/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import com.parse.ACRAResponse;
import com.parse.HttpConnectionProvider;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.zip.GZIPOutputStream;

class HttpRequest {
    private HttpConnectionProvider mConnectionProvider;
    public static final String POST_CONTENT_TYPE_FORM_URLENCODED = "application/x-www-form-urlencoded";
    public static final String POST_CONTENT_TYPE_JSON = "application/json";

    public HttpRequest(HttpConnectionProvider connectionProvider) {
        this.mConnectionProvider = connectionProvider;
    }

    public void sendPost(URL url, String data, ACRAResponse response) throws IOException {
        this.sendPost(url, data, response, POST_CONTENT_TYPE_FORM_URLENCODED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendPost(URL url, String data, ACRAResponse response, String contentType) throws IOException {
        HttpURLConnection urlConnection = null;
        urlConnection = this.mConnectionProvider.getConnection(url);
        urlConnection.setRequestMethod("POST");
        urlConnection.setRequestProperty("User-Agent", "Android");
        urlConnection.setRequestProperty("Content-Type", contentType);
        urlConnection.setRequestProperty("Content-Encoding", "gzip");
        urlConnection.setDoOutput(true);
        try {
            GZIPOutputStream gzipStream = new GZIPOutputStream(urlConnection.getOutputStream());
            gzipStream.write(data.getBytes());
            gzipStream.close();
            int responseCode = urlConnection.getResponseCode();
            response.setStatusCode(responseCode);
            urlConnection.getInputStream().close();
        }
        finally {
            urlConnection.disconnect();
        }
    }
}

