/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import android.net.Uri;
import android.util.Log;
import com.parse.ACRA;
import com.parse.CrashReportData;
import com.parse.HttpUtils;
import com.parse.ReportField;
import com.parse.ReportSender;
import com.parse.ReportSenderException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

class HttpPostSender
implements ReportSender {
    private Uri mFormUri = null;

    public HttpPostSender(String formUri) {
        this.mFormUri = Uri.parse((String)formUri);
    }

    @Override
    public void send(CrashReportData report) throws ReportSenderException {
        try {
            Map<String, String> finalReport = this.remap(report);
            URL reportUrl = new URL(this.mFormUri.toString());
            Log.d((String)"CrashReporting", (String)("Connect to " + reportUrl.toString()));
            HttpUtils.doPost(finalReport, reportUrl, ACRA.getConfig().formPostFormat());
        }
        catch (Exception e) {
            throw new ReportSenderException("Error while sending report to Http Post Form.", e);
        }
    }

    private Map<String, String> remap(Map<ReportField, String> report) {
        HashMap<String, String> finalReport = new HashMap<String, String>(report.size());
        for (ReportField field : ACRA.ALL_CRASH_REPORT_FIELDS) {
            finalReport.put(field.toString(), report.get((Object)field));
        }
        return finalReport;
    }
}

