/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import android.content.Context;
import android.content.pm.PackageManager;
import android.util.Log;
import com.parse.Compatibility;
import java.lang.reflect.Method;

class DeviceFeaturesCollector {
    DeviceFeaturesCollector() {
    }

    public static String getFeatures(Context ctx) {
        if (Compatibility.getAPILevel() >= 5) {
            StringBuffer result = new StringBuffer();
            try {
                PackageManager pm = ctx.getPackageManager();
                Method getSystemAvailableFeatures = PackageManager.class.getMethod("getSystemAvailableFeatures", null);
                Object[] features = (Object[])getSystemAvailableFeatures.invoke((Object)pm, new Object[0]);
                if (features != null) {
                    for (Object feature : features) {
                        String featureName = (String)feature.getClass().getField("name").get(feature);
                        if (featureName != null) {
                            result.append(featureName);
                        } else {
                            Method getGlEsVersion = feature.getClass().getMethod("getGlEsVersion", null);
                            String glEsVersion = (String)getGlEsVersion.invoke(feature, new Object[0]);
                            result.append("glEsVersion = ");
                            result.append(glEsVersion);
                        }
                        result.append("\n");
                    }
                }
            }
            catch (Throwable e) {
                Log.w((String)"CrashReporting", (String)("Couldn't retrieve device features for " + ctx.getPackageName()), (Throwable)e);
                result.append("Could not retrieve data: ");
                result.append(e.getMessage());
            }
            return result.toString();
        }
        return "Data available only with API Level > 5";
    }
}

