/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import android.content.res.Configuration;
import android.util.Log;
import android.util.SparseArray;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;

class ConfigurationInspector {
    private static final String SUFFIX_MASK = "_MASK";
    private static final String FIELD_SCREENLAYOUT = "screenLayout";
    private static final String FIELD_UIMODE = "uiMode";
    private static final String FIELD_MNC = "mnc";
    private static final String FIELD_MCC = "mcc";
    private static final String PREFIX_UI_MODE = "UI_MODE_";
    private static final String PREFIX_TOUCHSCREEN = "TOUCHSCREEN_";
    private static final String PREFIX_SCREENLAYOUT = "SCREENLAYOUT_";
    private static final String PREFIX_ORIENTATION = "ORIENTATION_";
    private static final String PREFIX_NAVIGATIONHIDDEN = "NAVIGATIONHIDDEN_";
    private static final String PREFIX_NAVIGATION = "NAVIGATION_";
    private static final String PREFIX_KEYBOARDHIDDEN = "KEYBOARDHIDDEN_";
    private static final String PREFIX_KEYBOARD = "KEYBOARD_";
    private static final String PREFIX_HARDKEYBOARDHIDDEN = "HARDKEYBOARDHIDDEN_";
    private static SparseArray<String> mHardKeyboardHiddenValues = new SparseArray();
    private static SparseArray<String> mKeyboardValues = new SparseArray();
    private static SparseArray<String> mKeyboardHiddenValues = new SparseArray();
    private static SparseArray<String> mNavigationValues = new SparseArray();
    private static SparseArray<String> mNavigationHiddenValues = new SparseArray();
    private static SparseArray<String> mOrientationValues = new SparseArray();
    private static SparseArray<String> mScreenLayoutValues = new SparseArray();
    private static SparseArray<String> mTouchScreenValues = new SparseArray();
    private static SparseArray<String> mUiModeValues = new SparseArray();
    private static final HashMap<String, SparseArray<String>> mValueArrays = new HashMap();

    ConfigurationInspector() {
    }

    public static String toString(Configuration conf) {
        StringBuilder result = new StringBuilder();
        for (Field f : conf.getClass().getFields()) {
            try {
                if (Modifier.isStatic(f.getModifiers())) continue;
                String fieldName = f.getName();
                result.append(fieldName).append('=');
                if (f.getType().equals(Integer.TYPE)) {
                    result.append(ConfigurationInspector.getFieldValueName(conf, f));
                } else {
                    Object val = f.get(conf);
                    if (val == null) {
                        result.append("null");
                    } else {
                        result.append(f.get(conf).toString());
                    }
                }
                result.append('\n');
            }
            catch (IllegalArgumentException e) {
                Log.e((String)"CrashReporting", (String)"Error while inspecting device configuration: ", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                Log.e((String)"CrashReporting", (String)"Error while inspecting device configuration: ", (Throwable)e);
            }
        }
        return result.toString();
    }

    private static String getFieldValueName(Configuration conf, Field f) throws IllegalArgumentException, IllegalAccessException {
        String fieldName = f.getName();
        if (fieldName.equals(FIELD_MCC) || fieldName.equals(FIELD_MNC)) {
            return Integer.toString(f.getInt(conf));
        }
        if (fieldName.equals(FIELD_UIMODE)) {
            return ConfigurationInspector.activeFlags(mValueArrays.get(PREFIX_UI_MODE), f.getInt(conf));
        }
        if (fieldName.equals(FIELD_SCREENLAYOUT)) {
            return ConfigurationInspector.activeFlags(mValueArrays.get(PREFIX_SCREENLAYOUT), f.getInt(conf));
        }
        SparseArray<String> values = mValueArrays.get(fieldName.toUpperCase() + '_');
        if (values == null) {
            return Integer.toString(f.getInt(conf));
        }
        String value = (String)values.get(f.getInt(conf));
        if (value == null) {
            return Integer.toString(f.getInt(conf));
        }
        return value;
    }

    private static String activeFlags(SparseArray<String> valueNames, int bitfield) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < valueNames.size(); ++i) {
            int value;
            int maskValue = valueNames.keyAt(i);
            if (!((String)valueNames.get(maskValue)).endsWith(SUFFIX_MASK) || (value = bitfield & maskValue) <= 0) continue;
            if (result.length() > 0) {
                result.append('+');
            }
            result.append((String)valueNames.get(value));
        }
        return result.toString();
    }

    static {
        mValueArrays.put(PREFIX_HARDKEYBOARDHIDDEN, mHardKeyboardHiddenValues);
        mValueArrays.put(PREFIX_KEYBOARD, mKeyboardValues);
        mValueArrays.put(PREFIX_KEYBOARDHIDDEN, mKeyboardHiddenValues);
        mValueArrays.put(PREFIX_NAVIGATION, mNavigationValues);
        mValueArrays.put(PREFIX_NAVIGATIONHIDDEN, mNavigationHiddenValues);
        mValueArrays.put(PREFIX_ORIENTATION, mOrientationValues);
        mValueArrays.put(PREFIX_SCREENLAYOUT, mScreenLayoutValues);
        mValueArrays.put(PREFIX_TOUCHSCREEN, mTouchScreenValues);
        mValueArrays.put(PREFIX_UI_MODE, mUiModeValues);
        for (Field f : Configuration.class.getFields()) {
            if (!Modifier.isStatic(f.getModifiers()) || !Modifier.isFinal(f.getModifiers())) continue;
            String fieldName = f.getName();
            try {
                if (fieldName.startsWith(PREFIX_HARDKEYBOARDHIDDEN)) {
                    mHardKeyboardHiddenValues.put(f.getInt(null), (Object)fieldName);
                    continue;
                }
                if (fieldName.startsWith(PREFIX_KEYBOARD)) {
                    mKeyboardValues.put(f.getInt(null), (Object)fieldName);
                    continue;
                }
                if (fieldName.startsWith(PREFIX_KEYBOARDHIDDEN)) {
                    mKeyboardHiddenValues.put(f.getInt(null), (Object)fieldName);
                    continue;
                }
                if (fieldName.startsWith(PREFIX_NAVIGATION)) {
                    mNavigationValues.put(f.getInt(null), (Object)fieldName);
                    continue;
                }
                if (fieldName.startsWith(PREFIX_NAVIGATIONHIDDEN)) {
                    mNavigationHiddenValues.put(f.getInt(null), (Object)fieldName);
                    continue;
                }
                if (fieldName.startsWith(PREFIX_ORIENTATION)) {
                    mOrientationValues.put(f.getInt(null), (Object)fieldName);
                    continue;
                }
                if (fieldName.startsWith(PREFIX_SCREENLAYOUT)) {
                    mScreenLayoutValues.put(f.getInt(null), (Object)fieldName);
                    continue;
                }
                if (fieldName.startsWith(PREFIX_TOUCHSCREEN)) {
                    mTouchScreenValues.put(f.getInt(null), (Object)fieldName);
                    continue;
                }
                if (!fieldName.startsWith(PREFIX_UI_MODE)) continue;
                mUiModeValues.put(f.getInt(null), (Object)fieldName);
            }
            catch (IllegalArgumentException e) {
                Log.w((String)"CrashReporting", (String)"Error while inspecting device configuration: ", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                Log.w((String)"CrashReporting", (String)"Error while inspecting device configuration: ", (Throwable)e);
            }
        }
    }
}

