/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.support.v4.app.Fragment;
import bolts.Task;
import com.facebook.AccessToken;
import com.parse.FacebookAuthenticationProvider;
import com.parse.LogInCallback;
import com.parse.ParseAuthenticationProvider;
import com.parse.ParseCallback1;
import com.parse.ParseCallback2;
import com.parse.ParseException;
import com.parse.ParseTaskUtils;
import com.parse.ParseUser;
import com.parse.SaveCallback;
import java.util.Collection;
import java.util.Collections;
import org.json.JSONException;

public final class ParseFacebookUtils {
    static FacebookAuthenticationProvider provider;
    static boolean isInitialized;

    public static boolean isLinked(ParseUser user) {
        return user.isLinked("facebook");
    }

    public static void initialize(Context context) {
        ParseFacebookUtils.initialize(context, 64206);
    }

    public static void initialize(Context context, int callbackRequestCodeOffset) {
        provider = new FacebookAuthenticationProvider(context, callbackRequestCodeOffset);
        ParseUser.registerAuthenticationProvider((ParseAuthenticationProvider)provider);
        isInitialized = true;
    }

    private static void checkInitialization() {
        if (!isInitialized) {
            throw new IllegalStateException("You must call ParseFacebookUtils.initialize() before using ParseFacebookUtils");
        }
    }

    public static boolean onActivityResult(int requestCode, int resultCode, Intent data) {
        if (provider != null) {
            return provider.onActivityResult(requestCode, resultCode, data);
        }
        return false;
    }

    public static Task<ParseUser> logInInBackground(AccessToken accessToken) {
        ParseFacebookUtils.checkInitialization();
        try {
            return provider.logInAsync(provider.getAuthData(accessToken));
        }
        catch (JSONException e) {
            return Task.forError((Exception)new ParseException((Throwable)e));
        }
    }

    public static Task<ParseUser> logInInBackground(AccessToken accessToken, LogInCallback callback) {
        return ParseTaskUtils.callbackOnMainThreadAsync(ParseFacebookUtils.logInInBackground(accessToken), (ParseCallback2)callback, (boolean)true);
    }

    public static Task<ParseUser> logInWithReadPermissionsInBackground(Activity activity, Collection<String> permissions) {
        return ParseFacebookUtils.logInAsync(activity, null, permissions, FacebookAuthenticationProvider.LoginAuthorizationType.READ);
    }

    public static Task<ParseUser> logInWithReadPermissionsInBackground(Activity activity, Collection<String> permissions, LogInCallback callback) {
        return ParseTaskUtils.callbackOnMainThreadAsync(ParseFacebookUtils.logInWithReadPermissionsInBackground(activity, permissions), (ParseCallback2)callback, (boolean)true);
    }

    public static Task<ParseUser> logInWithPublishPermissionsInBackground(Activity activity, Collection<String> permissions) {
        return ParseFacebookUtils.logInAsync(activity, null, permissions, FacebookAuthenticationProvider.LoginAuthorizationType.PUBLISH);
    }

    public static Task<ParseUser> logInWithPublishPermissionsInBackground(Activity activity, Collection<String> permissions, LogInCallback callback) {
        return ParseTaskUtils.callbackOnMainThreadAsync(ParseFacebookUtils.logInWithPublishPermissionsInBackground(activity, permissions), (ParseCallback2)callback, (boolean)true);
    }

    public static Task<ParseUser> logInWithReadPermissionsInBackground(Fragment fragment, Collection<String> permissions) {
        return ParseFacebookUtils.logInAsync(null, fragment, permissions, FacebookAuthenticationProvider.LoginAuthorizationType.READ);
    }

    public static Task<ParseUser> logInWithReadPermissionsInBackground(Fragment fragment, Collection<String> permissions, LogInCallback callback) {
        return ParseTaskUtils.callbackOnMainThreadAsync(ParseFacebookUtils.logInWithReadPermissionsInBackground(fragment, permissions), (ParseCallback2)callback, (boolean)true);
    }

    public static Task<ParseUser> logInWithPublishPermissionsInBackground(Fragment fragment, Collection<String> permissions) {
        return ParseFacebookUtils.logInAsync(null, fragment, permissions, FacebookAuthenticationProvider.LoginAuthorizationType.PUBLISH);
    }

    public static Task<ParseUser> logInWithPublishPermissionsInBackground(Fragment fragment, Collection<String> permissions, LogInCallback callback) {
        return ParseTaskUtils.callbackOnMainThreadAsync(ParseFacebookUtils.logInWithPublishPermissionsInBackground(fragment, permissions), (ParseCallback2)callback, (boolean)true);
    }

    private static Task<ParseUser> logInAsync(Activity activity, Fragment fragment, Collection<String> permissions, FacebookAuthenticationProvider.LoginAuthorizationType authorizationType) {
        ParseFacebookUtils.checkInitialization();
        if (permissions == null) {
            permissions = Collections.emptyList();
        }
        if (activity != null) {
            provider.setActivity(activity);
        } else if (fragment != null) {
            provider.setFragment(fragment);
        }
        return provider.setPermissions(permissions).setLoginAuthorizationType(authorizationType).logInAsync();
    }

    public static Task<Void> linkInBackground(ParseUser user, AccessToken accessToken) {
        ParseFacebookUtils.checkInitialization();
        try {
            return provider.linkAsync(user, provider.getAuthData(accessToken));
        }
        catch (JSONException e) {
            return Task.forError((Exception)new ParseException((Throwable)e));
        }
    }

    public static Task<Void> linkInBackground(ParseUser user, AccessToken accessToken, SaveCallback callback) {
        return ParseTaskUtils.callbackOnMainThreadAsync(ParseFacebookUtils.linkInBackground(user, accessToken), (ParseCallback1)callback, (boolean)true);
    }

    public static Task<Void> linkWithReadPermissionsInBackground(ParseUser user, Activity activity, Collection<String> permissions) {
        return ParseFacebookUtils.linkAsync(user, activity, null, permissions, FacebookAuthenticationProvider.LoginAuthorizationType.READ);
    }

    public static Task<Void> linkWithReadPermissionsInBackground(ParseUser user, Activity activity, Collection<String> permissions, SaveCallback callback) {
        return ParseTaskUtils.callbackOnMainThreadAsync(ParseFacebookUtils.linkWithReadPermissionsInBackground(user, activity, permissions), (ParseCallback1)callback, (boolean)true);
    }

    public static Task<Void> linkWithPublishPermissionsInBackground(ParseUser user, Activity activity, Collection<String> permissions) {
        return ParseFacebookUtils.linkAsync(user, activity, null, permissions, FacebookAuthenticationProvider.LoginAuthorizationType.PUBLISH);
    }

    public static Task<Void> linkWithPublishPermissionsInBackground(ParseUser user, Activity activity, Collection<String> permissions, SaveCallback callback) {
        return ParseTaskUtils.callbackOnMainThreadAsync(ParseFacebookUtils.linkWithPublishPermissionsInBackground(user, activity, permissions), (ParseCallback1)callback, (boolean)true);
    }

    public static Task<Void> linkWithReadPermissionsInBackground(ParseUser user, Fragment fragment, Collection<String> permissions) {
        return ParseFacebookUtils.linkAsync(user, null, fragment, permissions, FacebookAuthenticationProvider.LoginAuthorizationType.READ);
    }

    public static Task<Void> linkWithReadPermissionsInBackground(ParseUser user, Fragment fragment, Collection<String> permissions, SaveCallback callback) {
        return ParseTaskUtils.callbackOnMainThreadAsync(ParseFacebookUtils.linkWithReadPermissionsInBackground(user, fragment, permissions), (ParseCallback1)callback, (boolean)true);
    }

    public static Task<Void> linkWithPublishPermissionsInBackground(ParseUser user, Fragment fragment, Collection<String> permissions) {
        return ParseFacebookUtils.linkAsync(user, null, fragment, permissions, FacebookAuthenticationProvider.LoginAuthorizationType.PUBLISH);
    }

    public static Task<Void> linkWithPublishPermissionsInBackground(ParseUser user, Fragment fragment, Collection<String> permissions, SaveCallback callback) {
        return ParseTaskUtils.callbackOnMainThreadAsync(ParseFacebookUtils.linkWithPublishPermissionsInBackground(user, fragment, permissions), (ParseCallback1)callback, (boolean)true);
    }

    private static Task<Void> linkAsync(ParseUser user, Activity activity, Fragment fragment, Collection<String> permissions, FacebookAuthenticationProvider.LoginAuthorizationType authorizationType) {
        ParseFacebookUtils.checkInitialization();
        if (permissions == null) {
            permissions = Collections.emptyList();
        }
        if (activity != null) {
            provider.setActivity(activity);
        } else if (fragment != null) {
            provider.setFragment(fragment);
        }
        return provider.setPermissions(permissions).setLoginAuthorizationType(authorizationType).linkAsync(user);
    }

    public static Task<Void> unlinkInBackground(ParseUser user) {
        ParseFacebookUtils.checkInitialization();
        return provider.unlinkAsync(user);
    }

    public static Task<Void> unlinkInBackground(ParseUser user, SaveCallback callback) {
        return ParseTaskUtils.callbackOnMainThreadAsync(ParseFacebookUtils.unlinkInBackground(user), (ParseCallback1)callback);
    }

    private ParseFacebookUtils() {
    }
}

