/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import com.parse.BackgroundTask;
import com.parse.LogInCallback;
import com.parse.Parse;
import com.parse.ParseAnonymousUtils;
import com.parse.ParseCallback;
import com.parse.ParseCommand;
import com.parse.ParseException;
import com.parse.ParseObject;
import com.parse.ParseQuery;
import com.parse.RequestPasswordResetCallback;
import com.parse.SaveCallback;
import com.parse.SignUpCallback;
import com.parse.auth.ParseAuthenticationProvider;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParseUser
extends ParseObject {
    static final String CLASS_NAME = "_User";
    private String password;
    private String sessionToken;
    private final JSONObject authData = new JSONObject();
    private final Set<String> linkedServiceNames = new HashSet<String>();
    private final Set<String> readOnlyLinkedServiceNames = Collections.unmodifiableSet(this.linkedServiceNames);
    private boolean isNew;
    private boolean isLazy = false;
    private static ParseUser currentUser;
    private static Map<String, ParseAuthenticationProvider> authenticationProviders;
    private static boolean autoUserEnabled;
    private static boolean currentUserMatchesDisk;
    private static final String CURRENT_USER_FILENAME = "currentUser";
    private boolean isCurrentUser = false;

    static {
        authenticationProviders = new HashMap<String, ParseAuthenticationProvider>();
        currentUserMatchesDisk = false;
    }

    ParseUser(boolean isPointer) {
        super(CLASS_NAME, isPointer);
    }

    public ParseUser() {
        this(false);
    }

    static ParseUser logInLazyUser(String authType, JSONObject authData) {
        ParseUser user = new ParseUser();
        user.isCurrentUser = true;
        user.isLazy = true;
        try {
            user.authData.put(authType, (Object)authData);
            user.linkedServiceNames.add(authType);
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
        currentUser = user;
        currentUserMatchesDisk = false;
        return user;
    }

    boolean isLazy() {
        return this.isLazy;
    }

    public boolean isAuthenticated() {
        return this.isLazy() || this.sessionToken != null && ParseUser.getCurrentUser() != null && this.getObjectId().equals(ParseUser.getCurrentUser().getObjectId());
    }

    @Override
    public void remove(String key) {
        if (key == "username") {
            throw new IllegalArgumentException("Can't remove the username key.");
        }
        super.remove(key);
    }

    @Override
    protected JSONObject toJSONObjectForSaving() {
        JSONObject objectJSON = super.toJSONObjectForSaving();
        if (this.sessionToken != null) {
            try {
                objectJSON.put("session_token", (Object)this.sessionToken);
            }
            catch (JSONException e) {
                throw new RuntimeException("could not encode value for key: sessionToken");
            }
        }
        if (this.authData.length() > 0) {
            try {
                objectJSON.put("auth_data", (Object)this.authData);
            }
            catch (JSONException e) {
                throw new RuntimeException("could not attach key: auth_data");
            }
        }
        return objectJSON;
    }

    @Override
    JSONObject toJSONObjectForDataFile() {
        JSONObject objectJSON = super.toJSONObjectForDataFile();
        if (this.sessionToken != null) {
            try {
                objectJSON.put("session_token", (Object)this.sessionToken);
            }
            catch (JSONException e) {
                throw new RuntimeException("could not encode value for key: sessionToken");
            }
        }
        if (this.authData.length() > 0) {
            try {
                objectJSON.put("auth_data", (Object)this.authData);
            }
            catch (JSONException e) {
                throw new RuntimeException("could not attach key: auth_data");
            }
        }
        return objectJSON;
    }

    @Override
    protected void mergeFromObject(ParseObject other) {
        super.mergeFromObject(other);
        if (other instanceof ParseUser) {
            this.sessionToken = ((ParseUser)other).sessionToken;
            this.isNew = ((ParseUser)other).isNew();
            Iterator key = this.authData.keys();
            while (key.hasNext()) {
                key.next();
                key.remove();
            }
            key = ((ParseUser)other).authData.keys();
            while (key.hasNext()) {
                String k = (String)key.next();
                try {
                    Object v = ((ParseUser)other).authData.get(k);
                    this.authData.put(k, v);
                }
                catch (JSONException e) {
                    throw new RuntimeException("A JSONException occurred where one was not possible.");
                }
            }
            this.linkedServiceNames.clear();
            this.linkedServiceNames.addAll(((ParseUser)other).linkedServiceNames);
        }
    }

    @Override
    protected void mergeFromServer(JSONObject object) {
        super.mergeFromServer(object);
        if (object.has("session_token")) {
            try {
                this.sessionToken = object.getString("session_token");
            }
            catch (JSONException e) {
                throw new RuntimeException(e.getMessage());
            }
        }
        if (object.has("auth_data")) {
            try {
                JSONObject newData = object.getJSONObject("auth_data");
                Iterator i = newData.keys();
                while (i.hasNext()) {
                    String key = (String)i.next();
                    this.authData.put(key, newData.get(key));
                    if (!newData.isNull(key)) {
                        this.linkedServiceNames.add(key);
                    }
                    this.synchronizeAuthData(key);
                }
            }
            catch (JSONException e) {
                throw new RuntimeException(e);
            }
        }
        if (object.has("is_new")) {
            try {
                this.isNew = object.getBoolean("is_new");
            }
            catch (JSONException e) {
                throw new RuntimeException(e);
            }
        }
    }

    boolean isCurrentUser() {
        return this.isCurrentUser;
    }

    void cleanUpAuthData() {
        if (!this.isCurrentUser()) {
            return;
        }
        Iterator i = this.authData.keys();
        while (i.hasNext()) {
            String key = (String)i.next();
            if (!this.authData.isNull(key)) continue;
            i.remove();
            this.linkedServiceNames.remove(key);
            if (!authenticationProviders.containsKey(key)) continue;
            authenticationProviders.get(key).restoreAuthentication(null);
        }
    }

    public void setUsername(String username) {
        this.checkIfRunning();
        this.put("username", username);
    }

    public String getUsername() {
        return this.getString("username");
    }

    public void setPassword(String password) {
        this.checkIfRunning();
        this.password = password;
        this.dirty = true;
    }

    public void setEmail(String email) {
        this.checkIfRunning();
        this.put("email", email);
    }

    public String getEmail() {
        return this.getString("email");
    }

    @Override
    public void put(String key, Object value) {
        if (key.equals("username")) {
            this.stripAnonymity();
        }
        super.put(key, value);
    }

    private void stripAnonymity() {
        if (ParseAnonymousUtils.isLinked(this)) {
            this.linkedServiceNames.remove("anonymous");
            try {
                this.authData.put("anonymous", JSONObject.NULL);
            }
            catch (JSONException e) {
                throw new RuntimeException(e);
            }
            this.dirty = true;
        }
    }

    private void restoreAnonymity(JSONObject anonymousData) {
        if (anonymousData != null) {
            this.linkedServiceNames.add("anonymous");
            try {
                this.authData.put("anonymous", (Object)anonymousData);
            }
            catch (JSONException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public String getSessionToken() {
        return this.sessionToken;
    }

    @Override
    protected void validateSave() {
        if (this.getObjectId() == null) {
            throw new IllegalArgumentException("Cannot save a ParseUser until it has been signed up. Call signUp first.");
        }
        if (!this.isAuthenticated() && this.isDirty() && !this.getObjectId().equals(ParseUser.getCurrentUser().getObjectId())) {
            throw new IllegalArgumentException("Cannot save a ParseUser that is not authenticated.");
        }
    }

    @Override
    public void save(boolean needsLock) throws ParseException {
        if (this.isLazy()) {
            this.resolveLaziness(needsLock);
            return;
        }
        super.save(needsLock);
        this.cleanUpAuthData();
        if (this.isCurrentUser()) {
            ParseUser.saveCurrentUser(this);
        }
    }

    @Override
    protected void validateDelete() {
        super.validateDelete();
        if (!this.isAuthenticated() && this.isDirty()) {
            throw new IllegalArgumentException("Cannot delete a ParseUser that is not authenticated.");
        }
    }

    @Override
    public ParseUser fetch() throws ParseException {
        if (this.isLazy()) {
            return this;
        }
        super.fetch();
        this.cleanUpAuthData();
        if (this.isCurrentUser()) {
            ParseUser.saveCurrentUser(this);
        }
        return this;
    }

    @Override
    protected ParseCommand constructSaveCommand() throws ParseException {
        ParseCommand command = super.constructSaveCommand();
        if (command == null) {
            return null;
        }
        if (this.password != null) {
            command.put("user_password", this.password);
        }
        if (this.authData.length() > 0) {
            command.put("auth_data", this.authData);
        }
        return command;
    }

    private ParseCommand constructSignUpCommand() throws ParseException {
        ParseCommand command = this.constructSaveCommand();
        command.setOp("user_signup");
        return command;
    }

    private ParseCommand constructSignUpOrLoginCommand() throws ParseException {
        ParseCommand command = new ParseCommand("user_signup_or_login");
        JSONObject params = this.toJSONObjectForSaving();
        Iterator keys = params.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            try {
                Object value = params.get(key);
                if (value instanceof JSONObject) {
                    command.put(key, (JSONObject)value);
                    continue;
                }
                if (value instanceof JSONArray) {
                    command.put(key, (JSONArray)value);
                    continue;
                }
                if (value instanceof String) {
                    command.put(key, (String)value);
                    continue;
                }
                command.put(key, params.getInt(key));
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        if (this.password != null) {
            command.put("user_password", this.password);
        }
        return command;
    }

    private static ParseCommand constructPasswordResetCommand(String email) {
        ParseCommand command = new ParseCommand("user_request_password_reset");
        command.put("email", email);
        return command;
    }

    public void signUp() throws ParseException {
        this.signUp(true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void signUp(boolean needsLock) throws ParseException {
        if (needsLock) {
            this.checkIfRunning(true);
        }
        try {
            if (this.getUsername() == null) throw new IllegalArgumentException("Username cannot be missing or blank");
            if (this.getUsername().length() == 0) {
                throw new IllegalArgumentException("Username cannot be missing or blank");
            }
            if (this.password == null) {
                throw new IllegalArgumentException("Password cannot be missing or blank");
            }
            if (this.getObjectId() != null) {
                try {
                    if (!this.authData.has("anonymous")) throw new IllegalArgumentException("Cannot sign up a user that has already signed up.");
                    if (this.authData.get("anonymous") != JSONObject.NULL) throw new IllegalArgumentException("Cannot sign up a user that has already signed up.");
                    this.save(false);
                    return;
                }
                catch (JSONException e) {
                    throw new ParseException(e);
                }
            }
            if (this.operationSetQueue.size() > 1) {
                throw new IllegalArgumentException("Cannot sign up a user that is already signing up.");
            }
            if (ParseUser.getCurrentUser() != null && ParseAnonymousUtils.isLinked(ParseUser.getCurrentUser())) {
                if (this.isCurrentUser()) {
                    throw new IllegalArgumentException("Attempt to merge currentUser with itself.");
                }
                this.checkForChangesToMutableContainers();
                ParseUser.getCurrentUser().checkForChangesToMutableContainers();
                ParseUser.getCurrentUser().copyChangesFrom(this);
                ParseUser.getCurrentUser().dirty = true;
                ParseUser.getCurrentUser().setPassword(this.password);
                ParseUser.getCurrentUser().setUsername(this.getUsername());
                this.clearChanges();
                ParseUser.getCurrentUser().save();
                this.mergeFromObject(ParseUser.getCurrentUser());
                ParseUser.saveCurrentUser(this);
                return;
            }
            ParseCommand command = this.constructSignUpCommand();
            if (command == null) {
                return;
            }
            command.setInternalCallback(new ParseCommand.InternalCallback(){

                public void perform(ParseCommand command, Object result) {
                    ParseUser.this.handleSaveResult(command.op, (JSONObject)result);
                }
            });
            this.startSave();
            command.perform();
            ParseUser.saveCurrentUser(this);
            this.isNew = true;
            return;
        }
        finally {
            this.finishedRunning();
        }
    }

    public void signUpInBackground(SignUpCallback callback) {
        this.checkIfRunning(true);
        BackgroundTask<Void> signUpTask = new BackgroundTask<Void>((ParseCallback)callback){

            @Override
            public Void run() throws ParseException {
                ParseUser.this.signUp(false);
                return null;
            }
        };
        BackgroundTask.executeTask(signUpTask);
    }

    private static ParseCommand constructLogInCommand(String username, String password) throws ParseException {
        ParseCommand command = new ParseCommand("user_login");
        command.put("username", username);
        command.put("user_password", password);
        return command;
    }

    public static ParseUser logIn(String username, String password) throws ParseException {
        if (username == null) {
            throw new IllegalArgumentException("Must specify a username for the user to log in with");
        }
        if (password == null) {
            throw new IllegalArgumentException("Must specify a password for the user to log in with");
        }
        ParseCommand command = ParseUser.constructLogInCommand(username, password);
        Object result = command.perform();
        if (result == JSONObject.NULL) {
            throw new ParseException(101, "invalid login credentials");
        }
        ParseUser user = new ParseUser();
        user.handleFetchResult((JSONObject)result);
        ParseUser.saveCurrentUser(user);
        return user;
    }

    public static void logInInBackground(final String username, final String password, LogInCallback callback) {
        BackgroundTask<ParseUser> logInTask = new BackgroundTask<ParseUser>((ParseCallback)callback){

            @Override
            public ParseUser run() throws ParseException {
                ParseUser user = ParseUser.logIn(username, password);
                return user;
            }
        };
        BackgroundTask.executeTask(logInTask);
    }

    public static ParseUser getCurrentUser() {
        ParseUser.checkApplicationContext();
        if (currentUser != null) {
            return currentUser;
        }
        if (currentUserMatchesDisk) {
            if (ParseUser.isAutomaticUserEnabled()) {
                ParseAnonymousUtils.lazyLogIn();
            }
            return currentUser;
        }
        currentUserMatchesDisk = true;
        ParseObject user = ParseUser.getFromDisk(Parse.applicationContext, CURRENT_USER_FILENAME);
        if (user == null) {
            if (ParseUser.isAutomaticUserEnabled()) {
                ParseAnonymousUtils.lazyLogIn();
            }
            return currentUser;
        }
        currentUser = (ParseUser)user;
        ParseUser.currentUser.isCurrentUser = true;
        return currentUser;
    }

    private static void saveCurrentUser(ParseUser user) {
        ParseUser.checkApplicationContext();
        if (currentUser != user) {
            ParseUser.logOut();
        }
        user.isCurrentUser = true;
        user.synchronizeAllAuthData();
        user.saveToDisk(Parse.applicationContext, CURRENT_USER_FILENAME);
        currentUserMatchesDisk = true;
        currentUser = user;
    }

    public static void logOut() {
        ParseUser.checkApplicationContext();
        if (currentUser != null) {
            for (String authType : currentUser.getLinkedServiceNames()) {
                currentUser.logOutWith(authType);
            }
            ParseUser.currentUser.isCurrentUser = false;
            ParseUser.currentUser.sessionToken = null;
        }
        currentUserMatchesDisk = true;
        currentUser = null;
        File file = new File(Parse.getParseDir(), CURRENT_USER_FILENAME);
        file.delete();
    }

    public static void requestPasswordReset(String email) throws ParseException {
        ParseCommand command = ParseUser.constructPasswordResetCommand(email);
        command.perform();
    }

    public static void requestPasswordResetInBackground(final String email, RequestPasswordResetCallback callback) {
        BackgroundTask<Void> task = new BackgroundTask<Void>((ParseCallback)callback){

            @Override
            public Void run() throws ParseException {
                ParseUser.requestPasswordReset(email);
                return null;
            }
        };
        BackgroundTask.executeTask(task);
    }

    private static void checkApplicationContext() {
        if (Parse.applicationContext == null) {
            throw new RuntimeException("You must call Parse.initialize(context, oauthKey, oauthSecret) before using the Parse library.");
        }
    }

    @Override
    public ParseUser fetchIfNeeded() throws ParseException {
        return (ParseUser)super.fetchIfNeeded();
    }

    Set<String> getLinkedServiceNames() {
        return this.readOnlyLinkedServiceNames;
    }

    private void synchronizeAuthData(String authType) {
        if (!this.isCurrentUser()) {
            return;
        }
        if (!authenticationProviders.containsKey(authType)) {
            return;
        }
        ParseAuthenticationProvider provider = authenticationProviders.get(authType);
        boolean success = provider.restoreAuthentication(this.authData.optJSONObject(provider.getAuthType()));
        if (!success) {
            this.unlinkFromInBackground(authType);
        }
    }

    private void synchronizeAllAuthData() {
        if (this.authData != null) {
            Iterator authTypes = this.authData.keys();
            while (authTypes.hasNext()) {
                this.synchronizeAuthData((String)authTypes.next());
            }
        }
    }

    void unlinkFromInBackground(String authType) {
        this.unlinkFromInBackground(authType, null);
    }

    void unlinkFromInBackground(final String authType, final SaveCallback callback) {
        if (authType != null && this.authData.has(authType)) {
            try {
                this.authData.put(authType, JSONObject.NULL);
                this.dirty = true;
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            this.saveInBackground(new SaveCallback(){

                public void done(ParseException e) {
                    if (e == null) {
                        ParseUser.this.authData.remove(authType);
                        ParseUser.this.linkedServiceNames.remove(authType);
                        if (authenticationProviders.containsKey(authType)) {
                            ((ParseAuthenticationProvider)authenticationProviders.get(authType)).restoreAuthentication(null);
                        }
                    }
                    if (callback != null) {
                        callback.internalDone(null, e);
                    }
                }
            });
        } else if (callback != null) {
            callback.internalDone(null, null);
        }
    }

    boolean unlinkFrom(String authType) throws ParseException {
        if (authType == null) {
            return false;
        }
        if (this.authData.has(authType)) {
            try {
                this.authData.put(authType, JSONObject.NULL);
                this.dirty = true;
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            this.save();
            return true;
        }
        return false;
    }

    static void registerAuthenticationProvider(ParseAuthenticationProvider provider) {
        authenticationProviders.put(provider.getAuthType(), provider);
        if (ParseUser.getCurrentUser() != null) {
            ParseUser.getCurrentUser().synchronizeAuthData(provider.getAuthType());
        }
    }

    static void logInWith(String authType, LogInCallback callback) {
        if (!authenticationProviders.containsKey(authType)) {
            throw new IllegalArgumentException("No authentication provider could be found for the provided authType");
        }
        ParseUser.logInWith(authenticationProviders.get(authType), callback);
    }

    static void logInWith(final String authType, final JSONObject authData, final LogInCallback callback) {
        final BackgroundTask<ParseUser> logInWithTask = new BackgroundTask<ParseUser>((ParseCallback)callback){

            @Override
            public ParseUser run() throws ParseException {
                final ParseUser user = new ParseUser();
                try {
                    user.authData.put(authType, (Object)authData);
                    user.linkedServiceNames.add(authType);
                }
                catch (JSONException e) {
                    throw new ParseException(e);
                }
                user.startSave();
                ParseCommand command = user.constructSignUpOrLoginCommand();
                command.setInternalCallback(new ParseCommand.InternalCallback(){

                    public void perform(ParseCommand command, Object result) {
                        user.handleSaveResult(command.op, (JSONObject)result);
                    }
                });
                command.perform();
                user.synchronizeAuthData(authType);
                ParseUser.saveCurrentUser(user);
                return user;
            }
        };
        if (ParseUser.getCurrentUser() != null && ParseAnonymousUtils.isLinked(ParseUser.getCurrentUser())) {
            if (ParseUser.getCurrentUser().isLazy()) {
                BackgroundTask<ParseUser> claimTask = new BackgroundTask<ParseUser>((ParseCallback)callback){

                    @Override
                    public ParseUser run() throws ParseException {
                        boolean finished = false;
                        ParseUser user = ParseUser.getCurrentUser();
                        JSONObject oldAnonymousData = user.authData.optJSONObject("anonymous");
                        ParseUser.getCurrentUser().stripAnonymity();
                        try {
                            user.authData.put(authType, (Object)authData);
                            user.linkedServiceNames.add(authType);
                            user.resolveLaziness(true);
                            finished = true;
                            ParseUser parseUser = ParseUser.getCurrentUser();
                            return parseUser;
                        }
                        catch (JSONException e) {
                            throw new ParseException(e);
                        }
                        finally {
                            if (!finished) {
                                user.authData.remove(authType);
                                user.linkedServiceNames.remove(authType);
                                user.restoreAnonymity(oldAnonymousData);
                            }
                        }
                    }
                };
                BackgroundTask.executeTask(claimTask);
            } else {
                ParseUser.getCurrentUser().linkWith(authType, authData, new SaveCallback(){

                    public void done(ParseException e) {
                        if (e != null) {
                            if (e.getCode() == 208) {
                                BackgroundTask.executeTask(logInWithTask);
                            } else if (callback != null) {
                                callback.internalDone(null, e);
                            }
                            return;
                        }
                        if (callback != null) {
                            callback.internalDone(ParseUser.getCurrentUser(), (ParseException)null);
                        }
                    }
                });
            }
            return;
        }
        BackgroundTask.executeTask(logInWithTask);
    }

    private void resolveLaziness(boolean needsLock) throws ParseException {
        if (!this.isLazy()) {
            return;
        }
        if (this.linkedServiceNames.size() == 0) {
            this.signUp(needsLock);
            this.isLazy = false;
            return;
        }
        if (needsLock) {
            this.checkIfRunning(true);
        }
        try {
            ParseCommand command = this.constructSignUpOrLoginCommand();
            command.setInternalCallback(new ParseCommand.InternalCallback(){

                public void perform(ParseCommand command, Object result) {
                    ParseUser.this.handleSaveResult("create", (JSONObject)result);
                }
            });
            this.startSave();
            JSONObject result = (JSONObject)command.perform();
            if (result.optBoolean("is_new")) {
                this.isLazy = false;
            } else {
                ParseUser newUser = new ParseUser();
                newUser.handleFetchResult(result);
                ParseUser.saveCurrentUser(newUser);
            }
        }
        finally {
            this.finishedRunning();
        }
    }

    private static void logInWith(final ParseAuthenticationProvider authenticator, final LogInCallback callback) {
        authenticator.authenticate(new ParseAuthenticationProvider.ParseAuthenticationCallback(){

            public void onSuccess(JSONObject authData) {
                ParseUser.logInWith(authenticator.getAuthType(), authData, callback);
            }

            public void onCancel() {
                callback.internalDone(null, null);
            }

            public void onError(Throwable error) {
                callback.internalDone(null, new ParseException(error));
            }
        });
    }

    void linkWith(final String authType, final JSONObject authData, SaveCallback callback) {
        BackgroundTask.executeTask(new BackgroundTask<Void>((ParseCallback)callback){

            @Override
            public Void run() throws ParseException {
                JSONObject oldAnonymousData;
                ParseUser user = ParseUser.this;
                try {
                    user.authData.put(authType, (Object)authData);
                    user.linkedServiceNames.add(authType);
                    oldAnonymousData = authData.optJSONObject("anonymous");
                    ParseUser.this.stripAnonymity();
                    user.dirty = true;
                }
                catch (JSONException e) {
                    throw new ParseException(e);
                }
                try {
                    user.save();
                    user.synchronizeAuthData(authType);
                }
                catch (ParseException e) {
                    ParseUser.this.restoreAnonymity(oldAnonymousData);
                    throw e;
                }
                catch (Exception e) {
                    ParseUser.this.restoreAnonymity(oldAnonymousData);
                    throw new ParseException(e);
                }
                return null;
            }
        });
    }

    void linkWith(String authType, SaveCallback callback) {
        if (!authenticationProviders.containsKey(authType)) {
            throw new IllegalArgumentException("No authentication provider could be found for the provided authType");
        }
        this.linkWith(authenticationProviders.get(authType), callback);
    }

    private void linkWith(final ParseAuthenticationProvider authenticator, final SaveCallback callback) {
        authenticator.authenticate(new ParseAuthenticationProvider.ParseAuthenticationCallback(){

            public void onSuccess(JSONObject authData) {
                ParseUser.this.linkWith(authenticator.getAuthType(), authData, callback);
            }

            public void onCancel() {
                callback.internalDone(null, null);
            }

            public void onError(Throwable error) {
                callback.internalDone(null, new ParseException(error));
            }
        });
    }

    void logOutWith(String authType) {
        if (authenticationProviders.containsKey(authType) && this.linkedServiceNames.contains(authType)) {
            this.logOutWith(authenticationProviders.get(authType));
        }
    }

    private void logOutWith(ParseAuthenticationProvider provider) {
        provider.deauthenticate();
    }

    public boolean isNew() {
        return this.isNew;
    }

    static void disableAutomaticUser() {
        autoUserEnabled = false;
    }

    public static void enableAutomaticUser() {
        autoUserEnabled = true;
    }

    static boolean isAutomaticUserEnabled() {
        return autoUserEnabled;
    }

    public static ParseQuery getQuery() {
        return new ParseQuery(CLASS_NAME);
    }

    static void clearCurrentUserFromMemory() {
        currentUser = null;
        currentUserMatchesDisk = false;
    }
}

