/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import com.parse.BackgroundTask;
import com.parse.Parse;
import com.parse.ParseCallback;
import com.parse.ParseException;
import com.parse.ProgressCallback;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;

class ParseRequestRetryer {
    private HttpClient client;
    private HttpUriRequest request;
    private long delay;
    private int maxAttempts;
    private int attemptsMade = 0;
    public static HttpClient testClient = null;

    public ParseRequestRetryer(HttpUriRequest newRequest, long initialDelay, int newMaxAttempts) {
        if (testClient != null) {
            this.client = testClient;
            initialDelay = 1L;
        } else {
            this.client = new DefaultHttpClient();
            this.client.getParams().setParameter("http.protocol.version", (Object)HttpVersion.HTTP_1_1);
        }
        this.request = newRequest;
        this.maxAttempts = newMaxAttempts;
        this.delay = initialDelay + (long)((double)initialDelay * Math.random());
    }

    private byte[] sendOneRequest(ProgressCallback progressCallback) throws ParseException {
        HttpResponse response;
        try {
            response = this.client.execute(this.request);
            if (this.request.getMethod().equals("GET")) {
                int nRead;
                int totalSize = -1;
                Header[] contentLengthHeader = response.getHeaders("Content-Length");
                if (contentLengthHeader.length > 0) {
                    totalSize = Integer.parseInt(contentLengthHeader[0].getValue());
                }
                int downloadedSize = 0;
                InputStream responseStream = response.getEntity().getContent();
                ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                byte[] data = new byte[32768];
                while ((nRead = responseStream.read(data, 0, data.length)) != -1) {
                    buffer.write(data, 0, nRead);
                    downloadedSize += nRead;
                    if (progressCallback == null || totalSize == -1) continue;
                    final int progressToReport = Math.round((float)downloadedSize / (float)totalSize * 100.0f);
                    BackgroundTask<Integer> progressTask = new BackgroundTask<Integer>((ParseCallback)progressCallback){

                        @Override
                        public Integer run() throws ParseException {
                            return progressToReport;
                        }
                    };
                    BackgroundTask.executeTask(progressTask);
                }
                buffer.flush();
                return buffer.toByteArray();
            }
        }
        catch (ClientProtocolException e) {
            this.client.getConnectionManager().shutdown();
            throw this.connectionFailed("bad protocol", (Exception)((Object)e));
        }
        catch (IOException e) {
            this.client.getConnectionManager().shutdown();
            throw this.connectionFailed("i/o failure", e);
        }
        if (response.getStatusLine().getStatusCode() / 100 != 2) {
            throw new ParseException(100, String.format("Upload to S3 failed. %s", response.getStatusLine().getReasonPhrase()));
        }
        return null;
    }

    public byte[] go(ProgressCallback progressCallback) throws ParseException {
        byte[] response;
        block5: {
            response = null;
            try {
                response = this.sendOneRequest(progressCallback);
            }
            catch (ParseException e) {
                ++this.attemptsMade;
                if (this.attemptsMade < this.maxAttempts) {
                    Parse.logI("com.parse.ParseRequestRetryer", "Request failed. Waiting " + this.delay + " milliseconds before attempt #" + (this.attemptsMade + 1));
                    try {
                        Thread.sleep(this.delay);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.delay *= 2L;
                    this.go(progressCallback);
                }
                if (this.request.isAborted()) break block5;
                Parse.logI("com.parse.ParseRequestRetryer", "Request failed. Giving up.");
                throw e;
            }
        }
        return response;
    }

    ParseException connectionFailed(String message, Exception e) {
        return new ParseException(100, String.valueOf(message) + ": " + e.getClass().getName() + ": " + e.getMessage());
    }
}

