/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import com.parse.ParseObject;
import com.parse.ParseQuery;
import com.parse.ParseRelationOperation;
import java.util.Collections;
import org.json.JSONException;
import org.json.JSONObject;

public class ParseRelation {
    private ParseObject parent;
    private String key;
    private String targetClass;

    ParseRelation(ParseObject parent, String key) {
        this.parent = parent;
        this.key = key;
        this.targetClass = null;
    }

    ParseRelation(String targetClass) {
        this.parent = null;
        this.key = null;
        this.targetClass = targetClass;
    }

    void ensureParentAndKey(ParseObject someParent, String someKey) {
        if (this.parent == null) {
            this.parent = someParent;
        }
        if (this.key == null) {
            this.key = someKey;
        }
        if (this.parent != someParent) {
            throw new IllegalStateException("Internal error. One ParseRelation retrieved from two different ParseObjects.");
        }
        if (!this.key.equals(someKey)) {
            throw new IllegalStateException("Internal error. One ParseRelation retrieved from two different keys.");
        }
    }

    public void add(ParseObject object) {
        ParseRelationOperation operation = new ParseRelationOperation(Collections.singleton(object), null);
        this.targetClass = operation.getTargetClass();
        this.parent.performOperation(this.key, operation);
    }

    public void remove(ParseObject object) {
        ParseRelationOperation operation = new ParseRelationOperation(null, Collections.singleton(object));
        this.targetClass = operation.getTargetClass();
        this.parent.performOperation(this.key, operation);
    }

    public ParseQuery getQuery() {
        ParseQuery query;
        if (this.targetClass == null) {
            query = new ParseQuery(this.parent.getClassName());
            query.redirectClassNameForKey(this.key);
        } else {
            query = new ParseQuery(this.targetClass);
        }
        query.whereRelatedTo(this.parent, this.key);
        return query;
    }

    JSONObject encodeToJSON() throws JSONException {
        JSONObject relation = new JSONObject();
        relation.put("__type", (Object)"Relation");
        relation.put("className", (Object)this.targetClass);
        return relation;
    }

    String getTargetClass() {
        return this.targetClass;
    }

    void setTargetClass(String className) {
        this.targetClass = className;
    }
}

