/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import com.parse.BackgroundTask;
import com.parse.Parse;
import com.parse.ParseCallback;
import com.parse.ParseCommand;
import com.parse.ParseException;
import com.parse.ParseQuery;
import com.parse.SendCallback;
import com.parse.gdata.Preconditions;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParsePush {
    private static final String TAG = "com.parse.ParsePush";
    private Set<String> mChannelSet = null;
    private ParseQuery mQuery = null;
    private Long mExpirationTime = null;
    private Long mExpirationTimeInterval = null;
    private Boolean mPushToIOS = null;
    private Boolean mPushToAndroid = null;
    private JSONObject mData;

    public static void sendMessageInBackground(String message, ParseQuery query) {
        ParsePush.sendMessageInBackground(message, query, null);
    }

    public static void sendMessageInBackground(String message, ParseQuery query, SendCallback callback) {
        ParsePush push = new ParsePush();
        push.setQuery(query);
        push.setMessage(message);
        push.sendInBackground(callback);
    }

    public static void sendDataInBackground(JSONObject data, ParseQuery query) {
        ParsePush.sendDataInBackground(data, query, null);
    }

    public static void sendDataInBackground(JSONObject data, ParseQuery query, SendCallback callback) {
        ParsePush push = new ParsePush();
        push.setQuery(query);
        push.setData(data);
        push.sendInBackground(callback);
    }

    public void setChannel(String channel) {
        Preconditions.checkArgument(channel != null, "channel cannot be null");
        this.mChannelSet = new HashSet<String>();
        this.mChannelSet.add(channel);
        this.mQuery = null;
    }

    public void setChannels(Collection<String> channels) {
        Preconditions.checkArgument(channels != null, "channels collection cannot be null");
        for (String channel : channels) {
            Preconditions.checkArgument(channel != null, "channel cannot be null");
        }
        this.mChannelSet = new HashSet<String>();
        this.mChannelSet.addAll(channels);
        this.mQuery = null;
    }

    public void setQuery(ParseQuery query) {
        Preconditions.checkArgument(query != null, "Cannot target a null query");
        Preconditions.checkArgument(this.mPushToIOS == null && this.mPushToAndroid == null, "Cannot set push targets (i.e. setPushToAndroid or setPushToIOS) when pushing to a query");
        Preconditions.checkArgument(query.getClassName().equals("_Installation"), "Can only push to a query for Installations");
        this.mChannelSet = null;
        this.mQuery = query;
    }

    public void setExpirationTime(long time) {
        this.mExpirationTime = time;
        this.mExpirationTimeInterval = null;
    }

    public void setExpirationTimeInterval(long timeInterval) {
        this.mExpirationTime = null;
        this.mExpirationTimeInterval = timeInterval;
    }

    public void clearExpiration() {
        this.mExpirationTime = null;
        this.mExpirationTimeInterval = null;
    }

    public void setPushToIOS(boolean pushToIOS) {
        Preconditions.checkArgument(this.mQuery == null, "Cannot set push targets (i.e. setPushToAndroid or setPushToIOS) when pushing to a query");
        this.mPushToIOS = pushToIOS;
    }

    public void setPushToAndroid(boolean pushToAndroid) {
        Preconditions.checkArgument(this.mQuery == null, "Cannot set push targets (i.e. setPushToAndroid or setPushToIOS) when pushing to a query");
        this.mPushToAndroid = pushToAndroid;
    }

    public void setData(JSONObject data) {
        this.mData = data;
    }

    public void setMessage(String message) {
        JSONObject data = new JSONObject();
        try {
            data.put("alert", (Object)message);
        }
        catch (JSONException e) {
            Parse.logE(TAG, "JSONException in setMessage", e);
        }
        this.setData(data);
    }

    public void send() throws ParseException {
        this.buildCommand().perform();
    }

    public void sendInBackground(SendCallback callback) {
        BackgroundTask<Void> sendTask = new BackgroundTask<Void>((ParseCallback)callback){

            @Override
            public Void run() throws ParseException {
                ParsePush.this.send();
                return null;
            }
        };
        BackgroundTask.executeTask(sendTask);
    }

    public void sendInBackground() {
        this.sendInBackground(null);
    }

    ParseCommand buildCommand() {
        ParseCommand command = new ParseCommand("client_push");
        if (this.mData == null) {
            throw new IllegalArgumentException("Cannot send a push without calling either setMessage or setData");
        }
        command.put("data", this.mData);
        if (this.mQuery != null) {
            command.put("where", this.mQuery.getFindParams().optJSONObject("data"));
        } else if (this.mChannelSet == null) {
            command.put("channel", "");
        } else {
            command.put("channels", new JSONArray(this.mChannelSet));
        }
        if (this.mExpirationTime != null) {
            command.put("expiration_time", this.mExpirationTime);
        } else if (this.mExpirationTimeInterval != null) {
            command.put("expiration_time_interval", this.mExpirationTimeInterval);
        }
        if (this.mQuery == null) {
            boolean pushToIOS;
            boolean pushToAndroid = this.mPushToAndroid == null || this.mPushToAndroid != false;
            boolean bl = pushToIOS = this.mPushToIOS != null && this.mPushToIOS != false;
            if (!pushToIOS || !pushToAndroid) {
                if (pushToIOS) {
                    command.put("type", "ios");
                } else if (pushToAndroid) {
                    command.put("type", "android");
                } else {
                    throw new IllegalArgumentException("Cannot push if both pushToIOS and pushToAndroid are false");
                }
            }
        }
        return command;
    }
}

