/*
 * Decompiled with CFR 0.152.
 */
package com.parse;

import android.webkit.MimeTypeMap;
import com.parse.BackgroundTask;
import com.parse.CountingMultipartEntity;
import com.parse.GetDataCallback;
import com.parse.Parse;
import com.parse.ParseCallback;
import com.parse.ParseCommand;
import com.parse.ParseException;
import com.parse.ParseRequestRetryer;
import com.parse.ProgressCallback;
import com.parse.SaveCallback;
import com.parse.entity.mime.HttpMultipartMode;
import com.parse.entity.mime.content.ByteArrayBody;
import com.parse.entity.mime.content.StringBody;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.json.JSONException;
import org.json.JSONObject;

public class ParseFile {
    private String name = null;
    private String url = null;
    private byte[] data;
    private BackgroundTask<?> currentTask = null;
    private ParseCommand currentCommand = null;
    private HttpPost fileUploadPost = null;
    private ArrayList<GetDataCallback> callbacks = new ArrayList();
    private ParseFileState state;
    private ParseFileState previousState;

    public ParseFile(byte[] data) {
        if (data.length > Parse.maxParseFileSize) {
            throw new IllegalArgumentException(String.format("ParseFile must be less than %i bytes", Parse.maxParseFileSize));
        }
        this.setState(ParseFileState.DIRTY);
        this.data = data;
    }

    public ParseFile(String name, byte[] data) {
        if (data.length > Parse.maxParseFileSize) {
            throw new IllegalArgumentException(String.format("ParseFile must be less than %i bytes", Parse.maxParseFileSize));
        }
        this.name = name;
        this.data = data;
        this.setState(ParseFileState.DIRTY);
    }

    ParseFile(String name, String url) {
        this.name = name;
        this.url = url;
        this.setState(ParseFileState.AWAITING_FETCH);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setState(ParseFileState newState) {
        ParseFile parseFile = this;
        synchronized (parseFile) {
            if (newState != ParseFileState.SAVING && newState != ParseFileState.FETCHING) {
                this.currentTask = null;
                this.currentCommand = null;
            }
            if (this.state != newState) {
                this.previousState = this.state;
                this.state = newState;
            }
        }
    }

    private void revertState() {
        this.setState(this.previousState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void assertNotRunning() {
        ParseFile parseFile = this;
        synchronized (parseFile) {
            if (this.state == ParseFileState.SAVING || this.state == ParseFileState.FETCHING) {
                throw new RuntimeException("This query has an outstanding network connection. You have to wait until it's done.");
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public boolean isDirty() {
        return this.state == ParseFileState.DIRTY;
    }

    public boolean isDataAvailable() {
        return this.state != ParseFileState.AWAITING_FETCH && this.state != ParseFileState.FETCHING;
    }

    public String getUrl() {
        return this.url;
    }

    private ParseCommand constructFileUploadCommand() {
        this.currentCommand = new ParseCommand("upload_file");
        this.currentCommand.enableRetrying();
        if (this.name != null) {
            this.currentCommand.put("name", this.name);
        }
        return this.currentCommand;
    }

    private void prepareFileUploadPost(JSONObject result, ProgressCallback progressCallback) {
        JSONObject postParams = null;
        try {
            this.name = result.getString("name");
            this.url = result.getString("url");
            postParams = result.getJSONObject("post_params");
        }
        catch (JSONException e) {
            throw new RuntimeException(e.getMessage());
        }
        String mimeType = null;
        CountingMultipartEntity entity = new CountingMultipartEntity(HttpMultipartMode.BROWSER_COMPATIBLE, progressCallback);
        if (this.name.lastIndexOf(".") != -1) {
            String extension = this.name.substring(this.name.lastIndexOf(".") + 1);
            mimeType = MimeTypeMap.getSingleton().getMimeTypeFromExtension(extension);
        }
        if (mimeType == null) {
            mimeType = "application/octet-stream";
        }
        try {
            entity.addPart("Content-Type", new StringBody(mimeType));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e.getMessage());
        }
        Iterator keys = postParams.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            try {
                entity.addPart(key, new StringBody(postParams.getString(key)));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e.getMessage());
            }
            catch (JSONException e) {
                throw new RuntimeException(e.getMessage());
            }
        }
        entity.addPart("file", new ByteArrayBody(this.data, mimeType, "file"));
        try {
            this.fileUploadPost = new HttpPost(result.getString("post_url"));
        }
        catch (JSONException e) {
            throw new RuntimeException(e.getMessage());
        }
        this.fileUploadPost.setEntity((HttpEntity)entity);
    }

    private void handleFileUploadResult(JSONObject result, ProgressCallback progressCallback) throws ParseException {
        if (this.state != ParseFileState.SAVING) {
            return;
        }
        if (this.fileUploadPost == null) {
            this.prepareFileUploadPost(result, progressCallback);
        }
        ParseRequestRetryer retryer = new ParseRequestRetryer((HttpUriRequest)this.fileUploadPost, 1000L, 5);
        retryer.go(null);
        this.setState(ParseFileState.DATA_AVAILABLE);
    }

    public void save() throws ParseException {
        this.save(true, null);
    }

    private void save(boolean needsToSetState, ProgressCallback progressCallback) throws ParseException {
        if (needsToSetState) {
            this.assertNotRunning();
            if (this.state != ParseFileState.DIRTY) {
                return;
            }
            this.setState(ParseFileState.SAVING);
        }
        try {
            ParseCommand command = this.constructFileUploadCommand();
            JSONObject result = (JSONObject)command.perform();
            this.handleFileUploadResult(result, progressCallback);
        }
        catch (ParseException e) {
            this.revertState();
            throw e;
        }
    }

    public synchronized void saveInBackground(SaveCallback saveCallback, final ProgressCallback progressCallback) {
        BackgroundTask<Void> saveTask;
        this.assertNotRunning();
        if (this.state != ParseFileState.DIRTY) {
            saveCallback.done(null);
            return;
        }
        this.setState(ParseFileState.SAVING);
        this.currentTask = saveTask = new BackgroundTask<Void>((ParseCallback)saveCallback){

            @Override
            public Void run() throws ParseException {
                ParseFile.this.save(false, progressCallback);
                return null;
            }
        };
        BackgroundTask.executeTask(saveTask);
    }

    public void saveInBackground(SaveCallback callback) {
        this.saveInBackground(callback, null);
    }

    public void saveInBackground() {
        this.saveInBackground(null);
    }

    public byte[] getData() throws ParseException {
        return this.getData(true, null);
    }

    protected byte[] getData(boolean needsToSetState, ProgressCallback progressCallback) throws ParseException {
        if (this.isDataAvailable()) {
            return this.data;
        }
        if (needsToSetState) {
            this.assertNotRunning();
            this.setState(ParseFileState.FETCHING);
        }
        try {
            ParseRequestRetryer retryer = new ParseRequestRetryer((HttpUriRequest)new HttpGet(this.url), 1000L, 5);
            this.data = retryer.go(progressCallback);
        }
        catch (IllegalStateException e) {
            this.revertState();
            throw new ParseException(100, e.getMessage());
        }
        catch (ParseException e) {
            this.revertState();
            throw e;
        }
        this.setState(ParseFileState.DATA_AVAILABLE);
        return this.data;
    }

    public synchronized void getDataInBackground(GetDataCallback dataCallback, final ProgressCallback progressCallback) {
        if (this.isDataAvailable()) {
            dataCallback.done(this.data, null);
            return;
        }
        if (this.state == ParseFileState.FETCHING) {
            this.callbacks.add(dataCallback);
            return;
        }
        this.assertNotRunning();
        this.setState(ParseFileState.FETCHING);
        this.callbacks.add(dataCallback);
        GetDataCallback myCallback = new GetDataCallback(){

            public void done(byte[] data, ParseException e) {
                for (GetDataCallback callback : ParseFile.this.callbacks) {
                    callback.done(data, e);
                }
                ParseFile.this.callbacks.clear();
            }
        };
        BackgroundTask<byte[]> getTask = new BackgroundTask<byte[]>((ParseCallback)myCallback){

            @Override
            public byte[] run() throws ParseException {
                return ParseFile.this.getData(false, progressCallback);
            }
        };
        BackgroundTask.executeTask(getTask);
    }

    public void getDataInBackground(GetDataCallback dataCallback) {
        this.getDataInBackground(dataCallback, null);
    }

    public void cancel() {
        if (this.fileUploadPost != null) {
            this.fileUploadPost.abort();
        }
        if (this.currentCommand != null) {
            this.currentCommand.cancel();
        }
        if (this.currentTask != null) {
            this.currentTask.cancel(true);
        }
        this.callbacks.clear();
        this.revertState();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ParseFileState {
        DIRTY,
        SAVING,
        AWAITING_FETCH,
        FETCHING,
        DATA_AVAILABLE;

    }
}

