/*      */ package oracle.sql.converter;
/*      */ 
/*      */ import java.security.AccessController;
/*      */ import java.security.PrivilegedAction;
/*      */ import java.sql.SQLException;
/*      */ import java.util.HashMap;
/*      */ import java.util.Locale;
/*      */ import java.util.StringTokenizer;
/*      */ 
/*      */ public class CharacterSetMetaData
/*      */ {
/*      */   static final short WIDTH_SIZE = 8;
/*      */   static final short WIDTH_MASK = 255;
/*      */   static final short FLAG_FIXEDWIDTH = 256;
/*      */   public static final int ST_BADCODESET = 0;
/*   62 */   private static final HashMap language = new HashMap(58, 1.0F);
/*   63 */   private static final HashMap territory = new HashMap(134, 1.0F);
/*      */   static InternalCharacterSetMetaData metaDataImpl;
/*      */   private static final short[][] m_maxCharWidth;
/*      */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_;
/*      */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*      */   public static final boolean TRACE = false;
/*      */ 
/*      */   private static final void getMapProperties()
/*      */   {
/*      */     try
/*      */     {
/*   71 */       String[] arrayOfString = { "oracle.jdbc.languageMap", "oracle.jdbc.territoryMap" };
/*   72 */       HashMap[] arrayOfHashMap = { language, territory };
/*      */ 
/*   76 */       for (int i = 0; i < arrayOfString.length; i++)
/*      */       {
/*   78 */         String str3 = arrayOfString[i];
/*   79 */         String str4 = (String)AccessController.doPrivileged(new PrivilegedAction()
/*      */         {
/*      */           public String run()
/*      */           {
/*   83 */             return System.getProperty(this.val$fstr, null);
/*      */           }
/*      */         });
/*   87 */         if (str4 != null)
/*      */         {
/*   89 */           StringTokenizer localStringTokenizer = new StringTokenizer(str4, "=;");
/*   90 */           if (localStringTokenizer.countTokens() % 2 == 0)
/*      */           {
/*   92 */             while (localStringTokenizer.hasMoreTokens())
/*      */             {
/*   94 */               String str1 = localStringTokenizer.nextToken();
/*   95 */               String str2 = localStringTokenizer.nextToken();
/*      */ 
/*   97 */               arrayOfHashMap[i].put(str1, str2);
/*      */             }
/*      */           }
/*      */         }
/*      */       }
/*      */     }
/*      */     catch (Exception localException)
/*      */     {
/*      */     }
/*      */   }
/*      */ 
/*      */   public static String getNLSLanguage(Locale paramLocale)
/*      */   {
/* 1174 */     String str = null;
/*      */ 
/* 1176 */     str = (String)language.get(paramLocale.getLanguage() + "_" + paramLocale.getCountry());
/*      */ 
/* 1178 */     if (str == null)
/*      */     {
/* 1180 */       str = (String)language.get(paramLocale.getLanguage());
/*      */     }
/*      */ 
/* 1183 */     return str;
/*      */   }
/*      */ 
/*      */   public static String getNLSTerritory(Locale paramLocale)
/*      */   {
/* 1197 */     String str = null;
/*      */ 
/* 1199 */     str = (String)territory.get(paramLocale.getLanguage() + "_" + paramLocale.getCountry());
/*      */ 
/* 1201 */     if (str == null)
/*      */     {
/* 1203 */       str = (String)territory.get(paramLocale.getCountry());
/*      */ 
/* 1205 */       if (str == null)
/*      */       {
/* 1207 */         str = (String)territory.get(paramLocale.getLanguage());
/*      */       }
/*      */     }
/*      */ 
/* 1211 */     return str;
/*      */   }
/*      */ 
/*      */   public static boolean isFixedWidth(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1222 */     return metaDataImpl.isFixedWidth(paramInt);
/*      */   }
/*      */ 
/*      */   public static int getRatio(int paramInt1, int paramInt2)
/*      */   {
/* 1256 */     if (paramInt2 == paramInt1)
/*      */     {
/* 1258 */       return 1;
/*      */     }
/*      */ 
/* 1261 */     int i = metaDataImpl.getMaxCharLength(paramInt1);
/*      */ 
/* 1263 */     if (i == 0)
/* 1264 */       return 0;
/* 1265 */     if (i == 1)
/* 1266 */       return 1;
/* 1267 */     if (paramInt2 == 1) {
/* 1268 */       return i;
/*      */     }
/* 1270 */     if (metaDataImpl.isFixedWidth(paramInt2))
/*      */     {
/* 1274 */       return i;
/*      */     }
/*      */ 
/* 1282 */     int j = metaDataImpl.getMaxCharLength(paramInt2);
/* 1283 */     if (j == 0) {
/* 1284 */       return 0;
/*      */     }
/* 1286 */     int k = i / j;
/*      */ 
/* 1288 */     if (i % j != 0)
/*      */     {
/* 1290 */       k++;
/*      */     }
/*      */ 
/* 1293 */     return k;
/*      */   }
/*      */ 
/*      */   static
/*      */   {
/*  110 */     language.put("", "AMERICAN");
/*  111 */     language.put("ar_EG", "EGYPTIAN");
/*  112 */     language.put("ar", "ARABIC");
/*  113 */     language.put("as", "ASSAMESE");
/*  114 */     language.put("bg", "BULGARIAN");
/*  115 */     language.put("bn", "BANGLA");
/*  116 */     language.put("ca", "CATALAN");
/*  117 */     language.put("cs", "CZECH");
/*  118 */     language.put("da", "DANISH");
/*  119 */     language.put("de", "GERMAN");
/*  120 */     language.put("el", "GREEK");
/*  121 */     language.put("en", "AMERICAN");
/*      */ 
/*  142 */     language.put("es_ES", "SPANISH");
/*  143 */     language.put("es_MX", "MEXICAN SPANISH");
/*  144 */     language.put("es", "LATIN AMERICAN SPANISH");
/*  145 */     language.put("et", "ESTONIAN");
/*  146 */     language.put("fi", "FINNISH");
/*  147 */     language.put("fr_CA", "CANADIAN FRENCH");
/*  148 */     language.put("fr", "FRENCH");
/*  149 */     language.put("ga", "IRISH");
/*  150 */     language.put("gu", "GUJARATI");
/*  151 */     language.put("he", "HEBREW");
/*  152 */     language.put("hi", "HINDI");
/*  153 */     language.put("hr", "CROATIAN");
/*  154 */     language.put("hu", "HUNGARIAN");
/*  155 */     language.put("id", "INDONESIAN");
/*  156 */     language.put("in", "INDONESIAN");
/*  157 */     language.put("is", "ICELANDIC");
/*  158 */     language.put("it", "ITALIAN");
/*  159 */     language.put("iw", "HEBREW");
/*  160 */     language.put("ja", "JAPANESE");
/*  161 */     language.put("kn", "KANNADA");
/*  162 */     language.put("ko", "KOREAN");
/*  163 */     language.put("kk", "CYRILLIC KAZAKH");
/*  164 */     language.put("kk_KZ", "CYRILLIC KAZAKH");
/*  165 */     language.put("lt", "LITHUANIAN");
/*  166 */     language.put("lv", "LATVIAN");
/*  167 */     language.put("mk", "MACEDONIAN");
/*  168 */     language.put("ml", "MALAYALAM");
/*  169 */     language.put("mr", "MARATHI");
/*  170 */     language.put("ms", "MALAY");
/*  171 */     language.put("nb", "NORWEGIAN");
/*  172 */     language.put("nl", "DUTCH");
/*  173 */     language.put("no", "NORWEGIAN");
/*  174 */     language.put("or", "ORIYA");
/*  175 */     language.put("pa", "PUNJABI");
/*  176 */     language.put("pl", "POLISH");
/*  177 */     language.put("pt_BR", "BRAZILIAN PORTUGUESE");
/*  178 */     language.put("pt", "PORTUGUESE");
/*  179 */     language.put("ro", "ROMANIAN");
/*  180 */     language.put("ru", "RUSSIAN");
/*  181 */     language.put("sk", "SLOVAK");
/*  182 */     language.put("sq", "ALBANIAN");
/*  183 */     language.put("sl", "SLOVENIAN");
/*  184 */     language.put("sr", "CYRILLIC SERBIAN");
/*  185 */     language.put("sh", "LATIN SERBIAN");
/*  186 */     language.put("sv", "SWEDISH");
/*  187 */     language.put("ta", "TAMIL");
/*  188 */     language.put("te", "TELUGU");
/*  189 */     language.put("th", "THAI");
/*  190 */     language.put("tr", "TURKISH");
/*  191 */     language.put("uk", "UKRAINIAN");
/*  192 */     language.put("vi", "VIETNAMESE");
/*  193 */     language.put("zh_HK", "TRADITIONAL CHINESE");
/*  194 */     language.put("zh_TW", "TRADITIONAL CHINESE");
/*  195 */     language.put("zh", "SIMPLIFIED CHINESE");
/*      */ 
/*  197 */     territory.put("AE", "UNITED ARAB EMIRATES");
/*  198 */     territory.put("AL", "ALBANIA");
/*  199 */     territory.put("AT", "AUSTRIA");
/*  200 */     territory.put("AU", "AUSTRALIA");
/*  201 */     territory.put("BD", "BANGLADESH");
/*  202 */     territory.put("BE", "BELGIUM");
/*  203 */     territory.put("BG", "BULGARIA");
/*  204 */     territory.put("BH", "BAHRAIN");
/*  205 */     territory.put("BR", "BRAZIL");
/*  206 */     territory.put("CA", "CANADA");
/*  207 */     territory.put("CH", "SWITZERLAND");
/*  208 */     territory.put("CL", "CHILE");
/*  209 */     territory.put("CN", "CHINA");
/*  210 */     territory.put("CO", "COLOMBIA");
/*  211 */     territory.put("CR", "COSTA RICA");
/*  212 */     territory.put("CY", "CYPRUS");
/*  213 */     territory.put("CZ", "CZECH REPUBLIC");
/*  214 */     territory.put("DE", "GERMANY");
/*  215 */     territory.put("DJ", "DJIBOUTI");
/*  216 */     territory.put("DK", "DENMARK");
/*  217 */     territory.put("DZ", "ALGERIA");
/*  218 */     territory.put("EE", "ESTONIA");
/*  219 */     territory.put("EG", "EGYPT");
/*  220 */     territory.put("ES", "SPAIN");
/*  221 */     territory.put("ca_ES", "CATALONIA");
/*      */ 
/*  224 */     territory.put("FI", "FINLAND");
/*  225 */     territory.put("FR", "FRANCE");
/*  226 */     territory.put("GB", "UNITED KINGDOM");
/*  227 */     territory.put("GR", "GREECE");
/*  228 */     territory.put("GT", "GUATEMALA");
/*  229 */     territory.put("HK", "HONG KONG");
/*  230 */     territory.put("HR", "CROATIA");
/*  231 */     territory.put("HU", "HUNGARY");
/*  232 */     territory.put("ID", "INDONESIA");
/*  233 */     territory.put("IE", "IRELAND");
/*  234 */     territory.put("IL", "ISRAEL");
/*  235 */     territory.put("IN", "INDIA");
/*  236 */     territory.put("IQ", "IRAQ");
/*  237 */     territory.put("IS", "ICELAND");
/*  238 */     territory.put("IT", "ITALY");
/*  239 */     territory.put("JO", "JORDAN");
/*  240 */     territory.put("JP", "JAPAN");
/*  241 */     territory.put("KR", "KOREA");
/*  242 */     territory.put("KW", "KUWAIT");
/*  243 */     territory.put("LB", "LEBANON");
/*  244 */     territory.put("LT", "LITHUANIA");
/*  245 */     territory.put("LU", "LUXEMBOURG");
/*  246 */     territory.put("LV", "LATVIA");
/*  247 */     territory.put("LY", "LIBYA");
/*  248 */     territory.put("MA", "MOROCCO");
/*  249 */     territory.put("MK", "FYR MACEDONIA");
/*  250 */     territory.put("MR", "MAURITANIA");
/*  251 */     territory.put("MX", "MEXICO");
/*  252 */     territory.put("MY", "MALAYSIA");
/*  253 */     territory.put("NI", "NICARAGUA");
/*  254 */     territory.put("NL", "THE NETHERLANDS");
/*  255 */     territory.put("NO", "NORWAY");
/*  256 */     territory.put("NZ", "NEW ZEALAND");
/*  257 */     territory.put("OM", "OMAN");
/*  258 */     territory.put("PA", "PANAMA");
/*  259 */     territory.put("PE", "PERU");
/*  260 */     territory.put("PL", "POLAND");
/*  261 */     territory.put("PR", "PUERTO RICO");
/*  262 */     territory.put("PT", "PORTUGAL");
/*  263 */     territory.put("QA", "QATAR");
/*  264 */     territory.put("RO", "ROMANIA");
/*  265 */     territory.put("RU", "CIS");
/*  266 */     territory.put("SA", "SAUDI ARABIA");
/*  267 */     territory.put("SD", "SUDAN");
/*  268 */     territory.put("SE", "SWEDEN");
/*  269 */     territory.put("SG", "SINGAPORE");
/*  270 */     territory.put("SI", "SLOVENIA");
/*  271 */     territory.put("SK", "SLOVAKIA");
/*  272 */     territory.put("SO", "SOMALIA");
/*  273 */     territory.put("SV", "EL SALVADOR");
/*  274 */     territory.put("SY", "SYRIA");
/*  275 */     territory.put("TH", "THAILAND");
/*  276 */     territory.put("TN", "TUNISIA");
/*  277 */     territory.put("TR", "TURKEY");
/*  278 */     territory.put("TW", "TAIWAN");
/*  279 */     territory.put("UA", "UKRAINE");
/*  280 */     territory.put("US", "AMERICA");
/*  281 */     territory.put("VE", "VENEZUELA");
/*  282 */     territory.put("VN", "VIETNAM");
/*  283 */     territory.put("YE", "YEMEN");
/*  284 */     territory.put("ZA", "SOUTH AFRICA");
/*      */ 
/*  286 */     territory.put("ar", "SAUDI ARABIA");
/*  287 */     territory.put("as", "INDIA");
/*  288 */     territory.put("bg", "BULGARIA");
/*  289 */     territory.put("bn", "BANGLADESH");
/*  290 */     territory.put("ca", "CATALONIA");
/*  291 */     territory.put("cs", "CZECH REPUBLIC");
/*  292 */     territory.put("da", "DENMARK");
/*  293 */     territory.put("de", "GERMANY");
/*  294 */     territory.put("el", "GREECE");
/*  295 */     territory.put("en", "AMERICA");
/*  296 */     territory.put("es", "AMERICA");
/*  297 */     territory.put("et", "ESTONIA");
/*  298 */     territory.put("fi", "FINLAND");
/*  299 */     territory.put("fr", "FRANCE");
/*  300 */     territory.put("gu", "INDIA");
/*  301 */     territory.put("he", "ISRAEL");
/*  302 */     territory.put("hi", "INDIA");
/*  303 */     territory.put("hr", "CROATIA");
/*  304 */     territory.put("hu", "HUNGARY");
/*  305 */     territory.put("id", "INDONESIA");
/*  306 */     territory.put("in", "INDONESIA");
/*  307 */     territory.put("is", "ICELAND");
/*  308 */     territory.put("it", "ITALY");
/*  309 */     territory.put("iw", "ISRAEL");
/*  310 */     territory.put("ja", "JAPAN");
/*  311 */     territory.put("kn", "INDIA");
/*  312 */     territory.put("ko", "KOREA");
/*  313 */     territory.put("kk", "KAZAKHSTAN");
/*  314 */     territory.put("kk_KZ", "KAZAKHSTAN");
/*  315 */     territory.put("lt", "LITHUANIA");
/*  316 */     territory.put("lv", "LATVIA");
/*  317 */     territory.put("mk", "FYR MACEDONIA");
/*  318 */     territory.put("ml", "INDIA");
/*  319 */     territory.put("mr", "INDIA");
/*  320 */     territory.put("ms", "MALAYSIA");
/*  321 */     territory.put("nl", "THE NETHERLANDS");
/*  322 */     territory.put("no", "NORWAY");
/*  323 */     territory.put("or", "INDIA");
/*  324 */     territory.put("pa", "INDIA");
/*  325 */     territory.put("pl", "POLAND");
/*  326 */     territory.put("pt", "PORTUGAL");
/*  327 */     territory.put("ro", "ROMANIA");
/*  328 */     territory.put("ru", "CIS");
/*  329 */     territory.put("sk", "SLOVAKIA");
/*  330 */     territory.put("sl", "SLOVENIA");
/*  331 */     territory.put("sq", "ALBANIA");
/*  332 */     territory.put("sr", "SERBIA AND MONTENEGRO");
/*  333 */     territory.put("sh", "SERBIA AND MONTENEGRO");
/*  334 */     territory.put("sv", "SWEDEN");
/*  335 */     territory.put("ta", "INDIA");
/*  336 */     territory.put("te", "INDIA");
/*  337 */     territory.put("th", "THAILAND");
/*  338 */     territory.put("tr", "TURKEY");
/*  339 */     territory.put("uk", "UKRAINE");
/*  340 */     territory.put("vi", "VIETNAM");
/*  341 */     territory.put("zh", "CHINA");
/*      */ 
/*  344 */     metaDataImpl = null;
/*      */ 
/*  352 */     Orai18nCharacterSetMetaData localOrai18nCharacterSetMetaData = null;
/*      */     try
/*      */     {
/*  356 */       Class.forName("oracle.i18n.text.OraBoot");
/*  357 */       localOrai18nCharacterSetMetaData = new Orai18nCharacterSetMetaData();
/*      */     }
/*      */     catch (ClassNotFoundException localClassNotFoundException)
/*      */     {
/*      */     }
/*      */ 
/*  365 */     if ((localOrai18nCharacterSetMetaData != null) && (localOrai18nCharacterSetMetaData.oraBoot != null))
/*  366 */       metaDataImpl = localOrai18nCharacterSetMetaData;
/*      */     else {
/*  368 */       metaDataImpl = new JdbcCharacterSetMetaData();
/*      */     }
/*      */ 
/*  381 */     m_maxCharWidth = new short[][] { { 1, 1 }, { 2, 1 }, { 3, 1 }, { 4, 1 }, { 5, 1 }, { 6, 1 }, { 7, 1 }, { 8, 1 }, { 9, 1 }, { 10, 1 }, { 11, 1 }, { 12, 1 }, { 13, 1 }, { 14, 1 }, { 15, 1 }, { 16, 1 }, { 17, 1 }, { 18, 1 }, { 19, 1 }, { 20, 1 }, { 21, 1 }, { 22, 1 }, { 23, 1 }, { 25, 1 }, { 27, 1 }, { 28, 1 }, { 31, 1 }, { 32, 1 }, { 33, 1 }, { 34, 1 }, { 35, 1 }, { 36, 1 }, { 37, 1 }, { 38, 1 }, { 39, 1 }, { 40, 1 }, { 41, 1 }, { 42, 1 }, { 43, 1 }, { 44, 1 }, { 45, 1 }, { 46, 1 }, { 47, 1 }, { 48, 1 }, { 49, 1 }, { 50, 1 }, { 51, 1 }, { 61, 1 }, { 70, 1 }, { 72, 1 }, { 81, 1 }, { 82, 1 }, { 90, 1 }, { 91, 1 }, { 92, 1 }, { 93, 1 }, { 94, 1 }, { 95, 1 }, { 96, 1 }, { 97, 1 }, { 98, 1 }, { 99, 1 }, { 100, 1 }, { 101, 1 }, { 110, 1 }, { 113, 1 }, { 114, 1 }, { 140, 1 }, { 150, 1 }, { 152, 1 }, { 153, 1 }, { 154, 1 }, { 155, 1 }, { 156, 1 }, { 158, 1 }, { 159, 1 }, { 160, 1 }, { 161, 1 }, { 162, 1 }, { 163, 1 }, { 164, 1 }, { 165, 1 }, { 166, 1 }, { 167, 1 }, { 170, 1 }, { 171, 1 }, { 172, 1 }, { 173, 1 }, { 174, 1 }, { 175, 1 }, { 176, 1 }, { 177, 1 }, { 178, 1 }, { 179, 1 }, { 180, 1 }, { 181, 1 }, { 182, 1 }, { 183, 1 }, { 184, 1 }, { 185, 1 }, { 186, 1 }, { 187, 1 }, { 188, 1 }, { 189, 1 }, { 190, 1 }, { 191, 1 }, { 192, 1 }, { 193, 1 }, { 194, 1 }, { 195, 1 }, { 196, 1 }, { 197, 1 }, { 198, 1 }, { 199, 1 }, { 200, 1 }, { 201, 1 }, { 202, 1 }, { 203, 1 }, { 204, 1 }, { 205, 1 }, { 206, 1 }, { 207, 1 }, { 208, 1 }, { 210, 1 }, { 211, 1 }, { 221, 1 }, { 222, 1 }, { 223, 1 }, { 224, 1 }, { 225, 1 }, { 226, 1 }, { 230, 1 }, { 231, 1 }, { 232, 1 }, { 233, 1 }, { 235, 1 }, { 239, 1 }, { 241, 1 }, { 251, 1 }, { 261, 1 }, { 262, 1 }, { 263, 1 }, { 264, 1 }, { 265, 1 }, { 266, 1 }, { 267, 1 }, { 277, 1 }, { 278, 1 }, { 279, 1 }, { 301, 1 }, { 311, 1 }, { 312, 1 }, { 314, 1 }, { 315, 1 }, { 316, 1 }, { 317, 1 }, { 319, 1 }, { 320, 1 }, { 322, 1 }, { 323, 1 }, { 324, 1 }, { 351, 1 }, { 352, 1 }, { 353, 1 }, { 354, 1 }, { 368, 1 }, { 380, 1 }, { 381, 1 }, { 382, 1 }, { 383, 1 }, { 384, 1 }, { 385, 1 }, { 386, 1 }, { 390, 1 }, { 401, 1 }, { 500, 1 }, { 504, 1 }, { 505, 1 }, { 506, 1 }, { 507, 1 }, { 508, 1 }, { 509, 1 }, { 511, 1 }, { 514, 1 }, { 554, 1 }, { 555, 1 }, { 556, 1 }, { 557, 1 }, { 558, 1 }, { 559, 1 }, { 560, 1 }, { 561, 1 }, { 563, 1 }, { 565, 1 }, { 566, 1 }, { 567, 1 }, { 590, 1 }, { 798, 1 }, { 799, 258 }, { 829, 2 }, { 830, 3 }, { 831, 3 }, { 832, 2 }, { 833, 3 }, { 834, 2 }, { 835, 3 }, { 836, 2 }, { 837, 3 }, { 838, 2 }, { 840, 2 }, { 842, 3 }, { 845, 2 }, { 846, 2 }, { 850, 2 }, { 851, 2 }, { 852, 2 }, { 853, 3 }, { 854, 4 }, { 860, 4 }, { 861, 4 }, { 862, 2 }, { 863, 4 }, { 864, 3 }, { 865, 2 }, { 866, 2 }, { 867, 2 }, { 868, 2 }, { 870, 3 }, { 871, 3 }, { 872, 4 }, { 873, 4 }, { 992, 2 }, { 994, 2 }, { 995, 2 }, { 996, 3 }, { 997, 2 }, { 998, 3 }, { 1001, 258 }, { 1830, 258 }, { 1832, 258 }, { 1833, 258 }, { 1840, 258 }, { 1842, 258 }, { 1850, 258 }, { 1852, 258 }, { 1853, 258 }, { 1860, 258 }, { 1863, 260 }, { 1864, 258 }, { 1865, 258 }, { 2000, 258 }, { 2002, 258 }, { 9996, 3 }, { 9997, 3 }, { 9998, 3 }, { 9999, 3 } };
/*      */ 
/* 1377 */     _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*      */ 
/* 1384 */     getMapProperties();
/*      */   }
/*      */ 
/*      */   static class JdbcCharacterSetMetaData
/*      */     implements InternalCharacterSetMetaData
/*      */   {
/*      */     public boolean isFixedWidth(int paramInt)
/*      */     {
/* 1303 */       if (paramInt == 0) return false;
/*      */ 
/* 1306 */       int i = -1;
/* 1307 */       int j = 0;
/* 1308 */       int k = CharacterSetMetaData.m_maxCharWidth.length - 1;
/* 1309 */       int m = -1;
/*      */ 
/* 1311 */       while (j <= k)
/*      */       {
/* 1313 */         m = (j + k) / 2;
/*      */ 
/* 1315 */         if (paramInt < CharacterSetMetaData.m_maxCharWidth[m][0])
/*      */         {
/* 1317 */           k = m - 1;
/*      */         }
/* 1319 */         else if (paramInt > CharacterSetMetaData.m_maxCharWidth[m][0])
/*      */         {
/* 1321 */           j = m + 1;
/*      */         }
/*      */         else
/*      */         {
/* 1326 */           i = m;
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/* 1332 */       return (CharacterSetMetaData.m_maxCharWidth[i][1] & 0x100) != 0;
/*      */     }
/*      */ 
/*      */     public int getMaxCharLength(int paramInt)
/*      */     {
/* 1341 */       int i = -1;
/* 1342 */       int j = 0;
/* 1343 */       int k = CharacterSetMetaData.m_maxCharWidth.length - 1;
/*      */ 
/* 1346 */       while (j <= k)
/*      */       {
/* 1348 */         int m = (j + k) / 2;
/*      */ 
/* 1350 */         if (paramInt < CharacterSetMetaData.m_maxCharWidth[m][0])
/*      */         {
/* 1352 */           k = m - 1;
/*      */         }
/* 1354 */         else if (paramInt > CharacterSetMetaData.m_maxCharWidth[m][0])
/*      */         {
/* 1356 */           j = m + 1;
/*      */         }
/*      */         else
/*      */         {
/* 1361 */           i = m;
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/* 1367 */       if (i < 0)
/*      */       {
/* 1369 */         return 0;
/*      */       }
/* 1371 */       return CharacterSetMetaData.m_maxCharWidth[i][1] & 0xFF;
/*      */     }
/*      */   }
/*      */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.sql.converter.CharacterSetMetaData
 * JD-Core Version:    0.6.2
 */