/*     */ package oracle.sql.converter;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ import java.util.HashMap;
/*     */ import java.util.Hashtable;
/*     */ import oracle.sql.ConverterArchive;
/*     */ 
/*     */ public abstract class CharacterConverterJDBC
/*     */   implements JdbcCharacterConverters, Serializable
/*     */ {
/*     */   static final long serialVersionUID = 5948085171100875165L;
/*     */   static final String CONVERTERNAMEPREFIX = "converter_xcharset/lx2";
/*     */   static final String CONVERTERIDPREFIX = "0000";
/*     */   static final int HIBYTEMASK = 65280;
/*     */   static final int LOWBYTEMASK = 255;
/*     */   static final int STORE_INCREMENT = 10;
/*     */   static final int INVALID_ORA_CHAR = -1;
/*     */   static final int FIRSTBSHIFT = 24;
/*     */   static final int SECONDBSHIFT = 16;
/*     */   static final int THIRDBSHIFT = 8;
/*     */   static final int UB2MASK = 65535;
/*     */   static final int UB4MASK = 65535;
/*  72 */   static final HashMap m_converterStore = new HashMap();
/*     */   public int m_groupId;
/*     */   public int m_oracleId;
/*  81 */   public int[][] extraUnicodeToOracleMapping = (int[][])null;
/*     */ 
/*     */   public int getGroupId()
/*     */   {
/*  92 */     return this.m_groupId;
/*     */   }
/*     */ 
/*     */   public int getOracleId()
/*     */   {
/* 102 */     return this.m_oracleId;
/*     */   }
/*     */ 
/*     */   public char[] getLeadingCodes()
/*     */   {
/* 107 */     return null;
/*     */   }
/*     */ 
/*     */   public static JdbcCharacterConverters getInstance(int paramInt)
/*     */   {
/* 122 */     CharacterConverterJDBC localCharacterConverterJDBC = null;
/* 123 */     int i = 0;
/* 124 */     int j = 0;
/* 125 */     String str1 = Integer.toHexString(paramInt);
/*     */ 
/* 127 */     synchronized (m_converterStore)
/*     */     {
/* 129 */       localCharacterConverterJDBC = (CharacterConverterJDBC)m_converterStore.get(str1);
/*     */ 
/* 131 */       if (localCharacterConverterJDBC != null)
/*     */       {
/* 133 */         return localCharacterConverterJDBC;
/*     */       }
/*     */ 
/* 137 */       String str2 = "converter_xcharset/lx2" + "0000".substring(0, 4 - str1.length()) + str1;
/*     */ 
/* 140 */       ConverterArchive localConverterArchive = new ConverterArchive();
/*     */ 
/* 142 */       localCharacterConverterJDBC = (CharacterConverterJDBC)localConverterArchive.readObj(str2 + ".glb");
/*     */ 
/* 145 */       if (localCharacterConverterJDBC == null)
/*     */       {
/* 147 */         return null;
/*     */       }
/*     */ 
/* 150 */       localCharacterConverterJDBC.buildUnicodeToOracleMapping();
/* 151 */       m_converterStore.put(str1, localCharacterConverterJDBC);
/*     */ 
/* 153 */       return localCharacterConverterJDBC;
/*     */     }
/*     */   }
/*     */ 
/*     */   protected void storeMappingRange(int paramInt, Hashtable paramHashtable1, Hashtable paramHashtable2)
/*     */   {
/* 168 */     int i = paramInt >> 24 & 0xFF;
/* 169 */     int j = paramInt >> 16 & 0xFF;
/* 170 */     int k = paramInt >> 8 & 0xFF;
/* 171 */     int m = paramInt & 0xFF;
/* 172 */     Integer localInteger1 = Integer.valueOf(i);
/* 173 */     Integer localInteger2 = Integer.valueOf(paramInt >> 16 & 0xFFFF);
/* 174 */     Integer localInteger3 = Integer.valueOf(paramInt >> 8 & 0xFFFFFF);
/*     */ 
/* 178 */     if (paramInt >>> 26 == 54)
/*     */     {
/* 182 */       arrayOfChar = (char[])paramHashtable1.get(localInteger1);
/*     */ 
/* 184 */       if (arrayOfChar == null)
/*     */       {
/* 186 */         arrayOfChar = new char[] { 'ÿ', '\000' };
/*     */       }
/*     */ 
/* 192 */       if ((arrayOfChar[0] == 'ÿ') && (arrayOfChar[1] == 0))
/*     */       {
/* 194 */         arrayOfChar[0] = ((char)j);
/* 195 */         arrayOfChar[1] = ((char)j);
/*     */       }
/*     */       else
/*     */       {
/* 199 */         if (j < (arrayOfChar[0] & 0xFFFF))
/*     */         {
/* 201 */           arrayOfChar[0] = ((char)j);
/*     */         }
/*     */ 
/* 204 */         if (j > (arrayOfChar[0] & 0xFFFF))
/*     */         {
/* 206 */           arrayOfChar[1] = ((char)j);
/*     */         }
/*     */       }
/*     */ 
/* 210 */       paramHashtable1.put(localInteger1, arrayOfChar);
/*     */ 
/* 213 */       arrayOfChar = (char[])paramHashtable1.get(localInteger2);
/*     */ 
/* 215 */       if (arrayOfChar == null)
/*     */       {
/* 217 */         arrayOfChar = new char[] { 'ÿ', '\000' };
/*     */       }
/*     */ 
/* 223 */       if ((arrayOfChar[0] == 'ÿ') && (arrayOfChar[1] == 0))
/*     */       {
/* 225 */         arrayOfChar[0] = ((char)k);
/* 226 */         arrayOfChar[1] = ((char)k);
/*     */       }
/*     */       else
/*     */       {
/* 230 */         if (k < (arrayOfChar[0] & 0xFFFF))
/*     */         {
/* 232 */           arrayOfChar[0] = ((char)k);
/*     */         }
/*     */ 
/* 235 */         if (k > (arrayOfChar[0] & 0xFFFF))
/*     */         {
/* 237 */           arrayOfChar[1] = ((char)k);
/*     */         }
/*     */       }
/*     */ 
/* 241 */       paramHashtable1.put(localInteger2, arrayOfChar);
/*     */     }
/*     */ 
/* 245 */     char[] arrayOfChar = (char[])paramHashtable2.get(localInteger3);
/*     */ 
/* 247 */     if (arrayOfChar == null)
/*     */     {
/* 249 */       arrayOfChar = new char[] { 'ÿ', '\000' };
/*     */     }
/*     */ 
/* 255 */     if ((arrayOfChar[0] == 'ÿ') && (arrayOfChar[1] == 0))
/*     */     {
/* 257 */       arrayOfChar[0] = ((char)m);
/* 258 */       arrayOfChar[1] = ((char)m);
/*     */     }
/*     */     else
/*     */     {
/* 262 */       if (m < (arrayOfChar[0] & 0xFFFF))
/*     */       {
/* 264 */         arrayOfChar[0] = ((char)m);
/*     */       }
/*     */ 
/* 267 */       if (m > (arrayOfChar[0] & 0xFFFF))
/*     */       {
/* 269 */         arrayOfChar[1] = ((char)m);
/*     */       }
/*     */     }
/*     */ 
/* 273 */     paramHashtable2.put(localInteger3, arrayOfChar);
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.sql.converter.CharacterConverterJDBC
 * JD-Core Version:    0.6.2
 */