/*      */ package oracle.sql.converter;
/*      */ 
/*      */ import java.sql.SQLException;
/*      */ import java.util.Enumeration;
/*      */ import java.util.Hashtable;
/*      */ import java.util.Vector;
/*      */ import oracle.jdbc.driver.DatabaseError;
/*      */ import oracle.jdbc.internal.OracleConnection;
/*      */ 
/*      */ public class CharacterConverter1Byte extends CharacterConverterJDBC
/*      */ {
/*      */   static final long serialVersionUID = 200017349723606452L;
/*      */   static final int ORACHARMASK = 255;
/*      */   static final int UCSCHARWIDTH = 16;
/*  116 */   public int m_ucsReplacement = 0;
/*  117 */   public int[] m_ucsChar = null;
/*  118 */   public char[] m_oraCharLevel1 = null;
/*  119 */   public char[] m_oraCharSurrogateLevel = null;
/*  120 */   public char[] m_oraCharLevel2 = null;
/*  121 */   public byte m_oraCharReplacement = 0;
/*  122 */   protected transient boolean noSurrogate = true;
/*  123 */   protected transient boolean strictASCII = true;
/*  124 */   protected transient int m_oraCharLevel2Size = 0;
/*      */ 
/* 1015 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*      */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*      */   public static final boolean TRACE = false;
/*      */ 
/*      */   public CharacterConverter1Byte()
/*      */   {
/*  131 */     this.m_groupId = 0;
/*      */   }
/*      */ 
/*      */   int toUnicode(byte paramByte)
/*      */     throws SQLException
/*      */   {
/*  150 */     int i = this.m_ucsChar[(paramByte & 0xFF)];
/*      */ 
/*  152 */     if (i == -1)
/*      */     {
/*  155 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 154);
/*  156 */       localSQLException.fillInStackTrace();
/*  157 */       throw localSQLException;
/*      */     }
/*      */ 
/*  162 */     return i;
/*      */   }
/*      */ 
/*      */   int toUnicodeWithReplacement(byte paramByte)
/*      */   {
/*  175 */     int i = this.m_ucsChar[(paramByte & 0xFF)];
/*      */ 
/*  177 */     if (i == -1)
/*      */     {
/*  179 */       return this.m_ucsReplacement;
/*      */     }
/*      */ 
/*  183 */     return i;
/*      */   }
/*      */ 
/*      */   byte toOracleCharacter(char paramChar1, char paramChar2)
/*      */     throws SQLException
/*      */   {
/*  201 */     int i = paramChar1 >>> '\b' & 0xFF;
/*  202 */     int j = paramChar1 & 0xFF;
/*  203 */     int k = paramChar2 >>> '\b' & 0xFF;
/*  204 */     int m = paramChar2 & 0xFF;
/*      */ 
/*  206 */     if ((this.m_oraCharLevel1[i] != (char)this.m_oraCharLevel2Size) && (this.m_oraCharSurrogateLevel[(this.m_oraCharLevel1[i] + j)] != 65535) && (this.m_oraCharSurrogateLevel[(this.m_oraCharSurrogateLevel[(this.m_oraCharLevel1[i] + j)] + k)] != 65535) && (this.m_oraCharLevel2[(this.m_oraCharSurrogateLevel[(this.m_oraCharSurrogateLevel[(this.m_oraCharLevel1[i] + j)] + k)] + m)] != 65535))
/*      */     {
/*  212 */       return (byte)this.m_oraCharLevel2[(this.m_oraCharSurrogateLevel[(this.m_oraCharSurrogateLevel[(this.m_oraCharLevel1[i] + j)] + k)] + m)];
/*      */     }
/*      */ 
/*  217 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 155);
/*  218 */     localSQLException.fillInStackTrace();
/*  219 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   byte toOracleCharacter(char paramChar)
/*      */     throws SQLException
/*      */   {
/*  239 */     int i = paramChar >>> '\b';
/*  240 */     int j = paramChar & 0xFF;
/*      */     int k;
/*  243 */     if ((k = this.m_oraCharLevel2[(this.m_oraCharLevel1[i] + j)]) != 65535)
/*      */     {
/*  246 */       return (byte)k;
/*      */     }
/*      */ 
/*  251 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 155);
/*  252 */     localSQLException.fillInStackTrace();
/*  253 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   byte toOracleCharacterWithReplacement(char paramChar1, char paramChar2)
/*      */   {
/*  272 */     int i = paramChar1 >>> '\b' & 0xFF;
/*  273 */     int j = paramChar1 & 0xFF;
/*  274 */     int k = paramChar2 >>> '\b' & 0xFF;
/*  275 */     int m = paramChar2 & 0xFF;
/*      */ 
/*  277 */     if ((this.m_oraCharLevel1[i] != (char)this.m_oraCharLevel2Size) && (this.m_oraCharSurrogateLevel[(this.m_oraCharLevel1[i] + j)] != 65535) && (this.m_oraCharSurrogateLevel[(this.m_oraCharSurrogateLevel[(this.m_oraCharLevel1[i] + j)] + k)] != 65535) && (this.m_oraCharLevel2[(this.m_oraCharSurrogateLevel[(this.m_oraCharSurrogateLevel[(this.m_oraCharLevel1[i] + j)] + k)] + m)] != 65535))
/*      */     {
/*  283 */       return (byte)this.m_oraCharLevel2[(this.m_oraCharSurrogateLevel[(this.m_oraCharSurrogateLevel[(this.m_oraCharLevel1[i] + j)] + k)] + m)];
/*      */     }
/*      */ 
/*  287 */     return this.m_oraCharReplacement;
/*      */   }
/*      */ 
/*      */   byte toOracleCharacterWithReplacement(char paramChar)
/*      */   {
/*  303 */     int i = paramChar >>> '\b';
/*  304 */     int j = paramChar & 0xFF;
/*      */     int k;
/*  307 */     if ((k = this.m_oraCharLevel2[(this.m_oraCharLevel1[i] + j)]) != 65535)
/*      */     {
/*  310 */       return (byte)k;
/*      */     }
/*      */ 
/*  314 */     return this.m_oraCharReplacement;
/*      */   }
/*      */ 
/*      */   public int toUnicodeChars(byte[] paramArrayOfByte, int paramInt1, char[] paramArrayOfChar, int paramInt2, int paramInt3)
/*      */     throws SQLException
/*      */   {
/*  335 */     int i = paramInt1 + paramInt3;
/*      */ 
/*  337 */     int j = 0;
/*      */ 
/*  340 */     int m = paramInt2;
/*      */ 
/*  342 */     for (int k = paramInt1; (k < i) && (m < paramArrayOfChar.length); k++)
/*      */     {
/*  344 */       j = this.m_ucsChar[(paramArrayOfByte[k] & 0xFF)];
/*      */ 
/*  346 */       if (j == this.m_ucsReplacement)
/*      */       {
/*  349 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 154);
/*  350 */         localSQLException.fillInStackTrace();
/*  351 */         throw localSQLException;
/*      */       }
/*      */ 
/*  357 */       if ((j & 0xFFFFFFFF) > 65535L)
/*      */       {
/*  359 */         if (m + 2 < paramArrayOfChar.length)
/*      */         {
/*  361 */           k--;
/*  362 */           break;
/*      */         }
/*  364 */         paramArrayOfChar[(m++)] = ((char)(j >>> 16));
/*  365 */         paramArrayOfChar[(m++)] = ((char)(j & 0xFFFF));
/*      */       }
/*      */       else
/*      */       {
/*  369 */         paramArrayOfChar[(m++)] = ((char)j);
/*      */       }
/*      */     }
/*      */ 
/*  373 */     return k;
/*      */   }
/*      */ 
/*      */   public String toUnicodeString(byte[] paramArrayOfByte, int paramInt1, int paramInt2)
/*      */     throws SQLException
/*      */   {
/*  381 */     int i = paramInt1 + paramInt2;
/*      */ 
/*  383 */     StringBuilder localStringBuilder = new StringBuilder(paramInt2);
/*  384 */     int j = 0;
/*      */ 
/*  388 */     for (int k = paramInt1; k < i; k++)
/*      */     {
/*  390 */       j = this.m_ucsChar[(paramArrayOfByte[k] & 0xFF)];
/*      */ 
/*  392 */       if (j == this.m_ucsReplacement)
/*      */       {
/*  395 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 154);
/*  396 */         localSQLException.fillInStackTrace();
/*  397 */         throw localSQLException;
/*      */       }
/*      */ 
/*  403 */       if ((j & 0xFFFFFFFF) > 65535L)
/*      */       {
/*  405 */         localStringBuilder.append((char)(j >>> 16));
/*  406 */         localStringBuilder.append((char)(j & 0xFFFF));
/*      */       }
/*      */       else
/*      */       {
/*  410 */         localStringBuilder.append((char)j);
/*      */       }
/*      */     }
/*      */ 
/*  414 */     return localStringBuilder.substring(0, localStringBuilder.length());
/*      */   }
/*      */ 
/*      */   public String toUnicodeStringWithReplacement(byte[] paramArrayOfByte, int paramInt1, int paramInt2)
/*      */   {
/*  427 */     int i = paramInt1 + paramInt2;
/*  428 */     StringBuilder localStringBuilder = new StringBuilder(paramInt2);
/*  429 */     int j = 0;
/*      */ 
/*  433 */     for (int k = paramInt1; k < i; k++)
/*      */     {
/*  435 */       j = this.m_ucsChar[(paramArrayOfByte[k] & 0xFF)];
/*      */ 
/*  437 */       if (j == -1)
/*  438 */         localStringBuilder.append((char)this.m_ucsReplacement);
/*      */       else {
/*  440 */         localStringBuilder.append((char)j);
/*      */       }
/*      */     }
/*  443 */     return localStringBuilder.substring(0, localStringBuilder.length());
/*      */   }
/*      */ 
/*      */   public byte[] toOracleString(String paramString)
/*      */     throws SQLException
/*      */   {
/*  457 */     int i = paramString.length();
/*      */ 
/*  459 */     if (i == 0)
/*      */     {
/*  461 */       return new byte[0];
/*      */     }
/*      */ 
/*  464 */     char[] arrayOfChar = new char[i];
/*      */ 
/*  466 */     paramString.getChars(0, i, arrayOfChar, 0);
/*      */ 
/*  468 */     byte[] arrayOfByte1 = new byte[i * 4];
/*      */ 
/*  470 */     int j = 0;
/*      */ 
/*  472 */     for (int k = 0; k < i; k++)
/*      */     {
/*  474 */       if ((arrayOfChar[k] >= 55296) && (arrayOfChar[k] < 56320))
/*      */       {
/*      */         SQLException localSQLException;
/*  476 */         if ((k + 1 < i) && (arrayOfChar[(k + 1)] >= 56320) && (arrayOfChar[(k + 1)] <= 57343))
/*      */         {
/*  481 */           if (this.noSurrogate)
/*      */           {
/*  484 */             localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 155);
/*  485 */             localSQLException.fillInStackTrace();
/*  486 */             throw localSQLException;
/*      */           }
/*      */ 
/*  491 */           arrayOfByte1[(j++)] = toOracleCharacter(arrayOfChar[k], arrayOfChar[(k + 1)]);
/*      */ 
/*  495 */           k++;
/*      */         }
/*      */         else
/*      */         {
/*  502 */           localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 155);
/*  503 */           localSQLException.fillInStackTrace();
/*  504 */           throw localSQLException;
/*      */         }
/*      */ 
/*      */       }
/*  510 */       else if ((arrayOfChar[k] < '') && (this.strictASCII))
/*      */       {
/*  512 */         arrayOfByte1[(j++)] = ((byte)arrayOfChar[k]);
/*      */       }
/*      */       else {
/*  515 */         arrayOfByte1[(j++)] = toOracleCharacter(arrayOfChar[k]);
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*  520 */     if (j < arrayOfByte1.length)
/*      */     {
/*  524 */       byte[] arrayOfByte2 = new byte[j];
/*      */ 
/*  526 */       System.arraycopy(arrayOfByte1, 0, arrayOfByte2, 0, j);
/*      */ 
/*  528 */       return arrayOfByte2;
/*      */     }
/*      */ 
/*  532 */     return arrayOfByte1;
/*      */   }
/*      */ 
/*      */   public byte[] toOracleStringWithReplacement(String paramString)
/*      */   {
/*  545 */     int i = paramString.length();
/*      */ 
/*  547 */     if (i == 0)
/*      */     {
/*  549 */       return new byte[0];
/*      */     }
/*      */ 
/*  552 */     char[] arrayOfChar = new char[i];
/*      */ 
/*  554 */     paramString.getChars(0, i, arrayOfChar, 0);
/*      */ 
/*  556 */     byte[] arrayOfByte1 = new byte[i * 4];
/*      */ 
/*  558 */     int j = 0;
/*      */ 
/*  560 */     for (int k = 0; k < i; k++)
/*      */     {
/*  562 */       if ((arrayOfChar[k] >= 55296) && (arrayOfChar[k] < 56320))
/*      */       {
/*  564 */         if ((k + 1 < i) && (arrayOfChar[(k + 1)] >= 56320) && (arrayOfChar[(k + 1)] <= 57343))
/*      */         {
/*  569 */           if (this.noSurrogate)
/*      */           {
/*  571 */             arrayOfByte1[(j++)] = this.m_oraCharReplacement;
/*      */           }
/*      */           else
/*      */           {
/*  575 */             arrayOfByte1[(j++)] = toOracleCharacterWithReplacement(arrayOfChar[k], arrayOfChar[(k + 1)]);
/*      */           }
/*      */ 
/*  579 */           k++;
/*      */         }
/*      */         else
/*      */         {
/*  585 */           arrayOfByte1[(j++)] = this.m_oraCharReplacement;
/*      */         }
/*      */ 
/*      */       }
/*  592 */       else if ((arrayOfChar[k] < '') && (this.strictASCII))
/*      */       {
/*  594 */         arrayOfByte1[(j++)] = ((byte)arrayOfChar[k]);
/*      */       }
/*      */       else {
/*  597 */         arrayOfByte1[(j++)] = toOracleCharacterWithReplacement(arrayOfChar[k]);
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*  602 */     if (j < arrayOfByte1.length)
/*      */     {
/*  606 */       byte[] arrayOfByte2 = new byte[j];
/*      */ 
/*  608 */       System.arraycopy(arrayOfByte1, 0, arrayOfByte2, 0, j);
/*      */ 
/*  610 */       return arrayOfByte2;
/*      */     }
/*      */ 
/*  614 */     return arrayOfByte1;
/*      */   }
/*      */ 
/*      */   public void buildUnicodeToOracleMapping()
/*      */   {
/*  649 */     this.m_oraCharLevel1 = new char[256];
/*  650 */     this.m_oraCharSurrogateLevel = null;
/*  651 */     this.m_oraCharLevel2 = null;
/*      */ 
/*  653 */     Vector localVector = new Vector(45055, 12287);
/*  654 */     Hashtable localHashtable1 = new Hashtable();
/*  655 */     Hashtable localHashtable2 = new Hashtable();
/*      */ 
/*  664 */     int i1 = this.m_ucsChar.length;
/*  665 */     int i2 = 0;
/*  666 */     int i3 = 0;
/*      */ 
/*  669 */     for (int i4 = 0; i4 < 256; i4++)
/*      */     {
/*  671 */       this.m_oraCharLevel1[i4] = 65535;
/*      */     }
/*      */     int n;
/*  674 */     for (i4 = 0; i4 < i1; i4++)
/*      */     {
/*  678 */       n = this.m_ucsChar[i4];
/*      */ 
/*  680 */       if (n != -1)
/*      */       {
/*  685 */         localObject1 = new int[2];
/*      */ 
/*  687 */         localObject1[0] = n;
/*  688 */         localObject1[1] = i4;
/*      */ 
/*  690 */         localVector.addElement(localObject1);
/*  691 */         storeMappingRange(n, localHashtable1, localHashtable2);
/*      */       }
/*      */     }
/*  694 */     if (this.extraUnicodeToOracleMapping != null)
/*      */     {
/*  696 */       i1 = this.extraUnicodeToOracleMapping.length;
/*      */ 
/*  698 */       for (i4 = 0; i4 < i1; i4++)
/*      */       {
/*  702 */         n = this.extraUnicodeToOracleMapping[i4][0];
/*      */ 
/*  704 */         storeMappingRange(n, localHashtable1, localHashtable2);
/*      */       }
/*      */     }
/*      */ 
/*  708 */     Object localObject1 = localHashtable1.keys();
/*      */ 
/*  711 */     int i5 = 0;
/*  712 */     int i6 = 0;
/*      */     Object localObject2;
/*      */     char[] arrayOfChar;
/*  714 */     while (((Enumeration)localObject1).hasMoreElements())
/*      */     {
/*  716 */       localObject2 = ((Enumeration)localObject1).nextElement();
/*  717 */       arrayOfChar = (char[])localHashtable1.get(localObject2);
/*      */ 
/*  719 */       if (arrayOfChar != null)
/*      */       {
/*  723 */         i5 += 256;
/*      */       }
/*      */     }
/*      */ 
/*  727 */     localObject1 = localHashtable2.keys();
/*      */ 
/*  729 */     while (((Enumeration)localObject1).hasMoreElements())
/*      */     {
/*  731 */       localObject2 = ((Enumeration)localObject1).nextElement();
/*  732 */       arrayOfChar = (char[])localHashtable2.get(localObject2);
/*      */ 
/*  734 */       if (arrayOfChar != null)
/*      */       {
/*  738 */         i6 += 256;
/*      */       }
/*      */     }
/*      */ 
/*  742 */     if (i5 != 0)
/*      */     {
/*  744 */       this.m_oraCharSurrogateLevel = new char[i5];
/*      */     }
/*      */ 
/*  747 */     if (i6 != 0)
/*      */     {
/*  749 */       this.m_oraCharLevel2 = new char[i6 + 256];
/*      */     }
/*      */ 
/*  752 */     for (i4 = 0; i4 < i5; i4++)
/*      */     {
/*  754 */       this.m_oraCharSurrogateLevel[i4] = 65535;
/*      */     }
/*      */ 
/*  757 */     for (i4 = 0; i4 < i6 + 256; i4++)
/*      */     {
/*  759 */       this.m_oraCharLevel2[i4] = 65535;
/*      */     }
/*      */     int i;
/*      */     int j;
/*      */     int k;
/*      */     int m;
/*  762 */     for (i4 = 0; i4 < localVector.size(); i4++)
/*      */     {
/*  764 */       int[] arrayOfInt = (int[])localVector.elementAt(i4);
/*      */ 
/*  766 */       i = arrayOfInt[0] >> 24 & 0xFF;
/*  767 */       j = arrayOfInt[0] >> 16 & 0xFF;
/*  768 */       k = arrayOfInt[0] >> 8 & 0xFF;
/*  769 */       m = arrayOfInt[0] & 0xFF;
/*      */ 
/*  771 */       if ((i >= 216) && (i < 220))
/*      */       {
/*  773 */         if (this.m_oraCharLevel1[i] == 65535)
/*      */         {
/*  775 */           this.m_oraCharLevel1[i] = i3;
/*  776 */           i3 = (char)(i3 + 256);
/*      */         }
/*      */ 
/*  779 */         if (this.m_oraCharSurrogateLevel[(this.m_oraCharLevel1[i] + j)] == 65535)
/*      */         {
/*  782 */           this.m_oraCharSurrogateLevel[(this.m_oraCharLevel1[i] + j)] = i3;
/*      */ 
/*  784 */           i3 = (char)(i3 + 256);
/*      */         }
/*      */ 
/*  787 */         if (this.m_oraCharSurrogateLevel[(this.m_oraCharSurrogateLevel[(this.m_oraCharLevel1[i] + j)] + k)] == 65535)
/*      */         {
/*  790 */           this.m_oraCharSurrogateLevel[(this.m_oraCharSurrogateLevel[(this.m_oraCharLevel1[i] + j)] + k)] = i2;
/*      */ 
/*  792 */           i2 = (char)(i2 + 256);
/*      */         }
/*      */ 
/*  795 */         if (this.m_oraCharLevel2[(this.m_oraCharSurrogateLevel[(this.m_oraCharSurrogateLevel[(this.m_oraCharLevel1[i] + j)] + k)] + m)] == 65535)
/*      */         {
/*  798 */           this.m_oraCharLevel2[(this.m_oraCharSurrogateLevel[(this.m_oraCharSurrogateLevel[(this.m_oraCharLevel1[i] + j)] + k)] + m)] = ((char)(arrayOfInt[1] & 0xFFFF));
/*      */         }
/*      */ 
/*      */       }
/*      */       else
/*      */       {
/*  809 */         if (this.m_oraCharLevel1[k] == 65535)
/*      */         {
/*  811 */           this.m_oraCharLevel1[k] = i2;
/*  812 */           i2 = (char)(i2 + 256);
/*      */         }
/*      */ 
/*  815 */         if (this.m_oraCharLevel2[(this.m_oraCharLevel1[k] + m)] == 65535)
/*      */         {
/*  818 */           this.m_oraCharLevel2[(this.m_oraCharLevel1[k] + m)] = ((char)(arrayOfInt[1] & 0xFFFF));
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*  829 */     if (this.extraUnicodeToOracleMapping != null)
/*      */     {
/*  831 */       i1 = this.extraUnicodeToOracleMapping.length;
/*      */ 
/*  833 */       for (i4 = 0; i4 < i1; i4++)
/*      */       {
/*  837 */         n = this.extraUnicodeToOracleMapping[i4][0];
/*      */ 
/*  841 */         i = n >>> 24 & 0xFF;
/*  842 */         j = n >>> 16 & 0xFF;
/*  843 */         k = n >>> 8 & 0xFF;
/*  844 */         m = n & 0xFF;
/*      */ 
/*  846 */         if ((i >= 216) && (i < 220))
/*      */         {
/*  848 */           if (this.m_oraCharLevel1[i] == 65535)
/*      */           {
/*  852 */             this.m_oraCharLevel1[i] = i3;
/*  853 */             i3 = (char)(i3 + 256);
/*      */           }
/*      */ 
/*  856 */           if (this.m_oraCharSurrogateLevel[(this.m_oraCharLevel1[i] + j)] == 65535)
/*      */           {
/*  859 */             this.m_oraCharSurrogateLevel[(this.m_oraCharLevel1[i] + j)] = i3;
/*      */ 
/*  861 */             i3 = (char)(i3 + 256);
/*      */           }
/*      */ 
/*  864 */           if (this.m_oraCharSurrogateLevel[(this.m_oraCharSurrogateLevel[(this.m_oraCharLevel1[i] + j)] + k)] == 65535)
/*      */           {
/*  867 */             this.m_oraCharSurrogateLevel[(this.m_oraCharSurrogateLevel[(this.m_oraCharLevel1[i] + j)] + k)] = i2;
/*      */ 
/*  869 */             i2 = (char)(i2 + 256);
/*      */           }
/*      */ 
/*  872 */           this.m_oraCharLevel2[(this.m_oraCharSurrogateLevel[(this.m_oraCharSurrogateLevel[(this.m_oraCharLevel1[i] + j)] + k)] + m)] = ((char)(this.extraUnicodeToOracleMapping[i4][1] & 0xFF));
/*      */         }
/*      */         else
/*      */         {
/*  877 */           if (this.m_oraCharLevel1[k] == 65535)
/*      */           {
/*  879 */             this.m_oraCharLevel1[k] = i2;
/*  880 */             i2 = (char)(i2 + 256);
/*      */           }
/*      */ 
/*  883 */           this.m_oraCharLevel2[(this.m_oraCharLevel1[k] + m)] = ((char)(this.extraUnicodeToOracleMapping[i4][1] & 0xFFFF));
/*      */         }
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*  889 */     if (this.m_oraCharSurrogateLevel == null)
/*  890 */       this.noSurrogate = true;
/*      */     else {
/*  892 */       this.noSurrogate = false;
/*      */     }
/*  894 */     this.strictASCII = true;
/*      */ 
/*  896 */     for (i4 = 0; i4 < 128; i4++)
/*      */     {
/*  898 */       if (this.m_oraCharLevel2[i4] != i4)
/*      */       {
/*  900 */         this.strictASCII = false;
/*      */ 
/*  902 */         break;
/*      */       }
/*      */     }
/*      */ 
/*  906 */     for (i4 = 0; i4 < 256; i4++)
/*      */     {
/*  908 */       if (this.m_oraCharLevel1[i4] == 65535) {
/*  909 */         this.m_oraCharLevel1[i4] = ((char)i6);
/*      */       }
/*      */     }
/*  912 */     this.m_oraCharLevel2Size = i6;
/*      */   }
/*      */ 
/*      */   public void extractCodepoints(Vector paramVector)
/*      */   {
/*  922 */     int i = 0;
/*  923 */     int j = 255;
/*      */ 
/*  926 */     for (int k = i; k <= j; k++)
/*      */     {
/*      */       try
/*      */       {
/*  930 */         int[] arrayOfInt = new int[2];
/*  931 */         arrayOfInt[0] = k;
/*  932 */         arrayOfInt[1] = toUnicode((byte)k);
/*      */ 
/*  936 */         paramVector.addElement(arrayOfInt);
/*      */       }
/*      */       catch (SQLException localSQLException)
/*      */       {
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   public void extractExtraMappings(Vector paramVector)
/*      */   {
/*  953 */     if (this.extraUnicodeToOracleMapping == null)
/*      */     {
/*  955 */       return;
/*      */     }
/*      */ 
/*  960 */     for (int i = 0; i < this.extraUnicodeToOracleMapping.length; i++)
/*      */     {
/*  962 */       int[] arrayOfInt = new int[2];
/*  963 */       arrayOfInt[0] = this.extraUnicodeToOracleMapping[i][0];
/*  964 */       arrayOfInt[1] = this.extraUnicodeToOracleMapping[i][1];
/*      */ 
/*  966 */       paramVector.addElement(arrayOfInt);
/*      */     }
/*      */   }
/*      */ 
/*      */   public boolean hasExtraMappings()
/*      */   {
/*  974 */     return this.extraUnicodeToOracleMapping != null;
/*      */   }
/*      */ 
/*      */   public char getOraChar1ByteRep()
/*      */   {
/*  981 */     return (char)this.m_oraCharReplacement;
/*      */   }
/*      */ 
/*      */   public char getOraChar2ByteRep()
/*      */   {
/*  988 */     return '\000';
/*      */   }
/*      */ 
/*      */   public int getUCS2CharRep()
/*      */   {
/*  995 */     return this.m_ucsReplacement;
/*      */   }
/*      */ 
/*      */   protected OracleConnection getConnectionDuringExceptionHandling()
/*      */   {
/* 1010 */     return null;
/*      */   }
/*      */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.sql.converter.CharacterConverter1Byte
 * JD-Core Version:    0.6.2
 */