/*      */ package oracle.sql;
/*      */ 
/*      */ import java.io.IOException;
/*      */ import java.io.ObjectInputStream;
/*      */ import java.io.ObjectOutputStream;
/*      */ import java.io.PrintStream;
/*      */ import java.io.PrintWriter;
/*      */ import java.io.Serializable;
/*      */ import java.io.StringWriter;
/*      */ import java.lang.reflect.Field;
/*      */ import java.sql.Connection;
/*      */ import java.sql.SQLException;
/*      */ import java.util.Map;
/*      */ import oracle.jdbc.OracleConnectionWrapper;
/*      */ import oracle.jdbc.OracleData;
/*      */ import oracle.jdbc.OracleTypeMetaData.Kind;
/*      */ import oracle.jdbc.driver.DatabaseError;
/*      */ import oracle.jdbc.internal.OracleTypeMetaData;
/*      */ import oracle.jdbc.oracore.OracleNamedType;
/*      */ import oracle.jdbc.oracore.OracleTypeADT;
/*      */ import oracle.jdbc.oracore.OracleTypeCOLLECTION;
/*      */ import oracle.jdbc.oracore.OracleTypeOPAQUE;
/*      */ import oracle.jdbc.oracore.PickleContext;
/*      */ 
/*      */ public class TypeDescriptor
/*      */   implements OracleTypeMetaData, Serializable, ORAData, OracleData
/*      */ {
/*   55 */   public static boolean DEBUG_SERIALIZATION = false;
/*      */   static final long serialVersionUID = 2022598722047823723L;
/*      */   static final int KOIDFLEN = 16;
/*      */   static final short KOTA_TRN = 1;
/*      */   static final short KOTA_PDF = 2;
/*      */   static final short KOTA_ITOID = 4;
/*      */   static final short KOTA_LOB = 8;
/*      */   static final short KOTA_AD = 16;
/*      */   static final short KOTA_NMHSH = 32;
/*      */   static final short KOTA_TEV = 64;
/*      */   static final short KOTA_INH = 128;
/*      */   static final short KOTA_10I = 256;
/*      */   static final short KOTA_RBF = 512;
/*      */   static final short KOTA_HBF = 1024;
/*      */   static final int ANYTYPE_IMAGE_SIZE_TOID = 23;
/*      */   static final int ANYTYPE_IMAGE_SIZE_NO_TOID = 5;
/*      */   static final byte KOTTDOID = 1;
/*      */   static final byte KOTTBOID = 2;
/*      */   static final byte KOTADOID = 3;
/*      */   static final byte KOTREFOID = 4;
/*      */   static final byte KOTMDOID = 5;
/*      */   static final byte KOTMIOID = 6;
/*      */   static final byte KOTEXOID = 7;
/*      */   static final byte KOTDATOID = 8;
/*      */   static final byte KOTBYTOID = 9;
/*      */   static final byte KOTSHOOID = 10;
/*      */   static final byte KOTLONOID = 11;
/*      */   static final byte KOTREAOID = 12;
/*      */   static final byte KOTDOUOID = 13;
/*      */   static final byte KOTFLOOID = 14;
/*      */   static final byte KOTNUMOID = 15;
/*      */   static final byte KOTDECOID = 16;
/*      */   static final byte KOTUBYOID = 17;
/*      */   static final byte KOTUSHOID = 18;
/*      */   static final byte KOTULOOID = 19;
/*      */   static final byte KOTOCTOID = 20;
/*      */   static final byte KOTSMLOID = 21;
/*      */   static final byte KOTINTOID = 22;
/*      */   static final byte KOTRAWOID = 23;
/*      */   static final byte KOTPTROID = 24;
/*      */   static final byte KOTVSIOID = 25;
/*      */   static final byte KOTFSIOID = 26;
/*      */   static final byte KOTVSOOID = 27;
/*      */   static final byte KOTMLSOID = 28;
/*      */   static final byte KOTVAROID = 29;
/*      */   static final byte KOTMSTOID = 30;
/*      */   static final byte KOTNATOID = 31;
/*      */   static final byte KOTDOMOID = 32;
/*      */   static final byte KOTUND1OID = 33;
/*      */   static final byte KOTCLBOID = 34;
/*      */   static final byte KOTBLBOID = 35;
/*      */   static final byte KOTCFLOID = 36;
/*      */   static final byte KOTBFLOID = 37;
/*      */   static final byte KOTOIDOID = 38;
/*      */   static final byte KOTCAROID = 39;
/*      */   static final byte KOTCANOID = 40;
/*      */   static final byte KOTLPTOID = 41;
/*      */   static final byte KOTBRIOID = 42;
/*      */   static final byte KOTUCOOID = 43;
/*      */   static final byte KOTRECOID = 44;
/*      */   static final byte KOTRCUOID = 45;
/*      */   static final byte KOTBOOOID = 46;
/*      */   static final byte KOTRIDOID = 47;
/*      */   static final byte KOTPLOOID = 48;
/*      */   static final byte KOTPLROID = 49;
/*      */   static final byte KOTPBIOID = 50;
/*      */   static final byte KOTPINOID = 51;
/*      */   static final byte KOTPNAOID = 52;
/*      */   static final byte KOTPNNOID = 53;
/*      */   static final byte KOTPPOOID = 54;
/*      */   static final byte KOTPPNOID = 55;
/*      */   static final byte KOTPSTOID = 56;
/*      */   static final byte KOTEX1OID = 57;
/*      */   static final byte KOTOPQOID = 58;
/*      */   static final byte KOTTMOID = 59;
/*      */   static final byte KOTTMTZOID = 60;
/*      */   static final byte KOTTSOID = 61;
/*      */   static final byte KOTTSTZOID = 62;
/*      */   static final byte KOTIYMOID = 63;
/*      */   static final byte KOTIDSOID = 64;
/*      */   static final byte KOTTSIMPTZOID = 65;
/*      */   static final byte KOTTBXOID = 66;
/*      */   static final byte KOTADXOID = 67;
/*      */   static final byte KOTOIDBFLT = 68;
/*      */   static final byte KOTOIDBDBL = 69;
/*      */   static final byte KOTURDOID = 70;
/*      */   static final byte KOTLASTOID = 71;
/*  206 */   static final byte[] KOTTDEXTOID = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 1 };
/*      */ 
/*  209 */   static final byte[] KOTTBEXTOID = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 2 };
/*      */ 
/*  212 */   static final byte[] KOTADEXTOID = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 3 };
/*      */ 
/*  215 */   static final byte[] KOTMDEXTOID = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 4 };
/*      */ 
/*  218 */   static final byte[] KOTTBXEXTOID = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 66 };
/*      */ 
/*  221 */   static final byte[] KOTADXEXTOID = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 67 };
/*      */ 
/*  225 */   static final byte[] KOTTDTOID = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 };
/*      */ 
/*  227 */   static final byte[] KOTTBTOID = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2 };
/*      */ 
/*  229 */   static final byte[] KOTADTOID = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 3 };
/*      */ 
/*  231 */   static final byte[] KOTMDTOID = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 5 };
/*      */ 
/*  233 */   static final byte[] KOTMITOID = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 6 };
/*      */ 
/*  235 */   static final byte[] KOTEXTOID = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7 };
/*      */ 
/*  237 */   static final byte[] KOTEX1TOID = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 57 };
/*      */ 
/*  239 */   static final byte[] KOTTBXTOID = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 66 };
/*      */ 
/*  241 */   static final byte[] KOTADXTOID = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 67 };
/*      */ 
/*  244 */   public static final byte[] RAWTOID = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 23 };
/*      */ 
/*  248 */   public static final byte[] ANYTYPETOID = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 16 };
/*      */ 
/*  250 */   public static final byte[] ANYDATATOID = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 17 };
/*      */ 
/*  252 */   public static final byte[] ANYDATASETTOID = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 0, 18 };
/*      */ 
/*  255 */   public static final byte[] XMLTYPETOID = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 1, 0 };
/*      */   static final short SQLT_NONE = 0;
/*      */   static final short SQLT_CHR = 1;
/*      */   static final short SQLT_NUM = 2;
/*      */   static final short SQLT_INT = 3;
/*      */   static final short SQLT_FLT = 4;
/*      */   static final short SQLT_STR = 5;
/*      */   static final short SQLT_VNU = 6;
/*      */   static final short SQLT_PDN = 7;
/*      */   static final short SQLT_LNG = 8;
/*      */   static final short SQLT_VCS = 9;
/*      */   static final short SQLT_NON = 10;
/*      */   static final short SQLT_RID = 11;
/*      */   static final short SQLT_DAT = 12;
/*      */   static final short SQLT_VBI = 15;
/*      */   static final short SQLT_BFLOAT = 21;
/*      */   static final short SQLT_BDOUBLE = 22;
/*      */   static final short SQLT_BIN = 23;
/*      */   static final short SQLT_LBI = 24;
/*      */   static final short SQLT_UIN = 68;
/*      */   static final short SQLT_SLS = 91;
/*      */   static final short SQLT_LVC = 94;
/*      */   static final short SQLT_LVB = 95;
/*      */   static final short SQLT_AFC = 96;
/*      */   static final short SQLT_AVC = 97;
/*      */   static final short SQLT_IBFLOAT = 100;
/*      */   static final short SQLT_IBDOUBLE = 101;
/*      */   static final short SQLT_CUR = 102;
/*      */   static final short SQLT_RDD = 104;
/*      */   static final short SQLT_LAB = 105;
/*      */   static final short SQLT_OSL = 106;
/*      */   static final short SQLT_NTY = 108;
/*      */   static final short SQLT_REF = 110;
/*      */   static final short SQLT_CLOB = 112;
/*      */   static final short SQLT_BLOB = 113;
/*      */   static final short SQLT_BFILEE = 114;
/*      */   static final short SQLT_FILE = 114;
/*      */   static final short SQLT_CFILEE = 115;
/*      */   static final short SQLT_RSET = 116;
/*      */   static final short SQLT_SVT = 118;
/*      */   static final short SQLT_NCO = 122;
/*      */   static final short SQLT_DTR = 152;
/*      */   static final short SQLT_DUN = 153;
/*      */   static final short SQLT_DOP = 154;
/*      */   static final short SQLT_VST = 155;
/*      */   static final short SQLT_ODT = 156;
/*      */   static final short SQLT_DOL = 172;
/*      */   static final short SQLT_DATE = 184;
/*      */   static final short SQLT_TIME = 185;
/*      */   static final short SQLT_TIME_TZ = 186;
/*      */   static final short SQLT_TIMESTAMP = 187;
/*      */   static final short SQLT_TIMESTAMP_TZ = 188;
/*      */   static final short SQLT_INTERVAL_YM = 189;
/*      */   static final short SQLT_INTERVAL_DS = 190;
/*      */   static final short SQLT_TIMESTAMP_LTZ = 232;
/*      */   static final short SQLT_PNTY = 241;
/*      */   static final short SQLT_CFILE = 115;
/*      */   static final short SQLT_BFILE = 114;
/*      */   static final short SQLT_REC = 250;
/*      */   static final short SQLT_TAB = 251;
/*      */   static final short SQLT_BOL = 252;
/*      */   static final short SQLCS_IMPLICIT = 1;
/*      */   static final short SQLCS_NCHAR = 2;
/*      */   static final short SQLCS_EXPLICIT = 3;
/*      */   static final short SQLCS_FLEXIBLE = 4;
/*      */   static final short SQLCS_LIT_NULL = 5;
/*      */   static final short SQLT_XDP = 103;
/*      */   static final short SQLT_OKO = 107;
/*      */   static final short SQLT_INTY = 109;
/*      */   static final short SQLT_IREF = 111;
/*      */   static final short SQLT_DCLOB = 195;
/*      */   public static final short TYPECODE_REF = 110;
/*      */   public static final short TYPECODE_DATE = 12;
/*      */   public static final short TYPECODE_SIGNED8 = 27;
/*      */   public static final short TYPECODE_SIGNED16 = 28;
/*      */   public static final short TYPECODE_SIGNED32 = 29;
/*      */   public static final short TYPECODE_REAL = 21;
/*      */   public static final short TYPECODE_DOUBLE = 22;
/*      */   public static final short TYPECODE_BFLOAT = 100;
/*      */   public static final short TYPECODE_BDOUBLE = 101;
/*      */   public static final short TYPECODE_FLOAT = 4;
/*      */   public static final short TYPECODE_NUMBER = 2;
/*      */   public static final short TYPECODE_DECIMAL = 7;
/*      */   public static final short TYPECODE_UNSIGNED8 = 23;
/*      */   public static final short TYPECODE_UNSIGNED16 = 25;
/*      */   public static final short TYPECODE_UNSIGNED32 = 26;
/*      */   public static final short TYPECODE_OCTET = 245;
/*      */   public static final short TYPECODE_SMALLINT = 246;
/*      */   public static final short TYPECODE_INTEGER = 3;
/*      */   public static final short TYPECODE_RAW = 95;
/*      */   public static final short TYPECODE_PTR = 32;
/*      */   public static final short TYPECODE_VARCHAR2 = 9;
/*      */   public static final short TYPECODE_CHAR = 96;
/*      */   public static final short TYPECODE_VARCHAR = 1;
/*      */   public static final short TYPECODE_MLSLABEL = 105;
/*      */   public static final short TYPECODE_VARRAY = 247;
/*      */   public static final short TYPECODE_TABLE = 248;
/*      */   public static final short TYPECODE_OBJECT = 108;
/*      */   public static final short TYPECODE_OPAQUE = 58;
/*      */   public static final short TYPECODE_NAMEDCOLLECTION = 122;
/*      */   public static final short TYPECODE_BLOB = 113;
/*      */   public static final short TYPECODE_BFILE = 114;
/*      */   public static final short TYPECODE_CLOB = 112;
/*      */   public static final short TYPECODE_CFILE = 115;
/*      */   public static final short TYPECODE_TIME = 185;
/*      */   public static final short TYPECODE_TIME_TZ = 186;
/*      */   public static final short TYPECODE_TIMESTAMP = 187;
/*      */   public static final short TYPECODE_TIMESTAMP_TZ = 188;
/*      */   public static final short TYPECODE_TIMESTAMP_LTZ = 232;
/*      */   public static final short TYPECODE_INTERVAL_YM = 189;
/*      */   public static final short TYPECODE_INTERVAL_DS = 190;
/*      */   public static final short TYPECODE_UROWID = 104;
/*      */   public static final short TYPECODE_OTMFIRST = 228;
/*      */   public static final short TYPECODE_OTMLAST = 320;
/*      */   public static final short TYPECODE_SYSFIRST = 228;
/*      */   public static final short TYPECODE_SYSLAST = 235;
/*      */   public static final short TYPECODE_PLS_INTEGER = 266;
/*      */   public static final short TYPECODE_ITABLE = 251;
/*      */   public static final short TYPECODE_RECORD = 250;
/*      */   public static final short TYPECODE_BOOLEAN = 252;
/*      */   public static final short TYPECODE_NCHAR = 286;
/*      */   public static final short TYPECODE_NVARCHAR2 = 287;
/*      */   public static final short TYPECODE_NCLOB = 288;
/*      */   public static final short TYPECODE_NONE = 0;
/*      */   public static final short TYPECODE_ERRHP = 283;
/*      */   public static final short TYPECODE_JDBC_JOBJECT = 2000;
/*      */   public static final short TYPECODE_JDBC_STRUCT = 2002;
/*      */   public static final short TYPECODE_JDBC_ARRAY = 2003;
/*      */   public static final short TYPECODE_JDBC_JOPAQUE = 2000;
/*      */   public static final short TYPECODE_JDBC_REF = 2006;
/*      */   public static final short TYPECODE_JDBC_JSTRUCT = 2008;
/*      */   public static final short TYPECODE_SQLXML = 2009;
/*      */   private static final short TYPECODE_MAXVALUE = 2009;
/*  432 */   static final short[] OID_TO_TYPECODE = new short[71];
/*      */   SQLName sqlName;
/*      */   OracleNamedType pickler;
/*      */   transient oracle.jdbc.internal.OracleConnection connection;
/*      */   short internalTypeCode;
/*  510 */   boolean isTransient = false;
/*  511 */   byte[] toid = null;
/*  512 */   int toidVersion = 1;
/*      */   long precision;
/*      */   byte scale;
/*  518 */   byte[] transientImage = null;
/*      */ 
/*  522 */   AttributeDescriptor[] attributesDescriptor = null;
/*      */ 
/*  524 */   transient Boolean isInstanciable = null;
/*  525 */   transient String supertype = null;
/*  526 */   transient int numLocalAttrs = -1;
/*  527 */   transient String[] subtypes = null;
/*  528 */   transient String[] attrJavaNames = null;
/*      */   String typeNameByUser;
/*      */   private static String[] typeCodeTypeNameMap;
/*      */   protected Object acProxy;
/* 1690 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*      */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*      */   public static final boolean TRACE = false;
/*      */ 
/*      */   void copyDescriptor(TypeDescriptor paramTypeDescriptor)
/*      */   {
/*  534 */     if (paramTypeDescriptor.sqlName != null) this.sqlName = paramTypeDescriptor.sqlName;
/*  535 */     this.pickler = paramTypeDescriptor.pickler;
/*  536 */     this.connection = paramTypeDescriptor.connection;
/*  537 */     this.internalTypeCode = paramTypeDescriptor.internalTypeCode;
/*  538 */     this.isTransient = paramTypeDescriptor.isTransient;
/*  539 */     this.toid = paramTypeDescriptor.toid;
/*  540 */     this.toidVersion = paramTypeDescriptor.toidVersion;
/*  541 */     this.precision = paramTypeDescriptor.precision;
/*  542 */     this.scale = paramTypeDescriptor.scale;
/*  543 */     this.transientImage = paramTypeDescriptor.transientImage;
/*  544 */     this.attributesDescriptor = paramTypeDescriptor.attributesDescriptor;
/*  545 */     this.isInstanciable = paramTypeDescriptor.isInstanciable;
/*  546 */     this.supertype = paramTypeDescriptor.supertype;
/*  547 */     this.numLocalAttrs = paramTypeDescriptor.numLocalAttrs;
/*  548 */     this.subtypes = paramTypeDescriptor.subtypes;
/*  549 */     this.attrJavaNames = paramTypeDescriptor.attrJavaNames;
/*  550 */     if (paramTypeDescriptor.typeNameByUser != null) this.typeNameByUser = paramTypeDescriptor.typeNameByUser;
/*      */   }
/*      */ 
/*      */   protected TypeDescriptor(short paramShort)
/*      */   {
/*  558 */     this.internalTypeCode = paramShort;
/*      */   }
/*      */ 
/*      */   protected TypeDescriptor(short paramShort, String paramString, Connection paramConnection)
/*      */     throws SQLException
/*      */   {
/*  565 */     this.internalTypeCode = paramShort;
/*      */ 
/*  567 */     if ((paramString == null) || (paramConnection == null))
/*      */     {
/*  571 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 60, "Invalid arguments");
/*  572 */       localSQLException.fillInStackTrace();
/*  573 */       throw localSQLException;
/*      */     }
/*      */ 
/*  577 */     setPhysicalConnectionOf(paramConnection);
/*      */ 
/*  579 */     this.typeNameByUser = paramString;
/*      */   }
/*      */ 
/*      */   protected TypeDescriptor(short paramShort, SQLName paramSQLName, Connection paramConnection)
/*      */     throws SQLException
/*      */   {
/*  586 */     this.internalTypeCode = paramShort;
/*  587 */     if ((paramSQLName == null) || (paramConnection == null))
/*      */     {
/*  591 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 60, "Invalid arguments");
/*  592 */       localSQLException.fillInStackTrace();
/*  593 */       throw localSQLException;
/*      */     }
/*      */ 
/*  597 */     this.sqlName = paramSQLName;
/*  598 */     this.typeNameByUser = this.sqlName.getName();
/*      */ 
/*  600 */     setPhysicalConnectionOf(paramConnection);
/*      */   }
/*      */ 
/*      */   protected TypeDescriptor(short paramShort, SQLName paramSQLName, OracleTypeADT paramOracleTypeADT, Connection paramConnection)
/*      */     throws SQLException
/*      */   {
/*  609 */     this.internalTypeCode = paramShort;
/*  610 */     if ((paramSQLName == null) || (paramOracleTypeADT == null))
/*      */     {
/*  614 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 60, "Invalid arguments");
/*  615 */       localSQLException.fillInStackTrace();
/*  616 */       throw localSQLException;
/*      */     }
/*      */ 
/*  620 */     this.sqlName = paramSQLName;
/*  621 */     this.typeNameByUser = this.sqlName.getName();
/*  622 */     if (paramConnection != null) {
/*  623 */       setPhysicalConnectionOf(paramConnection);
/*      */     }
/*  625 */     this.pickler = paramOracleTypeADT;
/*      */ 
/*  627 */     this.pickler.setDescriptor(this);
/*      */ 
/*  629 */     this.toid = paramOracleTypeADT.getTOID();
/*      */   }
/*      */ 
/*      */   protected TypeDescriptor(short paramShort, OracleTypeADT paramOracleTypeADT, Connection paramConnection)
/*      */     throws SQLException
/*      */   {
/*  639 */     this.internalTypeCode = paramShort;
/*  640 */     if ((paramOracleTypeADT == null) || (paramConnection == null))
/*      */     {
/*  644 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 60, "Invalid arguments");
/*  645 */       localSQLException.fillInStackTrace();
/*  646 */       throw localSQLException;
/*      */     }
/*      */ 
/*  650 */     setPhysicalConnectionOf(paramConnection);
/*      */ 
/*  652 */     this.sqlName = null;
/*  653 */     this.pickler = paramOracleTypeADT;
/*  654 */     this.pickler.setDescriptor(this);
/*  655 */     this.toid = paramOracleTypeADT.getTOID();
/*      */   }
/*      */ 
/*      */   public OracleTypeMetaData.Kind getKind()
/*      */   {
/*  672 */     return OracleTypeMetaData.Kind.TYPE;
/*      */   }
/*      */ 
/*      */   public String getName()
/*      */     throws SQLException
/*      */   {
/*  687 */     if (this.sqlName == null)
/*  688 */       synchronized (this.connection) {
/*  689 */         initSQLName();
/*      */       }
/*  691 */     ??? = null;
/*      */ 
/*  694 */     if (this.sqlName != null)
/*  695 */       ??? = this.sqlName.getName();
/*  696 */     return ???;
/*      */   }
/*      */ 
/*      */   public SQLName getSQLName()
/*      */     throws SQLException
/*      */   {
/*  706 */     synchronized (this.connection)
/*      */     {
/*  713 */       if (this.sqlName == null) {
/*  714 */         initSQLName();
/*      */       }
/*  716 */       return this.sqlName;
/*      */     }
/*      */   }
/*      */ 
/*      */   void initSQLName()
/*      */     throws SQLException
/*      */   {
/*  725 */     if (!this.isTransient)
/*      */     {
/*      */       Object localObject;
/*  727 */       if (this.connection == null)
/*      */       {
/*  731 */         localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 1);
/*  732 */         ((SQLException)localObject).fillInStackTrace();
/*  733 */         throw ((Throwable)localObject);
/*      */       }
/*      */ 
/*  737 */       if (this.pickler != null) {
/*  738 */         this.sqlName = new SQLName(this.pickler.getFullName(), this.connection);
/*      */       }
/*  740 */       else if (this.typeNameByUser != null) {
/*  741 */         this.sqlName = new SQLName(this.typeNameByUser, this.connection);
/*      */       }
/*  743 */       else if (this.toid != null)
/*      */       {
/*  746 */         localObject = OracleTypeADT.toid2typename(this.connection, this.toid);
/*      */ 
/*  748 */         this.typeNameByUser = ((String)localObject);
/*  749 */         this.sqlName = new SQLName((String)localObject, this.connection);
/*      */ 
/*  753 */         TypeDescriptor localTypeDescriptor = null;
/*  754 */         String str = this.sqlName.getName();
/*  755 */         localTypeDescriptor = (TypeDescriptor)this.connection.getDescriptor(str);
/*      */ 
/*  759 */         if (localTypeDescriptor != null)
/*  760 */           copyDescriptor(localTypeDescriptor);
/*      */       }
/*  762 */       else if ((this.internalTypeCode == 108) || (this.internalTypeCode == 122))
/*      */       {
/*  766 */         localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 1);
/*  767 */         ((SQLException)localObject).fillInStackTrace();
/*  768 */         throw ((Throwable)localObject);
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   public String getSchemaName()
/*      */     throws SQLException
/*      */   {
/*  786 */     String str = null;
/*  787 */     if (this.sqlName == null)
/*  788 */       initSQLName();
/*  789 */     if (this.sqlName != null)
/*  790 */       str = this.sqlName.getSchema();
/*  791 */     return str;
/*      */   }
/*      */ 
/*      */   public String getTypeName()
/*      */     throws SQLException
/*      */   {
/*  802 */     String str = null;
/*  803 */     if (this.sqlName == null)
/*  804 */       initSQLName();
/*  805 */     if (this.sqlName != null)
/*  806 */       str = this.sqlName.getSimpleName();
/*  807 */     return str;
/*      */   }
/*      */ 
/*      */   public OracleNamedType getPickler()
/*      */   {
/*  818 */     return this.pickler;
/*      */   }
/*      */ 
/*      */   public oracle.jdbc.internal.OracleConnection getInternalConnection()
/*      */   {
/*  831 */     return this.connection;
/*      */   }
/*      */ 
/*      */   public void setPhysicalConnectionOf(Connection paramConnection)
/*      */   {
/*  844 */     this.connection = ((oracle.jdbc.OracleConnection)paramConnection).physicalConnectionWithin();
/*      */   }
/*      */ 
/*      */   public int getTypeCode()
/*      */     throws SQLException
/*      */   {
/*  856 */     return this.internalTypeCode;
/*      */   }
/*      */ 
/*      */   public String getTypeCodeName()
/*      */     throws SQLException
/*      */   {
/*  865 */     return getTypeCodeTypeNameMap()[getTypeCode()];
/*      */   }
/*      */ 
/*      */   private static String[] getTypeCodeTypeNameMap()
/*      */     throws SQLException
/*      */   {
/*  873 */     if (typeCodeTypeNameMap == null)
/*      */     {
/*  875 */       String[] arrayOfString = new String[2010];
/*      */ 
/*  877 */       Class localClass = null;
/*      */       try
/*      */       {
/*  880 */         localClass = Class.forName("oracle.sql.TypeDescriptor");
/*      */       }
/*      */       catch (ClassNotFoundException localClassNotFoundException)
/*      */       {
/*  887 */         SQLException localSQLException1 = DatabaseError.createSqlException(null, 1, "TypeDescriptor.getTypeCodeName: got a ClassNotFoundException: " + localClassNotFoundException.getMessage());
/*  888 */         localSQLException1.fillInStackTrace();
/*  889 */         throw localSQLException1;
/*      */       }
/*      */ 
/*  893 */       Field[] arrayOfField = localClass.getFields();
/*  894 */       for (int i = 0; i < arrayOfField.length; i++) {
/*  895 */         if (arrayOfField[i].getName().startsWith("TYPECODE_")) {
/*      */           try
/*      */           {
/*  898 */             arrayOfString[arrayOfField[i].getInt(null)] = arrayOfField[i].getName();
/*      */           }
/*      */           catch (Exception localException)
/*      */           {
/*  903 */             SQLException localSQLException2 = DatabaseError.createSqlException(null, 1, "TypeDescriptor.getTypeCodeName: " + localException.getMessage());
/*  904 */             localSQLException2.fillInStackTrace();
/*  905 */             throw localSQLException2;
/*      */           }
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*  911 */       typeCodeTypeNameMap = arrayOfString;
/*      */     }
/*  913 */     return typeCodeTypeNameMap;
/*      */   }
/*      */ 
/*      */   public short getInternalTypeCode()
/*      */     throws SQLException
/*      */   {
/*  936 */     return this.internalTypeCode;
/*      */   }
/*      */ 
/*      */   public static TypeDescriptor getTypeDescriptor(String paramString, oracle.jdbc.OracleConnection paramOracleConnection)
/*      */     throws SQLException
/*      */   {
/*  961 */     Object localObject1 = null;
/*      */     try
/*      */     {
/*  967 */       SQLName localSQLName = new SQLName(paramString, paramOracleConnection);
/*  968 */       localObject2 = localSQLName.getName();
/*      */ 
/*  971 */       localObject1 = (TypeDescriptor)paramOracleConnection.getDescriptor((String)localObject2);
/*      */ 
/*  973 */       if (localObject1 == null)
/*      */       {
/*  977 */         OracleTypeADT localOracleTypeADT = new OracleTypeADT(paramString, paramOracleConnection);
/*  978 */         oracle.jdbc.internal.OracleConnection localOracleConnection = (oracle.jdbc.internal.OracleConnection)paramOracleConnection;
/*      */ 
/*  981 */         localOracleTypeADT.init(localOracleConnection);
/*      */ 
/*  983 */         OracleNamedType localOracleNamedType = localOracleTypeADT.cleanup();
/*      */ 
/*  986 */         switch (localOracleNamedType.getTypeCode())
/*      */         {
/*      */         case 2002:
/*      */         case 2008:
/*  992 */           localObject1 = new StructDescriptor(localSQLName, (OracleTypeADT)localOracleNamedType, paramOracleConnection);
/*      */ 
/*  995 */           break;
/*      */         case 2003:
/*  998 */           localObject1 = new ArrayDescriptor(localSQLName, (OracleTypeCOLLECTION)localOracleNamedType, paramOracleConnection);
/*      */ 
/* 1002 */           break;
/*      */         case 2007:
/* 1005 */           localObject1 = new OpaqueDescriptor(localSQLName, (OracleTypeOPAQUE)localOracleNamedType, paramOracleConnection);
/*      */ 
/* 1008 */           break;
/*      */         case 2004:
/*      */         case 2005:
/*      */         case 2006:
/*      */         default:
/* 1013 */           SQLException localSQLException = DatabaseError.createSqlException(null, 1);
/* 1014 */           localSQLException.fillInStackTrace();
/* 1015 */           throw localSQLException;
/*      */         }
/*      */ 
/* 1020 */         paramOracleConnection.putDescriptor((String)localObject2, localObject1);
/*      */ 
/* 1023 */         localOracleNamedType.setDescriptor((TypeDescriptor)localObject1);
/*      */       }
/*      */ 
/*      */     }
/*      */     catch (Exception localException)
/*      */     {
/* 1030 */       if ((localException instanceof SQLException))
/*      */       {
/* 1032 */         localObject2 = DatabaseError.createSqlException(null, (SQLException)localException, 60, "Unable to resolve type \"" + paramString + "\"");
/*      */ 
/* 1034 */         ((SQLException)localObject2).fillInStackTrace();
/* 1035 */         throw ((Throwable)localObject2);
/*      */       }
/*      */ 
/* 1039 */       Object localObject2 = DatabaseError.createSqlException(null, 60, "Unable to resolve type \"" + paramString + "\"");
/*      */ 
/* 1041 */       ((SQLException)localObject2).fillInStackTrace();
/* 1042 */       throw ((Throwable)localObject2);
/*      */     }
/*      */ 
/* 1045 */     return localObject1;
/*      */   }
/*      */ 
/*      */   public static TypeDescriptor getTypeDescriptor(String paramString, oracle.jdbc.OracleConnection paramOracleConnection, byte[] paramArrayOfByte, long paramLong)
/*      */     throws SQLException
/*      */   {
/* 1070 */     Object localObject = null;
/*      */ 
/* 1073 */     String str = getSubtypeName(paramOracleConnection, paramArrayOfByte, paramLong);
/*      */ 
/* 1075 */     if (str == null) {
/* 1076 */       str = paramString;
/*      */     }
/*      */ 
/* 1080 */     localObject = (TypeDescriptor)paramOracleConnection.getDescriptor(str);
/*      */ 
/* 1082 */     if (localObject == null)
/*      */     {
/* 1087 */       SQLName localSQLName = new SQLName(str, paramOracleConnection);
/*      */ 
/* 1090 */       OracleTypeADT localOracleTypeADT = new OracleTypeADT(str, paramOracleConnection);
/* 1091 */       oracle.jdbc.internal.OracleConnection localOracleConnection = (oracle.jdbc.internal.OracleConnection)paramOracleConnection;
/*      */ 
/* 1094 */       localOracleTypeADT.init(localOracleConnection);
/*      */ 
/* 1096 */       OracleNamedType localOracleNamedType = localOracleTypeADT.cleanup();
/*      */ 
/* 1099 */       switch (localOracleNamedType.getTypeCode())
/*      */       {
/*      */       case 2002:
/*      */       case 2008:
/* 1105 */         localObject = new StructDescriptor(localSQLName, (OracleTypeADT)localOracleNamedType, paramOracleConnection);
/*      */ 
/* 1108 */         break;
/*      */       case 2003:
/* 1111 */         localObject = new ArrayDescriptor(localSQLName, (OracleTypeCOLLECTION)localOracleNamedType, paramOracleConnection);
/*      */ 
/* 1114 */         break;
/*      */       case 2007:
/* 1117 */         localObject = new OpaqueDescriptor(localSQLName, (OracleTypeOPAQUE)localOracleNamedType, paramOracleConnection);
/*      */ 
/* 1120 */         break;
/*      */       case 2004:
/*      */       case 2005:
/*      */       case 2006:
/*      */       default:
/* 1126 */         SQLException localSQLException = DatabaseError.createSqlException(null, 1);
/* 1127 */         localSQLException.fillInStackTrace();
/* 1128 */         throw localSQLException;
/*      */       }
/*      */ 
/* 1133 */       paramOracleConnection.putDescriptor(str, localObject);
/*      */     }
/* 1135 */     return localObject;
/*      */   }
/*      */ 
/*      */   public Datum toDatum(Connection paramConnection)
/*      */     throws SQLException
/*      */   {
/* 1148 */     if (((paramConnection instanceof OracleConnectionWrapper)) && (!(paramConnection instanceof oracle.jdbc.driver.OracleConnection)))
/*      */     {
/* 1151 */       this.connection = ((oracle.jdbc.internal.OracleConnection)((OracleConnectionWrapper)paramConnection).unwrap());
/*      */     }
/*      */     else
/*      */     {
/* 1156 */       this.connection = ((oracle.jdbc.internal.OracleConnection)paramConnection);
/*      */     }
/* 1158 */     OpaqueDescriptor localOpaqueDescriptor = OpaqueDescriptor.createDescriptor("SYS.ANYTYPE", paramConnection);
/*      */ 
/* 1160 */     byte[] arrayOfByte = new byte[getOpaqueImageTypeSize()];
/* 1161 */     pickleOpaqueTypeImage(arrayOfByte, 0, false);
/* 1162 */     OPAQUE localOPAQUE = new OPAQUE(localOpaqueDescriptor, this.connection, arrayOfByte);
/* 1163 */     localOPAQUE.setShareBytes(localOPAQUE.toBytes());
/* 1164 */     return localOPAQUE;
/*      */   }
/*      */ 
/*      */   public Object toJDBCObject(Connection paramConnection)
/*      */     throws SQLException
/*      */   {
/* 1171 */     return toDatum(paramConnection);
/*      */   }
/*      */ 
/*      */   static TypeDescriptor unpickleOpaqueTypeImage(PickleContext paramPickleContext, Connection paramConnection, short[] paramArrayOfShort)
/*      */     throws SQLException
/*      */   {
/* 1190 */     byte[] arrayOfByte1 = null;
/*      */ 
/* 1192 */     Object localObject1 = null;
/*      */ 
/* 1196 */     int k = paramPickleContext.offset();
/* 1197 */     byte[] arrayOfByte2 = paramPickleContext.image();
/*      */ 
/* 1200 */     paramPickleContext.skipBytes(1);
/* 1201 */     int i = (short)paramPickleContext.readUB2();
/* 1202 */     paramArrayOfShort[0] = ((short)paramPickleContext.readUB2());
/*      */     Object localObject2;
/* 1204 */     if ((i & 0x20) != 0)
/*      */     {
/* 1212 */       localObject2 = DatabaseError.createSqlException(null, 178);
/* 1213 */       ((SQLException)localObject2).fillInStackTrace();
/* 1214 */       throw ((Throwable)localObject2);
/*      */     }
/*      */     Object localObject3;
/*      */     int m;
/*      */     Object localObject4;
/* 1219 */     if ((i & 0x1) == 0)
/*      */     {
/* 1221 */       if (((i & 0x2) == 0) || (paramArrayOfShort[0] == 110) || (paramArrayOfShort[0] == 58))
/*      */       {
/* 1227 */         arrayOfByte1 = paramPickleContext.readDataValue(16);
/* 1228 */         int j = paramPickleContext.readUB2();
/*      */ 
/* 1231 */         localObject2 = (String)((oracle.jdbc.internal.OracleConnection)paramConnection).getDescriptor(arrayOfByte1);
/* 1232 */         localObject1 = (TypeDescriptor)((oracle.jdbc.internal.OracleConnection)paramConnection).getDescriptor((String)localObject2);
/* 1233 */         if (localObject1 == null)
/*      */         {
/* 1235 */           if (paramArrayOfShort[0] == 122) {
/* 1236 */             localObject1 = new ArrayDescriptor(arrayOfByte1, j, paramConnection);
/* 1237 */           } else if ((paramArrayOfShort[0] == 108) || (paramArrayOfShort[0] == 110)) {
/* 1238 */             localObject1 = new StructDescriptor(arrayOfByte1, j, paramConnection);
/* 1239 */           } else if (paramArrayOfShort[0] == 58) {
/* 1240 */             localObject1 = new OpaqueDescriptor(arrayOfByte1, j, paramConnection);
/*      */           }
/*      */           else {
/* 1243 */             localObject3 = DatabaseError.createSqlException(null, 178);
/* 1244 */             ((SQLException)localObject3).fillInStackTrace();
/* 1245 */             throw ((Throwable)localObject3);
/*      */           }
/*      */ 
/*      */         }
/*      */ 
/*      */       }
/*      */       else
/*      */       {
/* 1253 */         localObject1 = new TypeDescriptor(paramArrayOfShort[0]);
/*      */       }
/* 1255 */       ((TypeDescriptor)localObject1).setTransient(false);
/*      */     }
/*      */     else
/*      */     {
/* 1264 */       m = (int)paramPickleContext.readUB4();
/* 1265 */       if (paramArrayOfShort[0] == 108)
/*      */       {
/* 1267 */         localObject3 = null;
/* 1268 */         if (m > 0)
/*      */         {
/* 1270 */           localObject3 = new AttributeDescriptor[m];
/* 1271 */           for (int i1 = 0; i1 < m; i1++)
/*      */           {
/* 1273 */             int i2 = paramPickleContext.readByte();
/* 1274 */             localObject3[i1] = Kotad.unpickleAttributeImage(i2 == 2 ? 1 : false, paramPickleContext);
/* 1275 */             if (i2 != 2)
/*      */             {
/* 1277 */               short[] arrayOfShort = new short[1];
/* 1278 */               localObject3[i1].setTypeDescriptor(unpickleOpaqueTypeImage(paramPickleContext, paramConnection, arrayOfShort));
/*      */             }
/*      */           }
/*      */         }
/*      */ 
/* 1283 */         localObject1 = new StructDescriptor((AttributeDescriptor[])localObject3, paramConnection);
/*      */       }
/* 1285 */       else if (m == 1)
/*      */       {
/* 1287 */         int n = paramPickleContext.readByte();
/* 1288 */         localObject1 = Kotad.unpickleTypeDescriptorImage(paramPickleContext);
/*      */       }
/*      */       else
/*      */       {
/* 1293 */         localObject4 = DatabaseError.createSqlException(null, 178);
/* 1294 */         ((SQLException)localObject4).fillInStackTrace();
/* 1295 */         throw ((Throwable)localObject4);
/*      */       }
/*      */ 
/* 1298 */       ((TypeDescriptor)localObject1).setTransient(true);
/*      */     }
/*      */ 
/* 1301 */     if (((TypeDescriptor)localObject1).isTransient())
/*      */     {
/* 1304 */       m = paramPickleContext.offset();
/* 1305 */       localObject4 = new byte[m - k];
/* 1306 */       System.arraycopy(arrayOfByte2, k, localObject4, 0, localObject4.length);
/* 1307 */       ((TypeDescriptor)localObject1).setTransientImage((byte[])localObject4);
/*      */     }
/*      */ 
/* 1310 */     return localObject1;
/*      */   }
/*      */ 
/*      */   void setTransientImage(byte[] paramArrayOfByte)
/*      */   {
/* 1316 */     this.transientImage = paramArrayOfByte;
/*      */   }
/*      */ 
/*      */   void setTransient(boolean paramBoolean)
/*      */   {
/* 1323 */     this.isTransient = paramBoolean;
/*      */   }
/*      */ 
/*      */   public boolean isTransient()
/*      */   {
/* 1329 */     return this.isTransient;
/*      */   }
/*      */ 
/*      */   int getOpaqueImageTypeSize()
/*      */   {
/* 1336 */     int i = 0;
/* 1337 */     if (this.isTransient) {
/* 1338 */       i = this.transientImage.length;
/*      */     }
/*      */     else {
/* 1341 */       i = 5;
/* 1342 */       if ((this.toid != null) && (this.toid.length == 16))
/* 1343 */         i = 23;
/*      */     }
/* 1345 */     return i;
/*      */   }
/*      */ 
/*      */   int pickleOpaqueTypeImage(byte[] paramArrayOfByte, int paramInt, boolean paramBoolean)
/*      */   {
/* 1359 */     if (this.isTransient)
/*      */     {
/* 1361 */       System.arraycopy(this.transientImage, 0, paramArrayOfByte, paramInt, this.transientImage.length);
/* 1362 */       paramInt += this.transientImage.length;
/*      */     }
/*      */     else
/*      */     {
/* 1367 */       int i = 0;
/* 1368 */       if ((this.toid != null) && (this.toid.length == 16))
/* 1369 */         i = 1;
/* 1370 */       paramArrayOfByte[(paramInt++)] = 1;
/* 1371 */       int j = this.internalTypeCode;
/* 1372 */       if (paramBoolean)
/* 1373 */         j = 110;
/* 1374 */       int k = 512;
/* 1375 */       if ((j != 108) && (j != 122))
/*      */       {
/* 1377 */         k |= 2;
/* 1378 */       }if ((i != 0) && (j != 110))
/* 1379 */         k |= 4;
/* 1380 */       paramArrayOfByte[(paramInt++)] = ((byte)((k & 0xFF00) >> 8 & 0xFF));
/* 1381 */       paramArrayOfByte[(paramInt++)] = ((byte)(k & 0xFF));
/* 1382 */       paramArrayOfByte[(paramInt++)] = ((byte)((j & 0xFF00) >> 8 & 0xFF));
/* 1383 */       paramArrayOfByte[(paramInt++)] = ((byte)(j & 0xFF));
/* 1384 */       if (i != 0)
/*      */       {
/* 1386 */         System.arraycopy(this.toid, 0, paramArrayOfByte, paramInt, this.toid.length);
/* 1387 */         paramInt += this.toid.length;
/* 1388 */         paramArrayOfByte[(paramInt++)] = ((byte)((this.toidVersion & 0xFF00) >> 8 & 0xFF));
/* 1389 */         paramArrayOfByte[(paramInt++)] = ((byte)(this.toidVersion & 0xFF));
/*      */       }
/*      */     }
/* 1392 */     return paramInt;
/*      */   }
/*      */ 
/*      */   public void setPrecision(long paramLong)
/*      */   {
/* 1399 */     this.precision = paramLong;
/*      */   }
/*      */ 
/*      */   public long getPrecision()
/*      */   {
/* 1405 */     return this.precision;
/*      */   }
/*      */ 
/*      */   public void setScale(byte paramByte)
/*      */   {
/* 1411 */     this.scale = paramByte;
/*      */   }
/*      */ 
/*      */   public byte getScale()
/*      */   {
/* 1417 */     return this.scale;
/*      */   }
/*      */ 
/*      */   public boolean isInHierarchyOf(String paramString)
/*      */     throws SQLException
/*      */   {
/* 1432 */     return false;
/*      */   }
/*      */ 
/*      */   private void writeObject(ObjectOutputStream paramObjectOutputStream)
/*      */     throws IOException
/*      */   {
/*      */     try
/*      */     {
/* 1447 */       if (this.sqlName == null) {
/* 1448 */         initSQLName();
/*      */       }
/*      */     }
/*      */     catch (SQLException localSQLException)
/*      */     {
/* 1453 */       throw new IOException(localSQLException.getMessage());
/*      */     }
/*      */ 
/* 1456 */     paramObjectOutputStream.writeObject(this.sqlName);
/* 1457 */     paramObjectOutputStream.writeObject(this.pickler);
/*      */   }
/*      */ 
/*      */   private void readObject(ObjectInputStream paramObjectInputStream)
/*      */     throws IOException, ClassNotFoundException
/*      */   {
/* 1465 */     this.sqlName = ((SQLName)paramObjectInputStream.readObject());
/* 1466 */     this.pickler = ((OracleNamedType)paramObjectInputStream.readObject());
/*      */   }
/*      */ 
/*      */   public void setConnection(Connection paramConnection)
/*      */     throws SQLException
/*      */   {
/* 1473 */     setPhysicalConnectionOf(paramConnection);
/* 1474 */     this.pickler.setConnection(getInternalConnection());
/*      */   }
/*      */ 
/*      */   public static String getSubtypeName(oracle.jdbc.OracleConnection paramOracleConnection, byte[] paramArrayOfByte, long paramLong)
/*      */     throws SQLException
/*      */   {
/* 1482 */     if ((paramArrayOfByte == null) || (paramArrayOfByte.length == 0) || (paramOracleConnection == null))
/*      */     {
/* 1485 */       localObject = DatabaseError.createSqlException(null, 68, " 'image' should not be empty and 'conn' should not be null. ");
/* 1486 */       ((SQLException)localObject).fillInStackTrace();
/* 1487 */       throw ((Throwable)localObject);
/*      */     }
/*      */ 
/* 1491 */     Object localObject = OracleTypeADT.getSubtypeName(paramOracleConnection, paramArrayOfByte, paramLong);
/*      */ 
/* 1493 */     return localObject;
/*      */   }
/*      */ 
/*      */   public void initMetadataRecursively()
/*      */     throws SQLException
/*      */   {
/* 1501 */     if (this.pickler != null)
/* 1502 */       this.pickler.initMetadataRecursively();
/*      */   }
/*      */ 
/*      */   public void initNamesRecursively()
/*      */     throws SQLException
/*      */   {
/* 1510 */     if (this.pickler != null)
/* 1511 */       this.pickler.initNamesRecursively();
/*      */   }
/*      */ 
/*      */   public void fixupConnection(oracle.jdbc.internal.OracleConnection paramOracleConnection)
/*      */     throws SQLException
/*      */   {
/* 1519 */     if (this.connection == null) this.connection = paramOracleConnection;
/* 1520 */     if (this.pickler != null) this.pickler.fixupConnection(paramOracleConnection);
/*      */   }
/*      */ 
/*      */   public String toXMLString()
/*      */     throws SQLException
/*      */   {
/* 1539 */     return toXMLString(false);
/*      */   }
/*      */ 
/*      */   public String toXMLString(boolean paramBoolean)
/*      */     throws SQLException
/*      */   {
/* 1556 */     StringWriter localStringWriter = new StringWriter();
/* 1557 */     PrintWriter localPrintWriter = new PrintWriter(localStringWriter);
/* 1558 */     printXMLHeader(localPrintWriter);
/* 1559 */     printXML(localPrintWriter, 0, paramBoolean);
/* 1560 */     return localStringWriter.getBuffer().substring(0);
/*      */   }
/*      */ 
/*      */   public void printXML(PrintStream paramPrintStream)
/*      */     throws SQLException
/*      */   {
/* 1574 */     printXML(paramPrintStream, false);
/*      */   }
/*      */ 
/*      */   public void printXML(PrintStream paramPrintStream, boolean paramBoolean)
/*      */     throws SQLException
/*      */   {
/* 1589 */     PrintWriter localPrintWriter = new PrintWriter(paramPrintStream, true);
/* 1590 */     printXMLHeader(localPrintWriter);
/* 1591 */     printXML(localPrintWriter, 0, paramBoolean);
/*      */   }
/*      */ 
/*      */   void printXML(PrintWriter paramPrintWriter, int paramInt, boolean paramBoolean)
/*      */     throws SQLException
/*      */   {
/* 1598 */     String str = tagName();
/* 1599 */     paramPrintWriter.println("<" + str + " sqlName=\"" + getName() + "\" >");
/* 1600 */     if (this.pickler != null) this.pickler.printXML(paramPrintWriter, paramInt + 1, paramBoolean);
/* 1601 */     paramPrintWriter.println("</" + str + ">");
/*      */   }
/*      */ 
/*      */   String tagName()
/*      */   {
/* 1608 */     return "TypeDescriptor";
/*      */   }
/*      */ 
/*      */   void printXMLHeader(PrintWriter paramPrintWriter)
/*      */     throws SQLException
/*      */   {
/* 1615 */     paramPrintWriter.println("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>");
/*      */   }
/*      */ 
/*      */   protected oracle.jdbc.internal.OracleConnection getConnectionDuringExceptionHandling()
/*      */   {
/* 1630 */     return this.connection;
/*      */   }
/*      */ 
/*      */   public Class getClass(Map paramMap)
/*      */     throws SQLException
/*      */   {
/* 1643 */     String str1 = getName();
/*      */ 
/* 1645 */     Class localClass = this.connection.getClassForType(str1, paramMap);
/*      */ 
/* 1647 */     String str2 = getSchemaName();
/* 1648 */     String str3 = getTypeName();
/*      */ 
/* 1651 */     if (localClass == null) {
/* 1652 */       localClass = (Class)paramMap.get(str3);
/*      */     }
/* 1654 */     if (SQLName.s_parseAllFormat) {
/* 1655 */       if (localClass == null)
/*      */       {
/* 1657 */         if (this.connection.getDefaultSchemaNameForNamedTypes().equals(str2))
/* 1658 */           localClass = (Class)paramMap.get("\"" + str3 + "\"");
/*      */       }
/* 1660 */       if (localClass == null)
/*      */       {
/* 1662 */         localClass = (Class)paramMap.get("\"" + str2 + "\"" + "." + "\"" + str3 + "\"");
/*      */       }
/* 1664 */       if (localClass == null)
/*      */       {
/* 1666 */         localClass = (Class)paramMap.get("\"" + str2 + "\"" + "." + str3);
/*      */       }
/* 1668 */       if (localClass == null)
/*      */       {
/* 1670 */         localClass = (Class)paramMap.get(str2 + "." + "\"" + str3 + "\"");
/*      */       }
/*      */     }
/* 1673 */     return localClass;
/*      */   }
/*      */ 
/*      */   public void setACProxy(Object paramObject)
/*      */   {
/* 1681 */     this.acProxy = paramObject;
/*      */   }
/*      */ 
/*      */   public Object getACProxy()
/*      */   {
/* 1686 */     return this.acProxy;
/*      */   }
/*      */ 
/*      */   static
/*      */   {
/*  435 */     OID_TO_TYPECODE[8] = 12;
/*  436 */     OID_TO_TYPECODE[9] = 27;
/*  437 */     OID_TO_TYPECODE[10] = 28;
/*  438 */     OID_TO_TYPECODE[11] = 29;
/*  439 */     OID_TO_TYPECODE[12] = 21;
/*  440 */     OID_TO_TYPECODE[13] = 22;
/*  441 */     OID_TO_TYPECODE[14] = 4;
/*  442 */     OID_TO_TYPECODE[15] = 2;
/*  443 */     OID_TO_TYPECODE[16] = 7;
/*  444 */     OID_TO_TYPECODE[17] = 23;
/*  445 */     OID_TO_TYPECODE[18] = 25;
/*  446 */     OID_TO_TYPECODE[19] = 26;
/*  447 */     OID_TO_TYPECODE[20] = 245;
/*  448 */     OID_TO_TYPECODE[21] = 246;
/*  449 */     OID_TO_TYPECODE[22] = 3;
/*      */ 
/*  451 */     OID_TO_TYPECODE[23] = 95;
/*  452 */     OID_TO_TYPECODE[24] = 32;
/*  453 */     OID_TO_TYPECODE[25] = 9;
/*  454 */     OID_TO_TYPECODE[26] = 96;
/*  455 */     OID_TO_TYPECODE[27] = 1;
/*  456 */     OID_TO_TYPECODE[28] = 105;
/*  457 */     OID_TO_TYPECODE[29] = 247;
/*  458 */     OID_TO_TYPECODE[30] = 248;
/*  459 */     OID_TO_TYPECODE[31] = 108;
/*  460 */     OID_TO_TYPECODE[32] = 0;
/*  461 */     OID_TO_TYPECODE[33] = 0;
/*  462 */     OID_TO_TYPECODE[34] = 112;
/*  463 */     OID_TO_TYPECODE[35] = 113;
/*  464 */     OID_TO_TYPECODE[36] = 115;
/*  465 */     OID_TO_TYPECODE[37] = 114;
/*      */ 
/*  467 */     OID_TO_TYPECODE[38] = 0;
/*  468 */     OID_TO_TYPECODE[39] = 0;
/*  469 */     OID_TO_TYPECODE[40] = 0;
/*  470 */     OID_TO_TYPECODE[41] = 0;
/*  471 */     OID_TO_TYPECODE[42] = 0;
/*  472 */     OID_TO_TYPECODE[43] = 0;
/*  473 */     OID_TO_TYPECODE[44] = 0;
/*  474 */     OID_TO_TYPECODE[45] = 0;
/*      */ 
/*  476 */     OID_TO_TYPECODE[46] = 0;
/*  477 */     OID_TO_TYPECODE[47] = 0;
/*  478 */     OID_TO_TYPECODE[48] = 0;
/*  479 */     OID_TO_TYPECODE[49] = 0;
/*  480 */     OID_TO_TYPECODE[50] = 0;
/*  481 */     OID_TO_TYPECODE[51] = 0;
/*  482 */     OID_TO_TYPECODE[52] = 0;
/*  483 */     OID_TO_TYPECODE[53] = 0;
/*  484 */     OID_TO_TYPECODE[54] = 0;
/*  485 */     OID_TO_TYPECODE[55] = 0;
/*  486 */     OID_TO_TYPECODE[56] = 0;
/*      */ 
/*  488 */     OID_TO_TYPECODE[57] = 0;
/*      */ 
/*  490 */     OID_TO_TYPECODE[58] = 58;
/*      */ 
/*  492 */     OID_TO_TYPECODE[59] = 185;
/*  493 */     OID_TO_TYPECODE[60] = 186;
/*  494 */     OID_TO_TYPECODE[61] = 187;
/*  495 */     OID_TO_TYPECODE[62] = 188;
/*  496 */     OID_TO_TYPECODE[63] = 189;
/*  497 */     OID_TO_TYPECODE[64] = 190;
/*  498 */     OID_TO_TYPECODE[65] = 232;
/*  499 */     OID_TO_TYPECODE[66] = 0;
/*  500 */     OID_TO_TYPECODE[67] = 0;
/*  501 */     OID_TO_TYPECODE[68] = 100;
/*  502 */     OID_TO_TYPECODE[69] = 101;
/*  503 */     OID_TO_TYPECODE[70] = 104;
/*      */ 
/*  868 */     typeCodeTypeNameMap = null;
/*      */     try
/*      */     {
/*  923 */       getTypeCodeTypeNameMap();
/*      */     }
/*      */     catch (Exception localException)
/*      */     {
/*      */     }
/*      */   }
/*      */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.sql.TypeDescriptor
 * JD-Core Version:    0.6.2
 */