/*     */ package oracle.sql;
/*     */ 
/*     */ import java.io.PrintStream;
/*     */ import java.sql.Connection;
/*     */ import java.sql.SQLException;
/*     */ import java.sql.Timestamp;
/*     */ import java.util.Calendar;
/*     */ import java.util.Date;
/*     */ import java.util.HashMap;
/*     */ import java.util.Hashtable;
/*     */ import java.util.Locale;
/*     */ import java.util.TimeZone;
/*     */ 
/*     */ public class TIMEZONETAB
/*     */ {
/*  59 */   private static HashMap<Integer, TIMEZONETAB> instanceCache = null;
/*  60 */   private int instanceCount = 0;
/*  61 */   private int versionNumber = 0;
/*     */ 
/* 583 */   private Hashtable zonetab = new Hashtable();
/*     */ 
/* 586 */   private static int OFFSET_HOUR = 20;
/* 587 */   private static int OFFSET_MINUTE = 60;
/*     */ 
/* 590 */   private static int HOUR_MILLISECOND = 3600000;
/*     */ 
/* 593 */   private static int MINUTE_MILLISECOND = 60000;
/*     */ 
/* 596 */   private static int BYTE_SIZE = 10;
/*     */ 
/*     */   private TIMEZONETAB(int paramInt)
/*     */     throws SQLException
/*     */   {
/*  66 */     this.versionNumber = paramInt;
/*     */   }
/*     */ 
/*     */   public static TIMEZONETAB getInstance(int paramInt)
/*     */     throws SQLException
/*     */   {
/*  73 */     if (instanceCache == null)
/*     */     {
/*  75 */       synchronized (TIMEZONETAB.class) {
/*  76 */         if (instanceCache == null) {
/*  77 */           instanceCache = new HashMap(5);
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/*  82 */     ??? = (TIMEZONETAB)instanceCache.get(Integer.valueOf(paramInt));
/*  83 */     if (??? == null)
/*     */     {
/*  85 */       synchronized (TIMEZONETAB.class) {
/*  86 */         ??? = (TIMEZONETAB)instanceCache.get(Integer.valueOf(paramInt));
/*  87 */         if (??? == null)
/*     */         {
/*  89 */           ??? = new TIMEZONETAB(paramInt);
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/*  94 */     return ((TIMEZONETAB)???).returnInstance();
/*     */   }
/*     */ 
/*     */   private synchronized TIMEZONETAB returnInstance()
/*     */   {
/*  99 */     this.instanceCount += 1;
/* 100 */     instanceCache.put(Integer.valueOf(this.versionNumber), this);
/* 101 */     return this;
/*     */   }
/*     */ 
/*     */   public synchronized void freeInstance()
/*     */     throws SQLException
/*     */   {
/* 107 */     this.instanceCount -= 1;
/* 108 */     if (this.instanceCount < 1)
/* 109 */       instanceCache.remove(Integer.valueOf(this.versionNumber));
/*     */   }
/*     */ 
/*     */   public void addTrans(byte[] paramArrayOfByte, int paramInt)
/*     */   {
/* 124 */     int[] arrayOfInt = new int[BYTE_SIZE];
/*     */ 
/* 126 */     int i = paramArrayOfByte[0] & 0xFF;
/*     */ 
/* 128 */     OffsetDST[] arrayOfOffsetDST = new OffsetDST[i];
/* 129 */     int j = 0;
/*     */ 
/* 132 */     for (int k = 1; k < i * BYTE_SIZE; k += BYTE_SIZE)
/*     */     {
/* 134 */       for (int m = 0; m < BYTE_SIZE; m++) {
/* 135 */         arrayOfInt[m] = (paramArrayOfByte[(m + k)] & 0xFF);
/*     */       }
/*     */ 
/* 140 */       m = (arrayOfInt[0] - 100) * 100 + (arrayOfInt[1] - 100);
/*     */ 
/* 143 */       Calendar localCalendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"), Locale.US);
/*     */ 
/* 146 */       localCalendar.set(1, m);
/* 147 */       localCalendar.set(2, arrayOfInt[2] - 1);
/* 148 */       localCalendar.set(5, arrayOfInt[3]);
/* 149 */       localCalendar.set(11, arrayOfInt[4] - 1);
/* 150 */       localCalendar.set(12, arrayOfInt[5] - 1);
/* 151 */       localCalendar.set(13, arrayOfInt[6] - 1);
/* 152 */       localCalendar.set(14, 0);
/*     */ 
/* 155 */       long l = localCalendar.getTime().getTime();
/*     */ 
/* 158 */       int n = (arrayOfInt[7] - OFFSET_HOUR) * HOUR_MILLISECOND + (arrayOfInt[8] - OFFSET_MINUTE) * MINUTE_MILLISECOND;
/*     */ 
/* 162 */       byte b = (byte)arrayOfInt[9];
/*     */ 
/* 165 */       arrayOfOffsetDST[(j++)] = new OffsetDST(new Timestamp(l), n, b);
/*     */     }
/*     */ 
/* 170 */     this.zonetab.put(Integer.valueOf(paramInt & 0x1FF), arrayOfOffsetDST);
/*     */   }
/*     */ 
/*     */   public byte getLocalOffset(Calendar paramCalendar, int paramInt, OffsetDST paramOffsetDST)
/*     */     throws SQLException
/*     */   {
/* 186 */     int k = 0;
/* 187 */     int m = 0;
/*     */ 
/* 189 */     byte b = 0;
/*     */ 
/* 193 */     Calendar localCalendar1 = Calendar.getInstance(TimeZone.getTimeZone("UTC"), Locale.US);
/*     */ 
/* 195 */     Calendar localCalendar2 = Calendar.getInstance(TimeZone.getTimeZone("UTC"), Locale.US);
/*     */ 
/* 199 */     Calendar localCalendar3 = Calendar.getInstance(TimeZone.getTimeZone("UTC"), Locale.US);
/*     */ 
/* 207 */     localCalendar3.set(1, paramCalendar.get(1));
/* 208 */     localCalendar3.set(2, paramCalendar.get(2));
/* 209 */     localCalendar3.set(5, paramCalendar.get(5));
/* 210 */     localCalendar3.set(11, paramCalendar.get(11));
/* 211 */     localCalendar3.set(12, paramCalendar.get(12));
/* 212 */     localCalendar3.set(13, paramCalendar.get(13));
/* 213 */     localCalendar3.set(14, paramCalendar.get(14));
/*     */ 
/* 216 */     Calendar localCalendar4 = Calendar.getInstance(TimeZone.getTimeZone("UTC"), Locale.US);
/*     */ 
/* 219 */     localCalendar4.set(1, localCalendar3.get(1));
/* 220 */     localCalendar4.set(2, localCalendar3.get(2));
/* 221 */     localCalendar4.set(5, 1);
/* 222 */     localCalendar4.set(11, 0);
/* 223 */     localCalendar4.set(12, 0);
/* 224 */     localCalendar4.set(13, 0);
/* 225 */     localCalendar4.set(14, 0);
/*     */ 
/* 228 */     OffsetDST[] arrayOfOffsetDST = (OffsetDST[])this.zonetab.get(Integer.valueOf(paramInt & 0x1FF));
/*     */ 
/* 231 */     int i2 = findCloseMatch(arrayOfOffsetDST, localCalendar4.getTimeInMillis());
/*     */     int n;
/*     */     int i1;
/*     */     while (true)
/*     */     {
/* 256 */       localCalendar1.setTime(arrayOfOffsetDST[i2].getTimestamp());
/*     */ 
/* 258 */       int i = arrayOfOffsetDST[i2].getOFFSET();
/*     */ 
/* 261 */       localCalendar1.add(10, i / HOUR_MILLISECOND);
/*     */ 
/* 263 */       localCalendar1.add(12, i % HOUR_MILLISECOND / MINUTE_MILLISECOND);
/*     */ 
/* 267 */       n = arrayOfOffsetDST[i2].getDSTFLAG();
/*     */ 
/* 269 */       if (localCalendar3.equals(localCalendar1))
/*     */       {
/* 272 */         paramOffsetDST.setOFFSET(arrayOfOffsetDST[i2].getOFFSET());
/* 273 */         paramOffsetDST.setDSTFLAG(arrayOfOffsetDST[i2].getDSTFLAG());
/*     */ 
/* 275 */         b = 0;
/* 276 */         if (i2 <= 0) {
/*     */           break label719;
/*     */         }
/* 279 */         i1 = arrayOfOffsetDST[(i2 - 1)].getDSTFLAG();
/*     */ 
/* 282 */         if ((n != 0) || (i1 != 1)) {
/*     */           break label719;
/*     */         }
/* 285 */         b = 1; break label719;
/*     */       }
/*     */ 
/* 290 */       if (localCalendar3.before(localCalendar1))
/*     */       {
/* 292 */         if (i2 == 0)
/*     */         {
/* 295 */           paramOffsetDST.setOFFSET(0);
/* 296 */           paramOffsetDST.setDSTFLAG((byte)0);
/* 297 */           b = 0;
/*     */ 
/* 299 */           if (n != 1)
/*     */           {
/*     */             break label719;
/*     */           }
/*     */ 
/* 305 */           localCalendar1.add(10, -1);
/* 306 */           if (localCalendar3.before(localCalendar1))
/*     */             break label719;
/* 308 */           throw new SQLException("Illegal local time.");
/*     */         }
/*     */ 
/* 315 */         i2 -= 1;
/*     */ 
/* 317 */         if (i2 >= 0)
/*     */         {
/* 319 */           i1 = arrayOfOffsetDST[i2].getDSTFLAG();
/*     */ 
/* 321 */           if ((n == 1) && (i1 == 0))
/*     */           {
/* 326 */             localCalendar1.add(10, -1);
/* 327 */             if (!localCalendar3.before(localCalendar1))
/*     */             {
/* 329 */               throw new SQLException("Illegal local time.");
/*     */             }
/*     */ 
/*     */           }
/*     */ 
/*     */         }
/*     */ 
/*     */       }
/*     */       else
/*     */       {
/* 341 */         if (i2 == arrayOfOffsetDST.length - 1)
/*     */         {
/*     */           break;
/*     */         }
/*     */ 
/* 347 */         localCalendar2.setTime(arrayOfOffsetDST[(i2 + 1)].getTimestamp());
/*     */ 
/* 349 */         int j = arrayOfOffsetDST[(i2 + 1)].getOFFSET();
/*     */ 
/* 352 */         localCalendar2.add(10, j / HOUR_MILLISECOND);
/*     */ 
/* 354 */         localCalendar2.add(12, j % HOUR_MILLISECOND / MINUTE_MILLISECOND);
/*     */ 
/* 357 */         if (localCalendar3.before(localCalendar2)) {
/*     */           break;
/*     */         }
/* 360 */         i2 += 1;
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 366 */     paramOffsetDST.setOFFSET(arrayOfOffsetDST[i2].getOFFSET());
/* 367 */     paramOffsetDST.setDSTFLAG(arrayOfOffsetDST[i2].getDSTFLAG());
/*     */ 
/* 369 */     b = 0;
/* 370 */     if (n == 0)
/*     */     {
/* 372 */       if (i2 > 0)
/*     */       {
/* 375 */         i1 = arrayOfOffsetDST[(i2 - 1)].getDSTFLAG();
/*     */ 
/* 377 */         if (i1 == 1)
/*     */         {
/* 383 */           localCalendar1.add(10, 1);
/* 384 */           if (localCalendar3.before(localCalendar1))
/*     */           {
/* 386 */             b = 1;
/*     */           }
/*     */         }
/*     */       }
/*     */ 
/* 391 */       if (i2 != arrayOfOffsetDST.length - 1)
/*     */       {
/* 393 */         i1 = arrayOfOffsetDST[(i2 + 1)].getDSTFLAG();
/*     */ 
/* 395 */         if (i1 == 1)
/*     */         {
/* 402 */           localCalendar2.add(10, -1);
/* 403 */           if (!localCalendar3.before(localCalendar2))
/*     */           {
/* 405 */             throw new SQLException("Illegal local time.");
/*     */           }
/*     */ 
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 414 */     label719: return b;
/*     */   }
/*     */ 
/*     */   public int getOffset(Calendar paramCalendar, int paramInt)
/*     */     throws SQLException
/*     */   {
/* 428 */     OffsetDST[] arrayOfOffsetDST = (OffsetDST[])this.zonetab.get(Integer.valueOf(paramInt & 0x1FF));
/*     */ 
/* 430 */     return getOffset(paramCalendar, arrayOfOffsetDST);
/*     */   }
/*     */ 
/*     */   public int getOffset(Calendar paramCalendar, OffsetDST[] paramArrayOfOffsetDST)
/*     */     throws SQLException
/*     */   {
/* 437 */     int i = 0;
/*     */ 
/* 440 */     Timestamp localTimestamp = new Timestamp(paramCalendar.getTime().getTime());
/*     */ 
/* 443 */     int j = findCloseMatch(paramArrayOfOffsetDST, localTimestamp.getTime());
/*     */ 
/* 446 */     return paramArrayOfOffsetDST[j].getOFFSET();
/*     */   }
/*     */ 
/*     */   public boolean isDST(Calendar paramCalendar, OffsetDST[] paramArrayOfOffsetDST)
/*     */     throws SQLException
/*     */   {
/* 453 */     int i = 0;
/*     */ 
/* 456 */     Timestamp localTimestamp = new Timestamp(paramCalendar.getTime().getTime());
/*     */ 
/* 459 */     int j = findCloseMatch(paramArrayOfOffsetDST, localTimestamp.getTime());
/*     */ 
/* 462 */     return paramArrayOfOffsetDST[j].getDSTFLAG() == 1;
/*     */   }
/*     */ 
/*     */   public OffsetDST[] getOffsetDST(int paramInt)
/*     */   {
/* 467 */     OffsetDST[] arrayOfOffsetDST = (OffsetDST[])this.zonetab.get(Integer.valueOf(paramInt & 0x1FF));
/*     */ 
/* 469 */     return arrayOfOffsetDST;
/*     */   }
/*     */ 
/*     */   final int findCloseMatch(OffsetDST[] paramArrayOfOffsetDST, long paramLong)
/*     */   {
/* 477 */     int i = paramArrayOfOffsetDST.length;
/* 478 */     int j = 0;
/* 479 */     int k = i / 2;
/* 480 */     int m = k;
/*     */ 
/* 482 */     if (paramLong < paramArrayOfOffsetDST[j].getTime())
/*     */     {
/* 485 */       int n = 0;
/*     */ 
/* 487 */       while ((paramArrayOfOffsetDST[n].getDSTFLAG() == 1) && (n < paramArrayOfOffsetDST.length))
/*     */       {
/* 490 */         n++;
/*     */       }
/*     */ 
/* 493 */       return n < paramArrayOfOffsetDST.length ? n : 0;
/*     */     }
/*     */ 
/* 496 */     while (k > 0)
/*     */     {
/* 498 */       if (paramLong > paramArrayOfOffsetDST[k].getTime())
/* 499 */         j = k;
/* 500 */       else if (paramLong < paramArrayOfOffsetDST[k].getTime())
/* 501 */         i = k;
/* 502 */       else if (k == j) {
/*     */           break;
/*     */         }
/* 505 */       k = j + (i - j) / 2;
/*     */ 
/* 509 */       if (m == k) {
/*     */         break;
/*     */       }
/* 512 */       m = k;
/*     */     }
/*     */ 
/* 515 */     return k;
/*     */   }
/*     */ 
/*     */   public void displayTable(int paramInt)
/*     */   {
/* 533 */     OffsetDST[] arrayOfOffsetDST = (OffsetDST[])this.zonetab.get(Integer.valueOf(paramInt));
/*     */ 
/* 535 */     for (int i = 0; i < arrayOfOffsetDST.length; i++)
/*     */     {
/* 537 */       System.out.print(arrayOfOffsetDST[i].getTimestamp().toString());
/* 538 */       System.out.print("    " + arrayOfOffsetDST[i].getOFFSET());
/* 539 */       System.out.println("    " + arrayOfOffsetDST[i].getDSTFLAG());
/*     */     }
/*     */   }
/*     */ 
/*     */   public boolean checkID(int paramInt)
/*     */   {
/* 558 */     return this.zonetab.get(Integer.valueOf(paramInt & 0x1FF)) == null;
/*     */   }
/*     */ 
/*     */   public void updateTable(Connection paramConnection, int paramInt)
/*     */     throws SQLException, NullPointerException
/*     */   {
/* 574 */     byte[] arrayOfByte = TRANSDUMP.getTransitions(paramConnection, paramInt);
/*     */ 
/* 576 */     if (arrayOfByte == null) {
/* 577 */       throw new NullPointerException();
/*     */     }
/*     */ 
/* 580 */     addTrans(arrayOfByte, paramInt);
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.sql.TIMEZONETAB
 * JD-Core Version:    0.6.2
 */