/*      */ package oracle.sql;
/*      */ 
/*      */ import java.sql.Connection;
/*      */ import java.sql.SQLException;
/*      */ import java.sql.Time;
/*      */ import java.sql.Timestamp;
/*      */ import java.util.Calendar;
/*      */ import java.util.Locale;
/*      */ import java.util.SimpleTimeZone;
/*      */ import java.util.TimeZone;
/*      */ import oracle.jdbc.driver.DatabaseError;
/*      */ 
/*      */ public class TIMESTAMPTZ extends Datum
/*      */ {
/*      */   static final long serialVersionUID = 6708361144588335769L;
/*   72 */   static final Calendar CAL_GMT_US = Calendar.getInstance(TimeZone.getTimeZone("GMT"), Locale.US);
/*      */ 
/*   75 */   static final TimeZone TIMEZONE_UTC = TimeZone.getTimeZone("UTC");
/*      */ 
/* 1561 */   private static int HOUR_MILLISECOND = 3600000;
/*      */ 
/* 1564 */   private static int MINUTE_MILLISECOND = 60000;
/*      */ 
/* 1568 */   private static int OFFSET_HOUR = 20;
/* 1569 */   private static int OFFSET_MINUTE = 60;
/*      */ 
/* 1594 */   private static byte REGIONIDBIT = -128;
/*      */ 
/* 1604 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*      */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*      */   public static final boolean TRACE = false;
/*      */ 
/*      */   public TIMESTAMPTZ()
/*      */   {
/*   86 */     super(initTimestamptz());
/*      */   }
/*      */ 
/*      */   public TIMESTAMPTZ(byte[] paramArrayOfByte)
/*      */   {
/*  101 */     super(paramArrayOfByte);
/*      */   }
/*      */ 
/*      */   public TIMESTAMPTZ(Connection paramConnection, java.sql.Date paramDate)
/*      */     throws SQLException
/*      */   {
/*  116 */     super(toBytes(paramConnection, paramDate));
/*      */   }
/*      */ 
/*      */   public TIMESTAMPTZ(Connection paramConnection, java.sql.Date paramDate, Calendar paramCalendar)
/*      */     throws SQLException
/*      */   {
/*  133 */     super(toBytes(paramConnection, paramDate, paramCalendar));
/*      */   }
/*      */ 
/*      */   public TIMESTAMPTZ(Connection paramConnection, Time paramTime)
/*      */     throws SQLException
/*      */   {
/*  148 */     super(toBytes(paramConnection, paramTime));
/*      */   }
/*      */ 
/*      */   public TIMESTAMPTZ(Connection paramConnection, Time paramTime, Calendar paramCalendar)
/*      */     throws SQLException
/*      */   {
/*  166 */     super(toBytes(paramConnection, paramTime, paramCalendar));
/*      */   }
/*      */ 
/*      */   public TIMESTAMPTZ(Connection paramConnection, Timestamp paramTimestamp)
/*      */     throws SQLException
/*      */   {
/*  181 */     super(toBytes(paramConnection, paramTimestamp));
/*      */   }
/*      */ 
/*      */   public TIMESTAMPTZ(Connection paramConnection, Timestamp paramTimestamp, Calendar paramCalendar)
/*      */     throws SQLException
/*      */   {
/*  198 */     super(toBytes(paramConnection, paramTimestamp, paramCalendar));
/*      */   }
/*      */ 
/*      */   public TIMESTAMPTZ(Connection paramConnection, DATE paramDATE)
/*      */     throws SQLException
/*      */   {
/*  213 */     super(toBytes(paramConnection, paramDATE));
/*      */   }
/*      */ 
/*      */   public TIMESTAMPTZ(Connection paramConnection, String paramString)
/*      */     throws SQLException
/*      */   {
/*  230 */     super(toBytes(paramConnection, paramString));
/*      */   }
/*      */ 
/*      */   public TIMESTAMPTZ(Connection paramConnection, String paramString, Calendar paramCalendar)
/*      */     throws SQLException
/*      */   {
/*  246 */     super(toBytes(paramConnection, paramString, paramCalendar));
/*      */   }
/*      */ 
/*      */   public static java.sql.Date toDate(Connection paramConnection, byte[] paramArrayOfByte)
/*      */     throws SQLException
/*      */   {
/*  275 */     int[] arrayOfInt = new int[13];
/*      */ 
/*  278 */     for (int j = 0; j < 13; j++) {
/*  279 */       paramArrayOfByte[j] &= 255;
/*      */     }
/*      */ 
/*  283 */     j = TIMESTAMP.getJavaYear(arrayOfInt[0], arrayOfInt[1]);
/*      */ 
/*  286 */     Calendar localCalendar = Calendar.getInstance();
/*      */ 
/*  288 */     localCalendar.set(1, j);
/*  289 */     localCalendar.set(2, arrayOfInt[2] - 1);
/*  290 */     localCalendar.set(5, arrayOfInt[3]);
/*  291 */     localCalendar.set(11, arrayOfInt[4] - 1);
/*  292 */     localCalendar.set(12, arrayOfInt[5] - 1);
/*  293 */     localCalendar.set(13, arrayOfInt[6] - 1);
/*  294 */     localCalendar.set(14, 0);
/*      */ 
/*  297 */     if ((arrayOfInt[11] & REGIONIDBIT) != 0)
/*      */     {
/*  300 */       int k = getHighOrderbits(arrayOfInt[11]);
/*  301 */       k += getLowOrderbits(arrayOfInt[12]);
/*      */ 
/*  304 */       TIMEZONETAB localTIMEZONETAB = getTIMEZONETAB(paramConnection);
/*  305 */       if (localTIMEZONETAB.checkID(k)) {
/*  306 */         localTIMEZONETAB.updateTable(paramConnection, k);
/*      */       }
/*      */ 
/*  310 */       int i = localTIMEZONETAB.getOffset(localCalendar, k);
/*      */ 
/*  313 */       localCalendar.add(10, i / HOUR_MILLISECOND);
/*  314 */       localCalendar.add(12, i % HOUR_MILLISECOND / MINUTE_MILLISECOND);
/*      */     }
/*      */     else
/*      */     {
/*  318 */       localCalendar.add(10, arrayOfInt[11] - OFFSET_HOUR);
/*  319 */       localCalendar.add(12, arrayOfInt[12] - OFFSET_MINUTE);
/*      */     }
/*      */ 
/*  323 */     long l = localCalendar.getTime().getTime();
/*      */ 
/*  326 */     return new java.sql.Date(l);
/*      */   }
/*      */ 
/*      */   public static java.sql.Date toDate2(Connection paramConnection, byte[] paramArrayOfByte)
/*      */     throws SQLException
/*      */   {
/*  344 */     int[] arrayOfInt = new int[13];
/*      */ 
/*  347 */     for (int i = 0; i < 13; i++) {
/*  348 */       paramArrayOfByte[i] &= 255;
/*      */     }
/*      */ 
/*  352 */     i = TIMESTAMP.getJavaYear(arrayOfInt[0], arrayOfInt[1]);
/*      */ 
/*  358 */     Calendar localCalendar = (Calendar)CAL_GMT_US.clone();
/*  359 */     localCalendar.set(1, i);
/*  360 */     localCalendar.set(2, arrayOfInt[2] - 1);
/*  361 */     localCalendar.set(5, arrayOfInt[3]);
/*  362 */     localCalendar.set(11, arrayOfInt[4] - 1);
/*  363 */     localCalendar.set(12, arrayOfInt[5] - 1);
/*  364 */     localCalendar.set(13, arrayOfInt[6] - 1);
/*  365 */     localCalendar.set(14, 0);
/*      */ 
/*  368 */     long l = localCalendar.getTime().getTime();
/*      */ 
/*  371 */     return new java.sql.Date(l);
/*      */   }
/*      */ 
/*      */   public static Time toTime(Connection paramConnection, byte[] paramArrayOfByte)
/*      */     throws SQLException
/*      */   {
/*  392 */     int[] arrayOfInt = new int[13];
/*      */ 
/*  395 */     for (int i = 0; i < 13; i++) {
/*  396 */       paramArrayOfByte[i] &= 255;
/*      */     }
/*      */ 
/*  400 */     Calendar localCalendar = (Calendar)CAL_GMT_US.clone();
/*      */ 
/*  403 */     int j = TIMESTAMP.getJavaYear(arrayOfInt[0], arrayOfInt[1]);
/*      */ 
/*  405 */     localCalendar.set(1, j);
/*  406 */     localCalendar.set(2, arrayOfInt[2] - 1);
/*  407 */     localCalendar.set(5, arrayOfInt[3]);
/*  408 */     localCalendar.set(11, arrayOfInt[4] - 1);
/*  409 */     localCalendar.set(12, arrayOfInt[5] - 1);
/*  410 */     localCalendar.set(13, arrayOfInt[6] - 1);
/*  411 */     localCalendar.set(14, 0);
/*      */ 
/*  414 */     return new Time(localCalendar.getTimeInMillis());
/*      */   }
/*      */ 
/*      */   public static DATE toDATE(Connection paramConnection, byte[] paramArrayOfByte)
/*      */     throws SQLException
/*      */   {
/*  431 */     return new DATE(toTimestampInSessionTimezone(paramConnection, paramArrayOfByte));
/*      */   }
/*      */ 
/*      */   public static TIMESTAMP toTIMESTAMP(Connection paramConnection, byte[] paramArrayOfByte)
/*      */     throws SQLException
/*      */   {
/*  439 */     return new TIMESTAMP(toTimestampInSessionTimezone(paramConnection, paramArrayOfByte));
/*      */   }
/*      */ 
/*      */   public static Timestamp toTimestamp(Connection paramConnection, byte[] paramArrayOfByte)
/*      */     throws SQLException
/*      */   {
/*  456 */     int[] arrayOfInt = new int[13];
/*      */ 
/*  459 */     for (int j = 0; j < 13; j++) {
/*  460 */       paramArrayOfByte[j] &= 255;
/*      */     }
/*      */ 
/*  466 */     Calendar localCalendar1 = Calendar.getInstance();
/*      */ 
/*  469 */     Calendar localCalendar2 = (Calendar)CAL_GMT_US.clone();
/*      */ 
/*  474 */     Calendar localCalendar3 = Calendar.getInstance();
/*      */ 
/*  477 */     int k = TIMESTAMP.getJavaYear(arrayOfInt[0], arrayOfInt[1]);
/*      */ 
/*  479 */     localCalendar1.set(1, k);
/*  480 */     localCalendar1.set(2, arrayOfInt[2] - 1);
/*  481 */     localCalendar1.set(5, arrayOfInt[3]);
/*  482 */     localCalendar1.set(11, arrayOfInt[4] - 1);
/*  483 */     localCalendar1.set(12, arrayOfInt[5] - 1);
/*  484 */     localCalendar1.set(13, arrayOfInt[6] - 1);
/*  485 */     localCalendar1.set(14, 0);
/*      */ 
/*  490 */     localCalendar2.set(1, k);
/*  491 */     localCalendar2.set(2, arrayOfInt[2] - 1);
/*  492 */     localCalendar2.set(5, arrayOfInt[3]);
/*  493 */     localCalendar2.set(11, arrayOfInt[4] - 1);
/*  494 */     localCalendar2.set(12, arrayOfInt[5] - 1);
/*  495 */     localCalendar2.set(13, arrayOfInt[6] - 1);
/*  496 */     localCalendar2.set(14, 0);
/*      */ 
/*  498 */     long l1 = localCalendar1.getTime().getTime();
/*      */ 
/*  500 */     if ((arrayOfInt[11] & REGIONIDBIT) != 0)
/*      */     {
/*  502 */       int m = getHighOrderbits(arrayOfInt[11]);
/*  503 */       m += getLowOrderbits(arrayOfInt[12]);
/*      */ 
/*  506 */       TIMEZONETAB localTIMEZONETAB = getTIMEZONETAB(paramConnection);
/*  507 */       if (localTIMEZONETAB.checkID(m)) {
/*  508 */         localTIMEZONETAB.updateTable(paramConnection, m);
/*      */       }
/*      */ 
/*  512 */       int i = localTIMEZONETAB.getOffset(localCalendar2, m);
/*      */ 
/*  515 */       l1 += i;
/*      */ 
/*  517 */       TimeZone localTimeZone = localCalendar1.getTimeZone();
/*  518 */       localObject = localCalendar3.getTimeZone();
/*      */ 
/*  525 */       if ((!localTimeZone.inDaylightTime(localCalendar1.getTime())) && (((TimeZone)localObject).inDaylightTime(new Timestamp(l1))))
/*      */       {
/*  528 */         if ((localObject instanceof SimpleTimeZone)) {
/*  529 */           l1 -= ((SimpleTimeZone)localObject).getDSTSavings();
/*      */         }
/*      */         else {
/*  532 */           l1 -= HOUR_MILLISECOND;
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*  542 */       if ((localTimeZone.inDaylightTime(localCalendar1.getTime())) && (!((TimeZone)localObject).inDaylightTime(new Timestamp(l1))))
/*      */       {
/*  545 */         if ((localObject instanceof SimpleTimeZone)) {
/*  546 */           l1 += ((SimpleTimeZone)localTimeZone).getDSTSavings();
/*      */         }
/*      */         else {
/*  549 */           l1 += HOUR_MILLISECOND;
/*      */         }
/*      */       }
/*      */     }
/*      */     else
/*      */     {
/*  555 */       localCalendar1.add(10, arrayOfInt[11] - OFFSET_HOUR);
/*  556 */       localCalendar1.add(12, arrayOfInt[12] - OFFSET_MINUTE);
/*      */ 
/*  559 */       l1 = localCalendar1.getTime().getTime();
/*      */     }
/*      */ 
/*  563 */     Timestamp localTimestamp = new Timestamp(l1);
/*      */ 
/*  567 */     long l2 = localCalendar2.getTime().getTime();
/*      */ 
/*  572 */     Object localObject = Calendar.getInstance();
/*  573 */     ((Calendar)localObject).setTimeInMillis(l2);
/*      */ 
/*  578 */     Calendar localCalendar4 = Calendar.getInstance();
/*  579 */     localCalendar4.setTime(localTimestamp);
/*      */ 
/*  581 */     boolean bool1 = ((Calendar)localObject).getTimeZone().inDaylightTime(((Calendar)localObject).getTime());
/*  582 */     boolean bool2 = localCalendar4.getTimeZone().inDaylightTime(localCalendar4.getTime());
/*      */ 
/*  588 */     if ((bool1) && (!bool2)) {
/*  589 */       localTimestamp = new Timestamp(l1 - ((Calendar)localObject).getTimeZone().getDSTSavings());
/*      */     }
/*  591 */     else if ((!bool1) && (bool2)) {
/*  592 */       localTimestamp = new Timestamp(l1 + localCalendar4.getTimeZone().getDSTSavings());
/*      */     }
/*      */ 
/*  596 */     int n = TIMESTAMP.getNanos(paramArrayOfByte, 7);
/*      */ 
/*  599 */     localTimestamp.setNanos(n);
/*      */ 
/*  601 */     return localTimestamp;
/*      */   }
/*      */ 
/*      */   public static Timestamp toTimestamp2(Connection paramConnection, byte[] paramArrayOfByte)
/*      */     throws SQLException
/*      */   {
/*  627 */     int[] arrayOfInt = new int[13];
/*      */ 
/*  629 */     for (int i = 0; i < 13; i++) {
/*  630 */       paramArrayOfByte[i] &= 255;
/*      */     }
/*      */ 
/*  634 */     i = TIMESTAMP.getJavaYear(arrayOfInt[0], arrayOfInt[1]);
/*      */ 
/*  636 */     Calendar localCalendar = (Calendar)CAL_GMT_US.clone();
/*      */ 
/*  638 */     localCalendar.clear();
/*  639 */     localCalendar.set(1, i);
/*  640 */     localCalendar.set(2, arrayOfInt[2] - 1);
/*  641 */     localCalendar.set(5, arrayOfInt[3]);
/*  642 */     localCalendar.set(11, arrayOfInt[4] - 1);
/*  643 */     localCalendar.set(12, arrayOfInt[5] - 1);
/*  644 */     localCalendar.set(13, arrayOfInt[6] - 1);
/*  645 */     localCalendar.set(14, 0);
/*      */ 
/*  647 */     long l = localCalendar.getTime().getTime();
/*      */ 
/*  650 */     Timestamp localTimestamp = new Timestamp(l);
/*      */ 
/*  653 */     int j = TIMESTAMP.getNanos(paramArrayOfByte, 7);
/*      */ 
/*  656 */     localTimestamp.setNanos(j);
/*      */ 
/*  658 */     return localTimestamp;
/*      */   }
/*      */ 
/*      */   static Timestamp toTimestampInSessionTimezone(Connection paramConnection, byte[] paramArrayOfByte)
/*      */     throws SQLException
/*      */   {
/*  669 */     int[] arrayOfInt = new int[13];
/*      */ 
/*  671 */     for (int i = 0; i < 13; i++) {
/*  672 */       paramArrayOfByte[i] &= 255;
/*      */     }
/*      */ 
/*  676 */     i = TIMESTAMP.getJavaYear(arrayOfInt[0], arrayOfInt[1]);
/*      */ 
/*  678 */     Calendar localCalendar1 = (Calendar)CAL_GMT_US.clone();
/*      */ 
/*  680 */     localCalendar1.clear();
/*  681 */     localCalendar1.set(1, i);
/*  682 */     localCalendar1.set(2, arrayOfInt[2] - 1);
/*  683 */     localCalendar1.set(5, arrayOfInt[3]);
/*  684 */     localCalendar1.set(11, arrayOfInt[4] - 1);
/*  685 */     localCalendar1.set(12, arrayOfInt[5] - 1);
/*  686 */     localCalendar1.set(13, arrayOfInt[6] - 1);
/*  687 */     localCalendar1.set(14, 0);
/*      */ 
/*  690 */     Calendar localCalendar2 = TIMESTAMPLTZ.getSessCalendar(paramConnection);
/*  691 */     TIMESTAMPLTZ.TimeZoneAdjust(paramConnection, localCalendar1, localCalendar2);
/*      */ 
/*  693 */     long l = localCalendar2.getTime().getTime();
/*      */ 
/*  696 */     Timestamp localTimestamp = new Timestamp(l);
/*      */ 
/*  699 */     int j = TIMESTAMP.getNanos(paramArrayOfByte, 7);
/*      */ 
/*  702 */     localTimestamp.setNanos(j);
/*      */ 
/*  704 */     return localTimestamp;
/*      */   }
/*      */ 
/*      */   public static String toString(Connection paramConnection, byte[] paramArrayOfByte)
/*      */     throws SQLException
/*      */   {
/*      */     int i;
/*      */     String str1;
/*      */     String str2;
/*  720 */     if ((paramArrayOfByte[11] & REGIONIDBIT) != 0)
/*      */     {
/*  722 */       i = getHighOrderbits(paramArrayOfByte[11]);
/*  723 */       i += getLowOrderbits(paramArrayOfByte[12]);
/*  724 */       str1 = ZONEIDMAP.getRegion(i);
/*  725 */       str2 = str1;
/*      */     }
/*      */     else {
/*  728 */       i = paramArrayOfByte[11] - OFFSET_HOUR;
/*  729 */       int j = paramArrayOfByte[12] - OFFSET_MINUTE;
/*  730 */       str1 = new StringBuilder().append(i).append(":").toString();
/*  731 */       if (j == 0) {
/*  732 */         str1 = new StringBuilder().append(str1).append("00").toString();
/*      */       }
/*      */       else {
/*  735 */         str1 = new StringBuilder().append(str1).append("").append(j).toString();
/*      */       }
/*      */ 
/*  738 */       str2 = new StringBuilder().append("GMT").append(i >= 0 ? "+" : "").append(str1).toString();
/*      */     }
/*      */ 
/*  742 */     Calendar localCalendar = Calendar.getInstance(TimeZone.getTimeZone(str2));
/*      */ 
/*  746 */     Timestamp localTimestamp = toTimestamp2(paramConnection, paramArrayOfByte);
/*      */ 
/*  748 */     localCalendar.setTimeInMillis(localTimestamp.getTime());
/*      */ 
/*  751 */     int k = localCalendar.get(1);
/*      */ 
/*  753 */     if (localCalendar.get(0) == 0) {
/*  754 */       k = -(k - 1);
/*      */     }
/*      */ 
/*  757 */     int m = localCalendar.get(2) + 1;
/*  758 */     int n = localCalendar.get(5);
/*  759 */     int i1 = localCalendar.get(11);
/*  760 */     int i2 = localCalendar.get(12);
/*  761 */     int i3 = localCalendar.get(13);
/*  762 */     int i4 = 0;
/*  763 */     i4 = (paramArrayOfByte[7] & 0xFF) << 24;
/*  764 */     i4 |= (paramArrayOfByte[8] & 0xFF) << 16;
/*  765 */     i4 |= (paramArrayOfByte[9] & 0xFF) << 8;
/*  766 */     i4 |= paramArrayOfByte[10] & 0xFF & 0xFF;
/*      */ 
/*  768 */     return toString(k, m, n, i1, i2, i3, i4, str1);
/*      */   }
/*      */ 
/*      */   public static final String toString(int paramInt1, int paramInt2, int paramInt3, int paramInt4, int paramInt5, int paramInt6, int paramInt7, String paramString)
/*      */   {
/*  789 */     String str1 = new StringBuilder().append("").append(paramInt1).append("-").append(toStr(paramInt2)).append("-").append(toStr(paramInt3)).append(" ").append(toStr(paramInt4)).append(":").append(toStr(paramInt5)).append(":").append(toStr(paramInt6)).toString();
/*      */ 
/*  797 */     if (paramInt7 >= 0) {
/*  798 */       String str2 = String.format("%09d", new Object[] { Integer.valueOf(paramInt7) });
/*      */ 
/*  800 */       char[] arrayOfChar = str2.toCharArray();
/*  801 */       int i = arrayOfChar.length;
/*      */ 
/*  803 */       while ((i > 1) && (arrayOfChar[(i - 1)] == '0')) {
/*  804 */         i--;
/*      */       }
/*      */ 
/*  807 */       str2 = str2.substring(0, i);
/*      */ 
/*  809 */       str1 = new StringBuilder().append(str1).append(".").append(str2).toString();
/*      */     }
/*      */ 
/*  812 */     if (paramString != null) {
/*  813 */       str1 = new StringBuilder().append(str1).append(" ").append(paramString).toString();
/*      */     }
/*      */ 
/*  816 */     return str1;
/*      */   }
/*      */ 
/*      */   private static final String toStr(int paramInt)
/*      */   {
/*  822 */     return paramInt < 10 ? new StringBuilder().append("0").append(paramInt).toString() : Integer.toString(paramInt);
/*      */   }
/*      */ 
/*      */   public Timestamp timestampValue(Connection paramConnection)
/*      */     throws SQLException
/*      */   {
/*  843 */     if (((oracle.jdbc.OracleConnection)paramConnection).physicalConnectionWithin().getTimestamptzInGmt())
/*      */     {
/*  845 */       return toTimestamp2(paramConnection, getBytes());
/*      */     }
/*      */ 
/*  848 */     return toTimestamp(paramConnection, getBytes());
/*      */   }
/*      */ 
/*      */   public byte[] toBytes()
/*      */   {
/*  861 */     return getBytes();
/*      */   }
/*      */ 
/*      */   public static byte[] toBytes(Connection paramConnection, java.sql.Date paramDate)
/*      */     throws SQLException
/*      */   {
/*  875 */     return toBytes(paramConnection, paramDate, null);
/*      */   }
/*      */ 
/*      */   public static byte[] toBytes(Connection paramConnection, java.sql.Date paramDate, Calendar paramCalendar)
/*      */     throws SQLException
/*      */   {
/*  892 */     if (paramDate == null) {
/*  893 */       return null;
/*      */     }
/*      */ 
/*  896 */     byte[] arrayOfByte = new byte[13];
/*      */ 
/*  898 */     Calendar localCalendar1 = getWorkCal(paramConnection, paramCalendar);
/*      */ 
/*  900 */     localCalendar1.setTime(paramDate);
/*      */ 
/*  902 */     Calendar localCalendar2 = doCalWork(paramConnection, localCalendar1, arrayOfByte);
/*      */ 
/*  904 */     int i = TIMESTAMP.getOracleYear(localCalendar2);
/*      */ 
/*  906 */     arrayOfByte[0] = ((byte)(i / 100 + 100));
/*  907 */     arrayOfByte[1] = ((byte)(i % 100 + 100));
/*  908 */     arrayOfByte[2] = ((byte)(localCalendar2.get(2) + 1));
/*  909 */     arrayOfByte[3] = ((byte)localCalendar2.get(5));
/*  910 */     arrayOfByte[4] = ((byte)(localCalendar2.get(11) + 1));
/*  911 */     arrayOfByte[5] = ((byte)(localCalendar2.get(12) + 1));
/*  912 */     arrayOfByte[6] = ((byte)(localCalendar2.get(13) + 1));
/*  913 */     arrayOfByte[7] = 0;
/*  914 */     arrayOfByte[8] = 0;
/*  915 */     arrayOfByte[9] = 0;
/*  916 */     arrayOfByte[10] = 0;
/*      */ 
/*  918 */     return arrayOfByte;
/*      */   }
/*      */ 
/*      */   public static byte[] toBytes(Connection paramConnection, Time paramTime)
/*      */     throws SQLException
/*      */   {
/*  933 */     return toBytes(paramConnection, paramTime, null);
/*      */   }
/*      */ 
/*      */   public static byte[] toBytes(Connection paramConnection, Time paramTime, Calendar paramCalendar)
/*      */     throws SQLException
/*      */   {
/*  949 */     if (paramTime == null) {
/*  950 */       return null;
/*      */     }
/*      */ 
/*  953 */     byte[] arrayOfByte = new byte[13];
/*      */ 
/*  955 */     Calendar localCalendar1 = getWorkCal(paramConnection, paramCalendar);
/*      */ 
/*  957 */     localCalendar1.setTime(paramTime);
/*      */     int i;
/*  961 */     if (((oracle.jdbc.OracleConnection)paramConnection).physicalConnectionWithin().getUse1900AsYearForTime())
/*      */     {
/*  963 */       i = 1900;
/*      */     }
/*      */     else {
/*  966 */       i = 1970;
/*      */     }
/*      */ 
/*  969 */     localCalendar1.set(1, i);
/*  970 */     localCalendar1.set(2, 0);
/*  971 */     localCalendar1.set(5, 1);
/*      */ 
/*  973 */     Calendar localCalendar2 = doCalWork(paramConnection, localCalendar1, arrayOfByte);
/*      */ 
/*  975 */     int j = TIMESTAMP.getOracleYear(localCalendar2);
/*      */ 
/*  977 */     arrayOfByte[0] = ((byte)(j / 100 + 100));
/*  978 */     arrayOfByte[1] = ((byte)(j % 100 + 100));
/*  979 */     arrayOfByte[2] = ((byte)(localCalendar2.get(2) + 1));
/*  980 */     arrayOfByte[3] = ((byte)localCalendar2.get(5));
/*  981 */     arrayOfByte[4] = ((byte)(localCalendar2.get(11) + 1));
/*  982 */     arrayOfByte[5] = ((byte)(localCalendar2.get(12) + 1));
/*  983 */     arrayOfByte[6] = ((byte)(localCalendar2.get(13) + 1));
/*  984 */     arrayOfByte[7] = 0;
/*  985 */     arrayOfByte[8] = 0;
/*  986 */     arrayOfByte[9] = 0;
/*  987 */     arrayOfByte[10] = 0;
/*      */ 
/*  989 */     return arrayOfByte;
/*      */   }
/*      */ 
/*      */   public static byte[] toBytes(Connection paramConnection, Timestamp paramTimestamp)
/*      */     throws SQLException
/*      */   {
/* 1005 */     return toBytes(paramConnection, paramTimestamp, null);
/*      */   }
/*      */ 
/*      */   public static byte[] toBytes(Connection paramConnection, Timestamp paramTimestamp, Calendar paramCalendar)
/*      */     throws SQLException
/*      */   {
/* 1022 */     if (paramTimestamp == null) {
/* 1023 */       return null;
/*      */     }
/*      */ 
/* 1026 */     byte[] arrayOfByte = new byte[13];
/*      */ 
/* 1028 */     Calendar localCalendar1 = getWorkCal(paramConnection, paramCalendar);
/*      */ 
/* 1030 */     localCalendar1.setTime(paramTimestamp);
/*      */ 
/* 1032 */     Calendar localCalendar2 = doCalWork(paramConnection, localCalendar1, arrayOfByte);
/*      */ 
/* 1034 */     int i = TIMESTAMP.getOracleYear(localCalendar2);
/*      */ 
/* 1036 */     arrayOfByte[0] = ((byte)(i / 100 + 100));
/* 1037 */     arrayOfByte[1] = ((byte)(i % 100 + 100));
/* 1038 */     arrayOfByte[2] = ((byte)(localCalendar2.get(2) + 1));
/* 1039 */     arrayOfByte[3] = ((byte)localCalendar2.get(5));
/* 1040 */     arrayOfByte[4] = ((byte)(localCalendar2.get(11) + 1));
/* 1041 */     arrayOfByte[5] = ((byte)(localCalendar2.get(12) + 1));
/* 1042 */     arrayOfByte[6] = ((byte)(localCalendar2.get(13) + 1));
/*      */ 
/* 1049 */     arrayOfByte[7] = ((byte)(paramTimestamp.getNanos() >> 24));
/* 1050 */     arrayOfByte[8] = ((byte)(paramTimestamp.getNanos() >> 16 & 0xFF));
/* 1051 */     arrayOfByte[9] = ((byte)(paramTimestamp.getNanos() >> 8 & 0xFF));
/* 1052 */     arrayOfByte[10] = ((byte)(paramTimestamp.getNanos() & 0xFF));
/*      */ 
/* 1054 */     return arrayOfByte;
/*      */   }
/*      */ 
/*      */   public static byte[] toBytes(Connection paramConnection, DATE paramDATE)
/*      */     throws SQLException
/*      */   {
/* 1071 */     if (paramDATE == null) {
/* 1072 */       return null;
/*      */     }
/*      */ 
/* 1075 */     byte[] arrayOfByte = new byte[13];
/*      */ 
/* 1077 */     Calendar localCalendar1 = getWorkCal(paramConnection, null);
/*      */ 
/* 1080 */     localCalendar1.setTime(DATE.toDate(paramDATE.toBytes()));
/*      */ 
/* 1082 */     Calendar localCalendar2 = doCalWork(paramConnection, localCalendar1, arrayOfByte);
/*      */ 
/* 1084 */     int i = TIMESTAMP.getOracleYear(localCalendar2);
/*      */ 
/* 1086 */     arrayOfByte[0] = ((byte)(i / 100 + 100));
/* 1087 */     arrayOfByte[1] = ((byte)(i % 100 + 100));
/* 1088 */     arrayOfByte[2] = ((byte)(localCalendar2.get(2) + 1));
/* 1089 */     arrayOfByte[3] = ((byte)localCalendar2.get(5));
/* 1090 */     arrayOfByte[4] = ((byte)(localCalendar2.get(11) + 1));
/* 1091 */     arrayOfByte[5] = ((byte)(localCalendar2.get(12) + 1));
/* 1092 */     arrayOfByte[6] = ((byte)(localCalendar2.get(13) + 1));
/* 1093 */     arrayOfByte[7] = 0;
/* 1094 */     arrayOfByte[8] = 0;
/* 1095 */     arrayOfByte[9] = 0;
/* 1096 */     arrayOfByte[10] = 0;
/*      */ 
/* 1098 */     return arrayOfByte;
/*      */   }
/*      */ 
/*      */   public static byte[] toBytes(Connection paramConnection, String paramString)
/*      */     throws SQLException
/*      */   {
/* 1111 */     return toBytes(paramConnection, Timestamp.valueOf(paramString));
/*      */   }
/*      */ 
/*      */   public static byte[] toBytes(Connection paramConnection, String paramString, Calendar paramCalendar)
/*      */     throws SQLException
/*      */   {
/* 1125 */     Calendar localCalendar1 = (Calendar)CAL_GMT_US.clone();
/*      */ 
/* 1127 */     Timestamp localTimestamp = parseTime(paramString);
/* 1128 */     localCalendar1.setTime(localTimestamp);
/*      */     Calendar localCalendar2;
/* 1134 */     if (paramCalendar == null) {
/* 1135 */       localCalendar2 = Calendar.getInstance();
/*      */     }
/*      */     else {
/* 1138 */       localCalendar2 = Calendar.getInstance(paramCalendar.getTimeZone());
/*      */     }
/*      */ 
/* 1141 */     localCalendar2.set(1, localCalendar1.get(1));
/* 1142 */     localCalendar2.set(2, localCalendar1.get(2));
/* 1143 */     localCalendar2.set(5, localCalendar1.get(5));
/* 1144 */     localCalendar2.set(11, localCalendar1.get(11));
/* 1145 */     localCalendar2.set(12, localCalendar1.get(12));
/* 1146 */     localCalendar2.set(13, localCalendar1.get(13));
/* 1147 */     localCalendar2.set(14, localCalendar1.get(14));
/*      */ 
/* 1150 */     int i = localTimestamp.getNanos();
/* 1151 */     localTimestamp = new Timestamp(localCalendar2.getTime().getTime());
/* 1152 */     localTimestamp.setNanos(i);
/*      */ 
/* 1154 */     return toBytes(paramConnection, localTimestamp, paramCalendar);
/*      */   }
/*      */ 
/*      */   public String stringValue(Connection paramConnection)
/*      */     throws SQLException
/*      */   {
/* 1166 */     return toString(paramConnection, getBytes());
/*      */   }
/*      */ 
/*      */   public java.sql.Date dateValue(Connection paramConnection)
/*      */     throws SQLException
/*      */   {
/* 1188 */     if (((oracle.jdbc.OracleConnection)paramConnection).physicalConnectionWithin().getTimestamptzInGmt())
/*      */     {
/* 1190 */       return toDate2(paramConnection, getBytes());
/*      */     }
/*      */ 
/* 1193 */     return toDate(paramConnection, getBytes());
/*      */   }
/*      */ 
/*      */   public Time timeValue(Connection paramConnection)
/*      */     throws SQLException
/*      */   {
/* 1205 */     return toTime(paramConnection, getBytes());
/*      */   }
/*      */ 
/*      */   private static Calendar getWorkCal(Connection paramConnection, Calendar paramCalendar)
/*      */   {
/*      */     Calendar localCalendar;
/* 1218 */     if (paramCalendar == null)
/*      */     {
/* 1221 */       String str = ((oracle.jdbc.OracleConnection)paramConnection).getSessionTimeZone();
/*      */ 
/* 1223 */       if (str == null) {
/* 1224 */         localCalendar = Calendar.getInstance();
/*      */       }
/*      */       else
/* 1227 */         localCalendar = Calendar.getInstance(TimeZone.getTimeZone(str));
/*      */     }
/*      */     else
/*      */     {
/* 1231 */       localCalendar = Calendar.getInstance(paramCalendar.getTimeZone());
/*      */     }
/*      */ 
/* 1234 */     return localCalendar;
/*      */   }
/*      */ 
/*      */   private static Calendar doCalWork(Connection paramConnection, Calendar paramCalendar, byte[] paramArrayOfByte)
/*      */     throws SQLException
/*      */   {
/* 1247 */     boolean bool = paramCalendar.getTimeZone().inDaylightTime(paramCalendar.getTime());
/*      */     int i;
/* 1249 */     if (paramCalendar.getTimeZone().getID() == "Custom") {
/* 1250 */       i = paramCalendar.getTimeZone().getRawOffset();
/* 1251 */       paramArrayOfByte[11] = ((byte)(i / HOUR_MILLISECOND + OFFSET_HOUR));
/*      */ 
/* 1253 */       paramArrayOfByte[12] = ((byte)(i % HOUR_MILLISECOND / MINUTE_MILLISECOND + OFFSET_MINUTE));
/*      */     }
/*      */     else
/*      */     {
/* 1258 */       localObject = paramCalendar.getTimeZone().getID();
/*      */ 
/* 1261 */       int j = ZONEIDMAP.getID((String)localObject);
/*      */ 
/* 1263 */       if (!ZONEIDMAP.isValidID(j)) {
/* 1264 */         if (paramCalendar.getTimeZone().useDaylightTime()) {
/* 1265 */           throw new SQLException("Timezone not supported");
/*      */         }
/*      */ 
/* 1269 */         i = paramCalendar.getTimeZone().getRawOffset();
/* 1270 */         paramArrayOfByte[11] = ((byte)(i / HOUR_MILLISECOND + OFFSET_HOUR));
/*      */ 
/* 1272 */         paramArrayOfByte[12] = ((byte)(i % HOUR_MILLISECOND / MINUTE_MILLISECOND + OFFSET_MINUTE));
/*      */       }
/*      */       else
/*      */       {
/* 1276 */         TIMEZONETAB localTIMEZONETAB = getTIMEZONETAB(paramConnection);
/* 1277 */         if (localTIMEZONETAB.checkID(j)) {
/* 1278 */           localTIMEZONETAB.updateTable(paramConnection, j);
/*      */         }
/*      */ 
/* 1282 */         OffsetDST localOffsetDST = new OffsetDST();
/*      */ 
/* 1285 */         int k = localTIMEZONETAB.getLocalOffset(paramCalendar, j, localOffsetDST);
/* 1286 */         i = localOffsetDST.getOFFSET();
/*      */ 
/* 1288 */         if ((bool) && (k == 1)) {
/* 1289 */           if (localOffsetDST.getDSTFLAG() == 0) {
/* 1290 */             i += HOUR_MILLISECOND;
/*      */           }
/*      */           else {
/* 1293 */             throw new SQLException();
/*      */           }
/*      */ 
/*      */         }
/*      */ 
/* 1298 */         int m = ZONEIDMAP.getID((String)localObject);
/* 1299 */         paramArrayOfByte[11] = ((byte)setHighOrderbits(m));
/*      */         byte[] tmp262_259 = paramArrayOfByte; tmp262_259[11] = ((byte)(tmp262_259[11] | REGIONIDBIT));
/* 1301 */         paramArrayOfByte[12] = ((byte)setLowOrderbits(m));
/*      */       }
/*      */     }
/*      */ 
/* 1305 */     Object localObject = (Calendar)CAL_GMT_US.clone();
/*      */ 
/* 1307 */     ((Calendar)localObject).set(0, paramCalendar.get(0));
/* 1308 */     ((Calendar)localObject).set(1, paramCalendar.get(1));
/* 1309 */     ((Calendar)localObject).set(2, paramCalendar.get(2));
/* 1310 */     ((Calendar)localObject).set(5, paramCalendar.get(5));
/* 1311 */     ((Calendar)localObject).set(11, paramCalendar.get(11));
/* 1312 */     ((Calendar)localObject).set(12, paramCalendar.get(12));
/* 1313 */     ((Calendar)localObject).set(13, paramCalendar.get(13));
/*      */ 
/* 1316 */     ((Calendar)localObject).add(14, -1 * i);
/*      */ 
/* 1318 */     return localObject;
/*      */   }
/*      */ 
/*      */   private static byte[] initTimestamptz()
/*      */   {
/* 1328 */     byte[] arrayOfByte = new byte[13];
/* 1329 */     Calendar localCalendar = Calendar.getInstance();
/*      */ 
/* 1331 */     arrayOfByte[0] = 119;
/* 1332 */     arrayOfByte[1] = -86;
/* 1333 */     arrayOfByte[2] = 1;
/* 1334 */     arrayOfByte[3] = 1;
/* 1335 */     arrayOfByte[4] = 1;
/* 1336 */     arrayOfByte[5] = 1;
/* 1337 */     arrayOfByte[6] = 1;
/* 1338 */     arrayOfByte[7] = 0;
/* 1339 */     arrayOfByte[8] = 0;
/* 1340 */     arrayOfByte[9] = 0;
/* 1341 */     arrayOfByte[10] = 0;
/*      */ 
/* 1343 */     String str = localCalendar.getTimeZone().getID();
/*      */ 
/* 1346 */     arrayOfByte[11] = ((byte)setHighOrderbits(ZONEIDMAP.getID(str)));
/* 1347 */     arrayOfByte[11] = ((byte)(arrayOfByte[11] | REGIONIDBIT));
/* 1348 */     arrayOfByte[12] = ((byte)setLowOrderbits(ZONEIDMAP.getID(str)));
/*      */ 
/* 1351 */     return arrayOfByte;
/*      */   }
/*      */ 
/*      */   public Object toJdbc()
/*      */     throws SQLException
/*      */   {
/* 1363 */     return null;
/*      */   }
/*      */ 
/*      */   public Object makeJdbcArray(int paramInt)
/*      */   {
/* 1375 */     Timestamp[] arrayOfTimestamp = new Timestamp[paramInt];
/*      */ 
/* 1377 */     return arrayOfTimestamp;
/*      */   }
/*      */ 
/*      */   public boolean isConvertibleTo(Class paramClass)
/*      */   {
/* 1389 */     if ((paramClass.getName().compareTo("java.sql.Date") == 0) || (paramClass.getName().compareTo("java.sql.Time") == 0) || (paramClass.getName().compareTo("java.sql.Timestamp") == 0) || (paramClass.getName().compareTo("java.lang.String") == 0))
/*      */     {
/* 1393 */       return true;
/*      */     }
/*      */ 
/* 1396 */     return false;
/*      */   }
/*      */ 
/*      */   private static Timestamp parseTime(String paramString)
/*      */     throws SQLException
/*      */   {
/* 1412 */     if (paramString == null)
/*      */     {
/* 1414 */       localObject1 = DatabaseError.createSqlException(null, 68);
/* 1415 */       ((SQLException)localObject1).fillInStackTrace();
/* 1416 */       throw ((Throwable)localObject1);
/*      */     }
/*      */ 
/* 1421 */     Object localObject1 = paramString.trim();
/* 1422 */     int i = ((String)localObject1).indexOf(' ');
/*      */ 
/* 1424 */     if (i == 0)
/*      */     {
/* 1426 */       localObject2 = DatabaseError.createSqlException(null, 68);
/* 1427 */       ((SQLException)localObject2).fillInStackTrace();
/* 1428 */       throw ((Throwable)localObject2);
/*      */     }
/*      */ 
/* 1436 */     Object localObject2 = ((String)localObject1).substring(0, i);
/* 1437 */     String str1 = ((String)localObject1).substring(i + 1);
/*      */ 
/* 1439 */     if (((localObject2 == null ? 1 : 0) | (str1 == null ? 1 : 0)) != 0)
/*      */     {
/* 1441 */       SQLException localSQLException1 = DatabaseError.createSqlException(null, 68);
/* 1442 */       localSQLException1.fillInStackTrace();
/* 1443 */       throw localSQLException1;
/*      */     }
/*      */ 
/* 1450 */     int j = ((String)localObject2).indexOf('-');
/* 1451 */     int k = ((String)localObject2).indexOf('-', j + 1);
/*      */ 
/* 1453 */     if ((j < 1) || (k < 1) || (k == ((String)localObject2).length()))
/*      */     {
/* 1455 */       localObject3 = DatabaseError.createSqlException(null, 68);
/* 1456 */       ((SQLException)localObject3).fillInStackTrace();
/* 1457 */       throw ((Throwable)localObject3);
/*      */     }
/*      */ 
/* 1461 */     Object localObject3 = ((String)localObject2).substring(0, j);
/* 1462 */     String str2 = ((String)localObject2).substring(j + 1, k);
/* 1463 */     String str3 = ((String)localObject2).substring(k + 1);
/*      */ 
/* 1465 */     if ((((String)localObject3).length() != 4) || (str2.length() != 2) || (str3.length() != 2))
/*      */     {
/* 1469 */       SQLException localSQLException2 = DatabaseError.createSqlException(null, 68);
/* 1470 */       localSQLException2.fillInStackTrace();
/* 1471 */       throw localSQLException2;
/*      */     }
/*      */ 
/* 1476 */     int m = Integer.parseInt((String)localObject3);
/* 1477 */     int n = Integer.parseInt(str2) - 1;
/* 1478 */     int i1 = Integer.parseInt(str3);
/*      */ 
/* 1481 */     int i2 = str1.indexOf(':');
/* 1482 */     int i3 = str1.indexOf(':', i2 + 1);
/*      */ 
/* 1485 */     if ((i2 < 1) || (i3 < 1) || (i3 == str1.length()))
/*      */     {
/* 1487 */       localObject4 = DatabaseError.createSqlException(null, 68);
/* 1488 */       ((SQLException)localObject4).fillInStackTrace();
/* 1489 */       throw ((Throwable)localObject4);
/*      */     }
/*      */ 
/* 1493 */     Object localObject4 = str1.substring(0, i2);
/* 1494 */     String str4 = str1.substring(i2 + 1, i3);
/*      */ 
/* 1496 */     if ((((String)localObject4).length() != 2) || (str4.length() != 2))
/*      */     {
/* 1498 */       SQLException localSQLException3 = DatabaseError.createSqlException(null, 68);
/* 1499 */       localSQLException3.fillInStackTrace();
/* 1500 */       throw localSQLException3;
/*      */     }
/*      */ 
/* 1504 */     int i4 = Integer.parseInt((String)localObject4);
/* 1505 */     int i5 = Integer.parseInt(str4);
/*      */ 
/* 1508 */     int i7 = 0;
/* 1509 */     int i8 = str1.indexOf('.', i3 + 1);
/*      */     int i6;
/* 1511 */     if (i8 == -1)
/*      */     {
/* 1513 */       i6 = Integer.parseInt(str1.substring(i3 + 1));
/*      */     }
/* 1515 */     else if ((i8 > 0) && (i8 < str1.length() - 1))
/*      */     {
/* 1517 */       i6 = Integer.parseInt(str1.substring(i3 + 1, i8));
/*      */ 
/* 1519 */       localObject5 = str1.substring(i8 + 1);
/* 1520 */       localObject6 = "000000000";
/*      */ 
/* 1522 */       if ((((String)localObject5).length() > ((String)localObject6).length()) || (!Character.isDigit(((String)localObject5).charAt(0))))
/*      */       {
/* 1525 */         SQLException localSQLException4 = DatabaseError.createSqlException(null, 68);
/* 1526 */         localSQLException4.fillInStackTrace();
/* 1527 */         throw localSQLException4;
/*      */       }
/*      */ 
/* 1532 */       localObject5 = new StringBuilder().append((String)localObject5).append(((String)localObject6).substring(0, ((String)localObject6).length() - ((String)localObject5).length())).toString();
/*      */ 
/* 1534 */       i7 = Integer.parseInt((String)localObject5);
/*      */     }
/*      */     else
/*      */     {
/* 1538 */       localObject5 = DatabaseError.createSqlException(null, 68);
/* 1539 */       ((SQLException)localObject5).fillInStackTrace();
/* 1540 */       throw ((Throwable)localObject5);
/*      */     }
/*      */ 
/* 1544 */     Object localObject5 = (Calendar)CAL_GMT_US.clone();
/* 1545 */     ((Calendar)localObject5).set(1, m);
/* 1546 */     ((Calendar)localObject5).set(2, n);
/* 1547 */     ((Calendar)localObject5).set(5, i1);
/* 1548 */     ((Calendar)localObject5).set(11, i4);
/* 1549 */     ((Calendar)localObject5).set(12, i5);
/* 1550 */     ((Calendar)localObject5).set(13, i6);
/* 1551 */     ((Calendar)localObject5).set(14, 0);
/*      */ 
/* 1553 */     Object localObject6 = new Timestamp(((Calendar)localObject5).getTime().getTime());
/* 1554 */     ((Timestamp)localObject6).setNanos(i7);
/*      */ 
/* 1556 */     return localObject6;
/*      */   }
/*      */ 
/*      */   private static int setHighOrderbits(int paramInt)
/*      */   {
/* 1575 */     return (paramInt & 0x1FC0) >> 6;
/*      */   }
/*      */ 
/*      */   private static int setLowOrderbits(int paramInt)
/*      */   {
/* 1580 */     return (paramInt & 0x3F) << 2;
/*      */   }
/*      */ 
/*      */   private static int getHighOrderbits(int paramInt)
/*      */   {
/* 1585 */     return (paramInt & 0x7F) << 6;
/*      */   }
/*      */ 
/*      */   private static int getLowOrderbits(int paramInt)
/*      */   {
/* 1590 */     return (paramInt & 0xFC) >> 2;
/*      */   }
/*      */ 
/*      */   static TIMEZONETAB getTIMEZONETAB(Connection paramConnection)
/*      */     throws SQLException
/*      */   {
/* 1598 */     oracle.jdbc.internal.OracleConnection localOracleConnection = ((oracle.jdbc.OracleConnection)paramConnection).physicalConnectionWithin();
/*      */ 
/* 1600 */     return localOracleConnection.getTIMEZONETAB();
/*      */   }
/*      */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.sql.TIMESTAMPTZ
 * JD-Core Version:    0.6.2
 */