/*      */ package oracle.sql;
/*      */ 
/*      */ import java.sql.Connection;
/*      */ import java.sql.SQLException;
/*      */ import java.sql.Time;
/*      */ import java.sql.Timestamp;
/*      */ import java.util.Calendar;
/*      */ import java.util.GregorianCalendar;
/*      */ import java.util.TimeZone;
/*      */ 
/*      */ public class TIMESTAMPLTZ extends Datum
/*      */ {
/* 1113 */   private static int SIZE_TIMESTAMPLTZ = 11;
/* 1114 */   private static int SIZE_TIMESTAMPLTZ_NOFRAC = 7;
/*      */ 
/* 1117 */   private static int SIZE_DATE = 7;
/*      */ 
/* 1120 */   private static int HOUR_MILLISECOND = 3600000;
/*      */ 
/* 1123 */   private static int MINUTE_MILLISECOND = 60000;
/*      */ 
/* 1127 */   private static int JAVA_YEAR = 1970;
/* 1128 */   private static int JAVA_MONTH = 0;
/* 1129 */   private static int JAVA_DATE = 1;
/*      */ 
/* 1131 */   private static int MINYEAR = -4712;
/* 1132 */   private static int MAXYEAR = 9999;
/*      */ 
/* 1481 */   private static boolean cached = false;
/*      */   private static Calendar dbtz;
/*      */   static final long serialVersionUID = 2045880772054757133L;
/* 1485 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*      */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*      */   public static final boolean TRACE = false;
/*      */ 
/*      */   public TIMESTAMPLTZ()
/*      */   {
/*   99 */     super(initTimestampltz());
/*      */   }
/*      */ 
/*      */   public TIMESTAMPLTZ(byte[] paramArrayOfByte)
/*      */   {
/*  114 */     super(paramArrayOfByte);
/*      */   }
/*      */ 
/*      */   /** @deprecated */
/*      */   public TIMESTAMPLTZ(Connection paramConnection, Time paramTime, Calendar paramCalendar)
/*      */     throws SQLException
/*      */   {
/*  132 */     super(toBytes(paramConnection, paramTime, paramCalendar));
/*      */   }
/*      */ 
/*      */   /** @deprecated */
/*      */   public TIMESTAMPLTZ(Connection paramConnection, java.sql.Date paramDate, Calendar paramCalendar)
/*      */     throws SQLException
/*      */   {
/*  150 */     super(toBytes(paramConnection, paramDate, paramCalendar));
/*      */   }
/*      */ 
/*      */   /** @deprecated */
/*      */   public TIMESTAMPLTZ(Connection paramConnection, Timestamp paramTimestamp, Calendar paramCalendar)
/*      */     throws SQLException
/*      */   {
/*  168 */     super(toBytes(paramConnection, paramTimestamp, paramCalendar));
/*      */   }
/*      */ 
/*      */   /** @deprecated */
/*      */   public TIMESTAMPLTZ(Connection paramConnection, DATE paramDATE, Calendar paramCalendar)
/*      */     throws SQLException
/*      */   {
/*  185 */     super(toBytes(paramConnection, paramDATE, paramCalendar));
/*      */   }
/*      */ 
/*      */   /** @deprecated */
/*      */   public TIMESTAMPLTZ(Connection paramConnection, String paramString, Calendar paramCalendar)
/*      */     throws SQLException
/*      */   {
/*  203 */     super(toBytes(paramConnection, paramString, paramCalendar));
/*      */   }
/*      */ 
/*      */   public TIMESTAMPLTZ(Connection paramConnection, Calendar paramCalendar, Time paramTime)
/*      */     throws SQLException
/*      */   {
/*  221 */     super(toBytes(paramConnection, paramCalendar, paramTime));
/*      */   }
/*      */ 
/*      */   public TIMESTAMPLTZ(Connection paramConnection, Calendar paramCalendar, java.sql.Date paramDate)
/*      */     throws SQLException
/*      */   {
/*  238 */     super(toBytes(paramConnection, paramCalendar, paramDate));
/*      */   }
/*      */ 
/*      */   public TIMESTAMPLTZ(Connection paramConnection, Calendar paramCalendar, Timestamp paramTimestamp)
/*      */     throws SQLException
/*      */   {
/*  255 */     super(toBytes(paramConnection, paramCalendar, paramTimestamp));
/*      */   }
/*      */ 
/*      */   public TIMESTAMPLTZ(Connection paramConnection, Calendar paramCalendar, DATE paramDATE)
/*      */     throws SQLException
/*      */   {
/*  272 */     super(toBytes(paramConnection, paramCalendar, paramDATE));
/*      */   }
/*      */ 
/*      */   /** @deprecated */
/*      */   public TIMESTAMPLTZ(Connection paramConnection, Calendar paramCalendar, String paramString)
/*      */     throws SQLException
/*      */   {
/*  290 */     super(toBytes(paramConnection, paramCalendar, paramString));
/*      */   }
/*      */ 
/*      */   public TIMESTAMPLTZ(Connection paramConnection, Time paramTime)
/*      */     throws SQLException
/*      */   {
/*  307 */     super(toBytes(paramConnection, getSessCalendar(paramConnection), paramTime));
/*      */   }
/*      */ 
/*      */   public TIMESTAMPLTZ(Connection paramConnection, java.sql.Date paramDate)
/*      */     throws SQLException
/*      */   {
/*  323 */     super(toBytes(paramConnection, getSessCalendar(paramConnection), paramDate));
/*      */   }
/*      */ 
/*      */   public TIMESTAMPLTZ(Connection paramConnection, Timestamp paramTimestamp)
/*      */     throws SQLException
/*      */   {
/*  340 */     super(toBytes(paramConnection, getSessCalendar(paramConnection), paramTimestamp));
/*      */   }
/*      */ 
/*      */   public TIMESTAMPLTZ(Connection paramConnection, DATE paramDATE)
/*      */     throws SQLException
/*      */   {
/*  357 */     super(toBytes(paramConnection, getSessCalendar(paramConnection), paramDATE));
/*      */   }
/*      */ 
/*      */   /** @deprecated */
/*      */   public TIMESTAMPLTZ(Connection paramConnection, String paramString)
/*      */     throws SQLException
/*      */   {
/*  373 */     super(toBytes(paramConnection, getSessCalendar(paramConnection), Timestamp.valueOf(paramString)));
/*      */   }
/*      */ 
/*      */   public static java.sql.Date toDate(Connection paramConnection, byte[] paramArrayOfByte, Calendar paramCalendar)
/*      */     throws SQLException
/*      */   {
/*  399 */     Calendar localCalendar = toCalendar(paramConnection, Calendar.getInstance(), paramArrayOfByte, paramCalendar);
/*      */ 
/*  401 */     long l = localCalendar.getTime().getTime();
/*      */ 
/*  403 */     return new java.sql.Date(l);
/*      */   }
/*      */ 
/*      */   public static Time toTime(Connection paramConnection, byte[] paramArrayOfByte, Calendar paramCalendar)
/*      */     throws SQLException
/*      */   {
/*  423 */     Calendar localCalendar = toCalendar(paramConnection, Calendar.getInstance(), paramArrayOfByte, paramCalendar);
/*      */ 
/*  429 */     return new Time(localCalendar.get(11), localCalendar.get(12), localCalendar.get(13));
/*      */   }
/*      */ 
/*      */   public static Timestamp toTimestamp(Connection paramConnection, byte[] paramArrayOfByte, Calendar paramCalendar)
/*      */     throws SQLException
/*      */   {
/*  449 */     return toTimestamp(paramConnection, Calendar.getInstance(), paramArrayOfByte, paramCalendar);
/*      */   }
/*      */ 
/*      */   public static DATE toDATE(Connection paramConnection, byte[] paramArrayOfByte, Calendar paramCalendar)
/*      */     throws SQLException
/*      */   {
/*  467 */     return new DATE(toTimestamp(paramConnection, getSessCalendar(paramConnection), paramArrayOfByte, null));
/*      */   }
/*      */ 
/*      */   public Timestamp timestampValue(Connection paramConnection, Calendar paramCalendar)
/*      */     throws SQLException
/*      */   {
/*  481 */     return toTimestamp(paramConnection, getBytes(), paramCalendar);
/*      */   }
/*      */ 
/*      */   public Timestamp timestampValue(Connection paramConnection)
/*      */     throws SQLException
/*      */   {
/*  487 */     return toTimestamp(paramConnection, getBytes());
/*      */   }
/*      */ 
/*      */   /** @deprecated */
/*      */   public static String toString(Connection paramConnection, byte[] paramArrayOfByte, Calendar paramCalendar)
/*      */     throws SQLException
/*      */   {
/*  501 */     Calendar localCalendar = toCalendar(paramConnection, null, paramArrayOfByte, paramCalendar);
/*      */ 
/*  504 */     int i = localCalendar.get(1);
/*      */ 
/*  506 */     if (localCalendar.get(0) == 0) {
/*  507 */       i = -(i - 1);
/*      */     }
/*      */ 
/*  510 */     int j = localCalendar.get(2) + 1;
/*  511 */     int k = localCalendar.get(5);
/*  512 */     int m = localCalendar.get(11);
/*  513 */     int n = localCalendar.get(12);
/*  514 */     int i1 = localCalendar.get(13);
/*  515 */     int i2 = -1;
/*      */ 
/*  517 */     if (paramArrayOfByte.length == SIZE_TIMESTAMPLTZ) {
/*  518 */       i2 = TIMESTAMP.getNanos(paramArrayOfByte, 7);
/*      */     }
/*      */ 
/*  521 */     return TIMESTAMPTZ.toString(i, j, k, m, n, i1, i2, localCalendar.getTimeZone().getID());
/*      */   }
/*      */ 
/*      */   public byte[] toBytes()
/*      */   {
/*  532 */     return getBytes();
/*      */   }
/*      */ 
/*      */   /** @deprecated */
/*      */   public static byte[] toBytes(Connection paramConnection, Time paramTime, Calendar paramCalendar)
/*      */     throws SQLException
/*      */   {
/*  549 */     if (paramTime == null) {
/*  550 */       return null;
/*      */     }
/*      */ 
/*  553 */     Calendar localCalendar = Calendar.getInstance();
/*  554 */     localCalendar.setTime(paramTime);
/*      */     int i;
/*  558 */     if (((oracle.jdbc.OracleConnection)paramConnection).physicalConnectionWithin().getUse1900AsYearForTime())
/*      */     {
/*  560 */       i = 1900;
/*      */     }
/*      */     else {
/*  563 */       i = 1970;
/*      */     }
/*      */ 
/*  566 */     localCalendar.set(1, i);
/*  567 */     localCalendar.set(2, 0);
/*  568 */     localCalendar.set(5, 1);
/*  569 */     byte[] arrayOfByte = toBytes(paramConnection, localCalendar, paramCalendar, 0);
/*  570 */     return arrayOfByte;
/*      */   }
/*      */ 
/*      */   /** @deprecated */
/*      */   public static byte[] toBytes(Connection paramConnection, java.sql.Date paramDate, Calendar paramCalendar)
/*      */     throws SQLException
/*      */   {
/*  587 */     if (paramDate == null) {
/*  588 */       return null;
/*      */     }
/*  590 */     Calendar localCalendar = Calendar.getInstance();
/*  591 */     localCalendar.setTime(paramDate);
/*  592 */     byte[] arrayOfByte = toBytes(paramConnection, localCalendar, paramCalendar, 0);
/*  593 */     return arrayOfByte;
/*      */   }
/*      */ 
/*      */   /** @deprecated */
/*      */   public static byte[] toBytes(Connection paramConnection, Timestamp paramTimestamp, Calendar paramCalendar)
/*      */     throws SQLException
/*      */   {
/*  613 */     if (paramTimestamp == null) {
/*  614 */       return null;
/*      */     }
/*  616 */     Calendar localCalendar = Calendar.getInstance();
/*  617 */     localCalendar.setTime(paramTimestamp);
/*      */ 
/*  620 */     int i = paramTimestamp.getNanos();
/*      */ 
/*  622 */     byte[] arrayOfByte = toBytes(paramConnection, localCalendar, paramCalendar, i);
/*  623 */     return arrayOfByte;
/*      */   }
/*      */ 
/*      */   /** @deprecated */
/*      */   public static byte[] toBytes(Connection paramConnection, DATE paramDATE, Calendar paramCalendar)
/*      */     throws SQLException
/*      */   {
/*  643 */     if (paramDATE == null) {
/*  644 */       return null;
/*      */     }
/*  646 */     Calendar localCalendar = Calendar.getInstance();
/*  647 */     localCalendar.setTime(DATE.toDate(paramDATE.toBytes()));
/*  648 */     byte[] arrayOfByte = toBytes(paramConnection, localCalendar, paramCalendar, 0);
/*  649 */     return arrayOfByte;
/*      */   }
/*      */ 
/*      */   public static byte[] toBytes(Connection paramConnection, String paramString, Calendar paramCalendar)
/*      */     throws SQLException
/*      */   {
/*  664 */     return toBytes(paramConnection, Timestamp.valueOf(paramString), paramCalendar);
/*      */   }
/*      */ 
/*      */   public static java.sql.Date toDate(Connection paramConnection, byte[] paramArrayOfByte)
/*      */     throws SQLException
/*      */   {
/*  681 */     Calendar localCalendar = toCalendar(paramConnection, null, paramArrayOfByte, null);
/*      */ 
/*  683 */     long l = localCalendar.getTime().getTime();
/*      */ 
/*  685 */     return new java.sql.Date(l);
/*      */   }
/*      */ 
/*      */   public static Time toTime(Connection paramConnection, byte[] paramArrayOfByte)
/*      */     throws SQLException
/*      */   {
/*  699 */     Calendar localCalendar = toCalendar(paramConnection, null, paramArrayOfByte, null);
/*      */ 
/*  705 */     return new Time(localCalendar.get(11), localCalendar.get(12), localCalendar.get(13));
/*      */   }
/*      */ 
/*      */   public static Timestamp toTimestamp(Connection paramConnection, byte[] paramArrayOfByte)
/*      */     throws SQLException
/*      */   {
/*  721 */     return toTimestamp(paramConnection, null, paramArrayOfByte, null);
/*      */   }
/*      */ 
/*      */   public static DATE toDATE(Connection paramConnection, byte[] paramArrayOfByte)
/*      */     throws SQLException
/*      */   {
/*  736 */     Calendar localCalendar = toCalendar(paramConnection, null, paramArrayOfByte, null);
/*      */ 
/*  738 */     long l = localCalendar.getTime().getTime();
/*      */ 
/*  740 */     return new DATE(new Timestamp(l));
/*      */   }
/*      */ 
/*      */   public static TIMESTAMP toTIMESTAMP(Connection paramConnection, byte[] paramArrayOfByte)
/*      */     throws SQLException
/*      */   {
/*  756 */     return new TIMESTAMP(toTimestamp(paramConnection, getSessCalendar(paramConnection), paramArrayOfByte, null));
/*      */   }
/*      */ 
/*      */   public static TIMESTAMPTZ toTIMESTAMPTZ(Connection paramConnection, byte[] paramArrayOfByte)
/*      */     throws SQLException
/*      */   {
/*  773 */     return new TIMESTAMPTZ(paramConnection, toTimestamp(paramConnection, getSessCalendar(paramConnection), paramArrayOfByte, null), getSessCalendar(paramConnection));
/*      */   }
/*      */ 
/*      */   public static String toString(Connection paramConnection, byte[] paramArrayOfByte)
/*      */     throws SQLException
/*      */   {
/*  787 */     return toString(paramConnection, paramArrayOfByte, null);
/*      */   }
/*      */ 
/*      */   public static byte[] toBytes(Connection paramConnection, Calendar paramCalendar, Time paramTime)
/*      */     throws SQLException
/*      */   {
/*  802 */     if (paramTime == null)
/*  803 */       return null;
/*      */     Calendar localCalendar1;
/*  807 */     if (paramCalendar == null) {
/*  808 */       localCalendar1 = getSessCalendar(paramConnection);
/*      */     }
/*      */     else {
/*  811 */       localCalendar1 = (Calendar)paramCalendar.clone();
/*      */     }
/*  813 */     localCalendar1.setTime(paramTime);
/*      */     int i;
/*  817 */     if (((oracle.jdbc.OracleConnection)paramConnection).physicalConnectionWithin().getUse1900AsYearForTime())
/*      */     {
/*  819 */       i = 1900;
/*      */     }
/*      */     else {
/*  822 */       i = 1970;
/*      */     }
/*      */ 
/*  825 */     localCalendar1.set(1, i);
/*  826 */     localCalendar1.set(2, 0);
/*  827 */     localCalendar1.set(5, 1);
/*      */ 
/*  830 */     initDbTimeZone(paramConnection);
/*  831 */     Calendar localCalendar2 = (Calendar)dbtz.clone();
/*      */ 
/*  833 */     byte[] arrayOfByte = toBytes(paramConnection, localCalendar1, localCalendar2, 0);
/*  834 */     return arrayOfByte;
/*      */   }
/*      */ 
/*      */   public static byte[] toBytes(Connection paramConnection, Calendar paramCalendar, java.sql.Date paramDate)
/*      */     throws SQLException
/*      */   {
/*  850 */     if (paramDate == null)
/*  851 */       return null;
/*      */     Calendar localCalendar1;
/*  855 */     if (paramCalendar == null) {
/*  856 */       localCalendar1 = getSessCalendar(paramConnection);
/*      */     }
/*      */     else {
/*  859 */       localCalendar1 = (Calendar)paramCalendar.clone();
/*      */     }
/*  861 */     localCalendar1.setTime(paramDate);
/*      */ 
/*  864 */     initDbTimeZone(paramConnection);
/*  865 */     Calendar localCalendar2 = (Calendar)dbtz.clone();
/*      */ 
/*  867 */     byte[] arrayOfByte = toBytes(paramConnection, localCalendar1, localCalendar2, 0);
/*  868 */     return arrayOfByte;
/*      */   }
/*      */ 
/*      */   public static byte[] toBytes(Connection paramConnection, Calendar paramCalendar, Timestamp paramTimestamp)
/*      */     throws SQLException
/*      */   {
/*  887 */     if (paramTimestamp == null)
/*  888 */       return null;
/*      */     Calendar localCalendar1;
/*  892 */     if (paramCalendar == null) {
/*  893 */       localCalendar1 = getSessCalendar(paramConnection);
/*      */     }
/*      */     else {
/*  896 */       localCalendar1 = (Calendar)paramCalendar.clone();
/*      */     }
/*  898 */     localCalendar1.setTime(paramTimestamp);
/*      */ 
/*  900 */     int i = paramTimestamp.getNanos();
/*      */ 
/*  903 */     initDbTimeZone(paramConnection);
/*  904 */     Calendar localCalendar2 = (Calendar)dbtz.clone();
/*      */ 
/*  906 */     byte[] arrayOfByte = toBytes(paramConnection, localCalendar1, localCalendar2, i);
/*  907 */     return arrayOfByte;
/*      */   }
/*      */ 
/*      */   public static byte[] toBytes(Connection paramConnection, Calendar paramCalendar, DATE paramDATE)
/*      */     throws SQLException
/*      */   {
/*  925 */     if (paramDATE == null)
/*  926 */       return null;
/*      */     Calendar localCalendar1;
/*  930 */     if (paramCalendar == null) {
/*  931 */       localCalendar1 = getSessCalendar(paramConnection);
/*      */     }
/*      */     else {
/*  934 */       localCalendar1 = (Calendar)paramCalendar.clone();
/*      */     }
/*      */ 
/*  937 */     localCalendar1.setTime(DATE.toDate(paramDATE.toBytes()));
/*      */ 
/*  940 */     initDbTimeZone(paramConnection);
/*  941 */     Calendar localCalendar2 = (Calendar)dbtz.clone();
/*      */ 
/*  943 */     byte[] arrayOfByte = toBytes(paramConnection, localCalendar1, localCalendar2, 0);
/*  944 */     return arrayOfByte;
/*      */   }
/*      */ 
/*      */   public static byte[] toBytes(Connection paramConnection, Calendar paramCalendar, String paramString)
/*      */     throws SQLException
/*      */   {
/*  959 */     return toBytes(paramConnection, paramCalendar, Timestamp.valueOf(paramString));
/*      */   }
/*      */ 
/*      */   public String stringValue(Connection paramConnection)
/*      */     throws SQLException
/*      */   {
/*  972 */     return toString(paramConnection, getBytes());
/*      */   }
/*      */ 
/*      */   public String stringValue(Connection paramConnection, Calendar paramCalendar)
/*      */     throws SQLException
/*      */   {
/*  987 */     return toString(paramConnection, getBytes(), paramCalendar);
/*      */   }
/*      */ 
/*      */   public java.sql.Date dateValue(Connection paramConnection, Calendar paramCalendar)
/*      */     throws SQLException
/*      */   {
/* 1002 */     return toDate(paramConnection, getBytes(), paramCalendar);
/*      */   }
/*      */ 
/*      */   public java.sql.Date dateValue(Connection paramConnection)
/*      */     throws SQLException
/*      */   {
/* 1016 */     return toDate(paramConnection, getBytes());
/*      */   }
/*      */ 
/*      */   public Time timeValue(Connection paramConnection)
/*      */     throws SQLException
/*      */   {
/* 1027 */     return toTime(paramConnection, getBytes());
/*      */   }
/*      */ 
/*      */   public Time timeValue(Connection paramConnection, Calendar paramCalendar)
/*      */     throws SQLException
/*      */   {
/* 1038 */     return toTime(paramConnection, getBytes(), paramCalendar);
/*      */   }
/*      */ 
/*      */   public Object toJdbc()
/*      */     throws SQLException
/*      */   {
/* 1053 */     return null;
/*      */   }
/*      */ 
/*      */   public Object makeJdbcArray(int paramInt)
/*      */   {
/* 1064 */     Timestamp[] arrayOfTimestamp = new Timestamp[paramInt];
/*      */ 
/* 1066 */     return arrayOfTimestamp;
/*      */   }
/*      */ 
/*      */   public boolean isConvertibleTo(Class paramClass)
/*      */   {
/* 1078 */     if ((paramClass.getName().compareTo("java.sql.Date") == 0) || (paramClass.getName().compareTo("java.sql.Time") == 0) || (paramClass.getName().compareTo("java.sql.Timestamp") == 0) || (paramClass.getName().compareTo("java.lang.String") == 0))
/*      */     {
/* 1082 */       return true;
/*      */     }
/*      */ 
/* 1085 */     return false;
/*      */   }
/*      */ 
/*      */   private static byte[] initTimestampltz()
/*      */   {
/* 1097 */     byte[] arrayOfByte = new byte[SIZE_TIMESTAMPLTZ];
/*      */ 
/* 1099 */     arrayOfByte[0] = 119;
/* 1100 */     arrayOfByte[1] = -86;
/* 1101 */     arrayOfByte[2] = 1;
/* 1102 */     arrayOfByte[3] = 1;
/* 1103 */     arrayOfByte[4] = 1;
/* 1104 */     arrayOfByte[5] = 1;
/* 1105 */     arrayOfByte[6] = 1;
/*      */ 
/* 1107 */     return arrayOfByte;
/*      */   }
/*      */ 
/*      */   private static byte[] toBytes(Connection paramConnection, Calendar paramCalendar1, Calendar paramCalendar2, int paramInt)
/*      */     throws SQLException
/*      */   {
/*      */     byte[] arrayOfByte;
/* 1141 */     if (paramInt == 0) {
/* 1142 */       arrayOfByte = new byte[SIZE_TIMESTAMPLTZ_NOFRAC];
/*      */     }
/*      */     else {
/* 1145 */       arrayOfByte = new byte[SIZE_TIMESTAMPLTZ];
/*      */     }
/*      */ 
/* 1149 */     TimeZoneAdjust(paramConnection, paramCalendar1, paramCalendar2);
/*      */ 
/* 1151 */     int i = TIMESTAMP.getOracleYear(paramCalendar2);
/*      */ 
/* 1153 */     arrayOfByte[0] = ((byte)(i / 100 + 100));
/* 1154 */     arrayOfByte[1] = ((byte)(i % 100 + 100));
/* 1155 */     arrayOfByte[2] = ((byte)(paramCalendar2.get(2) + 1));
/* 1156 */     arrayOfByte[3] = ((byte)paramCalendar2.get(5));
/* 1157 */     arrayOfByte[4] = ((byte)(paramCalendar2.get(11) + 1));
/* 1158 */     arrayOfByte[5] = ((byte)(paramCalendar2.get(12) + 1));
/* 1159 */     arrayOfByte[6] = ((byte)(paramCalendar2.get(13) + 1));
/*      */ 
/* 1165 */     if (paramInt != 0) {
/* 1166 */       arrayOfByte[7] = ((byte)(paramInt >> 24));
/* 1167 */       arrayOfByte[8] = ((byte)(paramInt >> 16 & 0xFF));
/* 1168 */       arrayOfByte[9] = ((byte)(paramInt >> 8 & 0xFF));
/* 1169 */       arrayOfByte[10] = ((byte)(paramInt & 0xFF));
/*      */     }
/*      */ 
/* 1172 */     return arrayOfByte;
/*      */   }
/*      */ 
/*      */   private static Timestamp toTimestamp(Connection paramConnection, Calendar paramCalendar1, byte[] paramArrayOfByte, Calendar paramCalendar2)
/*      */     throws SQLException
/*      */   {
/* 1180 */     Calendar localCalendar = toCalendar(paramConnection, paramCalendar1, paramArrayOfByte, paramCalendar2);
/*      */ 
/* 1183 */     long l = localCalendar.getTime().getTime();
/*      */ 
/* 1186 */     Timestamp localTimestamp = new Timestamp(l);
/* 1187 */     int i = 0;
/*      */ 
/* 1190 */     if (paramArrayOfByte.length == SIZE_TIMESTAMPLTZ) {
/* 1191 */       i = TIMESTAMP.getNanos(paramArrayOfByte, 7);
/*      */     }
/*      */ 
/* 1194 */     localTimestamp.setNanos(i);
/*      */ 
/* 1196 */     return localTimestamp;
/*      */   }
/*      */ 
/*      */   private static final Calendar toCalendar(Connection paramConnection, Calendar paramCalendar1, byte[] paramArrayOfByte, Calendar paramCalendar2)
/*      */     throws SQLException
/*      */   {
/* 1211 */     int i = paramArrayOfByte.length;
/*      */     int[] arrayOfInt;
/* 1213 */     if (i == SIZE_TIMESTAMPLTZ) {
/* 1214 */       arrayOfInt = new int[SIZE_TIMESTAMPLTZ];
/*      */     }
/*      */     else {
/* 1217 */       arrayOfInt = new int[SIZE_TIMESTAMPLTZ_NOFRAC];
/*      */     }
/*      */ 
/* 1220 */     for (int j = 0; j < paramArrayOfByte.length; j++) {
/* 1221 */       paramArrayOfByte[j] &= 255;
/*      */     }
/*      */ 
/* 1225 */     j = TIMESTAMP.getJavaYear(arrayOfInt[0], arrayOfInt[1]);
/*      */ 
/* 1227 */     if (paramCalendar2 == null)
/*      */     {
/* 1229 */       initDbTimeZone(paramConnection);
/*      */ 
/* 1233 */       paramCalendar2 = (Calendar)dbtz.clone();
/*      */     }
/*      */ 
/* 1236 */     paramCalendar2.set(1, j);
/* 1237 */     paramCalendar2.set(2, arrayOfInt[2] - 1);
/* 1238 */     paramCalendar2.set(5, arrayOfInt[3]);
/* 1239 */     paramCalendar2.set(11, arrayOfInt[4] - 1);
/* 1240 */     paramCalendar2.set(12, arrayOfInt[5] - 1);
/* 1241 */     paramCalendar2.set(13, arrayOfInt[6] - 1);
/* 1242 */     paramCalendar2.set(14, 0);
/*      */     Calendar localCalendar;
/* 1245 */     if (paramCalendar1 == null) {
/* 1246 */       localCalendar = getSessCalendar(paramConnection);
/*      */     }
/*      */     else {
/* 1249 */       localCalendar = (Calendar)paramCalendar1.clone();
/*      */     }
/*      */ 
/* 1253 */     TimeZoneAdjust(paramConnection, paramCalendar2, localCalendar);
/*      */ 
/* 1255 */     return localCalendar;
/*      */   }
/*      */ 
/*      */   static void TimeZoneAdjust(Connection paramConnection, Calendar paramCalendar1, Calendar paramCalendar2)
/*      */     throws SQLException
/*      */   {
/* 1265 */     TimeZone localTimeZone = paramCalendar1.getTimeZone();
/*      */ 
/* 1267 */     String str1 = new String(paramCalendar1.getTimeZone().getID());
/* 1268 */     String str2 = new String(paramCalendar2.getTimeZone().getID());
/*      */ 
/* 1271 */     if ((!str2.equals(str1)) && ((!str2.equals("Custom")) || (!str1.equals("Custom"))))
/*      */     {
/* 1274 */       OffsetDST localOffsetDST = new OffsetDST();
/*      */ 
/* 1277 */       k = getZoneOffset(paramConnection, paramCalendar1, localOffsetDST);
/* 1278 */       m = localOffsetDST.getOFFSET();
/*      */ 
/* 1287 */       long l1 = localTimeZone.getOffset(paramCalendar1.getTimeInMillis());
/*      */ 
/* 1289 */       paramCalendar1.add(11, -(m / HOUR_MILLISECOND));
/* 1290 */       paramCalendar1.add(12, -(m % HOUR_MILLISECOND) / MINUTE_MILLISECOND);
/*      */ 
/* 1293 */       long l2 = localTimeZone.getOffset(paramCalendar1.getTimeInMillis());
/*      */ 
/* 1295 */       paramCalendar1.add(14, (int)(l1 - l2));
/*      */       int i;
/* 1299 */       if (str2.equals("Custom")) {
/* 1300 */         i = paramCalendar2.getTimeZone().getRawOffset();
/*      */       }
/*      */       else
/*      */       {
/* 1304 */         n = ZONEIDMAP.getID(str2);
/*      */ 
/* 1306 */         if (!ZONEIDMAP.isValidID(n)) {
/* 1307 */           if (paramCalendar2.getTimeZone().useDaylightTime()) {
/* 1308 */             throw new SQLException("Timezone not supported");
/*      */           }
/* 1310 */           i = paramCalendar2.getTimeZone().getRawOffset();
/*      */         }
/*      */         else {
/* 1313 */           TIMEZONETAB localTIMEZONETAB = getTIMEZONETAB(paramConnection);
/* 1314 */           if (localTIMEZONETAB.checkID(n)) {
/* 1315 */             localTIMEZONETAB.updateTable(paramConnection, n);
/*      */           }
/*      */ 
/* 1318 */           i = localTIMEZONETAB.getOffset(paramCalendar1, n);
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/* 1327 */       l1 = localTimeZone.getOffset(paramCalendar1.getTimeInMillis());
/*      */ 
/* 1330 */       paramCalendar1.add(11, i / HOUR_MILLISECOND);
/* 1331 */       paramCalendar1.add(12, i % HOUR_MILLISECOND / MINUTE_MILLISECOND);
/*      */ 
/* 1334 */       l2 = localTimeZone.getOffset(paramCalendar1.getTimeInMillis());
/*      */ 
/* 1336 */       paramCalendar1.add(14, (int)(l1 - l2));
/*      */     }
/*      */ 
/* 1340 */     if ((str2.equals("Custom")) && (str1.equals("Custom"))) {
/* 1341 */       j = paramCalendar1.getTimeZone().getRawOffset();
/* 1342 */       k = paramCalendar2.getTimeZone().getRawOffset();
/* 1343 */       m = 0;
/*      */ 
/* 1345 */       if (j != k)
/*      */       {
/* 1347 */         m = j - k;
/* 1348 */         m = m > 0 ? m : -m;
/*      */       }
/*      */ 
/* 1351 */       if (j > k) {
/* 1352 */         m = -m;
/*      */       }
/*      */ 
/* 1355 */       paramCalendar1.add(11, m / HOUR_MILLISECOND);
/* 1356 */       paramCalendar1.add(12, m % HOUR_MILLISECOND / MINUTE_MILLISECOND);
/*      */     }
/*      */ 
/* 1361 */     int j = paramCalendar1.get(1);
/* 1362 */     int k = paramCalendar1.get(2);
/* 1363 */     int m = paramCalendar1.get(5);
/* 1364 */     int n = paramCalendar1.get(11);
/* 1365 */     int i1 = paramCalendar1.get(12);
/* 1366 */     int i2 = paramCalendar1.get(13);
/* 1367 */     int i3 = paramCalendar1.get(14);
/*      */ 
/* 1370 */     paramCalendar2.set(1, j);
/* 1371 */     paramCalendar2.set(0, paramCalendar1.get(0));
/* 1372 */     paramCalendar2.set(2, k);
/* 1373 */     paramCalendar2.set(5, m);
/* 1374 */     paramCalendar2.set(11, n);
/* 1375 */     paramCalendar2.set(12, i1);
/* 1376 */     paramCalendar2.set(13, i2);
/* 1377 */     paramCalendar2.set(14, i3);
/*      */   }
/*      */ 
/*      */   private static byte getZoneOffset(Connection paramConnection, Calendar paramCalendar, OffsetDST paramOffsetDST)
/*      */     throws SQLException
/*      */   {
/* 1385 */     byte b = 0;
/*      */ 
/* 1388 */     if (paramCalendar.getTimeZone().getID() == "Custom") {
/* 1389 */       paramOffsetDST.setOFFSET(paramCalendar.getTimeZone().getRawOffset());
/*      */     }
/*      */     else
/*      */     {
/* 1393 */       String str = new String(paramCalendar.getTimeZone().getID());
/*      */ 
/* 1396 */       int i = ZONEIDMAP.getID(str);
/* 1397 */       if (!ZONEIDMAP.isValidID(i)) {
/* 1398 */         if (paramCalendar.getTimeZone().useDaylightTime()) {
/* 1399 */           throw new SQLException("Timezone not supported");
/*      */         }
/*      */ 
/* 1402 */         paramOffsetDST.setOFFSET(paramCalendar.getTimeZone().getRawOffset());
/*      */       }
/*      */       else {
/* 1405 */         TIMEZONETAB localTIMEZONETAB = getTIMEZONETAB(paramConnection);
/* 1406 */         if (localTIMEZONETAB.checkID(i)) {
/* 1407 */           localTIMEZONETAB.updateTable(paramConnection, i);
/*      */         }
/*      */ 
/* 1411 */         b = localTIMEZONETAB.getLocalOffset(paramCalendar, i, paramOffsetDST);
/*      */       }
/*      */     }
/*      */ 
/* 1415 */     return b;
/*      */   }
/*      */ 
/*      */   private static Calendar getDbTzCalendar(String paramString)
/*      */   {
/* 1422 */     int i = paramString.charAt(0);
/*      */     String str;
/* 1424 */     if ((i == 43) || (i == 45)) {
/* 1425 */       str = "GMT" + paramString;
/*      */     }
/*      */     else {
/* 1428 */       str = paramString;
/*      */     }
/*      */ 
/* 1432 */     TimeZone localTimeZone = TimeZone.getTimeZone(str);
/*      */ 
/* 1434 */     return new GregorianCalendar(localTimeZone);
/*      */   }
/*      */ 
/*      */   static Calendar getSessCalendar(Connection paramConnection)
/*      */   {
/* 1440 */     String str = ((oracle.jdbc.OracleConnection)paramConnection).getSessionTimeZone();
/*      */     Calendar localCalendar;
/* 1443 */     if (str == null)
/*      */     {
/* 1445 */       localCalendar = Calendar.getInstance();
/*      */     }
/*      */     else {
/* 1448 */       TimeZone localTimeZone = TimeZone.getTimeZone(str);
/* 1449 */       localCalendar = Calendar.getInstance(localTimeZone);
/*      */     }
/*      */ 
/* 1452 */     return localCalendar;
/*      */   }
/*      */ 
/*      */   private static synchronized void initDbTimeZone(Connection paramConnection)
/*      */     throws SQLException
/*      */   {
/* 1464 */     if (!cached) {
/* 1465 */       oracle.jdbc.internal.OracleConnection localOracleConnection = ((oracle.jdbc.OracleConnection)paramConnection).physicalConnectionWithin();
/*      */ 
/* 1467 */       String str = localOracleConnection.getDatabaseTimeZone();
/* 1468 */       dbtz = getDbTzCalendar(str);
/* 1469 */       cached = true;
/*      */     }
/*      */   }
/*      */ 
/*      */   static TIMEZONETAB getTIMEZONETAB(Connection paramConnection)
/*      */     throws SQLException
/*      */   {
/* 1476 */     oracle.jdbc.internal.OracleConnection localOracleConnection = ((oracle.jdbc.OracleConnection)paramConnection).physicalConnectionWithin();
/*      */ 
/* 1478 */     return localOracleConnection.getTIMEZONETAB();
/*      */   }
/*      */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.sql.TIMESTAMPLTZ
 * JD-Core Version:    0.6.2
 */