/*     */ package oracle.sql;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.ObjectInputStream;
/*     */ import java.io.Serializable;
/*     */ import java.sql.Connection;
/*     */ import java.sql.SQLException;
/*     */ import java.sql.Time;
/*     */ import java.sql.Timestamp;
/*     */ import java.util.Calendar;
/*     */ import java.util.TimeZone;
/*     */ 
/*     */ public class TIMESTAMP extends Datum
/*     */   implements Serializable
/*     */ {
/*     */   static final int CENTURY_DEFAULT = 119;
/*     */   static final int DECADE_DEFAULT = 100;
/*     */   static final int MONTH_DEFAULT = 1;
/*     */   static final int DAY_DEFAULT = 1;
/*     */   static final int DECADE_INIT = 170;
/*     */   static final int JAVA_YEAR = 1970;
/*     */   static final int JAVA_MONTH = 0;
/*     */   static final int JAVA_DATE = 1;
/*     */   public static final int SIZE_DATE = 7;
/*     */   public static final int SIZE_TIMESTAMP = 11;
/*     */   public static final int SIZE_TIMESTAMP_NOFRAC = 7;
/*     */   static final int SIZE_TIMESTAMPTZ = 13;
/*     */   static final int MINYEAR = -4712;
/*     */   static final int MAXYEAR = 9999;
/*     */   static final int JANMONTH = 1;
/*     */   static final int DECMONTH = 12;
/*     */   static final int MINDAYS = 1;
/*     */   static final int MAXDAYS = 31;
/*     */   static final int MINHOURS = 1;
/*     */   static final int MAXHOURS = 24;
/*     */   static final int MINMINUTES = 1;
/*     */   static final int MAXMINUTES = 60;
/*     */   static final int MINSECONDS = 1;
/*     */   static final int MAXSECONDS = 60;
/* 980 */   static final int[] daysInMonth = { 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31 };
/*     */   static final long serialVersionUID = -7964732752952728545L;
/* 987 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   public TIMESTAMP()
/*     */   {
/*  78 */     super(initTimestamp());
/*     */   }
/*     */ 
/*     */   public TIMESTAMP(byte[] paramArrayOfByte)
/*     */   {
/*  92 */     super(paramArrayOfByte);
/*     */   }
/*     */ 
/*     */   public TIMESTAMP(Time paramTime)
/*     */   {
/* 107 */     super(toBytes(paramTime));
/*     */   }
/*     */ 
/*     */   public TIMESTAMP(java.sql.Date paramDate)
/*     */   {
/* 121 */     super(toBytes(paramDate));
/*     */   }
/*     */ 
/*     */   public TIMESTAMP(Timestamp paramTimestamp)
/*     */   {
/* 135 */     super(toBytes(paramTimestamp));
/*     */   }
/*     */ 
/*     */   public TIMESTAMP(Timestamp paramTimestamp, Calendar paramCalendar)
/*     */   {
/* 152 */     super(toBytes(paramTimestamp, paramCalendar));
/*     */   }
/*     */ 
/*     */   public TIMESTAMP(DATE paramDATE)
/*     */   {
/* 167 */     super(toBytes(paramDATE));
/*     */   }
/*     */ 
/*     */   public static final int getNanos(byte[] paramArrayOfByte, int paramInt)
/*     */   {
/* 175 */     int i = (paramArrayOfByte[paramInt] & 0xFF) << 24;
/* 176 */     i |= (paramArrayOfByte[(paramInt + 1)] & 0xFF) << 16;
/* 177 */     i |= (paramArrayOfByte[(paramInt + 2)] & 0xFF) << 8;
/* 178 */     i |= paramArrayOfByte[(paramInt + 3)] & 0xFF & 0xFF;
/* 179 */     return i;
/*     */   }
/*     */ 
/*     */   public TIMESTAMP(String paramString)
/*     */   {
/* 193 */     super(toBytes(paramString));
/*     */   }
/*     */ 
/*     */   public static java.sql.Date toDate(byte[] paramArrayOfByte)
/*     */     throws SQLException
/*     */   {
/* 225 */     int i = paramArrayOfByte.length;
/*     */     int[] arrayOfInt;
/* 227 */     if (i == 11) {
/* 228 */       arrayOfInt = new int[11];
/*     */     }
/*     */     else {
/* 231 */       arrayOfInt = new int[7];
/*     */     }
/*     */ 
/* 234 */     for (int j = 0; j < paramArrayOfByte.length; j++) {
/* 235 */       paramArrayOfByte[j] &= 255;
/*     */     }
/*     */ 
/* 239 */     j = getJavaYear(arrayOfInt[0], arrayOfInt[1]);
/*     */ 
/* 243 */     Calendar localCalendar = Calendar.getInstance();
/*     */ 
/* 245 */     localCalendar.set(1, j);
/* 246 */     localCalendar.set(2, arrayOfInt[2] - 1);
/* 247 */     localCalendar.set(5, arrayOfInt[3]);
/* 248 */     localCalendar.set(11, arrayOfInt[4] - 1);
/* 249 */     localCalendar.set(12, arrayOfInt[5] - 1);
/* 250 */     localCalendar.set(13, arrayOfInt[6] - 1);
/*     */ 
/* 252 */     int k = 0;
/* 253 */     if (i == 11) {
/* 254 */       k = getNanos(paramArrayOfByte, 7) / 1000;
/*     */     }
/* 256 */     localCalendar.set(14, k);
/*     */ 
/* 259 */     long l = localCalendar.getTime().getTime();
/*     */ 
/* 262 */     return new java.sql.Date(l);
/*     */   }
/*     */ 
/*     */   public static Time toTime(byte[] paramArrayOfByte)
/*     */     throws SQLException
/*     */   {
/* 281 */     int i = paramArrayOfByte[4] & 0xFF;
/* 282 */     int j = paramArrayOfByte[5] & 0xFF;
/* 283 */     int k = paramArrayOfByte[6] & 0xFF;
/*     */ 
/* 285 */     return new Time(i - 1, j - 1, k - 1);
/*     */   }
/*     */ 
/*     */   public static Timestamp toTimestamp(byte[] paramArrayOfByte)
/*     */     throws SQLException
/*     */   {
/* 300 */     return toTimestamp(paramArrayOfByte, null);
/*     */   }
/*     */ 
/*     */   public static Timestamp toTimestamp(byte[] paramArrayOfByte, Calendar paramCalendar)
/*     */     throws SQLException
/*     */   {
/* 316 */     int i = paramArrayOfByte.length;
/*     */     int[] arrayOfInt;
/* 318 */     if (i == 11) {
/* 319 */       arrayOfInt = new int[11];
/*     */     }
/*     */     else {
/* 322 */       arrayOfInt = new int[7];
/*     */     }
/*     */ 
/* 325 */     for (int j = 0; j < paramArrayOfByte.length; j++) {
/* 326 */       paramArrayOfByte[j] &= 255;
/*     */     }
/*     */ 
/* 330 */     j = getJavaYear(arrayOfInt[0], arrayOfInt[1]);
/*     */     Calendar localCalendar;
/* 333 */     if (paramCalendar == null) {
/* 334 */       localCalendar = Calendar.getInstance();
/*     */     }
/*     */     else {
/* 337 */       localCalendar = Calendar.getInstance(paramCalendar.getTimeZone());
/*     */     }
/*     */ 
/* 340 */     localCalendar.clear();
/*     */ 
/* 342 */     localCalendar.set(1, j);
/* 343 */     localCalendar.set(2, arrayOfInt[2] - 1);
/* 344 */     localCalendar.set(5, arrayOfInt[3]);
/* 345 */     localCalendar.set(11, arrayOfInt[4] - 1);
/* 346 */     localCalendar.set(12, arrayOfInt[5] - 1);
/* 347 */     localCalendar.set(13, arrayOfInt[6] - 1);
/* 348 */     localCalendar.set(14, 0);
/*     */ 
/* 351 */     long l = localCalendar.getTime().getTime();
/*     */ 
/* 354 */     Timestamp localTimestamp = new Timestamp(l);
/*     */ 
/* 356 */     int k = 0;
/*     */ 
/* 358 */     if (i == 11) {
/* 359 */       k = getNanos(paramArrayOfByte, 7);
/*     */     }
/*     */ 
/* 363 */     localTimestamp.setNanos(k);
/*     */ 
/* 365 */     return localTimestamp;
/*     */   }
/*     */ 
/*     */   public static DATE toDATE(byte[] paramArrayOfByte)
/*     */     throws SQLException
/*     */   {
/* 380 */     byte[] arrayOfByte = new byte[7];
/*     */ 
/* 382 */     System.arraycopy(paramArrayOfByte, 0, arrayOfByte, 0, 7);
/*     */ 
/* 384 */     return new DATE(arrayOfByte);
/*     */   }
/*     */ 
/*     */   public Timestamp timestampValue()
/*     */     throws SQLException
/*     */   {
/* 396 */     return toTimestamp(getBytes());
/*     */   }
/*     */ 
/*     */   public Timestamp timestampValue(Calendar paramCalendar)
/*     */     throws SQLException
/*     */   {
/* 408 */     return toTimestamp(getBytes(), paramCalendar);
/*     */   }
/*     */ 
/*     */   public static String toString(byte[] paramArrayOfByte)
/*     */   {
/* 420 */     int[] arrayOfInt = new int[paramArrayOfByte.length];
/*     */ 
/* 422 */     for (int i = 0; i < paramArrayOfByte.length; i++) {
/* 423 */       if (paramArrayOfByte[i] < 0) {
/* 424 */         paramArrayOfByte[i] += 256;
/*     */       }
/*     */       else {
/* 427 */         arrayOfInt[i] = paramArrayOfByte[i];
/*     */       }
/*     */     }
/*     */ 
/* 431 */     i = getJavaYear(arrayOfInt[0], arrayOfInt[1]);
/* 432 */     int j = arrayOfInt[2];
/* 433 */     int k = arrayOfInt[3];
/* 434 */     int m = arrayOfInt[4] - 1;
/* 435 */     int n = arrayOfInt[5] - 1;
/* 436 */     int i1 = arrayOfInt[6] - 1;
/* 437 */     int i2 = 0;
/*     */ 
/* 439 */     if (paramArrayOfByte.length > 7)
/*     */     {
/* 441 */       i2 = getNanos(paramArrayOfByte, 7);
/*     */     }
/*     */ 
/* 444 */     return TIMESTAMPTZ.toString(i, j, k, m, n, i1, i2, null);
/*     */   }
/*     */ 
/*     */   public byte[] toBytes()
/*     */   {
/* 455 */     return getBytes();
/*     */   }
/*     */ 
/*     */   public static byte[] toBytes(Time paramTime)
/*     */   {
/* 469 */     if (paramTime == null) {
/* 470 */       return null;
/*     */     }
/*     */ 
/* 473 */     byte[] arrayOfByte = new byte[7];
/* 474 */     Calendar localCalendar = Calendar.getInstance();
/* 475 */     localCalendar.setTime(paramTime);
/*     */ 
/* 477 */     arrayOfByte[0] = 119;
/* 478 */     arrayOfByte[1] = -86;
/* 479 */     arrayOfByte[2] = 1;
/* 480 */     arrayOfByte[3] = 1;
/* 481 */     arrayOfByte[4] = ((byte)(localCalendar.get(11) + 1));
/* 482 */     arrayOfByte[5] = ((byte)(localCalendar.get(12) + 1));
/* 483 */     arrayOfByte[6] = ((byte)(localCalendar.get(13) + 1));
/*     */ 
/* 485 */     return arrayOfByte;
/*     */   }
/*     */ 
/*     */   public static byte[] toBytes(java.sql.Date paramDate)
/*     */   {
/* 499 */     if (paramDate == null) {
/* 500 */       return null;
/*     */     }
/*     */ 
/* 503 */     byte[] arrayOfByte = new byte[7];
/* 504 */     Calendar localCalendar = Calendar.getInstance();
/*     */ 
/* 506 */     localCalendar.setTime(paramDate);
/*     */ 
/* 508 */     int i = getOracleYear(localCalendar);
/*     */ 
/* 510 */     arrayOfByte[0] = ((byte)(i / 100 + 100));
/* 511 */     arrayOfByte[1] = ((byte)(i % 100 + 100));
/* 512 */     arrayOfByte[2] = ((byte)(localCalendar.get(2) + 1));
/* 513 */     arrayOfByte[3] = ((byte)localCalendar.get(5));
/* 514 */     arrayOfByte[4] = ((byte)(localCalendar.get(11) + 1));
/* 515 */     arrayOfByte[5] = ((byte)(localCalendar.get(12) + 1));
/* 516 */     arrayOfByte[6] = ((byte)(localCalendar.get(13) + 1));
/*     */ 
/* 518 */     return arrayOfByte;
/*     */   }
/*     */ 
/*     */   public static byte[] toBytes(Timestamp paramTimestamp)
/*     */   {
/* 532 */     return toBytes(paramTimestamp, null);
/*     */   }
/*     */ 
/*     */   public static byte[] toBytes(Timestamp paramTimestamp, Calendar paramCalendar)
/*     */   {
/* 547 */     if (paramTimestamp == null) {
/* 548 */       return null;
/*     */     }
/*     */ 
/* 553 */     int i = paramTimestamp.getNanos();
/*     */     byte[] arrayOfByte;
/* 557 */     if (i == 0) {
/* 558 */       arrayOfByte = new byte[7];
/*     */     }
/*     */     else
/* 561 */       arrayOfByte = new byte[11];
/*     */     Calendar localCalendar;
/* 566 */     if (paramCalendar == null) {
/* 567 */       localCalendar = Calendar.getInstance();
/*     */     }
/*     */     else {
/* 570 */       localCalendar = Calendar.getInstance(paramCalendar.getTimeZone());
/*     */     }
/*     */ 
/* 573 */     localCalendar.setTime(paramTimestamp);
/*     */ 
/* 575 */     int j = getOracleYear(localCalendar);
/*     */ 
/* 577 */     arrayOfByte[0] = ((byte)(j / 100 + 100));
/* 578 */     arrayOfByte[1] = ((byte)(j % 100 + 100));
/* 579 */     arrayOfByte[2] = ((byte)(localCalendar.get(2) + 1));
/* 580 */     arrayOfByte[3] = ((byte)localCalendar.get(5));
/* 581 */     arrayOfByte[4] = ((byte)(localCalendar.get(11) + 1));
/* 582 */     arrayOfByte[5] = ((byte)(localCalendar.get(12) + 1));
/* 583 */     arrayOfByte[6] = ((byte)(localCalendar.get(13) + 1));
/*     */ 
/* 590 */     if (i != 0) {
/* 591 */       arrayOfByte[7] = ((byte)(i >> 24));
/* 592 */       arrayOfByte[8] = ((byte)(i >> 16 & 0xFF));
/* 593 */       arrayOfByte[9] = ((byte)(i >> 8 & 0xFF));
/* 594 */       arrayOfByte[10] = ((byte)(i & 0xFF));
/*     */     }
/*     */ 
/* 597 */     return arrayOfByte;
/*     */   }
/*     */ 
/*     */   public static byte[] toBytes(DATE paramDATE)
/*     */   {
/* 611 */     if (paramDATE == null) {
/* 612 */       return null;
/*     */     }
/*     */ 
/* 615 */     byte[] arrayOfByte = new byte[7];
/*     */ 
/* 617 */     System.arraycopy(paramDATE.getBytes(), 0, arrayOfByte, 0, 7);
/*     */ 
/* 619 */     return arrayOfByte;
/*     */   }
/*     */ 
/*     */   public static byte[] toBytes(String paramString)
/*     */   {
/* 629 */     return toBytes(Timestamp.valueOf(paramString));
/*     */   }
/*     */ 
/*     */   public Object toJdbc()
/*     */     throws SQLException
/*     */   {
/* 640 */     return timestampValue();
/*     */   }
/*     */ 
/*     */   public Object makeJdbcArray(int paramInt)
/*     */   {
/* 651 */     Timestamp[] arrayOfTimestamp = new Timestamp[paramInt];
/*     */ 
/* 653 */     return arrayOfTimestamp;
/*     */   }
/*     */ 
/*     */   public boolean isConvertibleTo(Class paramClass)
/*     */   {
/* 665 */     if ((paramClass.getName().compareTo("java.sql.Date") == 0) || (paramClass.getName().compareTo("java.sql.Time") == 0) || (paramClass.getName().compareTo("java.sql.Timestamp") == 0) || (paramClass.getName().compareTo("java.lang.String") == 0))
/*     */     {
/* 669 */       return true;
/*     */     }
/*     */ 
/* 672 */     return false;
/*     */   }
/*     */ 
/*     */   public static TIMESTAMP TimeZoneConvert(Connection paramConnection, TIMESTAMP paramTIMESTAMP, TimeZone paramTimeZone1, TimeZone paramTimeZone2)
/*     */     throws SQLException
/*     */   {
/* 701 */     byte[] arrayOfByte = paramTIMESTAMP.getBytes();
/*     */ 
/* 703 */     int i = arrayOfByte.length;
/*     */     int[] arrayOfInt;
/* 705 */     if (i == 11) {
/* 706 */       arrayOfInt = new int[11];
/*     */     }
/*     */     else {
/* 709 */       arrayOfInt = new int[7];
/*     */     }
/*     */ 
/* 713 */     for (int j = 0; j < i; j++) {
/* 714 */       arrayOfByte[j] &= 255;
/*     */     }
/*     */ 
/* 718 */     j = getJavaYear(arrayOfInt[0], arrayOfInt[1]);
/* 719 */     int k = arrayOfInt[2] - 1;
/* 720 */     int m = arrayOfInt[3];
/* 721 */     int n = arrayOfInt[4] - 1;
/* 722 */     int i1 = arrayOfInt[5] - 1;
/* 723 */     int i2 = arrayOfInt[6] - 1;
/*     */ 
/* 725 */     Calendar localCalendar1 = Calendar.getInstance(paramTimeZone1);
/*     */ 
/* 728 */     localCalendar1.set(1, j);
/* 729 */     localCalendar1.set(2, k);
/* 730 */     localCalendar1.set(5, m);
/* 731 */     localCalendar1.set(11, n);
/* 732 */     localCalendar1.set(12, i1);
/* 733 */     localCalendar1.set(13, i2);
/*     */ 
/* 737 */     localCalendar1.set(14, 0);
/*     */ 
/* 740 */     long l = localCalendar1.getTimeInMillis();
/*     */ 
/* 743 */     Timestamp localTimestamp = new Timestamp(l);
/*     */ 
/* 745 */     int i3 = 0;
/*     */ 
/* 750 */     if (i == 11) {
/* 751 */       i3 = getNanos(arrayOfByte, 7);
/*     */     }
/* 753 */     localTimestamp.setNanos(i3);
/*     */ 
/* 756 */     Calendar localCalendar2 = Calendar.getInstance(paramTimeZone2);
/* 757 */     return new TIMESTAMP(localTimestamp, localCalendar2);
/*     */   }
/*     */ 
/*     */   public String stringValue()
/*     */   {
/* 767 */     return toString(getBytes());
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 772 */     return stringValue();
/*     */   }
/*     */ 
/*     */   public static int getOracleYear(Calendar paramCalendar)
/*     */   {
/* 779 */     int i = paramCalendar.get(1);
/*     */ 
/* 781 */     if (paramCalendar.get(0) == 0) {
/* 782 */       i = -i;
/*     */     }
/*     */ 
/* 785 */     if ((i < -4712) || (i > 9999)) {
/* 786 */       throw new IllegalArgumentException("Invalid year value");
/*     */     }
/*     */ 
/* 789 */     return i;
/*     */   }
/*     */ 
/*     */   public java.sql.Date dateValue()
/*     */     throws SQLException
/*     */   {
/* 802 */     return toDate(getBytes());
/*     */   }
/*     */ 
/*     */   public Time timeValue()
/*     */     throws SQLException
/*     */   {
/* 813 */     return toTime(getBytes());
/*     */   }
/*     */ 
/*     */   public static int getJavaYear(int paramInt1, int paramInt2)
/*     */   {
/* 822 */     int i = (paramInt1 - 100) * 100 + (paramInt2 - 100);
/*     */ 
/* 824 */     if (i <= 0) {
/* 825 */       i++;
/*     */     }
/*     */ 
/* 828 */     return i;
/*     */   }
/*     */ 
/*     */   private static byte[] initTimestamp()
/*     */   {
/* 840 */     byte[] arrayOfByte = new byte[11];
/*     */ 
/* 842 */     arrayOfByte[0] = 119;
/* 843 */     arrayOfByte[1] = -86;
/* 844 */     arrayOfByte[2] = 1;
/* 845 */     arrayOfByte[3] = 1;
/* 846 */     arrayOfByte[4] = 1;
/* 847 */     arrayOfByte[5] = 1;
/* 848 */     arrayOfByte[6] = 1;
/*     */ 
/* 850 */     return arrayOfByte;
/*     */   }
/*     */ 
/*     */   private boolean isLeapYear(int paramInt)
/*     */   {
/* 861 */     return (paramInt % 4 == 0) && (paramInt <= 1582 ? paramInt == -4712 : (paramInt % 100 != 0) || (paramInt % 400 == 0));
/*     */   }
/*     */ 
/*     */   private boolean isValid()
/*     */   {
/* 871 */     byte[] arrayOfByte = getBytes();
/*     */ 
/* 873 */     if ((arrayOfByte.length != 11) && (arrayOfByte.length != 7))
/*     */     {
/* 875 */       return false;
/*     */     }
/*     */ 
/* 879 */     int i = ((arrayOfByte[0] & 0xFF) - 100) * 100 + ((arrayOfByte[1] & 0xFF) - 100);
/* 880 */     if ((i < -4712) || (i > 9999)) {
/* 881 */       return false;
/*     */     }
/*     */ 
/* 885 */     if (i == 0) {
/* 886 */       return false;
/*     */     }
/*     */ 
/* 890 */     int j = arrayOfByte[2] & 0xFF;
/* 891 */     if ((j < 1) || (j > 12)) {
/* 892 */       return false;
/*     */     }
/*     */ 
/* 896 */     int k = arrayOfByte[3] & 0xFF;
/* 897 */     if ((k < 1) || (k > 31)) {
/* 898 */       return false;
/*     */     }
/* 900 */     if ((k > daysInMonth[(j - 1)]) && (
/* 901 */       (!isLeapYear(i)) || (j != 2) || (k != 29))) {
/* 902 */       return false;
/*     */     }
/*     */ 
/* 907 */     if ((i == 1582) && (j == 10) && (k >= 5) && (k < 15)) {
/* 908 */       return false;
/*     */     }
/*     */ 
/* 912 */     int m = arrayOfByte[4] & 0xFF;
/* 913 */     if ((m < 1) || (m > 24)) {
/* 914 */       return false;
/*     */     }
/*     */ 
/* 918 */     int n = arrayOfByte[5] & 0xFF;
/* 919 */     if ((n < 1) || (n > 60)) {
/* 920 */       return false;
/*     */     }
/*     */ 
/* 924 */     int i1 = arrayOfByte[6] & 0xFF;
/* 925 */     if ((i1 < 1) || (i1 > 60)) {
/* 926 */       return false;
/*     */     }
/*     */ 
/* 932 */     return true;
/*     */   }
/*     */ 
/*     */   private void readObject(ObjectInputStream paramObjectInputStream)
/*     */     throws IOException, ClassNotFoundException
/*     */   {
/* 939 */     paramObjectInputStream.defaultReadObject();
/* 940 */     if (!isValid())
/* 941 */       throw new IOException("Invalid TIMESTAMP");
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.sql.TIMESTAMP
 * JD-Core Version:    0.6.2
 */