/*      */ package oracle.sql;
/*      */ 
/*      */ import java.io.IOException;
/*      */ import java.io.ObjectInputStream;
/*      */ import java.io.ObjectOutputStream;
/*      */ import java.io.Serializable;
/*      */ import java.sql.Connection;
/*      */ import java.sql.PreparedStatement;
/*      */ import java.sql.ResultSet;
/*      */ import java.sql.ResultSetMetaData;
/*      */ import java.sql.SQLException;
/*      */ import java.sql.SQLInput;
/*      */ import java.sql.SQLOutput;
/*      */ import java.util.Map;
/*      */ import oracle.jdbc.OracleTypeMetaData.Kind;
/*      */ import oracle.jdbc.driver.DatabaseError;
/*      */ import oracle.jdbc.internal.OracleTypeMetaData.Struct;
/*      */ import oracle.jdbc.oracore.OracleNamedType;
/*      */ import oracle.jdbc.oracore.OracleType;
/*      */ import oracle.jdbc.oracore.OracleTypeADT;
/*      */ 
/*      */ /** @deprecated */
/*      */ public class StructDescriptor extends TypeDescriptor
/*      */   implements OracleTypeMetaData.Struct, Serializable
/*      */ {
/*      */   static final boolean DEBUG = false;
/*      */   static final long serialVersionUID = 1013921343538311063L;
/* 1398 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*      */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*      */   public static final boolean TRACE = false;
/*      */ 
/*      */   public static StructDescriptor createDescriptor(String paramString, Connection paramConnection)
/*      */     throws SQLException
/*      */   {
/*   74 */     return createDescriptor(paramString, paramConnection, false, false);
/*      */   }
/*      */ 
/*      */   public static StructDescriptor createDescriptor(String paramString, Connection paramConnection, boolean paramBoolean1, boolean paramBoolean2)
/*      */     throws SQLException
/*      */   {
/*   94 */     if ((paramString == null) || (paramString.length() == 0) || (paramConnection == null))
/*      */     {
/*   97 */       localObject = DatabaseError.createSqlException(null, 60, "Invalid arguments");
/*   98 */       ((SQLException)localObject).fillInStackTrace();
/*   99 */       throw ((Throwable)localObject);
/*      */     }
/*      */ 
/*  103 */     Object localObject = new SQLName(paramString, (oracle.jdbc.OracleConnection)paramConnection);
/*      */ 
/*  105 */     String str = ((SQLName)localObject).getName();
/*  106 */     StructDescriptor localStructDescriptor = null;
/*  107 */     if (!paramBoolean2)
/*      */     {
/*  110 */       localStructDescriptor = (StructDescriptor)((oracle.jdbc.OracleConnection)paramConnection).getDescriptor(str);
/*      */ 
/*  114 */       if (localStructDescriptor == null)
/*      */       {
/*  116 */         int i = ((oracle.jdbc.OracleConnection)paramConnection).physicalConnectionWithin().getVersionNumber();
/*  117 */         if (i >= 12000) {
/*  118 */           localStructDescriptor = new StructDescriptor(paramString, paramConnection);
/*      */         }
/*      */         else {
/*  121 */           localStructDescriptor = new StructDescriptor((SQLName)localObject, paramConnection);
/*      */         }
/*  123 */         if (paramBoolean1) localStructDescriptor.initNamesRecursively();
/*  124 */         ((oracle.jdbc.OracleConnection)paramConnection).putDescriptor(str, localStructDescriptor);
/*      */       }
/*      */     }
/*  127 */     return localStructDescriptor;
/*      */   }
/*      */ 
/*      */   /** @deprecated */
/*      */   public static StructDescriptor createDescriptor(SQLName paramSQLName, Connection paramConnection, boolean paramBoolean1, boolean paramBoolean2)
/*      */     throws SQLException
/*      */   {
/*  149 */     String str = paramSQLName.getName();
/*  150 */     StructDescriptor localStructDescriptor = null;
/*  151 */     if (!paramBoolean2)
/*      */     {
/*  154 */       localStructDescriptor = (StructDescriptor)((oracle.jdbc.OracleConnection)paramConnection).getDescriptor(str);
/*      */ 
/*  158 */       if (localStructDescriptor == null)
/*      */       {
/*  160 */         localStructDescriptor = new StructDescriptor(paramSQLName, paramConnection);
/*  161 */         if (paramBoolean1) localStructDescriptor.initNamesRecursively();
/*  162 */         ((oracle.jdbc.OracleConnection)paramConnection).putDescriptor(str, localStructDescriptor);
/*      */       }
/*      */     }
/*  165 */     return localStructDescriptor;
/*      */   }
/*      */ 
/*      */   /** @deprecated */
/*      */   public static StructDescriptor createDescriptor(SQLName paramSQLName, Connection paramConnection)
/*      */     throws SQLException
/*      */   {
/*  184 */     return createDescriptor(paramSQLName, paramConnection, false, false);
/*      */   }
/*      */ 
/*      */   public static StructDescriptor createDescriptor(OracleTypeADT paramOracleTypeADT)
/*      */     throws SQLException
/*      */   {
/*  201 */     String str = paramOracleTypeADT.getFullName();
/*  202 */     oracle.jdbc.internal.OracleConnection localOracleConnection = paramOracleTypeADT.getConnection();
/*  203 */     StructDescriptor localStructDescriptor = (StructDescriptor)localOracleConnection.getDescriptor(str);
/*      */ 
/*  207 */     if (localStructDescriptor == null)
/*      */     {
/*  209 */       SQLName localSQLName = new SQLName(paramOracleTypeADT.getSchemaName(), paramOracleTypeADT.getSimpleName(), paramOracleTypeADT.getConnection());
/*      */ 
/*  211 */       localStructDescriptor = new StructDescriptor(localSQLName, paramOracleTypeADT, localOracleConnection);
/*      */ 
/*  213 */       localOracleConnection.putDescriptor(str, localStructDescriptor);
/*      */     }
/*  215 */     return localStructDescriptor;
/*      */   }
/*      */ 
/*      */   /** @deprecated */
/*      */   public static StructDescriptor createDescriptor(SQLName paramSQLName, byte[] paramArrayOfByte1, int paramInt, byte[] paramArrayOfByte2, oracle.jdbc.internal.OracleConnection paramOracleConnection)
/*      */     throws SQLException
/*      */   {
/*  232 */     OracleTypeADT localOracleTypeADT = new OracleTypeADT(paramSQLName, paramArrayOfByte1, paramInt, paramArrayOfByte2, paramOracleConnection);
/*  233 */     return new StructDescriptor(paramSQLName, localOracleTypeADT, paramOracleConnection);
/*      */   }
/*      */ 
/*      */   public StructDescriptor(OracleTypeADT paramOracleTypeADT, Connection paramConnection)
/*      */     throws SQLException
/*      */   {
/*  250 */     super((short)108, paramOracleTypeADT, paramConnection);
/*      */   }
/*      */ 
/*      */   public StructDescriptor(String paramString, Connection paramConnection)
/*      */     throws SQLException
/*      */   {
/*  265 */     super((short)108, paramString, paramConnection);
/*      */ 
/*  267 */     initPickler();
/*      */   }
/*      */ 
/*      */   public StructDescriptor(SQLName paramSQLName, Connection paramConnection)
/*      */     throws SQLException
/*      */   {
/*  281 */     super((short)108, paramSQLName, paramConnection);
/*      */ 
/*  283 */     initPickler();
/*      */   }
/*      */ 
/*      */   public StructDescriptor(SQLName paramSQLName, OracleTypeADT paramOracleTypeADT, Connection paramConnection)
/*      */     throws SQLException
/*      */   {
/*  298 */     super((short)108, paramSQLName, paramOracleTypeADT, paramConnection);
/*      */ 
/*  302 */     this.toid = paramOracleTypeADT.getTOID();
/*      */   }
/*      */ 
/*      */   StructDescriptor(byte[] paramArrayOfByte, int paramInt, Connection paramConnection)
/*      */     throws SQLException
/*      */   {
/*  313 */     super((short)108);
/*      */ 
/*  315 */     this.toid = paramArrayOfByte;
/*  316 */     this.toidVersion = paramInt;
/*  317 */     setPhysicalConnectionOf(paramConnection);
/*  318 */     initPickler();
/*      */   }
/*      */ 
/*      */   StructDescriptor(AttributeDescriptor[] paramArrayOfAttributeDescriptor, Connection paramConnection)
/*      */     throws SQLException
/*      */   {
/*  329 */     super((short)108);
/*      */ 
/*  331 */     this.attributesDescriptor = paramArrayOfAttributeDescriptor;
/*  332 */     setPhysicalConnectionOf(paramConnection);
/*  333 */     this.isTransient = true;
/*      */ 
/*  336 */     initPickler();
/*  337 */     this.isInstanciable = Boolean.TRUE;
/*      */   }
/*      */ 
/*      */   private void initPickler()
/*      */     throws SQLException
/*      */   {
/*  346 */     String str = null;
/*      */     try
/*      */     {
/*  349 */       if (this.isTransient) {
/*  350 */         str = getName();
/*  351 */         this.pickler = new OracleTypeADT(this.attributesDescriptor, this.connection);
/*      */       }
/*      */       else
/*      */       {
/*  355 */         if (this.typeNameByUser == null) {
/*  356 */           str = getName();
/*      */         }
/*      */         else {
/*  359 */           str = this.typeNameByUser;
/*      */         }
/*  361 */         this.pickler = new OracleTypeADT(str, this.connection);
/*  362 */         ((OracleTypeADT)this.pickler).init(this.connection);
/*  363 */         this.toid = ((OracleTypeADT)this.pickler).getTOID();
/*      */       }
/*      */ 
/*  366 */       this.pickler.setDescriptor(this);
/*      */     }
/*      */     catch (Exception localException)
/*      */     {
/*  370 */       if ((localException instanceof SQLException)) {
/*  371 */         throw ((SQLException)localException);
/*      */       }
/*      */ 
/*  375 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 60, "Unable to resolve type \"" + str + "\"");
/*      */ 
/*  377 */       localSQLException.fillInStackTrace();
/*  378 */       throw localSQLException;
/*      */     }
/*      */   }
/*      */ 
/*      */   public OracleTypeMetaData.Kind getKind()
/*      */   {
/*  395 */     return OracleTypeMetaData.Kind.STRUCT;
/*      */   }
/*      */ 
/*      */   public int getTypeCode()
/*      */     throws SQLException
/*      */   {
/*  407 */     int i = getOracleTypeADT().getTypeCode();
/*  408 */     return i;
/*      */   }
/*      */ 
/*      */   public int getTypeVersion()
/*      */     throws SQLException
/*      */   {
/*  420 */     int i = getOracleTypeADT().getTypeVersion();
/*  421 */     return i;
/*      */   }
/*      */ 
/*      */   void setAttributesDescriptor(AttributeDescriptor[] paramArrayOfAttributeDescriptor)
/*      */   {
/*  428 */     this.attributesDescriptor = paramArrayOfAttributeDescriptor;
/*      */   }
/*      */ 
/*      */   public AttributeDescriptor[] getAttributesDescriptor()
/*      */   {
/*  434 */     return this.attributesDescriptor;
/*      */   }
/*      */ 
/*      */   byte[] toBytes(STRUCT paramSTRUCT, boolean paramBoolean)
/*      */     throws SQLException
/*      */   {
/*  446 */     Object localObject1 = paramSTRUCT.shareBytes();
/*      */     Object localObject2;
/*  448 */     if (localObject1 == null)
/*      */     {
/*  450 */       if (paramSTRUCT.datumArray != null)
/*      */       {
/*  452 */         localObject1 = this.pickler.linearize(paramSTRUCT);
/*      */ 
/*  454 */         if (!paramBoolean) {
/*  455 */           paramSTRUCT.setShareBytes(null);
/*      */         }
/*      */       }
/*  458 */       else if (paramSTRUCT.objectArray != null)
/*      */       {
/*  460 */         paramSTRUCT.datumArray = toOracleArray(paramSTRUCT.objectArray);
/*  461 */         localObject1 = this.pickler.linearize(paramSTRUCT);
/*      */ 
/*  463 */         if (!paramBoolean)
/*      */         {
/*  465 */           paramSTRUCT.datumArray = null;
/*      */ 
/*  467 */           paramSTRUCT.setShareBytes(null);
/*      */         }
/*      */ 
/*      */       }
/*      */       else
/*      */       {
/*  473 */         localObject2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 1);
/*  474 */         ((SQLException)localObject2).fillInStackTrace();
/*  475 */         throw ((Throwable)localObject2);
/*      */       }
/*      */ 
/*      */     }
/*  482 */     else if (paramSTRUCT.imageLength != 0L)
/*      */     {
/*  484 */       if ((paramSTRUCT.imageOffset != 0L) || (paramSTRUCT.imageLength != localObject1.length))
/*      */       {
/*  486 */         localObject2 = new byte[(int)paramSTRUCT.imageLength];
/*      */ 
/*  488 */         System.arraycopy(localObject1, (int)paramSTRUCT.imageOffset, localObject2, 0, (int)paramSTRUCT.imageLength);
/*      */ 
/*  490 */         paramSTRUCT.setImage((byte[])localObject2, 0L, 0L);
/*      */ 
/*  492 */         localObject1 = localObject2;
/*      */       }
/*      */     }
/*      */ 
/*  496 */     return localObject1;
/*      */   }
/*      */ 
/*      */   Datum[] toOracleArray(STRUCT paramSTRUCT, boolean paramBoolean)
/*      */     throws SQLException
/*      */   {
/*  504 */     Datum[] arrayOfDatum1 = paramSTRUCT.datumArray;
/*  505 */     Datum[] arrayOfDatum2 = null;
/*      */ 
/*  507 */     if (arrayOfDatum1 == null)
/*      */     {
/*  509 */       if (paramSTRUCT.objectArray != null)
/*      */       {
/*  511 */         arrayOfDatum1 = toOracleArray(paramSTRUCT.objectArray);
/*      */       }
/*  513 */       else if (paramSTRUCT.shareBytes() != null)
/*      */       {
/*  515 */         if (((paramSTRUCT.shareBytes()[0] & 0x80) <= 0) && (((OracleTypeADT)this.pickler).isEmbeddedADT()))
/*      */         {
/*  520 */           this.pickler = OracleTypeADT.shallowClone((OracleTypeADT)this.pickler);
/*      */         }
/*      */ 
/*  524 */         this.pickler.unlinearize(paramSTRUCT.shareBytes(), paramSTRUCT.imageOffset, paramSTRUCT, 1, null);
/*      */ 
/*  526 */         arrayOfDatum1 = paramSTRUCT.datumArray;
/*      */ 
/*  528 */         if (!paramBoolean) {
/*  529 */           paramSTRUCT.datumArray = null;
/*      */         }
/*      */       }
/*      */       else
/*      */       {
/*  534 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 1);
/*  535 */         localSQLException.fillInStackTrace();
/*  536 */         throw localSQLException;
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*  542 */     if (paramBoolean)
/*      */     {
/*  544 */       paramSTRUCT.datumArray = arrayOfDatum1;
/*  545 */       arrayOfDatum2 = (Datum[])arrayOfDatum1.clone();
/*      */     }
/*      */     else
/*      */     {
/*  549 */       arrayOfDatum2 = arrayOfDatum1;
/*      */     }
/*  551 */     return arrayOfDatum2;
/*      */   }
/*      */ 
/*      */   Object[] toArray(STRUCT paramSTRUCT, Map paramMap, boolean paramBoolean)
/*      */     throws SQLException
/*      */   {
/*  561 */     Object[] arrayOfObject = null;
/*      */ 
/*  563 */     if (paramSTRUCT.objectArray == null)
/*      */     {
/*  565 */       if (paramSTRUCT.datumArray != null)
/*      */       {
/*  567 */         arrayOfObject = new Object[paramSTRUCT.datumArray.length];
/*      */ 
/*  569 */         for (int i = 0; i < paramSTRUCT.datumArray.length; i++)
/*      */         {
/*  571 */           if (paramSTRUCT.datumArray[i] != null)
/*      */           {
/*  573 */             if ((paramSTRUCT.datumArray[i] instanceof STRUCT))
/*  574 */               arrayOfObject[i] = ((STRUCT)paramSTRUCT.datumArray[i]).toJdbc(paramMap);
/*      */             else
/*  576 */               arrayOfObject[i] = paramSTRUCT.datumArray[i].toJdbc();
/*      */           }
/*      */         }
/*      */       }
/*  580 */       else if (paramSTRUCT.shareBytes() != null)
/*      */       {
/*  582 */         if (((paramSTRUCT.shareBytes()[0] & 0x80) <= 0) && (((OracleTypeADT)this.pickler).isEmbeddedADT()))
/*      */         {
/*  587 */           this.pickler = OracleTypeADT.shallowClone((OracleTypeADT)this.pickler);
/*      */         }
/*      */ 
/*  590 */         this.pickler.unlinearize(paramSTRUCT.shareBytes(), paramSTRUCT.imageOffset, paramSTRUCT, 2, paramMap);
/*      */ 
/*  592 */         arrayOfObject = paramSTRUCT.objectArray;
/*      */ 
/*  595 */         paramSTRUCT.objectArray = null;
/*      */       }
/*      */       else
/*      */       {
/*  601 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 1);
/*  602 */         localSQLException.fillInStackTrace();
/*  603 */         throw localSQLException;
/*      */       }
/*      */ 
/*      */     }
/*      */     else
/*      */     {
/*  610 */       arrayOfObject = (Object[])paramSTRUCT.objectArray.clone();
/*      */     }
/*  612 */     return arrayOfObject;
/*      */   }
/*      */ 
/*      */   public int getLength()
/*      */     throws SQLException
/*      */   {
/*  629 */     return getFieldTypes().length;
/*      */   }
/*      */ 
/*      */   public OracleTypeADT getOracleTypeADT()
/*      */     throws SQLException
/*      */   {
/*  640 */     if (this.pickler == null)
/*  641 */       initPickler();
/*  642 */     OracleTypeADT localOracleTypeADT = (OracleTypeADT)this.pickler;
/*  643 */     return localOracleTypeADT;
/*      */   }
/*      */ 
/*      */   private OracleType[] getFieldTypes()
/*      */     throws SQLException
/*      */   {
/*  654 */     return ((OracleTypeADT)this.pickler).getAttrTypes();
/*      */   }
/*      */ 
/*      */   public SQLInput toJdbc2SQLInput(STRUCT paramSTRUCT, Map paramMap)
/*      */     throws SQLException
/*      */   {
/*  669 */     return new OracleJdbc2SQLInput(toOracleArray(paramSTRUCT, false), paramMap, this.connection);
/*      */   }
/*      */ 
/*      */   public SQLOutput toJdbc2SQLOutput()
/*      */     throws SQLException
/*      */   {
/*  682 */     return new OracleSQLOutput(this, this.connection);
/*      */   }
/*      */ 
/*      */   public Datum[] toOracleArray(Object[] paramArrayOfObject)
/*      */     throws SQLException
/*      */   {
/*  698 */     Datum[] arrayOfDatum = null;
/*      */ 
/*  700 */     if (paramArrayOfObject != null)
/*      */     {
/*  702 */       OracleType[] arrayOfOracleType = getFieldTypes();
/*  703 */       int i = arrayOfOracleType.length;
/*      */ 
/*  706 */       if (paramArrayOfObject.length != i)
/*      */       {
/*  709 */         localObject = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 49, null);
/*  710 */         ((SQLException)localObject).fillInStackTrace();
/*  711 */         throw ((Throwable)localObject);
/*      */       }
/*      */ 
/*  716 */       arrayOfDatum = new Datum[i];
/*      */ 
/*  718 */       Object localObject = this.connection;
/*      */ 
/*  721 */       for (int j = 0; j < i; j++) {
/*  722 */         arrayOfDatum[j] = arrayOfOracleType[j].toDatumInternal(paramArrayOfObject[j], (oracle.jdbc.internal.OracleConnection)localObject);
/*      */       }
/*      */     }
/*  725 */     return arrayOfDatum;
/*      */   }
/*      */ 
/*      */   public Datum[] toOracleArray(Map paramMap)
/*      */     throws SQLException
/*      */   {
/*  732 */     Datum[] arrayOfDatum = null;
/*  733 */     int i = 0;
/*      */ 
/*  735 */     if (paramMap != null)
/*      */     {
/*  737 */       OracleType[] arrayOfOracleType = getFieldTypes();
/*  738 */       int j = arrayOfOracleType.length;
/*  739 */       int k = paramMap.size();
/*      */ 
/*  742 */       arrayOfDatum = new Datum[j];
/*      */ 
/*  744 */       oracle.jdbc.internal.OracleConnection localOracleConnection = this.connection;
/*      */ 
/*  747 */       for (int m = 0; m < j; m++)
/*      */       {
/*  749 */         Object localObject = paramMap.get(((OracleTypeADT)this.pickler).getAttributeName(m + 1));
/*      */ 
/*  752 */         arrayOfDatum[m] = arrayOfOracleType[m].toDatum(localObject, localOracleConnection);
/*      */ 
/*  754 */         if ((localObject != null) || (paramMap.containsKey(((OracleTypeADT)this.pickler).getAttributeName(m + 1))))
/*      */         {
/*  757 */           i++;
/*      */         }
/*      */       }
/*  760 */       if (i < k)
/*      */       {
/*  768 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68, null);
/*  769 */         localSQLException.fillInStackTrace();
/*  770 */         throw localSQLException;
/*      */       }
/*      */     }
/*      */ 
/*  774 */     return arrayOfDatum;
/*      */   }
/*      */ 
/*      */   public ResultSetMetaData getMetaData()
/*      */     throws SQLException
/*      */   {
/*  796 */     return this.connection.newStructMetaData(this);
/*      */   }
/*      */ 
/*      */   public boolean isFinalType()
/*      */     throws SQLException
/*      */   {
/*  813 */     return getOracleTypeADT().isFinalType();
/*      */   }
/*      */ 
/*      */   public boolean isSubtype()
/*      */     throws SQLException
/*      */   {
/*  830 */     return getOracleTypeADT().isSubType();
/*      */   }
/*      */ 
/*      */   public boolean isInHierarchyOf(String paramString)
/*      */     throws SQLException
/*      */   {
/*  844 */     StructDescriptor localStructDescriptor = this;
/*  845 */     String str = localStructDescriptor.getName();
/*  846 */     boolean bool = false;
/*      */ 
/*  848 */     if (paramString.equals(str)) {
/*  849 */       bool = true;
/*      */     }
/*      */     else {
/*      */       while (true)
/*      */       {
/*  854 */         str = localStructDescriptor.getSupertypeName();
/*      */ 
/*  856 */         if (str == null)
/*      */         {
/*  858 */           bool = false;
/*      */ 
/*  860 */           break;
/*      */         }
/*      */ 
/*  863 */         if (paramString.equals(str))
/*      */         {
/*  865 */           bool = true;
/*      */ 
/*  867 */           break;
/*      */         }
/*      */ 
/*  870 */         localStructDescriptor = createDescriptor(str, this.connection);
/*      */       }
/*      */     }
/*      */ 
/*  874 */     return bool;
/*      */   }
/*      */ 
/*      */   public boolean isInstantiable()
/*      */     throws SQLException
/*      */   {
/*  891 */     if (this.isInstanciable == null)
/*  892 */       this.isInstanciable = getOracleTypeADT().isInstanciable();
/*  893 */     return this.isInstanciable.booleanValue();
/*      */   }
/*      */ 
/*      */   public boolean isJavaObject()
/*      */     throws SQLException
/*      */   {
/*  912 */     return getOracleTypeADT().isJavaObject();
/*      */   }
/*      */ 
/*      */   public String getSupertypeName()
/*      */     throws SQLException
/*      */   {
/*  930 */     String str = null;
/*      */ 
/*  932 */     if (isSubtype())
/*      */     {
/*  934 */       if (this.supertype == null) {
/*  935 */         this.supertype = getOracleTypeADT().getSuperTypeName();
/*      */       }
/*  937 */       str = this.supertype;
/*      */     }
/*      */ 
/*  940 */     return str;
/*      */   }
/*      */ 
/*      */   public int getLocalAttributeCount()
/*      */     throws SQLException
/*      */   {
/*      */     int i;
/*  959 */     if (!isSubtype()) {
/*  960 */       i = getOracleTypeADT().getAttrTypes().length;
/*      */     }
/*      */     else {
/*  963 */       if (this.numLocalAttrs == -1) {
/*  964 */         this.numLocalAttrs = getOracleTypeADT().getNumberOfLocalAttributes();
/*      */       }
/*  966 */       i = this.numLocalAttrs;
/*      */     }
/*  968 */     return i;
/*      */   }
/*      */ 
/*      */   public String[] getSubtypeNames()
/*      */     throws SQLException
/*      */   {
/*  986 */     if (this.subtypes == null)
/*  987 */       this.subtypes = getOracleTypeADT().getSubtypeNames();
/*  988 */     return this.subtypes;
/*      */   }
/*      */ 
/*      */   public String getJavaClassName()
/*      */     throws SQLException
/*      */   {
/* 1006 */     String str = null;
/*      */ 
/* 1008 */     if (isJavaObject()) {
/* 1009 */       str = getJavaObjectClassName(this.connection, this);
/*      */     }
/* 1011 */     return str;
/*      */   }
/*      */ 
/*      */   public String getAttributeJavaName(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1025 */     String str = null;
/*      */ 
/* 1027 */     if (isJavaObject())
/*      */     {
/* 1029 */       if (this.attrJavaNames == null) {
/* 1030 */         initMetaData3();
/*      */       }
/* 1032 */       str = this.attrJavaNames[paramInt];
/*      */     }
/* 1034 */     return str;
/*      */   }
/*      */ 
/*      */   public String[] getAttributeJavaNames()
/*      */     throws SQLException
/*      */   {
/* 1047 */     String[] arrayOfString = null;
/*      */ 
/* 1049 */     if (isJavaObject())
/*      */     {
/* 1051 */       if (this.attrJavaNames == null) {
/* 1052 */         initMetaData3();
/*      */       }
/* 1054 */       arrayOfString = this.attrJavaNames;
/*      */     }
/*      */     else
/*      */     {
/* 1058 */       arrayOfString = new String[0];
/*      */     }
/* 1060 */     return arrayOfString;
/*      */   }
/*      */ 
/*      */   public String getLanguage()
/*      */     throws SQLException
/*      */   {
/* 1076 */     String str = null;
/*      */ 
/* 1078 */     if (isJavaObject())
/* 1079 */       str = "JAVA";
/*      */     else {
/* 1081 */       str = "SQL";
/*      */     }
/* 1083 */     return str;
/*      */   }
/*      */ 
/*      */   public static String getJavaObjectClassName(Connection paramConnection, StructDescriptor paramStructDescriptor)
/*      */     throws SQLException
/*      */   {
/* 1099 */     return getJavaObjectClassName(paramConnection, paramStructDescriptor.getSchemaName(), paramStructDescriptor.getTypeName());
/*      */   }
/*      */ 
/*      */   public static String getJavaObjectClassName(Connection paramConnection, String paramString1, String paramString2)
/*      */     throws SQLException
/*      */   {
/* 1114 */     PreparedStatement localPreparedStatement = null;
/* 1115 */     ResultSet localResultSet = null;
/* 1116 */     String str = null;
/* 1117 */     oracle.jdbc.internal.OracleConnection localOracleConnection = ((oracle.jdbc.OracleConnection)paramConnection).physicalConnectionWithin();
/* 1118 */     ((oracle.jdbc.internal.OracleConnection)localOracleConnection).beginNonRequestCalls();
/*      */     try {
/* 1120 */       localPreparedStatement = paramConnection.prepareStatement("select external_name from all_sqlj_types where owner = :1 and type_name = :2");
/*      */ 
/* 1123 */       localPreparedStatement.setString(1, paramString1);
/* 1124 */       localPreparedStatement.setString(2, paramString2);
/*      */ 
/* 1126 */       localResultSet = localPreparedStatement.executeQuery();
/*      */ 
/* 1128 */       if (localResultSet.next()) {
/* 1129 */         str = localResultSet.getString(1);
/*      */       }
/*      */       else
/*      */       {
/* 1133 */         SQLException localSQLException1 = DatabaseError.createSqlException(null, 100);
/* 1134 */         localSQLException1.fillInStackTrace();
/* 1135 */         throw localSQLException1;
/*      */       }
/*      */     }
/*      */     catch (SQLException localSQLException2)
/*      */     {
/*      */     }
/*      */     finally
/*      */     {
/* 1143 */       if (localResultSet != null) {
/* 1144 */         localResultSet.close();
/*      */       }
/*      */ 
/* 1147 */       if (localPreparedStatement != null) {
/* 1148 */         localPreparedStatement.close();
/*      */       }
/*      */ 
/* 1154 */       ((oracle.jdbc.internal.OracleConnection)localOracleConnection).endNonRequestCalls();
/*      */     }
/* 1156 */     return str;
/*      */   }
/*      */ 
/*      */   public String descType()
/*      */     throws SQLException
/*      */   {
/* 1173 */     StringBuffer localStringBuffer = new StringBuffer();
/*      */ 
/* 1175 */     return descType(localStringBuffer, 0);
/*      */   }
/*      */ 
/*      */   String descType(StringBuffer paramStringBuffer, int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1182 */     String str1 = "";
/*      */ 
/* 1184 */     for (int i = 0; i < paramInt; i++) {
/* 1185 */       str1 = str1 + "  ";
/*      */     }
/* 1187 */     String str2 = str1 + "  ";
/*      */ 
/* 1189 */     paramStringBuffer.append(str1);
/* 1190 */     paramStringBuffer.append(getTypeName());
/* 1191 */     paramStringBuffer.append("\n");
/* 1192 */     paramStringBuffer.append(str1);
/* 1193 */     paramStringBuffer.append("Subtype=" + getOracleTypeADT().isSubType());
/* 1194 */     paramStringBuffer.append(" JavaObject=" + getOracleTypeADT().isJavaObject());
/* 1195 */     paramStringBuffer.append(" FinalType=" + getOracleTypeADT().isFinalType());
/* 1196 */     paramStringBuffer.append("\n");
/*      */ 
/* 1198 */     ResultSetMetaData localResultSetMetaData = getMetaData();
/* 1199 */     int j = localResultSetMetaData.getColumnCount();
/*      */ 
/* 1201 */     for (int k = 0; k < j; k++)
/*      */     {
/* 1203 */       int m = localResultSetMetaData.getColumnType(k + 1);
/*      */       Object localObject;
/* 1205 */       if ((m == 2002) || (m == 2008))
/*      */       {
/* 1208 */         localObject = createDescriptor(localResultSetMetaData.getColumnTypeName(k + 1), this.connection);
/*      */ 
/* 1212 */         ((StructDescriptor)localObject).descType(paramStringBuffer, paramInt + 1);
/*      */       }
/* 1214 */       else if (m == 2003)
/*      */       {
/* 1216 */         localObject = ArrayDescriptor.createDescriptor(localResultSetMetaData.getColumnTypeName(k + 1), this.connection);
/*      */ 
/* 1220 */         ((ArrayDescriptor)localObject).descType(paramStringBuffer, paramInt + 1);
/*      */       }
/* 1222 */       else if (m == 2007)
/*      */       {
/* 1224 */         localObject = OpaqueDescriptor.createDescriptor(localResultSetMetaData.getColumnTypeName(k + 1), this.connection);
/*      */ 
/* 1228 */         ((OpaqueDescriptor)localObject).descType(paramStringBuffer, paramInt + 1);
/*      */       }
/*      */       else
/*      */       {
/* 1232 */         paramStringBuffer.append(str2);
/* 1233 */         paramStringBuffer.append(localResultSetMetaData.getColumnTypeName(k + 1));
/* 1234 */         paramStringBuffer.append("\n");
/*      */       }
/*      */     }
/*      */ 
/* 1238 */     return paramStringBuffer.substring(0, paramStringBuffer.length());
/*      */   }
/*      */ 
/*      */   public byte[] toBytes(Object[] paramArrayOfObject)
/*      */     throws SQLException
/*      */   {
/* 1261 */     Datum[] arrayOfDatum = toOracleArray(paramArrayOfObject);
/*      */ 
/* 1263 */     return toBytes(arrayOfDatum);
/*      */   }
/*      */ 
/*      */   /** @deprecated */
/*      */   public byte[] toBytes(Datum[] paramArrayOfDatum)
/*      */     throws SQLException
/*      */   {
/* 1283 */     STRUCT localSTRUCT = new STRUCT(this, (byte[])null, this.connection);
/*      */ 
/* 1285 */     localSTRUCT.setDatumArray(paramArrayOfDatum);
/*      */ 
/* 1287 */     return this.pickler.linearize(localSTRUCT);
/*      */   }
/*      */ 
/*      */   public Datum[] toArray(Object[] paramArrayOfObject)
/*      */     throws SQLException
/*      */   {
/* 1303 */     return toOracleArray(paramArrayOfObject);
/*      */   }
/*      */ 
/*      */   public Datum[] toArray(byte[] paramArrayOfByte)
/*      */     throws SQLException
/*      */   {
/* 1317 */     STRUCT localSTRUCT = new STRUCT(this, paramArrayOfByte, this.connection);
/*      */ 
/* 1319 */     return toOracleArray(localSTRUCT, false);
/*      */   }
/*      */ 
/*      */   private void initMetaData3()
/*      */     throws SQLException
/*      */   {
/* 1329 */     synchronized (this.connection)
/*      */     {
/* 1331 */       if (this.attrJavaNames == null)
/*      */       {
/* 1334 */         this.connection.beginNonRequestCalls();
/* 1335 */         String[] arrayOfString = null;
/* 1336 */         PreparedStatement localPreparedStatement = null;
/* 1337 */         ResultSet localResultSet = null;
/*      */         try
/*      */         {
/* 1341 */           localPreparedStatement = this.connection.prepareStatement("select EXTERNAL_ATTR_NAME, ATTR_NO from all_sqlj_type_attrs where owner = :1 and type_name = :2");
/*      */ 
/* 1344 */           localPreparedStatement.setString(1, getSchemaName());
/* 1345 */           localPreparedStatement.setString(2, getTypeName());
/*      */ 
/* 1347 */           localResultSet = localPreparedStatement.executeQuery();
/* 1348 */           arrayOfString = new String[getOracleTypeADT().getAttrTypes().length];
/*      */ 
/* 1351 */           for (int i = 0; localResultSet.next(); i++)
/* 1352 */             arrayOfString[(localResultSet.getInt(2) - 1)] = localResultSet.getString(1);
/*      */         }
/*      */         finally
/*      */         {
/* 1356 */           if (localResultSet != null) {
/* 1357 */             localResultSet.close();
/*      */           }
/* 1359 */           if (localPreparedStatement != null) {
/* 1360 */             localPreparedStatement.close();
/*      */           }
/*      */ 
/* 1365 */           this.connection.endNonRequestCalls();
/*      */         }
/*      */ 
/* 1368 */         this.attrJavaNames = arrayOfString;
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   String tagName()
/*      */   {
/* 1377 */     return "StructDescriptor";
/*      */   }
/*      */ 
/*      */   private void writeObject(ObjectOutputStream paramObjectOutputStream)
/*      */     throws IOException
/*      */   {
/*      */   }
/*      */ 
/*      */   private void readObject(ObjectInputStream paramObjectInputStream)
/*      */     throws IOException, ClassNotFoundException
/*      */   {
/*      */   }
/*      */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.sql.StructDescriptor
 * JD-Core Version:    0.6.2
 */