/*      */ package oracle.sql;
/*      */ 
/*      */ import java.io.PrintStream;
/*      */ import java.io.PrintWriter;
/*      */ import java.io.StringWriter;
/*      */ import java.security.AccessController;
/*      */ import java.security.PrivilegedAction;
/*      */ import java.sql.Connection;
/*      */ import java.sql.ResultSetMetaData;
/*      */ import java.sql.SQLData;
/*      */ import java.sql.SQLException;
/*      */ import java.sql.SQLOutput;
/*      */ import java.sql.Struct;
/*      */ import java.util.Hashtable;
/*      */ import java.util.Map;
/*      */ import oracle.jdbc.OracleData;
/*      */ import oracle.jdbc.OracleDataFactory;
/*      */ import oracle.jdbc.OracleTypeMetaData;
/*      */ import oracle.jdbc.driver.DatabaseError;
/*      */ import oracle.jdbc.internal.OracleStruct;
/*      */ import oracle.jdbc.proxy.ProxyFactory;
/*      */ import oracle.jdbc.proxy._Proxy_;
/*      */ 
/*      */ /** @deprecated */
/*      */ public class STRUCT extends DatumWithConnection
/*      */   implements OracleStruct
/*      */ {
/*      */   StructDescriptor descriptor;
/*      */   Datum[] datumArray;
/*      */   Object[] objectArray;
/*   70 */   boolean enableLocalCache = false;
/*      */   long imageOffset;
/*      */   long imageLength;
/*      */   Object acProxy;
/* 1074 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*      */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*      */   public static final boolean TRACE = false;
/*      */ 
/*      */   public STRUCT(StructDescriptor paramStructDescriptor, Connection paramConnection, Object[] paramArrayOfObject)
/*      */     throws SQLException
/*      */   {
/*  105 */     assertNotNull(paramStructDescriptor);
/*      */ 
/*  107 */     this.descriptor = paramStructDescriptor;
/*      */ 
/*  109 */     assertNotNull(paramConnection);
/*      */     SQLException localSQLException;
/*  111 */     if (!paramStructDescriptor.getInternalConnection().isDescriptorSharable(((oracle.jdbc.OracleConnection)paramConnection).physicalConnectionWithin()))
/*      */     {
/*  114 */       localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 1, "Cannot construct STRUCT instance,invalid connection");
/*      */ 
/*  116 */       localSQLException.fillInStackTrace();
/*  117 */       throw localSQLException;
/*      */     }
/*      */ 
/*  121 */     paramStructDescriptor.setConnection(paramConnection);
/*      */ 
/*  123 */     if (!this.descriptor.isInstantiable())
/*      */     {
/*  126 */       localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 1, "Cannot construct STRUCT instance for a non-instantiable object type");
/*      */ 
/*  128 */       localSQLException.fillInStackTrace();
/*  129 */       throw localSQLException;
/*      */     }
/*      */ 
/*  133 */     setPhysicalConnectionOf(paramConnection);
/*      */ 
/*  135 */     if (paramArrayOfObject != null)
/*  136 */       this.datumArray = this.descriptor.toArray(paramArrayOfObject);
/*      */     else
/*  138 */       this.datumArray = new Datum[this.descriptor.getLength()];
/*      */   }
/*      */ 
/*      */   public STRUCT(StructDescriptor paramStructDescriptor, Connection paramConnection, Map paramMap)
/*      */     throws SQLException
/*      */   {
/*  151 */     assertNotNull(paramStructDescriptor);
/*      */ 
/*  153 */     this.descriptor = paramStructDescriptor;
/*      */ 
/*  155 */     assertNotNull(paramConnection);
/*      */     SQLException localSQLException;
/*  157 */     if (!paramStructDescriptor.getInternalConnection().isDescriptorSharable(((oracle.jdbc.OracleConnection)paramConnection).physicalConnectionWithin()))
/*      */     {
/*  160 */       localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 1, "Cannot construct STRUCT instance,invalid connection");
/*      */ 
/*  162 */       localSQLException.fillInStackTrace();
/*  163 */       throw localSQLException;
/*      */     }
/*      */ 
/*  167 */     paramStructDescriptor.setConnection(paramConnection);
/*      */ 
/*  169 */     if (!this.descriptor.isInstantiable())
/*      */     {
/*  172 */       localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 1, "Cannot construct STRUCT instance for a non-instantiable object type");
/*      */ 
/*  174 */       localSQLException.fillInStackTrace();
/*  175 */       throw localSQLException;
/*      */     }
/*      */ 
/*  179 */     setPhysicalConnectionOf(paramConnection);
/*      */ 
/*  181 */     this.datumArray = this.descriptor.toOracleArray(paramMap);
/*      */   }
/*      */ 
/*      */   public STRUCT(StructDescriptor paramStructDescriptor, byte[] paramArrayOfByte, Connection paramConnection)
/*      */     throws SQLException
/*      */   {
/*  198 */     super(paramArrayOfByte);
/*      */ 
/*  200 */     assertNotNull(paramStructDescriptor);
/*      */ 
/*  202 */     this.descriptor = paramStructDescriptor;
/*      */ 
/*  204 */     assertNotNull(paramConnection);
/*      */ 
/*  206 */     if (!paramStructDescriptor.getInternalConnection().isDescriptorSharable(((oracle.jdbc.OracleConnection)paramConnection).physicalConnectionWithin()))
/*      */     {
/*  209 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 1, "Cannot construct STRUCT instance,invalid connection");
/*      */ 
/*  211 */       localSQLException.fillInStackTrace();
/*  212 */       throw localSQLException;
/*      */     }
/*      */ 
/*  216 */     paramStructDescriptor.setConnection(paramConnection);
/*  217 */     setPhysicalConnectionOf(paramConnection);
/*      */ 
/*  219 */     this.datumArray = null;
/*      */   }
/*      */ 
/*      */   public String getSQLTypeName()
/*      */     throws SQLException
/*      */   {
/*  240 */     synchronized (getInternalConnection())
/*      */     {
/*  247 */       return this.descriptor.getName();
/*      */     }
/*      */   }
/*      */ 
/*      */   public Object[] getAttributes()
/*      */     throws SQLException
/*      */   {
/*  275 */     synchronized (getInternalConnection())
/*      */     {
/*  282 */       Object[] arrayOfObject = getAttributes(getMap());
/*      */ 
/*  284 */       return arrayOfObject;
/*      */     }
/*      */   }
/*      */ 
/*      */   public Object[] getAttributes(Map paramMap)
/*      */     throws SQLException
/*      */   {
/*  314 */     synchronized (getInternalConnection())
/*      */     {
/*  321 */       return this.descriptor.toArray(this, paramMap, this.enableLocalCache);
/*      */     }
/*      */   }
/*      */ 
/*      */   public OracleTypeMetaData getOracleMetaData()
/*      */     throws SQLException
/*      */   {
/*  343 */     return getDescriptor();
/*      */   }
/*      */ 
/*      */   public StructDescriptor getDescriptor()
/*      */     throws SQLException
/*      */   {
/*  363 */     return this.descriptor;
/*      */   }
/*      */ 
/*      */   public void setDescriptor(StructDescriptor paramStructDescriptor)
/*      */   {
/*  374 */     this.descriptor = paramStructDescriptor;
/*      */   }
/*      */ 
/*      */   public Datum[] getOracleAttributes()
/*      */     throws SQLException
/*      */   {
/*  389 */     synchronized (getInternalConnection())
/*      */     {
/*  396 */       return this.descriptor.toOracleArray(this, this.enableLocalCache);
/*      */     }
/*      */   }
/*      */ 
/*      */   public Map getMap()
/*      */   {
/*  413 */     Map localMap = null;
/*      */     try
/*      */     {
/*  417 */       localMap = getInternalConnection().getTypeMap();
/*      */     }
/*      */     catch (SQLException localSQLException)
/*      */     {
/*      */     }
/*      */ 
/*  425 */     return localMap;
/*      */   }
/*      */ 
/*      */   public byte[] toBytes()
/*      */     throws SQLException
/*      */   {
/*  439 */     synchronized (getInternalConnection())
/*      */     {
/*  441 */       return this.descriptor.toBytes(this, this.enableLocalCache);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setDatumArray(Datum[] paramArrayOfDatum)
/*      */   {
/*      */     try
/*      */     {
/*  457 */       this.datumArray = (paramArrayOfDatum == null ? new Datum[this.descriptor.getLength()] : paramArrayOfDatum);
/*      */     }
/*      */     catch (SQLException localSQLException)
/*      */     {
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setObjArray(Object[] paramArrayOfObject)
/*      */     throws SQLException
/*      */   {
/*  473 */     synchronized (getInternalConnection())
/*      */     {
/*  475 */       this.objectArray = (paramArrayOfObject == null ? new Object[0] : paramArrayOfObject);
/*      */     }
/*      */   }
/*      */ 
/*      */   public static STRUCT toSTRUCT(Object paramObject, oracle.jdbc.OracleConnection paramOracleConnection)
/*      */     throws SQLException
/*      */   {
/*  492 */     STRUCT localSTRUCT = null;
/*      */ 
/*  494 */     if (paramObject != null) {
/*  495 */       if ((paramObject instanceof STRUCT))
/*      */       {
/*  497 */         localSTRUCT = (STRUCT)paramObject;
/*      */       }
/*  499 */       else if ((paramObject instanceof ORAData))
/*      */       {
/*  501 */         localSTRUCT = (STRUCT)((ORAData)paramObject).toDatum(paramOracleConnection);
/*      */       }
/*      */       else
/*      */       {
/*      */         Object localObject1;
/*      */         Object localObject2;
/*  503 */         if ((paramObject instanceof OracleData))
/*      */         {
/*  505 */           localObject1 = ((OracleData)paramObject).toJDBCObject(paramOracleConnection);
/*      */ 
/*  509 */           if ((localObject1 instanceof _Proxy_))
/*      */           {
/*  511 */             localObject2 = (_Proxy_)localObject1;
/*  512 */             localObject1 = AccessController.doPrivileged(new PrivilegedAction()
/*      */             {
/*      */               public Object run()
/*      */               {
/*  517 */                 return ProxyFactory.extractDelegate(this.val$proxiedJDBCObject);
/*      */               }
/*      */             });
/*      */           }
/*      */ 
/*  522 */           localSTRUCT = (STRUCT)localObject1;
/*      */         }
/*  525 */         else if ((paramObject instanceof CustomDatum))
/*      */         {
/*  527 */           localSTRUCT = (STRUCT)((oracle.jdbc.internal.OracleConnection)paramOracleConnection).toDatum((CustomDatum)paramObject);
/*      */         }
/*  531 */         else if ((paramObject instanceof SQLData))
/*      */         {
/*  533 */           localObject1 = (SQLData)paramObject;
/*      */ 
/*  535 */           localObject2 = StructDescriptor.createDescriptor(((SQLData)localObject1).getSQLTypeName(), paramOracleConnection);
/*      */ 
/*  538 */           SQLOutput localSQLOutput = ((StructDescriptor)localObject2).toJdbc2SQLOutput();
/*      */ 
/*  540 */           ((SQLData)localObject1).writeSQL(localSQLOutput);
/*      */ 
/*  542 */           localSTRUCT = ((OracleSQLOutput)localSQLOutput).getSTRUCT();
/*      */         }
/*      */         else
/*      */         {
/*  547 */           localObject1 = DatabaseError.createSqlException(null, 59, paramObject);
/*  548 */           ((SQLException)localObject1).fillInStackTrace();
/*  549 */           throw ((Throwable)localObject1);
/*      */         }
/*      */       }
/*      */     }
/*  553 */     return localSTRUCT;
/*      */   }
/*      */ 
/*      */   public Object toJdbc()
/*      */     throws SQLException
/*      */   {
/*  574 */     Map localMap = getMap();
/*  575 */     return toJdbc(localMap);
/*      */   }
/*      */ 
/*      */   public Object toJdbc(Map paramMap)
/*      */     throws SQLException
/*      */   {
/*  593 */     Object localObject = this;
/*      */ 
/*  595 */     if (paramMap != null)
/*      */     {
/*  597 */       Class localClass = this.descriptor.getClass(paramMap);
/*      */ 
/*  599 */       if (localClass != null) {
/*  600 */         localObject = toClass(localClass, paramMap);
/*      */       }
/*      */     }
/*  603 */     return localObject;
/*      */   }
/*      */ 
/*      */   public Object toClass(Class paramClass)
/*      */     throws SQLException
/*      */   {
/*  620 */     return toClass(paramClass, getMap());
/*      */   }
/*      */ 
/*      */   public Object toClass(Class paramClass, Map paramMap)
/*      */     throws SQLException
/*      */   {
/*  649 */     Object localObject1 = null;
/*      */     try
/*      */     {
/*  653 */       if ((paramClass == null) || (paramClass == STRUCT.class) || (paramClass == Struct.class))
/*      */       {
/*  655 */         localObject1 = this;
/*      */       }
/*      */       else
/*      */       {
/*  660 */         Object localObject2 = paramClass.newInstance();
/*      */ 
/*  662 */         if ((localObject2 instanceof SQLData))
/*      */         {
/*  664 */           ((SQLData)localObject2).readSQL(this.descriptor.toJdbc2SQLInput(this, paramMap), this.descriptor.getName());
/*      */ 
/*  667 */           localObject1 = localObject2;
/*      */         }
/*  669 */         else if ((localObject2 instanceof ORADataFactory))
/*      */         {
/*  671 */           localObject3 = (ORADataFactory)localObject2;
/*      */ 
/*  673 */           localObject1 = ((ORADataFactory)localObject3).create(this, 2002);
/*      */         }
/*  675 */         else if ((localObject2 instanceof OracleDataFactory))
/*      */         {
/*  677 */           localObject3 = (OracleDataFactory)localObject2;
/*  678 */           localObject1 = ((OracleDataFactory)localObject3).create(this, 2002);
/*      */         }
/*  681 */         else if ((localObject2 instanceof CustomDatumFactory))
/*      */         {
/*  683 */           localObject3 = (CustomDatumFactory)localObject2;
/*      */ 
/*  685 */           localObject1 = ((CustomDatumFactory)localObject3).create(this, 2002);
/*      */         }
/*      */         else
/*      */         {
/*  691 */           localObject3 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 49, this.descriptor.getName());
/*  692 */           ((SQLException)localObject3).fillInStackTrace();
/*  693 */           throw ((Throwable)localObject3);
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*      */     }
/*      */     catch (InstantiationException localInstantiationException)
/*      */     {
/*  702 */       localObject3 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 49, "InstantiationException: " + localInstantiationException.getMessage());
/*      */ 
/*  704 */       ((SQLException)localObject3).fillInStackTrace();
/*  705 */       throw ((Throwable)localObject3);
/*      */     }
/*      */     catch (IllegalAccessException localIllegalAccessException)
/*      */     {
/*  712 */       Object localObject3 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 49, "IllegalAccessException: " + localIllegalAccessException.getMessage());
/*      */ 
/*  714 */       ((SQLException)localObject3).fillInStackTrace();
/*  715 */       throw ((Throwable)localObject3);
/*      */     }
/*      */ 
/*  719 */     return localObject1;
/*      */   }
/*      */ 
/*      */   public boolean isConvertibleTo(Class paramClass)
/*      */   {
/*  738 */     return false;
/*      */   }
/*      */ 
/*      */   public Object makeJdbcArray(int paramInt)
/*      */   {
/*  748 */     return new Object[paramInt];
/*      */   }
/*      */ 
/*      */   public void setAutoBuffering(boolean paramBoolean)
/*      */     throws SQLException
/*      */   {
/*  767 */     synchronized (getInternalConnection())
/*      */     {
/*  774 */       this.enableLocalCache = paramBoolean;
/*      */     }
/*      */   }
/*      */ 
/*      */   public boolean getAutoBuffering()
/*      */     throws SQLException
/*      */   {
/*  790 */     synchronized (getInternalConnection())
/*      */     {
/*  797 */       return this.enableLocalCache;
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setImage(byte[] paramArrayOfByte, long paramLong1, long paramLong2)
/*      */     throws SQLException
/*      */   {
/*  810 */     setShareBytes(paramArrayOfByte);
/*      */ 
/*  812 */     this.imageOffset = paramLong1;
/*  813 */     this.imageLength = paramLong2;
/*      */   }
/*      */ 
/*      */   public void setImageLength(long paramLong)
/*      */     throws SQLException
/*      */   {
/*  824 */     this.imageLength = paramLong;
/*      */   }
/*      */ 
/*      */   public long getImageOffset()
/*      */   {
/*  835 */     return this.imageOffset;
/*      */   }
/*      */ 
/*      */   public long getImageLength()
/*      */   {
/*  847 */     return this.imageLength;
/*      */   }
/*      */ 
/*      */   public CustomDatumFactory getFactory(Hashtable paramHashtable, String paramString)
/*      */     throws SQLException
/*      */   {
/*  861 */     String str = getSQLTypeName();
/*  862 */     Object localObject = paramHashtable.get(str);
/*      */ 
/*  864 */     if (localObject == null)
/*      */     {
/*  867 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 1, "Unable to convert a \"" + str + "\" to a \"" + paramString + "\" or a subclass of \"" + paramString + "\"");
/*      */ 
/*  870 */       localSQLException.fillInStackTrace();
/*  871 */       throw localSQLException;
/*      */     }
/*      */ 
/*  875 */     return (CustomDatumFactory)localObject;
/*      */   }
/*      */ 
/*      */   public ORADataFactory getORADataFactory(Hashtable paramHashtable, String paramString)
/*      */     throws SQLException
/*      */   {
/*  889 */     String str = getSQLTypeName();
/*  890 */     Object localObject = paramHashtable.get(str);
/*      */ 
/*  892 */     if (localObject == null)
/*      */     {
/*  895 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 1, "Unable to convert a \"" + str + "\" to a \"" + paramString + "\" or a subclass of \"" + paramString + "\"");
/*      */ 
/*  898 */       localSQLException.fillInStackTrace();
/*  899 */       throw localSQLException;
/*      */     }
/*      */ 
/*  903 */     return (ORADataFactory)localObject;
/*      */   }
/*      */ 
/*      */   public OracleDataFactory getOracleDataFactory(Hashtable paramHashtable, String paramString)
/*      */     throws SQLException
/*      */   {
/*  911 */     String str = getSQLTypeName();
/*  912 */     Object localObject = paramHashtable.get(str);
/*      */ 
/*  914 */     if (localObject == null)
/*      */     {
/*  917 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 1, "Unable to convert a \"" + str + "\" to a \"" + paramString + "\" or a subclass of \"" + paramString + "\"");
/*      */ 
/*  920 */       localSQLException.fillInStackTrace();
/*  921 */       throw localSQLException;
/*      */     }
/*      */ 
/*  925 */     return (OracleDataFactory)localObject;
/*      */   }
/*      */ 
/*      */   public String debugString()
/*      */   {
/*  938 */     StringWriter localStringWriter = new StringWriter();
/*  939 */     String str = null;
/*      */     try
/*      */     {
/*  943 */       StructDescriptor localStructDescriptor = getDescriptor();
/*      */ 
/*  945 */       localStringWriter.write("name = " + localStructDescriptor.getName());
/*      */       int i;
/*  946 */       localStringWriter.write(" length = " + (i = localStructDescriptor.getLength()));
/*      */ 
/*  948 */       Object[] arrayOfObject = getAttributes();
/*      */ 
/*  950 */       for (int j = 0; j < i; j++)
/*      */       {
/*  952 */         localStringWriter.write(" attribute[" + j + "] = " + arrayOfObject[j]);
/*      */       }
/*  954 */       str = localStringWriter.toString();
/*      */     }
/*      */     catch (SQLException localSQLException)
/*      */     {
/*  960 */       str = "StructDescriptor missing or bad";
/*      */     }
/*  962 */     return str;
/*      */   }
/*      */ 
/*      */   public boolean isInHierarchyOf(String paramString)
/*      */     throws SQLException
/*      */   {
/*  975 */     return this.descriptor.isInHierarchyOf(paramString);
/*      */   }
/*      */ 
/*      */   public Connection getJavaSqlConnection()
/*      */     throws SQLException
/*      */   {
/*  987 */     return super.getJavaSqlConnection();
/*      */   }
/*      */ 
/*      */   public String dump()
/*      */     throws SQLException
/*      */   {
/* 1003 */     return dump(this);
/*      */   }
/*      */ 
/*      */   public static String dump(Object paramObject)
/*      */     throws SQLException
/*      */   {
/* 1014 */     StringWriter localStringWriter = new StringWriter();
/* 1015 */     PrintWriter localPrintWriter = new PrintWriter(localStringWriter);
/* 1016 */     dump(paramObject, localPrintWriter);
/* 1017 */     return localStringWriter.getBuffer().substring(0);
/*      */   }
/*      */ 
/*      */   public static void dump(Object paramObject, PrintStream paramPrintStream) throws SQLException
/*      */   {
/* 1022 */     dump(paramObject, new PrintWriter(paramPrintStream, true));
/*      */   }
/*      */ 
/*      */   public static void dump(Object paramObject, PrintWriter paramPrintWriter) throws SQLException
/*      */   {
/* 1027 */     dump(paramObject, paramPrintWriter, 0);
/*      */   }
/*      */ 
/*      */   static void dump(Object paramObject, PrintWriter paramPrintWriter, int paramInt) throws SQLException
/*      */   {
/* 1032 */     if ((paramObject instanceof STRUCT)) { dump((STRUCT)paramObject, paramPrintWriter, paramInt); return; }
/* 1033 */     if ((paramObject instanceof ARRAY)) { ARRAY.dump((ARRAY)paramObject, paramPrintWriter, paramInt); return; }
/* 1034 */     if (paramObject == null)
/* 1035 */       paramPrintWriter.println("null");
/*      */     else
/* 1037 */       paramPrintWriter.println(paramObject.toString());
/*      */   }
/*      */ 
/*      */   static void dump(STRUCT paramSTRUCT, PrintWriter paramPrintWriter, int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1044 */     StructDescriptor localStructDescriptor = paramSTRUCT.getDescriptor();
/* 1045 */     ResultSetMetaData localResultSetMetaData = localStructDescriptor.getMetaData();
/*      */ 
/* 1047 */     for (int j = 0; j < paramInt; j++) paramPrintWriter.print(' ');
/* 1048 */     paramPrintWriter.println("name = " + localStructDescriptor.getName());
/*      */ 
/* 1050 */     for (j = 0; j < paramInt; j++) paramPrintWriter.print(' ');
/*      */     int i;
/* 1051 */     paramPrintWriter.println("length = " + (i = localStructDescriptor.getLength()));
/* 1052 */     Object[] arrayOfObject = paramSTRUCT.getAttributes();
/* 1053 */     for (j = 0; j < i; j++)
/*      */     {
/* 1055 */       for (int k = 0; k < paramInt; k++) paramPrintWriter.print(' ');
/* 1056 */       paramPrintWriter.print(localResultSetMetaData.getColumnName(j + 1) + " = ");
/* 1057 */       dump(arrayOfObject[j], paramPrintWriter, paramInt + 1);
/*      */     }
/*      */   }
/*      */ 
/*      */   public void setACProxy(Object paramObject)
/*      */   {
/* 1065 */     this.acProxy = paramObject;
/*      */   }
/*      */ 
/*      */   public Object getACProxy()
/*      */   {
/* 1070 */     return this.acProxy;
/*      */   }
/*      */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.sql.STRUCT
 * JD-Core Version:    0.6.2
 */