/*     */ package oracle.sql;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.ObjectInputStream;
/*     */ import java.io.ObjectOutputStream;
/*     */ import java.io.Serializable;
/*     */ import java.sql.SQLException;
/*     */ import oracle.jdbc.driver.DatabaseError;
/*     */ 
/*     */ public class SQLName
/*     */   implements Serializable
/*     */ {
/*  64 */   static boolean DEBUG = false;
/*  65 */   static boolean s_parseAllFormat = false;
/*     */   static final long serialVersionUID = 2266340348729491526L;
/*     */   String name;
/*     */   String schema;
/*     */   String simple;
/*     */   int version;
/*     */   boolean synonym;
/* 462 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   protected SQLName()
/*     */   {
/*     */   }
/*     */ 
/*     */   public SQLName(String paramString, oracle.jdbc.OracleConnection paramOracleConnection)
/*     */     throws SQLException
/*     */   {
/*  95 */     init(paramString, paramOracleConnection);
/*     */ 
/*  97 */     this.version = 2;
/*  98 */     this.synonym = false;
/*     */   }
/*     */ 
/*     */   public SQLName(String paramString1, String paramString2, oracle.jdbc.OracleConnection paramOracleConnection)
/*     */     throws SQLException
/*     */   {
/* 117 */     this.schema = paramString1;
/* 118 */     this.simple = paramString2;
/* 119 */     this.name = (this.schema + "." + this.simple);
/*     */ 
/* 121 */     this.version = 2;
/* 122 */     this.synonym = false;
/*     */   }
/*     */ 
/*     */   private void init(String paramString, oracle.jdbc.OracleConnection paramOracleConnection)
/*     */     throws SQLException
/*     */   {
/* 134 */     String[] arrayOfString1 = new String[1];
/* 135 */     String[] arrayOfString2 = new String[1];
/*     */ 
/* 137 */     if (parse(paramString, arrayOfString1, arrayOfString2, true))
/*     */     {
/* 139 */       this.schema = arrayOfString1[0];
/* 140 */       this.simple = arrayOfString2[0];
/*     */     }
/*     */     else
/*     */     {
/* 144 */       this.schema = paramOracleConnection.physicalConnectionWithin().getDefaultSchemaNameForNamedTypes();
/* 145 */       this.simple = arrayOfString2[0];
/*     */     }
/*     */ 
/* 148 */     this.name = (this.schema + "." + this.simple);
/*     */   }
/*     */ 
/*     */   public String getName()
/*     */     throws SQLException
/*     */   {
/* 164 */     return this.name;
/*     */   }
/*     */ 
/*     */   public String getSchema()
/*     */     throws SQLException
/*     */   {
/* 179 */     return this.schema;
/*     */   }
/*     */ 
/*     */   public String getSimpleName()
/*     */     throws SQLException
/*     */   {
/* 194 */     return this.simple;
/*     */   }
/*     */ 
/*     */   public int getVersion()
/*     */     throws SQLException
/*     */   {
/* 209 */     return this.version;
/*     */   }
/*     */ 
/*     */   public static boolean parse(String paramString, String[] paramArrayOfString1, String[] paramArrayOfString2)
/*     */     throws SQLException
/*     */   {
/* 232 */     return parse(paramString, paramArrayOfString1, paramArrayOfString2, s_parseAllFormat);
/*     */   }
/*     */ 
/*     */   public static boolean parse(String paramString, String[] paramArrayOfString1, String[] paramArrayOfString2, boolean paramBoolean)
/*     */     throws SQLException
/*     */   {
/* 242 */     if (paramString == null) {
/* 243 */       return false;
/*     */     }
/* 245 */     if ((paramArrayOfString1 == null) || (paramArrayOfString1.length < 1) || (paramArrayOfString2 == null) || (paramArrayOfString2.length < 1))
/*     */     {
/* 249 */       SQLException localSQLException = DatabaseError.createSqlException(null, 68);
/* 250 */       localSQLException.fillInStackTrace();
/* 251 */       throw localSQLException;
/*     */     }
/*     */ 
/* 270 */     if (!paramBoolean)
/*     */     {
/* 272 */       i = paramString.indexOf(".");
/*     */ 
/* 274 */       if (i < 0)
/*     */       {
/* 276 */         paramArrayOfString2[0] = paramString;
/*     */ 
/* 278 */         return false;
/*     */       }
/*     */ 
/* 282 */       paramArrayOfString1[0] = paramString.substring(0, i);
/* 283 */       paramArrayOfString2[0] = paramString.substring(i + 1);
/*     */ 
/* 285 */       return true;
/*     */     }
/*     */ 
/* 290 */     int i = paramString.length();
/* 291 */     int j = paramString.indexOf("\"");
/* 292 */     int k = paramString.indexOf("\"", j + 1);
/* 293 */     int m = -1;
/*     */ 
/* 295 */     if (j < 0)
/*     */     {
/* 297 */       m = paramString.indexOf(".");
/*     */ 
/* 299 */       if (m < 0)
/*     */       {
/* 301 */         paramArrayOfString2[0] = paramString;
/*     */ 
/* 303 */         return false;
/*     */       }
/*     */ 
/* 307 */       paramArrayOfString1[0] = paramString.substring(0, m);
/* 308 */       paramArrayOfString2[0] = paramString.substring(m + 1);
/*     */ 
/* 310 */       return true;
/*     */     }
/*     */ 
/* 313 */     if (j == 0)
/*     */     {
/* 315 */       if (k == i - 1)
/*     */       {
/* 317 */         paramArrayOfString2[0] = paramString.substring(j + 1, k);
/*     */ 
/* 319 */         return false;
/*     */       }
/*     */ 
/* 323 */       m = paramString.indexOf(".", k);
/* 324 */       paramArrayOfString1[0] = paramString.substring(j + 1, k);
/*     */ 
/* 326 */       j = paramString.indexOf("\"", m);
/* 327 */       k = paramString.indexOf("\"", j + 1);
/*     */ 
/* 329 */       if (j < 0)
/*     */       {
/* 331 */         paramArrayOfString2[0] = paramString.substring(m + 1);
/*     */ 
/* 333 */         return true;
/*     */       }
/*     */ 
/* 339 */       paramArrayOfString2[0] = paramString.substring(j + 1, k);
/*     */ 
/* 341 */       return true;
/*     */     }
/*     */ 
/* 347 */     m = paramString.indexOf(".");
/* 348 */     paramArrayOfString1[0] = paramString.substring(0, m);
/* 349 */     paramArrayOfString2[0] = paramString.substring(j + 1, k);
/*     */ 
/* 351 */     return true;
/*     */   }
/*     */ 
/*     */   public static void setHandleDoubleQuote(boolean paramBoolean)
/*     */     throws SQLException
/*     */   {
/* 370 */     s_parseAllFormat = paramBoolean;
/*     */   }
/*     */ 
/*     */   public static boolean getHandleDoubleQuote()
/*     */     throws SQLException
/*     */   {
/* 384 */     return s_parseAllFormat;
/*     */   }
/*     */ 
/*     */   public boolean equals(Object paramObject)
/*     */   {
/* 396 */     if (paramObject == this) return true;
/* 397 */     if (!(paramObject instanceof SQLName)) return false;
/* 398 */     return ((SQLName)paramObject).name.equals(this.name);
/*     */   }
/*     */ 
/*     */   public int hashCode()
/*     */   {
/* 404 */     return this.name == null ? -1 : this.name.hashCode();
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 415 */     return this.name;
/*     */   }
/*     */ 
/*     */   private void writeObject(ObjectOutputStream paramObjectOutputStream)
/*     */     throws IOException
/*     */   {
/* 426 */     paramObjectOutputStream.writeUTF(this.name);
/* 427 */     paramObjectOutputStream.writeUTF(this.schema);
/* 428 */     paramObjectOutputStream.writeUTF(this.simple);
/* 429 */     paramObjectOutputStream.writeInt(this.version);
/* 430 */     paramObjectOutputStream.writeBoolean(this.synonym);
/*     */   }
/*     */ 
/*     */   private void readObject(ObjectInputStream paramObjectInputStream)
/*     */     throws IOException, ClassNotFoundException
/*     */   {
/* 438 */     this.name = paramObjectInputStream.readUTF();
/* 439 */     this.schema = paramObjectInputStream.readUTF();
/* 440 */     this.simple = paramObjectInputStream.readUTF();
/* 441 */     this.version = paramObjectInputStream.readInt();
/* 442 */     this.synonym = paramObjectInputStream.readBoolean();
/*     */   }
/*     */ 
/*     */   protected oracle.jdbc.internal.OracleConnection getConnectionDuringExceptionHandling()
/*     */   {
/* 457 */     return null;
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.sql.SQLName
 * JD-Core Version:    0.6.2
 */