/*     */ package oracle.sql;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.ObjectInputStream;
/*     */ import java.io.ObjectOutputStream;
/*     */ import java.io.Serializable;
/*     */ import java.sql.CallableStatement;
/*     */ import java.sql.Connection;
/*     */ import java.sql.PreparedStatement;
/*     */ import java.sql.Ref;
/*     */ import java.sql.SQLData;
/*     */ import java.sql.SQLException;
/*     */ import java.util.Map;
/*     */ import oracle.jdbc.OracleDataFactory;
/*     */ import oracle.jdbc.OraclePreparedStatement;
/*     */ import oracle.jdbc.OracleResultSet;
/*     */ import oracle.jdbc.OracleTypeMetaData;
/*     */ import oracle.jdbc.driver.DatabaseError;
/*     */ import oracle.jdbc.internal.OracleConnection;
/*     */ import oracle.jdbc.internal.OracleRef;
/*     */ import oracle.jdbc.oracore.OracleTypeADT;
/*     */ 
/*     */ /** @deprecated */
/*     */ public class REF extends DatumWithConnection
/*     */   implements OracleRef, Serializable, Cloneable
/*     */ {
/*     */   static final boolean DEBUG = false;
/*     */   static final long serialVersionUID = 1328446996944583167L;
/*     */   String typename;
/*     */   transient StructDescriptor descriptor;
/*     */   Object acProxy;
/* 849 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   public String getBaseTypeName()
/*     */     throws SQLException
/*     */   {
/*  82 */     if (this.typename == null)
/*     */     {
/*  84 */       if (this.descriptor != null) {
/*  85 */         this.typename = this.descriptor.getName();
/*     */       }
/*     */       else
/*     */       {
/*  89 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 52);
/*  90 */         localSQLException.fillInStackTrace();
/*  91 */         throw localSQLException;
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/*  96 */     return this.typename;
/*     */   }
/*     */ 
/*     */   public REF(String paramString, Connection paramConnection, byte[] paramArrayOfByte)
/*     */     throws SQLException
/*     */   {
/* 111 */     super(paramArrayOfByte);
/*     */ 
/* 113 */     if ((paramConnection == null) || (paramString == null))
/*     */     {
/* 117 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/* 118 */       localSQLException.fillInStackTrace();
/* 119 */       throw localSQLException;
/*     */     }
/*     */ 
/* 123 */     this.typename = paramString;
/* 124 */     this.descriptor = null;
/*     */ 
/* 126 */     setPhysicalConnectionOf(paramConnection);
/*     */   }
/*     */ 
/*     */   public REF(StructDescriptor paramStructDescriptor, Connection paramConnection, byte[] paramArrayOfByte)
/*     */     throws SQLException
/*     */   {
/* 142 */     super(paramArrayOfByte);
/*     */ 
/* 144 */     if ((paramConnection == null) || (paramStructDescriptor == null))
/*     */     {
/* 147 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 68);
/* 148 */       localSQLException.fillInStackTrace();
/* 149 */       throw localSQLException;
/*     */     }
/*     */ 
/* 154 */     this.descriptor = paramStructDescriptor;
/*     */ 
/* 156 */     setPhysicalConnectionOf(paramConnection);
/*     */   }
/*     */ 
/*     */   public Object getValue(Map paramMap)
/*     */     throws SQLException
/*     */   {
/* 177 */     STRUCT localSTRUCT = getSTRUCT();
/* 178 */     Object localObject = localSTRUCT != null ? localSTRUCT.toJdbc(paramMap) : null;
/*     */ 
/* 180 */     return localObject;
/*     */   }
/*     */ 
/*     */   public Object getValue()
/*     */     throws SQLException
/*     */   {
/* 201 */     STRUCT localSTRUCT = getSTRUCT();
/* 202 */     Object localObject = localSTRUCT != null ? localSTRUCT.toJdbc() : null;
/* 203 */     return localObject;
/*     */   }
/*     */ 
/*     */   public STRUCT getSTRUCT()
/*     */     throws SQLException
/*     */   {
/* 215 */     synchronized (getInternalConnection())
/*     */     {
/* 222 */       STRUCT localSTRUCT = null;
/*     */ 
/* 224 */       OraclePreparedStatement localOraclePreparedStatement = (OraclePreparedStatement)getInternalConnection().prepareStatement("select deref(:1) from dual");
/*     */ 
/* 227 */       localOraclePreparedStatement.setRowPrefetch(1);
/* 228 */       localOraclePreparedStatement.setREF(1, this);
/*     */ 
/* 230 */       OracleResultSet localOracleResultSet = (OracleResultSet)localOraclePreparedStatement.executeQuery();
/*     */       try
/*     */       {
/* 234 */         if (localOracleResultSet.next()) {
/* 235 */           localSTRUCT = localOracleResultSet.getSTRUCT(1);
/*     */         }
/*     */         else
/*     */         {
/* 239 */           SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 52);
/* 240 */           localSQLException.fillInStackTrace();
/* 241 */           throw localSQLException;
/*     */         }
/*     */ 
/*     */       }
/*     */       finally
/*     */       {
/* 247 */         localOracleResultSet.close();
/*     */ 
/* 249 */         localOracleResultSet = null;
/*     */ 
/* 251 */         localOraclePreparedStatement.close();
/*     */ 
/* 253 */         localOraclePreparedStatement = null;
/*     */       }
/* 255 */       return localSTRUCT;
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setValue(Object paramObject)
/*     */     throws SQLException
/*     */   {
/* 270 */     synchronized (getInternalConnection())
/*     */     {
/* 278 */       STRUCT localSTRUCT = STRUCT.toSTRUCT(paramObject, getInternalConnection());
/*     */ 
/* 280 */       if (localSTRUCT.getInternalConnection() != getInternalConnection())
/*     */       {
/* 283 */         localObject1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 77, "Incompatible connection object");
/* 284 */         ((SQLException)localObject1).fillInStackTrace();
/* 285 */         throw ((Throwable)localObject1);
/*     */       }
/*     */ 
/* 289 */       if (!getBaseTypeName().equals(localSTRUCT.getSQLTypeName()))
/*     */       {
/* 292 */         localObject1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 77, "Incompatible type");
/* 293 */         ((SQLException)localObject1).fillInStackTrace();
/* 294 */         throw ((Throwable)localObject1);
/*     */       }
/*     */ 
/* 299 */       Object localObject1 = localSTRUCT.toBytes();
/*     */ 
/* 302 */       byte[] arrayOfByte = localSTRUCT.getDescriptor().getOracleTypeADT().getTOID();
/*     */ 
/* 305 */       CallableStatement localCallableStatement = null;
/* 306 */       getInternalConnection().beginNonRequestCalls();
/*     */       try
/*     */       {
/* 309 */         localCallableStatement = getInternalConnection().prepareCall("begin :1 := dbms_pickler.update_through_ref (:2, :3, :4, :5); end;");
/*     */ 
/* 312 */         localCallableStatement.registerOutParameter(1, 2);
/*     */ 
/* 314 */         localCallableStatement.setBytes(2, shareBytes());
/* 315 */         localCallableStatement.setInt(3, 0);
/* 316 */         localCallableStatement.setBytes(4, arrayOfByte);
/* 317 */         localCallableStatement.setBytes(5, (byte[])localObject1);
/*     */ 
/* 319 */         localCallableStatement.execute();
/*     */ 
/* 321 */         int i = 0;
/*     */ 
/* 323 */         if ((i = localCallableStatement.getInt(1)) != 0)
/*     */         {
/* 326 */           SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 77, "ORA-" + i);
/* 327 */           localSQLException.fillInStackTrace();
/* 328 */           throw localSQLException;
/*     */         }
/*     */ 
/*     */       }
/*     */       finally
/*     */       {
/* 334 */         if (localCallableStatement != null) {
/* 335 */           localCallableStatement.close();
/*     */         }
/* 337 */         localCallableStatement = null;
/*     */ 
/* 342 */         getInternalConnection().endNonRequestCalls();
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public OracleTypeMetaData getOracleMetaData()
/*     */     throws SQLException
/*     */   {
/* 363 */     return getDescriptor();
/*     */   }
/*     */ 
/*     */   public StructDescriptor getDescriptor()
/*     */     throws SQLException
/*     */   {
/* 381 */     if (this.descriptor == null)
/*     */     {
/* 383 */       this.descriptor = StructDescriptor.createDescriptor(this.typename, getInternalConnection());
/*     */     }
/*     */ 
/* 386 */     return this.descriptor;
/*     */   }
/*     */ 
/*     */   public String getSQLTypeName()
/*     */     throws SQLException
/*     */   {
/* 404 */     String str = getBaseTypeName();
/* 405 */     return str;
/*     */   }
/*     */ 
/*     */   public Object getObject(Map paramMap)
/*     */     throws SQLException
/*     */   {
/* 424 */     STRUCT localSTRUCT = getSTRUCT();
/* 425 */     Object localObject = localSTRUCT != null ? localSTRUCT.toJdbc(paramMap) : null;
/* 426 */     return localObject;
/*     */   }
/*     */ 
/*     */   public Object getObject()
/*     */     throws SQLException
/*     */   {
/* 459 */     STRUCT localSTRUCT = getSTRUCT();
/* 460 */     Object localObject = localSTRUCT != null ? localSTRUCT.toJdbc() : null;
/* 461 */     return localObject;
/*     */   }
/*     */ 
/*     */   public void setObject(Object paramObject)
/*     */     throws SQLException
/*     */   {
/* 500 */     PreparedStatement localPreparedStatement = null;
/*     */     try
/*     */     {
/* 503 */       localPreparedStatement = getInternalConnection().prepareStatement("call sys.utl_ref.update_object( :1, :2 )");
/*     */ 
/* 505 */       localPreparedStatement.setRef(1, this);
/* 506 */       localPreparedStatement.setObject(2, paramObject);
/* 507 */       localPreparedStatement.execute(); } finally {
/* 508 */       if (localPreparedStatement != null) localPreparedStatement.close();
/*     */     }
/*     */   }
/*     */ 
/*     */   public Object toJdbc()
/*     */     throws SQLException
/*     */   {
/* 539 */     return this;
/*     */   }
/*     */ 
/*     */   public Object toJdbc(Map paramMap)
/*     */     throws SQLException
/*     */   {
/* 559 */     Object localObject = this;
/* 560 */     if (paramMap != null) {
/* 561 */       Class localClass = getDescriptor().getClass(paramMap);
/* 562 */       if (localClass != null) {
/* 563 */         localObject = toClass(localClass, paramMap);
/*     */       }
/*     */     }
/* 566 */     return localObject;
/*     */   }
/*     */ 
/*     */   public Object toClass(Class paramClass, Map paramMap)
/*     */     throws SQLException
/*     */   {
/* 581 */     Object localObject1 = null;
/*     */     try {
/* 583 */       if ((paramClass == null) || (paramClass == REF.class) || (paramClass == Ref.class)) {
/* 584 */         localObject1 = this;
/*     */       }
/*     */       else {
/* 587 */         Object localObject2 = paramClass.newInstance();
/*     */ 
/* 593 */         if ((localObject2 instanceof SQLData)) {
/* 594 */           localObject1 = this;
/*     */         }
/* 596 */         else if ((localObject2 instanceof ORADataFactory)) {
/* 597 */           localObject3 = (ORADataFactory)localObject2;
/* 598 */           localObject1 = ((ORADataFactory)localObject3).create(this, 2006);
/*     */         }
/* 600 */         else if ((localObject2 instanceof OracleDataFactory)) {
/* 601 */           localObject3 = (OracleDataFactory)localObject2;
/* 602 */           localObject1 = ((OracleDataFactory)localObject3).create(this, 2006);
/*     */         }
/*     */         else
/*     */         {
/* 606 */           localObject3 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 49, this.descriptor.getName());
/* 607 */           ((SQLException)localObject3).fillInStackTrace();
/* 608 */           throw ((Throwable)localObject3);
/*     */         }
/*     */       }
/*     */ 
/*     */     }
/*     */     catch (InstantiationException localInstantiationException)
/*     */     {
/* 615 */       localObject3 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 49, "InstantiationException: " + localInstantiationException.getMessage());
/*     */ 
/* 617 */       ((SQLException)localObject3).fillInStackTrace();
/* 618 */       throw ((Throwable)localObject3);
/*     */     }
/*     */     catch (IllegalAccessException localIllegalAccessException)
/*     */     {
/* 623 */       Object localObject3 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 49, "IllegalAccessException: " + localIllegalAccessException.getMessage());
/*     */ 
/* 625 */       ((SQLException)localObject3).fillInStackTrace();
/* 626 */       throw ((Throwable)localObject3);
/*     */     }
/*     */ 
/* 629 */     return localObject1;
/*     */   }
/*     */ 
/*     */   public boolean isConvertibleTo(Class paramClass)
/*     */   {
/* 652 */     return false;
/*     */   }
/*     */ 
/*     */   public Object makeJdbcArray(int paramInt)
/*     */   {
/* 675 */     return new REF[paramInt];
/*     */   }
/*     */ 
/*     */   public Object clone()
/*     */     throws CloneNotSupportedException
/*     */   {
/* 687 */     REF localREF = null;
/*     */     try
/*     */     {
/* 691 */       localREF = new REF(getBaseTypeName(), getInternalConnection(), getBytes());
/*     */     }
/*     */     catch (SQLException localSQLException)
/*     */     {
/* 695 */       throw new CloneNotSupportedException(localSQLException.getMessage());
/*     */     }
/*     */ 
/* 698 */     return localREF;
/*     */   }
/*     */ 
/*     */   public boolean equals(Object paramObject)
/*     */   {
/* 710 */     boolean bool = false;
/*     */     try
/*     */     {
/* 714 */       bool = ((paramObject instanceof REF)) && (super.equals(paramObject)) && (getBaseTypeName().equals(((REF)paramObject).getSQLTypeName()));
/*     */     }
/*     */     catch (Exception localException)
/*     */     {
/*     */     }
/*     */ 
/* 723 */     return bool;
/*     */   }
/*     */ 
/*     */   public int hashCode()
/*     */   {
/* 754 */     byte[] arrayOfByte = shareBytes();
/* 755 */     int i = 0;
/*     */     int j;
/* 757 */     if ((arrayOfByte[2] & 0x5) == 5)
/*     */     {
/* 761 */       for (j = 0; j < 4; j++)
/*     */       {
/* 763 */         i *= 256;
/* 764 */         i += (arrayOfByte[(8 + j)] & 0xFF);
/*     */       }
/*     */     }
/* 767 */     else if ((arrayOfByte[2] & 0x3) == 3)
/*     */     {
/* 772 */       for (j = 0; (j < 4) && (j < arrayOfByte.length); j++)
/*     */       {
/* 774 */         i *= 256;
/* 775 */         i += (arrayOfByte[(6 + j)] & 0xFF);
/*     */       }
/*     */     }
/* 778 */     else if ((arrayOfByte[2] & 0x2) == 2)
/*     */     {
/* 783 */       for (j = 0; j < 4; j++)
/*     */       {
/* 785 */         i *= 256;
/* 786 */         i += (arrayOfByte[(8 + j)] & 0xFF);
/*     */       }
/*     */     }
/* 789 */     return i;
/*     */   }
/*     */ 
/*     */   private void writeObject(ObjectOutputStream paramObjectOutputStream)
/*     */     throws IOException
/*     */   {
/* 800 */     paramObjectOutputStream.writeObject(shareBytes());
/*     */     try
/*     */     {
/* 804 */       paramObjectOutputStream.writeUTF(getBaseTypeName());
/*     */     }
/*     */     catch (SQLException localSQLException)
/*     */     {
/* 808 */       throw new IOException(localSQLException.getMessage());
/*     */     }
/*     */   }
/*     */ 
/*     */   private void readObject(ObjectInputStream paramObjectInputStream)
/*     */     throws IOException, ClassNotFoundException
/*     */   {
/* 818 */     setBytes((byte[])paramObjectInputStream.readObject());
/*     */ 
/* 820 */     this.typename = paramObjectInputStream.readUTF();
/*     */   }
/*     */ 
/*     */   public Connection getJavaSqlConnection()
/*     */     throws SQLException
/*     */   {
/* 832 */     return super.getJavaSqlConnection();
/*     */   }
/*     */ 
/*     */   public void setACProxy(Object paramObject)
/*     */   {
/* 840 */     this.acProxy = paramObject;
/*     */   }
/*     */ 
/*     */   public Object getACProxy()
/*     */   {
/* 845 */     return this.acProxy;
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.sql.REF
 * JD-Core Version:    0.6.2
 */