/*     */ package oracle.sql;
/*     */ 
/*     */ import java.io.ByteArrayInputStream;
/*     */ import java.io.CharArrayReader;
/*     */ import java.io.InputStream;
/*     */ import java.io.Reader;
/*     */ import java.io.UnsupportedEncodingException;
/*     */ import java.sql.SQLException;
/*     */ import oracle.jdbc.driver.DBConversion;
/*     */ import oracle.jdbc.driver.DatabaseError;
/*     */ import oracle.jdbc.internal.OracleConnection;
/*     */ import oracle.jdbc.util.RepConversion;
/*     */ 
/*     */ public class RAW extends Datum
/*     */ {
/*     */   static final long serialVersionUID = -3298750557928937840L;
/* 560 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   static int hexDigit2Nibble(char paramChar)
/*     */     throws SQLException
/*     */   {
/*  65 */     int i = Character.digit(paramChar, 16);
/*     */ 
/*  67 */     if (i == -1)
/*     */     {
/*  70 */       SQLException localSQLException = DatabaseError.createSqlException(null, 59, "Invalid hex digit: " + paramChar);
/*  71 */       localSQLException.fillInStackTrace();
/*  72 */       throw localSQLException;
/*     */     }
/*     */ 
/*  76 */     return i;
/*     */   }
/*     */ 
/*     */   public static byte[] hexString2Bytes(String paramString)
/*     */     throws SQLException
/*     */   {
/*  95 */     int i = paramString.length();
/*  96 */     char[] arrayOfChar = new char[i];
/*     */ 
/*  98 */     paramString.getChars(0, i, arrayOfChar, 0);
/*     */ 
/* 101 */     int j = 0;
/* 102 */     int k = 0;
/*     */ 
/* 104 */     if (i == 0)
/* 105 */       return new byte[0];
/*     */     byte[] arrayOfByte;
/* 107 */     if (i % 2 > 0)
/*     */     {
/* 109 */       arrayOfByte = new byte[(i + 1) / 2];
/* 110 */       arrayOfByte[(j++)] = ((byte)hexDigit2Nibble(arrayOfChar[(k++)]));
/*     */     }
/*     */     else
/*     */     {
/* 114 */       arrayOfByte = new byte[i / 2];
/*     */     }
/*     */ 
/* 117 */     for (; j < arrayOfByte.length; j++)
/*     */     {
/* 119 */       arrayOfByte[j] = ((byte)(hexDigit2Nibble(arrayOfChar[(k++)]) << 4 | hexDigit2Nibble(arrayOfChar[(k++)])));
/*     */     }
/*     */ 
/* 122 */     return arrayOfByte;
/*     */   }
/*     */ 
/*     */   public static RAW newRAW(Object paramObject)
/*     */     throws SQLException
/*     */   {
/* 152 */     RAW localRAW = new RAW(paramObject);
/* 153 */     return localRAW;
/*     */   }
/*     */ 
/*     */   public static RAW oldRAW(Object paramObject)
/*     */     throws SQLException
/*     */   {
/*     */     RAW localRAW;
/* 185 */     if ((paramObject instanceof String))
/*     */     {
/* 187 */       String str = (String)paramObject;
/* 188 */       byte[] arrayOfByte = null;
/*     */       try
/*     */       {
/* 192 */         arrayOfByte = str.getBytes("ISO8859_1");
/*     */       }
/*     */       catch (UnsupportedEncodingException localUnsupportedEncodingException)
/*     */       {
/* 197 */         SQLException localSQLException = DatabaseError.createSqlException(null, 109, "ISO8859_1 character encoding not found");
/* 198 */         localSQLException.fillInStackTrace();
/* 199 */         throw localSQLException;
/*     */       }
/*     */ 
/* 203 */       localRAW = new RAW(arrayOfByte);
/*     */     }
/*     */     else
/*     */     {
/* 207 */       localRAW = new RAW(paramObject);
/*     */     }
/* 209 */     return localRAW;
/*     */   }
/*     */ 
/*     */   public RAW()
/*     */   {
/*     */   }
/*     */ 
/*     */   public RAW(byte[] paramArrayOfByte)
/*     */   {
/* 239 */     super(paramArrayOfByte);
/*     */   }
/*     */ 
/*     */   /** @deprecated */
/*     */   public RAW(Object paramObject)
/*     */     throws SQLException
/*     */   {
/* 266 */     this();
/*     */ 
/* 273 */     if ((paramObject instanceof byte[]))
/*     */     {
/* 275 */       setShareBytes((byte[])paramObject);
/*     */     }
/* 277 */     else if ((paramObject instanceof String))
/*     */     {
/* 279 */       setShareBytes(hexString2Bytes((String)paramObject));
/*     */     }
/*     */     else
/*     */     {
/* 284 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 59, paramObject);
/* 285 */       localSQLException.fillInStackTrace();
/* 286 */       throw localSQLException;
/*     */     }
/*     */   }
/*     */ 
/*     */   public Object toJdbc()
/*     */     throws SQLException
/*     */   {
/* 314 */     return getBytes();
/*     */   }
/*     */ 
/*     */   public boolean isConvertibleTo(Class paramClass)
/*     */   {
/* 337 */     String str = paramClass.getName();
/*     */ 
/* 339 */     if ((str.compareTo("java.lang.String") == 0) || (str.compareTo("java.io.InputStream") == 0) || (str.compareTo("java.io.Reader") == 0))
/*     */     {
/* 343 */       return true;
/*     */     }
/*     */ 
/* 347 */     return false;
/*     */   }
/*     */ 
/*     */   public String stringValue()
/*     */   {
/* 365 */     String str = RepConversion.bArray2String(getBytes());
/* 366 */     return str;
/*     */   }
/*     */ 
/*     */   public Reader characterStreamValue()
/*     */     throws SQLException
/*     */   {
/* 385 */     int i = (int)getLength();
/* 386 */     char[] arrayOfChar = new char[i * 2];
/* 387 */     byte[] arrayOfByte = shareBytes();
/*     */ 
/* 389 */     DBConversion.RAWBytesToHexChars(arrayOfByte, i, arrayOfChar);
/*     */ 
/* 391 */     CharArrayReader localCharArrayReader = new CharArrayReader(arrayOfChar);
/*     */ 
/* 393 */     return localCharArrayReader;
/*     */   }
/*     */ 
/*     */   public InputStream asciiStreamValue()
/*     */     throws SQLException
/*     */   {
/* 412 */     int i = (int)getLength();
/* 413 */     char[] arrayOfChar = new char[i * 2];
/* 414 */     byte[] arrayOfByte1 = shareBytes();
/*     */ 
/* 416 */     DBConversion.RAWBytesToHexChars(arrayOfByte1, i, arrayOfChar);
/*     */ 
/* 418 */     byte[] arrayOfByte2 = new byte[i * 2];
/*     */ 
/* 420 */     DBConversion.javaCharsToAsciiBytes(arrayOfChar, i * 2, arrayOfByte2);
/*     */ 
/* 422 */     ByteArrayInputStream localByteArrayInputStream = new ByteArrayInputStream(arrayOfByte2);
/* 423 */     return localByteArrayInputStream;
/*     */   }
/*     */ 
/*     */   public InputStream binaryStreamValue()
/*     */     throws SQLException
/*     */   {
/* 442 */     return getStream();
/*     */   }
/*     */ 
/*     */   public Object makeJdbcArray(int paramInt)
/*     */   {
/* 465 */     return new byte[paramInt][];
/*     */   }
/*     */ 
/*     */   protected OracleConnection getConnectionDuringExceptionHandling()
/*     */   {
/* 480 */     return null;
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.sql.RAW
 * JD-Core Version:    0.6.2
 */