/*     */ package oracle.sql;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.io.Reader;
/*     */ import java.math.BigDecimal;
/*     */ import java.net.URL;
/*     */ import java.sql.Array;
/*     */ import java.sql.Blob;
/*     */ import java.sql.Clob;
/*     */ import java.sql.Date;
/*     */ import java.sql.NClob;
/*     */ import java.sql.Ref;
/*     */ import java.sql.RowId;
/*     */ import java.sql.SQLData;
/*     */ import java.sql.SQLException;
/*     */ import java.sql.SQLOutput;
/*     */ import java.sql.SQLXML;
/*     */ import java.sql.Struct;
/*     */ import java.sql.Time;
/*     */ import java.sql.Timestamp;
/*     */ import oracle.jdbc.driver.DatabaseError;
/*     */ 
/*     */ public class OracleSQLOutput
/*     */   implements SQLOutput
/*     */ {
/*     */   private StructDescriptor descriptor;
/*     */   private Object[] attributes;
/*     */   private int index;
/*     */   private oracle.jdbc.OracleConnection conn;
/* 933 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   public OracleSQLOutput(StructDescriptor paramStructDescriptor, oracle.jdbc.OracleConnection paramOracleConnection)
/*     */     throws SQLException
/*     */   {
/* 106 */     this.descriptor = paramStructDescriptor;
/* 107 */     this.attributes = new Object[paramStructDescriptor.getLength()];
/* 108 */     this.conn = paramOracleConnection;
/* 109 */     this.index = 0;
/*     */   }
/*     */ 
/*     */   public STRUCT getSTRUCT()
/*     */     throws SQLException
/*     */   {
/* 120 */     return new STRUCT(this.descriptor, this.conn, this.attributes);
/*     */   }
/*     */ 
/*     */   public void writeString(String paramString)
/*     */     throws SQLException
/*     */   {
/* 144 */     this.attributes[(this.index++)] = paramString;
/*     */   }
/*     */ 
/*     */   public void writeBoolean(boolean paramBoolean)
/*     */     throws SQLException
/*     */   {
/* 162 */     this.attributes[(this.index++)] = Boolean.valueOf(paramBoolean);
/*     */   }
/*     */ 
/*     */   public void writeByte(byte paramByte)
/*     */     throws SQLException
/*     */   {
/* 181 */     this.attributes[(this.index++)] = Integer.valueOf(paramByte);
/*     */   }
/*     */ 
/*     */   public void writeShort(short paramShort)
/*     */     throws SQLException
/*     */   {
/* 198 */     this.attributes[(this.index++)] = Integer.valueOf(paramShort);
/*     */   }
/*     */ 
/*     */   public void writeInt(int paramInt)
/*     */     throws SQLException
/*     */   {
/* 215 */     this.attributes[(this.index++)] = Integer.valueOf(paramInt);
/*     */   }
/*     */ 
/*     */   public void writeLong(long paramLong)
/*     */     throws SQLException
/*     */   {
/* 232 */     this.attributes[(this.index++)] = new Long(paramLong);
/*     */   }
/*     */ 
/*     */   public void writeFloat(float paramFloat)
/*     */     throws SQLException
/*     */   {
/* 249 */     this.attributes[(this.index++)] = new Float(paramFloat);
/*     */   }
/*     */ 
/*     */   public void writeDouble(double paramDouble)
/*     */     throws SQLException
/*     */   {
/* 266 */     this.attributes[(this.index++)] = new Double(paramDouble);
/*     */   }
/*     */ 
/*     */   public void writeBigDecimal(BigDecimal paramBigDecimal)
/*     */     throws SQLException
/*     */   {
/* 283 */     this.attributes[(this.index++)] = paramBigDecimal;
/*     */   }
/*     */ 
/*     */   public void writeBytes(byte[] paramArrayOfByte)
/*     */     throws SQLException
/*     */   {
/* 300 */     this.attributes[(this.index++)] = paramArrayOfByte;
/*     */   }
/*     */ 
/*     */   public void writeDate(Date paramDate)
/*     */     throws SQLException
/*     */   {
/* 317 */     this.attributes[(this.index++)] = paramDate;
/*     */   }
/*     */ 
/*     */   public void writeTime(Time paramTime)
/*     */     throws SQLException
/*     */   {
/* 334 */     this.attributes[(this.index++)] = paramTime;
/*     */   }
/*     */ 
/*     */   public void writeTimestamp(Timestamp paramTimestamp)
/*     */     throws SQLException
/*     */   {
/* 351 */     this.attributes[(this.index++)] = paramTimestamp;
/*     */   }
/*     */ 
/*     */   public void writeCharacterStream(Reader paramReader)
/*     */     throws SQLException
/*     */   {
/* 369 */     StringBuffer localStringBuffer = new StringBuffer();
/*     */ 
/* 371 */     char[] arrayOfChar = new char[100];
/* 372 */     int i = 0;
/*     */     try
/*     */     {
/* 378 */       while ((i = paramReader.read(arrayOfChar)) != -1)
/*     */       {
/* 380 */         localStringBuffer.append(arrayOfChar, 0, i);
/*     */       }
/*     */ 
/*     */     }
/*     */     catch (IOException localIOException)
/*     */     {
/* 386 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), localIOException);
/* 387 */       localSQLException.fillInStackTrace();
/* 388 */       throw localSQLException;
/*     */     }
/*     */ 
/* 392 */     String str = localStringBuffer.substring(0, localStringBuffer.length());
/*     */ 
/* 395 */     this.attributes[(this.index++)] = str;
/*     */   }
/*     */ 
/*     */   public void writeAsciiStream(InputStream paramInputStream)
/*     */     throws SQLException
/*     */   {
/* 413 */     StringBuffer localStringBuffer = new StringBuffer();
/*     */ 
/* 415 */     byte[] arrayOfByte = new byte[100];
/* 416 */     char[] arrayOfChar = new char[100];
/* 417 */     int i = 0;
/*     */     try
/*     */     {
/* 421 */       while ((i = paramInputStream.read(arrayOfByte)) != -1)
/*     */       {
/* 423 */         for (int j = 0; j < i; j++) {
/* 424 */           arrayOfChar[j] = ((char)arrayOfByte[j]);
/*     */         }
/* 426 */         localStringBuffer.append(arrayOfChar, 0, i);
/*     */       }
/*     */ 
/*     */     }
/*     */     catch (IOException localIOException)
/*     */     {
/* 432 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), localIOException);
/* 433 */       localSQLException.fillInStackTrace();
/* 434 */       throw localSQLException;
/*     */     }
/*     */ 
/* 438 */     String str = localStringBuffer.substring(0, localStringBuffer.length());
/*     */ 
/* 440 */     this.attributes[(this.index++)] = str;
/*     */   }
/*     */ 
/*     */   public void writeBinaryStream(InputStream paramInputStream)
/*     */     throws SQLException
/*     */   {
/* 459 */     writeAsciiStream(paramInputStream);
/*     */   }
/*     */ 
/*     */   public void writeObject(SQLData paramSQLData)
/*     */     throws SQLException
/*     */   {
/* 489 */     STRUCT localSTRUCT = null;
/*     */ 
/* 491 */     if (paramSQLData != null)
/*     */     {
/* 493 */       StructDescriptor localStructDescriptor = StructDescriptor.createDescriptor(paramSQLData.getSQLTypeName(), this.conn);
/*     */ 
/* 496 */       SQLOutput localSQLOutput = localStructDescriptor.toJdbc2SQLOutput();
/*     */ 
/* 498 */       paramSQLData.writeSQL(localSQLOutput);
/*     */ 
/* 500 */       localSTRUCT = ((OracleSQLOutput)localSQLOutput).getSTRUCT();
/*     */     }
/*     */ 
/* 503 */     writeStruct(localSTRUCT);
/*     */   }
/*     */ 
/*     */   public void writeObject(Object paramObject)
/*     */     throws SQLException
/*     */   {
/* 521 */     if ((paramObject != null) && ((paramObject instanceof SQLData)))
/* 522 */       writeObject((SQLData)paramObject);
/*     */     else
/* 524 */       this.attributes[(this.index++)] = paramObject;
/*     */   }
/*     */ 
/*     */   public void writeRef(Ref paramRef)
/*     */     throws SQLException
/*     */   {
/* 542 */     this.attributes[(this.index++)] = paramRef;
/*     */   }
/*     */ 
/*     */   public void writeBlob(Blob paramBlob)
/*     */     throws SQLException
/*     */   {
/* 559 */     this.attributes[(this.index++)] = paramBlob;
/*     */   }
/*     */ 
/*     */   public void writeClob(Clob paramClob)
/*     */     throws SQLException
/*     */   {
/* 576 */     this.attributes[(this.index++)] = paramClob;
/*     */   }
/*     */ 
/*     */   public void writeStruct(Struct paramStruct)
/*     */     throws SQLException
/*     */   {
/* 593 */     this.attributes[(this.index++)] = paramStruct;
/*     */   }
/*     */ 
/*     */   public void writeArray(Array paramArray)
/*     */     throws SQLException
/*     */   {
/* 610 */     this.attributes[(this.index++)] = paramArray;
/*     */   }
/*     */ 
/*     */   public void writeOracleObject(Datum paramDatum)
/*     */     throws SQLException
/*     */   {
/* 629 */     this.attributes[(this.index++)] = paramDatum;
/*     */   }
/*     */ 
/*     */   public void writeRef(REF paramREF)
/*     */     throws SQLException
/*     */   {
/* 648 */     this.attributes[(this.index++)] = paramREF;
/*     */   }
/*     */ 
/*     */   public void writeBlob(BLOB paramBLOB)
/*     */     throws SQLException
/*     */   {
/* 667 */     this.attributes[(this.index++)] = paramBLOB;
/*     */   }
/*     */ 
/*     */   public void writeBfile(BFILE paramBFILE)
/*     */     throws SQLException
/*     */   {
/* 686 */     this.attributes[(this.index++)] = paramBFILE;
/*     */   }
/*     */ 
/*     */   public void writeClob(CLOB paramCLOB)
/*     */     throws SQLException
/*     */   {
/* 705 */     this.attributes[(this.index++)] = paramCLOB;
/*     */   }
/*     */ 
/*     */   public void writeStruct(STRUCT paramSTRUCT)
/*     */     throws SQLException
/*     */   {
/* 724 */     this.attributes[(this.index++)] = paramSTRUCT;
/*     */   }
/*     */ 
/*     */   public void writeArray(ARRAY paramARRAY)
/*     */     throws SQLException
/*     */   {
/* 743 */     this.attributes[(this.index++)] = paramARRAY;
/*     */   }
/*     */ 
/*     */   public void writeNUMBER(NUMBER paramNUMBER)
/*     */     throws SQLException
/*     */   {
/* 762 */     this.attributes[(this.index++)] = paramNUMBER;
/*     */   }
/*     */ 
/*     */   public void writeCHAR(CHAR paramCHAR)
/*     */     throws SQLException
/*     */   {
/* 781 */     this.attributes[(this.index++)] = paramCHAR;
/*     */   }
/*     */ 
/*     */   public void writeDATE(DATE paramDATE)
/*     */     throws SQLException
/*     */   {
/* 800 */     this.attributes[(this.index++)] = paramDATE;
/*     */   }
/*     */ 
/*     */   public void writeRAW(RAW paramRAW)
/*     */     throws SQLException
/*     */   {
/* 819 */     this.attributes[(this.index++)] = paramRAW;
/*     */   }
/*     */ 
/*     */   public void writeROWID(ROWID paramROWID)
/*     */     throws SQLException
/*     */   {
/* 838 */     this.attributes[(this.index++)] = paramROWID;
/*     */   }
/*     */ 
/*     */   public void writeURL(URL paramURL)
/*     */     throws SQLException
/*     */   {
/* 859 */     SQLException localSQLException = DatabaseError.createUnsupportedFeatureSqlException();
/* 860 */     localSQLException.fillInStackTrace();
/* 861 */     throw localSQLException;
/*     */   }
/*     */ 
/*     */   public void writeNClob(NClob paramNClob)
/*     */     throws SQLException
/*     */   {
/* 877 */     writeClob(paramNClob);
/*     */   }
/*     */ 
/*     */   public void writeNString(String paramString)
/*     */     throws SQLException
/*     */   {
/* 889 */     writeString(paramString);
/*     */   }
/*     */ 
/*     */   public void writeSQLXML(SQLXML paramSQLXML)
/*     */     throws SQLException
/*     */   {
/* 901 */     writeObject(paramSQLXML);
/*     */   }
/*     */ 
/*     */   public void writeRowId(RowId paramRowId)
/*     */     throws SQLException
/*     */   {
/* 913 */     writeROWID((ROWID)paramRowId);
/*     */   }
/*     */ 
/*     */   protected oracle.jdbc.internal.OracleConnection getConnectionDuringExceptionHandling()
/*     */   {
/* 928 */     return null;
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.sql.OracleSQLOutput
 * JD-Core Version:    0.6.2
 */