/*      */ package oracle.sql;
/*      */ 
/*      */ import java.io.InputStream;
/*      */ import java.io.Reader;
/*      */ import java.math.BigDecimal;
/*      */ import java.net.URL;
/*      */ import java.sql.Array;
/*      */ import java.sql.Blob;
/*      */ import java.sql.Clob;
/*      */ import java.sql.Date;
/*      */ import java.sql.NClob;
/*      */ import java.sql.Ref;
/*      */ import java.sql.RowId;
/*      */ import java.sql.SQLException;
/*      */ import java.sql.SQLInput;
/*      */ import java.sql.SQLXML;
/*      */ import java.sql.Struct;
/*      */ import java.sql.Time;
/*      */ import java.sql.Timestamp;
/*      */ import java.util.Map;
/*      */ import oracle.jdbc.driver.DatabaseError;
/*      */ 
/*      */ public class OracleJdbc2SQLInput
/*      */   implements SQLInput
/*      */ {
/*      */   private int index;
/*      */   private Datum[] attributes;
/*      */   private Map map;
/*      */   private oracle.jdbc.OracleConnection conn;
/* 1346 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*      */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*      */   public static final boolean TRACE = false;
/*      */ 
/*      */   public OracleJdbc2SQLInput(Datum[] paramArrayOfDatum, Map paramMap, oracle.jdbc.OracleConnection paramOracleConnection)
/*      */   {
/*   92 */     this.attributes = paramArrayOfDatum;
/*   93 */     this.map = paramMap;
/*   94 */     this.conn = paramOracleConnection;
/*   95 */     this.index = 0;
/*      */   }
/*      */ 
/*      */   public String readString()
/*      */     throws SQLException
/*      */   {
/*  118 */     String str = null;
/*      */     try
/*      */     {
/*  122 */       if (this.attributes[this.index] != null)
/*      */       {
/*  124 */         str = this.attributes[this.index].stringValue();
/*      */       }
/*      */     }
/*      */     finally
/*      */     {
/*  129 */       this.index += 1;
/*      */     }
/*  131 */     return str;
/*      */   }
/*      */ 
/*      */   public boolean readBoolean()
/*      */     throws SQLException
/*      */   {
/*  149 */     boolean bool = false;
/*      */     try
/*      */     {
/*  153 */       if (this.attributes[this.index] != null)
/*      */       {
/*  155 */         bool = this.attributes[this.index].booleanValue();
/*      */       }
/*      */     }
/*      */     finally
/*      */     {
/*  160 */       this.index += 1;
/*      */     }
/*  162 */     return bool;
/*      */   }
/*      */ 
/*      */   public byte readByte()
/*      */     throws SQLException
/*      */   {
/*  180 */     byte b = 0;
/*      */     try
/*      */     {
/*  184 */       if (this.attributes[this.index] != null)
/*      */       {
/*  186 */         b = this.attributes[this.index].byteValue();
/*      */       }
/*      */     }
/*      */     finally
/*      */     {
/*  191 */       this.index += 1;
/*      */     }
/*  193 */     return b;
/*      */   }
/*      */ 
/*      */   public short readShort()
/*      */     throws SQLException
/*      */   {
/*  210 */     long l = readLong();
/*      */ 
/*  212 */     if ((l > 65537L) || (l < -65538L))
/*      */     {
/*  215 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 26, "readShort");
/*  216 */       localSQLException.fillInStackTrace();
/*  217 */       throw localSQLException;
/*      */     }
/*      */ 
/*  220 */     return (short)(int)l;
/*      */   }
/*      */ 
/*      */   public int readInt()
/*      */     throws SQLException
/*      */   {
/*  237 */     int i = 0;
/*      */     try
/*      */     {
/*  241 */       if (this.attributes[this.index] != null)
/*      */       {
/*  243 */         i = this.attributes[this.index].intValue();
/*      */       }
/*      */     }
/*      */     finally
/*      */     {
/*  248 */       this.index += 1;
/*      */     }
/*  250 */     return i;
/*      */   }
/*      */ 
/*      */   public long readLong()
/*      */     throws SQLException
/*      */   {
/*  267 */     long l = 0L;
/*      */     try
/*      */     {
/*  271 */       if (this.attributes[this.index] != null)
/*      */       {
/*  273 */         l = this.attributes[this.index].longValue();
/*      */       }
/*      */     }
/*      */     finally
/*      */     {
/*  278 */       this.index += 1;
/*      */     }
/*  280 */     return l;
/*      */   }
/*      */ 
/*      */   public float readFloat()
/*      */     throws SQLException
/*      */   {
/*  297 */     float f = 0.0F;
/*      */     try
/*      */     {
/*  301 */       if (this.attributes[this.index] != null)
/*      */       {
/*  303 */         f = this.attributes[this.index].floatValue();
/*      */       }
/*      */     }
/*      */     finally
/*      */     {
/*  308 */       this.index += 1;
/*      */     }
/*  310 */     return f;
/*      */   }
/*      */ 
/*      */   public double readDouble()
/*      */     throws SQLException
/*      */   {
/*  327 */     double d = 0.0D;
/*      */     try
/*      */     {
/*  331 */       if (this.attributes[this.index] != null)
/*      */       {
/*  333 */         d = this.attributes[this.index].doubleValue();
/*      */       }
/*      */     }
/*      */     finally
/*      */     {
/*  338 */       this.index += 1;
/*      */     }
/*  340 */     return d;
/*      */   }
/*      */ 
/*      */   public BigDecimal readBigDecimal()
/*      */     throws SQLException
/*      */   {
/*  357 */     BigDecimal localBigDecimal = null;
/*      */     try
/*      */     {
/*  361 */       if (this.attributes[this.index] != null)
/*      */       {
/*  363 */         localBigDecimal = this.attributes[this.index].bigDecimalValue();
/*      */       }
/*      */     }
/*      */     finally
/*      */     {
/*  368 */       this.index += 1;
/*      */     }
/*  370 */     return localBigDecimal;
/*      */   }
/*      */ 
/*      */   public byte[] readBytes()
/*      */     throws SQLException
/*      */   {
/*  387 */     byte[] arrayOfByte = null;
/*      */     try
/*      */     {
/*  391 */       if (this.attributes[this.index] != null)
/*      */       {
/*  393 */         if ((this.attributes[this.index] instanceof RAW)) {
/*  394 */           arrayOfByte = ((RAW)this.attributes[this.index]).shareBytes();
/*      */         }
/*      */         else
/*      */         {
/*  398 */           SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4, null);
/*  399 */           localSQLException.fillInStackTrace();
/*  400 */           throw localSQLException;
/*      */         }
/*      */       }
/*      */ 
/*      */     }
/*      */     finally
/*      */     {
/*  407 */       this.index += 1;
/*      */     }
/*  409 */     return arrayOfByte;
/*      */   }
/*      */ 
/*      */   public Date readDate()
/*      */     throws SQLException
/*      */   {
/*  426 */     Date localDate = null;
/*      */     try
/*      */     {
/*  430 */       if (this.attributes[this.index] != null)
/*      */       {
/*  432 */         localDate = this.attributes[this.index].dateValue();
/*      */       }
/*      */     }
/*      */     finally
/*      */     {
/*  437 */       this.index += 1;
/*      */     }
/*  439 */     return localDate;
/*      */   }
/*      */ 
/*      */   public Time readTime()
/*      */     throws SQLException
/*      */   {
/*  456 */     Time localTime = null;
/*      */     try
/*      */     {
/*  460 */       if (this.attributes[this.index] != null)
/*      */       {
/*  462 */         localTime = this.attributes[this.index].timeValue();
/*      */       }
/*      */     }
/*      */     finally
/*      */     {
/*  467 */       this.index += 1;
/*      */     }
/*  469 */     return localTime;
/*      */   }
/*      */ 
/*      */   public Timestamp readTimestamp()
/*      */     throws SQLException
/*      */   {
/*  486 */     Timestamp localTimestamp = null;
/*      */     try
/*      */     {
/*  490 */       if (this.attributes[this.index] != null)
/*      */       {
/*  492 */         localTimestamp = this.attributes[this.index].timestampValue();
/*      */       }
/*      */     }
/*      */     finally
/*      */     {
/*  497 */       this.index += 1;
/*      */     }
/*  499 */     return localTimestamp;
/*      */   }
/*      */ 
/*      */   public Reader readCharacterStream()
/*      */     throws SQLException
/*      */   {
/*  516 */     Reader localReader = null;
/*      */     try
/*      */     {
/*  520 */       Datum localDatum = this.attributes[this.index];
/*      */ 
/*  522 */       if (localDatum != null)
/*      */       {
/*  524 */         localReader = localDatum.characterStreamValue();
/*      */       }
/*      */     }
/*      */     finally
/*      */     {
/*  529 */       this.index += 1;
/*      */     }
/*  531 */     return localReader;
/*      */   }
/*      */ 
/*      */   public InputStream readAsciiStream()
/*      */     throws SQLException
/*      */   {
/*  548 */     InputStream localInputStream = null;
/*      */     try
/*      */     {
/*  552 */       Datum localDatum = this.attributes[this.index];
/*      */ 
/*  554 */       if (localDatum != null)
/*      */       {
/*  556 */         localInputStream = localDatum.asciiStreamValue();
/*      */       }
/*      */     }
/*      */     finally
/*      */     {
/*  561 */       this.index += 1;
/*      */     }
/*  563 */     return localInputStream;
/*      */   }
/*      */ 
/*      */   public InputStream readBinaryStream()
/*      */     throws SQLException
/*      */   {
/*  581 */     InputStream localInputStream = null;
/*      */     try
/*      */     {
/*  585 */       Datum localDatum = this.attributes[this.index];
/*      */ 
/*  587 */       if (localDatum != null)
/*      */       {
/*  589 */         localInputStream = localDatum.binaryStreamValue();
/*      */       }
/*      */     }
/*      */     finally
/*      */     {
/*  594 */       this.index += 1;
/*      */     }
/*  596 */     return localInputStream;
/*      */   }
/*      */ 
/*      */   public Object readObject()
/*      */     throws SQLException
/*      */   {
/*  628 */     Datum localDatum = (Datum)readOracleObject();
/*  629 */     Object localObject = null;
/*      */ 
/*  631 */     if (localDatum != null)
/*      */     {
/*  633 */       if ((localDatum instanceof STRUCT))
/*  634 */         localObject = ((STRUCT)localDatum).toJdbc(this.map);
/*      */       else {
/*  636 */         localObject = localDatum.toJdbc();
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*  644 */     return localObject;
/*      */   }
/*      */ 
/*      */   public Ref readRef()
/*      */     throws SQLException
/*      */   {
/*  661 */     return readREF();
/*      */   }
/*      */ 
/*      */   public Blob readBlob()
/*      */     throws SQLException
/*      */   {
/*  678 */     return readBLOB();
/*      */   }
/*      */ 
/*      */   public Clob readClob()
/*      */     throws SQLException
/*      */   {
/*  695 */     return readCLOB();
/*      */   }
/*      */ 
/*      */   public Array readArray()
/*      */     throws SQLException
/*      */   {
/*  712 */     return readARRAY();
/*      */   }
/*      */ 
/*      */   public Struct readStruct()
/*      */     throws SQLException
/*      */   {
/*  729 */     return readSTRUCT();
/*      */   }
/*      */ 
/*      */   public boolean wasNull()
/*      */     throws SQLException
/*      */   {
/*  747 */     if (this.index == 0)
/*      */     {
/*  750 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 24);
/*  751 */       localSQLException.fillInStackTrace();
/*  752 */       throw localSQLException;
/*      */     }
/*      */ 
/*  756 */     boolean bool = this.attributes[(this.index - 1)] == null;
/*  757 */     return bool;
/*      */   }
/*      */ 
/*      */   public Object readOracleObject()
/*      */     throws SQLException
/*      */   {
/*  774 */     return this.attributes[(this.index++)];
/*      */   }
/*      */ 
/*      */   public NUMBER readNUMBER()
/*      */     throws SQLException
/*      */   {
/*  791 */     NUMBER localNUMBER = null;
/*      */     try
/*      */     {
/*  794 */       if (this.attributes[this.index] != null)
/*      */       {
/*  796 */         if ((this.attributes[this.index] instanceof NUMBER)) {
/*  797 */           localNUMBER = (NUMBER)this.attributes[this.index];
/*      */         }
/*      */         else
/*      */         {
/*  801 */           SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4, null);
/*  802 */           localSQLException.fillInStackTrace();
/*  803 */           throw localSQLException;
/*      */         }
/*      */       }
/*      */ 
/*      */     }
/*      */     finally
/*      */     {
/*  810 */       this.index += 1;
/*      */     }
/*  812 */     return localNUMBER;
/*      */   }
/*      */ 
/*      */   public CHAR readCHAR()
/*      */     throws SQLException
/*      */   {
/*  829 */     CHAR localCHAR = null;
/*      */     try
/*      */     {
/*  833 */       if (this.attributes[this.index] != null)
/*      */       {
/*  835 */         if ((this.attributes[this.index] instanceof CHAR)) {
/*  836 */           localCHAR = (CHAR)this.attributes[this.index];
/*      */         }
/*      */         else
/*      */         {
/*  840 */           SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4, null);
/*  841 */           localSQLException.fillInStackTrace();
/*  842 */           throw localSQLException;
/*      */         }
/*      */       }
/*      */ 
/*      */     }
/*      */     finally
/*      */     {
/*  849 */       this.index += 1;
/*      */     }
/*  851 */     return localCHAR;
/*      */   }
/*      */ 
/*      */   public DATE readDATE()
/*      */     throws SQLException
/*      */   {
/*  868 */     DATE localDATE = null;
/*      */     try
/*      */     {
/*  872 */       if (this.attributes[this.index] != null)
/*      */       {
/*  874 */         if ((this.attributes[this.index] instanceof DATE)) {
/*  875 */           localDATE = (DATE)this.attributes[this.index];
/*      */         }
/*      */         else
/*      */         {
/*  879 */           SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4, null);
/*  880 */           localSQLException.fillInStackTrace();
/*  881 */           throw localSQLException;
/*      */         }
/*      */       }
/*      */ 
/*      */     }
/*      */     finally
/*      */     {
/*  888 */       this.index += 1;
/*      */     }
/*  890 */     return localDATE;
/*      */   }
/*      */ 
/*      */   public BFILE readBFILE()
/*      */     throws SQLException
/*      */   {
/*  907 */     BFILE localBFILE = null;
/*      */     try
/*      */     {
/*  911 */       if (this.attributes[this.index] != null)
/*      */       {
/*  913 */         if ((this.attributes[this.index] instanceof BFILE)) {
/*  914 */           localBFILE = (BFILE)this.attributes[this.index];
/*      */         }
/*      */         else
/*      */         {
/*  918 */           SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4, null);
/*  919 */           localSQLException.fillInStackTrace();
/*  920 */           throw localSQLException;
/*      */         }
/*      */       }
/*      */ 
/*      */     }
/*      */     finally
/*      */     {
/*  927 */       this.index += 1;
/*      */     }
/*  929 */     return localBFILE;
/*      */   }
/*      */ 
/*      */   public BLOB readBLOB()
/*      */     throws SQLException
/*      */   {
/*  946 */     BLOB localBLOB = null;
/*      */     try
/*      */     {
/*  950 */       if (this.attributes[this.index] != null)
/*      */       {
/*  952 */         if ((this.attributes[this.index] instanceof BLOB)) {
/*  953 */           localBLOB = (BLOB)this.attributes[this.index];
/*      */         }
/*      */         else
/*      */         {
/*  957 */           SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4, null);
/*  958 */           localSQLException.fillInStackTrace();
/*  959 */           throw localSQLException;
/*      */         }
/*      */       }
/*      */ 
/*      */     }
/*      */     finally
/*      */     {
/*  966 */       this.index += 1;
/*      */     }
/*  968 */     return localBLOB;
/*      */   }
/*      */ 
/*      */   public CLOB readCLOB()
/*      */     throws SQLException
/*      */   {
/*  985 */     CLOB localCLOB = null;
/*      */     try
/*      */     {
/*  989 */       if (this.attributes[this.index] != null)
/*      */       {
/*  991 */         if ((this.attributes[this.index] instanceof CLOB)) {
/*  992 */           localCLOB = (CLOB)this.attributes[this.index];
/*      */         }
/*      */         else
/*      */         {
/*  996 */           SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4, null);
/*  997 */           localSQLException.fillInStackTrace();
/*  998 */           throw localSQLException;
/*      */         }
/*      */       }
/*      */ 
/*      */     }
/*      */     finally
/*      */     {
/* 1005 */       this.index += 1;
/*      */     }
/* 1007 */     return localCLOB;
/*      */   }
/*      */ 
/*      */   public RAW readRAW()
/*      */     throws SQLException
/*      */   {
/* 1024 */     RAW localRAW = null;
/*      */     try
/*      */     {
/* 1028 */       if (this.attributes[this.index] != null)
/*      */       {
/* 1030 */         if ((this.attributes[this.index] instanceof RAW)) {
/* 1031 */           localRAW = (RAW)this.attributes[this.index];
/*      */         }
/*      */         else
/*      */         {
/* 1035 */           SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4, null);
/* 1036 */           localSQLException.fillInStackTrace();
/* 1037 */           throw localSQLException;
/*      */         }
/*      */       }
/*      */ 
/*      */     }
/*      */     finally
/*      */     {
/* 1044 */       this.index += 1;
/*      */     }
/* 1046 */     return localRAW;
/*      */   }
/*      */ 
/*      */   public REF readREF()
/*      */     throws SQLException
/*      */   {
/* 1063 */     REF localREF = null;
/*      */     try
/*      */     {
/* 1067 */       if (this.attributes[this.index] != null)
/*      */       {
/* 1069 */         if ((this.attributes[this.index] instanceof REF)) {
/* 1070 */           localREF = (REF)this.attributes[this.index];
/*      */         }
/*      */         else
/*      */         {
/* 1074 */           SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4, null);
/* 1075 */           localSQLException.fillInStackTrace();
/* 1076 */           throw localSQLException;
/*      */         }
/*      */       }
/*      */ 
/*      */     }
/*      */     finally
/*      */     {
/* 1083 */       this.index += 1;
/*      */     }
/* 1085 */     return localREF;
/*      */   }
/*      */ 
/*      */   public ROWID readROWID()
/*      */     throws SQLException
/*      */   {
/* 1102 */     ROWID localROWID = null;
/*      */     try
/*      */     {
/* 1106 */       if (this.attributes[this.index] != null)
/*      */       {
/* 1108 */         if ((this.attributes[this.index] instanceof ROWID)) {
/* 1109 */           localROWID = (ROWID)this.attributes[this.index];
/*      */         }
/*      */         else
/*      */         {
/* 1113 */           SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4, null);
/* 1114 */           localSQLException.fillInStackTrace();
/* 1115 */           throw localSQLException;
/*      */         }
/*      */       }
/*      */ 
/*      */     }
/*      */     finally
/*      */     {
/* 1122 */       this.index += 1;
/*      */     }
/* 1124 */     return localROWID;
/*      */   }
/*      */ 
/*      */   public ARRAY readARRAY()
/*      */     throws SQLException
/*      */   {
/* 1141 */     ARRAY localARRAY = null;
/*      */     try
/*      */     {
/* 1145 */       if (this.attributes[this.index] != null)
/*      */       {
/* 1147 */         if ((this.attributes[this.index] instanceof ARRAY)) {
/* 1148 */           localARRAY = (ARRAY)this.attributes[this.index];
/*      */         }
/*      */         else
/*      */         {
/* 1152 */           SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4, null);
/* 1153 */           localSQLException.fillInStackTrace();
/* 1154 */           throw localSQLException;
/*      */         }
/*      */       }
/*      */ 
/*      */     }
/*      */     finally
/*      */     {
/* 1161 */       this.index += 1;
/*      */     }
/* 1163 */     return localARRAY;
/*      */   }
/*      */ 
/*      */   public STRUCT readSTRUCT()
/*      */     throws SQLException
/*      */   {
/* 1180 */     STRUCT localSTRUCT = null;
/*      */     try
/*      */     {
/* 1184 */       if (this.attributes[this.index] != null)
/*      */       {
/* 1186 */         if ((this.attributes[this.index] instanceof STRUCT)) {
/* 1187 */           localSTRUCT = (STRUCT)this.attributes[this.index];
/*      */         }
/*      */         else
/*      */         {
/* 1191 */           SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4, null);
/* 1192 */           localSQLException.fillInStackTrace();
/* 1193 */           throw localSQLException;
/*      */         }
/*      */       }
/*      */ 
/*      */     }
/*      */     finally
/*      */     {
/* 1200 */       this.index += 1;
/*      */     }
/* 1202 */     return localSTRUCT;
/*      */   }
/*      */ 
/*      */   public URL readURL()
/*      */     throws SQLException
/*      */   {
/* 1230 */     SQLException localSQLException = DatabaseError.createUnsupportedFeatureSqlException();
/* 1231 */     localSQLException.fillInStackTrace();
/* 1232 */     throw localSQLException;
/*      */   }
/*      */ 
/*      */   public NClob readNClob()
/*      */     throws SQLException
/*      */   {
/* 1246 */     NCLOB localNCLOB = null;
/*      */     try
/*      */     {
/* 1250 */       if (this.attributes[this.index] != null)
/*      */       {
/* 1252 */         if ((this.attributes[this.index] instanceof NCLOB)) {
/* 1253 */           localNCLOB = (NCLOB)this.attributes[this.index];
/*      */         }
/*      */         else
/*      */         {
/* 1257 */           SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4, null);
/* 1258 */           localSQLException.fillInStackTrace();
/* 1259 */           throw localSQLException;
/*      */         }
/*      */       }
/*      */ 
/*      */     }
/*      */     finally
/*      */     {
/* 1266 */       this.index += 1;
/*      */     }
/* 1268 */     return localNCLOB;
/*      */   }
/*      */ 
/*      */   public String readNString()
/*      */     throws SQLException
/*      */   {
/* 1280 */     return readString();
/*      */   }
/*      */ 
/*      */   public SQLXML readSQLXML()
/*      */     throws SQLException
/*      */   {
/* 1292 */     SQLXML localSQLXML = null;
/*      */     try
/*      */     {
/* 1296 */       if (this.attributes[this.index] != null)
/*      */       {
/* 1298 */         if ((this.attributes[this.index] instanceof SQLXML)) {
/* 1299 */           localSQLXML = (SQLXML)this.attributes[this.index];
/*      */         }
/*      */         else
/*      */         {
/* 1303 */           SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 4, null);
/* 1304 */           localSQLException.fillInStackTrace();
/* 1305 */           throw localSQLException;
/*      */         }
/*      */       }
/*      */ 
/*      */     }
/*      */     finally
/*      */     {
/* 1312 */       this.index += 1;
/*      */     }
/* 1314 */     return localSQLXML;
/*      */   }
/*      */ 
/*      */   public RowId readRowId()
/*      */     throws SQLException
/*      */   {
/* 1326 */     return readROWID();
/*      */   }
/*      */ 
/*      */   protected oracle.jdbc.internal.OracleConnection getConnectionDuringExceptionHandling()
/*      */   {
/* 1341 */     return null;
/*      */   }
/*      */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.sql.OracleJdbc2SQLInput
 * JD-Core Version:    0.6.2
 */