/*     */ package oracle.sql;
/*     */ 
/*     */ import java.io.IOException;
/*     */ import java.io.ObjectInputStream;
/*     */ import java.io.ObjectOutputStream;
/*     */ import java.io.Serializable;
/*     */ import java.sql.Connection;
/*     */ import java.sql.SQLException;
/*     */ import oracle.jdbc.OracleTypeMetaData.Kind;
/*     */ import oracle.jdbc.driver.DatabaseError;
/*     */ import oracle.jdbc.internal.OracleTypeMetaData.Opaque;
/*     */ import oracle.jdbc.oracore.OracleNamedType;
/*     */ import oracle.jdbc.oracore.OracleTypeADT;
/*     */ import oracle.jdbc.oracore.OracleTypeOPAQUE;
/*     */ 
/*     */ /** @deprecated */
/*     */ public class OpaqueDescriptor extends TypeDescriptor
/*     */   implements OracleTypeMetaData.Opaque, Serializable
/*     */ {
/*     */   static final boolean DEBUG = false;
/*     */   static final long serialVersionUID = 1013921343538311063L;
/* 523 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   public OpaqueDescriptor(String paramString, Connection paramConnection)
/*     */     throws SQLException
/*     */   {
/*  57 */     super((short)58, paramString, paramConnection);
/*     */ 
/*  59 */     initPickler();
/*     */   }
/*     */ 
/*     */   public OpaqueDescriptor(SQLName paramSQLName, Connection paramConnection)
/*     */     throws SQLException
/*     */   {
/*  73 */     super((short)58, paramSQLName, paramConnection);
/*     */ 
/*  75 */     initPickler();
/*     */   }
/*     */ 
/*     */   public OpaqueDescriptor(SQLName paramSQLName, OracleTypeOPAQUE paramOracleTypeOPAQUE, Connection paramConnection)
/*     */     throws SQLException
/*     */   {
/*  90 */     super((short)58, paramSQLName, paramOracleTypeOPAQUE, paramConnection);
/*     */   }
/*     */ 
/*     */   public OpaqueDescriptor(OracleTypeADT paramOracleTypeADT, Connection paramConnection)
/*     */     throws SQLException
/*     */   {
/* 106 */     super((short)58, paramOracleTypeADT, paramConnection);
/*     */   }
/*     */ 
/*     */   OpaqueDescriptor(byte[] paramArrayOfByte, int paramInt, Connection paramConnection)
/*     */     throws SQLException
/*     */   {
/* 118 */     super((short)108);
/*     */ 
/* 120 */     this.toid = paramArrayOfByte;
/* 121 */     this.toidVersion = paramInt;
/* 122 */     setPhysicalConnectionOf(paramConnection);
/* 123 */     initPickler();
/*     */   }
/*     */ 
/*     */   public static OpaqueDescriptor createDescriptor(String paramString, Connection paramConnection)
/*     */     throws SQLException
/*     */   {
/* 141 */     if ((paramString == null) || (paramString.length() == 0))
/*     */     {
/* 144 */       localObject = DatabaseError.createSqlException(null, 60, "Invalid argument,'name' shouldn't be null nor an empty string and 'conn' should not be null");
/*     */ 
/* 146 */       ((SQLException)localObject).fillInStackTrace();
/* 147 */       throw ((Throwable)localObject);
/*     */     }
/*     */ 
/* 151 */     Object localObject = new SQLName(paramString, (oracle.jdbc.OracleConnection)paramConnection);
/* 152 */     String str = ((SQLName)localObject).getName();
/*     */ 
/* 155 */     OpaqueDescriptor localOpaqueDescriptor = null;
/* 156 */     if (paramConnection != null) {
/* 157 */       localOpaqueDescriptor = (OpaqueDescriptor)((oracle.jdbc.OracleConnection)paramConnection).getDescriptor(str);
/*     */     }
/*     */ 
/* 160 */     if (localOpaqueDescriptor == null)
/*     */     {
/*     */       OracleTypeOPAQUE localOracleTypeOPAQUE;
/* 162 */       if (str.equals("SYS.ANYTYPE"))
/*     */       {
/* 164 */         localOracleTypeOPAQUE = new OracleTypeOPAQUE(TypeDescriptor.ANYTYPETOID, 1, 0, (short)0, str, 7L);
/*     */ 
/* 166 */         localOpaqueDescriptor = new OpaqueDescriptor((SQLName)localObject, localOracleTypeOPAQUE, paramConnection);
/*     */       }
/* 168 */       else if (str.equals("SYS.ANYDATA"))
/*     */       {
/* 170 */         localOracleTypeOPAQUE = new OracleTypeOPAQUE(TypeDescriptor.ANYDATATOID, 1, 0, (short)0, str, 7L);
/*     */ 
/* 172 */         localOpaqueDescriptor = new OpaqueDescriptor((SQLName)localObject, localOracleTypeOPAQUE, paramConnection);
/*     */       }
/*     */       else {
/* 175 */         int i = ((oracle.jdbc.OracleConnection)paramConnection).physicalConnectionWithin().getVersionNumber();
/* 176 */         if (i >= 12000) {
/* 177 */           localOpaqueDescriptor = new OpaqueDescriptor(paramString, paramConnection);
/*     */         }
/*     */         else {
/* 180 */           localOpaqueDescriptor = new OpaqueDescriptor((SQLName)localObject, paramConnection);
/*     */         }
/*     */       }
/*     */ 
/* 184 */       if (paramConnection != null) {
/* 185 */         ((oracle.jdbc.OracleConnection)paramConnection).putDescriptor(str, localOpaqueDescriptor);
/*     */       }
/*     */     }
/* 188 */     return localOpaqueDescriptor;
/*     */   }
/*     */ 
/*     */   public static OpaqueDescriptor createDescriptor(SQLName paramSQLName, Connection paramConnection)
/*     */     throws SQLException
/*     */   {
/* 204 */     String str = paramSQLName.getName();
/*     */ 
/* 207 */     OpaqueDescriptor localOpaqueDescriptor = null;
/* 208 */     if (paramConnection != null) {
/* 209 */       localOpaqueDescriptor = (OpaqueDescriptor)((oracle.jdbc.OracleConnection)paramConnection).getDescriptor(str);
/*     */     }
/*     */ 
/* 212 */     if (localOpaqueDescriptor == null)
/*     */     {
/*     */       OracleTypeOPAQUE localOracleTypeOPAQUE;
/* 214 */       if (str.equals("SYS.ANYTYPE"))
/*     */       {
/* 216 */         localOracleTypeOPAQUE = new OracleTypeOPAQUE(TypeDescriptor.ANYTYPETOID, 1, 0, (short)0, str, 7L);
/*     */ 
/* 218 */         localOpaqueDescriptor = new OpaqueDescriptor(paramSQLName, localOracleTypeOPAQUE, paramConnection);
/*     */       }
/* 220 */       else if (str.equals("SYS.ANYDATA"))
/*     */       {
/* 222 */         localOracleTypeOPAQUE = new OracleTypeOPAQUE(TypeDescriptor.ANYDATATOID, 1, 0, (short)0, str, 7L);
/*     */ 
/* 224 */         localOpaqueDescriptor = new OpaqueDescriptor(paramSQLName, localOracleTypeOPAQUE, paramConnection);
/*     */       }
/*     */       else {
/* 227 */         localOpaqueDescriptor = new OpaqueDescriptor(paramSQLName, paramConnection);
/*     */       }
/* 229 */       if (paramConnection != null) {
/* 230 */         ((oracle.jdbc.OracleConnection)paramConnection).putDescriptor(str, localOpaqueDescriptor);
/*     */       }
/*     */     }
/* 233 */     return localOpaqueDescriptor;
/*     */   }
/*     */ 
/*     */   public OracleTypeMetaData.Kind getKind()
/*     */   {
/* 247 */     return OracleTypeMetaData.Kind.OPAQUE;
/*     */   }
/*     */ 
/*     */   private void initPickler()
/*     */     throws SQLException
/*     */   {
/*     */     try
/*     */     {
/* 256 */       this.pickler = new OracleTypeADT(getName(), this.connection);
/*     */ 
/* 258 */       ((OracleTypeADT)this.pickler).init(this.connection);
/*     */ 
/* 260 */       this.pickler = ((OracleTypeOPAQUE)((OracleTypeADT)this.pickler).cleanup());
/*     */ 
/* 262 */       this.pickler.setDescriptor(this);
/*     */     }
/*     */     catch (Exception localException)
/*     */     {
/* 268 */       if ((localException instanceof SQLException)) {
/* 269 */         throw ((SQLException)localException);
/*     */       }
/*     */ 
/* 272 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 60, "Unable to resolve type \"" + getName() + "\"");
/*     */ 
/* 274 */       localSQLException.fillInStackTrace();
/* 275 */       throw localSQLException;
/*     */     }
/*     */   }
/*     */ 
/*     */   byte[] toBytes(OPAQUE paramOPAQUE, boolean paramBoolean)
/*     */     throws SQLException
/*     */   {
/* 284 */     byte[] arrayOfByte = null;
/*     */ 
/* 286 */     if (paramOPAQUE.shareBytes() != null)
/*     */     {
/* 288 */       arrayOfByte = paramOPAQUE.shareBytes();
/*     */     }
/*     */     else
/*     */     {
/*     */       try
/*     */       {
/* 294 */         arrayOfByte = this.pickler.linearize(paramOPAQUE);
/*     */       }
/*     */       finally
/*     */       {
/* 298 */         if (!paramBoolean) {
/* 299 */           paramOPAQUE.setShareBytes(null);
/*     */         }
/*     */       }
/*     */     }
/* 303 */     return arrayOfByte;
/*     */   }
/*     */ 
/*     */   byte[] toValue(OPAQUE paramOPAQUE, boolean paramBoolean)
/*     */     throws SQLException
/*     */   {
/* 310 */     byte[] arrayOfByte = null;
/*     */ 
/* 312 */     if (paramOPAQUE.value != null)
/*     */     {
/* 314 */       arrayOfByte = paramOPAQUE.value;
/*     */     }
/*     */     else
/*     */     {
/*     */       try
/*     */       {
/* 320 */         this.pickler.unlinearize(paramOPAQUE.shareBytes(), 0L, paramOPAQUE, 1, null);
/*     */ 
/* 322 */         arrayOfByte = paramOPAQUE.value;
/*     */       }
/*     */       finally
/*     */       {
/* 326 */         if (!paramBoolean)
/* 327 */           paramOPAQUE.value = null;
/*     */       }
/*     */     }
/* 330 */     return arrayOfByte;
/*     */   }
/*     */ 
/*     */   public int getTypeCode()
/*     */     throws SQLException
/*     */   {
/* 346 */     if (((this.sqlName != null) && ("SYS.XMLTYPE".equalsIgnoreCase(this.sqlName.getName()))) || ((this.typeNameByUser != null) && ("SYS.XMLTYPE".equals(this.typeNameByUser))))
/*     */     {
/* 350 */       return 2009;
/*     */     }
/* 352 */     return 2007;
/*     */   }
/*     */ 
/*     */   public boolean isInHierarchyOf(String paramString)
/*     */     throws SQLException
/*     */   {
/* 366 */     OpaqueDescriptor localOpaqueDescriptor = this;
/* 367 */     String str = localOpaqueDescriptor.getName();
/* 368 */     return paramString.equals(str);
/*     */   }
/*     */ 
/*     */   public long getMaxLength()
/*     */     throws SQLException
/*     */   {
/* 385 */     long l = hasUnboundedSize() ? 0L : ((OracleTypeOPAQUE)this.pickler).getMaxLength();
/*     */ 
/* 388 */     return l;
/*     */   }
/*     */ 
/*     */   public boolean isTrustedLibrary()
/*     */     throws SQLException
/*     */   {
/* 409 */     return ((OracleTypeOPAQUE)this.pickler).isTrustedLibrary();
/*     */   }
/*     */ 
/*     */   public boolean isModeledInC()
/*     */     throws SQLException
/*     */   {
/* 427 */     return ((OracleTypeOPAQUE)this.pickler).isModeledInC();
/*     */   }
/*     */ 
/*     */   public boolean hasUnboundedSize()
/*     */     throws SQLException
/*     */   {
/* 445 */     return ((OracleTypeOPAQUE)this.pickler).isUnboundedSized();
/*     */   }
/*     */ 
/*     */   public boolean hasFixedSize()
/*     */     throws SQLException
/*     */   {
/* 464 */     return ((OracleTypeOPAQUE)this.pickler).isFixedSized();
/*     */   }
/*     */ 
/*     */   public String descType()
/*     */     throws SQLException
/*     */   {
/* 481 */     StringBuffer localStringBuffer = new StringBuffer();
/* 482 */     return descType(localStringBuffer, 0);
/*     */   }
/*     */ 
/*     */   String descType(StringBuffer paramStringBuffer, int paramInt)
/*     */     throws SQLException
/*     */   {
/* 489 */     String str1 = "";
/*     */ 
/* 491 */     for (int i = 0; i < paramInt; i++) {
/* 492 */       str1 = str1 + "  ";
/*     */     }
/* 494 */     String str2 = str1 + "  ";
/*     */ 
/* 496 */     paramStringBuffer.append(str1);
/* 497 */     paramStringBuffer.append(getTypeName());
/* 498 */     paramStringBuffer.append(" maxLen=" + getMaxLength() + " isTrusted=" + isTrustedLibrary() + " hasUnboundedSize=" + hasUnboundedSize() + " hasFixedSize=" + hasFixedSize());
/*     */ 
/* 501 */     paramStringBuffer.append("\n");
/*     */ 
/* 503 */     return paramStringBuffer.toString();
/*     */   }
/*     */ 
/*     */   private void writeObject(ObjectOutputStream paramObjectOutputStream)
/*     */     throws IOException
/*     */   {
/*     */   }
/*     */ 
/*     */   private void readObject(ObjectInputStream paramObjectInputStream)
/*     */     throws IOException, ClassNotFoundException
/*     */   {
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.sql.OpaqueDescriptor
 * JD-Core Version:    0.6.2
 */