/*      */ package oracle.sql;
/*      */ 
/*      */ import java.io.PrintStream;
/*      */ import java.math.BigDecimal;
/*      */ import java.math.BigInteger;
/*      */ import java.sql.SQLException;
/*      */ import oracle.core.lmx.CoreException;
/*      */ import oracle.jdbc.driver.DatabaseError;
/*      */ 
/*      */ public class NUMBER extends Datum
/*      */ {
/*  399 */   static byte[] MAX_LONG = toBytes(9223372036854775807L);
/*  400 */   static byte[] MIN_LONG = toBytes(-9223372036854775808L);
/*      */   private static final int CHARACTER_ZERO = 48;
/* 2992 */   private static final BigDecimal BIGDEC_NEGZERO = new BigDecimal("-0");
/* 2993 */   private static final BigDecimal BIGDEC_ZERO = BigDecimal.valueOf(0L);
/* 2994 */   private static final BigDecimal BIGDEC_ONE = BigDecimal.valueOf(1L);
/* 2995 */   private static final BigInteger BIGINT_ZERO = BigInteger.valueOf(0L);
/* 2996 */   private static final BigInteger BIGINT_HUND = BigInteger.valueOf(100L);
/*      */   private static final byte DIGEND = 21;
/*      */   private static final byte ODIGEND = 9;
/*      */   private static final int HUNDIGMAX = 66;
/*      */   private static final int BIGINTARRAYMAX = 54;
/*      */   private static final double BIGRATIO = 0.150514997831991D;
/*      */   private static final int BIGLENMAX = 22;
/*      */   static final byte LNXM_NUM = 22;
/*      */   static final int LNXSGNBT = 128;
/*      */   static final byte LNXDIGS = 20;
/*      */   static final byte LNXEXPBS = 64;
/*      */   static final double ORANUM_FBASE = 100.0D;
/*      */   static final int LNXBASE = 100;
/*      */   static final byte IEEE_DBL_DIG = 15;
/*      */   private static final byte IEEE_FLT_DIG = 6;
/*      */   static final int LNXEXPMX = 127;
/*      */   static final int LNXEXPMN = 0;
/*      */   static final int LNXMXOUT = 40;
/*      */   static final int LNXMXFMT = 64;
/*      */   private static final byte BYTE_MAX_VALUE = 127;
/*      */   private static final byte BYTE_MIN_VALUE = -128;
/*      */   private static final short SHORT_MAX_VALUE = 32767;
/*      */   private static final short SHORT_MIN_VALUE = -32768;
/* 3092 */   private static final byte[] PI = { -63, 4, 15, 16, 93, 66, 36, 90, 80, 33, 39, 47, 27, 44, 39, 33, 80, 51, 29, 85, 21 };
/*      */ 
/* 3096 */   private static final byte[] E = { -63, 3, 72, 83, 82, 83, 85, 60, 5, 53, 36, 37, 3, 88, 48, 14, 53, 67, 25, 98, 77 };
/*      */ 
/* 3100 */   private static final byte[] LN10 = { -63, 3, 31, 26, 86, 10, 30, 95, 5, 57, 85, 2, 80, 92, 46, 47, 85, 37, 43, 8, 61 };
/*      */   private static LnxLib _slnxlib;
/* 3113 */   private static LnxLib _thinlib = null;
/*      */ 
/* 3116 */   private static int DBL_MAX = 40;
/*      */ 
/* 3118 */   private static int INT_MAX = 15;
/* 3119 */   private static float FLOAT_MAX_INT = 2.147484E+009F;
/* 3120 */   private static float FLOAT_MIN_INT = -2.147484E+009F;
/* 3121 */   private static double DOUBLE_MAX_INT = 2147483647.0D;
/* 3122 */   private static double DOUBLE_MIN_INT = -2147483648.0D;
/* 3123 */   private static double DOUBLE_MAX_INT_2 = 2147483649.0D;
/* 3124 */   private static double DOUBLE_MIN_INT_2 = -2147483649.0D;
/*      */ 
/* 3487 */   private static Object drvType = null;
/*      */ 
/* 3502 */   private static String LANGID = "AMERICAN";
/*      */   static final long serialVersionUID = -1656085588913430059L;
/* 3506 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*      */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*      */   public static final boolean TRACE = false;
/*      */ 
/*      */   public NUMBER()
/*      */   {
/*  146 */     super(_makeZero());
/*      */   }
/*      */ 
/*      */   public NUMBER(byte[] paramArrayOfByte)
/*      */   {
/*  158 */     super(paramArrayOfByte);
/*      */   }
/*      */ 
/*      */   public NUMBER(byte paramByte)
/*      */   {
/*  168 */     super(toBytes(paramByte));
/*      */   }
/*      */ 
/*      */   public NUMBER(int paramInt)
/*      */   {
/*  178 */     super(toBytes(paramInt));
/*      */   }
/*      */ 
/*      */   public NUMBER(long paramLong)
/*      */   {
/*  187 */     super(toBytes(paramLong));
/*      */   }
/*      */ 
/*      */   public NUMBER(short paramShort)
/*      */   {
/*  196 */     super(toBytes(paramShort));
/*      */   }
/*      */ 
/*      */   public NUMBER(float paramFloat)
/*      */   {
/*  205 */     super(toBytes(paramFloat));
/*      */   }
/*      */ 
/*      */   public NUMBER(double paramDouble)
/*      */     throws SQLException
/*      */   {
/*  216 */     super(toBytes(paramDouble));
/*      */   }
/*      */ 
/*      */   public NUMBER(BigDecimal paramBigDecimal)
/*      */     throws SQLException
/*      */   {
/*  243 */     super(toBytes(paramBigDecimal));
/*      */   }
/*      */ 
/*      */   public NUMBER(BigInteger paramBigInteger)
/*      */     throws SQLException
/*      */   {
/*  258 */     super(toBytes(paramBigInteger));
/*      */   }
/*      */ 
/*      */   public NUMBER(String paramString, int paramInt)
/*      */     throws SQLException
/*      */   {
/*  274 */     super(toBytes(paramString, paramInt));
/*      */   }
/*      */ 
/*      */   public NUMBER(boolean paramBoolean)
/*      */   {
/*  284 */     super(toBytes(paramBoolean));
/*      */   }
/*      */ 
/*      */   public NUMBER(Object paramObject)
/*      */     throws SQLException
/*      */   {
/*  295 */     if ((paramObject instanceof Integer)) {
/*  296 */       setShareBytes(toBytes(((Integer)paramObject).intValue()));
/*      */     }
/*  298 */     else if ((paramObject instanceof Long)) {
/*  299 */       setShareBytes(toBytes(((Long)paramObject).longValue()));
/*      */     }
/*  301 */     else if ((paramObject instanceof Float)) {
/*  302 */       setShareBytes(toBytes(((Float)paramObject).floatValue()));
/*      */     }
/*  304 */     else if ((paramObject instanceof Double)) {
/*  305 */       setShareBytes(toBytes(((Double)paramObject).doubleValue()));
/*      */     }
/*  307 */     else if ((paramObject instanceof BigInteger)) {
/*  308 */       setShareBytes(toBytes((BigInteger)paramObject));
/*      */     }
/*  310 */     else if ((paramObject instanceof BigDecimal)) {
/*  311 */       setShareBytes(toBytes((BigDecimal)paramObject));
/*      */     }
/*  313 */     else if ((paramObject instanceof Boolean)) {
/*  314 */       setShareBytes(toBytes(((Boolean)paramObject).booleanValue()));
/*      */     }
/*  316 */     else if ((paramObject instanceof String)) {
/*  317 */       setShareBytes(stringToBytes((String)paramObject));
/*      */     }
/*  319 */     else if ((paramObject instanceof Short)) {
/*  320 */       setShareBytes(toBytes(((Short)paramObject).shortValue()));
/*      */     }
/*  322 */     else if ((paramObject instanceof Byte)) {
/*  323 */       setShareBytes(toBytes(((Byte)paramObject).byteValue()));
/*      */     }
/*      */     else
/*  326 */       throw new SQLException("Initialization failed");
/*      */   }
/*      */ 
/*      */   public static double toDouble(byte[] paramArrayOfByte)
/*      */   {
/*  350 */     if (_isZero(paramArrayOfByte)) {
/*  351 */       return 0.0D;
/*      */     }
/*  353 */     if (_isPosInf(paramArrayOfByte)) {
/*  354 */       return (1.0D / 0.0D);
/*      */     }
/*  356 */     if (_isNegInf(paramArrayOfByte)) {
/*  357 */       return (-1.0D / 0.0D);
/*      */     }
/*      */ 
/*  364 */     String str = null;
/*      */     try
/*      */     {
/*  368 */       if (drvType == null)
/*      */       {
/*  370 */         str = _slnxlib.lnxnuc(paramArrayOfByte, DBL_MAX, null);
/*      */       }
/*  372 */       else str = _slnxlib.lnxnuc(paramArrayOfByte, DBL_MAX, LANGID);
/*      */     }
/*      */     catch (Exception localException)
/*      */     {
/*      */     }
/*      */ 
/*  378 */     double d = Double.valueOf(str).doubleValue();
/*      */ 
/*  380 */     return d;
/*      */   }
/*      */ 
/*      */   public static float toFloat(byte[] paramArrayOfByte)
/*      */   {
/*  391 */     return (float)toDouble(paramArrayOfByte);
/*      */   }
/*      */ 
/*      */   public static long toLong(byte[] paramArrayOfByte)
/*      */     throws SQLException
/*      */   {
/*  415 */     if (_isZero(paramArrayOfByte)) {
/*  416 */       return 0L;
/*      */     }
/*      */ 
/*  420 */     if ((_isInf(paramArrayOfByte)) || (compareBytes(paramArrayOfByte, MAX_LONG) > 0) || (compareBytes(paramArrayOfByte, MIN_LONG) < 0))
/*      */     {
/*  423 */       throw new SQLException(CoreException.getMessage((byte)3));
/*      */     }
/*  425 */     return _getLnxLib().lnxsni(paramArrayOfByte);
/*      */   }
/*      */ 
/*      */   public static int toInt(byte[] paramArrayOfByte)
/*      */     throws SQLException
/*      */   {
/*  441 */     if (_isInf(paramArrayOfByte))
/*  442 */       throw new SQLException(CoreException.getMessage((byte)3));
/*      */     String str;
/*  457 */     if (drvType == null)
/*      */     {
/*  459 */       str = _slnxlib.lnxnuc(paramArrayOfByte, INT_MAX, null);
/*      */     }
/*  461 */     else str = _slnxlib.lnxnuc(paramArrayOfByte, INT_MAX, LANGID);
/*      */ 
/*  464 */     double d = Double.valueOf(str).doubleValue();
/*      */ 
/*  467 */     if (((float)d > FLOAT_MAX_INT) || ((float)d < FLOAT_MIN_INT)) {
/*  468 */       throw new SQLException(CoreException.getMessage((byte)3));
/*      */     }
/*      */ 
/*  471 */     if ((d > DOUBLE_MAX_INT) && (d <= DOUBLE_MAX_INT_2)) {
/*  472 */       throw new SQLException(CoreException.getMessage((byte)3));
/*      */     }
/*  474 */     if ((d < DOUBLE_MIN_INT) && (d >= DOUBLE_MIN_INT_2))
/*  475 */       throw new SQLException(CoreException.getMessage((byte)3));
/*  476 */     int i = (int)d;
/*  477 */     return i;
/*      */   }
/*      */ 
/*      */   public static short toShort(byte[] paramArrayOfByte)
/*      */     throws SQLException
/*      */   {
/*  489 */     long l = 0L;
/*      */     try {
/*  491 */       l = toLong(paramArrayOfByte);
/*      */ 
/*  493 */       if ((l > 32767L) || (l < -32768L)) {
/*  494 */         throw new SQLException(CoreException.getMessage((byte)3));
/*      */       }
/*      */     }
/*      */     finally
/*      */     {
/*      */     }
/*      */ 
/*  501 */     return (short)(int)l;
/*      */   }
/*      */ 
/*      */   public static byte toByte(byte[] paramArrayOfByte)
/*      */     throws SQLException
/*      */   {
/*  512 */     long l = 0L;
/*      */     try {
/*  514 */       l = toLong(paramArrayOfByte);
/*      */ 
/*  516 */       if ((l > 127L) || (l < -128L)) {
/*  517 */         throw new SQLException(CoreException.getMessage((byte)3));
/*      */       }
/*      */     }
/*      */     finally
/*      */     {
/*      */     }
/*      */ 
/*  524 */     return (byte)(int)l;
/*      */   }
/*      */ 
/*      */   public static BigInteger toBigInteger(byte[] paramArrayOfByte)
/*      */     throws SQLException
/*      */   {
/*  536 */     long[] arrayOfLong = new long[10];
/*  537 */     int i = 9;
/*  538 */     int j = 1;
/*      */ 
/*  543 */     int i1 = 0;
/*      */ 
/*  549 */     if (_isZero(paramArrayOfByte)) {
/*  550 */       return BIGINT_ZERO;
/*      */     }
/*  552 */     if (_isInf(paramArrayOfByte)) {
/*  553 */       throw new SQLException(CoreException.getMessage((byte)3));
/*      */     }
/*      */ 
/*  556 */     boolean bool = _isPositive(paramArrayOfByte);
/*      */ 
/*  559 */     byte[] arrayOfByte1 = _fromLnxFmt(paramArrayOfByte);
/*      */ 
/*  562 */     if (arrayOfByte1[0] < 0)
/*      */     {
/*  564 */       return BIGINT_ZERO;
/*      */     }
/*      */ 
/*  570 */     int i2 = Math.min(arrayOfByte1[0] + 1, arrayOfByte1.length - 1);
/*  571 */     int k = i2;
/*      */ 
/*  574 */     if ((i2 & 0x1) == 1)
/*      */     {
/*  576 */       arrayOfLong[i] = arrayOfByte1[j];
/*  577 */       j = (byte)(j + 1);
/*  578 */       k--;
/*      */     }
/*      */     else
/*      */     {
/*  582 */       arrayOfLong[i] = (arrayOfByte1[j] * 100 + arrayOfByte1[(j + 1)]);
/*  583 */       j = (byte)(j + 2);
/*  584 */       k -= 2;
/*      */     }
/*      */ 
/*  588 */     int m = i;
/*  589 */     while (k != 0)
/*      */     {
/*  591 */       long l = arrayOfByte1[j] * 100 + arrayOfByte1[(j + 1)];
/*      */ 
/*  593 */       for (i = 9; i >= m; i = (byte)(i - 1))
/*      */       {
/*  595 */         l += arrayOfLong[i] * 10000L;
/*  596 */         arrayOfLong[i] = (l & 0xFFFF);
/*  597 */         l >>= 16;
/*      */       }
/*      */ 
/*  600 */       if (l != 0L);
/*  602 */       m = (byte)(m - 1);
/*  603 */       arrayOfLong[m] = l;
/*      */ 
/*  606 */       j = (byte)(j + 2);
/*  607 */       k -= 2;
/*      */     }
/*      */     int n;
/*  611 */     if (arrayOfLong[m] >> 8 != 0L)
/*  612 */       n = 2 * (9 - m) + 2;
/*      */     else {
/*  614 */       n = 2 * (9 - m) + 1;
/*      */     }
/*  616 */     byte[] arrayOfByte2 = new byte[n];
/*      */ 
/*  618 */     if ((n & 0x1) == 1)
/*      */     {
/*  620 */       arrayOfByte2[i1] = ((byte)(int)arrayOfLong[m]);
/*  621 */       i1++;
/*      */     }
/*      */     else
/*      */     {
/*  625 */       arrayOfByte2[i1] = ((byte)(int)(arrayOfLong[m] >> 8));
/*  626 */       i1++;
/*  627 */       arrayOfByte2[i1] = ((byte)(int)(arrayOfLong[m] & 0xFF));
/*  628 */       i1++;
/*      */     }
/*      */ 
/*  633 */     for (m = (byte)(m + 1); m <= 9; m = (byte)(m + 1))
/*      */     {
/*  635 */       arrayOfByte2[i1] = ((byte)(int)(arrayOfLong[m] >> 8));
/*  636 */       arrayOfByte2[(i1 + 1)] = ((byte)(int)(arrayOfLong[m] & 0xFF));
/*  637 */       i1 += 2;
/*      */     }
/*      */ 
/*  641 */     BigInteger localBigInteger = new BigInteger(bool ? 1 : -1, arrayOfByte2);
/*      */ 
/*  644 */     int i3 = arrayOfByte1[0] - (i2 - 1);
/*  645 */     return localBigInteger.multiply(BIGINT_HUND.pow(i3));
/*      */   }
/*      */ 
/*      */   public static BigDecimal toBigDecimal(byte[] paramArrayOfByte)
/*      */     throws SQLException
/*      */   {
/*  659 */     long[] arrayOfLong = new long[10];
/*  660 */     int i = 9;
/*  661 */     int j = 1;
/*      */ 
/*  666 */     int i1 = 0;
/*      */ 
/*  672 */     if (_isZero(paramArrayOfByte)) {
/*  673 */       return BIGDEC_ZERO;
/*      */     }
/*  675 */     if (_isInf(paramArrayOfByte)) {
/*  676 */       throw new SQLException(CoreException.getMessage((byte)3));
/*      */     }
/*      */ 
/*  679 */     boolean bool = _isPositive(paramArrayOfByte);
/*      */ 
/*  682 */     byte[] arrayOfByte1 = _fromLnxFmt(paramArrayOfByte);
/*      */     int i2;
/*  686 */     int k = i2 = arrayOfByte1.length - 1;
/*      */ 
/*  689 */     if ((i2 & 0x1) == 1)
/*      */     {
/*  691 */       arrayOfLong[i] = arrayOfByte1[j];
/*  692 */       j = (byte)(j + 1);
/*  693 */       k--;
/*      */     }
/*      */     else
/*      */     {
/*  697 */       arrayOfLong[i] = (arrayOfByte1[j] * 100 + arrayOfByte1[(j + 1)]);
/*  698 */       j = (byte)(j + 2);
/*  699 */       k -= 2;
/*      */     }
/*      */ 
/*  703 */     int m = i;
/*  704 */     while (k != 0)
/*      */     {
/*  706 */       long l = arrayOfByte1[j] * 100 + arrayOfByte1[(j + 1)];
/*      */ 
/*  708 */       for (i = 9; i >= m; i = (byte)(i - 1))
/*      */       {
/*  710 */         l += arrayOfLong[i] * 10000L;
/*  711 */         arrayOfLong[i] = (l & 0xFFFF);
/*  712 */         l >>= 16;
/*      */       }
/*      */ 
/*  715 */       if (l != 0L);
/*  717 */       m = (byte)(m - 1);
/*  718 */       arrayOfLong[m] = l;
/*      */ 
/*  721 */       j = (byte)(j + 2);
/*  722 */       k -= 2;
/*      */     }
/*      */     int n;
/*  726 */     if (arrayOfLong[m] >> 8 != 0L)
/*  727 */       n = 2 * (9 - m) + 2;
/*      */     else {
/*  729 */       n = 2 * (9 - m) + 1;
/*      */     }
/*  731 */     byte[] arrayOfByte2 = new byte[n];
/*      */ 
/*  733 */     if ((n & 0x1) == 1)
/*      */     {
/*  735 */       arrayOfByte2[i1] = ((byte)(int)arrayOfLong[m]);
/*  736 */       i1++;
/*      */     }
/*      */     else
/*      */     {
/*  740 */       arrayOfByte2[i1] = ((byte)(int)(arrayOfLong[m] >> 8));
/*  741 */       i1++;
/*  742 */       arrayOfByte2[i1] = ((byte)(int)(arrayOfLong[m] & 0xFF));
/*  743 */       i1++;
/*      */     }
/*      */ 
/*  748 */     for (m = (byte)(m + 1); m <= 9; m = (byte)(m + 1))
/*      */     {
/*  750 */       arrayOfByte2[i1] = ((byte)(int)(arrayOfLong[m] >> 8));
/*  751 */       arrayOfByte2[(i1 + 1)] = ((byte)(int)(arrayOfLong[m] & 0xFF));
/*  752 */       i1 += 2;
/*      */     }
/*      */ 
/*  756 */     BigInteger localBigInteger = new BigInteger(bool ? 1 : -1, arrayOfByte2);
/*  757 */     BigDecimal localBigDecimal = new BigDecimal(localBigInteger);
/*      */ 
/*  760 */     int i3 = arrayOfByte1[0] - i2 + 1;
/*      */ 
/*  763 */     localBigDecimal = localBigDecimal.movePointRight(i3 * 2);
/*      */ 
/*  769 */     if ((i3 < 0) && (arrayOfByte1[i2] % 10 == 0))
/*  770 */       localBigDecimal = localBigDecimal.setScale(-(i3 * 2 + 1));
/*  771 */     return localBigDecimal;
/*      */   }
/*      */ 
/*      */   public static String toString(byte[] paramArrayOfByte)
/*      */   {
/*  787 */     int i = 0;
/*      */ 
/*  792 */     if (_isZero(paramArrayOfByte)) {
/*  793 */       return "0";
/*      */     }
/*  795 */     if (_isPosInf(paramArrayOfByte)) {
/*  796 */       return new Double((1.0D / 0.0D)).toString();
/*      */     }
/*  798 */     if (_isNegInf(paramArrayOfByte)) {
/*  799 */       return new Double((-1.0D / 0.0D)).toString();
/*      */     }
/*      */ 
/*  802 */     byte[] arrayOfByte = _fromLnxFmt(paramArrayOfByte);
/*      */ 
/*  804 */     int k = arrayOfByte[0];
/*  805 */     int m = arrayOfByte.length - 1;
/*  806 */     int n = k - (m - 1);
/*      */     int i2;
/*  832 */     if (n >= 0)
/*      */     {
/*  834 */       i2 = 2 * (k + 1) + 1;
/*      */     }
/*  838 */     else if (k >= 0)
/*  839 */       i2 = 2 * (m + 1);
/*      */     else {
/*  841 */       i2 = 2 * (m - k) + 3;
/*      */     }
/*      */ 
/*  848 */     char[] arrayOfChar = new char[i2];
/*      */ 
/*  850 */     if (!_isPositive(paramArrayOfByte))
/*      */     {
/*  852 */       arrayOfChar[(i++)] = '-';
/*      */     }
/*      */     int j;
/*  855 */     if (n >= 0)
/*      */     {
/*  857 */       i += _byteToChars(arrayOfByte[1], arrayOfChar, i);
/*      */ 
/*  859 */       for (j = 2; j <= m; k--)
/*      */       {
/*  861 */         _byteTo2Chars(arrayOfByte[j], arrayOfChar, i);
/*  862 */         i += 2;
/*      */ 
/*  859 */         j++;
/*      */       }
/*      */ 
/*  866 */       if (k > 0)
/*  867 */         for (; k > 0; k--)
/*      */         {
/*  869 */           arrayOfChar[(i++)] = '0';
/*  870 */           arrayOfChar[(i++)] = '0';
/*      */         }
/*      */     }
/*      */     else
/*      */     {
/*  875 */       int i1 = m + n;
/*      */ 
/*  877 */       if (i1 > 0)
/*      */       {
/*  879 */         i += _byteToChars(arrayOfByte[1], arrayOfChar, i);
/*      */ 
/*  881 */         if (i1 == 1)
/*      */         {
/*  883 */           arrayOfChar[(i++)] = '.';
/*      */         }
/*      */ 
/*  886 */         for (j = 2; j < m; j++)
/*      */         {
/*  888 */           _byteTo2Chars(arrayOfByte[j], arrayOfChar, i);
/*  889 */           i += 2;
/*      */ 
/*  891 */           if (i1 == j)
/*      */           {
/*  893 */             arrayOfChar[(i++)] = '.';
/*      */           }
/*      */         }
/*  896 */         if (arrayOfByte[j] % 10 == 0)
/*      */         {
/*  898 */           i += _byteToChars((byte)(arrayOfByte[j] / 10), arrayOfChar, i);
/*      */         }
/*      */         else
/*      */         {
/*  902 */           _byteTo2Chars(arrayOfByte[j], arrayOfChar, i);
/*  903 */           i += 2;
/*      */         }
/*      */       }
/*      */       else
/*      */       {
/*  908 */         arrayOfChar[(i++)] = '0';
/*  909 */         arrayOfChar[(i++)] = '.';
/*      */ 
/*  911 */         for (; i1 < 0; i1++)
/*      */         {
/*  913 */           arrayOfChar[(i++)] = '0';
/*  914 */           arrayOfChar[(i++)] = '0';
/*      */         }
/*      */ 
/*  917 */         for (j = 1; j < m; j++)
/*      */         {
/*  919 */           _byteTo2Chars(arrayOfByte[j], arrayOfChar, i);
/*  920 */           i += 2;
/*      */         }
/*      */ 
/*  923 */         if (arrayOfByte[j] % 10 == 0)
/*      */         {
/*  925 */           i += _byteToChars((byte)(arrayOfByte[j] / 10), arrayOfChar, i);
/*      */         }
/*      */         else
/*      */         {
/*  929 */           _byteTo2Chars(arrayOfByte[j], arrayOfChar, i);
/*  930 */           i += 2;
/*      */         }
/*      */       }
/*      */     }
/*      */ 
/*  935 */     return new String(arrayOfChar, 0, i);
/*      */   }
/*      */ 
/*      */   public static boolean toBoolean(byte[] paramArrayOfByte)
/*      */   {
/*  947 */     if (_isZero(paramArrayOfByte)) {
/*  948 */       return false;
/*      */     }
/*  950 */     return true;
/*      */   }
/*      */ 
/*      */   public static byte[] toBytes(double paramDouble)
/*      */     throws SQLException
/*      */   {
/*  966 */     if (Double.isNaN(paramDouble)) {
/*  967 */       throw new IllegalArgumentException(CoreException.getMessage((byte)11));
/*      */     }
/*      */ 
/*  972 */     if ((paramDouble == 0.0D) || (paramDouble == -0.0D)) {
/*  973 */       return _makeZero();
/*      */     }
/*  975 */     if (paramDouble == (1.0D / 0.0D)) {
/*  976 */       return _makePosInf();
/*      */     }
/*      */ 
/*  979 */     if (paramDouble == (-1.0D / 0.0D)) {
/*  980 */       return _makeNegInf();
/*      */     }
/*      */ 
/*  985 */     return _getThinLib().lnxren(paramDouble);
/*      */   }
/*      */ 
/*      */   public static byte[] toBytes(float paramFloat)
/*      */   {
/*  999 */     if (Float.isNaN(paramFloat)) {
/* 1000 */       throw new IllegalArgumentException(CoreException.getMessage((byte)11));
/*      */     }
/*      */ 
/* 1005 */     if ((paramFloat == 0.0F) || (paramFloat == -0.0F)) {
/* 1006 */       return _makeZero();
/*      */     }
/* 1008 */     if (paramFloat == (1.0F / 1.0F)) {
/* 1009 */       return _makePosInf();
/*      */     }
/* 1011 */     if (paramFloat == (1.0F / -1.0F)) {
/* 1012 */       return _makeNegInf();
/*      */     }
/*      */ 
/* 1017 */     String str = Float.toString(paramFloat);
/*      */     try
/*      */     {
/* 1027 */       return _getLnxLib().lnxcpn(str, false, 0, false, 0, "AMERICAN_AMERICA");
/*      */     }
/*      */     catch (Exception localException) {
/*      */     }
/* 1031 */     return null;
/*      */   }
/*      */ 
/*      */   public static byte[] toBytes(long paramLong)
/*      */   {
/* 1046 */     return _getLnxLib().lnxmin(paramLong);
/*      */   }
/*      */ 
/*      */   public static byte[] toBytes(int paramInt)
/*      */   {
/* 1058 */     return toBytes(paramInt);
/*      */   }
/*      */ 
/*      */   public static byte[] toBytes(short paramShort)
/*      */   {
/* 1070 */     return toBytes(paramShort);
/*      */   }
/*      */ 
/*      */   public static byte[] toBytes(byte paramByte)
/*      */   {
/* 1082 */     return toBytes(paramByte); } 
/*      */   public static byte[] toBytes(BigInteger paramBigInteger) throws SQLException { // Byte code:
/*      */     //   0: aload_0
/*      */     //   1: ifnonnull +19 -> 20
/*      */     //   4: aconst_null
/*      */     //   5: bipush 68
/*      */     //   7: ldc 115
/*      */     //   9: invokestatic 116	oracle/jdbc/driver/DatabaseError:createSqlException	(Loracle/jdbc/internal/OracleConnection;ILjava/lang/Object;)Ljava/sql/SQLException;
/*      */     //   12: astore_1
/*      */     //   13: aload_1
/*      */     //   14: invokevirtual 117	java/sql/SQLException:fillInStackTrace	()Ljava/lang/Throwable;
/*      */     //   17: pop
/*      */     //   18: aload_1
/*      */     //   19: athrow
/*      */     //   20: bipush 66
/*      */     //   22: newarray byte
/*      */     //   24: astore_1
/*      */     //   25: bipush 54
/*      */     //   27: newarray long
/*      */     //   29: astore_2
/*      */     //   30: bipush 22
/*      */     //   32: newarray long
/*      */     //   34: astore_3
/*      */     //   35: bipush 21
/*      */     //   37: istore 4
/*      */     //   39: iconst_0
/*      */     //   40: istore 5
/*      */     //   42: bipush 21
/*      */     //   44: istore 7
/*      */     //   46: iconst_0
/*      */     //   47: istore 10
/*      */     //   49: iconst_0
/*      */     //   50: istore 12
/*      */     //   52: iconst_1
/*      */     //   53: istore 14
/*      */     //   55: aload_0
/*      */     //   56: invokevirtual 118	java/math/BigInteger:signum	()I
/*      */     //   59: ifne +7 -> 66
/*      */     //   62: invokestatic 1	oracle/sql/NUMBER:_makeZero	()[B
/*      */     //   65: areturn
/*      */     //   66: aload_0
/*      */     //   67: invokevirtual 118	java/math/BigInteger:signum	()I
/*      */     //   70: iconst_m1
/*      */     //   71: if_icmpne +38 -> 109
/*      */     //   74: aload_0
/*      */     //   75: invokevirtual 119	java/math/BigInteger:abs	()Ljava/math/BigInteger;
/*      */     //   78: astore 17
/*      */     //   80: iconst_0
/*      */     //   81: istore 14
/*      */     //   83: aload 17
/*      */     //   85: invokevirtual 120	java/math/BigInteger:toByteArray	()[B
/*      */     //   88: astore 13
/*      */     //   90: aload 17
/*      */     //   92: invokevirtual 121	java/math/BigInteger:bitLength	()I
/*      */     //   95: i2d
/*      */     //   96: ldc2_w 122
/*      */     //   99: dmul
/*      */     //   100: invokestatic 124	java/lang/Math:floor	(D)D
/*      */     //   103: d2i
/*      */     //   104: istore 15
/*      */     //   106: goto +24 -> 130
/*      */     //   109: aload_0
/*      */     //   110: invokevirtual 120	java/math/BigInteger:toByteArray	()[B
/*      */     //   113: astore 13
/*      */     //   115: aload_0
/*      */     //   116: invokevirtual 121	java/math/BigInteger:bitLength	()I
/*      */     //   119: i2d
/*      */     //   120: ldc2_w 122
/*      */     //   123: dmul
/*      */     //   124: invokestatic 124	java/lang/Math:floor	(D)D
/*      */     //   127: d2i
/*      */     //   128: istore 15
/*      */     //   130: aload_0
/*      */     //   131: invokevirtual 119	java/math/BigInteger:abs	()Ljava/math/BigInteger;
/*      */     //   134: getstatic 85	oracle/sql/NUMBER:BIGINT_HUND	Ljava/math/BigInteger;
/*      */     //   137: iload 15
/*      */     //   139: invokevirtual 86	java/math/BigInteger:pow	(I)Ljava/math/BigInteger;
/*      */     //   142: invokevirtual 125	java/math/BigInteger:compareTo	(Ljava/math/BigInteger;)I
/*      */     //   145: ifge +6 -> 151
/*      */     //   148: iinc 15 255
/*      */     //   151: aload 13
/*      */     //   153: arraylength
/*      */     //   154: bipush 54
/*      */     //   156: if_icmple +15 -> 171
/*      */     //   159: new 33	java/sql/SQLException
/*      */     //   162: dup
/*      */     //   163: iconst_3
/*      */     //   164: invokestatic 55	oracle/core/lmx/CoreException:getMessage	(B)Ljava/lang/String;
/*      */     //   167: invokespecial 35	java/sql/SQLException:<init>	(Ljava/lang/String;)V
/*      */     //   170: athrow
/*      */     //   171: iconst_0
/*      */     //   172: istore 16
/*      */     //   174: iload 16
/*      */     //   176: aload 13
/*      */     //   178: arraylength
/*      */     //   179: if_icmpge +44 -> 223
/*      */     //   182: aload 13
/*      */     //   184: iload 16
/*      */     //   186: baload
/*      */     //   187: ifge +20 -> 207
/*      */     //   190: aload_2
/*      */     //   191: iload 16
/*      */     //   193: aload 13
/*      */     //   195: iload 16
/*      */     //   197: baload
/*      */     //   198: sipush 256
/*      */     //   201: iadd
/*      */     //   202: i2l
/*      */     //   203: lastore
/*      */     //   204: goto +13 -> 217
/*      */     //   207: aload_2
/*      */     //   208: iload 16
/*      */     //   210: aload 13
/*      */     //   212: iload 16
/*      */     //   214: baload
/*      */     //   215: i2l
/*      */     //   216: lastore
/*      */     //   217: iinc 16 1
/*      */     //   220: goto -46 -> 174
/*      */     //   223: aload 13
/*      */     //   225: arraylength
/*      */     //   226: istore 6
/*      */     //   228: iload 6
/*      */     //   230: iconst_3
/*      */     //   231: irem
/*      */     //   232: lookupswitch	default:+80->312, 1:+59->291, 2:+28->260
/*      */     //   261: iload 4
/*      */     //   263: aload_2
/*      */     //   264: iload 5
/*      */     //   266: laload
/*      */     //   267: bipush 8
/*      */     //   269: lshl
/*      */     //   270: aload_2
/*      */     //   271: iload 5
/*      */     //   273: iconst_1
/*      */     //   274: iadd
/*      */     //   275: laload
/*      */     //   276: ladd
/*      */     //   277: lastore
/*      */     //   278: iload 5
/*      */     //   280: iconst_2
/*      */     //   281: iadd
/*      */     //   282: i2b
/*      */     //   283: istore 5
/*      */     //   285: iinc 6 254
/*      */     //   288: goto +104 -> 392
/*      */     //   291: aload_3
/*      */     //   292: iload 4
/*      */     //   294: aload_2
/*      */     //   295: iload 5
/*      */     //   297: laload
/*      */     //   298: lastore
/*      */     //   299: iload 5
/*      */     //   301: iconst_1
/*      */     //   302: iadd
/*      */     //   303: i2b
/*      */     //   304: istore 5
/*      */     //   306: iinc 6 255
/*      */     //   309: goto +83 -> 392
/*      */     //   312: aload_2
/*      */     //   313: iload 5
/*      */     //   315: laload
/*      */     //   316: bipush 16
/*      */     //   318: lshl
/*      */     //   319: aload_2
/*      */     //   320: iload 5
/*      */     //   322: iconst_1
/*      */     //   323: iadd
/*      */     //   324: laload
/*      */     //   325: bipush 8
/*      */     //   327: lshl
/*      */     //   328: ladd
/*      */     //   329: aload_2
/*      */     //   330: iload 5
/*      */     //   332: iconst_2
/*      */     //   333: iadd
/*      */     //   334: laload
/*      */     //   335: ladd
/*      */     //   336: lstore 8
/*      */     //   338: aload_3
/*      */     //   339: iload 4
/*      */     //   341: lload 8
/*      */     //   343: ldc2_w 126
/*      */     //   346: lrem
/*      */     //   347: lastore
/*      */     //   348: aload_3
/*      */     //   349: iload 4
/*      */     //   351: iconst_1
/*      */     //   352: isub
/*      */     //   353: lload 8
/*      */     //   355: ldc2_w 126
/*      */     //   358: ldiv
/*      */     //   359: lastore
/*      */     //   360: iload 7
/*      */     //   362: aload_3
/*      */     //   363: iload 4
/*      */     //   365: iconst_1
/*      */     //   366: isub
/*      */     //   367: laload
/*      */     //   368: lconst_0
/*      */     //   369: lcmp
/*      */     //   370: ifeq +7 -> 377
/*      */     //   373: iconst_1
/*      */     //   374: goto +4 -> 378
/*      */     //   377: iconst_0
/*      */     //   378: isub
/*      */     //   379: i2b
/*      */     //   380: istore 7
/*      */     //   382: iload 5
/*      */     //   384: iconst_3
/*      */     //   385: iadd
/*      */     //   386: i2b
/*      */     //   387: istore 5
/*      */     //   389: iinc 6 253
/*      */     //   392: iload 6
/*      */     //   394: ifeq +197 -> 591
/*      */     //   397: aload_2
/*      */     //   398: iload 5
/*      */     //   400: laload
/*      */     //   401: iconst_4
/*      */     //   402: lshl
/*      */     //   403: aload_2
/*      */     //   404: iload 5
/*      */     //   406: iconst_1
/*      */     //   407: iadd
/*      */     //   408: laload
/*      */     //   409: iconst_4
/*      */     //   410: lshr
/*      */     //   411: ladd
/*      */     //   412: lstore 8
/*      */     //   414: bipush 21
/*      */     //   416: istore 4
/*      */     //   418: iload 4
/*      */     //   420: iload 7
/*      */     //   422: if_icmplt +43 -> 465
/*      */     //   425: lload 8
/*      */     //   427: aload_3
/*      */     //   428: iload 4
/*      */     //   430: laload
/*      */     //   431: bipush 12
/*      */     //   433: lshl
/*      */     //   434: ladd
/*      */     //   435: lstore 8
/*      */     //   437: aload_3
/*      */     //   438: iload 4
/*      */     //   440: lload 8
/*      */     //   442: ldc2_w 126
/*      */     //   445: lrem
/*      */     //   446: lastore
/*      */     //   447: lload 8
/*      */     //   449: ldc2_w 126
/*      */     //   452: ldiv
/*      */     //   453: lstore 8
/*      */     //   455: iload 4
/*      */     //   457: iconst_1
/*      */     //   458: isub
/*      */     //   459: i2b
/*      */     //   460: istore 4
/*      */     //   462: goto -44 -> 418
/*      */     //   465: lload 8
/*      */     //   467: lconst_0
/*      */     //   468: lcmp
/*      */     //   469: ifeq +16 -> 485
/*      */     //   472: iload 7
/*      */     //   474: iconst_1
/*      */     //   475: isub
/*      */     //   476: i2b
/*      */     //   477: istore 7
/*      */     //   479: aload_3
/*      */     //   480: iload 7
/*      */     //   482: lload 8
/*      */     //   484: lastore
/*      */     //   485: aload_2
/*      */     //   486: iload 5
/*      */     //   488: iconst_1
/*      */     //   489: iadd
/*      */     //   490: laload
/*      */     //   491: ldc2_w 128
/*      */     //   494: land
/*      */     //   495: bipush 8
/*      */     //   497: lshl
/*      */     //   498: aload_2
/*      */     //   499: iload 5
/*      */     //   501: iconst_2
/*      */     //   502: iadd
/*      */     //   503: laload
/*      */     //   504: ladd
/*      */     //   505: lstore 8
/*      */     //   507: bipush 21
/*      */     //   509: istore 4
/*      */     //   511: iload 4
/*      */     //   513: iload 7
/*      */     //   515: if_icmplt +43 -> 558
/*      */     //   518: lload 8
/*      */     //   520: aload_3
/*      */     //   521: iload 4
/*      */     //   523: laload
/*      */     //   524: bipush 12
/*      */     //   526: lshl
/*      */     //   527: ladd
/*      */     //   528: lstore 8
/*      */     //   530: aload_3
/*      */     //   531: iload 4
/*      */     //   533: lload 8
/*      */     //   535: ldc2_w 126
/*      */     //   538: lrem
/*      */     //   539: lastore
/*      */     //   540: lload 8
/*      */     //   542: ldc2_w 126
/*      */     //   545: ldiv
/*      */     //   546: lstore 8
/*      */     //   548: iload 4
/*      */     //   550: iconst_1
/*      */     //   551: isub
/*      */     //   552: i2b
/*      */     //   553: istore 4
/*      */     //   555: goto -44 -> 511
/*      */     //   558: lload 8
/*      */     //   560: lconst_0
/*      */     //   561: lcmp
/*      */     //   562: ifeq +16 -> 578
/*      */     //   565: iload 7
/*      */     //   567: iconst_1
/*      */     //   568: isub
/*      */     //   569: i2b
/*      */     //   570: istore 7
/*      */     //   572: aload_3
/*      */     //   573: iload 7
/*      */     //   575: lload 8
/*      */     //   577: lastore
/*      */     //   578: iload 5
/*      */     //   580: iconst_3
/*      */     //   581: iadd
/*      */     //   582: i2b
/*      */     //   583: istore 5
/*      */     //   585: iinc 6 253
/*      */     //   588: goto -196 -> 392
/*      */     //   591: aload_1
/*      */     //   592: iload 12
/*      */     //   594: aload_3
/*      */     //   595: iload 7
/*      */     //   597: laload
/*      */     //   598: ldc2_w 78
/*      */     //   601: ldiv
/*      */     //   602: l2i
/*      */     //   603: i2b
/*      */     //   604: dup_x2
/*      */     //   605: bastore
/*      */     //   606: ifeq +56 -> 662
/*      */     //   609: iconst_3
/*      */     //   610: bipush 21
/*      */     //   612: iload 7
/*      */     //   614: isub
/*      */     //   615: imul
/*      */     //   616: iconst_3
/*      */     //   617: iadd
/*      */     //   618: istore 11
/*      */     //   620: aload_1
/*      */     //   621: iload 12
/*      */     //   623: iconst_1
/*      */     //   624: iadd
/*      */     //   625: aload_3
/*      */     //   626: iload 7
/*      */     //   628: laload
/*      */     //   629: ldc2_w 78
/*      */     //   632: lrem
/*      */     //   633: ldc2_w 130
/*      */     //   636: ldiv
/*      */     //   637: l2i
/*      */     //   638: i2b
/*      */     //   639: bastore
/*      */     //   640: aload_1
/*      */     //   641: iload 12
/*      */     //   643: iconst_2
/*      */     //   644: iadd
/*      */     //   645: aload_3
/*      */     //   646: iload 7
/*      */     //   648: laload
/*      */     //   649: ldc2_w 130
/*      */     //   652: lrem
/*      */     //   653: l2i
/*      */     //   654: i2b
/*      */     //   655: bastore
/*      */     //   656: iinc 12 3
/*      */     //   659: goto +82 -> 741
/*      */     //   662: aload_1
/*      */     //   663: iload 12
/*      */     //   665: aload_3
/*      */     //   666: iload 7
/*      */     //   668: laload
/*      */     //   669: ldc2_w 78
/*      */     //   672: lrem
/*      */     //   673: ldc2_w 130
/*      */     //   676: ldiv
/*      */     //   677: l2i
/*      */     //   678: i2b
/*      */     //   679: dup_x2
/*      */     //   680: bastore
/*      */     //   681: ifeq +36 -> 717
/*      */     //   684: iconst_3
/*      */     //   685: bipush 21
/*      */     //   687: iload 7
/*      */     //   689: isub
/*      */     //   690: imul
/*      */     //   691: iconst_2
/*      */     //   692: iadd
/*      */     //   693: istore 11
/*      */     //   695: aload_1
/*      */     //   696: iload 12
/*      */     //   698: iconst_1
/*      */     //   699: iadd
/*      */     //   700: aload_3
/*      */     //   701: iload 7
/*      */     //   703: laload
/*      */     //   704: ldc2_w 130
/*      */     //   707: lrem
/*      */     //   708: l2i
/*      */     //   709: i2b
/*      */     //   710: bastore
/*      */     //   711: iinc 12 2
/*      */     //   714: goto +27 -> 741
/*      */     //   717: aload_1
/*      */     //   718: iload 12
/*      */     //   720: aload_3
/*      */     //   721: iload 7
/*      */     //   723: laload
/*      */     //   724: l2i
/*      */     //   725: i2b
/*      */     //   726: bastore
/*      */     //   727: iconst_3
/*      */     //   728: bipush 21
/*      */     //   730: iload 7
/*      */     //   732: isub
/*      */     //   733: imul
/*      */     //   734: iconst_1
/*      */     //   735: iadd
/*      */     //   736: istore 11
/*      */     //   738: iinc 12 1
/*      */     //   741: iload 7
/*      */     //   743: iconst_1
/*      */     //   744: iadd
/*      */     //   745: i2b
/*      */     //   746: istore 4
/*      */     //   748: iload 4
/*      */     //   750: bipush 21
/*      */     //   752: if_icmpgt +66 -> 818
/*      */     //   755: aload_1
/*      */     //   756: iload 12
/*      */     //   758: aload_3
/*      */     //   759: iload 4
/*      */     //   761: laload
/*      */     //   762: ldc2_w 78
/*      */     //   765: ldiv
/*      */     //   766: l2i
/*      */     //   767: i2b
/*      */     //   768: bastore
/*      */     //   769: aload_1
/*      */     //   770: iload 12
/*      */     //   772: iconst_1
/*      */     //   773: iadd
/*      */     //   774: aload_3
/*      */     //   775: iload 4
/*      */     //   777: laload
/*      */     //   778: ldc2_w 78
/*      */     //   781: lrem
/*      */     //   782: ldc2_w 130
/*      */     //   785: ldiv
/*      */     //   786: l2i
/*      */     //   787: i2b
/*      */     //   788: bastore
/*      */     //   789: aload_1
/*      */     //   790: iload 12
/*      */     //   792: iconst_2
/*      */     //   793: iadd
/*      */     //   794: aload_3
/*      */     //   795: iload 4
/*      */     //   797: laload
/*      */     //   798: ldc2_w 130
/*      */     //   801: lrem
/*      */     //   802: l2i
/*      */     //   803: i2b
/*      */     //   804: bastore
/*      */     //   805: iinc 12 3
/*      */     //   808: iload 4
/*      */     //   810: iconst_1
/*      */     //   811: iadd
/*      */     //   812: i2b
/*      */     //   813: istore 4
/*      */     //   815: goto -67 -> 748
/*      */     //   818: iload 12
/*      */     //   820: iconst_1
/*      */     //   821: isub
/*      */     //   822: istore 16
/*      */     //   824: iload 16
/*      */     //   826: iflt +19 -> 845
/*      */     //   829: aload_1
/*      */     //   830: iload 16
/*      */     //   832: baload
/*      */     //   833: ifne +12 -> 845
/*      */     //   836: iinc 11 255
/*      */     //   839: iinc 16 255
/*      */     //   842: goto -18 -> 824
/*      */     //   845: iload 11
/*      */     //   847: bipush 19
/*      */     //   849: if_icmple +104 -> 953
/*      */     //   852: bipush 20
/*      */     //   854: istore 16
/*      */     //   856: bipush 19
/*      */     //   858: istore 11
/*      */     //   860: aload_1
/*      */     //   861: iload 16
/*      */     //   863: baload
/*      */     //   864: bipush 50
/*      */     //   866: if_icmplt +87 -> 953
/*      */     //   869: iinc 16 255
/*      */     //   872: aload_1
/*      */     //   873: iload 16
/*      */     //   875: dup2
/*      */     //   876: baload
/*      */     //   877: iconst_1
/*      */     //   878: iadd
/*      */     //   879: i2b
/*      */     //   880: bastore
/*      */     //   881: aload_1
/*      */     //   882: iload 16
/*      */     //   884: baload
/*      */     //   885: bipush 100
/*      */     //   887: if_icmpne +39 -> 926
/*      */     //   890: iload 16
/*      */     //   892: ifne +14 -> 906
/*      */     //   895: iinc 15 1
/*      */     //   898: aload_1
/*      */     //   899: iload 16
/*      */     //   901: iconst_1
/*      */     //   902: bastore
/*      */     //   903: goto +23 -> 926
/*      */     //   906: aload_1
/*      */     //   907: iload 16
/*      */     //   909: iconst_0
/*      */     //   910: bastore
/*      */     //   911: iinc 16 255
/*      */     //   914: aload_1
/*      */     //   915: iload 16
/*      */     //   917: dup2
/*      */     //   918: baload
/*      */     //   919: iconst_1
/*      */     //   920: iadd
/*      */     //   921: i2b
/*      */     //   922: bastore
/*      */     //   923: goto -42 -> 881
/*      */     //   926: iload 11
/*      */     //   928: iconst_1
/*      */     //   929: isub
/*      */     //   930: istore 16
/*      */     //   932: iload 16
/*      */     //   934: iflt +19 -> 953
/*      */     //   937: aload_1
/*      */     //   938: iload 16
/*      */     //   940: baload
/*      */     //   941: ifne +12 -> 953
/*      */     //   944: iinc 11 255
/*      */     //   947: iinc 16 255
/*      */     //   950: goto -18 -> 932
/*      */     //   953: iload 15
/*      */     //   955: bipush 62
/*      */     //   957: if_icmple +15 -> 972
/*      */     //   960: new 33	java/sql/SQLException
/*      */     //   963: dup
/*      */     //   964: iconst_3
/*      */     //   965: invokestatic 55	oracle/core/lmx/CoreException:getMessage	(B)Ljava/lang/String;
/*      */     //   968: invokespecial 35	java/sql/SQLException:<init>	(Ljava/lang/String;)V
/*      */     //   971: athrow
/*      */     //   972: iload 11
/*      */     //   974: iconst_1
/*      */     //   975: iadd
/*      */     //   976: newarray byte
/*      */     //   978: astore 17
/*      */     //   980: aload 17
/*      */     //   982: iconst_0
/*      */     //   983: iload 15
/*      */     //   985: i2b
/*      */     //   986: bastore
/*      */     //   987: aload_1
/*      */     //   988: iconst_0
/*      */     //   989: aload 17
/*      */     //   991: iconst_1
/*      */     //   992: iload 11
/*      */     //   994: invokestatic 132	java/lang/System:arraycopy	(Ljava/lang/Object;ILjava/lang/Object;II)V
/*      */     //   997: aload 17
/*      */     //   999: iload 14
/*      */     //   1001: invokestatic 133	oracle/sql/NUMBER:_toLnxFmt	([BZ)[B
/*      */     //   1004: areturn } 
/*      */   public static byte[] toBytes(BigDecimal paramBigDecimal) throws SQLException { // Byte code:
/*      */     //   0: aload_0
/*      */     //   1: ifnonnull +19 -> 20
/*      */     //   4: aconst_null
/*      */     //   5: bipush 68
/*      */     //   7: ldc 115
/*      */     //   9: invokestatic 116	oracle/jdbc/driver/DatabaseError:createSqlException	(Loracle/jdbc/internal/OracleConnection;ILjava/lang/Object;)Ljava/sql/SQLException;
/*      */     //   12: astore_1
/*      */     //   13: aload_1
/*      */     //   14: invokevirtual 117	java/sql/SQLException:fillInStackTrace	()Ljava/lang/Throwable;
/*      */     //   17: pop
/*      */     //   18: aload_1
/*      */     //   19: athrow
/*      */     //   20: bipush 66
/*      */     //   22: newarray byte
/*      */     //   24: astore_1
/*      */     //   25: bipush 54
/*      */     //   27: newarray long
/*      */     //   29: astore_2
/*      */     //   30: bipush 22
/*      */     //   32: newarray long
/*      */     //   34: astore_3
/*      */     //   35: bipush 21
/*      */     //   37: istore 4
/*      */     //   39: iconst_0
/*      */     //   40: istore 5
/*      */     //   42: bipush 21
/*      */     //   44: istore 7
/*      */     //   46: iconst_0
/*      */     //   47: istore 11
/*      */     //   49: iconst_0
/*      */     //   50: istore 14
/*      */     //   52: aload_0
/*      */     //   53: invokevirtual 134	java/math/BigDecimal:abs	()Ljava/math/BigDecimal;
/*      */     //   56: astore 18
/*      */     //   58: iconst_0
/*      */     //   59: istore 20
/*      */     //   61: aload_0
/*      */     //   62: invokevirtual 135	java/math/BigDecimal:signum	()I
/*      */     //   65: ifne +7 -> 72
/*      */     //   68: invokestatic 1	oracle/sql/NUMBER:_makeZero	()[B
/*      */     //   71: areturn
/*      */     //   72: aload_0
/*      */     //   73: invokevirtual 135	java/math/BigDecimal:signum	()I
/*      */     //   76: iconst_m1
/*      */     //   77: if_icmpne +7 -> 84
/*      */     //   80: iconst_0
/*      */     //   81: goto +4 -> 85
/*      */     //   84: iconst_1
/*      */     //   85: istore 13
/*      */     //   87: aload_0
/*      */     //   88: invokevirtual 136	java/math/BigDecimal:scale	()I
/*      */     //   91: istore 16
/*      */     //   93: iload 16
/*      */     //   95: ifge +12 -> 107
/*      */     //   98: aload_0
/*      */     //   99: iconst_0
/*      */     //   100: invokevirtual 91	java/math/BigDecimal:setScale	(I)Ljava/math/BigDecimal;
/*      */     //   103: astore_0
/*      */     //   104: iconst_0
/*      */     //   105: istore 16
/*      */     //   107: aload 18
/*      */     //   109: getstatic 137	oracle/sql/NUMBER:BIGDEC_ONE	Ljava/math/BigDecimal;
/*      */     //   112: invokevirtual 138	java/math/BigDecimal:compareTo	(Ljava/math/BigDecimal;)I
/*      */     //   115: istore 19
/*      */     //   117: iconst_0
/*      */     //   118: istore 21
/*      */     //   120: iload 19
/*      */     //   122: iconst_m1
/*      */     //   123: if_icmpne +34 -> 157
/*      */     //   126: iinc 21 1
/*      */     //   129: aload 18
/*      */     //   131: iload 21
/*      */     //   133: invokevirtual 90	java/math/BigDecimal:movePointRight	(I)Ljava/math/BigDecimal;
/*      */     //   136: astore 22
/*      */     //   138: aload 22
/*      */     //   140: getstatic 137	oracle/sql/NUMBER:BIGDEC_ONE	Ljava/math/BigDecimal;
/*      */     //   143: invokevirtual 138	java/math/BigDecimal:compareTo	(Ljava/math/BigDecimal;)I
/*      */     //   146: iflt -20 -> 126
/*      */     //   149: iload 21
/*      */     //   151: ineg
/*      */     //   152: istore 20
/*      */     //   154: goto +30 -> 184
/*      */     //   157: iinc 21 1
/*      */     //   160: aload 18
/*      */     //   162: iload 21
/*      */     //   164: invokevirtual 139	java/math/BigDecimal:movePointLeft	(I)Ljava/math/BigDecimal;
/*      */     //   167: astore 22
/*      */     //   169: aload 22
/*      */     //   171: getstatic 137	oracle/sql/NUMBER:BIGDEC_ONE	Ljava/math/BigDecimal;
/*      */     //   174: invokevirtual 138	java/math/BigDecimal:compareTo	(Ljava/math/BigDecimal;)I
/*      */     //   177: ifge -20 -> 157
/*      */     //   180: iload 21
/*      */     //   182: istore 20
/*      */     //   184: aload 18
/*      */     //   186: iload 16
/*      */     //   188: invokevirtual 90	java/math/BigDecimal:movePointRight	(I)Ljava/math/BigDecimal;
/*      */     //   191: invokevirtual 140	java/math/BigDecimal:toBigInteger	()Ljava/math/BigInteger;
/*      */     //   194: invokevirtual 120	java/math/BigInteger:toByteArray	()[B
/*      */     //   197: astore 12
/*      */     //   199: aload 12
/*      */     //   201: arraylength
/*      */     //   202: bipush 54
/*      */     //   204: if_icmple +15 -> 219
/*      */     //   207: new 33	java/sql/SQLException
/*      */     //   210: dup
/*      */     //   211: iconst_3
/*      */     //   212: invokestatic 55	oracle/core/lmx/CoreException:getMessage	(B)Ljava/lang/String;
/*      */     //   215: invokespecial 35	java/sql/SQLException:<init>	(Ljava/lang/String;)V
/*      */     //   218: athrow
/*      */     //   219: iconst_0
/*      */     //   220: istore 15
/*      */     //   222: iload 15
/*      */     //   224: aload 12
/*      */     //   226: arraylength
/*      */     //   227: if_icmpge +44 -> 271
/*      */     //   230: aload 12
/*      */     //   232: iload 15
/*      */     //   234: baload
/*      */     //   235: ifge +20 -> 255
/*      */     //   238: aload_2
/*      */     //   239: iload 15
/*      */     //   241: aload 12
/*      */     //   243: iload 15
/*      */     //   245: baload
/*      */     //   246: sipush 256
/*      */     //   249: iadd
/*      */     //   250: i2l
/*      */     //   251: lastore
/*      */     //   252: goto +13 -> 265
/*      */     //   255: aload_2
/*      */     //   256: iload 15
/*      */     //   258: aload 12
/*      */     //   260: iload 15
/*      */     //   262: baload
/*      */     //   263: i2l
/*      */     //   264: lastore
/*      */     //   265: iinc 15 1
/*      */     //   268: goto -46 -> 222
/*      */     //   271: aload 12
/*      */     //   273: arraylength
/*      */     //   274: istore 6
/*      */     //   276: iload 6
/*      */     //   278: iconst_3
/*      */     //   279: irem
/*      */     //   280: lookupswitch	default:+80->360, 1:+59->339, 2:+28->308
/*      */     //   309: iload 4
/*      */     //   311: aload_2
/*      */     //   312: iload 5
/*      */     //   314: laload
/*      */     //   315: bipush 8
/*      */     //   317: lshl
/*      */     //   318: aload_2
/*      */     //   319: iload 5
/*      */     //   321: iconst_1
/*      */     //   322: iadd
/*      */     //   323: laload
/*      */     //   324: ladd
/*      */     //   325: lastore
/*      */     //   326: iload 5
/*      */     //   328: iconst_2
/*      */     //   329: iadd
/*      */     //   330: i2b
/*      */     //   331: istore 5
/*      */     //   333: iinc 6 254
/*      */     //   336: goto +104 -> 440
/*      */     //   339: aload_3
/*      */     //   340: iload 4
/*      */     //   342: aload_2
/*      */     //   343: iload 5
/*      */     //   345: laload
/*      */     //   346: lastore
/*      */     //   347: iload 5
/*      */     //   349: iconst_1
/*      */     //   350: iadd
/*      */     //   351: i2b
/*      */     //   352: istore 5
/*      */     //   354: iinc 6 255
/*      */     //   357: goto +83 -> 440
/*      */     //   360: aload_2
/*      */     //   361: iload 5
/*      */     //   363: laload
/*      */     //   364: bipush 16
/*      */     //   366: lshl
/*      */     //   367: aload_2
/*      */     //   368: iload 5
/*      */     //   370: iconst_1
/*      */     //   371: iadd
/*      */     //   372: laload
/*      */     //   373: bipush 8
/*      */     //   375: lshl
/*      */     //   376: ladd
/*      */     //   377: aload_2
/*      */     //   378: iload 5
/*      */     //   380: iconst_2
/*      */     //   381: iadd
/*      */     //   382: laload
/*      */     //   383: ladd
/*      */     //   384: lstore 8
/*      */     //   386: aload_3
/*      */     //   387: iload 4
/*      */     //   389: lload 8
/*      */     //   391: ldc2_w 126
/*      */     //   394: lrem
/*      */     //   395: lastore
/*      */     //   396: aload_3
/*      */     //   397: iload 4
/*      */     //   399: iconst_1
/*      */     //   400: isub
/*      */     //   401: lload 8
/*      */     //   403: ldc2_w 126
/*      */     //   406: ldiv
/*      */     //   407: lastore
/*      */     //   408: iload 7
/*      */     //   410: aload_3
/*      */     //   411: iload 4
/*      */     //   413: iconst_1
/*      */     //   414: isub
/*      */     //   415: laload
/*      */     //   416: lconst_0
/*      */     //   417: lcmp
/*      */     //   418: ifeq +7 -> 425
/*      */     //   421: iconst_1
/*      */     //   422: goto +4 -> 426
/*      */     //   425: iconst_0
/*      */     //   426: isub
/*      */     //   427: i2b
/*      */     //   428: istore 7
/*      */     //   430: iload 5
/*      */     //   432: iconst_3
/*      */     //   433: iadd
/*      */     //   434: i2b
/*      */     //   435: istore 5
/*      */     //   437: iinc 6 253
/*      */     //   440: iload 6
/*      */     //   442: ifeq +197 -> 639
/*      */     //   445: aload_2
/*      */     //   446: iload 5
/*      */     //   448: laload
/*      */     //   449: iconst_4
/*      */     //   450: lshl
/*      */     //   451: aload_2
/*      */     //   452: iload 5
/*      */     //   454: iconst_1
/*      */     //   455: iadd
/*      */     //   456: laload
/*      */     //   457: iconst_4
/*      */     //   458: lshr
/*      */     //   459: ladd
/*      */     //   460: lstore 8
/*      */     //   462: bipush 21
/*      */     //   464: istore 4
/*      */     //   466: iload 4
/*      */     //   468: iload 7
/*      */     //   470: if_icmplt +43 -> 513
/*      */     //   473: lload 8
/*      */     //   475: aload_3
/*      */     //   476: iload 4
/*      */     //   478: laload
/*      */     //   479: bipush 12
/*      */     //   481: lshl
/*      */     //   482: ladd
/*      */     //   483: lstore 8
/*      */     //   485: aload_3
/*      */     //   486: iload 4
/*      */     //   488: lload 8
/*      */     //   490: ldc2_w 126
/*      */     //   493: lrem
/*      */     //   494: lastore
/*      */     //   495: lload 8
/*      */     //   497: ldc2_w 126
/*      */     //   500: ldiv
/*      */     //   501: lstore 8
/*      */     //   503: iload 4
/*      */     //   505: iconst_1
/*      */     //   506: isub
/*      */     //   507: i2b
/*      */     //   508: istore 4
/*      */     //   510: goto -44 -> 466
/*      */     //   513: lload 8
/*      */     //   515: lconst_0
/*      */     //   516: lcmp
/*      */     //   517: ifeq +16 -> 533
/*      */     //   520: iload 7
/*      */     //   522: iconst_1
/*      */     //   523: isub
/*      */     //   524: i2b
/*      */     //   525: istore 7
/*      */     //   527: aload_3
/*      */     //   528: iload 7
/*      */     //   530: lload 8
/*      */     //   532: lastore
/*      */     //   533: aload_2
/*      */     //   534: iload 5
/*      */     //   536: iconst_1
/*      */     //   537: iadd
/*      */     //   538: laload
/*      */     //   539: ldc2_w 128
/*      */     //   542: land
/*      */     //   543: bipush 8
/*      */     //   545: lshl
/*      */     //   546: aload_2
/*      */     //   547: iload 5
/*      */     //   549: iconst_2
/*      */     //   550: iadd
/*      */     //   551: laload
/*      */     //   552: ladd
/*      */     //   553: lstore 8
/*      */     //   555: bipush 21
/*      */     //   557: istore 4
/*      */     //   559: iload 4
/*      */     //   561: iload 7
/*      */     //   563: if_icmplt +43 -> 606
/*      */     //   566: lload 8
/*      */     //   568: aload_3
/*      */     //   569: iload 4
/*      */     //   571: laload
/*      */     //   572: bipush 12
/*      */     //   574: lshl
/*      */     //   575: ladd
/*      */     //   576: lstore 8
/*      */     //   578: aload_3
/*      */     //   579: iload 4
/*      */     //   581: lload 8
/*      */     //   583: ldc2_w 126
/*      */     //   586: lrem
/*      */     //   587: lastore
/*      */     //   588: lload 8
/*      */     //   590: ldc2_w 126
/*      */     //   593: ldiv
/*      */     //   594: lstore 8
/*      */     //   596: iload 4
/*      */     //   598: iconst_1
/*      */     //   599: isub
/*      */     //   600: i2b
/*      */     //   601: istore 4
/*      */     //   603: goto -44 -> 559
/*      */     //   606: lload 8
/*      */     //   608: lconst_0
/*      */     //   609: lcmp
/*      */     //   610: ifeq +16 -> 626
/*      */     //   613: iload 7
/*      */     //   615: iconst_1
/*      */     //   616: isub
/*      */     //   617: i2b
/*      */     //   618: istore 7
/*      */     //   620: aload_3
/*      */     //   621: iload 7
/*      */     //   623: lload 8
/*      */     //   625: lastore
/*      */     //   626: iload 5
/*      */     //   628: iconst_3
/*      */     //   629: iadd
/*      */     //   630: i2b
/*      */     //   631: istore 5
/*      */     //   633: iinc 6 253
/*      */     //   636: goto -196 -> 440
/*      */     //   639: aload_1
/*      */     //   640: iload 11
/*      */     //   642: aload_3
/*      */     //   643: iload 7
/*      */     //   645: laload
/*      */     //   646: ldc2_w 78
/*      */     //   649: ldiv
/*      */     //   650: l2i
/*      */     //   651: i2b
/*      */     //   652: dup_x2
/*      */     //   653: bastore
/*      */     //   654: ifeq +56 -> 710
/*      */     //   657: iconst_3
/*      */     //   658: bipush 21
/*      */     //   660: iload 7
/*      */     //   662: isub
/*      */     //   663: imul
/*      */     //   664: iconst_3
/*      */     //   665: iadd
/*      */     //   666: istore 10
/*      */     //   668: aload_1
/*      */     //   669: iload 11
/*      */     //   671: iconst_1
/*      */     //   672: iadd
/*      */     //   673: aload_3
/*      */     //   674: iload 7
/*      */     //   676: laload
/*      */     //   677: ldc2_w 78
/*      */     //   680: lrem
/*      */     //   681: ldc2_w 130
/*      */     //   684: ldiv
/*      */     //   685: l2i
/*      */     //   686: i2b
/*      */     //   687: bastore
/*      */     //   688: aload_1
/*      */     //   689: iload 11
/*      */     //   691: iconst_2
/*      */     //   692: iadd
/*      */     //   693: aload_3
/*      */     //   694: iload 7
/*      */     //   696: laload
/*      */     //   697: ldc2_w 130
/*      */     //   700: lrem
/*      */     //   701: l2i
/*      */     //   702: i2b
/*      */     //   703: bastore
/*      */     //   704: iinc 11 3
/*      */     //   707: goto +82 -> 789
/*      */     //   710: aload_1
/*      */     //   711: iload 11
/*      */     //   713: aload_3
/*      */     //   714: iload 7
/*      */     //   716: laload
/*      */     //   717: ldc2_w 78
/*      */     //   720: lrem
/*      */     //   721: ldc2_w 130
/*      */     //   724: ldiv
/*      */     //   725: l2i
/*      */     //   726: i2b
/*      */     //   727: dup_x2
/*      */     //   728: bastore
/*      */     //   729: ifeq +36 -> 765
/*      */     //   732: iconst_3
/*      */     //   733: bipush 21
/*      */     //   735: iload 7
/*      */     //   737: isub
/*      */     //   738: imul
/*      */     //   739: iconst_2
/*      */     //   740: iadd
/*      */     //   741: istore 10
/*      */     //   743: aload_1
/*      */     //   744: iload 11
/*      */     //   746: iconst_1
/*      */     //   747: iadd
/*      */     //   748: aload_3
/*      */     //   749: iload 7
/*      */     //   751: laload
/*      */     //   752: ldc2_w 130
/*      */     //   755: lrem
/*      */     //   756: l2i
/*      */     //   757: i2b
/*      */     //   758: bastore
/*      */     //   759: iinc 11 2
/*      */     //   762: goto +27 -> 789
/*      */     //   765: aload_1
/*      */     //   766: iload 11
/*      */     //   768: aload_3
/*      */     //   769: iload 7
/*      */     //   771: laload
/*      */     //   772: l2i
/*      */     //   773: i2b
/*      */     //   774: bastore
/*      */     //   775: iconst_3
/*      */     //   776: bipush 21
/*      */     //   778: iload 7
/*      */     //   780: isub
/*      */     //   781: imul
/*      */     //   782: iconst_1
/*      */     //   783: iadd
/*      */     //   784: istore 10
/*      */     //   786: iinc 11 1
/*      */     //   789: iload 7
/*      */     //   791: iconst_1
/*      */     //   792: iadd
/*      */     //   793: i2b
/*      */     //   794: istore 4
/*      */     //   796: iload 4
/*      */     //   798: bipush 21
/*      */     //   800: if_icmpgt +66 -> 866
/*      */     //   803: aload_1
/*      */     //   804: iload 11
/*      */     //   806: aload_3
/*      */     //   807: iload 4
/*      */     //   809: laload
/*      */     //   810: ldc2_w 78
/*      */     //   813: ldiv
/*      */     //   814: l2i
/*      */     //   815: i2b
/*      */     //   816: bastore
/*      */     //   817: aload_1
/*      */     //   818: iload 11
/*      */     //   820: iconst_1
/*      */     //   821: iadd
/*      */     //   822: aload_3
/*      */     //   823: iload 4
/*      */     //   825: laload
/*      */     //   826: ldc2_w 78
/*      */     //   829: lrem
/*      */     //   830: ldc2_w 130
/*      */     //   833: ldiv
/*      */     //   834: l2i
/*      */     //   835: i2b
/*      */     //   836: bastore
/*      */     //   837: aload_1
/*      */     //   838: iload 11
/*      */     //   840: iconst_2
/*      */     //   841: iadd
/*      */     //   842: aload_3
/*      */     //   843: iload 4
/*      */     //   845: laload
/*      */     //   846: ldc2_w 130
/*      */     //   849: lrem
/*      */     //   850: l2i
/*      */     //   851: i2b
/*      */     //   852: bastore
/*      */     //   853: iinc 11 3
/*      */     //   856: iload 4
/*      */     //   858: iconst_1
/*      */     //   859: iadd
/*      */     //   860: i2b
/*      */     //   861: istore 4
/*      */     //   863: goto -67 -> 796
/*      */     //   866: iload 11
/*      */     //   868: iconst_1
/*      */     //   869: isub
/*      */     //   870: istore 15
/*      */     //   872: iload 15
/*      */     //   874: iflt +19 -> 893
/*      */     //   877: aload_1
/*      */     //   878: iload 15
/*      */     //   880: baload
/*      */     //   881: ifne +12 -> 893
/*      */     //   884: iinc 10 255
/*      */     //   887: iinc 15 255
/*      */     //   890: goto -18 -> 872
/*      */     //   893: iload 16
/*      */     //   895: ifle +201 -> 1096
/*      */     //   898: iload 16
/*      */     //   900: iconst_1
/*      */     //   901: iand
/*      */     //   902: ifeq +194 -> 1096
/*      */     //   905: iload 10
/*      */     //   907: istore 23
/*      */     //   909: iload 23
/*      */     //   911: iconst_1
/*      */     //   912: iadd
/*      */     //   913: newarray byte
/*      */     //   915: astore 24
/*      */     //   917: aload_1
/*      */     //   918: iconst_0
/*      */     //   919: baload
/*      */     //   920: bipush 9
/*      */     //   922: if_icmpgt +79 -> 1001
/*      */     //   925: iconst_0
/*      */     //   926: istore 15
/*      */     //   928: iload 15
/*      */     //   930: iload 23
/*      */     //   932: iconst_1
/*      */     //   933: isub
/*      */     //   934: if_icmpge +35 -> 969
/*      */     //   937: aload 24
/*      */     //   939: iload 15
/*      */     //   941: aload_1
/*      */     //   942: iload 15
/*      */     //   944: baload
/*      */     //   945: bipush 10
/*      */     //   947: irem
/*      */     //   948: bipush 10
/*      */     //   950: imul
/*      */     //   951: aload_1
/*      */     //   952: iload 15
/*      */     //   954: iconst_1
/*      */     //   955: iadd
/*      */     //   956: baload
/*      */     //   957: bipush 10
/*      */     //   959: idiv
/*      */     //   960: iadd
/*      */     //   961: i2b
/*      */     //   962: bastore
/*      */     //   963: iinc 15 1
/*      */     //   966: goto -38 -> 928
/*      */     //   969: aload 24
/*      */     //   971: iload 15
/*      */     //   973: aload_1
/*      */     //   974: iload 15
/*      */     //   976: baload
/*      */     //   977: bipush 10
/*      */     //   979: irem
/*      */     //   980: bipush 10
/*      */     //   982: imul
/*      */     //   983: i2b
/*      */     //   984: bastore
/*      */     //   985: aload 24
/*      */     //   987: iload 23
/*      */     //   989: iconst_1
/*      */     //   990: isub
/*      */     //   991: baload
/*      */     //   992: ifne +94 -> 1086
/*      */     //   995: iinc 10 255
/*      */     //   998: goto +88 -> 1086
/*      */     //   1001: aload 24
/*      */     //   1003: iload 23
/*      */     //   1005: aload_1
/*      */     //   1006: iload 23
/*      */     //   1008: iconst_1
/*      */     //   1009: isub
/*      */     //   1010: baload
/*      */     //   1011: bipush 10
/*      */     //   1013: irem
/*      */     //   1014: bipush 10
/*      */     //   1016: imul
/*      */     //   1017: i2b
/*      */     //   1018: bastore
/*      */     //   1019: iload 23
/*      */     //   1021: iconst_1
/*      */     //   1022: isub
/*      */     //   1023: istore 15
/*      */     //   1025: iload 15
/*      */     //   1027: ifle +35 -> 1062
/*      */     //   1030: aload 24
/*      */     //   1032: iload 15
/*      */     //   1034: aload_1
/*      */     //   1035: iload 15
/*      */     //   1037: baload
/*      */     //   1038: bipush 10
/*      */     //   1040: idiv
/*      */     //   1041: aload_1
/*      */     //   1042: iload 15
/*      */     //   1044: iconst_1
/*      */     //   1045: isub
/*      */     //   1046: baload
/*      */     //   1047: bipush 10
/*      */     //   1049: irem
/*      */     //   1050: bipush 10
/*      */     //   1052: imul
/*      */     //   1053: iadd
/*      */     //   1054: i2b
/*      */     //   1055: bastore
/*      */     //   1056: iinc 15 255
/*      */     //   1059: goto -34 -> 1025
/*      */     //   1062: aload 24
/*      */     //   1064: iload 15
/*      */     //   1066: aload_1
/*      */     //   1067: iload 15
/*      */     //   1069: baload
/*      */     //   1070: bipush 10
/*      */     //   1072: idiv
/*      */     //   1073: i2b
/*      */     //   1074: bastore
/*      */     //   1075: aload 24
/*      */     //   1077: iload 23
/*      */     //   1079: baload
/*      */     //   1080: ifle +6 -> 1086
/*      */     //   1083: iinc 10 1
/*      */     //   1086: aload 24
/*      */     //   1088: iconst_0
/*      */     //   1089: aload_1
/*      */     //   1090: iconst_0
/*      */     //   1091: iload 10
/*      */     //   1093: invokestatic 132	java/lang/System:arraycopy	(Ljava/lang/Object;ILjava/lang/Object;II)V
/*      */     //   1096: iload 10
/*      */     //   1098: bipush 20
/*      */     //   1100: if_icmple +104 -> 1204
/*      */     //   1103: bipush 20
/*      */     //   1105: istore 15
/*      */     //   1107: bipush 20
/*      */     //   1109: istore 10
/*      */     //   1111: aload_1
/*      */     //   1112: iload 15
/*      */     //   1114: baload
/*      */     //   1115: bipush 50
/*      */     //   1117: if_icmplt +60 -> 1177
/*      */     //   1120: iinc 15 255
/*      */     //   1123: aload_1
/*      */     //   1124: iload 15
/*      */     //   1126: dup2
/*      */     //   1127: baload
/*      */     //   1128: iconst_1
/*      */     //   1129: iadd
/*      */     //   1130: i2b
/*      */     //   1131: bastore
/*      */     //   1132: aload_1
/*      */     //   1133: iload 15
/*      */     //   1135: baload
/*      */     //   1136: bipush 100
/*      */     //   1138: if_icmpne +39 -> 1177
/*      */     //   1141: iload 15
/*      */     //   1143: ifne +14 -> 1157
/*      */     //   1146: iinc 20 1
/*      */     //   1149: aload_1
/*      */     //   1150: iload 15
/*      */     //   1152: iconst_1
/*      */     //   1153: bastore
/*      */     //   1154: goto +23 -> 1177
/*      */     //   1157: aload_1
/*      */     //   1158: iload 15
/*      */     //   1160: iconst_0
/*      */     //   1161: bastore
/*      */     //   1162: iinc 15 255
/*      */     //   1165: aload_1
/*      */     //   1166: iload 15
/*      */     //   1168: dup2
/*      */     //   1169: baload
/*      */     //   1170: iconst_1
/*      */     //   1171: iadd
/*      */     //   1172: i2b
/*      */     //   1173: bastore
/*      */     //   1174: goto -42 -> 1132
/*      */     //   1177: iload 10
/*      */     //   1179: iconst_1
/*      */     //   1180: isub
/*      */     //   1181: istore 15
/*      */     //   1183: iload 15
/*      */     //   1185: iflt +19 -> 1204
/*      */     //   1188: aload_1
/*      */     //   1189: iload 15
/*      */     //   1191: baload
/*      */     //   1192: ifne +12 -> 1204
/*      */     //   1195: iinc 10 255
/*      */     //   1198: iinc 15 255
/*      */     //   1201: goto -18 -> 1183
/*      */     //   1204: iload 20
/*      */     //   1206: ifgt +37 -> 1243
/*      */     //   1209: aload_1
/*      */     //   1210: iconst_0
/*      */     //   1211: baload
/*      */     //   1212: bipush 10
/*      */     //   1214: if_icmpge +17 -> 1231
/*      */     //   1217: iconst_2
/*      */     //   1218: iload 20
/*      */     //   1220: isub
/*      */     //   1221: ineg
/*      */     //   1222: iconst_2
/*      */     //   1223: idiv
/*      */     //   1224: iconst_1
/*      */     //   1225: iadd
/*      */     //   1226: istore 14
/*      */     //   1228: goto +23 -> 1251
/*      */     //   1231: iconst_2
/*      */     //   1232: iload 20
/*      */     //   1234: isub
/*      */     //   1235: ineg
/*      */     //   1236: iconst_2
/*      */     //   1237: idiv
/*      */     //   1238: istore 14
/*      */     //   1240: goto +11 -> 1251
/*      */     //   1243: iload 20
/*      */     //   1245: iconst_1
/*      */     //   1246: isub
/*      */     //   1247: iconst_2
/*      */     //   1248: idiv
/*      */     //   1249: istore 14
/*      */     //   1251: iload 14
/*      */     //   1253: bipush 62
/*      */     //   1255: if_icmple +15 -> 1270
/*      */     //   1258: new 33	java/sql/SQLException
/*      */     //   1261: dup
/*      */     //   1262: iconst_3
/*      */     //   1263: invokestatic 55	oracle/core/lmx/CoreException:getMessage	(B)Ljava/lang/String;
/*      */     //   1266: invokespecial 35	java/sql/SQLException:<init>	(Ljava/lang/String;)V
/*      */     //   1269: athrow
/*      */     //   1270: iload 14
/*      */     //   1272: bipush 191
/*      */     //   1274: if_icmpgt +15 -> 1289
/*      */     //   1277: new 33	java/sql/SQLException
/*      */     //   1280: dup
/*      */     //   1281: iconst_2
/*      */     //   1282: invokestatic 55	oracle/core/lmx/CoreException:getMessage	(B)Ljava/lang/String;
/*      */     //   1285: invokespecial 35	java/sql/SQLException:<init>	(Ljava/lang/String;)V
/*      */     //   1288: athrow
/*      */     //   1289: iload 10
/*      */     //   1291: iconst_1
/*      */     //   1292: iadd
/*      */     //   1293: newarray byte
/*      */     //   1295: astore 23
/*      */     //   1297: aload 23
/*      */     //   1299: iconst_0
/*      */     //   1300: iload 14
/*      */     //   1302: i2b
/*      */     //   1303: bastore
/*      */     //   1304: aload_1
/*      */     //   1305: iconst_0
/*      */     //   1306: aload 23
/*      */     //   1308: iconst_1
/*      */     //   1309: iload 10
/*      */     //   1311: invokestatic 132	java/lang/System:arraycopy	(Ljava/lang/Object;ILjava/lang/Object;II)V
/*      */     //   1314: aload 23
/*      */     //   1316: iload 13
/*      */     //   1318: invokestatic 133	oracle/sql/NUMBER:_toLnxFmt	([BZ)[B
/*      */     //   1321: areturn } 
/*      */   public static byte[] toBytes(String paramString, int paramInt) throws SQLException { // Byte code:
/*      */     //   0: aload_0
/*      */     //   1: ifnull +10 -> 11
/*      */     //   4: aload_0
/*      */     //   5: invokevirtual 141	java/lang/String:length	()I
/*      */     //   8: ifne +17 -> 25
/*      */     //   11: aconst_null
/*      */     //   12: bipush 68
/*      */     //   14: invokestatic 142	oracle/jdbc/driver/DatabaseError:createSqlException	(Loracle/jdbc/internal/OracleConnection;I)Ljava/sql/SQLException;
/*      */     //   17: astore_2
/*      */     //   18: aload_2
/*      */     //   19: invokevirtual 117	java/sql/SQLException:fillInStackTrace	()Ljava/lang/Throwable;
/*      */     //   22: pop
/*      */     //   23: aload_2
/*      */     //   24: athrow
/*      */     //   25: iconst_0
/*      */     //   26: istore_2
/*      */     //   27: iconst_0
/*      */     //   28: istore_3
/*      */     //   29: bipush 22
/*      */     //   31: newarray byte
/*      */     //   33: astore 5
/*      */     //   35: iconst_0
/*      */     //   36: istore 7
/*      */     //   38: iconst_1
/*      */     //   39: istore 9
/*      */     //   41: iconst_0
/*      */     //   42: istore 10
/*      */     //   44: iconst_0
/*      */     //   45: istore 11
/*      */     //   47: iconst_0
/*      */     //   48: istore 12
/*      */     //   50: iconst_0
/*      */     //   51: istore 14
/*      */     //   53: iconst_0
/*      */     //   54: istore 15
/*      */     //   56: bipush 40
/*      */     //   58: istore 16
/*      */     //   60: iconst_0
/*      */     //   61: istore 17
/*      */     //   63: iconst_0
/*      */     //   64: istore 18
/*      */     //   66: iconst_0
/*      */     //   67: istore 19
/*      */     //   69: iconst_0
/*      */     //   70: istore 21
/*      */     //   72: aload_0
/*      */     //   73: ldc 143
/*      */     //   75: invokevirtual 144	java/lang/String:indexOf	(Ljava/lang/String;)I
/*      */     //   78: dup
/*      */     //   79: istore 22
/*      */     //   81: iconst_m1
/*      */     //   82: if_icmpne +16 -> 98
/*      */     //   85: aload_0
/*      */     //   86: ldc 145
/*      */     //   88: invokevirtual 144	java/lang/String:indexOf	(Ljava/lang/String;)I
/*      */     //   91: dup
/*      */     //   92: istore 22
/*      */     //   94: iconst_m1
/*      */     //   95: if_icmpeq +386 -> 481
/*      */     //   98: new 146	java/lang/StringBuffer
/*      */     //   101: dup
/*      */     //   102: aload_0
/*      */     //   103: invokevirtual 141	java/lang/String:length	()I
/*      */     //   106: iconst_5
/*      */     //   107: iadd
/*      */     //   108: invokespecial 147	java/lang/StringBuffer:<init>	(I)V
/*      */     //   111: astore 23
/*      */     //   113: iconst_0
/*      */     //   114: istore 24
/*      */     //   116: aconst_null
/*      */     //   117: astore 25
/*      */     //   119: aload_0
/*      */     //   120: iconst_0
/*      */     //   121: invokevirtual 148	java/lang/String:charAt	(I)C
/*      */     //   124: bipush 45
/*      */     //   126: if_icmpne +7 -> 133
/*      */     //   129: iconst_1
/*      */     //   130: goto +4 -> 134
/*      */     //   133: iconst_0
/*      */     //   134: istore 26
/*      */     //   136: aload_0
/*      */     //   137: iload 22
/*      */     //   139: iconst_1
/*      */     //   140: iadd
/*      */     //   141: invokevirtual 149	java/lang/String:substring	(I)Ljava/lang/String;
/*      */     //   144: astore 27
/*      */     //   146: aload_0
/*      */     //   147: iload 26
/*      */     //   149: ifeq +7 -> 156
/*      */     //   152: iconst_1
/*      */     //   153: goto +4 -> 157
/*      */     //   156: iconst_0
/*      */     //   157: iload 22
/*      */     //   159: invokevirtual 150	java/lang/String:substring	(II)Ljava/lang/String;
/*      */     //   162: astore 28
/*      */     //   164: new 24	java/math/BigDecimal
/*      */     //   167: dup
/*      */     //   168: aload 28
/*      */     //   170: invokespecial 151	java/math/BigDecimal:<init>	(Ljava/lang/String;)V
/*      */     //   173: astore 25
/*      */     //   175: aload 27
/*      */     //   177: iconst_0
/*      */     //   178: invokevirtual 148	java/lang/String:charAt	(I)C
/*      */     //   181: bipush 45
/*      */     //   183: if_icmpne +7 -> 190
/*      */     //   186: iconst_1
/*      */     //   187: goto +4 -> 191
/*      */     //   190: iconst_0
/*      */     //   191: istore 29
/*      */     //   193: iload 29
/*      */     //   195: ifne +14 -> 209
/*      */     //   198: aload 27
/*      */     //   200: iconst_0
/*      */     //   201: invokevirtual 148	java/lang/String:charAt	(I)C
/*      */     //   204: bipush 43
/*      */     //   206: if_icmpne +11 -> 217
/*      */     //   209: aload 27
/*      */     //   211: iconst_1
/*      */     //   212: invokevirtual 149	java/lang/String:substring	(I)Ljava/lang/String;
/*      */     //   215: astore 27
/*      */     //   217: aload 27
/*      */     //   219: invokestatic 152	java/lang/Integer:parseInt	(Ljava/lang/String;)I
/*      */     //   222: istore 24
/*      */     //   224: aload 25
/*      */     //   226: invokevirtual 153	java/math/BigDecimal:toString	()Ljava/lang/String;
/*      */     //   229: astore 30
/*      */     //   231: aload 30
/*      */     //   233: ldc 154
/*      */     //   235: invokevirtual 144	java/lang/String:indexOf	(Ljava/lang/String;)I
/*      */     //   238: istore 31
/*      */     //   240: aload 30
/*      */     //   242: invokevirtual 141	java/lang/String:length	()I
/*      */     //   245: istore 32
/*      */     //   247: iload 32
/*      */     //   249: istore 33
/*      */     //   251: iload 31
/*      */     //   253: iconst_m1
/*      */     //   254: if_icmpeq +66 -> 320
/*      */     //   257: new 155	java/lang/StringBuilder
/*      */     //   260: dup
/*      */     //   261: invokespecial 156	java/lang/StringBuilder:<init>	()V
/*      */     //   264: aload 30
/*      */     //   266: iconst_0
/*      */     //   267: iload 31
/*      */     //   269: invokevirtual 150	java/lang/String:substring	(II)Ljava/lang/String;
/*      */     //   272: invokevirtual 157	java/lang/StringBuilder:append	(Ljava/lang/String;)Ljava/lang/StringBuilder;
/*      */     //   275: aload 30
/*      */     //   277: iload 31
/*      */     //   279: iconst_1
/*      */     //   280: iadd
/*      */     //   281: invokevirtual 149	java/lang/String:substring	(I)Ljava/lang/String;
/*      */     //   284: invokevirtual 157	java/lang/StringBuilder:append	(Ljava/lang/String;)Ljava/lang/StringBuilder;
/*      */     //   287: invokevirtual 158	java/lang/StringBuilder:toString	()Ljava/lang/String;
/*      */     //   290: astore 30
/*      */     //   292: iinc 32 255
/*      */     //   295: iload 29
/*      */     //   297: ifeq +13 -> 310
/*      */     //   300: iload 24
/*      */     //   302: iload 31
/*      */     //   304: isub
/*      */     //   305: istore 24
/*      */     //   307: goto +35 -> 342
/*      */     //   310: iinc 24 1
/*      */     //   313: iload 24
/*      */     //   315: istore 33
/*      */     //   317: goto +25 -> 342
/*      */     //   320: iload 29
/*      */     //   322: ifeq +13 -> 335
/*      */     //   325: iload 24
/*      */     //   327: iload 32
/*      */     //   329: isub
/*      */     //   330: istore 24
/*      */     //   332: goto +10 -> 342
/*      */     //   335: iinc 24 1
/*      */     //   338: iload 24
/*      */     //   340: istore 33
/*      */     //   342: iload 26
/*      */     //   344: ifeq +11 -> 355
/*      */     //   347: aload 23
/*      */     //   349: ldc 159
/*      */     //   351: invokevirtual 160	java/lang/StringBuffer:append	(Ljava/lang/String;)Ljava/lang/StringBuffer;
/*      */     //   354: pop
/*      */     //   355: iload 29
/*      */     //   357: ifeq +46 -> 403
/*      */     //   360: aload 23
/*      */     //   362: ldc 161
/*      */     //   364: invokevirtual 160	java/lang/StringBuffer:append	(Ljava/lang/String;)Ljava/lang/StringBuffer;
/*      */     //   367: pop
/*      */     //   368: iconst_0
/*      */     //   369: istore 34
/*      */     //   371: iload 34
/*      */     //   373: iload 24
/*      */     //   375: if_icmpge +17 -> 392
/*      */     //   378: aload 23
/*      */     //   380: ldc 92
/*      */     //   382: invokevirtual 160	java/lang/StringBuffer:append	(Ljava/lang/String;)Ljava/lang/StringBuffer;
/*      */     //   385: pop
/*      */     //   386: iinc 34 1
/*      */     //   389: goto -18 -> 371
/*      */     //   392: aload 23
/*      */     //   394: aload 30
/*      */     //   396: invokevirtual 160	java/lang/StringBuffer:append	(Ljava/lang/String;)Ljava/lang/StringBuffer;
/*      */     //   399: pop
/*      */     //   400: goto +75 -> 475
/*      */     //   403: iload 24
/*      */     //   405: iload 32
/*      */     //   407: if_icmple +8 -> 415
/*      */     //   410: iload 24
/*      */     //   412: goto +5 -> 417
/*      */     //   415: iload 32
/*      */     //   417: istore 34
/*      */     //   419: iconst_0
/*      */     //   420: istore 35
/*      */     //   422: iload 35
/*      */     //   424: iload 34
/*      */     //   426: if_icmpge +49 -> 475
/*      */     //   429: iload 33
/*      */     //   431: iload 35
/*      */     //   433: if_icmpne +11 -> 444
/*      */     //   436: aload 23
/*      */     //   438: ldc 154
/*      */     //   440: invokevirtual 160	java/lang/StringBuffer:append	(Ljava/lang/String;)Ljava/lang/StringBuffer;
/*      */     //   443: pop
/*      */     //   444: aload 23
/*      */     //   446: iload 32
/*      */     //   448: iload 35
/*      */     //   450: if_icmple +13 -> 463
/*      */     //   453: aload 30
/*      */     //   455: iload 35
/*      */     //   457: invokevirtual 148	java/lang/String:charAt	(I)C
/*      */     //   460: goto +5 -> 465
/*      */     //   463: bipush 48
/*      */     //   465: invokevirtual 162	java/lang/StringBuffer:append	(C)Ljava/lang/StringBuffer;
/*      */     //   468: pop
/*      */     //   469: iinc 35 1
/*      */     //   472: goto -50 -> 422
/*      */     //   475: aload 23
/*      */     //   477: invokevirtual 163	java/lang/StringBuffer:toString	()Ljava/lang/String;
/*      */     //   480: astore_0
/*      */     //   481: aload_0
/*      */     //   482: invokevirtual 164	java/lang/String:trim	()Ljava/lang/String;
/*      */     //   485: astore_0
/*      */     //   486: aload_0
/*      */     //   487: invokevirtual 141	java/lang/String:length	()I
/*      */     //   490: istore 20
/*      */     //   492: aload_0
/*      */     //   493: iconst_0
/*      */     //   494: invokevirtual 148	java/lang/String:charAt	(I)C
/*      */     //   497: bipush 45
/*      */     //   499: if_icmpne +12 -> 511
/*      */     //   502: iinc 20 255
/*      */     //   505: iconst_0
/*      */     //   506: istore 9
/*      */     //   508: iconst_1
/*      */     //   509: istore 19
/*      */     //   511: iload 20
/*      */     //   513: istore_2
/*      */     //   514: iload 20
/*      */     //   516: newarray char
/*      */     //   518: astore 23
/*      */     //   520: aload_0
/*      */     //   521: iload 19
/*      */     //   523: iload 20
/*      */     //   525: iload 19
/*      */     //   527: iadd
/*      */     //   528: aload 23
/*      */     //   530: iconst_0
/*      */     //   531: invokevirtual 165	java/lang/String:getChars	(II[CI)V
/*      */     //   534: iconst_0
/*      */     //   535: istore 4
/*      */     //   537: iload 4
/*      */     //   539: iload 20
/*      */     //   541: if_icmpge +25 -> 566
/*      */     //   544: aload 23
/*      */     //   546: iload 4
/*      */     //   548: caload
/*      */     //   549: bipush 46
/*      */     //   551: if_icmpne +9 -> 560
/*      */     //   554: iconst_1
/*      */     //   555: istore 11
/*      */     //   557: goto +9 -> 566
/*      */     //   560: iinc 4 1
/*      */     //   563: goto -26 -> 537
/*      */     //   566: iload 11
/*      */     //   568: ifne +5 -> 573
/*      */     //   571: iconst_0
/*      */     //   572: istore_1
/*      */     //   573: iload_3
/*      */     //   574: iload_2
/*      */     //   575: if_icmpge +27 -> 602
/*      */     //   578: aload 23
/*      */     //   580: iload_3
/*      */     //   581: caload
/*      */     //   582: bipush 48
/*      */     //   584: if_icmpne +18 -> 602
/*      */     //   587: iinc 3 1
/*      */     //   590: iload 11
/*      */     //   592: iconst_1
/*      */     //   593: if_icmpne -20 -> 573
/*      */     //   596: iinc 21 1
/*      */     //   599: goto -26 -> 573
/*      */     //   602: iload_3
/*      */     //   603: iload_2
/*      */     //   604: if_icmpne +7 -> 611
/*      */     //   607: invokestatic 1	oracle/sql/NUMBER:_makeZero	()[B
/*      */     //   610: areturn
/*      */     //   611: iload 20
/*      */     //   613: iconst_2
/*      */     //   614: if_icmplt +232 -> 846
/*      */     //   617: aload 23
/*      */     //   619: iload_3
/*      */     //   620: caload
/*      */     //   621: bipush 46
/*      */     //   623: if_icmpne +223 -> 846
/*      */     //   626: iinc 3 1
/*      */     //   629: iload_2
/*      */     //   630: ifle +20 -> 650
/*      */     //   633: aload 23
/*      */     //   635: iload_2
/*      */     //   636: iconst_1
/*      */     //   637: isub
/*      */     //   638: caload
/*      */     //   639: bipush 48
/*      */     //   641: if_icmpne +9 -> 650
/*      */     //   644: iinc 2 255
/*      */     //   647: goto -18 -> 629
/*      */     //   650: iload_3
/*      */     //   651: iload_2
/*      */     //   652: if_icmpne +7 -> 659
/*      */     //   655: invokestatic 1	oracle/sql/NUMBER:_makeZero	()[B
/*      */     //   658: areturn
/*      */     //   659: iinc 12 255
/*      */     //   662: iload_3
/*      */     //   663: iload_2
/*      */     //   664: iconst_1
/*      */     //   665: isub
/*      */     //   666: if_icmpge +35 -> 701
/*      */     //   669: aload 23
/*      */     //   671: iload_3
/*      */     //   672: caload
/*      */     //   673: bipush 48
/*      */     //   675: if_icmpne +26 -> 701
/*      */     //   678: aload 23
/*      */     //   680: iload_3
/*      */     //   681: iconst_1
/*      */     //   682: iadd
/*      */     //   683: caload
/*      */     //   684: bipush 48
/*      */     //   686: if_icmpne +15 -> 701
/*      */     //   689: iinc 12 255
/*      */     //   692: iinc 15 2
/*      */     //   695: iinc 3 2
/*      */     //   698: goto -36 -> 662
/*      */     //   701: iload 12
/*      */     //   703: bipush 191
/*      */     //   705: if_icmpge +15 -> 720
/*      */     //   708: new 33	java/sql/SQLException
/*      */     //   711: dup
/*      */     //   712: iconst_2
/*      */     //   713: invokestatic 55	oracle/core/lmx/CoreException:getMessage	(B)Ljava/lang/String;
/*      */     //   716: invokespecial 35	java/sql/SQLException:<init>	(Ljava/lang/String;)V
/*      */     //   719: athrow
/*      */     //   720: iload_2
/*      */     //   721: iload_3
/*      */     //   722: isub
/*      */     //   723: iload 16
/*      */     //   725: if_icmple +36 -> 761
/*      */     //   728: iload_3
/*      */     //   729: iload 16
/*      */     //   731: iadd
/*      */     //   732: istore 6
/*      */     //   734: iload 15
/*      */     //   736: ifle +10 -> 746
/*      */     //   739: iload 6
/*      */     //   741: iload 15
/*      */     //   743: iadd
/*      */     //   744: istore 6
/*      */     //   746: iload 6
/*      */     //   748: iload_2
/*      */     //   749: if_icmpgt +6 -> 755
/*      */     //   752: iload 6
/*      */     //   754: istore_2
/*      */     //   755: iload_2
/*      */     //   756: istore 17
/*      */     //   758: iconst_1
/*      */     //   759: istore 10
/*      */     //   761: iload_2
/*      */     //   762: iload_3
/*      */     //   763: isub
/*      */     //   764: iconst_1
/*      */     //   765: ishr
/*      */     //   766: istore 7
/*      */     //   768: iload_2
/*      */     //   769: iload_3
/*      */     //   770: isub
/*      */     //   771: iconst_2
/*      */     //   772: irem
/*      */     //   773: ifeq +34 -> 807
/*      */     //   776: aload 5
/*      */     //   778: iload 7
/*      */     //   780: new 27	java/lang/String
/*      */     //   783: dup
/*      */     //   784: aload 23
/*      */     //   786: iload_2
/*      */     //   787: iconst_1
/*      */     //   788: isub
/*      */     //   789: iconst_1
/*      */     //   790: invokespecial 97	java/lang/String:<init>	([CII)V
/*      */     //   793: invokestatic 152	java/lang/Integer:parseInt	(Ljava/lang/String;)I
/*      */     //   796: bipush 10
/*      */     //   798: imul
/*      */     //   799: i2b
/*      */     //   800: bastore
/*      */     //   801: iinc 14 1
/*      */     //   804: iinc 2 255
/*      */     //   807: iload_2
/*      */     //   808: iload_3
/*      */     //   809: if_icmple +510 -> 1319
/*      */     //   812: iinc 7 255
/*      */     //   815: aload 5
/*      */     //   817: iload 7
/*      */     //   819: new 27	java/lang/String
/*      */     //   822: dup
/*      */     //   823: aload 23
/*      */     //   825: iload_2
/*      */     //   826: iconst_2
/*      */     //   827: isub
/*      */     //   828: iconst_2
/*      */     //   829: invokespecial 97	java/lang/String:<init>	([CII)V
/*      */     //   832: invokestatic 152	java/lang/Integer:parseInt	(Ljava/lang/String;)I
/*      */     //   835: i2b
/*      */     //   836: bastore
/*      */     //   837: iinc 2 254
/*      */     //   840: iinc 14 1
/*      */     //   843: goto -36 -> 807
/*      */     //   846: iload_1
/*      */     //   847: ifle +27 -> 874
/*      */     //   850: iload_2
/*      */     //   851: ifle +23 -> 874
/*      */     //   854: aload 23
/*      */     //   856: iload_2
/*      */     //   857: iconst_1
/*      */     //   858: isub
/*      */     //   859: caload
/*      */     //   860: bipush 48
/*      */     //   862: if_icmpne +12 -> 874
/*      */     //   865: iinc 2 255
/*      */     //   868: iinc 1 255
/*      */     //   871: goto -25 -> 846
/*      */     //   874: iload_1
/*      */     //   875: ifne +67 -> 942
/*      */     //   878: iload_2
/*      */     //   879: iconst_1
/*      */     //   880: if_icmple +62 -> 942
/*      */     //   883: aload 23
/*      */     //   885: iload_2
/*      */     //   886: iconst_1
/*      */     //   887: isub
/*      */     //   888: caload
/*      */     //   889: bipush 46
/*      */     //   891: if_icmpne +6 -> 897
/*      */     //   894: iinc 2 255
/*      */     //   897: iload_3
/*      */     //   898: iload_2
/*      */     //   899: if_icmpne +7 -> 906
/*      */     //   902: invokestatic 1	oracle/sql/NUMBER:_makeZero	()[B
/*      */     //   905: areturn
/*      */     //   906: iload_2
/*      */     //   907: iconst_1
/*      */     //   908: if_icmple +34 -> 942
/*      */     //   911: aload 23
/*      */     //   913: iload_2
/*      */     //   914: iconst_2
/*      */     //   915: isub
/*      */     //   916: caload
/*      */     //   917: bipush 48
/*      */     //   919: if_icmpne +23 -> 942
/*      */     //   922: aload 23
/*      */     //   924: iload_2
/*      */     //   925: iconst_1
/*      */     //   926: isub
/*      */     //   927: caload
/*      */     //   928: bipush 48
/*      */     //   930: if_icmpne +12 -> 942
/*      */     //   933: iinc 2 254
/*      */     //   936: iinc 12 1
/*      */     //   939: goto -33 -> 906
/*      */     //   942: iload 12
/*      */     //   944: bipush 62
/*      */     //   946: if_icmple +15 -> 961
/*      */     //   949: new 33	java/sql/SQLException
/*      */     //   952: dup
/*      */     //   953: iconst_3
/*      */     //   954: invokestatic 55	oracle/core/lmx/CoreException:getMessage	(B)Ljava/lang/String;
/*      */     //   957: invokespecial 35	java/sql/SQLException:<init>	(Ljava/lang/String;)V
/*      */     //   960: athrow
/*      */     //   961: iload_2
/*      */     //   962: iload_3
/*      */     //   963: isub
/*      */     //   964: iload 11
/*      */     //   966: ifeq +7 -> 973
/*      */     //   969: iconst_1
/*      */     //   970: goto +4 -> 974
/*      */     //   973: iconst_0
/*      */     //   974: isub
/*      */     //   975: iload 16
/*      */     //   977: if_icmple +44 -> 1021
/*      */     //   980: iload 16
/*      */     //   982: iload 11
/*      */     //   984: ifeq +7 -> 991
/*      */     //   987: iconst_1
/*      */     //   988: goto +4 -> 992
/*      */     //   991: iconst_0
/*      */     //   992: iadd
/*      */     //   993: istore 6
/*      */     //   995: iload_2
/*      */     //   996: iload 6
/*      */     //   998: isub
/*      */     //   999: istore 24
/*      */     //   1001: iload 6
/*      */     //   1003: istore_2
/*      */     //   1004: iload_1
/*      */     //   1005: iload 24
/*      */     //   1007: isub
/*      */     //   1008: istore_1
/*      */     //   1009: iload_1
/*      */     //   1010: ifge +5 -> 1015
/*      */     //   1013: iconst_0
/*      */     //   1014: istore_1
/*      */     //   1015: iconst_1
/*      */     //   1016: istore 10
/*      */     //   1018: iload_2
/*      */     //   1019: istore 17
/*      */     //   1021: iload_1
/*      */     //   1022: ifne +9 -> 1031
/*      */     //   1025: iload_2
/*      */     //   1026: iload_3
/*      */     //   1027: isub
/*      */     //   1028: goto +8 -> 1036
/*      */     //   1031: iload_2
/*      */     //   1032: iload_1
/*      */     //   1033: isub
/*      */     //   1034: iconst_1
/*      */     //   1035: isub
/*      */     //   1036: istore 13
/*      */     //   1038: iload 21
/*      */     //   1040: ifle +10 -> 1050
/*      */     //   1043: iload 13
/*      */     //   1045: iload 21
/*      */     //   1047: isub
/*      */     //   1048: istore 13
/*      */     //   1050: iload 13
/*      */     //   1052: iconst_2
/*      */     //   1053: irem
/*      */     //   1054: ifeq +48 -> 1102
/*      */     //   1057: new 27	java/lang/String
/*      */     //   1060: dup
/*      */     //   1061: aload 23
/*      */     //   1063: iload_3
/*      */     //   1064: iconst_1
/*      */     //   1065: invokespecial 97	java/lang/String:<init>	([CII)V
/*      */     //   1068: invokestatic 152	java/lang/Integer:parseInt	(Ljava/lang/String;)I
/*      */     //   1071: istore 18
/*      */     //   1073: iinc 3 1
/*      */     //   1076: iinc 13 255
/*      */     //   1079: iload_2
/*      */     //   1080: iconst_1
/*      */     //   1081: isub
/*      */     //   1082: iload 16
/*      */     //   1084: if_icmpne +40 -> 1124
/*      */     //   1087: iinc 1 255
/*      */     //   1090: iinc 2 255
/*      */     //   1093: iconst_1
/*      */     //   1094: istore 10
/*      */     //   1096: iload_2
/*      */     //   1097: istore 17
/*      */     //   1099: goto +25 -> 1124
/*      */     //   1102: new 27	java/lang/String
/*      */     //   1105: dup
/*      */     //   1106: aload 23
/*      */     //   1108: iload_3
/*      */     //   1109: iconst_2
/*      */     //   1110: invokespecial 97	java/lang/String:<init>	([CII)V
/*      */     //   1113: invokestatic 152	java/lang/Integer:parseInt	(Ljava/lang/String;)I
/*      */     //   1116: istore 18
/*      */     //   1118: iinc 3 2
/*      */     //   1121: iinc 13 254
/*      */     //   1124: aload 5
/*      */     //   1126: iload 7
/*      */     //   1128: iload 18
/*      */     //   1130: i2b
/*      */     //   1131: bastore
/*      */     //   1132: iinc 7 1
/*      */     //   1135: iinc 14 1
/*      */     //   1138: iload 13
/*      */     //   1140: ifle +41 -> 1181
/*      */     //   1143: aload 5
/*      */     //   1145: iload 7
/*      */     //   1147: new 27	java/lang/String
/*      */     //   1150: dup
/*      */     //   1151: aload 23
/*      */     //   1153: iload_3
/*      */     //   1154: iconst_2
/*      */     //   1155: invokespecial 97	java/lang/String:<init>	([CII)V
/*      */     //   1158: invokestatic 152	java/lang/Integer:parseInt	(Ljava/lang/String;)I
/*      */     //   1161: i2b
/*      */     //   1162: bastore
/*      */     //   1163: iinc 7 1
/*      */     //   1166: iinc 3 2
/*      */     //   1169: iinc 12 1
/*      */     //   1172: iinc 13 254
/*      */     //   1175: iinc 14 1
/*      */     //   1178: goto -40 -> 1138
/*      */     //   1181: iload_3
/*      */     //   1182: iload_2
/*      */     //   1183: if_icmpge +95 -> 1278
/*      */     //   1186: iload_1
/*      */     //   1187: iconst_2
/*      */     //   1188: irem
/*      */     //   1189: ifeq +45 -> 1234
/*      */     //   1192: iload 7
/*      */     //   1194: iload_1
/*      */     //   1195: iconst_2
/*      */     //   1196: idiv
/*      */     //   1197: iadd
/*      */     //   1198: istore 7
/*      */     //   1200: aload 5
/*      */     //   1202: iload 7
/*      */     //   1204: new 27	java/lang/String
/*      */     //   1207: dup
/*      */     //   1208: aload 23
/*      */     //   1210: iload_2
/*      */     //   1211: iconst_1
/*      */     //   1212: isub
/*      */     //   1213: iconst_1
/*      */     //   1214: invokespecial 97	java/lang/String:<init>	([CII)V
/*      */     //   1217: invokestatic 152	java/lang/Integer:parseInt	(Ljava/lang/String;)I
/*      */     //   1220: bipush 10
/*      */     //   1222: imul
/*      */     //   1223: i2b
/*      */     //   1224: bastore
/*      */     //   1225: iinc 2 255
/*      */     //   1228: iinc 1 255
/*      */     //   1231: goto +41 -> 1272
/*      */     //   1234: iload 7
/*      */     //   1236: iload_1
/*      */     //   1237: iconst_2
/*      */     //   1238: idiv
/*      */     //   1239: iconst_1
/*      */     //   1240: isub
/*      */     //   1241: iadd
/*      */     //   1242: istore 7
/*      */     //   1244: aload 5
/*      */     //   1246: iload 7
/*      */     //   1248: new 27	java/lang/String
/*      */     //   1251: dup
/*      */     //   1252: aload 23
/*      */     //   1254: iload_2
/*      */     //   1255: iconst_2
/*      */     //   1256: isub
/*      */     //   1257: iconst_2
/*      */     //   1258: invokespecial 97	java/lang/String:<init>	([CII)V
/*      */     //   1261: invokestatic 152	java/lang/Integer:parseInt	(Ljava/lang/String;)I
/*      */     //   1264: i2b
/*      */     //   1265: bastore
/*      */     //   1266: iinc 2 254
/*      */     //   1269: iinc 1 254
/*      */     //   1272: iinc 14 1
/*      */     //   1275: iinc 7 255
/*      */     //   1278: iload_1
/*      */     //   1279: ifle +40 -> 1319
/*      */     //   1282: aload 5
/*      */     //   1284: iload 7
/*      */     //   1286: new 27	java/lang/String
/*      */     //   1289: dup
/*      */     //   1290: aload 23
/*      */     //   1292: iload_2
/*      */     //   1293: iconst_2
/*      */     //   1294: isub
/*      */     //   1295: iconst_2
/*      */     //   1296: invokespecial 97	java/lang/String:<init>	([CII)V
/*      */     //   1299: invokestatic 152	java/lang/Integer:parseInt	(Ljava/lang/String;)I
/*      */     //   1302: i2b
/*      */     //   1303: bastore
/*      */     //   1304: iinc 7 255
/*      */     //   1307: iinc 2 254
/*      */     //   1310: iinc 1 254
/*      */     //   1313: iinc 14 1
/*      */     //   1316: goto -38 -> 1278
/*      */     //   1319: iload 10
/*      */     //   1321: ifeq +120 -> 1441
/*      */     //   1324: iload 14
/*      */     //   1326: istore 24
/*      */     //   1328: new 27	java/lang/String
/*      */     //   1331: dup
/*      */     //   1332: aload 23
/*      */     //   1334: iload 17
/*      */     //   1336: iconst_1
/*      */     //   1337: invokespecial 97	java/lang/String:<init>	([CII)V
/*      */     //   1340: invokestatic 152	java/lang/Integer:parseInt	(Ljava/lang/String;)I
/*      */     //   1343: istore 18
/*      */     //   1345: iload 18
/*      */     //   1347: iconst_5
/*      */     //   1348: if_icmplt +93 -> 1441
/*      */     //   1351: iinc 24 255
/*      */     //   1354: aload 5
/*      */     //   1356: iload 24
/*      */     //   1358: dup2
/*      */     //   1359: baload
/*      */     //   1360: iconst_1
/*      */     //   1361: iadd
/*      */     //   1362: i2b
/*      */     //   1363: bastore
/*      */     //   1364: aload 5
/*      */     //   1366: iload 24
/*      */     //   1368: baload
/*      */     //   1369: bipush 100
/*      */     //   1371: if_icmpne +42 -> 1413
/*      */     //   1374: iload 24
/*      */     //   1376: ifne +15 -> 1391
/*      */     //   1379: iinc 12 1
/*      */     //   1382: aload 5
/*      */     //   1384: iload 24
/*      */     //   1386: iconst_1
/*      */     //   1387: bastore
/*      */     //   1388: goto +25 -> 1413
/*      */     //   1391: aload 5
/*      */     //   1393: iload 24
/*      */     //   1395: iconst_0
/*      */     //   1396: bastore
/*      */     //   1397: iinc 24 255
/*      */     //   1400: aload 5
/*      */     //   1402: iload 24
/*      */     //   1404: dup2
/*      */     //   1405: baload
/*      */     //   1406: iconst_1
/*      */     //   1407: iadd
/*      */     //   1408: i2b
/*      */     //   1409: bastore
/*      */     //   1410: goto -46 -> 1364
/*      */     //   1413: iload 14
/*      */     //   1415: iconst_1
/*      */     //   1416: isub
/*      */     //   1417: istore 4
/*      */     //   1419: iload 4
/*      */     //   1421: iflt +20 -> 1441
/*      */     //   1424: aload 5
/*      */     //   1426: iload 4
/*      */     //   1428: baload
/*      */     //   1429: ifne +12 -> 1441
/*      */     //   1432: iinc 14 255
/*      */     //   1435: iinc 4 255
/*      */     //   1438: goto -19 -> 1419
/*      */     //   1441: iload 14
/*      */     //   1443: iconst_1
/*      */     //   1444: iadd
/*      */     //   1445: newarray byte
/*      */     //   1447: astore 24
/*      */     //   1449: aload 24
/*      */     //   1451: iconst_0
/*      */     //   1452: iload 12
/*      */     //   1454: i2b
/*      */     //   1455: bastore
/*      */     //   1456: aload 5
/*      */     //   1458: iconst_0
/*      */     //   1459: aload 24
/*      */     //   1461: iconst_1
/*      */     //   1462: iload 14
/*      */     //   1464: invokestatic 132	java/lang/System:arraycopy	(Ljava/lang/Object;ILjava/lang/Object;II)V
/*      */     //   1467: aload 24
/*      */     //   1469: iload 9
/*      */     //   1471: invokestatic 133	oracle/sql/NUMBER:_toLnxFmt	([BZ)[B
/*      */     //   1474: areturn } 
/* 2050 */   public static byte[] toBytes(boolean paramBoolean) { if (paramBoolean) {
/* 2051 */       return toBytes(1L);
/*      */     }
/* 2053 */     return toBytes(0L);
/*      */   }
/*      */ 
/*      */   public byte[] toBytes()
/*      */   {
/* 2071 */     return getBytes();
/*      */   }
/*      */ 
/*      */   public double doubleValue()
/*      */   {
/* 2081 */     return toDouble(shareBytes());
/*      */   }
/*      */ 
/*      */   public float floatValue()
/*      */   {
/* 2091 */     return toFloat(shareBytes());
/*      */   }
/*      */ 
/*      */   public long longValue()
/*      */     throws SQLException
/*      */   {
/* 2103 */     return toLong(shareBytes());
/*      */   }
/*      */ 
/*      */   public int intValue()
/*      */     throws SQLException
/*      */   {
/* 2115 */     return toInt(shareBytes());
/*      */   }
/*      */ 
/*      */   public short shortValue()
/*      */     throws SQLException
/*      */   {
/* 2127 */     return toShort(shareBytes());
/*      */   }
/*      */ 
/*      */   public byte byteValue()
/*      */     throws SQLException
/*      */   {
/* 2139 */     return toByte(shareBytes());
/*      */   }
/*      */ 
/*      */   public BigInteger bigIntegerValue()
/*      */     throws SQLException
/*      */   {
/* 2150 */     return toBigInteger(shareBytes());
/*      */   }
/*      */ 
/*      */   public BigDecimal bigDecimalValue()
/*      */     throws SQLException
/*      */   {
/* 2163 */     return toBigDecimal(shareBytes());
/*      */   }
/*      */ 
/*      */   public String stringValue()
/*      */   {
/* 2173 */     return toString(shareBytes());
/*      */   }
/*      */ 
/*      */   public boolean booleanValue()
/*      */   {
/* 2183 */     return toBoolean(shareBytes());
/*      */   }
/*      */ 
/*      */   public Object toJdbc()
/*      */     throws SQLException
/*      */   {
/*      */     try
/*      */     {
/* 2197 */       return bigDecimalValue();
/*      */     }
/*      */     catch (SQLException localSQLException)
/*      */     {
/* 2201 */       return new SQLException(localSQLException.getMessage());
/*      */     }
/*      */   }
/*      */ 
/*      */   public Object makeJdbcArray(int paramInt)
/*      */   {
/* 2215 */     BigDecimal[] arrayOfBigDecimal = new BigDecimal[paramInt];
/*      */ 
/* 2217 */     return arrayOfBigDecimal;
/*      */   }
/*      */ 
/*      */   public boolean isConvertibleTo(Class paramClass)
/*      */   {
/* 2229 */     String str = paramClass.getName();
/*      */ 
/* 2231 */     if ((str.compareTo("java.lang.Integer") == 0) || (str.compareTo("java.lang.Long") == 0) || (str.compareTo("java.lang.Float") == 0) || (str.compareTo("java.lang.Double") == 0) || (str.compareTo("java.math.BigInteger") == 0) || (str.compareTo("java.math.BigDecimal") == 0) || (str.compareTo("java.lang.String") == 0) || (str.compareTo("java.lang.Boolean") == 0) || (str.compareTo("java.lang.Byte") == 0) || (str.compareTo("java.lang.Short") == 0))
/*      */     {
/* 2241 */       return true;
/*      */     }
/*      */ 
/* 2244 */     return false;
/*      */   }
/*      */ 
/*      */   public NUMBER abs()
/*      */     throws SQLException
/*      */   {
/* 2261 */     return new NUMBER(_getLnxLib().lnxabs(shareBytes()));
/*      */   }
/*      */ 
/*      */   public NUMBER acos()
/*      */     throws SQLException
/*      */   {
/* 2273 */     return new NUMBER(_getLnxLib().lnxacos(shareBytes()));
/*      */   }
/*      */ 
/*      */   public NUMBER add(NUMBER paramNUMBER)
/*      */     throws SQLException
/*      */   {
/* 2286 */     return new NUMBER(_getLnxLib().lnxadd(shareBytes(), paramNUMBER.shareBytes()));
/*      */   }
/*      */ 
/*      */   public NUMBER asin()
/*      */     throws SQLException
/*      */   {
/* 2298 */     return new NUMBER(_getLnxLib().lnxasin(shareBytes()));
/*      */   }
/*      */ 
/*      */   public NUMBER atan()
/*      */     throws SQLException
/*      */   {
/* 2311 */     return new NUMBER(_getLnxLib().lnxatan(shareBytes()));
/*      */   }
/*      */ 
/*      */   public NUMBER atan2(NUMBER paramNUMBER)
/*      */     throws SQLException
/*      */   {
/* 2323 */     return new NUMBER(_getLnxLib().lnxatan2(shareBytes(), paramNUMBER.shareBytes()));
/*      */   }
/*      */ 
/*      */   public NUMBER ceil()
/*      */     throws SQLException
/*      */   {
/* 2336 */     return new NUMBER(_getLnxLib().lnxceil(shareBytes()));
/*      */   }
/*      */ 
/*      */   public NUMBER cos()
/*      */     throws SQLException
/*      */   {
/* 2348 */     return new NUMBER(_getLnxLib().lnxcos(shareBytes()));
/*      */   }
/*      */ 
/*      */   public NUMBER cosh()
/*      */     throws SQLException
/*      */   {
/* 2361 */     return new NUMBER(_getLnxLib().lnxcsh(shareBytes()));
/*      */   }
/*      */ 
/*      */   public NUMBER decrement()
/*      */     throws SQLException
/*      */   {
/* 2376 */     return new NUMBER(_getLnxLib().lnxdec(shareBytes()));
/*      */   }
/*      */ 
/*      */   public NUMBER div(NUMBER paramNUMBER)
/*      */     throws SQLException
/*      */   {
/* 2389 */     return new NUMBER(_getLnxLib().lnxdiv(shareBytes(), paramNUMBER.shareBytes()));
/*      */   }
/*      */ 
/*      */   public NUMBER exp()
/*      */     throws SQLException
/*      */   {
/* 2402 */     return new NUMBER(_getLnxLib().lnxexp(shareBytes()));
/*      */   }
/*      */ 
/*      */   public NUMBER floatingPointRound(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 2415 */     return new NUMBER(_getLnxLib().lnxfpr(shareBytes(), paramInt));
/*      */   }
/*      */ 
/*      */   public NUMBER floor()
/*      */     throws SQLException
/*      */   {
/* 2427 */     return new NUMBER(_getLnxLib().lnxflo(shareBytes()));
/*      */   }
/*      */ 
/*      */   public NUMBER increment()
/*      */     throws SQLException
/*      */   {
/* 2442 */     return new NUMBER(_getLnxLib().lnxinc(shareBytes()));
/*      */   }
/*      */ 
/*      */   public NUMBER ln()
/*      */     throws SQLException
/*      */   {
/* 2455 */     return new NUMBER(_getLnxLib().lnxln(shareBytes()));
/*      */   }
/*      */ 
/*      */   public NUMBER log(NUMBER paramNUMBER)
/*      */     throws SQLException
/*      */   {
/* 2468 */     return new NUMBER(_getLnxLib().lnxlog(shareBytes(), paramNUMBER.shareBytes()));
/*      */   }
/*      */ 
/*      */   public NUMBER mod(NUMBER paramNUMBER)
/*      */     throws SQLException
/*      */   {
/* 2482 */     return new NUMBER(_getLnxLib().lnxmod(shareBytes(), paramNUMBER.shareBytes()));
/*      */   }
/*      */ 
/*      */   public NUMBER mul(NUMBER paramNUMBER)
/*      */     throws SQLException
/*      */   {
/* 2494 */     return new NUMBER(_getLnxLib().lnxmul(shareBytes(), paramNUMBER.shareBytes()));
/*      */   }
/*      */ 
/*      */   public NUMBER negate()
/*      */     throws SQLException
/*      */   {
/* 2506 */     return new NUMBER(_getLnxLib().lnxneg(shareBytes()));
/*      */   }
/*      */ 
/*      */   public NUMBER pow(NUMBER paramNUMBER)
/*      */     throws SQLException
/*      */   {
/* 2519 */     return new NUMBER(_getLnxLib().lnxbex(shareBytes(), paramNUMBER.shareBytes()));
/*      */   }
/*      */ 
/*      */   public NUMBER pow(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 2534 */     return new NUMBER(_getLnxLib().lnxpow(shareBytes(), paramInt));
/*      */   }
/*      */ 
/*      */   public NUMBER round(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 2547 */     return new NUMBER(_getLnxLib().lnxrou(shareBytes(), paramInt));
/*      */   }
/*      */ 
/*      */   public NUMBER scale(int paramInt1, int paramInt2, boolean[] paramArrayOfBoolean)
/*      */     throws SQLException
/*      */   {
/* 2569 */     return new NUMBER(_getLnxLib().lnxsca(shareBytes(), paramInt1, paramInt2, paramArrayOfBoolean));
/*      */   }
/*      */ 
/*      */   public NUMBER shift(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 2587 */     return new NUMBER(_getLnxLib().lnxshift(shareBytes(), paramInt));
/*      */   }
/*      */ 
/*      */   public NUMBER sin()
/*      */     throws SQLException
/*      */   {
/* 2598 */     return new NUMBER(_getLnxLib().lnxsin(shareBytes()));
/*      */   }
/*      */ 
/*      */   public NUMBER sinh()
/*      */     throws SQLException
/*      */   {
/* 2609 */     return new NUMBER(_getLnxLib().lnxsnh(shareBytes()));
/*      */   }
/*      */ 
/*      */   public NUMBER sqroot()
/*      */     throws SQLException
/*      */   {
/* 2620 */     return new NUMBER(_getLnxLib().lnxsqr(shareBytes()));
/*      */   }
/*      */ 
/*      */   public NUMBER sub(NUMBER paramNUMBER)
/*      */     throws SQLException
/*      */   {
/* 2631 */     return new NUMBER(_getLnxLib().lnxsub(shareBytes(), paramNUMBER.shareBytes()));
/*      */   }
/*      */ 
/*      */   public NUMBER tan()
/*      */     throws SQLException
/*      */   {
/* 2642 */     return new NUMBER(_getLnxLib().lnxtan(shareBytes()));
/*      */   }
/*      */ 
/*      */   public NUMBER tanh()
/*      */     throws SQLException
/*      */   {
/* 2654 */     return new NUMBER(_getLnxLib().lnxtnh(shareBytes()));
/*      */   }
/*      */ 
/*      */   public NUMBER truncate(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 2667 */     return new NUMBER(_getLnxLib().lnxtru(shareBytes(), paramInt));
/*      */   }
/*      */ 
/*      */   public static NUMBER formattedTextToNumber(String paramString1, String paramString2, String paramString3)
/*      */     throws SQLException
/*      */   {
/* 2690 */     return new NUMBER(_getLnxLib().lnxfcn(paramString1, paramString2, paramString3));
/*      */   }
/*      */ 
/*      */   public static NUMBER textToPrecisionNumber(String paramString1, boolean paramBoolean1, int paramInt1, boolean paramBoolean2, int paramInt2, String paramString2)
/*      */     throws SQLException
/*      */   {
/* 2728 */     return new NUMBER(_getLnxLib().lnxcpn(paramString1, paramBoolean1, paramInt1, paramBoolean2, paramInt2, paramString2));
/*      */   }
/*      */ 
/*      */   public String toFormattedText(String paramString1, String paramString2)
/*      */     throws SQLException
/*      */   {
/* 2751 */     return _getLnxLib().lnxnfn(shareBytes(), paramString1, paramString2);
/*      */   }
/*      */ 
/*      */   public String toText(int paramInt, String paramString)
/*      */     throws SQLException
/*      */   {
/* 2768 */     return _getLnxLib().lnxnuc(shareBytes(), paramInt, paramString);
/*      */   }
/*      */ 
/*      */   public int compareTo(NUMBER paramNUMBER)
/*      */   {
/* 2782 */     return compareBytes(shareBytes(), paramNUMBER.shareBytes());
/*      */   }
/*      */ 
/*      */   public boolean isInf()
/*      */   {
/* 2793 */     return _isInf(shareBytes());
/*      */   }
/*      */ 
/*      */   public boolean isNegInf()
/*      */   {
/* 2803 */     return _isNegInf(shareBytes());
/*      */   }
/*      */ 
/*      */   public boolean isPosInf()
/*      */   {
/* 2813 */     return _isPosInf(shareBytes());
/*      */   }
/*      */ 
/*      */   public boolean isInt()
/*      */   {
/* 2823 */     return _isInt(shareBytes());
/*      */   }
/*      */ 
/*      */   public static boolean isValid(byte[] paramArrayOfByte)
/*      */   {
/* 2836 */     int i = (byte)paramArrayOfByte.length;
/*      */     int j;
/* 2838 */     if (_isPositive(paramArrayOfByte))
/*      */     {
/* 2840 */       if (i == 1) {
/* 2841 */         return _isZero(paramArrayOfByte);
/*      */       }
/*      */ 
/* 2844 */       if ((paramArrayOfByte[0] == -1) && (paramArrayOfByte[1] == 101))
/*      */       {
/* 2846 */         return i == 2;
/*      */       }
/* 2848 */       if (i > 21) {
/* 2849 */         return false;
/*      */       }
/*      */ 
/* 2852 */       if ((paramArrayOfByte[1] < 2) || (paramArrayOfByte[(i - 1)] < 2)) {
/* 2853 */         return false;
/*      */       }
/*      */ 
/* 2856 */       for (k = 1; k < i; k++)
/*      */       {
/* 2858 */         j = paramArrayOfByte[k];
/* 2859 */         if ((j < 1) || (j > 100)) {
/* 2860 */           return false;
/*      */         }
/*      */       }
/* 2863 */       return true;
/*      */     }
/*      */ 
/* 2867 */     if (i < 3) {
/* 2868 */       return _isNegInf(paramArrayOfByte);
/*      */     }
/* 2870 */     if (i > 21) {
/* 2871 */       return false;
/*      */     }
/*      */ 
/* 2874 */     if (paramArrayOfByte[(i - 1)] != 102)
/*      */     {
/* 2876 */       if (i <= 20) {
/* 2877 */         return false;
/*      */       }
/*      */     }
/*      */     else {
/* 2881 */       i = (byte)(i - 1);
/*      */     }
/*      */ 
/* 2885 */     if ((paramArrayOfByte[1] > 100) || (paramArrayOfByte[(i - 1)] > 100)) {
/* 2886 */       return false;
/*      */     }
/*      */ 
/* 2889 */     for (int k = 1; k < i; k++)
/*      */     {
/* 2891 */       j = paramArrayOfByte[k];
/*      */ 
/* 2893 */       if ((j < 2) || (j > 101)) {
/* 2894 */         return false;
/*      */       }
/*      */     }
/* 2897 */     return true;
/*      */   }
/*      */ 
/*      */   public boolean isZero()
/*      */   {
/* 2908 */     return _isZero(shareBytes());
/*      */   }
/*      */ 
/*      */   public static NUMBER e()
/*      */   {
/* 2918 */     return new NUMBER(E);
/*      */   }
/*      */ 
/*      */   public static NUMBER ln10()
/*      */   {
/* 2928 */     return new NUMBER(LN10);
/*      */   }
/*      */ 
/*      */   public static NUMBER negInf()
/*      */   {
/* 2938 */     return new NUMBER(_makeNegInf());
/*      */   }
/*      */ 
/*      */   public static NUMBER pi()
/*      */   {
/* 2948 */     return new NUMBER(PI);
/*      */   }
/*      */ 
/*      */   public static NUMBER posInf()
/*      */   {
/* 2958 */     return new NUMBER(_makePosInf());
/*      */   }
/*      */ 
/*      */   public static NUMBER zero()
/*      */   {
/* 2968 */     return new NUMBER(_makeZero());
/*      */   }
/*      */ 
/*      */   public int sign()
/*      */   {
/* 2979 */     if (_isZero(shareBytes())) {
/* 2980 */       return 0;
/*      */     }
/* 2982 */     return _isPositive(shareBytes()) ? 1 : -1;
/*      */   }
/*      */ 
/*      */   static boolean _isInf(byte[] paramArrayOfByte)
/*      */   {
/* 3134 */     if (((paramArrayOfByte.length == 2) && (paramArrayOfByte[0] == -1) && (paramArrayOfByte[1] == 101)) || ((paramArrayOfByte[0] == 0) && (paramArrayOfByte.length == 1)))
/*      */     {
/* 3138 */       return true;
/*      */     }
/* 3140 */     return false;
/*      */   }
/*      */ 
/*      */   private static boolean _isInt(byte[] paramArrayOfByte)
/*      */   {
/* 3150 */     if (_isZero(paramArrayOfByte)) {
/* 3151 */       return true;
/*      */     }
/* 3153 */     if (_isInf(paramArrayOfByte)) {
/* 3154 */       return false;
/*      */     }
/* 3156 */     byte[] arrayOfByte = _fromLnxFmt(paramArrayOfByte);
/* 3157 */     int i = arrayOfByte[0];
/* 3158 */     int j = (byte)(arrayOfByte.length - 1);
/*      */ 
/* 3160 */     if (j > i + 1) {
/* 3161 */       return false;
/*      */     }
/* 3163 */     return true;
/*      */   }
/*      */ 
/*      */   static boolean _isNegInf(byte[] paramArrayOfByte)
/*      */   {
/* 3172 */     if ((paramArrayOfByte[0] == 0) && (paramArrayOfByte.length == 1)) {
/* 3173 */       return true;
/*      */     }
/* 3175 */     return false;
/*      */   }
/*      */ 
/*      */   static boolean _isPosInf(byte[] paramArrayOfByte)
/*      */   {
/* 3184 */     if ((paramArrayOfByte.length == 2) && (paramArrayOfByte[0] == -1) && (paramArrayOfByte[1] == 101))
/*      */     {
/* 3187 */       return true;
/*      */     }
/* 3189 */     return false;
/*      */   }
/*      */ 
/*      */   static boolean _isPositive(byte[] paramArrayOfByte)
/*      */   {
/* 3198 */     if ((paramArrayOfByte[0] & 0xFFFFFF80) != 0) {
/* 3199 */       return true;
/*      */     }
/* 3201 */     return false;
/*      */   }
/*      */ 
/*      */   static boolean _isZero(byte[] paramArrayOfByte)
/*      */   {
/* 3210 */     if ((paramArrayOfByte[0] == -128) && (paramArrayOfByte.length == 1)) {
/* 3211 */       return true;
/*      */     }
/* 3213 */     return false;
/*      */   }
/*      */ 
/*      */   static byte[] _makePosInf()
/*      */   {
/* 3221 */     byte[] arrayOfByte = new byte[2];
/*      */ 
/* 3224 */     arrayOfByte[0] = -1;
/* 3225 */     arrayOfByte[1] = 101;
/*      */ 
/* 3227 */     return arrayOfByte;
/*      */   }
/*      */ 
/*      */   static byte[] _makeNegInf()
/*      */   {
/* 3235 */     byte[] arrayOfByte = new byte[1];
/*      */ 
/* 3238 */     arrayOfByte[0] = 0;
/*      */ 
/* 3240 */     return arrayOfByte;
/*      */   }
/*      */ 
/*      */   static byte[] _makeZero()
/*      */   {
/* 3248 */     byte[] arrayOfByte = new byte[1];
/*      */ 
/* 3251 */     arrayOfByte[0] = -128;
/*      */ 
/* 3253 */     return arrayOfByte;
/*      */   }
/*      */ 
/*      */   static byte[] _fromLnxFmt(byte[] paramArrayOfByte)
/*      */   {
/* 3264 */     int j = paramArrayOfByte.length;
/*      */     byte[] arrayOfByte;
/* 3269 */     if (_isPositive(paramArrayOfByte))
/*      */     {
/* 3271 */       arrayOfByte = new byte[j];
/* 3272 */       arrayOfByte[0] = ((byte)((paramArrayOfByte[0] & 0xFFFFFF7F) - 65));
/*      */ 
/* 3274 */       for (i = 1; i < j; i++) {
/* 3275 */         arrayOfByte[i] = ((byte)(paramArrayOfByte[i] - 1));
/*      */       }
/*      */     }
/*      */ 
/* 3279 */     if ((j - 1 == 20) && (paramArrayOfByte[(j - 1)] != 102))
/*      */     {
/* 3281 */       arrayOfByte = new byte[j];
/*      */     }
/* 3283 */     else arrayOfByte = new byte[j - 1];
/*      */ 
/* 3285 */     arrayOfByte[0] = ((byte)(((paramArrayOfByte[0] ^ 0xFFFFFFFF) & 0xFFFFFF7F) - 65));
/*      */ 
/* 3287 */     for (int i = 1; i < arrayOfByte.length; i++) {
/* 3288 */       arrayOfByte[i] = ((byte)(101 - paramArrayOfByte[i]));
/*      */     }
/*      */ 
/* 3291 */     return arrayOfByte;
/*      */   }
/*      */ 
/*      */   static byte[] _toLnxFmt(byte[] paramArrayOfByte, boolean paramBoolean)
/*      */   {
/* 3307 */     int j = paramArrayOfByte.length;
/*      */     byte[] arrayOfByte;
/* 3312 */     if (paramBoolean)
/*      */     {
/* 3314 */       arrayOfByte = new byte[j];
/* 3315 */       arrayOfByte[0] = ((byte)(paramArrayOfByte[0] + 128 + 64 + 1));
/*      */ 
/* 3317 */       for (i = 1; i < j; i++) {
/* 3318 */         arrayOfByte[i] = ((byte)(paramArrayOfByte[i] + 1));
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 3324 */     if (j - 1 < 20)
/* 3325 */       arrayOfByte = new byte[j + 1];
/*      */     else {
/* 3327 */       arrayOfByte = new byte[j];
/*      */     }
/* 3329 */     arrayOfByte[0] = ((byte)(paramArrayOfByte[0] + 128 + 64 + 1 ^ 0xFFFFFFFF));
/*      */ 
/* 3331 */     for (int i = 1; i < j; i++) {
/* 3332 */       arrayOfByte[i] = ((byte)(101 - paramArrayOfByte[i]));
/*      */     }
/* 3334 */     if (i <= 20) {
/* 3335 */       arrayOfByte[i] = 102;
/*      */     }
/*      */ 
/* 3338 */     return arrayOfByte;
/*      */   }
/*      */ 
/*      */   private static LnxLib _getLnxLib()
/*      */   {
/* 3348 */     if (_slnxlib == null)
/*      */     {
/*      */       try
/*      */       {
/* 3353 */         if (System.getProperty("oracle.jserver.version") != null)
/*      */         {
/* 3355 */           _slnxlib = new LnxLibServer();
/*      */         }
/*      */         else
/*      */         {
/* 3359 */           _slnxlib = new LnxLibThin();
/*      */         }
/*      */       }
/*      */       catch (SecurityException localSecurityException)
/*      */       {
/* 3364 */         _slnxlib = new LnxLibThin();
/*      */       }
/*      */     }
/*      */ 
/* 3368 */     return _slnxlib;
/*      */   }
/*      */ 
/*      */   private static LnxLib _getThinLib()
/*      */   {
/* 3377 */     if (_thinlib == null)
/*      */     {
/* 3379 */       _thinlib = new LnxLibThin();
/*      */     }
/*      */ 
/* 3382 */     return _thinlib;
/*      */   }
/*      */ 
/*      */   private static int _byteToChars(byte paramByte, char[] paramArrayOfChar, int paramInt)
/*      */   {
/* 3392 */     if (paramByte < 0)
/*      */     {
/* 3394 */       return 0;
/*      */     }
/* 3396 */     if (paramByte < 10)
/*      */     {
/* 3398 */       paramArrayOfChar[paramInt] = ((char)(48 + paramByte));
/* 3399 */       return 1;
/*      */     }
/* 3401 */     if (paramByte < 100)
/*      */     {
/* 3403 */       paramArrayOfChar[paramInt] = ((char)(48 + paramByte / 10));
/* 3404 */       paramArrayOfChar[(paramInt + 1)] = ((char)(48 + paramByte % 10));
/* 3405 */       return 2;
/*      */     }
/*      */ 
/* 3409 */     paramArrayOfChar[paramInt] = '1';
/* 3410 */     paramArrayOfChar[(paramInt + 1)] = ((char)(48 + paramByte / 10 - 10));
/* 3411 */     paramArrayOfChar[(paramInt + 2)] = ((char)(48 + paramByte % 10));
/* 3412 */     return 3;
/*      */   }
/*      */ 
/*      */   private static void _byteTo2Chars(byte paramByte, char[] paramArrayOfChar, int paramInt)
/*      */   {
/* 3421 */     if (paramByte < 0)
/*      */     {
/* 3424 */       paramArrayOfChar[paramInt] = '0';
/* 3425 */       paramArrayOfChar[(paramInt + 1)] = '0';
/*      */     }
/* 3427 */     else if (paramByte < 10)
/*      */     {
/* 3429 */       paramArrayOfChar[paramInt] = '0';
/* 3430 */       paramArrayOfChar[(paramInt + 1)] = ((char)(48 + paramByte));
/*      */     }
/* 3432 */     else if (paramByte < 100)
/*      */     {
/* 3434 */       paramArrayOfChar[paramInt] = ((char)(48 + paramByte / 10));
/* 3435 */       paramArrayOfChar[(paramInt + 1)] = ((char)(48 + paramByte % 10));
/*      */     }
/*      */     else
/*      */     {
/* 3440 */       paramArrayOfChar[paramInt] = '0';
/* 3441 */       paramArrayOfChar[(paramInt + 1)] = '0';
/*      */     }
/*      */   }
/*      */ 
/*      */   private static void _printBytes(byte[] paramArrayOfByte)
/*      */   {
/* 3453 */     int i = paramArrayOfByte.length;
/*      */ 
/* 3455 */     System.out.print(i + ": ");
/*      */ 
/* 3457 */     for (int j = 0; j < i; j++)
/*      */     {
/* 3459 */       System.out.print(paramArrayOfByte[j] + " ");
/*      */     }
/*      */ 
/* 3462 */     System.out.println();
/*      */   }
/*      */ 
/*      */   private byte[] stringToBytes(String paramString)
/*      */     throws SQLException
/*      */   {
/* 3473 */     int i = 0;
/*      */ 
/* 3475 */     paramString = paramString.trim();
/*      */ 
/* 3477 */     if (paramString.indexOf(46) >= 0)
/*      */     {
/* 3479 */       i = paramString.length() - 1 - paramString.indexOf(46);
/*      */     }
/*      */ 
/* 3482 */     return toBytes(paramString, i);
/*      */   }
/*      */ 
/*      */   static
/*      */   {
/*      */     try
/*      */     {
/* 3493 */       drvType = System.getProperty("oracle.jserver.version");
/*      */     }
/*      */     catch (SecurityException localSecurityException)
/*      */     {
/* 3498 */       drvType = null;
/*      */     }
/*      */   }
/*      */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.sql.NUMBER
 * JD-Core Version:    0.6.2
 */