/*      */ package oracle.sql;
/*      */ 
/*      */ import java.util.HashMap;
/*      */ import java.util.Locale;
/*      */ import java.util.Map;
/*      */ 
/*      */ public class LxMetaData
/*      */ {
/*      */   private static final String DEFAULT_ES_ORA_LANGUAGE = "LATIN AMERICAN SPANISH";
/*      */   private static final int WIDTH_SIZE = 8;
/*      */   private static final short WIDTH_MASK = 255;
/*      */   public static final int ST_BADCODESET = 0;
/*  302 */   private static final Locale EN_LOCALE = new Locale("en", "US");
/*      */ 
/*  304 */   private static Map ORACLE_LANG_2_ISO_A2_LANG = null;
/*      */ 
/*  393 */   private static Map ORACLE_TERR_2_ISO_A2_TERR = null;
/*      */ 
/*  532 */   private static Map ORACLE_LANG_2_TERR = null;
/*      */ 
/*  619 */   private static Map ISO_A2_LANG_2_ORACLE_LANG = null;
/*      */ 
/*  701 */   private static Map ISO_LANGUAGE_DEFAULT_TERRITORY = null;
/*      */ 
/*  781 */   private static Map ISO_LOCALE_2_ORACLE_LOCALE = null;
/*      */ 
/*  799 */   private static Map ISO_A2_TERR_2_ORACLE_TERR = null;
/*      */ 
/*  934 */   private static Map CHARSET_RATIO = null;
/*      */ 
/*      */   static Locale getJavaLocale(String paramString1, String paramString2)
/*      */   {
/*   49 */     if (paramString1 == null)
/*      */     {
/*   51 */       return null;
/*      */     }
/*      */ 
/*   54 */     String str1 = paramString1;
/*      */ 
/*   56 */     String str2 = EN_LOCALE.getLanguage();
/*   57 */     if (!"".equals(str1))
/*      */     {
/*   59 */       if (ORACLE_LANG_2_ISO_A2_LANG == null)
/*   60 */         ORACLE_LANG_2_ISO_A2_LANG = getLang2IsoLangMap();
/*   61 */       str2 = (String)ORACLE_LANG_2_ISO_A2_LANG.get(str1.toUpperCase(Locale.US));
/*      */ 
/*   63 */       if (str2 == null)
/*      */       {
/*   65 */         return null;
/*      */       }
/*      */     }
/*      */     else
/*      */     {
/*   70 */       str1 = "AMERICAN";
/*      */     }
/*      */ 
/*   73 */     String str3 = null;
/*   74 */     if ((paramString2 == null) || ((str3 = paramString2.toUpperCase(Locale.US)) == null) || ("".equals(str3)))
/*      */     {
/*   78 */       if (ORACLE_LANG_2_TERR == null)
/*   79 */         ORACLE_LANG_2_TERR = getLang2Terr();
/*   80 */       str3 = (String)ORACLE_LANG_2_TERR.get(str1);
/*      */     }
/*      */ 
/*   83 */     if (ORACLE_TERR_2_ISO_A2_TERR == null)
/*   84 */       ORACLE_TERR_2_ISO_A2_TERR = getTerr2IsoTerrMap();
/*   85 */     String str4 = (String)ORACLE_TERR_2_ISO_A2_TERR.get(str3);
/*   86 */     if (str4 == null)
/*      */     {
/*   88 */       return null;
/*      */     }
/*      */ 
/*   91 */     return new Locale(str2, str4);
/*      */   }
/*      */ 
/*      */   public static String getNLSLanguage(Locale paramLocale)
/*      */   {
/*  115 */     String str = getOraLocale(paramLocale);
/*  116 */     if (str == null)
/*  117 */       return null;
/*  118 */     int i = str.indexOf(95);
/*  119 */     return i < 0 ? str : str.substring(0, i);
/*      */   }
/*      */ 
/*      */   public static String getNLSTerritory(Locale paramLocale)
/*      */   {
/*  135 */     String str = getOraLocale(paramLocale);
/*  136 */     if (str == null)
/*  137 */       return null;
/*  138 */     int i = str.indexOf(95);
/*  139 */     return i < 0 ? null : str.substring(i + 1);
/*      */   }
/*      */ 
/*      */   private static String getOraLocale(Locale paramLocale)
/*      */   {
/*  154 */     if (paramLocale == null)
/*      */     {
/*  156 */       return null;
/*      */     }
/*      */ 
/*  160 */     String str1 = paramLocale.getLanguage().equals("") ? EN_LOCALE.getLanguage() : paramLocale.getLanguage();
/*      */ 
/*  163 */     if (ISO_A2_LANG_2_ORACLE_LANG == null) {
/*  164 */       ISO_A2_LANG_2_ORACLE_LANG = getIsoLangToOracleMap();
/*      */     }
/*      */ 
/*  167 */     String str2 = (String)ISO_A2_LANG_2_ORACLE_LANG.get(str1);
/*  168 */     if (str2 == null) {
/*  169 */       return null;
/*      */     }
/*      */ 
/*  172 */     String str3 = paramLocale.getCountry();
/*      */ 
/*  174 */     if (str3.equals(""))
/*      */     {
/*  176 */       if (ISO_LANGUAGE_DEFAULT_TERRITORY == null) {
/*  177 */         ISO_LANGUAGE_DEFAULT_TERRITORY = getIsoLangDefaultTerrMap();
/*      */       }
/*  179 */       str3 = (String)ISO_LANGUAGE_DEFAULT_TERRITORY.get(str1);
/*      */ 
/*  181 */       if (str3 == null) {
/*  182 */         return null;
/*      */       }
/*      */     }
/*  185 */     Locale localLocale = new Locale(str1, str3);
/*      */ 
/*  188 */     if (ISO_LOCALE_2_ORACLE_LOCALE == null) {
/*  189 */       ISO_LOCALE_2_ORACLE_LOCALE = getIsoLocToOracleMap();
/*      */     }
/*  191 */     String str4 = (String)ISO_LOCALE_2_ORACLE_LOCALE.get(localLocale.toString());
/*      */ 
/*  194 */     if (str4 != null)
/*      */     {
/*  196 */       return str4;
/*      */     }
/*      */ 
/*  199 */     if ("es".equals(str1))
/*      */     {
/*  202 */       str2 = "LATIN AMERICAN SPANISH";
/*      */     }
/*      */ 
/*  206 */     if (ISO_A2_TERR_2_ORACLE_TERR == null) {
/*  207 */       ISO_A2_TERR_2_ORACLE_TERR = getIsoTerrToOracleMap();
/*      */     }
/*  209 */     String str5 = (String)ISO_A2_TERR_2_ORACLE_TERR.get(str3);
/*  210 */     return str5 != null ? str2 + "_" + str5 : null;
/*      */   }
/*      */ 
/*      */   public static int getRatio(int paramInt1, int paramInt2)
/*      */   {
/*  251 */     if (paramInt2 == paramInt1)
/*      */     {
/*  253 */       return 1;
/*      */     }
/*      */ 
/*  256 */     if (CHARSET_RATIO == null)
/*      */     {
/*  258 */       CHARSET_RATIO = getCharsetRatio();
/*      */     }
/*      */ 
/*  261 */     Object localObject = CHARSET_RATIO.get(Integer.toString(paramInt1));
/*  262 */     if (localObject == null) {
/*  263 */       return 0;
/*      */     }
/*  265 */     int i = Integer.parseInt((String)localObject);
/*      */ 
/*  268 */     localObject = CHARSET_RATIO.get(Integer.toString(paramInt2));
/*  269 */     if (localObject == null) {
/*  270 */       return 0;
/*      */     }
/*  272 */     int j = Integer.parseInt((String)localObject);
/*      */ 
/*  274 */     int k = i & 0xFF;
/*      */ 
/*  276 */     if (k == 1)
/*      */     {
/*  278 */       return 1;
/*      */     }
/*      */ 
/*  281 */     if (j >>> 8 == 0)
/*      */     {
/*  284 */       return k;
/*      */     }
/*      */ 
/*  291 */     int m = j & 0xFF;
/*  292 */     int n = k / m;
/*      */ 
/*  294 */     if (k % m != 0)
/*      */     {
/*  296 */       n++;
/*      */     }
/*      */ 
/*  299 */     return n;
/*      */   }
/*      */ 
/*      */   private static synchronized Map getLang2IsoLangMap()
/*      */   {
/*  307 */     HashMap localHashMap = new HashMap();
/*      */ 
/*  309 */     localHashMap.put("ALBANIAN", "sq");
/*  310 */     localHashMap.put("AMERICAN", "en");
/*  311 */     localHashMap.put("AMHARIC", "am");
/*  312 */     localHashMap.put("ARABIC", "ar");
/*  313 */     localHashMap.put("ARMENIAN", "hy");
/*  314 */     localHashMap.put("ASSAMESE", "as");
/*  315 */     localHashMap.put("AZERBAIJANI", "az");
/*  316 */     localHashMap.put("BANGLA", "bn");
/*  317 */     localHashMap.put("BELARUSIAN", "be");
/*  318 */     localHashMap.put("BENGALI", "bn");
/*  319 */     localHashMap.put("BRAZILIAN PORTUGUESE", "pt");
/*  320 */     localHashMap.put("BULGARIAN", "bg");
/*  321 */     localHashMap.put("CANADIAN FRENCH", "fr");
/*  322 */     localHashMap.put("CATALAN", "ca");
/*  323 */     localHashMap.put("CROATIAN", "hr");
/*  324 */     localHashMap.put("CYRILLIC KAZAKH", "kk");
/*  325 */     localHashMap.put("CYRILLIC SERBIAN", "sr");
/*  326 */     localHashMap.put("CYRILLIC UZBEK", "uz");
/*  327 */     localHashMap.put("CZECH", "cs");
/*  328 */     localHashMap.put("DANISH", "da");
/*  329 */     localHashMap.put("DARI", "pr");
/*  330 */     localHashMap.put("DIVEHI", "dv");
/*  331 */     localHashMap.put("DUTCH", "nl");
/*  332 */     localHashMap.put("EGYPTIAN", "ar");
/*  333 */     localHashMap.put("ENGLISH", "en");
/*  334 */     localHashMap.put("ESTONIAN", "et");
/*  335 */     localHashMap.put("FINNISH", "fi");
/*  336 */     localHashMap.put("FRENCH", "fr");
/*  337 */     localHashMap.put("GERMAN", "de");
/*  338 */     localHashMap.put("GERMAN DIN", "de");
/*  339 */     localHashMap.put("GREEK", "el");
/*  340 */     localHashMap.put("GUJARATI", "gu");
/*  341 */     localHashMap.put("HEBREW", "iw");
/*  342 */     localHashMap.put("HINDI", "hi");
/*  343 */     localHashMap.put("HUNGARIAN", "hu");
/*  344 */     localHashMap.put("ICELANDIC", "is");
/*  345 */     localHashMap.put("INDONESIAN", "in");
/*  346 */     localHashMap.put("IRISH", "ga");
/*  347 */     localHashMap.put("ITALIAN", "it");
/*  348 */     localHashMap.put("JAPANESE", "ja");
/*  349 */     localHashMap.put("KANNADA", "kn");
/*  350 */     localHashMap.put("KHMER", "km");
/*  351 */     localHashMap.put("KOREAN", "ko");
/*  352 */     localHashMap.put("LAO", "lo");
/*  353 */     localHashMap.put("LATIN AMERICAN SPANISH", "es");
/*  354 */     localHashMap.put("LATIN BOSNIAN", "bs");
/*  355 */     localHashMap.put("LATIN SERBIAN", "sh");
/*  356 */     localHashMap.put("LATIN UZBEK", "uz");
/*  357 */     localHashMap.put("LATVIAN", "lv");
/*  358 */     localHashMap.put("LITHUANIAN", "lt");
/*  359 */     localHashMap.put("MACEDONIAN", "mk");
/*  360 */     localHashMap.put("MALAY", "ms");
/*  361 */     localHashMap.put("MALAYALAM", "ml");
/*  362 */     localHashMap.put("MALTESE", "mt");
/*  363 */     localHashMap.put("MARATHI", "mr");
/*  364 */     localHashMap.put("MEXICAN SPANISH", "es");
/*  365 */     localHashMap.put("NEPALI", "ne");
/*  366 */     localHashMap.put("NORWEGIAN", "no");
/*  367 */     localHashMap.put("NUMERIC DATE LANGUAGE", "en");
/*  368 */     localHashMap.put("ORIYA", "or");
/*  369 */     localHashMap.put("PERSIAN", "fa");
/*  370 */     localHashMap.put("POLISH", "pl");
/*  371 */     localHashMap.put("PORTUGUESE", "pt");
/*  372 */     localHashMap.put("PUNJABI", "pa");
/*  373 */     localHashMap.put("ROMANIAN", "ro");
/*  374 */     localHashMap.put("RUSSIAN", "ru");
/*  375 */     localHashMap.put("SIMPLIFIED CHINESE", "zh");
/*  376 */     localHashMap.put("SINHALA", "si");
/*  377 */     localHashMap.put("SLOVAK", "sk");
/*  378 */     localHashMap.put("SLOVENIAN", "sl");
/*  379 */     localHashMap.put("SPANISH", "es");
/*  380 */     localHashMap.put("SWAHILI", "sw");
/*  381 */     localHashMap.put("SWEDISH", "sv");
/*  382 */     localHashMap.put("TAMIL", "ta");
/*  383 */     localHashMap.put("TELUGU", "te");
/*  384 */     localHashMap.put("THAI", "th");
/*  385 */     localHashMap.put("TRADITIONAL CHINESE", "zh");
/*  386 */     localHashMap.put("TURKISH", "tr");
/*  387 */     localHashMap.put("UKRAINIAN", "uk");
/*  388 */     localHashMap.put("VIETNAMESE", "vi");
/*      */ 
/*  390 */     return localHashMap;
/*      */   }
/*      */ 
/*      */   private static synchronized Map getTerr2IsoTerrMap()
/*      */   {
/*  396 */     HashMap localHashMap = new HashMap();
/*      */ 
/*  398 */     localHashMap.put("AFGHANISTAN", "AF");
/*  399 */     localHashMap.put("ALBANIA", "AL");
/*  400 */     localHashMap.put("ALGERIA", "DZ");
/*  401 */     localHashMap.put("AMERICA", "US");
/*  402 */     localHashMap.put("ARGENTINA", "AR");
/*  403 */     localHashMap.put("ARMENIA", "AM");
/*  404 */     localHashMap.put("AUSTRALIA", "AU");
/*  405 */     localHashMap.put("AUSTRIA", "AT");
/*  406 */     localHashMap.put("AZERBAIJAN", "AZ");
/*  407 */     localHashMap.put("BAHAMAS", "BS");
/*  408 */     localHashMap.put("BAHRAIN", "BH");
/*  409 */     localHashMap.put("BANGLADESH", "BD");
/*  410 */     localHashMap.put("BELARUS", "BY");
/*  411 */     localHashMap.put("BELGIUM", "BE");
/*  412 */     localHashMap.put("BELIZE", "BZ");
/*  413 */     localHashMap.put("BERMUDA", "BM");
/*  414 */     localHashMap.put("BOLIVIA", "BO");
/*  415 */     localHashMap.put("BOSNIA AND HERZEGOVINA", "BA");
/*  416 */     localHashMap.put("BRAZIL", "BR");
/*  417 */     localHashMap.put("BULGARIA", "BG");
/*  418 */     localHashMap.put("CAMBODIA", "KH");
/*  419 */     localHashMap.put("CAMEROON", "CM");
/*  420 */     localHashMap.put("CANADA", "CA");
/*  421 */     localHashMap.put("CATALONIA", "ES");
/*  422 */     localHashMap.put("CHILE", "CL");
/*  423 */     localHashMap.put("CHINA", "CN");
/*  424 */     localHashMap.put("CIS", "RU");
/*  425 */     localHashMap.put("COLOMBIA", "CO");
/*  426 */     localHashMap.put("CONGO BRAZZAVILLE", "CG");
/*  427 */     localHashMap.put("CONGO KINSHASA", "CD");
/*  428 */     localHashMap.put("COSTA RICA", "CR");
/*  429 */     localHashMap.put("CROATIA", "HR");
/*  430 */     localHashMap.put("CYPRUS", "CY");
/*  431 */     localHashMap.put("CZECH REPUBLIC", "CZ");
/*  432 */     localHashMap.put("CZECHOSLOVAKIA", "CZ");
/*  433 */     localHashMap.put("DENMARK", "DK");
/*  434 */     localHashMap.put("DJIBOUTI", "DJ");
/*  435 */     localHashMap.put("ECUADOR", "EC");
/*  436 */     localHashMap.put("EGYPT", "EG");
/*  437 */     localHashMap.put("EL SALVADOR", "SV");
/*  438 */     localHashMap.put("ESTONIA", "EE");
/*  439 */     localHashMap.put("ETHIOPIA", "ET");
/*  440 */     localHashMap.put("FINLAND", "FI");
/*  441 */     localHashMap.put("FRANCE", "FR");
/*  442 */     localHashMap.put("FYR MACEDONIA", "MK");
/*  443 */     localHashMap.put("GABON", "GA");
/*  444 */     localHashMap.put("GERMANY", "DE");
/*  445 */     localHashMap.put("GREECE", "GR");
/*  446 */     localHashMap.put("GUATEMALA", "GT");
/*  447 */     localHashMap.put("HONDURAS", "HN");
/*  448 */     localHashMap.put("HONG KONG", "HK");
/*  449 */     localHashMap.put("HUNGARY", "HU");
/*  450 */     localHashMap.put("ICELAND", "IS");
/*  451 */     localHashMap.put("INDIA", "IN");
/*  452 */     localHashMap.put("INDONESIA", "ID");
/*  453 */     localHashMap.put("IRAN", "IR");
/*  454 */     localHashMap.put("IRAQ", "IQ");
/*  455 */     localHashMap.put("IRELAND", "IE");
/*  456 */     localHashMap.put("ISRAEL", "IL");
/*  457 */     localHashMap.put("ITALY", "IT");
/*  458 */     localHashMap.put("IVORY COAST", "CI");
/*  459 */     localHashMap.put("JAPAN", "JP");
/*  460 */     localHashMap.put("JORDAN", "JO");
/*  461 */     localHashMap.put("KAZAKHSTAN", "KZ");
/*  462 */     localHashMap.put("KENYA", "KE");
/*  463 */     localHashMap.put("KOREA", "KR");
/*  464 */     localHashMap.put("KUWAIT", "KW");
/*  465 */     localHashMap.put("LAOS", "LA");
/*  466 */     localHashMap.put("LATVIA", "LV");
/*  467 */     localHashMap.put("LEBANON", "LB");
/*  468 */     localHashMap.put("LIBYA", "LY");
/*  469 */     localHashMap.put("LITHUANIA", "LT");
/*  470 */     localHashMap.put("LUXEMBOURG", "LU");
/*  471 */     localHashMap.put("MACEDONIA", "MK");
/*  472 */     localHashMap.put("MALAYSIA", "MY");
/*  473 */     localHashMap.put("MALDIVES", "MV");
/*  474 */     localHashMap.put("MALTA", "MT");
/*  475 */     localHashMap.put("MAURITANIA", "MR");
/*  476 */     localHashMap.put("MEXICO", "MX");
/*  477 */     localHashMap.put("MONTENEGRO", "ME");
/*  478 */     localHashMap.put("MOROCCO", "MA");
/*  479 */     localHashMap.put("NEPAL", "NP");
/*  480 */     localHashMap.put("NEW ZEALAND", "NZ");
/*  481 */     localHashMap.put("NICARAGUA", "NI");
/*  482 */     localHashMap.put("NIGERIA", "NG");
/*  483 */     localHashMap.put("NORWAY", "NO");
/*  484 */     localHashMap.put("OMAN", "OM");
/*  485 */     localHashMap.put("PAKISTAN", "PK");
/*  486 */     localHashMap.put("PANAMA", "PA");
/*  487 */     localHashMap.put("PARAGUAY", "PY");
/*  488 */     localHashMap.put("PERU", "PE");
/*  489 */     localHashMap.put("PHILIPPINES", "PH");
/*  490 */     localHashMap.put("POLAND", "PL");
/*  491 */     localHashMap.put("PORTUGAL", "PT");
/*  492 */     localHashMap.put("PUERTO RICO", "PR");
/*  493 */     localHashMap.put("QATAR", "QA");
/*  494 */     localHashMap.put("ROMANIA", "RO");
/*  495 */     localHashMap.put("RUSSIA", "RU");
/*  496 */     localHashMap.put("SAUDI ARABIA", "SA");
/*  497 */     localHashMap.put("SENEGAL", "SN");
/*  498 */     localHashMap.put("SERBIA", "RS");
/*  499 */     localHashMap.put("SERBIA AND MONTENEGRO", "CS");
/*  500 */     localHashMap.put("SINGAPORE", "SG");
/*  501 */     localHashMap.put("SLOVAKIA", "SK");
/*  502 */     localHashMap.put("SLOVENIA", "SI");
/*  503 */     localHashMap.put("SOMALIA", "SO");
/*  504 */     localHashMap.put("SOUTH AFRICA", "ZA");
/*  505 */     localHashMap.put("SPAIN", "ES");
/*  506 */     localHashMap.put("SRI LANKA", "LK");
/*  507 */     localHashMap.put("SUDAN", "SD");
/*  508 */     localHashMap.put("SWEDEN", "SE");
/*  509 */     localHashMap.put("SWITZERLAND", "CH");
/*  510 */     localHashMap.put("SYRIA", "SY");
/*  511 */     localHashMap.put("TAIWAN", "TW");
/*  512 */     localHashMap.put("TANZANIA", "TZ");
/*  513 */     localHashMap.put("THAILAND", "TH");
/*  514 */     localHashMap.put("THE NETHERLANDS", "NL");
/*  515 */     localHashMap.put("TUNISIA", "TN");
/*  516 */     localHashMap.put("TURKEY", "TR");
/*  517 */     localHashMap.put("UGANDA", "UG");
/*  518 */     localHashMap.put("UKRAINE", "UA");
/*  519 */     localHashMap.put("UNITED ARAB EMIRATES", "AE");
/*  520 */     localHashMap.put("UNITED KINGDOM", "GB");
/*  521 */     localHashMap.put("URUGUAY", "UY");
/*  522 */     localHashMap.put("UZBEKISTAN", "UZ");
/*  523 */     localHashMap.put("VENEZUELA", "VE");
/*  524 */     localHashMap.put("VIETNAM", "VN");
/*  525 */     localHashMap.put("YEMEN", "YE");
/*  526 */     localHashMap.put("YUGOSLAVIA", "YU");
/*  527 */     localHashMap.put("ZAMBIA", "ZM");
/*      */ 
/*  529 */     return localHashMap;
/*      */   }
/*      */ 
/*      */   private static synchronized Map getLang2Terr()
/*      */   {
/*  535 */     HashMap localHashMap = new HashMap();
/*      */ 
/*  537 */     localHashMap.put("ALBANIAN", "ALBANIA");
/*  538 */     localHashMap.put("AMERICAN", "AMERICA");
/*  539 */     localHashMap.put("AMHARIC", "ETHIOPIA");
/*  540 */     localHashMap.put("ARABIC", "UNITED ARAB EMIRATES");
/*  541 */     localHashMap.put("ARMENIAN", "ARMENIA");
/*  542 */     localHashMap.put("ASSAMESE", "INDIA");
/*  543 */     localHashMap.put("AZERBAIJANI", "AZERBAIJAN");
/*  544 */     localHashMap.put("BANGLA", "INDIA");
/*  545 */     localHashMap.put("BELARUSIAN", "BELARUS");
/*  546 */     localHashMap.put("BRAZILIAN PORTUGUESE", "BRAZIL");
/*  547 */     localHashMap.put("BULGARIAN", "BULGARIA");
/*  548 */     localHashMap.put("CANADIAN FRENCH", "CANADA");
/*  549 */     localHashMap.put("CATALAN", "CATALONIA");
/*  550 */     localHashMap.put("CROATIAN", "CROATIA");
/*  551 */     localHashMap.put("CYRILLIC KAZAKH", "KAZAKHSTAN");
/*  552 */     localHashMap.put("CYRILLIC SERBIAN", "SERBIA");
/*  553 */     localHashMap.put("CYRILLIC UZBEK", "UZBEKISTAN");
/*  554 */     localHashMap.put("CZECH", "CZECH REPUBLIC");
/*  555 */     localHashMap.put("DANISH", "DENMARK");
/*  556 */     localHashMap.put("DARI", "AFGHANISTAN");
/*  557 */     localHashMap.put("DIVEHI", "MALDIVES");
/*  558 */     localHashMap.put("DUTCH", "THE NETHERLANDS");
/*  559 */     localHashMap.put("EGYPTIAN", "EGYPT");
/*  560 */     localHashMap.put("ENGLISH", "UNITED KINGDOM");
/*  561 */     localHashMap.put("ESTONIAN", "ESTONIA");
/*  562 */     localHashMap.put("FINNISH", "FINLAND");
/*  563 */     localHashMap.put("FRENCH", "FRANCE");
/*  564 */     localHashMap.put("GERMAN", "GERMANY");
/*  565 */     localHashMap.put("GERMAN DIN", "GERMANY");
/*  566 */     localHashMap.put("GREEK", "GREECE");
/*  567 */     localHashMap.put("GUJARATI", "INDIA");
/*  568 */     localHashMap.put("HEBREW", "ISRAEL");
/*  569 */     localHashMap.put("HINDI", "INDIA");
/*  570 */     localHashMap.put("HUNGARIAN", "HUNGARY");
/*  571 */     localHashMap.put("ICELANDIC", "ICELAND");
/*  572 */     localHashMap.put("INDONESIAN", "INDONESIA");
/*  573 */     localHashMap.put("IRISH", "IRELAND");
/*  574 */     localHashMap.put("ITALIAN", "ITALY");
/*  575 */     localHashMap.put("JAPANESE", "JAPAN");
/*  576 */     localHashMap.put("KANNADA", "INDIA");
/*  577 */     localHashMap.put("KHMER", "CAMBODIA");
/*  578 */     localHashMap.put("KOREAN", "KOREA");
/*  579 */     localHashMap.put("LAO", "LAOS");
/*  580 */     localHashMap.put("LATIN AMERICAN SPANISH", "AMERICA");
/*  581 */     localHashMap.put("LATIN BOSNIAN", "BOSNIA AND HERZEGOVINA");
/*  582 */     localHashMap.put("LATIN SERBIAN", "SERBIA");
/*  583 */     localHashMap.put("LATIN UZBEK", "UZBEKISTAN");
/*  584 */     localHashMap.put("LATVIAN", "LATVIA");
/*  585 */     localHashMap.put("LITHUANIAN", "LITHUANIA");
/*  586 */     localHashMap.put("MACEDONIAN", "FYR MACEDONIA");
/*  587 */     localHashMap.put("MALAY", "MALAYSIA");
/*  588 */     localHashMap.put("MALAYALAM", "INDIA");
/*  589 */     localHashMap.put("MALTESE", "MALTA");
/*  590 */     localHashMap.put("MARATHI", "INDIA");
/*  591 */     localHashMap.put("MEXICAN SPANISH", "MEXICO");
/*  592 */     localHashMap.put("NEPALI", "NEPAL");
/*  593 */     localHashMap.put("NORWEGIAN", "NORWAY");
/*  594 */     localHashMap.put("ORIYA", "INDIA");
/*  595 */     localHashMap.put("PERSIAN", "IRAN");
/*  596 */     localHashMap.put("POLISH", "POLAND");
/*  597 */     localHashMap.put("PORTUGUESE", "PORTUGAL");
/*  598 */     localHashMap.put("PUNJABI", "INDIA");
/*  599 */     localHashMap.put("ROMANIAN", "ROMANIA");
/*  600 */     localHashMap.put("RUSSIAN", "RUSSIA");
/*  601 */     localHashMap.put("SIMPLIFIED CHINESE", "CHINA");
/*  602 */     localHashMap.put("SINHALA", "SRI LANKA");
/*  603 */     localHashMap.put("SLOVAK", "SLOVAKIA");
/*  604 */     localHashMap.put("SLOVENIAN", "SLOVENIA");
/*  605 */     localHashMap.put("SPANISH", "SPAIN");
/*  606 */     localHashMap.put("SWAHILI", "KENYA");
/*  607 */     localHashMap.put("SWEDISH", "SWEDEN");
/*  608 */     localHashMap.put("TAMIL", "INDIA");
/*  609 */     localHashMap.put("TELUGU", "INDIA");
/*  610 */     localHashMap.put("THAI", "THAILAND");
/*  611 */     localHashMap.put("TRADITIONAL CHINESE", "TAIWAN");
/*  612 */     localHashMap.put("TURKISH", "TURKEY");
/*  613 */     localHashMap.put("UKRAINIAN", "UKRAINE");
/*  614 */     localHashMap.put("VIETNAMESE", "VIETNAM");
/*      */ 
/*  616 */     return localHashMap;
/*      */   }
/*      */ 
/*      */   private static synchronized Map getIsoLangToOracleMap()
/*      */   {
/*  622 */     HashMap localHashMap = new HashMap();
/*      */ 
/*  624 */     localHashMap.put("am", "AMHARIC");
/*  625 */     localHashMap.put("ar", "ARABIC");
/*  626 */     localHashMap.put("as", "ASSAMESE");
/*  627 */     localHashMap.put("az", "AZERBAIJANI");
/*  628 */     localHashMap.put("be", "BELARUSIAN");
/*  629 */     localHashMap.put("bg", "BULGARIAN");
/*  630 */     localHashMap.put("bn", "BANGLA");
/*  631 */     localHashMap.put("bs", "LATIN BOSNIAN");
/*  632 */     localHashMap.put("ca", "CATALAN");
/*  633 */     localHashMap.put("cs", "CZECH");
/*  634 */     localHashMap.put("da", "DANISH");
/*  635 */     localHashMap.put("de", "GERMAN");
/*  636 */     localHashMap.put("dv", "DIVEHI");
/*  637 */     localHashMap.put("el", "GREEK");
/*  638 */     localHashMap.put("en", "ENGLISH");
/*  639 */     localHashMap.put("es", "SPANISH");
/*  640 */     localHashMap.put("et", "ESTONIAN");
/*  641 */     localHashMap.put("fa", "PERSIAN");
/*  642 */     localHashMap.put("fi", "FINNISH");
/*  643 */     localHashMap.put("fr", "FRENCH");
/*  644 */     localHashMap.put("ga", "IRISH");
/*  645 */     localHashMap.put("gu", "GUJARATI");
/*  646 */     localHashMap.put("he", "HEBREW");
/*  647 */     localHashMap.put("hi", "HINDI");
/*  648 */     localHashMap.put("hr", "CROATIAN");
/*  649 */     localHashMap.put("hu", "HUNGARIAN");
/*  650 */     localHashMap.put("hy", "ARMENIAN");
/*  651 */     localHashMap.put("id", "INDONESIAN");
/*  652 */     localHashMap.put("in", "INDONESIAN");
/*  653 */     localHashMap.put("is", "ICELANDIC");
/*  654 */     localHashMap.put("it", "ITALIAN");
/*  655 */     localHashMap.put("iw", "HEBREW");
/*  656 */     localHashMap.put("ja", "JAPANESE");
/*  657 */     localHashMap.put("kk", "CYRILLIC KAZAKH");
/*  658 */     localHashMap.put("km", "KHMER");
/*  659 */     localHashMap.put("kn", "KANNADA");
/*  660 */     localHashMap.put("ko", "KOREAN");
/*  661 */     localHashMap.put("lo", "LAO");
/*  662 */     localHashMap.put("lt", "LITHUANIAN");
/*  663 */     localHashMap.put("lv", "LATVIAN");
/*  664 */     localHashMap.put("mk", "MACEDONIAN");
/*  665 */     localHashMap.put("ml", "MALAYALAM");
/*  666 */     localHashMap.put("mr", "MARATHI");
/*  667 */     localHashMap.put("ms", "MALAY");
/*  668 */     localHashMap.put("mt", "MALTESE");
/*  669 */     localHashMap.put("nb", "NORWEGIAN");
/*  670 */     localHashMap.put("ne", "NEPALI");
/*  671 */     localHashMap.put("nl", "DUTCH");
/*  672 */     localHashMap.put("nn", "NORWEGIAN");
/*  673 */     localHashMap.put("no", "NORWEGIAN");
/*  674 */     localHashMap.put("or", "ORIYA");
/*  675 */     localHashMap.put("pa", "PUNJABI");
/*  676 */     localHashMap.put("pl", "POLISH");
/*  677 */     localHashMap.put("pr", "DARI");
/*  678 */     localHashMap.put("pt", "PORTUGUESE");
/*  679 */     localHashMap.put("ro", "ROMANIAN");
/*  680 */     localHashMap.put("ru", "RUSSIAN");
/*  681 */     localHashMap.put("sh", "LATIN SERBIAN");
/*  682 */     localHashMap.put("si", "SINHALA");
/*  683 */     localHashMap.put("sk", "SLOVAK");
/*  684 */     localHashMap.put("sl", "SLOVENIAN");
/*  685 */     localHashMap.put("sq", "ALBANIAN");
/*  686 */     localHashMap.put("sr", "CYRILLIC SERBIAN");
/*  687 */     localHashMap.put("sv", "SWEDISH");
/*  688 */     localHashMap.put("sw", "SWAHILI");
/*  689 */     localHashMap.put("ta", "TAMIL");
/*  690 */     localHashMap.put("te", "TELUGU");
/*  691 */     localHashMap.put("th", "THAI");
/*  692 */     localHashMap.put("tr", "TURKISH");
/*  693 */     localHashMap.put("uk", "UKRAINIAN");
/*  694 */     localHashMap.put("uz", "LATIN UZBEK");
/*  695 */     localHashMap.put("vi", "VIETNAMESE");
/*  696 */     localHashMap.put("zh", "SIMPLIFIED CHINESE");
/*      */ 
/*  698 */     return localHashMap;
/*      */   }
/*      */ 
/*      */   private static synchronized Map getIsoLangDefaultTerrMap()
/*      */   {
/*  704 */     HashMap localHashMap = new HashMap();
/*      */ 
/*  706 */     localHashMap.put("am", "ET");
/*  707 */     localHashMap.put("ar", "AE");
/*  708 */     localHashMap.put("as", "IN");
/*  709 */     localHashMap.put("az", "AZ");
/*  710 */     localHashMap.put("be", "BY");
/*  711 */     localHashMap.put("bg", "BG");
/*  712 */     localHashMap.put("bn", "BD");
/*  713 */     localHashMap.put("bs", "BA");
/*  714 */     localHashMap.put("ca", "ES");
/*  715 */     localHashMap.put("cs", "CZ");
/*  716 */     localHashMap.put("da", "DK");
/*  717 */     localHashMap.put("de", "DE");
/*  718 */     localHashMap.put("dv", "MV");
/*  719 */     localHashMap.put("el", "GR");
/*  720 */     localHashMap.put("en", "US");
/*  721 */     localHashMap.put("es", "ES");
/*  722 */     localHashMap.put("et", "EE");
/*  723 */     localHashMap.put("fa", "IR");
/*  724 */     localHashMap.put("fi", "FI");
/*  725 */     localHashMap.put("fr", "FR");
/*  726 */     localHashMap.put("ga", "IE");
/*  727 */     localHashMap.put("gu", "IN");
/*  728 */     localHashMap.put("he", "IL");
/*  729 */     localHashMap.put("hi", "IN");
/*  730 */     localHashMap.put("hr", "HR");
/*  731 */     localHashMap.put("hu", "HU");
/*  732 */     localHashMap.put("hy", "AM");
/*  733 */     localHashMap.put("id", "ID");
/*  734 */     localHashMap.put("in", "ID");
/*  735 */     localHashMap.put("is", "IS");
/*  736 */     localHashMap.put("it", "IT");
/*  737 */     localHashMap.put("iw", "IL");
/*  738 */     localHashMap.put("ja", "JP");
/*  739 */     localHashMap.put("kk", "KZ");
/*  740 */     localHashMap.put("km", "KH");
/*  741 */     localHashMap.put("kn", "IN");
/*  742 */     localHashMap.put("ko", "KR");
/*  743 */     localHashMap.put("lo", "LA");
/*  744 */     localHashMap.put("lt", "LT");
/*  745 */     localHashMap.put("lv", "LV");
/*  746 */     localHashMap.put("mk", "MK");
/*  747 */     localHashMap.put("ml", "IN");
/*  748 */     localHashMap.put("mr", "IN");
/*  749 */     localHashMap.put("ms", "MY");
/*  750 */     localHashMap.put("mt", "MT");
/*  751 */     localHashMap.put("nb", "NO");
/*  752 */     localHashMap.put("ne", "NP");
/*  753 */     localHashMap.put("nl", "NL");
/*  754 */     localHashMap.put("nn", "NO");
/*  755 */     localHashMap.put("no", "NO");
/*  756 */     localHashMap.put("or", "IN");
/*  757 */     localHashMap.put("pa", "IN");
/*  758 */     localHashMap.put("pl", "PL");
/*  759 */     localHashMap.put("pr", "AF");
/*  760 */     localHashMap.put("pt", "PT");
/*  761 */     localHashMap.put("ro", "RO");
/*  762 */     localHashMap.put("ru", "RU");
/*  763 */     localHashMap.put("si", "LK");
/*  764 */     localHashMap.put("sk", "SK");
/*  765 */     localHashMap.put("sl", "SI");
/*  766 */     localHashMap.put("sq", "AL");
/*  767 */     localHashMap.put("sr", "RS");
/*  768 */     localHashMap.put("sv", "SE");
/*  769 */     localHashMap.put("ta", "IN");
/*  770 */     localHashMap.put("te", "IN");
/*  771 */     localHashMap.put("th", "TH");
/*  772 */     localHashMap.put("tr", "TR");
/*  773 */     localHashMap.put("uk", "UA");
/*  774 */     localHashMap.put("uz", "UZ");
/*  775 */     localHashMap.put("vi", "VN");
/*  776 */     localHashMap.put("zh", "CN");
/*      */ 
/*  778 */     return localHashMap;
/*      */   }
/*      */ 
/*      */   private static synchronized Map getIsoLocToOracleMap()
/*      */   {
/*  784 */     HashMap localHashMap = new HashMap();
/*      */ 
/*  786 */     localHashMap.put("ar_EG", "EGYPTIAN_EGYPT");
/*  787 */     localHashMap.put("ca_ES", "CATALAN_CATALONIA");
/*  788 */     localHashMap.put("en_US", "AMERICAN_AMERICA");
/*  789 */     localHashMap.put("es_ES", "SPANISH_SPAIN");
/*  790 */     localHashMap.put("es_MX", "MEXICAN SPANISH_MEXICO");
/*  791 */     localHashMap.put("fr_CA", "CANADIAN FRENCH_CANADA");
/*  792 */     localHashMap.put("pt_BR", "BRAZILIAN PORTUGUESE_BRAZIL");
/*  793 */     localHashMap.put("zh_HK", "TRADITIONAL CHINESE_HONG KONG");
/*  794 */     localHashMap.put("zh_TW", "TRADITIONAL CHINESE_TAIWAN");
/*      */ 
/*  796 */     return localHashMap;
/*      */   }
/*      */ 
/*      */   private static synchronized Map getIsoTerrToOracleMap()
/*      */   {
/*  802 */     HashMap localHashMap = new HashMap();
/*      */ 
/*  804 */     localHashMap.put("AE", "UNITED ARAB EMIRATES");
/*  805 */     localHashMap.put("AF", "AFGHANISTAN");
/*  806 */     localHashMap.put("AL", "ALBANIA");
/*  807 */     localHashMap.put("AM", "ARMENIA");
/*  808 */     localHashMap.put("AR", "ARGENTINA");
/*  809 */     localHashMap.put("AT", "AUSTRIA");
/*  810 */     localHashMap.put("AU", "AUSTRALIA");
/*  811 */     localHashMap.put("AZ", "AZERBAIJAN");
/*  812 */     localHashMap.put("BA", "BOSNIA AND HERZEGOVINA");
/*  813 */     localHashMap.put("BD", "BANGLADESH");
/*  814 */     localHashMap.put("BE", "BELGIUM");
/*  815 */     localHashMap.put("BG", "BULGARIA");
/*  816 */     localHashMap.put("BH", "BAHRAIN");
/*  817 */     localHashMap.put("BM", "BERMUDA");
/*  818 */     localHashMap.put("BO", "BOLIVIA");
/*  819 */     localHashMap.put("BR", "BRAZIL");
/*  820 */     localHashMap.put("BS", "BAHAMAS");
/*  821 */     localHashMap.put("BY", "BELARUS");
/*  822 */     localHashMap.put("BZ", "BELIZE");
/*  823 */     localHashMap.put("CA", "CANADA");
/*  824 */     localHashMap.put("CD", "CONGO KINSHASA");
/*  825 */     localHashMap.put("CG", "CONGO BRAZZAVILLE");
/*  826 */     localHashMap.put("CH", "SWITZERLAND");
/*  827 */     localHashMap.put("CI", "IVORY COAST");
/*  828 */     localHashMap.put("CL", "CHILE");
/*  829 */     localHashMap.put("CM", "CAMEROON");
/*  830 */     localHashMap.put("CN", "CHINA");
/*  831 */     localHashMap.put("CO", "COLOMBIA");
/*  832 */     localHashMap.put("CR", "COSTA RICA");
/*  833 */     localHashMap.put("CS", "SERBIA AND MONTENEGRO");
/*  834 */     localHashMap.put("CY", "CYPRUS");
/*  835 */     localHashMap.put("CZ", "CZECH REPUBLIC");
/*  836 */     localHashMap.put("DE", "GERMANY");
/*  837 */     localHashMap.put("DJ", "DJIBOUTI");
/*  838 */     localHashMap.put("DK", "DENMARK");
/*  839 */     localHashMap.put("DZ", "ALGERIA");
/*  840 */     localHashMap.put("EC", "ECUADOR");
/*  841 */     localHashMap.put("EE", "ESTONIA");
/*  842 */     localHashMap.put("EG", "EGYPT");
/*  843 */     localHashMap.put("ES", "SPAIN");
/*  844 */     localHashMap.put("ET", "ETHIOPIA");
/*  845 */     localHashMap.put("FI", "FINLAND");
/*  846 */     localHashMap.put("FR", "FRANCE");
/*  847 */     localHashMap.put("GA", "GABON");
/*  848 */     localHashMap.put("GB", "UNITED KINGDOM");
/*  849 */     localHashMap.put("GR", "GREECE");
/*  850 */     localHashMap.put("GT", "GUATEMALA");
/*  851 */     localHashMap.put("HK", "HONG KONG");
/*  852 */     localHashMap.put("HN", "HONDURAS");
/*  853 */     localHashMap.put("HR", "CROATIA");
/*  854 */     localHashMap.put("HU", "HUNGARY");
/*  855 */     localHashMap.put("ID", "INDONESIA");
/*  856 */     localHashMap.put("IE", "IRELAND");
/*  857 */     localHashMap.put("IL", "ISRAEL");
/*  858 */     localHashMap.put("IN", "INDIA");
/*  859 */     localHashMap.put("IQ", "IRAQ");
/*  860 */     localHashMap.put("IR", "IRAN");
/*  861 */     localHashMap.put("IS", "ICELAND");
/*  862 */     localHashMap.put("IT", "ITALY");
/*  863 */     localHashMap.put("JO", "JORDAN");
/*  864 */     localHashMap.put("JP", "JAPAN");
/*  865 */     localHashMap.put("KE", "KENYA");
/*  866 */     localHashMap.put("KH", "CAMBODIA");
/*  867 */     localHashMap.put("KR", "KOREA");
/*  868 */     localHashMap.put("KW", "KUWAIT");
/*  869 */     localHashMap.put("KZ", "KAZAKHSTAN");
/*  870 */     localHashMap.put("LA", "LAOS");
/*  871 */     localHashMap.put("LB", "LEBANON");
/*  872 */     localHashMap.put("LK", "SRI LANKA");
/*  873 */     localHashMap.put("LT", "LITHUANIA");
/*  874 */     localHashMap.put("LU", "LUXEMBOURG");
/*  875 */     localHashMap.put("LV", "LATVIA");
/*  876 */     localHashMap.put("LY", "LIBYA");
/*  877 */     localHashMap.put("MA", "MOROCCO");
/*  878 */     localHashMap.put("ME", "MONTENEGRO");
/*  879 */     localHashMap.put("MK", "FYR MACEDONIA");
/*  880 */     localHashMap.put("MR", "MAURITANIA");
/*  881 */     localHashMap.put("MT", "MALTA");
/*  882 */     localHashMap.put("MV", "MALDIVES");
/*  883 */     localHashMap.put("MX", "MEXICO");
/*  884 */     localHashMap.put("MY", "MALAYSIA");
/*  885 */     localHashMap.put("NG", "NIGERIA");
/*  886 */     localHashMap.put("NI", "NICARAGUA");
/*  887 */     localHashMap.put("NL", "THE NETHERLANDS");
/*  888 */     localHashMap.put("NO", "NORWAY");
/*  889 */     localHashMap.put("NP", "NEPAL");
/*  890 */     localHashMap.put("NZ", "NEW ZEALAND");
/*  891 */     localHashMap.put("OM", "OMAN");
/*  892 */     localHashMap.put("PA", "PANAMA");
/*  893 */     localHashMap.put("PE", "PERU");
/*  894 */     localHashMap.put("PH", "PHILIPPINES");
/*  895 */     localHashMap.put("PK", "PAKISTAN");
/*  896 */     localHashMap.put("PL", "POLAND");
/*  897 */     localHashMap.put("PR", "PUERTO RICO");
/*  898 */     localHashMap.put("PT", "PORTUGAL");
/*  899 */     localHashMap.put("PY", "PARAGUAY");
/*  900 */     localHashMap.put("QA", "QATAR");
/*  901 */     localHashMap.put("RO", "ROMANIA");
/*  902 */     localHashMap.put("RS", "SERBIA");
/*  903 */     localHashMap.put("RU", "RUSSIA");
/*  904 */     localHashMap.put("SA", "SAUDI ARABIA");
/*  905 */     localHashMap.put("SD", "SUDAN");
/*  906 */     localHashMap.put("SE", "SWEDEN");
/*  907 */     localHashMap.put("SG", "SINGAPORE");
/*  908 */     localHashMap.put("SI", "SLOVENIA");
/*  909 */     localHashMap.put("SK", "SLOVAKIA");
/*  910 */     localHashMap.put("SN", "SENEGAL");
/*  911 */     localHashMap.put("SO", "SOMALIA");
/*  912 */     localHashMap.put("SV", "EL SALVADOR");
/*  913 */     localHashMap.put("SY", "SYRIA");
/*  914 */     localHashMap.put("TH", "THAILAND");
/*  915 */     localHashMap.put("TN", "TUNISIA");
/*  916 */     localHashMap.put("TR", "TURKEY");
/*  917 */     localHashMap.put("TW", "TAIWAN");
/*  918 */     localHashMap.put("TZ", "TANZANIA");
/*  919 */     localHashMap.put("UA", "UKRAINE");
/*  920 */     localHashMap.put("UG", "UGANDA");
/*  921 */     localHashMap.put("US", "AMERICA");
/*  922 */     localHashMap.put("UY", "URUGUAY");
/*  923 */     localHashMap.put("UZ", "UZBEKISTAN");
/*  924 */     localHashMap.put("VE", "VENEZUELA");
/*  925 */     localHashMap.put("VN", "VIETNAM");
/*  926 */     localHashMap.put("YE", "YEMEN");
/*  927 */     localHashMap.put("YU", "YUGOSLAVIA");
/*  928 */     localHashMap.put("ZA", "SOUTH AFRICA");
/*  929 */     localHashMap.put("ZM", "ZAMBIA");
/*      */ 
/*  931 */     return localHashMap;
/*      */   }
/*      */ 
/*      */   private static synchronized Map getCharsetRatio()
/*      */   {
/*  937 */     HashMap localHashMap = new HashMap();
/*  938 */     localHashMap.put("2000", "258");
/*  939 */     localHashMap.put("873", "4");
/*  940 */     localHashMap.put("557", "1");
/*  941 */     localHashMap.put("558", "1");
/*  942 */     localHashMap.put("559", "1");
/*  943 */     localHashMap.put("565", "1");
/*  944 */     localHashMap.put("566", "1");
/*  945 */     localHashMap.put("500", "1");
/*  946 */     localHashMap.put("320", "1");
/*  947 */     localHashMap.put("70", "1");
/*  948 */     localHashMap.put("36", "1");
/*  949 */     localHashMap.put("560", "1");
/*  950 */     localHashMap.put("556", "1");
/*  951 */     localHashMap.put("554", "1");
/*  952 */     localHashMap.put("561", "1");
/*  953 */     localHashMap.put("563", "1");
/*  954 */     localHashMap.put("555", "1");
/*  955 */     localHashMap.put("52", "1");
/*  956 */     localHashMap.put("173", "1");
/*  957 */     localHashMap.put("140", "1");
/*  958 */     localHashMap.put("191", "1");
/*  959 */     localHashMap.put("194", "1");
/*  960 */     localHashMap.put("314", "1");
/*  961 */     localHashMap.put("47", "1");
/*  962 */     localHashMap.put("179", "1");
/*  963 */     localHashMap.put("197", "1");
/*  964 */     localHashMap.put("43", "1");
/*  965 */     localHashMap.put("390", "1");
/*  966 */     localHashMap.put("233", "1");
/*  967 */     localHashMap.put("48", "1");
/*  968 */     localHashMap.put("19", "1");
/*  969 */     localHashMap.put("235", "1");
/*  970 */     localHashMap.put("185", "1");
/*  971 */     localHashMap.put("322", "1");
/*  972 */     localHashMap.put("323", "1");
/*  973 */     localHashMap.put("317", "1");
/*  974 */     localHashMap.put("188", "1");
/*  975 */     localHashMap.put("325", "1");
/*  976 */     localHashMap.put("326", "1");
/*  977 */     localHashMap.put("35", "1");
/*  978 */     localHashMap.put("49", "1");
/*  979 */     localHashMap.put("196", "1");
/*  980 */     localHashMap.put("51", "1");
/*  981 */     localHashMap.put("158", "1");
/*  982 */     localHashMap.put("159", "1");
/*  983 */     localHashMap.put("171", "1");
/*  984 */     localHashMap.put("11", "1");
/*  985 */     localHashMap.put("207", "1");
/*  986 */     localHashMap.put("222", "1");
/*  987 */     localHashMap.put("189", "1");
/*  988 */     localHashMap.put("180", "1");
/*  989 */     localHashMap.put("204", "1");
/*  990 */     localHashMap.put("225", "1");
/*  991 */     localHashMap.put("198", "1");
/*  992 */     localHashMap.put("182", "1");
/*  993 */     localHashMap.put("14", "1");
/*  994 */     localHashMap.put("202", "1");
/*  995 */     localHashMap.put("224", "1");
/*  996 */     localHashMap.put("232", "1");
/*  997 */     localHashMap.put("184", "1");
/*  998 */     localHashMap.put("301", "1");
/*  999 */     localHashMap.put("316", "1");
/* 1000 */     localHashMap.put("32", "1");
/* 1001 */     localHashMap.put("262", "1");
/* 1002 */     localHashMap.put("162", "1");
/* 1003 */     localHashMap.put("263", "1");
/* 1004 */     localHashMap.put("163", "1");
/* 1005 */     localHashMap.put("170", "1");
/* 1006 */     localHashMap.put("150", "1");
/* 1007 */     localHashMap.put("110", "1");
/* 1008 */     localHashMap.put("113", "1");
/* 1009 */     localHashMap.put("81", "1");
/* 1010 */     localHashMap.put("327", "1");
/* 1011 */     localHashMap.put("381", "1");
/* 1012 */     localHashMap.put("324", "1");
/* 1013 */     localHashMap.put("211", "1");
/* 1014 */     localHashMap.put("37", "1");
/* 1015 */     localHashMap.put("266", "1");
/* 1016 */     localHashMap.put("166", "1");
/* 1017 */     localHashMap.put("174", "1");
/* 1018 */     localHashMap.put("380", "1");
/* 1019 */     localHashMap.put("382", "1");
/* 1020 */     localHashMap.put("386", "1");
/* 1021 */     localHashMap.put("385", "1");
/* 1022 */     localHashMap.put("172", "1");
/* 1023 */     localHashMap.put("12", "1");
/* 1024 */     localHashMap.put("201", "1");
/* 1025 */     localHashMap.put("223", "1");
/* 1026 */     localHashMap.put("208", "1");
/* 1027 */     localHashMap.put("186", "1");
/* 1028 */     localHashMap.put("401", "1");
/* 1029 */     localHashMap.put("368", "1");
/* 1030 */     localHashMap.put("17", "1");
/* 1031 */     localHashMap.put("206", "1");
/* 1032 */     localHashMap.put("200", "1");
/* 1033 */     localHashMap.put("181", "1");
/* 1034 */     localHashMap.put("25", "1");
/* 1035 */     localHashMap.put("265", "1");
/* 1036 */     localHashMap.put("165", "1");
/* 1037 */     localHashMap.put("161", "1");
/* 1038 */     localHashMap.put("23", "1");
/* 1039 */     localHashMap.put("187", "1");
/* 1040 */     localHashMap.put("92", "1");
/* 1041 */     localHashMap.put("315", "1");
/* 1042 */     localHashMap.put("38", "1");
/* 1043 */     localHashMap.put("267", "1");
/* 1044 */     localHashMap.put("167", "1");
/* 1045 */     localHashMap.put("175", "1");
/* 1046 */     localHashMap.put("154", "1");
/* 1047 */     localHashMap.put("833", "2");
/* 1048 */     localHashMap.put("835", "2");
/* 1049 */     localHashMap.put("830", "3");
/* 1050 */     localHashMap.put("837", "3");
/* 1051 */     localHashMap.put("831", "3");
/* 1052 */     localHashMap.put("836", "2");
/* 1053 */     localHashMap.put("832", "2");
/* 1054 */     localHashMap.put("838", "2");
/* 1055 */     localHashMap.put("834", "2");
/* 1056 */     localHashMap.put("829", "2");
/* 1057 */     localHashMap.put("842", "2");
/* 1058 */     localHashMap.put("840", "2");
/* 1059 */     localHashMap.put("845", "2");
/* 1060 */     localHashMap.put("846", "2");
/* 1061 */     localHashMap.put("590", "1");
/* 1062 */     localHashMap.put("114", "1");
/* 1063 */     localHashMap.put("176", "1");
/* 1064 */     localHashMap.put("383", "1");
/* 1065 */     localHashMap.put("384", "1");
/* 1066 */     localHashMap.put("192", "1");
/* 1067 */     localHashMap.put("193", "1");
/* 1068 */     localHashMap.put("195", "1");
/* 1069 */     localHashMap.put("205", "1");
/* 1070 */     localHashMap.put("190", "1");
/* 1071 */     localHashMap.put("16", "1");
/* 1072 */     localHashMap.put("40", "1");
/* 1073 */     localHashMap.put("34", "1");
/* 1074 */     localHashMap.put("18", "1");
/* 1075 */     localHashMap.put("153", "1");
/* 1076 */     localHashMap.put("155", "1");
/* 1077 */     localHashMap.put("152", "1");
/* 1078 */     localHashMap.put("13", "1");
/* 1079 */     localHashMap.put("203", "1");
/* 1080 */     localHashMap.put("226", "1");
/* 1081 */     localHashMap.put("199", "1");
/* 1082 */     localHashMap.put("183", "1");
/* 1083 */     localHashMap.put("33", "1");
/* 1084 */     localHashMap.put("15", "1");
/* 1085 */     localHashMap.put("21", "1");
/* 1086 */     localHashMap.put("353", "1");
/* 1087 */     localHashMap.put("354", "1");
/* 1088 */     localHashMap.put("41", "1");
/* 1089 */     localHashMap.put("42", "1");
/* 1090 */     localHashMap.put("319", "1");
/* 1091 */     localHashMap.put("22", "1");
/* 1092 */     localHashMap.put("82", "1");
/* 1093 */     localHashMap.put("93", "1");
/* 1094 */     localHashMap.put("312", "1");
/* 1095 */     localHashMap.put("264", "1");
/* 1096 */     localHashMap.put("164", "1");
/* 1097 */     localHashMap.put("177", "1");
/* 1098 */     localHashMap.put("156", "1");
/* 1099 */     localHashMap.put("1", "1");
/* 1100 */     localHashMap.put("221", "1");
/* 1101 */     localHashMap.put("277", "1");
/* 1102 */     localHashMap.put("4", "1");
/* 1103 */     localHashMap.put("871", "3");
/* 1104 */     localHashMap.put("872", "4");
/* 1105 */     localHashMap.put("45", "1");
/* 1106 */     localHashMap.put("44", "1");
/* 1107 */     localHashMap.put("231", "1");
/* 1108 */     localHashMap.put("230", "1");
/* 1109 */     localHashMap.put("239", "1");
/* 1110 */     localHashMap.put("2", "1");
/* 1111 */     localHashMap.put("241", "1");
/* 1112 */     localHashMap.put("96", "1");
/* 1113 */     localHashMap.put("100", "1");
/* 1114 */     localHashMap.put("7", "1");
/* 1115 */     localHashMap.put("97", "1");
/* 1116 */     localHashMap.put("98", "1");
/* 1117 */     localHashMap.put("9", "1");
/* 1118 */     localHashMap.put("27", "1");
/* 1119 */     localHashMap.put("99", "1");
/* 1120 */     localHashMap.put("95", "1");
/* 1121 */     localHashMap.put("8", "1");
/* 1122 */     localHashMap.put("5", "1");
/* 1123 */     localHashMap.put("90", "1");
/* 1124 */     localHashMap.put("6", "1");
/* 1125 */     localHashMap.put("91", "1");
/* 1126 */     localHashMap.put("94", "1");
/* 1127 */     localHashMap.put("101", "1");
/* 1128 */     localHashMap.put("210", "1");
/* 1129 */     localHashMap.put("3", "1");
/* 1130 */     localHashMap.put("278", "1");
/* 1131 */     localHashMap.put("31", "1");
/* 1132 */     localHashMap.put("46", "1");
/* 1133 */     localHashMap.put("39", "1");
/* 1134 */     localHashMap.put("279", "1");
/* 1135 */     localHashMap.put("351", "1");
/* 1136 */     localHashMap.put("352", "1");
/* 1137 */     localHashMap.put("178", "1");
/* 1138 */     localHashMap.put("251", "1");
/* 1139 */     localHashMap.put("50", "1");
/* 1140 */     localHashMap.put("10", "1");
/* 1141 */     localHashMap.put("28", "1");
/* 1142 */     localHashMap.put("160", "1");
/* 1143 */     localHashMap.put("261", "1");
/* 1144 */     localHashMap.put("20", "1");
/* 1145 */     localHashMap.put("850", "2");
/* 1146 */     localHashMap.put("853", "2");
/* 1147 */     localHashMap.put("852", "2");
/* 1148 */     localHashMap.put("851", "2");
/* 1149 */     localHashMap.put("854", "260");
/* 1150 */     localHashMap.put("865", "2");
/* 1151 */     localHashMap.put("866", "2");
/* 1152 */     localHashMap.put("864", "2");
/* 1153 */     localHashMap.put("862", "1");
/* 1154 */     localHashMap.put("868", "2");
/* 1155 */     localHashMap.put("992", "2");
/* 1156 */     localHashMap.put("867", "2");
/* 1157 */     localHashMap.put("860", "4");
/* 1158 */     localHashMap.put("861", "2");
/* 1159 */     localHashMap.put("863", "4");
/*      */ 
/* 1161 */     return localHashMap;
/*      */   }
/*      */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.sql.LxMetaData
 * JD-Core Version:    0.6.2
 */