/*     */ package oracle.sql;
/*     */ 
/*     */ import java.sql.Connection;
/*     */ import java.sql.SQLException;
/*     */ import oracle.jdbc.OracleCallableStatement;
/*     */ import oracle.jdbc.internal.OracleConnection;
/*     */ 
/*     */ public class LobPlsqlUtil
/*     */ {
/*  68 */   static boolean PLSQL_DEBUG = false;
/*     */   static final int MAX_PLSQL_SIZE = 32512;
/*     */   static final int MAX_PLSQL_INSTR_SIZE = 32512;
/*     */   static final int MAX_CHUNK_SIZE = 32512;
/* 979 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   public static long hasPattern(BLOB paramBLOB, byte[] paramArrayOfByte, long paramLong)
/*     */     throws SQLException
/*     */   {
/*  85 */     return hasPattern(paramBLOB.getInternalConnection(), paramBLOB, 2004, paramArrayOfByte, paramLong);
/*     */   }
/*     */ 
/*     */   public static long isSubLob(BLOB paramBLOB1, BLOB paramBLOB2, long paramLong)
/*     */     throws SQLException
/*     */   {
/*  94 */     return isSubLob(paramBLOB1.getInternalConnection(), paramBLOB1, 2004, paramBLOB2, paramLong);
/*     */   }
/*     */ 
/*     */   public static long hasPattern(CLOB paramCLOB, char[] paramArrayOfChar, long paramLong)
/*     */     throws SQLException
/*     */   {
/* 108 */     if ((paramArrayOfChar == null) || (paramLong <= 0L)) {
/* 109 */       return 0L;
/*     */     }
/* 111 */     OracleConnection localOracleConnection = paramCLOB.getInternalConnection();
/* 112 */     long l1 = paramArrayOfChar.length;
/* 113 */     long l2 = length(localOracleConnection, paramCLOB, 2005);
/*     */ 
/* 116 */     if ((l1 == 0L) || (l1 > l2 - paramLong + 1L) || (paramLong > l2))
/*     */     {
/* 118 */       return 0L;
/*     */     }
/*     */ 
/* 122 */     if (l1 <= getPlsqlMaxInstrSize(localOracleConnection))
/*     */     {
/* 126 */       OracleCallableStatement localOracleCallableStatement = null;
/*     */       try
/*     */       {
/* 130 */         localOracleCallableStatement = (OracleCallableStatement)localOracleConnection.prepareCall("begin :1 := dbms_lob.instr(:2, :3, :4); end;");
/*     */ 
/* 133 */         localOracleCallableStatement.registerOutParameter(1, 2);
/*     */ 
/* 135 */         if (paramCLOB.isNCLOB())
/*     */         {
/* 137 */           localOracleCallableStatement.setFormOfUse(2, (short)2);
/* 138 */           localOracleCallableStatement.setFormOfUse(3, (short)2);
/*     */         }
/*     */ 
/* 141 */         localOracleCallableStatement.setCLOB(2, paramCLOB);
/* 142 */         localOracleCallableStatement.setString(3, new String(paramArrayOfChar));
/* 143 */         localOracleCallableStatement.setLong(4, paramLong);
/* 144 */         localOracleCallableStatement.execute();
/*     */ 
/* 146 */         return localOracleCallableStatement.getLong(1);
/*     */       }
/*     */       finally
/*     */       {
/* 150 */         localOracleCallableStatement.close();
/*     */ 
/* 152 */         localOracleCallableStatement = null;
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 161 */     int i = 0;
/* 162 */     long l3 = paramLong;
/* 163 */     int j = 0;
/*     */ 
/* 166 */     long l5 = 0L;
/*     */ 
/* 169 */     while (j == 0)
/*     */     {
/* 171 */       if (l1 > l2 - l3 + 1L) {
/* 172 */         return 0L;
/*     */       }
/* 174 */       i = 0;
/*     */ 
/* 177 */       int k = (int)Math.min(getPlsqlMaxInstrSize(localOracleConnection), l1 - i);
/*     */ 
/* 181 */       char[] arrayOfChar = new char[k];
/*     */ 
/* 183 */       System.arraycopy(paramArrayOfChar, i, arrayOfChar, 0, k);
/*     */ 
/* 186 */       long l4 = hasPattern(paramCLOB, arrayOfChar, l3);
/*     */ 
/* 188 */       if (l4 == 0L)
/*     */       {
/* 190 */         return 0L;
/*     */       }
/*     */ 
/* 194 */       l5 = l4;
/*     */ 
/* 196 */       i += k;
/* 197 */       l3 = l4 + k;
/*     */ 
/* 200 */       int m = 1;
/*     */ 
/* 202 */       while (m != 0)
/*     */       {
/* 204 */         k = (int)Math.min(getPlsqlMaxInstrSize(localOracleConnection), l1 - i);
/*     */ 
/* 208 */         arrayOfChar = new char[k];
/*     */ 
/* 210 */         System.arraycopy(paramArrayOfChar, i, arrayOfChar, 0, k);
/*     */ 
/* 214 */         l4 = hasPattern(paramCLOB, arrayOfChar, l3);
/*     */ 
/* 216 */         if (l4 == l3)
/*     */         {
/* 220 */           i += k;
/* 221 */           l3 += k;
/*     */ 
/* 223 */           if (i == l1)
/*     */           {
/* 225 */             m = 0;
/* 226 */             j = 1;
/*     */           }
/*     */         } else {
/* 229 */           if (l4 == 0L)
/*     */           {
/* 234 */             return 0L;
/*     */           }
/*     */ 
/* 241 */           l3 = l4 - i;
/*     */ 
/* 243 */           m = 0;
/*     */         }
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 249 */     return l5;
/*     */   }
/*     */ 
/*     */   public static long isSubLob(CLOB paramCLOB1, CLOB paramCLOB2, long paramLong)
/*     */     throws SQLException
/*     */   {
/* 259 */     if ((paramCLOB2 == null) || (paramLong <= 0L)) {
/* 260 */       return 0L;
/*     */     }
/* 262 */     OracleConnection localOracleConnection = paramCLOB1.getInternalConnection();
/* 263 */     long l1 = length(localOracleConnection, paramCLOB2, 2005);
/* 264 */     long l2 = length(localOracleConnection, paramCLOB1, 2005);
/*     */ 
/* 267 */     if ((l1 == 0L) || (l1 > l2 - paramLong + 1L) || (paramLong > l2))
/*     */     {
/* 269 */       return 0L;
/*     */     }
/*     */ 
/* 273 */     if (l1 <= getPlsqlMaxInstrSize(localOracleConnection))
/*     */     {
/* 277 */       char[] arrayOfChar1 = new char[(int)l1];
/*     */ 
/* 279 */       paramCLOB2.getChars(1L, (int)l1, arrayOfChar1);
/*     */ 
/* 281 */       return hasPattern(paramCLOB1, arrayOfChar1, paramLong);
/*     */     }
/*     */ 
/* 289 */     int i = 0;
/* 290 */     long l3 = paramLong;
/* 291 */     int j = 0;
/*     */ 
/* 294 */     long l5 = 0L;
/*     */ 
/* 297 */     while (j == 0)
/*     */     {
/* 299 */       if (l1 > l2 - l3 + 1L) {
/* 300 */         return 0L;
/*     */       }
/* 302 */       i = 0;
/*     */ 
/* 305 */       int k = (int)Math.min(getPlsqlMaxInstrSize(localOracleConnection), l1 - i);
/*     */ 
/* 309 */       char[] arrayOfChar2 = new char[k];
/*     */ 
/* 311 */       paramCLOB2.getChars(i + 1, k, arrayOfChar2);
/*     */ 
/* 314 */       long l4 = hasPattern(paramCLOB1, arrayOfChar2, l3);
/*     */ 
/* 316 */       if (l4 == 0L)
/*     */       {
/* 318 */         return 0L;
/*     */       }
/*     */ 
/* 322 */       l5 = l4;
/*     */ 
/* 324 */       i += k;
/* 325 */       l3 = l4 + k;
/*     */ 
/* 328 */       int m = 1;
/*     */ 
/* 330 */       while (m != 0)
/*     */       {
/* 332 */         k = (int)Math.min(getPlsqlMaxInstrSize(localOracleConnection), l1 - i);
/*     */ 
/* 336 */         arrayOfChar2 = new char[k];
/*     */ 
/* 338 */         paramCLOB2.getChars(i + 1, k, arrayOfChar2);
/*     */ 
/* 341 */         l4 = hasPattern(paramCLOB1, arrayOfChar2, l3);
/*     */ 
/* 343 */         if (l4 == l3)
/*     */         {
/* 347 */           i += k;
/* 348 */           l3 += k;
/*     */ 
/* 350 */           if (i == l1)
/*     */           {
/* 352 */             m = 0;
/* 353 */             j = 1;
/*     */           }
/*     */         } else {
/* 356 */           if (l4 == 0L)
/*     */           {
/* 361 */             return 0L;
/*     */           }
/*     */ 
/* 368 */           l3 = l4 - i;
/*     */ 
/* 370 */           m = 0;
/*     */         }
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 376 */     return l5;
/*     */   }
/*     */ 
/*     */   public static long hasPattern(BFILE paramBFILE, byte[] paramArrayOfByte, long paramLong)
/*     */     throws SQLException
/*     */   {
/* 393 */     return hasPattern(paramBFILE.getInternalConnection(), paramBFILE, -13, paramArrayOfByte, paramLong);
/*     */   }
/*     */ 
/*     */   public static long isSubLob(BFILE paramBFILE1, BFILE paramBFILE2, long paramLong)
/*     */     throws SQLException
/*     */   {
/* 402 */     return isSubLob(paramBFILE1.getInternalConnection(), paramBFILE1, -13, paramBFILE2, paramLong);
/*     */   }
/*     */ 
/*     */   public static String fileGetName(BFILE paramBFILE)
/*     */     throws SQLException
/*     */   {
/* 410 */     OracleCallableStatement localOracleCallableStatement = null;
/* 411 */     String str = null;
/*     */     try
/*     */     {
/* 415 */       localOracleCallableStatement = (OracleCallableStatement)paramBFILE.getInternalConnection().prepareCall("begin dbms_lob.fileGetName(:1, :2, :3); end; ");
/*     */ 
/* 418 */       localOracleCallableStatement.setBFILE(1, paramBFILE);
/* 419 */       localOracleCallableStatement.registerOutParameter(2, 12);
/* 420 */       localOracleCallableStatement.registerOutParameter(3, 12);
/* 421 */       localOracleCallableStatement.execute();
/*     */ 
/* 423 */       str = localOracleCallableStatement.getString(3);
/*     */     }
/*     */     finally
/*     */     {
/* 427 */       if (localOracleCallableStatement != null)
/*     */       {
/* 429 */         localOracleCallableStatement.close();
/*     */ 
/* 431 */         localOracleCallableStatement = null;
/*     */       }
/*     */     }
/* 434 */     return str;
/*     */   }
/*     */ 
/*     */   public static String fileGetDirAlias(BFILE paramBFILE)
/*     */     throws SQLException
/*     */   {
/* 441 */     OracleCallableStatement localOracleCallableStatement = null;
/* 442 */     String str = null;
/*     */     try
/*     */     {
/* 446 */       localOracleCallableStatement = (OracleCallableStatement)paramBFILE.getInternalConnection().prepareCall("begin dbms_lob.fileGetName(:1, :2, :3); end; ");
/*     */ 
/* 449 */       localOracleCallableStatement.setBFILE(1, paramBFILE);
/* 450 */       localOracleCallableStatement.registerOutParameter(2, 12);
/* 451 */       localOracleCallableStatement.registerOutParameter(3, 12);
/* 452 */       localOracleCallableStatement.execute();
/*     */ 
/* 454 */       str = localOracleCallableStatement.getString(2);
/*     */     }
/*     */     finally
/*     */     {
/* 459 */       if (localOracleCallableStatement != null)
/*     */       {
/* 461 */         localOracleCallableStatement.close();
/*     */ 
/* 463 */         localOracleCallableStatement = null;
/*     */       }
/*     */     }
/* 466 */     return str;
/*     */   }
/*     */ 
/*     */   private static int getPlsqlMaxInstrSize(OracleConnection paramOracleConnection)
/*     */     throws SQLException
/*     */   {
/* 479 */     boolean bool = paramOracleConnection.isCharSetMultibyte(paramOracleConnection.getDriverCharSet());
/*     */ 
/* 481 */     int i = paramOracleConnection.getMaxCharbyteSize();
/*     */ 
/* 483 */     int j = 32512;
/*     */ 
/* 485 */     if (bool) {
/* 486 */       j = 32512 / (paramOracleConnection.getC2SNlsRatio() * i);
/*     */     }
/* 488 */     return j;
/*     */   }
/*     */ 
/*     */   public static long read(OracleConnection paramOracleConnection, Datum paramDatum, int paramInt, long paramLong1, long paramLong2, byte[] paramArrayOfByte)
/*     */     throws SQLException
/*     */   {
/* 496 */     OracleCallableStatement localOracleCallableStatement = null;
/* 497 */     int i = 0;
/*     */     try
/*     */     {
/* 501 */       localOracleCallableStatement = (OracleCallableStatement)paramOracleConnection.prepareCall("begin dbms_lob.read (:1, :2, :3, :4); end;");
/*     */ 
/* 504 */       int j = 0;
/* 505 */       int k = 0;
/*     */ 
/* 508 */       if (isNCLOB(paramDatum))
/*     */       {
/* 510 */         localOracleCallableStatement.setFormOfUse(1, (short)2);
/* 511 */         localOracleCallableStatement.setFormOfUse(4, (short)2);
/*     */       }
/*     */ 
/* 514 */       localOracleCallableStatement.setObject(1, paramDatum, paramInt);
/* 515 */       localOracleCallableStatement.registerOutParameter(2, 2);
/* 516 */       localOracleCallableStatement.registerOutParameter(4, -3);
/*     */ 
/* 518 */       while (i < paramLong2)
/*     */       {
/* 520 */         k = Math.min((int)paramLong2, 32512);
/*     */ 
/* 524 */         localOracleCallableStatement.setInt(2, k);
/* 525 */         localOracleCallableStatement.setInt(3, (int)paramLong1 + i);
/* 526 */         localOracleCallableStatement.execute();
/*     */ 
/* 528 */         j = localOracleCallableStatement.getInt(2);
/* 529 */         byte[] arrayOfByte = localOracleCallableStatement.getBytes(4);
/*     */ 
/* 534 */         j = Math.min(j, arrayOfByte.length);
/*     */ 
/* 536 */         System.arraycopy(arrayOfByte, 0, paramArrayOfByte, i, j);
/*     */ 
/* 541 */         i += j;
/* 542 */         paramLong2 -= j;
/*     */       }
/*     */ 
/*     */     }
/*     */     catch (SQLException localSQLException)
/*     */     {
/* 549 */       if (localSQLException.getErrorCode() != 1403)
/*     */       {
/* 553 */         throw localSQLException;
/*     */       }
/*     */ 
/*     */     }
/*     */     finally
/*     */     {
/* 563 */       if (localOracleCallableStatement != null)
/*     */       {
/* 565 */         localOracleCallableStatement.close();
/*     */ 
/* 567 */         localOracleCallableStatement = null;
/*     */       }
/*     */     }
/*     */ 
/* 571 */     return i;
/*     */   }
/*     */ 
/*     */   public static long length(OracleConnection paramOracleConnection, Datum paramDatum, int paramInt)
/*     */     throws SQLException
/*     */   {
/* 579 */     long l = 0L;
/* 580 */     OracleCallableStatement localOracleCallableStatement = null;
/*     */     try
/*     */     {
/* 584 */       localOracleCallableStatement = (OracleCallableStatement)paramOracleConnection.prepareCall("begin :1 := dbms_lob.getLength (:2); end;");
/*     */ 
/* 587 */       if (isNCLOB(paramDatum)) {
/* 588 */         localOracleCallableStatement.setFormOfUse(2, (short)2);
/*     */       }
/* 590 */       localOracleCallableStatement.setObject(2, paramDatum, paramInt);
/* 591 */       localOracleCallableStatement.registerOutParameter(1, 2);
/* 592 */       localOracleCallableStatement.execute();
/*     */ 
/* 594 */       l = localOracleCallableStatement.getLong(1);
/*     */     }
/*     */     finally
/*     */     {
/* 598 */       if (localOracleCallableStatement != null)
/*     */       {
/* 600 */         localOracleCallableStatement.close();
/*     */ 
/* 602 */         localOracleCallableStatement = null;
/*     */       }
/*     */     }
/*     */ 
/* 606 */     return l;
/*     */   }
/*     */ 
/*     */   public static long hasPattern(OracleConnection paramOracleConnection, Datum paramDatum, int paramInt, byte[] paramArrayOfByte, long paramLong)
/*     */     throws SQLException
/*     */   {
/* 616 */     if ((paramArrayOfByte == null) || (paramLong <= 0L)) {
/* 617 */       return 0L;
/*     */     }
/* 619 */     long l1 = paramArrayOfByte.length;
/* 620 */     long l2 = length(paramOracleConnection, paramDatum, paramInt);
/*     */ 
/* 623 */     if ((l1 == 0L) || (l1 > l2 - paramLong + 1L) || (paramLong > l2))
/*     */     {
/* 625 */       return 0L;
/*     */     }
/*     */ 
/* 629 */     if (l1 <= 32512L)
/*     */     {
/* 633 */       OracleCallableStatement localOracleCallableStatement = null;
/*     */       try
/*     */       {
/* 637 */         localOracleCallableStatement = (OracleCallableStatement)paramOracleConnection.prepareCall("begin :1 := dbms_lob.instr(:2, :3, :4); end;");
/*     */ 
/* 640 */         localOracleCallableStatement.registerOutParameter(1, 2);
/* 641 */         localOracleCallableStatement.setObject(2, paramDatum, paramInt);
/* 642 */         localOracleCallableStatement.setBytes(3, paramArrayOfByte);
/* 643 */         localOracleCallableStatement.setLong(4, paramLong);
/* 644 */         localOracleCallableStatement.execute();
/*     */ 
/* 646 */         return localOracleCallableStatement.getLong(1);
/*     */       }
/*     */       finally
/*     */       {
/* 650 */         localOracleCallableStatement.close();
/*     */ 
/* 652 */         localOracleCallableStatement = null;
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 661 */     int i = 0;
/* 662 */     long l3 = paramLong;
/* 663 */     int j = 0;
/*     */ 
/* 666 */     long l5 = 0L;
/*     */ 
/* 669 */     while (j == 0)
/*     */     {
/* 671 */       if (l1 > l2 - l3 + 1L) {
/* 672 */         return 0L;
/*     */       }
/* 674 */       i = 0;
/*     */ 
/* 677 */       int k = (int)Math.min(32512L, l1 - i);
/*     */ 
/* 681 */       byte[] arrayOfByte = new byte[k];
/*     */ 
/* 683 */       System.arraycopy(paramArrayOfByte, i, arrayOfByte, 0, k);
/*     */ 
/* 686 */       long l4 = hasPattern(paramOracleConnection, paramDatum, paramInt, arrayOfByte, l3);
/*     */ 
/* 688 */       if (l4 == 0L)
/*     */       {
/* 690 */         return 0L;
/*     */       }
/*     */ 
/* 694 */       l5 = l4;
/*     */ 
/* 696 */       i += k;
/* 697 */       l3 = l4 + k;
/*     */ 
/* 700 */       int m = 1;
/*     */ 
/* 702 */       while (m != 0)
/*     */       {
/* 704 */         k = (int)Math.min(32512L, l1 - i);
/*     */ 
/* 708 */         arrayOfByte = new byte[k];
/*     */ 
/* 710 */         System.arraycopy(paramArrayOfByte, i, arrayOfByte, 0, k);
/*     */ 
/* 714 */         l4 = hasPattern(paramOracleConnection, paramDatum, paramInt, arrayOfByte, l3);
/*     */ 
/* 717 */         if (l4 == l3)
/*     */         {
/* 721 */           i += k;
/* 722 */           l3 += k;
/*     */ 
/* 724 */           if (i == l1)
/*     */           {
/* 726 */             m = 0;
/* 727 */             j = 1;
/*     */           }
/*     */         } else {
/* 730 */           if (l4 == 0L)
/*     */           {
/* 735 */             return 0L;
/*     */           }
/*     */ 
/* 742 */           l3 = l4 - i;
/*     */ 
/* 744 */           m = 0;
/*     */         }
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 750 */     return l5;
/*     */   }
/*     */ 
/*     */   public static long isSubLob(OracleConnection paramOracleConnection, Datum paramDatum1, int paramInt, Datum paramDatum2, long paramLong)
/*     */     throws SQLException
/*     */   {
/* 760 */     if ((paramDatum2 == null) || (paramLong <= 0L)) {
/* 761 */       return 0L;
/*     */     }
/* 763 */     long l1 = length(paramOracleConnection, paramDatum2, paramInt);
/* 764 */     long l2 = length(paramOracleConnection, paramDatum1, paramInt);
/*     */ 
/* 766 */     if ((l1 == 0L) || (l1 > l2 - paramLong + 1L) || (paramLong > l2))
/*     */     {
/* 768 */       return 0L;
/*     */     }
/*     */ 
/* 772 */     if (l1 <= 32512L)
/*     */     {
/* 776 */       byte[] arrayOfByte1 = new byte[(int)l1];
/*     */ 
/* 778 */       read(paramOracleConnection, paramDatum2, paramInt, 1L, l1, arrayOfByte1);
/*     */ 
/* 780 */       return hasPattern(paramOracleConnection, paramDatum1, paramInt, arrayOfByte1, paramLong);
/*     */     }
/*     */ 
/* 788 */     int i = 0;
/* 789 */     long l3 = paramLong;
/* 790 */     int j = 0;
/*     */ 
/* 793 */     long l5 = 0L;
/*     */ 
/* 796 */     while (j == 0)
/*     */     {
/* 798 */       if (l1 > l2 - l3 + 1L) {
/* 799 */         return 0L;
/*     */       }
/* 801 */       i = 0;
/*     */ 
/* 804 */       int k = (int)Math.min(32512L, l1 - i);
/*     */ 
/* 808 */       byte[] arrayOfByte2 = new byte[k];
/*     */ 
/* 810 */       read(paramOracleConnection, paramDatum2, paramInt, i + 1, k, arrayOfByte2);
/*     */ 
/* 813 */       long l4 = hasPattern(paramOracleConnection, paramDatum1, paramInt, arrayOfByte2, l3);
/*     */ 
/* 815 */       if (l4 == 0L)
/*     */       {
/* 817 */         return 0L;
/*     */       }
/*     */ 
/* 821 */       l5 = l4;
/*     */ 
/* 823 */       i += k;
/* 824 */       l3 = l4 + k;
/*     */ 
/* 827 */       int m = 1;
/*     */ 
/* 829 */       while (m != 0)
/*     */       {
/* 831 */         k = (int)Math.min(32512L, l1 - i);
/*     */ 
/* 835 */         arrayOfByte2 = new byte[k];
/*     */ 
/* 837 */         read(paramOracleConnection, paramDatum2, paramInt, i + 1, k, arrayOfByte2);
/*     */ 
/* 840 */         l4 = hasPattern(paramOracleConnection, paramDatum1, paramInt, arrayOfByte2, l3);
/*     */ 
/* 843 */         if (l4 == l3)
/*     */         {
/* 847 */           i += k;
/* 848 */           l3 += k;
/*     */ 
/* 850 */           if (i == l1)
/*     */           {
/* 852 */             m = 0;
/* 853 */             j = 1;
/*     */           }
/*     */         } else {
/* 856 */           if (l4 == 0L)
/*     */           {
/* 861 */             return 0L;
/*     */           }
/*     */ 
/* 868 */           l3 = l4 - i;
/*     */ 
/* 870 */           m = 0;
/*     */         }
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 876 */     return l5;
/*     */   }
/*     */ 
/*     */   private static boolean isNCLOB(Datum paramDatum)
/*     */   {
/* 886 */     Class localClass = null;
/*     */     try
/*     */     {
/* 890 */       localClass = Class.forName("oracle.sql.CLOB");
/*     */     }
/*     */     catch (ClassNotFoundException localClassNotFoundException)
/*     */     {
/* 895 */       return false;
/*     */     }
/*     */ 
/* 898 */     if (!localClass.isInstance(paramDatum)) {
/* 899 */       return false;
/*     */     }
/* 901 */     CLOB localCLOB = (CLOB)paramDatum;
/*     */ 
/* 903 */     return localCLOB.isNCLOB();
/*     */   }
/*     */ 
/*     */   public static Datum createTemporaryLob(Connection paramConnection, boolean paramBoolean, int paramInt1, int paramInt2, short paramShort)
/*     */     throws SQLException
/*     */   {
/* 912 */     OracleCallableStatement localOracleCallableStatement = null;
/* 913 */     Datum localDatum = null;
/*     */     try
/*     */     {
/* 917 */       localOracleCallableStatement = (OracleCallableStatement)paramConnection.prepareCall(new StringBuilder().append("begin dbms_lob.createTemporary (:1,").append(paramBoolean ? "TRUE" : "FALSE").append(", :2); end;").toString());
/*     */ 
/* 921 */       localOracleCallableStatement.registerOutParameter(1, paramInt2);
/* 922 */       localOracleCallableStatement.setFormOfUse(1, paramShort);
/*     */ 
/* 925 */       localOracleCallableStatement.setInt(2, paramInt1);
/* 926 */       localOracleCallableStatement.execute();
/*     */ 
/* 928 */       localDatum = localOracleCallableStatement.getOracleObject(1);
/*     */     }
/*     */     finally
/*     */     {
/* 932 */       if (localOracleCallableStatement != null)
/*     */       {
/* 934 */         localOracleCallableStatement.close();
/*     */ 
/* 936 */         localOracleCallableStatement = null;
/*     */       }
/*     */     }
/*     */ 
/* 940 */     return localDatum;
/*     */   }
/*     */ 
/*     */   public static void freeTemporaryLob(Connection paramConnection, Datum paramDatum, int paramInt)
/*     */     throws SQLException
/*     */   {
/* 948 */     OracleCallableStatement localOracleCallableStatement = null;
/*     */     try
/*     */     {
/* 952 */       localOracleCallableStatement = (OracleCallableStatement)paramConnection.prepareCall("begin dbms_lob.freeTemporary (:1); end;");
/*     */ 
/* 955 */       localOracleCallableStatement.registerOutParameter(1, paramInt);
/*     */ 
/* 957 */       if (isNCLOB(paramDatum)) {
/* 958 */         localOracleCallableStatement.setFormOfUse(1, (short)2);
/*     */       }
/* 960 */       localOracleCallableStatement.setOracleObject(1, paramDatum);
/* 961 */       localOracleCallableStatement.execute();
/* 962 */       Datum localDatum = localOracleCallableStatement.getOracleObject(1);
/* 963 */       byte[] arrayOfByte = localDatum.shareBytes();
/* 964 */       paramDatum.setShareBytes(arrayOfByte);
/*     */     }
/*     */     finally
/*     */     {
/* 968 */       if (localOracleCallableStatement != null)
/*     */       {
/* 970 */         localOracleCallableStatement.close();
/*     */ 
/* 972 */         localOracleCallableStatement = null;
/*     */       }
/*     */     }
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.sql.LobPlsqlUtil
 * JD-Core Version:    0.6.2
 */