/*      */ package oracle.sql;
/*      */ 
/*      */ import java.sql.SQLException;
/*      */ import java.text.DecimalFormatSymbols;
/*      */ import java.util.Locale;
/*      */ import oracle.core.lmx.CoreException;
/*      */ import oracle.jdbc.driver.OracleLocale;
/*      */ 
/*      */ class LnxLibThin
/*      */   implements LnxLib
/*      */ {
/* 6529 */   private static final byte[] lnxqone = { -63, 2 };
/*      */ 
/* 6532 */   private static final byte[] lnxqtwo = { -63, 3 };
/*      */   private static final int LNXQACOS = 0;
/*      */   private static final int LNXQASIN = 1;
/*      */   private static final int LNXQATAN = 2;
/*      */   private static final int LNXQCOS = 3;
/*      */   private static final int LNXQSIN = 4;
/*      */   private static final int LNXQTAN = 5;
/*      */   private static final int LNXQCSH = 6;
/*      */   private static final int LNXQSNH = 7;
/*      */   private static final int LNXQTNH = 8;
/*      */   private static final int LNXQEXP = 9;
/*      */   private static final int LNXM_NUM = 22;
/*      */   private static final int LNXDIGS = 20;
/*      */   private static final int LNXSGNBT = 128;
/*      */   private static final int LNXEXPMX = 127;
/*      */   private static final int LNXEXPMN = 0;
/*      */   private static final int LNXEXPBS = 64;
/*      */   private static final int LNXBASE = 100;
/*      */   private static final int LNXMXFMT = 64;
/*      */   private static final int LNXMXOUT = 40;
/*      */   private static final int LNXDIV_LNXBASE_SQUARED = 10000;
/*      */   private static final int MINUB1MAXVAL = 255;
/*      */   private static final double ORANUM_FBASE = 100.0D;
/*      */   private static final int LNXQNOSGN = 127;
/*      */   private static final char LNXNFT_COMMA = ',';
/*      */   private static final int LNXBYTEMASK = 255;
/*      */   private static final int LNXSHORTMASK = 65535;
/* 6594 */   private static byte[] LnxqFirstDigit = { 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1 };
/*      */ 
/* 6601 */   private static byte[] LnxqNegate = { 0, 101, 100, 99, 98, 97, 96, 95, 94, 93, 92, 91, 90, 89, 88, 87, 86, 85, 84, 83, 82, 81, 80, 79, 78, 77, 76, 75, 74, 73, 72, 71, 70, 69, 68, 67, 66, 65, 64, 63, 62, 61, 60, 59, 58, 57, 56, 55, 54, 53, 52, 51, 50, 49, 48, 47, 46, 45, 44, 43, 42, 41, 40, 39, 38, 37, 36, 35, 34, 33, 32, 31, 30, 29, 28, 27, 26, 25, 24, 23, 22, 21, 20, 19, 18, 17, 16, 15, 14, 13, 12, 11, 10, 9, 8, 7, 6, 5, 4, 3, 2, 1 };
/*      */ 
/* 6609 */   private static byte[] LnxqTruncate_P = { 0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91 };
/*      */ 
/* 6616 */   private static byte[] LnxqTruncate_N = { 0, 0, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 101, 101, 101, 101, 101, 101, 101, 101, 101, 101 };
/*      */ 
/* 6624 */   private static byte[] LnxqRound_P = { 0, 1, 1, 1, 1, 1, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 101, 101, 101, 101, 101 };
/*      */ 
/* 6632 */   private static byte[] LnxqRound_N = { 0, 0, 1, 1, 1, 1, 1, 11, 11, 11, 11, 11, 11, 11, 11, 11, 11, 21, 21, 21, 21, 21, 21, 21, 21, 21, 21, 31, 31, 31, 31, 31, 31, 31, 31, 31, 31, 41, 41, 41, 41, 41, 41, 41, 41, 41, 41, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 61, 61, 61, 61, 61, 61, 61, 61, 61, 61, 71, 71, 71, 71, 71, 71, 71, 71, 71, 71, 81, 81, 81, 81, 81, 81, 81, 81, 81, 81, 91, 91, 91, 91, 91, 91, 91, 91, 91, 91, 101, 101, 101, 101, 101 };
/*      */ 
/* 6641 */   private static byte[][] LnxqComponents_P = { { 0, 0 }, { 0, 0 }, { 0, 1 }, { 0, 2 }, { 0, 3 }, { 0, 4 }, { 0, 5 }, { 0, 6 }, { 0, 7 }, { 0, 8 }, { 0, 9 }, { 1, 0 }, { 1, 1 }, { 1, 2 }, { 1, 3 }, { 1, 4 }, { 1, 5 }, { 1, 6 }, { 1, 7 }, { 1, 8 }, { 1, 9 }, { 2, 0 }, { 2, 1 }, { 2, 2 }, { 2, 3 }, { 2, 4 }, { 2, 5 }, { 2, 6 }, { 2, 7 }, { 2, 8 }, { 2, 9 }, { 3, 0 }, { 3, 1 }, { 3, 2 }, { 3, 3 }, { 3, 4 }, { 3, 5 }, { 3, 6 }, { 3, 7 }, { 3, 8 }, { 3, 9 }, { 4, 0 }, { 4, 1 }, { 4, 2 }, { 4, 3 }, { 4, 4 }, { 4, 5 }, { 4, 6 }, { 4, 7 }, { 4, 8 }, { 4, 9 }, { 5, 0 }, { 5, 1 }, { 5, 2 }, { 5, 3 }, { 5, 4 }, { 5, 5 }, { 5, 6 }, { 5, 7 }, { 5, 8 }, { 5, 9 }, { 6, 0 }, { 6, 1 }, { 6, 2 }, { 6, 3 }, { 6, 4 }, { 6, 5 }, { 6, 6 }, { 6, 7 }, { 6, 8 }, { 6, 9 }, { 7, 0 }, { 7, 1 }, { 7, 2 }, { 7, 3 }, { 7, 4 }, { 7, 5 }, { 7, 6 }, { 7, 7 }, { 7, 8 }, { 7, 9 }, { 8, 0 }, { 8, 1 }, { 8, 2 }, { 8, 3 }, { 8, 4 }, { 8, 5 }, { 8, 6 }, { 8, 7 }, { 8, 8 }, { 8, 9 }, { 9, 0 }, { 9, 1 }, { 9, 2 }, { 9, 3 }, { 9, 4 }, { 9, 5 }, { 9, 6 }, { 9, 7 }, { 9, 8 }, { 9, 9 } };
/*      */ 
/* 6746 */   private static byte[][] LnxqComponents_N = { { 0, 0 }, { 0, 0 }, { 9, 9 }, { 9, 8 }, { 9, 7 }, { 9, 6 }, { 9, 5 }, { 9, 4 }, { 9, 3 }, { 9, 2 }, { 9, 1 }, { 9, 0 }, { 8, 9 }, { 8, 8 }, { 8, 7 }, { 8, 6 }, { 8, 5 }, { 8, 4 }, { 8, 3 }, { 8, 2 }, { 8, 1 }, { 8, 0 }, { 7, 9 }, { 7, 8 }, { 7, 7 }, { 7, 6 }, { 7, 5 }, { 7, 4 }, { 7, 3 }, { 7, 2 }, { 7, 1 }, { 7, 0 }, { 6, 9 }, { 6, 8 }, { 6, 7 }, { 6, 6 }, { 6, 5 }, { 6, 4 }, { 6, 3 }, { 6, 2 }, { 6, 1 }, { 6, 0 }, { 5, 9 }, { 5, 8 }, { 5, 7 }, { 5, 6 }, { 5, 5 }, { 5, 4 }, { 5, 3 }, { 5, 2 }, { 5, 1 }, { 5, 0 }, { 4, 9 }, { 4, 8 }, { 4, 7 }, { 4, 6 }, { 4, 5 }, { 4, 4 }, { 4, 3 }, { 4, 2 }, { 4, 1 }, { 4, 0 }, { 3, 9 }, { 3, 8 }, { 3, 7 }, { 3, 6 }, { 3, 5 }, { 3, 4 }, { 3, 3 }, { 3, 2 }, { 3, 1 }, { 3, 0 }, { 2, 9 }, { 2, 8 }, { 2, 7 }, { 2, 6 }, { 2, 5 }, { 2, 4 }, { 2, 3 }, { 2, 2 }, { 2, 1 }, { 2, 0 }, { 1, 9 }, { 1, 8 }, { 1, 7 }, { 1, 6 }, { 1, 5 }, { 1, 4 }, { 1, 3 }, { 1, 2 }, { 1, 1 }, { 1, 0 }, { 0, 9 }, { 0, 8 }, { 0, 7 }, { 0, 6 }, { 0, 5 }, { 0, 4 }, { 0, 3 }, { 0, 2 }, { 0, 1 }, { 0, 0 } };
/*      */ 
/* 6852 */   private static byte[][] LnxqAdd_PPP = { { 0, 0 }, { 0, 1 }, { 1, 0 }, { 2, 0 }, { 3, 0 }, { 4, 0 }, { 5, 0 }, { 6, 0 }, { 7, 0 }, { 8, 0 }, { 9, 0 }, { 10, 0 }, { 11, 0 }, { 12, 0 }, { 13, 0 }, { 14, 0 }, { 15, 0 }, { 16, 0 }, { 17, 0 }, { 18, 0 }, { 19, 0 }, { 20, 0 }, { 21, 0 }, { 22, 0 }, { 23, 0 }, { 24, 0 }, { 25, 0 }, { 26, 0 }, { 27, 0 }, { 28, 0 }, { 29, 0 }, { 30, 0 }, { 31, 0 }, { 32, 0 }, { 33, 0 }, { 34, 0 }, { 35, 0 }, { 36, 0 }, { 37, 0 }, { 38, 0 }, { 39, 0 }, { 40, 0 }, { 41, 0 }, { 42, 0 }, { 43, 0 }, { 44, 0 }, { 45, 0 }, { 46, 0 }, { 47, 0 }, { 48, 0 }, { 49, 0 }, { 50, 0 }, { 51, 0 }, { 52, 0 }, { 53, 0 }, { 54, 0 }, { 55, 0 }, { 56, 0 }, { 57, 0 }, { 58, 0 }, { 59, 0 }, { 60, 0 }, { 61, 0 }, { 62, 0 }, { 63, 0 }, { 64, 0 }, { 65, 0 }, { 66, 0 }, { 67, 0 }, { 68, 0 }, { 69, 0 }, { 70, 0 }, { 71, 0 }, { 72, 0 }, { 73, 0 }, { 74, 0 }, { 75, 0 }, { 76, 0 }, { 77, 0 }, { 78, 0 }, { 79, 0 }, { 80, 0 }, { 81, 0 }, { 82, 0 }, { 83, 0 }, { 84, 0 }, { 85, 0 }, { 86, 0 }, { 87, 0 }, { 88, 0 }, { 89, 0 }, { 90, 0 }, { 91, 0 }, { 92, 0 }, { 93, 0 }, { 94, 0 }, { 95, 0 }, { 96, 0 }, { 97, 0 }, { 98, 0 }, { 99, 0 }, { 100, 0 }, { 1, 1 }, { 2, 1 }, { 3, 1 }, { 4, 1 }, { 5, 1 }, { 6, 1 }, { 7, 1 }, { 8, 1 }, { 9, 1 }, { 10, 1 }, { 11, 1 }, { 12, 1 }, { 13, 1 }, { 14, 1 }, { 15, 1 }, { 16, 1 }, { 17, 1 }, { 18, 1 }, { 19, 1 }, { 20, 1 }, { 21, 1 }, { 22, 1 }, { 23, 1 }, { 24, 1 }, { 25, 1 }, { 26, 1 }, { 27, 1 }, { 28, 1 }, { 29, 1 }, { 30, 1 }, { 31, 1 }, { 32, 1 }, { 33, 1 }, { 34, 1 }, { 35, 1 }, { 36, 1 }, { 37, 1 }, { 38, 1 }, { 39, 1 }, { 40, 1 }, { 41, 1 }, { 42, 1 }, { 43, 1 }, { 44, 1 }, { 45, 1 }, { 46, 1 }, { 47, 1 }, { 48, 1 }, { 49, 1 }, { 50, 1 }, { 51, 1 }, { 52, 1 }, { 53, 1 }, { 54, 1 }, { 55, 1 }, { 56, 1 }, { 57, 1 }, { 58, 1 }, { 59, 1 }, { 60, 1 }, { 61, 1 }, { 62, 1 }, { 63, 1 }, { 64, 1 }, { 65, 1 }, { 66, 1 }, { 67, 1 }, { 68, 1 }, { 69, 1 }, { 70, 1 }, { 71, 1 }, { 72, 1 }, { 73, 1 }, { 74, 1 }, { 75, 1 }, { 76, 1 }, { 77, 1 }, { 78, 1 }, { 79, 1 }, { 80, 1 }, { 81, 1 }, { 82, 1 }, { 83, 1 }, { 84, 1 }, { 85, 1 }, { 86, 1 }, { 87, 1 }, { 88, 1 }, { 89, 1 }, { 90, 1 }, { 91, 1 }, { 92, 1 }, { 93, 1 }, { 94, 1 }, { 95, 1 }, { 96, 1 }, { 97, 1 }, { 98, 1 }, { 99, 1 }, { 100, 1 } };
/*      */ 
/* 7061 */   private static byte[][] LnxqAdd_NNN = { { 0, 2 }, { 0, 1 }, { 0, 0 }, { 0, 0 }, { 0, 0 }, { 2, 1 }, { 3, 1 }, { 4, 1 }, { 5, 1 }, { 6, 1 }, { 7, 1 }, { 8, 1 }, { 9, 1 }, { 10, 1 }, { 11, 1 }, { 12, 1 }, { 13, 1 }, { 14, 1 }, { 15, 1 }, { 16, 1 }, { 17, 1 }, { 18, 1 }, { 19, 1 }, { 20, 1 }, { 21, 1 }, { 22, 1 }, { 23, 1 }, { 24, 1 }, { 25, 1 }, { 26, 1 }, { 27, 1 }, { 28, 1 }, { 29, 1 }, { 30, 1 }, { 31, 1 }, { 32, 1 }, { 33, 1 }, { 34, 1 }, { 35, 1 }, { 36, 1 }, { 37, 1 }, { 38, 1 }, { 39, 1 }, { 40, 1 }, { 41, 1 }, { 42, 1 }, { 43, 1 }, { 44, 1 }, { 45, 1 }, { 46, 1 }, { 47, 1 }, { 48, 1 }, { 49, 1 }, { 50, 1 }, { 51, 1 }, { 52, 1 }, { 53, 1 }, { 54, 1 }, { 55, 1 }, { 56, 1 }, { 57, 1 }, { 58, 1 }, { 59, 1 }, { 60, 1 }, { 61, 1 }, { 62, 1 }, { 63, 1 }, { 64, 1 }, { 65, 1 }, { 66, 1 }, { 67, 1 }, { 68, 1 }, { 69, 1 }, { 70, 1 }, { 71, 1 }, { 72, 1 }, { 73, 1 }, { 74, 1 }, { 75, 1 }, { 76, 1 }, { 77, 1 }, { 78, 1 }, { 79, 1 }, { 80, 1 }, { 81, 1 }, { 82, 1 }, { 83, 1 }, { 84, 1 }, { 85, 1 }, { 86, 1 }, { 87, 1 }, { 88, 1 }, { 89, 1 }, { 90, 1 }, { 91, 1 }, { 92, 1 }, { 93, 1 }, { 94, 1 }, { 95, 1 }, { 96, 1 }, { 97, 1 }, { 98, 1 }, { 99, 1 }, { 100, 1 }, { 101, 1 }, { 2, 2 }, { 3, 2 }, { 4, 2 }, { 5, 2 }, { 6, 2 }, { 7, 2 }, { 8, 2 }, { 9, 2 }, { 10, 2 }, { 11, 2 }, { 12, 2 }, { 13, 2 }, { 14, 2 }, { 15, 2 }, { 16, 2 }, { 17, 2 }, { 18, 2 }, { 19, 2 }, { 20, 2 }, { 21, 2 }, { 22, 2 }, { 23, 2 }, { 24, 2 }, { 25, 2 }, { 26, 2 }, { 27, 2 }, { 28, 2 }, { 29, 2 }, { 30, 2 }, { 31, 2 }, { 32, 2 }, { 33, 2 }, { 34, 2 }, { 35, 2 }, { 36, 2 }, { 37, 2 }, { 38, 2 }, { 39, 2 }, { 40, 2 }, { 41, 2 }, { 42, 2 }, { 43, 2 }, { 44, 2 }, { 45, 2 }, { 46, 2 }, { 47, 2 }, { 48, 2 }, { 49, 2 }, { 50, 2 }, { 51, 2 }, { 52, 2 }, { 53, 2 }, { 54, 2 }, { 55, 2 }, { 56, 2 }, { 57, 2 }, { 58, 2 }, { 59, 2 }, { 60, 2 }, { 61, 2 }, { 62, 2 }, { 63, 2 }, { 64, 2 }, { 65, 2 }, { 66, 2 }, { 67, 2 }, { 68, 2 }, { 69, 2 }, { 70, 2 }, { 71, 2 }, { 72, 2 }, { 73, 2 }, { 74, 2 }, { 75, 2 }, { 76, 2 }, { 77, 2 }, { 78, 2 }, { 79, 2 }, { 80, 2 }, { 81, 2 }, { 82, 2 }, { 83, 2 }, { 84, 2 }, { 85, 2 }, { 86, 2 }, { 87, 2 }, { 88, 2 }, { 89, 2 }, { 90, 2 }, { 91, 2 }, { 92, 2 }, { 93, 2 }, { 94, 2 }, { 95, 2 }, { 96, 2 }, { 97, 2 }, { 98, 2 }, { 99, 2 }, { 100, 2 }, { 101, 2 } };
/*      */ 
/* 7274 */   private static byte[][] LnxqAdd_PNP = { { 0, 2 }, { 0, 1 }, { 0, 0 }, { 0, 0 }, { 1, 1 }, { 2, 1 }, { 3, 1 }, { 4, 1 }, { 5, 1 }, { 6, 1 }, { 7, 1 }, { 8, 1 }, { 9, 1 }, { 10, 1 }, { 11, 1 }, { 12, 1 }, { 13, 1 }, { 14, 1 }, { 15, 1 }, { 16, 1 }, { 17, 1 }, { 18, 1 }, { 19, 1 }, { 20, 1 }, { 21, 1 }, { 22, 1 }, { 23, 1 }, { 24, 1 }, { 25, 1 }, { 26, 1 }, { 27, 1 }, { 28, 1 }, { 29, 1 }, { 30, 1 }, { 31, 1 }, { 32, 1 }, { 33, 1 }, { 34, 1 }, { 35, 1 }, { 36, 1 }, { 37, 1 }, { 38, 1 }, { 39, 1 }, { 40, 1 }, { 41, 1 }, { 42, 1 }, { 43, 1 }, { 44, 1 }, { 45, 1 }, { 46, 1 }, { 47, 1 }, { 48, 1 }, { 49, 1 }, { 50, 1 }, { 51, 1 }, { 52, 1 }, { 53, 1 }, { 54, 1 }, { 55, 1 }, { 56, 1 }, { 57, 1 }, { 58, 1 }, { 59, 1 }, { 60, 1 }, { 61, 1 }, { 62, 1 }, { 63, 1 }, { 64, 1 }, { 65, 1 }, { 66, 1 }, { 67, 1 }, { 68, 1 }, { 69, 1 }, { 70, 1 }, { 71, 1 }, { 72, 1 }, { 73, 1 }, { 74, 1 }, { 75, 1 }, { 76, 1 }, { 77, 1 }, { 78, 1 }, { 79, 1 }, { 80, 1 }, { 81, 1 }, { 82, 1 }, { 83, 1 }, { 84, 1 }, { 85, 1 }, { 86, 1 }, { 87, 1 }, { 88, 1 }, { 89, 1 }, { 90, 1 }, { 91, 1 }, { 92, 1 }, { 93, 1 }, { 94, 1 }, { 95, 1 }, { 96, 1 }, { 97, 1 }, { 98, 1 }, { 99, 1 }, { 100, 1 }, { 1, 2 }, { 2, 2 }, { 3, 2 }, { 4, 2 }, { 5, 2 }, { 6, 2 }, { 7, 2 }, { 8, 2 }, { 9, 2 }, { 10, 2 }, { 11, 2 }, { 12, 2 }, { 13, 2 }, { 14, 2 }, { 15, 2 }, { 16, 2 }, { 17, 2 }, { 18, 2 }, { 19, 2 }, { 20, 2 }, { 21, 2 }, { 22, 2 }, { 23, 2 }, { 24, 2 }, { 25, 2 }, { 26, 2 }, { 27, 2 }, { 28, 2 }, { 29, 2 }, { 30, 2 }, { 31, 2 }, { 32, 2 }, { 33, 2 }, { 34, 2 }, { 35, 2 }, { 36, 2 }, { 37, 2 }, { 38, 2 }, { 39, 2 }, { 40, 2 }, { 41, 2 }, { 42, 2 }, { 43, 2 }, { 44, 2 }, { 45, 2 }, { 46, 2 }, { 47, 2 }, { 48, 2 }, { 49, 2 }, { 50, 2 }, { 51, 2 }, { 52, 2 }, { 53, 2 }, { 54, 2 }, { 55, 2 }, { 56, 2 }, { 57, 2 }, { 58, 2 }, { 59, 2 }, { 60, 2 }, { 61, 2 }, { 62, 2 }, { 63, 2 }, { 64, 2 }, { 65, 2 }, { 66, 2 }, { 67, 2 }, { 68, 2 }, { 69, 2 }, { 70, 2 }, { 71, 2 }, { 72, 2 }, { 73, 2 }, { 74, 2 }, { 75, 2 }, { 76, 2 }, { 77, 2 }, { 78, 2 }, { 79, 2 }, { 80, 2 }, { 81, 2 }, { 82, 2 }, { 83, 2 }, { 84, 2 }, { 85, 2 }, { 86, 2 }, { 87, 2 }, { 88, 2 }, { 89, 2 }, { 90, 2 }, { 91, 2 }, { 92, 2 }, { 93, 2 }, { 94, 2 }, { 95, 2 }, { 96, 2 }, { 97, 2 }, { 98, 2 }, { 99, 2 }, { 100, 2 } };
/*      */ 
/* 7486 */   private static byte[][] LnxqAdd_PNN = { { 0, 0 }, { 0, 1 }, { 0, 0 }, { 2, 0 }, { 3, 0 }, { 4, 0 }, { 5, 0 }, { 6, 0 }, { 7, 0 }, { 8, 0 }, { 9, 0 }, { 10, 0 }, { 11, 0 }, { 12, 0 }, { 13, 0 }, { 14, 0 }, { 15, 0 }, { 16, 0 }, { 17, 0 }, { 18, 0 }, { 19, 0 }, { 20, 0 }, { 21, 0 }, { 22, 0 }, { 23, 0 }, { 24, 0 }, { 25, 0 }, { 26, 0 }, { 27, 0 }, { 28, 0 }, { 29, 0 }, { 30, 0 }, { 31, 0 }, { 32, 0 }, { 33, 0 }, { 34, 0 }, { 35, 0 }, { 36, 0 }, { 37, 0 }, { 38, 0 }, { 39, 0 }, { 40, 0 }, { 41, 0 }, { 42, 0 }, { 43, 0 }, { 44, 0 }, { 45, 0 }, { 46, 0 }, { 47, 0 }, { 48, 0 }, { 49, 0 }, { 50, 0 }, { 51, 0 }, { 52, 0 }, { 53, 0 }, { 54, 0 }, { 55, 0 }, { 56, 0 }, { 57, 0 }, { 58, 0 }, { 59, 0 }, { 60, 0 }, { 61, 0 }, { 62, 0 }, { 63, 0 }, { 64, 0 }, { 65, 0 }, { 66, 0 }, { 67, 0 }, { 68, 0 }, { 69, 0 }, { 70, 0 }, { 71, 0 }, { 72, 0 }, { 73, 0 }, { 74, 0 }, { 75, 0 }, { 76, 0 }, { 77, 0 }, { 78, 0 }, { 79, 0 }, { 80, 0 }, { 81, 0 }, { 82, 0 }, { 83, 0 }, { 84, 0 }, { 85, 0 }, { 86, 0 }, { 87, 0 }, { 88, 0 }, { 89, 0 }, { 90, 0 }, { 91, 0 }, { 92, 0 }, { 93, 0 }, { 94, 0 }, { 95, 0 }, { 96, 0 }, { 97, 0 }, { 98, 0 }, { 99, 0 }, { 100, 0 }, { 101, 0 }, { 2, 1 }, { 3, 1 }, { 4, 1 }, { 5, 1 }, { 6, 1 }, { 7, 1 }, { 8, 1 }, { 9, 1 }, { 10, 1 }, { 11, 1 }, { 12, 1 }, { 13, 1 }, { 14, 1 }, { 15, 1 }, { 16, 1 }, { 17, 1 }, { 18, 1 }, { 19, 1 }, { 20, 1 }, { 21, 1 }, { 22, 1 }, { 23, 1 }, { 24, 1 }, { 25, 1 }, { 26, 1 }, { 27, 1 }, { 28, 1 }, { 29, 1 }, { 30, 1 }, { 31, 1 }, { 32, 1 }, { 33, 1 }, { 34, 1 }, { 35, 1 }, { 36, 1 }, { 37, 1 }, { 38, 1 }, { 39, 1 }, { 40, 1 }, { 41, 1 }, { 42, 1 }, { 43, 1 }, { 44, 1 }, { 45, 1 }, { 46, 1 }, { 47, 1 }, { 48, 1 }, { 49, 1 }, { 50, 1 }, { 51, 1 }, { 52, 1 }, { 53, 1 }, { 54, 1 }, { 55, 1 }, { 56, 1 }, { 57, 1 }, { 58, 1 }, { 59, 1 }, { 60, 1 }, { 61, 1 }, { 62, 1 }, { 63, 1 }, { 64, 1 }, { 65, 1 }, { 66, 1 }, { 67, 1 }, { 68, 1 }, { 69, 1 }, { 70, 1 }, { 71, 1 }, { 72, 1 }, { 73, 1 }, { 74, 1 }, { 75, 1 }, { 76, 1 }, { 77, 1 }, { 78, 1 }, { 79, 1 }, { 80, 1 }, { 81, 1 }, { 82, 1 }, { 83, 1 }, { 84, 1 }, { 85, 1 }, { 86, 1 }, { 87, 1 }, { 88, 1 }, { 89, 1 }, { 90, 1 }, { 91, 1 }, { 92, 1 }, { 93, 1 }, { 94, 1 }, { 95, 1 }, { 96, 1 }, { 97, 1 }, { 98, 1 }, { 99, 1 }, { 100, 1 }, { 101, 1 } };
/*      */ 
/* 7697 */   private static byte[] LnxsubIdentity = { 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101 };
/*      */ 
/* 7717 */   private static byte[][] LnxqDigit_P = { { 1, 2, 3, 4, 5, 6, 7, 8, 9, 10 }, { 11, 12, 13, 14, 15, 16, 17, 18, 19, 20 }, { 21, 22, 23, 24, 25, 26, 27, 28, 29, 30 }, { 31, 32, 33, 34, 35, 36, 37, 38, 39, 40 }, { 41, 42, 43, 44, 45, 46, 47, 48, 49, 50 }, { 51, 52, 53, 54, 55, 56, 57, 58, 59, 60 }, { 61, 62, 63, 64, 65, 66, 67, 68, 69, 70 }, { 71, 72, 73, 74, 75, 76, 77, 78, 79, 80 }, { 81, 82, 83, 84, 85, 86, 87, 88, 89, 90 }, { 91, 92, 93, 94, 95, 96, 97, 98, 99, 100 } };
/*      */ 
/* 7735 */   private static byte[][] LnxqDigit_N = { { 101, 100, 99, 98, 97, 96, 95, 94, 93, 92 }, { 91, 90, 89, 88, 87, 86, 85, 84, 83, 82 }, { 81, 80, 79, 78, 77, 76, 75, 74, 73, 72 }, { 71, 70, 69, 68, 67, 66, 65, 64, 63, 62 }, { 61, 60, 59, 58, 57, 56, 55, 54, 53, 52 }, { 51, 50, 49, 48, 47, 46, 45, 44, 43, 42 }, { 41, 40, 39, 38, 37, 36, 35, 34, 33, 32 }, { 31, 30, 29, 28, 27, 26, 25, 24, 23, 22 }, { 21, 20, 19, 18, 17, 16, 15, 14, 13, 12 }, { 11, 10, 9, 8, 7, 6, 5, 4, 3, 2 } };
/*      */ 
/* 7749 */   private static final double[][] powerTable = { { 128.0D, 1.0E+256D, 1.0E-256D }, { 64.0D, 1.E+128D, 1.E-128D }, { 32.0D, 1.0E+064D, 1.0E-064D }, { 16.0D, 1.E+032D, 1.E-032D }, { 8.0D, 10000000000000000.0D, 1.0E-016D }, { 4.0D, 100000000.0D, 1.0E-008D }, { 2.0D, 10000.0D, 0.0001D }, { 1.0D, 100.0D, 0.01D } };
/*      */ 
/* 7762 */   private static final double[][] factorTable = { { 15.0D, 1.0E+030D, 1.E-030D }, { 14.0D, 1.0E+028D, 1.0E-028D }, { 13.0D, 1.0E+026D, 1.0E-026D }, { 12.0D, 1.0E+024D, 9.999999999999999E-025D }, { 11.0D, 1.0E+022D, 1.0E-022D }, { 10.0D, 1.0E+020D, 1.0E-020D }, { 9.0D, 1.0E+018D, 1.E-018D }, { 8.0D, 10000000000000000.0D, 1.0E-016D }, { 7.0D, 100000000000000.0D, 1.0E-014D }, { 6.0D, 1000000000000.0D, 1.0E-012D }, { 5.0D, 10000000000.0D, 1.0E-010D }, { 4.0D, 100000000.0D, 1.0E-008D }, { 3.0D, 1000000.0D, 1.0E-006D }, { 2.0D, 10000.0D, 0.0001D }, { 1.0D, 100.0D, 0.01D }, { 0.0D, 1.0D, 1.0D }, { -1.0D, 0.01D, 100.0D }, { -2.0D, 0.0001D, 10000.0D }, { -3.0D, 1.0E-006D, 1000000.0D }, { -4.0D, 1.0E-008D, 100000000.0D }, { -5.0D, 1.0E-010D, 10000000000.0D }, { -6.0D, 1.0E-012D, 1000000000000.0D }, { -7.0D, 1.0E-014D, 100000000000000.0D }, { -8.0D, 1.0E-016D, 10000000000000000.0D }, { -9.0D, 1.E-018D, 1.0E+018D }, { -10.0D, 1.0E-020D, 1.0E+020D }, { -11.0D, 1.0E-022D, 1.0E+022D }, { -12.0D, 9.999999999999999E-025D, 1.0E+024D }, { -13.0D, 1.0E-026D, 1.0E+026D }, { -14.0D, 1.0E-028D, 1.0E+028D }, { -15.0D, 1.E-030D, 1.0E+030D }, { -16.0D, 1.E-032D, 1.E+032D }, { -17.0D, 9.999999999999999E-035D, 1.0E+034D }, { -18.0D, 9.999999999999999E-037D, 1.0E+036D }, { -19.0D, 1.0E-038D, 1.0E+038D }, { -20.0D, 9.999999999999999E-041D, 1.0E+040D }, { -21.0D, 1.0E-042D, 1.0E+042D }, { -22.0D, 1.0E-044D, 1.E+044D }, { -23.0D, 1.0E-046D, 1.0E+046D }, { -24.0D, 1.0E-048D, 1.0E+048D }, { -25.0D, 1.0E-050D, 1.E+050D }, { -26.0D, 1.0E-052D, 1.0E+052D }, { -27.0D, 1.0E-054D, 1.E+054D }, { -28.0D, 1.0E-056D, 1.E+056D }, { -29.0D, 1.0E-058D, 9.999999999999999E+057D }, { -30.0D, 1.0E-060D, 1.0E+060D }, { -31.0D, 1.0E-062D, 1.0E+062D }, { -32.0D, 1.0E-064D, 1.0E+064D }, { -33.0D, 1.0E-066D, 1.0E+066D }, { -34.0D, 1.E-068D, 1.0E+068D } };
/*      */ 
/* 7822 */   private char[] lnx_chars = { '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '-', ' ', '.', ',', '$', '<', '>', '(', ')', '#', '~', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'i', 'l', 'm', 'p', 'r', 's', 't', 'v', 'A', 'B', 'C', 'D', 'E', 'F', 'I', 'L', 'M', 'P', 'R', 'S', 'T' };
/*      */ 
/*      */   public byte[] lnxabs(byte[] paramArrayOfByte)
/*      */     throws SQLException
/*      */   {
/*  107 */     byte[] arrayOfByte = new byte[paramArrayOfByte.length];
/*      */ 
/*  111 */     if (NUMBER._isPositive(paramArrayOfByte))
/*      */     {
/*  114 */       System.arraycopy(paramArrayOfByte, 0, arrayOfByte, 0, paramArrayOfByte.length);
/*  115 */       return arrayOfByte;
/*      */     }
/*      */ 
/*  119 */     if (NUMBER._isNegInf(paramArrayOfByte))
/*      */     {
/*  121 */       return NUMBER.posInf().shareBytes();
/*      */     }
/*      */ 
/*  125 */     int i = paramArrayOfByte.length;
/*  126 */     if (paramArrayOfByte[(i - 1)] == 102)
/*      */     {
/*  128 */       i--;
/*      */     }
/*      */ 
/*  131 */     System.arraycopy(paramArrayOfByte, 0, arrayOfByte, 0, i);
/*      */ 
/*  136 */     _negateNumber(arrayOfByte);
/*      */ 
/*  138 */     return _setLength(arrayOfByte, i);
/*      */   }
/*      */ 
/*      */   public byte[] lnxacos(byte[] paramArrayOfByte)
/*      */     throws SQLException
/*      */   {
/*  152 */     return lnxqtri(paramArrayOfByte, 0);
/*      */   }
/*      */ 
/*      */   public byte[] lnxadd(byte[] paramArrayOfByte1, byte[] paramArrayOfByte2)
/*      */     throws SQLException
/*      */   {
/*  160 */     int i = paramArrayOfByte1.length;
/*  161 */     int j = 0;
/*  162 */     int k = paramArrayOfByte2.length;
/*  163 */     int m = 0;
/*      */ 
/*  165 */     byte[] arrayOfByte1 = new byte[41];
/*  166 */     int n = 0;
/*      */ 
/*  173 */     int i5 = 0;
/*  174 */     int i6 = 0;
/*      */ 
/*  185 */     int i15 = 0;
/*  186 */     int i16 = 0;
/*  187 */     int i17 = 0;
/*      */ 
/*  204 */     int i9 = n + 1;
/*      */ 
/*  208 */     boolean bool1 = NUMBER._isPositive(paramArrayOfByte1);
/*  209 */     int i19 = paramArrayOfByte1[0] < 0 ? 256 + paramArrayOfByte1[0] : 255 - paramArrayOfByte1[0];
/*      */ 
/*  213 */     if (!bool1)
/*      */     {
/*  215 */       if (paramArrayOfByte1[(i - 1)] == 102) {
/*  216 */         i--;
/*      */       }
/*      */     }
/*  219 */     int i18 = i - 1;
/*      */ 
/*  223 */     boolean bool2 = NUMBER._isPositive(paramArrayOfByte2);
/*  224 */     int i21 = paramArrayOfByte2[0] < 0 ? 256 + paramArrayOfByte2[0] : 255 - paramArrayOfByte2[0];
/*      */ 
/*  226 */     if (!bool2)
/*      */     {
/*  228 */       if (paramArrayOfByte2[(k - 1)] == 102)
/*  229 */         k--;
/*      */     }
/*  231 */     int i20 = k - 1;
/*      */     boolean bool3;
/*  235 */     if ((i19 == 255) && ((i18 == 0) || (paramArrayOfByte1[1] == 101)))
/*      */     {
/*  239 */       bool3 = bool1;
/*      */ 
/*  241 */       if (bool3) {
/*  242 */         return NUMBER._makePosInf();
/*      */       }
/*  244 */       return NUMBER._makeNegInf();
/*      */     }
/*      */ 
/*  247 */     if ((i21 == 255) && ((i20 == 0) || (paramArrayOfByte2[1] == 101)))
/*      */     {
/*  251 */       bool3 = bool2;
/*      */ 
/*  253 */       if (bool3) {
/*  254 */         return NUMBER._makePosInf();
/*      */       }
/*  256 */       return NUMBER._makeNegInf();
/*      */     }
/*      */ 
/*  261 */     if ((i19 == 128) && (i18 == 0))
/*      */     {
/*  264 */       arrayOfByte1 = new byte[k];
/*  265 */       System.arraycopy(paramArrayOfByte2, 0, arrayOfByte1, 0, k);
/*  266 */       bool3 = bool2;
/*  267 */       i26 = k;
/*      */ 
/*  269 */       return _setLength(arrayOfByte1, i26);
/*      */     }
/*      */ 
/*  272 */     if ((i21 == 128) && (i20 == 0))
/*      */     {
/*  275 */       arrayOfByte1 = new byte[i];
/*  276 */       System.arraycopy(paramArrayOfByte1, 0, arrayOfByte1, 0, i);
/*  277 */       bool3 = bool1;
/*  278 */       i26 = i;
/*      */ 
/*  280 */       return _setLength(arrayOfByte1, i26);
/*      */     }
/*      */ 
/*  284 */     int i14 = i19 - i21;
/*      */     byte[][] arrayOfByte;
/*      */     int i24;
/*      */     int i25;
/*      */     int i27;
/*      */     int i28;
/*  309 */     if (bool1 == bool2)
/*      */     {
/*  314 */       bool3 = bool1;
/*      */ 
/*  317 */       if (bool3)
/*      */       {
/*  320 */         arrayOfByte = LnxqAdd_PPP;
/*  321 */         i24 = 1;
/*  322 */         i25 = 1;
/*      */       }
/*      */       else
/*      */       {
/*  327 */         arrayOfByte = LnxqAdd_NNN;
/*  328 */         i24 = 101;
/*  329 */         i25 = -1;
/*      */       }
/*      */ 
/*      */     }
/*      */     else
/*      */     {
/*  344 */       int i30 = i14;
/*      */ 
/*  347 */       if (i30 == 0)
/*      */       {
/*  351 */         i27 = j + 1;
/*  352 */         i28 = m + 1;
/*  353 */         int i29 = j + (i18 < i20 ? i18 : i20);
/*  354 */         while ((i27 <= i29) && (paramArrayOfByte1[i27] + paramArrayOfByte2[i28] == 102))
/*      */         {
/*  357 */           i27++;
/*  358 */           i28++;
/*      */         }
/*      */ 
/*  362 */         if (i27 <= i29)
/*      */         {
/*  365 */           i30 = bool1 ? paramArrayOfByte1[i27] + paramArrayOfByte2[i28] - 102 : 102 - (paramArrayOfByte1[i27] + paramArrayOfByte2[i28]);
/*      */         }
/*      */         else
/*      */         {
/*  373 */           i30 = i18 - i20;
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*  378 */       if (i30 == 0)
/*      */       {
/*  381 */         return NUMBER._makeZero();
/*      */       }
/*      */ 
/*  385 */       bool3 = i30 > 0 ? bool1 : bool2;
/*      */ 
/*  388 */       if (bool3)
/*      */       {
/*  391 */         arrayOfByte = LnxqAdd_PNP;
/*  392 */         i24 = 1;
/*  393 */         i25 = -1;
/*      */       }
/*      */       else
/*      */       {
/*  398 */         arrayOfByte = LnxqAdd_PNN;
/*  399 */         i24 = 101;
/*  400 */         i25 = 1;
/*      */       }
/*      */     }
/*      */     int i22;
/*      */     int i3;
/*      */     int i4;
/*      */     int i7;
/*      */     int i8;
/*      */     int i23;
/*      */     int i13;
/*  427 */     if (i14 >= 0)
/*      */     {
/*  432 */       i22 = i19;
/*      */ 
/*  435 */       if (i14 + i20 <= i18)
/*      */       {
/*  442 */         i15 = i14;
/*  443 */         i16 = i20;
/*  444 */         i17 = i18 - (i14 + i20);
/*      */ 
/*  447 */         i3 = j + i15;
/*  448 */         i4 = 1;
/*  449 */         i5 = i3 + i16;
/*  450 */         i6 = m + i20;
/*  451 */         i7 = j + i18;
/*  452 */         i8 = 1;
/*      */ 
/*  455 */         i23 = i18;
/*  456 */         i13 = (i17 != 0) && (bool1 != bool3) ? 1 : 0;
/*      */       }
/*  458 */       else if (i14 < i18)
/*      */       {
/*  465 */         i15 = i14;
/*  466 */         i16 = i18 - i14;
/*  467 */         i17 = i20 - i16;
/*      */ 
/*  470 */         i3 = j + i15;
/*  471 */         i4 = 1;
/*  472 */         i5 = j + i18;
/*  473 */         i6 = m + i16;
/*  474 */         i7 = m + i20;
/*  475 */         i8 = 2;
/*      */ 
/*  478 */         i23 = i14 + i20;
/*  479 */         i13 = bool2 != bool3 ? 1 : 0;
/*      */       }
/*      */       else
/*      */       {
/*  488 */         i15 = i18;
/*  489 */         i16 = -(i14 - i18);
/*  490 */         i17 = i20;
/*      */ 
/*  493 */         i3 = j + i18;
/*  494 */         i4 = 1;
/*  495 */         i7 = m + i20;
/*  496 */         i8 = 2;
/*      */ 
/*  499 */         i23 = i14 + i20;
/*  500 */         i13 = bool2 != bool3 ? 1 : 0;
/*      */       }
/*      */ 
/*      */     }
/*      */     else
/*      */     {
/*  508 */       i22 = i21;
/*      */ 
/*  511 */       i14 = -i14;
/*  512 */       if (i14 + i18 <= i20)
/*      */       {
/*  519 */         i15 = i14;
/*  520 */         i16 = i18;
/*  521 */         i17 = i20 - (i14 + i18);
/*      */ 
/*  524 */         i3 = m + i15;
/*  525 */         i4 = 2;
/*  526 */         i5 = j + i18;
/*  527 */         i6 = i3 + i16;
/*  528 */         i7 = m + i20;
/*  529 */         i8 = 2;
/*      */ 
/*  532 */         i23 = i20;
/*  533 */         i13 = (i17 != 0) && (bool2 != bool3) ? 1 : 0;
/*      */       }
/*  535 */       else if (i14 < i20)
/*      */       {
/*  542 */         i15 = i14;
/*  543 */         i16 = i20 - i14;
/*  544 */         i17 = i18 - i16;
/*      */ 
/*  547 */         i3 = m + i15;
/*  548 */         i4 = 2;
/*  549 */         i5 = j + i16;
/*  550 */         i6 = m + i20;
/*  551 */         i7 = j + i18;
/*  552 */         i8 = 1;
/*      */ 
/*  555 */         i23 = i14 + i18;
/*  556 */         i13 = bool1 != bool3 ? 1 : 0;
/*      */       }
/*      */       else
/*      */       {
/*  565 */         i15 = i20;
/*  566 */         i16 = -(i14 - i20);
/*  567 */         i17 = i18;
/*      */ 
/*  570 */         i3 = m + i20;
/*  571 */         i4 = 2;
/*  572 */         i7 = j + i18;
/*  573 */         i8 = 1;
/*      */ 
/*  576 */         i23 = i14 + i18;
/*  577 */         i13 = bool1 != bool3 ? 1 : 0;
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*  582 */     if (i23 > 20)
/*      */     {
/*  584 */       if (i14 > 20)
/*      */       {
/*  587 */         i16 = 0;
/*  588 */         i17 = 0;
/*  589 */         i23 = i15;
/*  590 */         i13 = 0;
/*      */       }
/*      */       else
/*      */       {
/*  594 */         i9 = 1;
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*  599 */     int i10 = i9 + (i23 - 1);
/*  600 */     int i11 = i10;
/*      */     int i12;
/*  611 */     if (i17 != 0)
/*      */     {
/*  614 */       i12 = i11 - i17;
/*      */ 
/*  617 */       if (i8 == 1)
/*  618 */         arrayOfByte1[i11] = paramArrayOfByte1[i7];
/*      */       else
/*  620 */         arrayOfByte1[i11] = paramArrayOfByte2[i7];
/*  621 */       i7--;
/*  622 */       i11--;
/*      */ 
/*  625 */       if (i13 != 0)
/*      */       {
/*  628 */         while (i11 > i12)
/*      */         {
/*  630 */           if (i8 == 1)
/*  631 */             arrayOfByte1[i11] = ((byte)(paramArrayOfByte1[i7] + i25));
/*      */           else
/*  633 */             arrayOfByte1[i11] = ((byte)(paramArrayOfByte2[i7] + i25));
/*  634 */           i7--;
/*  635 */           i11--;
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*  641 */       while (i11 > i12)
/*      */       {
/*  643 */         if (i8 == 1)
/*  644 */           arrayOfByte1[i11] = paramArrayOfByte1[i7];
/*      */         else
/*  646 */           arrayOfByte1[i11] = paramArrayOfByte2[i7];
/*  647 */         i7--;
/*  648 */         i11--;
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*  660 */     if (i16 > 0)
/*      */     {
/*  664 */       i12 = i11 - i16;
/*      */ 
/*  667 */       int i1 = 0;
/*  668 */       int i2 = i13 != 0 ? i1 + 1 : i1;
/*      */       do
/*      */       {
/*  673 */         i2 = i1 + paramArrayOfByte1[i5] + paramArrayOfByte2[i6] + arrayOfByte[i2][1];
/*      */ 
/*  676 */         arrayOfByte1[i11] = arrayOfByte[i2][0];
/*  677 */         i5--;
/*  678 */         i6--;
/*  679 */         i11--;
/*      */       }
/*  681 */       while (i11 > i12);
/*      */ 
/*  684 */       i13 = (arrayOfByte[i2][1] & 0x1) == 0 ? 0 : 1;
/*      */     }
/*      */     else
/*      */     {
/*  689 */       i27 = i13 != 0 ? 100 : i25 == 1 ? 2 : i24;
/*      */ 
/*  693 */       i12 = i11 + i16;
/*      */ 
/*  696 */       while (i11 > i12)
/*      */       {
/*  698 */         arrayOfByte1[i11] = ((byte)i27);
/*  699 */         i11--;
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*  711 */     if (i15 != 0)
/*      */     {
/*  714 */       i12 = i11 - i15;
/*      */ 
/*  717 */       if (i13 != 0)
/*      */       {
/*  720 */         i27 = (i25 == 1 ? 100 : 1) + (bool3 ? 0 : 1);
/*      */ 
/*  722 */         i28 = (i25 == 1 ? 1 : 100) + (bool3 ? 0 : 1);
/*      */         do
/*      */         {
/*  727 */           if (i4 == 1)
/*      */           {
/*  729 */             i13 = paramArrayOfByte1[i3] == i27 ? 1 : 0;
/*  730 */             arrayOfByte1[i11] = ((byte)(i13 != 0 ? i28 : paramArrayOfByte1[i3] + i25));
/*      */           }
/*      */           else
/*      */           {
/*  735 */             i13 = paramArrayOfByte2[i3] == i27 ? 1 : 0;
/*  736 */             arrayOfByte1[i11] = ((byte)(i13 != 0 ? i28 : paramArrayOfByte2[i3] + i25));
/*      */           }
/*      */ 
/*  739 */           i3--;
/*  740 */           i11--;
/*      */         }
/*  742 */         while ((i13 != 0) && (i11 > i12));
/*      */       }
/*      */ 
/*  746 */       while (i11 > i12)
/*      */       {
/*  748 */         if (i4 == 1)
/*  749 */           arrayOfByte1[i11] = paramArrayOfByte1[i3];
/*      */         else
/*  751 */           arrayOfByte1[i11] = paramArrayOfByte2[i3];
/*  752 */         i3--;
/*  753 */         i11--;
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*  762 */     if (i13 != 0)
/*      */     {
/*  766 */       if (i22 == 255)
/*      */       {
/*  768 */         if (bool3) {
/*  769 */           return NUMBER._makePosInf();
/*      */         }
/*  771 */         return NUMBER._makeNegInf();
/*      */       }
/*      */ 
/*  775 */       i9--;
/*  776 */       arrayOfByte1[i9] = ((byte)(bool3 ? 2 : 100));
/*  777 */       i22++;
/*  778 */       i23++;
/*      */     }
/*      */ 
/*  783 */     if (arrayOfByte1[i9] == i24)
/*      */     {
/*      */       do
/*      */       {
/*  788 */         i9++;
/*  789 */         i22--;
/*  790 */         i23--;
/*      */       }
/*  792 */       while (arrayOfByte1[i9] == i24);
/*      */ 
/*  795 */       if (i22 < 128) {
/*  796 */         return NUMBER._makeZero();
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*  804 */     if (i23 > 20)
/*      */     {
/*  807 */       i10 = i9 + 19;
/*  808 */       i23 = 20;
/*      */ 
/*  811 */       if ((bool3 ? arrayOfByte1[(i10 + 1)] : LnxqNegate[arrayOfByte1[(i10 + 1)]]) > 50)
/*      */       {
/*  815 */         i27 = bool3 ? 100 : 2;
/*      */ 
/*  818 */         if (i13 == 0) {
/*  819 */           arrayOfByte1[(i9 - 1)] = ((byte)i24);
/*      */         }
/*      */ 
/*  822 */         while (arrayOfByte1[i10] == i27)
/*      */         {
/*  824 */           i10--;
/*  825 */           i23--;
/*      */         }
/*      */ 
/*  828 */         if (i10 < i9)
/*      */         {
/*  830 */           if (i22 == 255)
/*      */           {
/*  832 */             if (bool3) {
/*  833 */               return NUMBER._makePosInf();
/*      */             }
/*  835 */             return NUMBER._makeNegInf();
/*      */           }
/*  837 */           i9--;
/*  838 */           i22++;
/*  839 */           i23 = 1;
/*      */         }
/*      */         int tmp1810_1808 = i10;
/*      */         byte[] tmp1810_1806 = arrayOfByte1; tmp1810_1806[tmp1810_1808] = ((byte)(tmp1810_1806[tmp1810_1808] + (bool3 ? 1 : -1)));
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*  848 */     while (arrayOfByte1[i10] == i24)
/*      */     {
/*  850 */       i10--;
/*  851 */       i23--;
/*      */     }
/*      */ 
/*  857 */     if (i9 != 1)
/*      */     {
/*  859 */       byte[] arrayOfByte2 = new byte[41];
/*  860 */       System.arraycopy(arrayOfByte1, i9, arrayOfByte2, 1, i23);
/*  861 */       System.arraycopy(arrayOfByte2, 1, arrayOfByte1, 1, i23);
/*      */     }
/*      */ 
/*  866 */     int i26 = i23 + 1;
/*      */ 
/*  868 */     if (!bool3)
/*      */     {
/*  872 */       if (i26 <= 20)
/*      */       {
/*  874 */         arrayOfByte1[i26] = 102;
/*  875 */         i26++;
/*      */       }
/*      */     }
/*      */ 
/*  879 */     arrayOfByte1[n] = ((byte)(bool3 ? i22 - 256 : 255 - i22));
/*  880 */     return _setLength(arrayOfByte1, i26);
/*      */   }
/*      */ 
/*      */   public byte[] lnxasin(byte[] paramArrayOfByte)
/*      */     throws SQLException
/*      */   {
/*  893 */     return lnxqtri(paramArrayOfByte, 1);
/*      */   }
/*      */ 
/*      */   public byte[] lnxatan(byte[] paramArrayOfByte)
/*      */     throws SQLException
/*      */   {
/*  905 */     return lnxqtri(paramArrayOfByte, 2);
/*      */   }
/*      */ 
/*      */   public byte[] lnxatan2(byte[] paramArrayOfByte1, byte[] paramArrayOfByte2)
/*      */     throws SQLException
/*      */   {
/*  925 */     if ((NUMBER._isZero(paramArrayOfByte1)) && (NUMBER._isZero(paramArrayOfByte2)))
/*      */     {
/*  928 */       throw new SQLException(CoreException.getMessage((byte)11));
/*      */     }
/*      */ 
/*  934 */     byte[] arrayOfByte1 = lnxdiv(paramArrayOfByte1, paramArrayOfByte2);
/*  935 */     arrayOfByte1 = lnxatan(arrayOfByte1);
/*      */ 
/*  937 */     if (NUMBER._isPositive(paramArrayOfByte2))
/*      */     {
/*  939 */       return arrayOfByte1;
/*      */     }
/*      */ 
/*  942 */     byte[] arrayOfByte2 = NUMBER.pi().shareBytes();
/*      */ 
/*  944 */     if (NUMBER._isPositive(paramArrayOfByte1))
/*      */     {
/*  947 */       return lnxadd(arrayOfByte1, arrayOfByte2);
/*      */     }
/*      */ 
/*  952 */     return lnxsub(arrayOfByte1, arrayOfByte2);
/*      */   }
/*      */ 
/*      */   public byte[] lnxbex(byte[] paramArrayOfByte1, byte[] paramArrayOfByte2)
/*      */     throws SQLException
/*      */   {
/*      */     byte[] arrayOfByte;
/*  967 */     switch (lnxsgn(paramArrayOfByte1))
/*      */     {
/*      */     case 1:
/*  970 */       arrayOfByte = lnxln(paramArrayOfByte1);
/*  971 */       arrayOfByte = lnxmul(paramArrayOfByte2, arrayOfByte);
/*  972 */       return lnxexp(arrayOfByte);
/*      */     case 0:
/*  975 */       if (NUMBER._isZero(paramArrayOfByte2))
/*      */       {
/*  978 */         arrayOfByte = new byte[lnxqone.length];
/*  979 */         System.arraycopy(lnxqone, 0, arrayOfByte, 0, lnxqone.length);
/*  980 */         return arrayOfByte;
/*      */       }
/*      */ 
/*  985 */       return NUMBER._makeZero();
/*      */     case -1:
/*  989 */       if (new NUMBER(paramArrayOfByte2).isInt())
/*      */       {
/*  993 */         arrayOfByte = lnxneg(paramArrayOfByte1);
/*  994 */         arrayOfByte = lnxln(arrayOfByte);
/*  995 */         arrayOfByte = lnxmul(paramArrayOfByte2, arrayOfByte);
/*  996 */         arrayOfByte = lnxexp(arrayOfByte);
/*      */ 
/*  999 */         if (!NUMBER._isZero(lnxmod(paramArrayOfByte2, lnxqtwo)))
/*      */         {
/* 1001 */           arrayOfByte = lnxneg(arrayOfByte);
/*      */         }
/* 1003 */         return arrayOfByte;
/*      */       }
/*      */ 
/* 1009 */       return NUMBER._makePosInf();
/*      */     }
/*      */ 
/* 1017 */     return null;
/*      */   }
/*      */ 
/*      */   public byte[] lnxcos(byte[] paramArrayOfByte)
/*      */     throws SQLException
/*      */   {
/* 1029 */     return lnxqtra(paramArrayOfByte, 3);
/*      */   }
/*      */ 
/*      */   public byte[] lnxcsh(byte[] paramArrayOfByte)
/*      */     throws SQLException
/*      */   {
/* 1041 */     return lnxqtra(paramArrayOfByte, 6);
/*      */   }
/*      */ 
/*      */   public byte[] lnxdec(byte[] paramArrayOfByte)
/*      */     throws SQLException
/*      */   {
/* 1052 */     int m = paramArrayOfByte.length;
/* 1053 */     byte[] arrayOfByte1 = new byte[22];
/*      */ 
/* 1055 */     System.arraycopy(paramArrayOfByte, 0, arrayOfByte1, 0, m);
/*      */ 
/* 1057 */     if (NUMBER._isPositive(arrayOfByte1))
/*      */     {
/* 1060 */       int i = (byte)((arrayOfByte1[0] & 0xFFFFFF7F) - 65);
/*      */ 
/* 1064 */       if ((i >= 0) && (i <= 18))
/*      */       {
/* 1070 */         int j = i + 1;
/* 1071 */         int k = m - 1;
/*      */ 
/* 1074 */         if (j <= k)
/*      */         {
/*      */           int tmp70_69 = j;
/*      */           byte[] tmp70_67 = arrayOfByte1; tmp70_67[tmp70_69] = ((byte)(tmp70_67[tmp70_69] - 1));
/*      */ 
/* 1080 */           if ((arrayOfByte1[j] == 1) && (j == k))
/*      */           {
/* 1082 */             m--;
/* 1083 */             if (m == 1)
/* 1084 */               return NUMBER._makeZero();
/*      */           }
/*      */         }
/*      */         else
/*      */         {
/*      */           int tmp107_105 = k;
/*      */           byte[] tmp107_103 = arrayOfByte1; tmp107_103[tmp107_105] = ((byte)(tmp107_103[tmp107_105] - 1));
/*      */ 
/* 1094 */           while (j > k)
/*      */           {
/* 1096 */             arrayOfByte1[j] = 100;
/* 1097 */             j--;
/*      */           }
/*      */ 
/* 1101 */           if (arrayOfByte1[1] == 1)
/*      */           {
/* 1103 */             for (int n = 1; n <= i; n++)
/* 1104 */               arrayOfByte1[n] = arrayOfByte1[(n + 1)];
/* 1105 */             i--;
/*      */           }
/*      */ 
/* 1109 */           m = i + 2;
/*      */         }
/*      */ 
/* 1114 */         arrayOfByte1[0] = ((byte)(i + 128 + 64 + 1));
/* 1115 */         byte[] arrayOfByte2 = new byte[m];
/* 1116 */         System.arraycopy(arrayOfByte1, 0, arrayOfByte2, 0, m);
/*      */ 
/* 1118 */         return arrayOfByte2;
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 1123 */     return NUMBER._makeZero();
/*      */   }
/*      */ 
/*      */   public byte[] lnxdiv(byte[] paramArrayOfByte1, byte[] paramArrayOfByte2)
/*      */     throws SQLException
/*      */   {
/* 1131 */     byte[] arrayOfByte1 = paramArrayOfByte1;
/* 1132 */     int i = arrayOfByte1.length;
/* 1133 */     byte[] arrayOfByte2 = paramArrayOfByte2;
/* 1134 */     int j = arrayOfByte2.length;
/* 1135 */     byte[] arrayOfByte3 = new byte[22];
/*      */ 
/* 1142 */     int[] arrayOfInt1 = new int[22];
/*      */ 
/* 1148 */     int[] arrayOfInt2 = new int[10];
/*      */ 
/* 1157 */     int[] arrayOfInt3 = new int[13];
/*      */ 
/* 1168 */     int n = arrayOfByte1[0] >> 7 != 0 ? 1 : 0;
/* 1169 */     int i1 = arrayOfByte1[0];
/*      */ 
/* 1171 */     if (n == 0)
/*      */     {
/* 1173 */       i1 = (byte)(i1 ^ 0xFFFFFFFF);
/* 1174 */       if (arrayOfByte1[(i - 1)] == 102) i--;
/*      */ 
/*      */     }
/*      */ 
/* 1179 */     int i4 = arrayOfByte2[0] >> 7 != 0 ? 1 : 0;
/* 1180 */     int i5 = arrayOfByte2[0];
/*      */ 
/* 1182 */     if (i4 == 0)
/*      */     {
/* 1184 */       i5 = (byte)(i5 ^ 0xFFFFFFFF);
/* 1185 */       if (arrayOfByte2[(j - 1)] == 102) j--;
/*      */ 
/*      */     }
/*      */ 
/* 1191 */     if (((i5 & 0xFF) == 128) && (j == 1))
/*      */     {
/* 1194 */       if (n == i4)
/*      */       {
/* 1196 */         return NUMBER._makePosInf();
/*      */       }
/* 1198 */       return NUMBER._makeNegInf();
/*      */     }
/*      */ 
/* 1202 */     if (((i1 & 0xFF) == 128) && (i == 1))
/*      */     {
/* 1205 */       return NUMBER._makeZero();
/*      */     }
/* 1209 */     int i17;
/* 1209 */     if (i == 1) i17 = 0; else i17 = 1;
/* 1210 */     if ((((i1 & 0xFF) == 255) && ((i == 2) || (arrayOfByte1[i17] == 101))) || ((i == 1) && (arrayOfByte1[0] == 0)))
/*      */     {
/* 1215 */       if (n == i4)
/*      */       {
/* 1217 */         return NUMBER._makePosInf();
/*      */       }
/*      */ 
/* 1220 */       return NUMBER._makeNegInf();
/*      */     }
/*      */ 
/* 1224 */     if (j == 1) i17 = 0; else i17 = 1;
/* 1225 */     if ((((i5 & 0xFF) == 255) && ((j == 2) || (arrayOfByte2[i17] == 101))) || ((j == 1) && (arrayOfByte2[0] == 0)))
/*      */     {
/* 1230 */       return NUMBER._makeZero();
/*      */     }
/*      */ 
/* 1246 */     int i2 = i / 2 - 1;
/* 1247 */     int i3 = 21;
/* 1248 */     int k = i - 2;
/*      */ 
/* 1250 */     while (i3 > i2)
/*      */     {
/* 1252 */       arrayOfInt1[i3] = 0;
/* 1253 */       i3--;
/*      */     }
/*      */ 
/* 1256 */     if (n != 0)
/*      */     {
/* 1259 */       if ((i & 0x1) == 0)
/*      */       {
/* 1261 */         arrayOfInt1[i3] = (arrayOfByte1[(k + 1)] * 100 - 100);
/* 1262 */         k--;
/* 1263 */         i3--;
/*      */       }
/*      */ 
/* 1266 */       while (k > 0)
/*      */       {
/* 1268 */         arrayOfInt1[i3] = (arrayOfByte1[k] * 100 + arrayOfByte1[(k + 1)] - 101);
/* 1269 */         k -= 2;
/* 1270 */         i3--;
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 1276 */     if ((i & 0x1) == 0)
/*      */     {
/* 1278 */       arrayOfInt1[i3] = (10100 - arrayOfByte1[(k + 1)] * 100);
/* 1279 */       k--;
/* 1280 */       i3--;
/*      */     }
/*      */ 
/* 1283 */     while (k > 0)
/*      */     {
/* 1285 */       arrayOfInt1[i3] = (10201 - (arrayOfByte1[k] * 100 + arrayOfByte1[(k + 1)]));
/* 1286 */       k -= 2;
/* 1287 */       i3--;
/*      */     }
/*      */ 
/* 1293 */     int i6 = j / 2 - 1;
/* 1294 */     int i7 = i6;
/* 1295 */     int m = j - 2;
/*      */ 
/* 1297 */     if (i4 != 0)
/*      */     {
/* 1300 */       if ((j & 0x1) == 0)
/*      */       {
/* 1302 */         arrayOfInt2[i7] = (arrayOfByte2[(m + 1)] * 100 - 100);
/* 1303 */         m--;
/* 1304 */         i7--;
/*      */       }
/*      */ 
/* 1307 */       while (m > 0)
/*      */       {
/* 1309 */         arrayOfInt2[i7] = (arrayOfByte2[m] * 100 + arrayOfByte2[(m + 1)] - 101);
/* 1310 */         m -= 2;
/* 1311 */         i7--;
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 1317 */     if ((j & 0x1) == 0)
/*      */     {
/* 1319 */       arrayOfInt2[i7] = (10100 - arrayOfByte2[(m + 1)] * 100);
/* 1320 */       m--;
/* 1321 */       i7--;
/*      */     }
/*      */ 
/* 1324 */     while (m > 0)
/*      */     {
/* 1326 */       arrayOfInt2[i7] = (10201 - (arrayOfByte2[m] * 100 + arrayOfByte2[(m + 1)]));
/* 1327 */       m -= 2;
/* 1328 */       i7--;
/*      */     }
/*      */ 
/* 1342 */     int i12 = 0;
/* 1343 */     int i13 = -1;
/*      */     int i20;
/* 1347 */     if (j <= 3)
/*      */     {
/* 1358 */       i3 = 0;
/*      */ 
/* 1362 */       int i18 = arrayOfInt1[0];
/* 1363 */       i20 = arrayOfInt2[0];
/*      */       do
/*      */       {
/* 1370 */         int i21 = i18 / i20;
/*      */ 
/* 1372 */         i3++;
/* 1373 */         i18 -= i21 * i20;
/* 1374 */         i18 = i18 * 10000 + arrayOfInt1[i3];
/*      */ 
/* 1376 */         i13++;
/* 1377 */         arrayOfInt3[i13] = i21;
/*      */ 
/* 1379 */         if ((i18 == 0) && (i3 >= i2)) break;
/*      */       }
/* 1381 */       while (i13 < 10 + (arrayOfInt3[0] == 0 ? 2 : 1));
/*      */     }
/*      */     else
/*      */     {
/* 1397 */       int i23 = 0;
/* 1398 */       int i24 = i6;
/*      */ 
/* 1402 */       double d1 = arrayOfInt1[i23] * 10000 + arrayOfInt1[(i23 + 1)];
/* 1403 */       double d2 = arrayOfInt2[0] * 10000 + arrayOfInt2[1];
/*      */       do
/*      */       {
/* 1410 */         int i22 = (int)(d1 / d2);
/*      */ 
/* 1412 */         if (i22 != 0)
/*      */         {
/* 1415 */           i3 = i23 + 2;
/* 1416 */           i7 = 2;
/* 1417 */           while (i3 <= i24)
/*      */           {
/* 1419 */             arrayOfInt1[i3] -= i22 * arrayOfInt2[i7];
/* 1420 */             i3++;
/* 1421 */             i7++;
/*      */           }
/*      */         }
/*      */ 
/* 1425 */         d1 -= i22 * d2;
/* 1426 */         d1 = d1 * 10000.0D + arrayOfInt1[(i23 + 2)];
/*      */ 
/* 1428 */         if (i22 >= 10000)
/*      */         {
/* 1430 */           i14 = i13;
/* 1431 */           while (arrayOfInt3[i14] == 9999)
/*      */           {
/* 1433 */             arrayOfInt3[i14] = 0;
/* 1434 */             i14--;
/*      */           }
/* 1436 */           arrayOfInt3[i14] += 1;
/* 1437 */           i22 -= 10000;
/*      */         }
/*      */ 
/* 1440 */         if (i22 < 0)
/*      */         {
/* 1442 */           i14 = i13;
/* 1443 */           while (arrayOfInt3[i14] == 0)
/*      */           {
/* 1445 */             arrayOfInt3[i14] = 9999;
/* 1446 */             i14--;
/*      */           }
/* 1448 */           arrayOfInt3[i14] -= 1;
/* 1449 */           i22 += 10000;
/*      */         }
/*      */ 
/* 1452 */         i13++;
/* 1453 */         arrayOfInt3[i13] = i22;
/*      */ 
/* 1456 */         if (i23 >= i2) if ((d1 < 0.0D ? -d1 : d1) < 0.1D)
/*      */           {
/* 1458 */             i3 = i23 + 2;
/* 1459 */             while ((i3 <= i24) && (arrayOfInt1[i3] == 0))
/*      */             {
/* 1461 */               i3++;
/*      */             }
/* 1463 */             if (i3 > i24)
/*      */             {
/*      */               break;
/*      */             }
/*      */           }
/*      */ 
/* 1469 */         i23++;
/* 1470 */         i24++;
/*      */       }
/* 1472 */       while (i13 < 10 + (arrayOfInt3[0] == 0 ? 2 : 1));
/*      */     }
/*      */ 
/* 1480 */     if (arrayOfInt3[0] == 0)
/*      */     {
/* 1482 */       i12++;
/*      */     }
/*      */ 
/* 1487 */     while (arrayOfInt3[i13] == 0)
/*      */     {
/* 1489 */       i13--;
/*      */     }
/*      */ 
/* 1494 */     int i15 = arrayOfInt3[i12] >= 100 ? 1 : 0;
/* 1495 */     int i16 = arrayOfInt3[i13] % 100 != 0 ? 1 : 0;
/*      */ 
/* 1497 */     int i10 = 2 * (i13 - i12) + i15 + i16;
/*      */ 
/* 1503 */     if (i10 > 20)
/*      */     {
/* 1507 */       if (i15 > 0)
/*      */       {
/* 1509 */         i13 = i12 + 9;
/* 1510 */         arrayOfInt3[i13] += (arrayOfInt3[(i13 + 1)] >= 5000 ? 1 : 0);
/*      */       }
/*      */       else
/*      */       {
/* 1514 */         i13 = i12 + 10;
/* 1515 */         arrayOfInt3[i13] = ((arrayOfInt3[i13] + 50) / 100 * 100);
/*      */       }
/*      */ 
/* 1520 */       if (arrayOfInt3[i13] == 10000)
/*      */       {
/*      */         do
/*      */         {
/* 1524 */           i13--;
/*      */         }
/* 1526 */         while (arrayOfInt3[i13] == 9999);
/* 1527 */         arrayOfInt3[i13] += 1;
/*      */       }
/*      */ 
/* 1531 */       if (arrayOfInt3[0] != 0)
/*      */       {
/* 1533 */         i12 = 0;
/*      */       }
/*      */ 
/* 1537 */       while (arrayOfInt3[i13] == 0)
/*      */       {
/* 1539 */         i13--;
/*      */       }
/*      */ 
/* 1543 */       i15 = arrayOfInt3[i12] >= 100 ? 1 : 0;
/* 1544 */       i16 = arrayOfInt3[i13] % 100 != 0 ? 1 : 0;
/* 1545 */       i10 = 2 * (i13 - i12) + i15 + i16;
/*      */     }
/*      */ 
/* 1551 */     int i8 = (i1 & 0xFF) - (i5 & 0xFF) - (arrayOfInt3[0] == 0 ? 1 : 0) + 193;
/*      */ 
/* 1556 */     if (i8 > 255)
/*      */     {
/* 1559 */       if (n == i4)
/*      */       {
/* 1561 */         return NUMBER._makePosInf();
/*      */       }
/* 1563 */       return NUMBER._makeNegInf();
/*      */     }
/*      */ 
/* 1567 */     if (i8 < 128)
/*      */     {
/* 1570 */       return NUMBER._makeZero();
/*      */     }
/*      */ 
/* 1584 */     int i9 = i10 + 1;
/* 1585 */     arrayOfByte3 = new byte[i9];
/*      */ 
/* 1589 */     int i11 = i10;
/* 1590 */     int i14 = i13;
/*      */ 
/* 1592 */     if (i16 == 0)
/*      */     {
/* 1595 */       arrayOfByte3[i11] = ((byte)(arrayOfInt3[i14] / 100 + 1));
/* 1596 */       i11--;
/*      */ 
/* 1598 */       i14--;
/*      */     }
/*      */     int i19;
/* 1602 */     while (i11 > 1)
/*      */     {
/* 1610 */       i19 = arrayOfInt3[i14] / 100;
/* 1611 */       i20 = arrayOfInt3[i14] - i19 * 100;
/* 1612 */       arrayOfByte3[i11] = ((byte)(i20 + 1));
/* 1613 */       i11--;
/* 1614 */       arrayOfByte3[i11] = ((byte)(i19 + 1));
/* 1615 */       i11--;
/*      */ 
/* 1618 */       i14--;
/*      */     }
/*      */ 
/* 1623 */     if (i15 == 0)
/*      */     {
/* 1626 */       arrayOfByte3[i11] = ((byte)(arrayOfInt3[i14] + 1));
/*      */     }
/*      */ 
/* 1631 */     arrayOfByte3[0] = ((byte)i8);
/*      */ 
/* 1636 */     if (n != i4)
/*      */     {
/* 1640 */       i9++;
/*      */       byte[] arrayOfByte4;
/* 1641 */       if (i9 > 20)
/*      */       {
/* 1643 */         arrayOfByte4 = new byte[21];
/* 1644 */         i9 = 21;
/*      */       }
/*      */       else {
/* 1647 */         arrayOfByte4 = new byte[i9];
/*      */       }
/* 1649 */       arrayOfByte4[0] = ((byte)(i8 ^ 0xFFFFFFFF));
/* 1650 */       for (i19 = 0; i19 < i9 - 2; i19++)
/*      */       {
/* 1652 */         arrayOfByte4[(i19 + 1)] = ((byte)(102 - arrayOfByte3[(i19 + 1)]));
/*      */       }
/* 1654 */       if (i9 <= 20) {
/* 1655 */         arrayOfByte4[(i9 - 1)] = 102;
/*      */       }
/* 1659 */       else if (arrayOfByte3.length == 20)
/* 1660 */         arrayOfByte4[(i9 - 1)] = 102;
/*      */       else {
/* 1662 */         arrayOfByte4[(i19 + 1)] = ((byte)(102 - arrayOfByte3[(i19 + 1)]));
/*      */       }
/* 1664 */       return arrayOfByte4;
/*      */     }
/*      */ 
/* 1667 */     return arrayOfByte3;
/*      */   }
/*      */ 
/*      */   public byte[] lnxexp(byte[] paramArrayOfByte)
/*      */     throws SQLException
/*      */   {
/* 1680 */     return lnxqtra(paramArrayOfByte, 9);
/*      */   }
/*      */ 
/*      */   public byte[] lnxflo(byte[] paramArrayOfByte)
/*      */     throws SQLException
/*      */   {
/* 1694 */     byte[] arrayOfByte = lnxtru(paramArrayOfByte, 0);
/*      */ 
/* 1700 */     if ((NUMBER.compareBytes(arrayOfByte, paramArrayOfByte) != 0) && (!NUMBER._isPositive(paramArrayOfByte))) {
/* 1701 */       arrayOfByte = lnxsub(arrayOfByte, lnxqone);
/*      */     }
/* 1703 */     return arrayOfByte;
/*      */   }
/*      */ 
/*      */   public byte[] lnxceil(byte[] paramArrayOfByte)
/*      */     throws SQLException
/*      */   {
/* 1717 */     byte[] arrayOfByte = lnxtru(paramArrayOfByte, 0);
/*      */ 
/* 1722 */     if ((NUMBER.compareBytes(arrayOfByte, paramArrayOfByte) != 0) && (NUMBER._isPositive(paramArrayOfByte))) {
/* 1723 */       arrayOfByte = lnxadd(arrayOfByte, lnxqone);
/*      */     }
/* 1725 */     return arrayOfByte;
/*      */   }
/*      */ 
/*      */   public byte[] lnxfpr(byte[] paramArrayOfByte, int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1743 */     int i3 = paramArrayOfByte.length;
/*      */ 
/* 1747 */     if (NUMBER._isZero(paramArrayOfByte))
/*      */     {
/* 1749 */       return NUMBER._makeZero();
/*      */     }
/* 1751 */     if (NUMBER._isNegInf(paramArrayOfByte))
/*      */     {
/* 1753 */       return NUMBER._makeNegInf();
/*      */     }
/* 1755 */     if (NUMBER._isPosInf(paramArrayOfByte))
/*      */     {
/* 1757 */       return NUMBER._makePosInf();
/*      */     }
/*      */ 
/* 1761 */     if (paramInt < 0)
/*      */     {
/* 1763 */       return NUMBER._makeZero();
/*      */     }
/*      */     boolean bool;
/*      */     int k;
/*      */     int m;
/*      */     int n;
/*      */     int i1;
/*      */     int i2;
/* 1766 */     if ((bool = NUMBER._isPositive(paramArrayOfByte)))
/*      */     {
/* 1768 */       paramInt += ((paramArrayOfByte[1] & 0xFF) < 11 ? 2 : 1);
/* 1769 */       k = paramInt >> 1;
/* 1770 */       m = (paramInt & 0x1) == 1 ? 1 : 0;
/* 1771 */       n = 1;
/* 1772 */       i1 = 100;
/* 1773 */       i2 = 1;
/*      */     }
/*      */     else
/*      */     {
/* 1777 */       paramInt += ((paramArrayOfByte[1] & 0xFF) > 91 ? 2 : 1);
/* 1778 */       k = paramInt >> 1;
/* 1779 */       m = (paramInt & 0x1) == 1 ? 1 : 0;
/* 1780 */       n = 101;
/* 1781 */       i1 = 2;
/* 1782 */       i2 = -1;
/* 1783 */       i3 -= ((paramArrayOfByte[(i3 - 1)] & 0xFF) == 102 ? 1 : 0);
/*      */     }
/*      */ 
/* 1787 */     byte[] arrayOfByte = new byte[i3];
/* 1788 */     System.arraycopy(paramArrayOfByte, 0, arrayOfByte, 0, i3);
/*      */ 
/* 1792 */     if ((k > i3 - 1) || ((k == i3 - 1) && ((m != 0) || (LnxqFirstDigit[paramArrayOfByte[k]] == 1))))
/*      */     {
/* 1796 */       return _setLength(paramArrayOfByte, i3);
/*      */     }
/*      */ 
/* 1802 */     if ((k != 0) || ((m != 0) && (bool ? paramArrayOfByte[1] >= 51 : paramArrayOfByte[1] <= 51))) {
/* 1802 */       if ((k != 1) || (m != 0) || (bool ? paramArrayOfByte[1] >= 6 : paramArrayOfByte[1] <= 96));
/*      */     }
/*      */     else {
/* 1806 */       return NUMBER._makeZero();
/*      */     }
/*      */ 
/* 1809 */     if (k == 0)
/*      */     {
/* 1812 */       if (NUMBER._isInf(paramArrayOfByte))
/*      */       {
/* 1814 */         if (bool)
/*      */         {
/* 1816 */           return NUMBER._makePosInf();
/*      */         }
/*      */ 
/* 1820 */         return NUMBER._makeNegInf();
/*      */       }
/*      */ 
/* 1824 */       arrayOfByte[0] = ((byte)(paramArrayOfByte[0] + i2));
/* 1825 */       arrayOfByte[1] = ((byte)(n + i2));
/*      */ 
/* 1827 */       return _setLength(arrayOfByte, 2);
/*      */     }
/*      */ 
/* 1830 */     int i = j = (byte)k;
/*      */ 
/* 1832 */     if (m != 0)
/*      */     {
/* 1835 */       if (bool ? paramArrayOfByte[(j + 1)] > 50 : paramArrayOfByte[(j + 1)] < 52)
/*      */       {
/* 1838 */         arrayOfByte[i] = ((byte)(paramArrayOfByte[j] + i2));
/*      */       }
/*      */       else
/*      */       {
/* 1843 */         arrayOfByte[i] = paramArrayOfByte[j];
/*      */       }
/*      */ 
/*      */     }
/*      */     else
/*      */     {
/* 1849 */       arrayOfByte[i] = (bool ? LnxqRound_P[paramArrayOfByte[j]] : LnxqRound_N[paramArrayOfByte[j]]);
/*      */     }
/*      */ 
/* 1852 */     int j = (byte)(j - 1);
/*      */     int i4;
/* 1856 */     if (arrayOfByte[i] == i1 + i2)
/*      */     {
/* 1861 */       while ((j > 0) && (paramArrayOfByte[j] == i1))
/*      */       {
/* 1863 */         j = (byte)(j - 1);
/*      */       }
/*      */ 
/* 1867 */       if (j == 0)
/*      */       {
/* 1870 */         if (NUMBER._isInf(paramArrayOfByte))
/*      */         {
/* 1872 */           if (bool)
/*      */           {
/* 1874 */             return NUMBER._makePosInf();
/*      */           }
/*      */ 
/* 1878 */           return NUMBER._makeNegInf();
/*      */         }
/*      */ 
/* 1882 */         arrayOfByte[0] = ((byte)(paramArrayOfByte[0] + i2));
/* 1883 */         arrayOfByte[1] = ((byte)(n + i2));
/*      */ 
/* 1885 */         return _setLength(arrayOfByte, 2);
/*      */       }
/*      */ 
/* 1889 */       arrayOfByte[j] = ((byte)(paramArrayOfByte[j] + i2));
/*      */ 
/* 1892 */       i4 = j + 1;
/*      */ 
/* 1895 */       j = (byte)(j - 1);
/*      */     }
/* 1897 */     else if (arrayOfByte[i] == n)
/*      */     {
/* 1902 */       while (paramArrayOfByte[j] == n)
/*      */       {
/* 1904 */         j = (byte)(j - 1);
/*      */       }
/*      */ 
/* 1908 */       i4 = j + 1;
/*      */     }
/*      */     else
/*      */     {
/* 1915 */       i4 = k + 1;
/*      */     }
/*      */ 
/* 1918 */     return _setLength(arrayOfByte, i4);
/*      */   }
/*      */ 
/*      */   public byte[] lnxinc(byte[] paramArrayOfByte)
/*      */     throws SQLException
/*      */   {
/* 1930 */     int n = paramArrayOfByte.length;
/* 1931 */     byte[] arrayOfByte1 = new byte[22];
/*      */ 
/* 1934 */     System.arraycopy(paramArrayOfByte, 0, arrayOfByte1, 0, n);
/* 1935 */     int i = 0;
/*      */ 
/* 1938 */     int m = (byte)((arrayOfByte1[0] & 0xFFFFFF7F) - 65);
/*      */ 
/* 1941 */     if ((m >= 0) && (m <= 18))
/*      */     {
/* 1947 */       int j = (byte)(m + 1);
/* 1948 */       int k = (byte)(n - 1);
/*      */ 
/* 1952 */       if (j <= k)
/*      */       {
/* 1956 */         if (arrayOfByte1[j] < 100)
/*      */         {
/*      */           int tmp79_78 = j;
/*      */           byte[] tmp79_76 = arrayOfByte1; tmp79_76[tmp79_78] = ((byte)(tmp79_76[tmp79_78] + 1));
/*      */         }
/*      */         else
/*      */         {
/* 1968 */           arrayOfByte1[i] = 0;
/*      */           do
/*      */           {
/* 1973 */             j = (byte)(j - 1);
/*      */           }
/* 1975 */           while (arrayOfByte1[j] == 100);
/*      */ 
/* 1978 */           if (j > i)
/*      */           {
/*      */             int tmp115_114 = j;
/*      */             byte[] tmp115_112 = arrayOfByte1; tmp115_112[tmp115_114] = ((byte)(tmp115_112[tmp115_114] + 1));
/*      */           }
/*      */           else
/*      */           {
/* 1986 */             m++;
/* 1987 */             j = (byte)(j + 1);
/* 1988 */             arrayOfByte1[j] = 2;
/*      */           }
/*      */ 
/* 1992 */           arrayOfByte1[i] = ((byte)(m + 128 + 64 + 1));
/*      */ 
/* 1995 */           n = j - i + 1;
/*      */         }
/*      */ 
/*      */       }
/*      */       else
/*      */       {
/* 2003 */         arrayOfByte1[j] = 2;
/*      */ 
/* 2006 */         j = (byte)(j - 1);
/* 2007 */         while (j > k)
/*      */         {
/* 2009 */           arrayOfByte1[j] = 1;
/* 2010 */           j = (byte)(j - 1);
/*      */         }
/*      */ 
/* 2014 */         n = m + 2;
/*      */       }
/*      */ 
/*      */     }
/*      */     else
/*      */     {
/* 2022 */       arrayOfByte1[0] = -63;
/* 2023 */       arrayOfByte1[1] = 2;
/*      */ 
/* 2026 */       n = 2;
/*      */     }
/*      */ 
/* 2030 */     byte[] arrayOfByte2 = new byte[n];
/* 2031 */     System.arraycopy(arrayOfByte1, 0, arrayOfByte2, 0, n);
/*      */ 
/* 2033 */     return arrayOfByte2;
/*      */   }
/*      */ 
/*      */   public byte[] lnxln(byte[] paramArrayOfByte)
/*      */     throws SQLException
/*      */   {
/* 2053 */     if (lnxsgn(paramArrayOfByte) <= 0) return NUMBER._makeNegInf();
/*      */ 
/* 2056 */     if (NUMBER._isPosInf(paramArrayOfByte)) return NUMBER._makePosInf();
/*      */ 
/* 2059 */     byte[] arrayOfByte1 = new byte[paramArrayOfByte.length];
/* 2060 */     System.arraycopy(paramArrayOfByte, 0, arrayOfByte1, 0, paramArrayOfByte.length);
/*      */ 
/* 2065 */     int i = (arrayOfByte1[0] & 0xFF) - 193;
/* 2066 */     arrayOfByte1[0] = -63;
/* 2067 */     double d1 = lnxnur(arrayOfByte1);
/*      */ 
/* 2070 */     double d2 = Math.log(d1);
/* 2071 */     byte[] arrayOfByte2 = NUMBER.toBytes(d2);
/*      */ 
/* 2085 */     byte[] arrayOfByte3 = lnxexp(arrayOfByte2);
/* 2086 */     byte[] arrayOfByte4 = lnxdiv(arrayOfByte1, arrayOfByte3);
/* 2087 */     arrayOfByte4 = lnxsub(arrayOfByte4, lnxqone);
/*      */ 
/* 2091 */     byte[] arrayOfByte5 = new byte[arrayOfByte4.length];
/* 2092 */     System.arraycopy(arrayOfByte4, 0, arrayOfByte5, 0, arrayOfByte4.length);
/*      */ 
/* 2095 */     byte[] arrayOfByte6 = lnxmul(arrayOfByte4, arrayOfByte4);
/*      */ 
/* 2097 */     int j = 1;
/* 2098 */     while ((arrayOfByte6[0] & 0xFF) > 172)
/*      */     {
/* 2100 */       j++;
/* 2101 */       arrayOfByte3 = lnxqIDiv(arrayOfByte6, j);
/* 2102 */       arrayOfByte5 = lnxsub(arrayOfByte5, arrayOfByte3);
/* 2103 */       arrayOfByte6 = lnxmul(arrayOfByte4, arrayOfByte6);
/* 2104 */       j++;
/* 2105 */       arrayOfByte3 = lnxqIDiv(arrayOfByte6, j);
/* 2106 */       arrayOfByte5 = lnxadd(arrayOfByte5, arrayOfByte3);
/* 2107 */       arrayOfByte6 = lnxmul(arrayOfByte4, arrayOfByte6);
/*      */     }
/*      */ 
/* 2120 */     i *= 2;
/*      */ 
/* 2127 */     byte[] arrayOfByte7 = NUMBER.ln10().shareBytes();
/* 2128 */     arrayOfByte4 = lnxmin(i);
/* 2129 */     arrayOfByte3 = lnxmul(arrayOfByte4, arrayOfByte7);
/*      */ 
/* 2131 */     arrayOfByte3 = lnxadd(arrayOfByte3, arrayOfByte2);
/* 2132 */     return lnxadd(arrayOfByte3, arrayOfByte5);
/*      */   }
/*      */ 
/*      */   public byte[] lnxlog(byte[] paramArrayOfByte1, byte[] paramArrayOfByte2)
/*      */     throws SQLException
/*      */   {
/* 2149 */     double d = NUMBER.toDouble(paramArrayOfByte2);
/*      */ 
/* 2153 */     if (d > 0.0D)
/*      */     {
/* 2159 */       if (d == 10.0D)
/*      */       {
/* 2162 */         arrayOfByte1 = lnxln(paramArrayOfByte1);
/* 2163 */         byte[] arrayOfByte3 = NUMBER.ln10().shareBytes();
/* 2164 */         return lnxdiv(arrayOfByte1, arrayOfByte3);
/*      */       }
/*      */ 
/* 2169 */       byte[] arrayOfByte1 = lnxln(paramArrayOfByte1);
/* 2170 */       byte[] arrayOfByte2 = lnxln(paramArrayOfByte2);
/* 2171 */       return lnxdiv(arrayOfByte1, arrayOfByte2);
/*      */     }
/*      */ 
/* 2177 */     return NUMBER._makeNegInf();
/*      */   }
/*      */ 
/*      */   public byte[] lnxmod(byte[] paramArrayOfByte1, byte[] paramArrayOfByte2)
/*      */     throws SQLException
/*      */   {
/* 2191 */     byte[] arrayOfByte1 = lnxdiv(paramArrayOfByte1, paramArrayOfByte2);
/*      */ 
/* 2194 */     byte[] arrayOfByte2 = lnxtru(arrayOfByte1, 0);
/*      */ 
/* 2196 */     arrayOfByte1 = lnxmul(paramArrayOfByte2, arrayOfByte2);
/* 2197 */     byte[] arrayOfByte3 = lnxsub(paramArrayOfByte1, arrayOfByte1);
/* 2198 */     return arrayOfByte3;
/*      */   }
/*      */ 
/*      */   public byte[] lnxmul(byte[] paramArrayOfByte1, byte[] paramArrayOfByte2)
/*      */     throws SQLException
/*      */   {
/* 2207 */     Object localObject1 = paramArrayOfByte1;
/* 2208 */     int i = localObject1.length;
/* 2209 */     Object localObject2 = paramArrayOfByte2;
/* 2210 */     int j = localObject2.length;
/* 2211 */     byte[] arrayOfByte1 = new byte[22];
/*      */ 
/* 2218 */     int[] arrayOfInt1 = new int[10];
/*      */ 
/* 2224 */     int[] arrayOfInt2 = new int[10];
/*      */ 
/* 2228 */     int i8 = 0;
/*      */ 
/* 2230 */     byte[] arrayOfByte2 = new byte[41];
/* 2231 */     int i10 = 0;
/*      */ 
/* 2233 */     int i12 = 0;
/*      */ 
/* 2238 */     int n = localObject1[0] >> 7 != 0 ? 1 : 0;
/* 2239 */     int i1 = localObject1[0];
/*      */ 
/* 2241 */     if (n == 0)
/*      */     {
/* 2243 */       i1 = (byte)(i1 ^ 0xFFFFFFFF);
/* 2244 */       if (localObject1[(i - 1)] == 102) i--;
/*      */ 
/*      */     }
/*      */ 
/* 2249 */     int i4 = localObject2[0] >> 7 != 0 ? 1 : 0;
/* 2250 */     int i5 = localObject2[0];
/*      */ 
/* 2252 */     if (i4 == 0)
/*      */     {
/* 2254 */       i5 = (byte)(i5 ^ 0xFFFFFFFF);
/* 2255 */       if (localObject2[(j - 1)] == 102) j--;
/*      */ 
/*      */     }
/*      */ 
/* 2261 */     if ((-i1 == 128) && (i == 1))
/*      */     {
/* 2265 */       arrayOfByte1 = NUMBER._makeZero();
/* 2266 */       return arrayOfByte1;
/*      */     }
/*      */ 
/* 2269 */     if ((-i5 == 128) && (j == 1))
/*      */     {
/* 2272 */       arrayOfByte1 = NUMBER._makeZero();
/* 2273 */       return arrayOfByte1;
/*      */     }
/*      */ 
/* 2278 */     if (((i1 & 0xFF) == 255) && ((i == 1) || (localObject1[1] == 101)))
/*      */     {
/* 2281 */       if (n == i4)
/*      */       {
/* 2283 */         arrayOfByte1 = NUMBER._makePosInf();
/*      */       }
/* 2285 */       else arrayOfByte1 = NUMBER._makeNegInf();
/*      */ 
/* 2287 */       return arrayOfByte1;
/*      */     }
/* 2289 */     if (((i5 & 0xFF) == 255) && ((j == 1) || (localObject2[1] == 101)))
/*      */     {
/* 2292 */       if (n == i4)
/*      */       {
/* 2294 */         arrayOfByte1 = NUMBER._makePosInf();
/*      */       }
/* 2296 */       else arrayOfByte1 = NUMBER._makeNegInf();
/*      */ 
/* 2299 */       return arrayOfByte1;
/*      */     }
/*      */ 
/* 2306 */     if (i > j)
/*      */     {
/* 2313 */       Object localObject3 = localObject1;
/* 2314 */       localObject1 = localObject2;
/* 2315 */       localObject2 = localObject3;
/*      */ 
/* 2318 */       int i14 = i;
/* 2319 */       i = j;
/* 2320 */       j = i14;
/*      */ 
/* 2323 */       int i15 = n;
/* 2324 */       n = i4;
/* 2325 */       i4 = i15;
/*      */     }
/*      */ 
/* 2331 */     int i2 = i / 2 - 1;
/* 2332 */     int i3 = i2;
/* 2333 */     int k = i - 2;
/*      */ 
/* 2335 */     if (n != 0)
/*      */     {
/* 2338 */       if ((i & 0x1) == 0)
/*      */       {
/* 2340 */         arrayOfInt1[i3] = (localObject1[(k + 1)] * 100 - 100);
/* 2341 */         k--;
/* 2342 */         i3--;
/*      */       }
/*      */ 
/* 2345 */       while (k > 0)
/*      */       {
/* 2347 */         arrayOfInt1[i3] = (localObject1[k] * 100 + localObject1[(k + 1)] - 101);
/* 2348 */         k -= 2;
/* 2349 */         i3--;
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 2355 */     if ((i & 0x1) == 0)
/*      */     {
/* 2357 */       arrayOfInt1[i3] = (10100 - localObject1[(k + 1)] * 100);
/* 2358 */       k--;
/* 2359 */       i3--;
/*      */     }
/*      */ 
/* 2362 */     while (k > 0)
/*      */     {
/* 2364 */       arrayOfInt1[i3] = (10201 - (localObject1[k] * 100 + localObject1[(k + 1)]));
/* 2365 */       k -= 2;
/* 2366 */       i3--;
/*      */     }
/*      */ 
/* 2372 */     int i6 = j / 2 - 1;
/* 2373 */     int i7 = i6;
/* 2374 */     int m = j - 2;
/*      */ 
/* 2376 */     if (i4 != 0)
/*      */     {
/* 2379 */       if ((j & 0x1) == 0)
/*      */       {
/* 2381 */         arrayOfInt2[i7] = (localObject2[(m + 1)] * 100 - 100);
/* 2382 */         m--;
/* 2383 */         i7--;
/*      */       }
/*      */ 
/* 2386 */       while (m > 0)
/*      */       {
/* 2388 */         arrayOfInt2[i7] = (localObject2[m] * 100 + localObject2[(m + 1)] - 101);
/* 2389 */         m -= 2;
/* 2390 */         i7--;
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 2396 */     if ((j & 0x1) == 0)
/*      */     {
/* 2398 */       arrayOfInt2[i7] = (10100 - localObject2[(m + 1)] * 100);
/* 2399 */       m--;
/* 2400 */       i7--;
/*      */     }
/*      */ 
/* 2403 */     while (m > 0)
/*      */     {
/* 2405 */       arrayOfInt2[i7] = (10201 - (localObject2[m] * 100 + localObject2[(m + 1)]));
/* 2406 */       m -= 2;
/* 2407 */       i7--;
/*      */     }
/*      */     int i9;
/* 2413 */     if (arrayOfInt1[0] * arrayOfInt2[0] < 1000000)
/*      */     {
/* 2415 */       i8 = (short)((i1 & 0xFF) + (i5 & 0xFF) - 193);
/* 2416 */       i9 = (i & 0xFE) + (j & 0xFE);
/*      */     }
/*      */     else
/*      */     {
/* 2420 */       i8 = (short)((i1 & 0xFF) + (i5 & 0xFF) - 192);
/* 2421 */       i9 = (i & 0xFE) + (j & 0xFE) + 1;
/*      */     }
/*      */ 
/* 2426 */     i10 = 1;
/* 2427 */     int i11 = i9;
/*      */ 
/* 2431 */     if (i <= 3)
/*      */     {
/* 2437 */       i12 = arrayOfInt1[0] * arrayOfInt2[i6];
/*      */ 
/* 2439 */       i12 = LnxmulSetDigit1(arrayOfByte2, i11, i12); i11 -= 2;
/*      */ 
/* 2442 */       i7 = i6 - 1;
/*      */ 
/* 2444 */       while (i7 >= 0)
/*      */       {
/* 2447 */         i12 += arrayOfInt1[0] * arrayOfInt2[i7];
/* 2448 */         i12 = LnxmulSetDigit1(arrayOfByte2, i11, i12); i11 -= 2;
/*      */ 
/* 2450 */         i7--;
/*      */       }
/*      */ 
/* 2454 */       LnxmulSetDigit2(arrayOfByte2, i11, i12); i11 -= 2;
/*      */     }
/*      */     else
/*      */     {
/* 2464 */       i12 += arrayOfInt1[i2] * arrayOfInt2[i6];
/*      */ 
/* 2466 */       i12 = LnxmulSetDigit1(arrayOfByte2, i11, i12); i11 -= 2;
/*      */ 
/* 2470 */       i7 = i6 - 1;
/*      */ 
/* 2472 */       while (i7 > i6 - (i / 2 - 1))
/*      */       {
/* 2475 */         switch (i6 - i7 + 1) {
/*      */         case 9:
/* 2477 */           i12 = LnxmulSetSum(arrayOfInt1, arrayOfInt2, i2, i7, 8, i12);
/*      */         case 8:
/* 2479 */           i12 = LnxmulSetSum(arrayOfInt1, arrayOfInt2, i2, i7, 7, i12);
/*      */         case 7:
/* 2481 */           i12 = LnxmulSetSum(arrayOfInt1, arrayOfInt2, i2, i7, 6, i12);
/*      */         case 6:
/* 2483 */           i12 = LnxmulSetSum(arrayOfInt1, arrayOfInt2, i2, i7, 5, i12);
/*      */         case 5:
/* 2485 */           i12 = LnxmulSetSum(arrayOfInt1, arrayOfInt2, i2, i7, 4, i12);
/*      */         case 4:
/* 2487 */           i12 = LnxmulSetSum(arrayOfInt1, arrayOfInt2, i2, i7, 3, i12);
/*      */         case 3:
/* 2489 */           i12 = LnxmulSetSum(arrayOfInt1, arrayOfInt2, i2, i7, 2, i12);
/*      */         case 2:
/* 2491 */           i12 = LnxmulSetSum(arrayOfInt1, arrayOfInt2, i2, i7, 1, i12);
/*      */         }
/* 2493 */         i12 = LnxmulSetSum(arrayOfInt1, arrayOfInt2, i2, i7, 0, i12);
/*      */ 
/* 2498 */         i12 = LnxmulSetDigit1(arrayOfByte2, i11, i12); i11 -= 2;
/*      */ 
/* 2500 */         i7--;
/*      */       }
/*      */ 
/*      */       do
/*      */       {
/* 2506 */         switch (i / 2)
/*      */         {
/*      */         case 10:
/* 2509 */           i12 = LnxmulSetSum(arrayOfInt1, arrayOfInt2, i2, i7, 9, i12);
/*      */         case 9:
/* 2510 */           i12 = LnxmulSetSum(arrayOfInt1, arrayOfInt2, i2, i7, 8, i12);
/*      */         case 8:
/* 2511 */           i12 = LnxmulSetSum(arrayOfInt1, arrayOfInt2, i2, i7, 7, i12);
/*      */         case 7:
/* 2512 */           i12 = LnxmulSetSum(arrayOfInt1, arrayOfInt2, i2, i7, 6, i12);
/*      */         case 6:
/* 2513 */           i12 = LnxmulSetSum(arrayOfInt1, arrayOfInt2, i2, i7, 5, i12);
/*      */         case 5:
/* 2514 */           i12 = LnxmulSetSum(arrayOfInt1, arrayOfInt2, i2, i7, 4, i12);
/*      */         case 4:
/* 2515 */           i12 = LnxmulSetSum(arrayOfInt1, arrayOfInt2, i2, i7, 3, i12);
/*      */         case 3:
/* 2516 */           i12 = LnxmulSetSum(arrayOfInt1, arrayOfInt2, i2, i7, 2, i12);
/*      */         case 2:
/* 2517 */           i12 = LnxmulSetSum(arrayOfInt1, arrayOfInt2, i2, i7, 1, i12);
/* 2518 */         }i12 = LnxmulSetSum(arrayOfInt1, arrayOfInt2, i2, i7, 0, i12);
/*      */ 
/* 2522 */         i12 = LnxmulSetDigit1(arrayOfByte2, i11, i12); i11 -= 2;
/*      */ 
/* 2525 */         i7--;
/*      */       }
/*      */ 
/* 2528 */       while (i7 >= 0);
/*      */ 
/* 2532 */       i3 = i2 - 1;
/*      */ 
/* 2534 */       while (i3 > 0)
/*      */       {
/* 2538 */         switch (i3 + 1) {
/*      */         case 9:
/* 2540 */           i12 = LnxmulSetSum(arrayOfInt1, arrayOfInt2, i3, 0, 8, i12);
/*      */         case 8:
/* 2541 */           i12 = LnxmulSetSum(arrayOfInt1, arrayOfInt2, i3, 0, 7, i12);
/*      */         case 7:
/* 2542 */           i12 = LnxmulSetSum(arrayOfInt1, arrayOfInt2, i3, 0, 6, i12);
/*      */         case 6:
/* 2543 */           i12 = LnxmulSetSum(arrayOfInt1, arrayOfInt2, i3, 0, 5, i12);
/*      */         case 5:
/* 2544 */           i12 = LnxmulSetSum(arrayOfInt1, arrayOfInt2, i3, 0, 4, i12);
/*      */         case 4:
/* 2545 */           i12 = LnxmulSetSum(arrayOfInt1, arrayOfInt2, i3, 0, 3, i12);
/*      */         case 3:
/* 2546 */           i12 = LnxmulSetSum(arrayOfInt1, arrayOfInt2, i3, 0, 2, i12);
/*      */         case 2:
/* 2547 */           i12 = LnxmulSetSum(arrayOfInt1, arrayOfInt2, i3, 0, 1, i12);
/* 2548 */         }i12 = LnxmulSetSum(arrayOfInt1, arrayOfInt2, i3, 0, 0, i12);
/*      */ 
/* 2552 */         i12 = LnxmulSetDigit1(arrayOfByte2, i11, i12); i11 -= 2;
/*      */ 
/* 2554 */         i3--;
/*      */       }
/*      */ 
/* 2559 */       i12 += arrayOfInt1[0] * arrayOfInt2[0];
/*      */ 
/* 2561 */       i12 = LnxmulSetDigit1(arrayOfByte2, i11, i12); i11 -= 2;
/*      */ 
/* 2565 */       LnxmulSetDigit2(arrayOfByte2, i11, i12); i11 -= 2;
/*      */     }
/*      */ 
/* 2571 */     if (((i9 & 0x1) == 0) && (arrayOfByte2[i11] != 1))
/*      */     {
/* 2573 */       i8 = (short)(i8 + 1);
/* 2574 */       i9++;
/* 2575 */       i10--;
/*      */     }
/*      */ 
/* 2580 */     while (arrayOfByte2[(i10 + i9 - 2)] == 1)
/*      */     {
/* 2582 */       i9--;
/*      */     }
/*      */ 
/* 2587 */     if (i9 > 21)
/*      */     {
/* 2590 */       i11 = i10 + 19;
/* 2591 */       i9 = 21;
/*      */ 
/* 2594 */       if (arrayOfByte2[(i11 + 1)] > 50)
/*      */       {
/* 2597 */         while (arrayOfByte2[i11] == 100)
/*      */         {
/* 2599 */           i11--;
/* 2600 */           i9--;
/*      */         }
/*      */ 
/* 2603 */         if (i11 < i10)
/*      */         {
/* 2605 */           arrayOfByte2[i10] = 2;
/* 2606 */           i8 = (short)(i8 + 1);
/* 2607 */           i9++;
/*      */         }
/*      */         int tmp1764_1762 = i11;
/*      */         byte[] tmp1764_1760 = arrayOfByte2; tmp1764_1760[tmp1764_1762] = ((byte)(tmp1764_1760[tmp1764_1762] + 1));
/*      */       }
/*      */       else
/*      */       {
/* 2616 */         while (arrayOfByte2[(i10 + i9 - 2)] == 1)
/*      */         {
/* 2618 */           i9--;
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 2625 */     if ((i8 & 0xFFFF) > 255)
/*      */     {
/* 2628 */       if (n == i4)
/*      */       {
/* 2630 */         return NUMBER._makePosInf();
/*      */       }
/*      */ 
/* 2634 */       return NUMBER._makeNegInf();
/*      */     }
/*      */ 
/* 2637 */     if ((i8 & 0xFFFF) < 128)
/*      */     {
/* 2641 */       return NUMBER._makeZero();
/*      */     }
/*      */     int i13;
/* 2646 */     if (n != i4)
/*      */     {
/* 2648 */       i9++;
/* 2649 */       arrayOfByte1 = new byte[i9];
/* 2650 */       arrayOfByte1[0] = ((byte)(i8 ^ 0xFFFFFFFF));
/* 2651 */       for (i13 = 0; i13 < i9 - 1; i13++)
/*      */       {
/* 2653 */         arrayOfByte1[(i13 + 1)] = ((byte)(102 - arrayOfByte2[(i10 + i13)]));
/*      */       }
/* 2655 */       arrayOfByte1[(i9 - 1)] = 102;
/*      */     } else {
/* 2657 */       arrayOfByte1 = new byte[i9];
/* 2658 */       arrayOfByte1[0] = ((byte)i8);
/* 2659 */       for (i13 = 0; i13 < i9 - 1; i13++)
/*      */       {
/* 2661 */         arrayOfByte1[(i13 + 1)] = arrayOfByte2[(i10 + i13)];
/*      */       }
/*      */     }
/*      */ 
/* 2665 */     return arrayOfByte1;
/*      */   }
/*      */ 
/*      */   private static int LnxmulSetSum(int[] paramArrayOfInt1, int[] paramArrayOfInt2, int paramInt1, int paramInt2, int paramInt3, int paramInt4)
/*      */     throws SQLException
/*      */   {
/* 2672 */     int i = 0;
/*      */     try
/*      */     {
/* 2675 */       i = paramInt4 + paramArrayOfInt1[(paramInt1 - paramInt3)] * paramArrayOfInt2[(paramInt2 + paramInt3)];
/*      */     }
/*      */     catch (ArrayIndexOutOfBoundsException localArrayIndexOutOfBoundsException)
/*      */     {
/* 2679 */       throw new SQLException(CoreException.getMessage((byte)4));
/*      */     }
/*      */ 
/* 2682 */     return i;
/*      */   }
/*      */ 
/*      */   private static int LnxmulSetDigit1(byte[] paramArrayOfByte, int paramInt1, int paramInt2)
/*      */   {
/* 2687 */     int i = paramInt2 / 100;
/* 2688 */     int j = paramInt2 / 10000;
/* 2689 */     paramInt1 -= 2;
/* 2690 */     paramArrayOfByte[(paramInt1 + 1)] = ((byte)(paramInt2 - i * 100 + 1));
/* 2691 */     paramArrayOfByte[paramInt1] = ((byte)(i - j * 100 + 1));
/* 2692 */     return j;
/*      */   }
/*      */ 
/*      */   private static void LnxmulSetDigit2(byte[] paramArrayOfByte, int paramInt1, int paramInt2) {
/* 2696 */     int i = paramInt2 / 100;
/* 2697 */     paramInt1 -= 2;
/* 2698 */     paramArrayOfByte[paramInt1] = ((byte)(i + 1));
/* 2699 */     paramArrayOfByte[(paramInt1 + 1)] = ((byte)(paramInt2 - i * 100 + 1));
/*      */   }
/*      */ 
/*      */   public byte[] lnxneg(byte[] paramArrayOfByte)
/*      */     throws SQLException
/*      */   {
/* 2707 */     if (NUMBER._isZero(paramArrayOfByte))
/*      */     {
/* 2709 */       return NUMBER._makeZero();
/*      */     }
/* 2711 */     if (NUMBER._isPosInf(paramArrayOfByte))
/*      */     {
/* 2713 */       return NUMBER._makeNegInf();
/*      */     }
/* 2715 */     if (NUMBER._isNegInf(paramArrayOfByte))
/*      */     {
/* 2717 */       return NUMBER._makePosInf();
/*      */     }
/*      */ 
/* 2721 */     int i = paramArrayOfByte.length;
/* 2722 */     if ((!NUMBER._isPositive(paramArrayOfByte)) && (paramArrayOfByte[(i - 1)] == 102)) {
/* 2723 */       i--;
/*      */     }
/* 2725 */     byte[] arrayOfByte = new byte[i];
/*      */ 
/* 2727 */     System.arraycopy(paramArrayOfByte, 0, arrayOfByte, 0, i);
/*      */ 
/* 2729 */     _negateNumber(arrayOfByte);
/*      */ 
/* 2731 */     return _setLength(arrayOfByte, i);
/*      */   }
/*      */ 
/*      */   public byte[] lnxpow(byte[] paramArrayOfByte, int paramInt)
/*      */     throws SQLException
/*      */   {
/*      */     byte[] arrayOfByte1;
/* 2749 */     if (paramInt >= 0)
/*      */     {
/* 2752 */       arrayOfByte1 = new byte[paramArrayOfByte.length];
/* 2753 */       System.arraycopy(paramArrayOfByte, 0, arrayOfByte1, 0, paramArrayOfByte.length);
/*      */     }
/*      */     else
/*      */     {
/* 2757 */       int i = -2147483648;
/*      */ 
/* 2760 */       if (paramInt == i)
/*      */       {
/* 2762 */         arrayOfByte1 = lnxpow(paramArrayOfByte, i + 1);
/* 2763 */         return lnxdiv(arrayOfByte1, paramArrayOfByte);
/*      */       }
/*      */ 
/* 2767 */       paramInt = -paramInt;
/*      */ 
/* 2770 */       arrayOfByte1 = lnxdiv(lnxqone, paramArrayOfByte);
/*      */     }
/*      */ 
/* 2774 */     byte[] arrayOfByte2 = lnxqone;
/*      */ 
/* 2777 */     while (paramInt > 0)
/*      */     {
/* 2780 */       if ((paramInt & 0x1) == 1)
/*      */       {
/* 2783 */         arrayOfByte2 = lnxmul(arrayOfByte2, arrayOfByte1);
/*      */       }
/*      */ 
/* 2786 */       if (paramInt >>= 1 > 0)
/*      */       {
/* 2789 */         arrayOfByte1 = lnxmul(arrayOfByte1, arrayOfByte1);
/*      */       }
/*      */     }
/*      */ 
/* 2793 */     return arrayOfByte2;
/*      */   }
/*      */ 
/*      */   public byte[] lnxrou(byte[] paramArrayOfByte, int paramInt)
/*      */     throws SQLException
/*      */   {
/* 2801 */     int i = paramArrayOfByte.length;
/* 2802 */     int j = 0;
/*      */ 
/* 2816 */     if (i == 1)
/*      */     {
/* 2818 */       if (paramArrayOfByte[j] == -128) {
/* 2819 */         return NUMBER._makeZero();
/*      */       }
/* 2821 */       return NUMBER._makeNegInf();
/*      */     }
/*      */ 
/* 2825 */     if (i == 2)
/*      */     {
/* 2827 */       if ((paramArrayOfByte[0] == -1) && (paramArrayOfByte[1] == 101))
/*      */       {
/* 2829 */         return NUMBER._makePosInf();
/*      */       }
/*      */     }
/* 2832 */     int i6 = paramArrayOfByte[0] < 0 ? 256 + paramArrayOfByte[0] : paramArrayOfByte[0];
/*      */     boolean bool;
/*      */     int i2;
/*      */     int i3;
/*      */     int m;
/*      */     int n;
/*      */     int i1;
/* 2835 */     if ((bool = NUMBER._isPositive(paramArrayOfByte)))
/*      */     {
/* 2837 */       if (paramInt >= 0)
/*      */       {
/* 2839 */         i2 = i6 + (paramInt + 1 >> 1) - 192;
/*      */ 
/* 2841 */         i3 = (paramInt & 0x1) == 0 ? 0 : 1;
/*      */       }
/*      */       else
/*      */       {
/* 2845 */         paramInt = -paramInt;
/* 2846 */         i2 = i6 - (paramInt >> 1) - 192;
/*      */ 
/* 2848 */         i3 = (paramInt & 0x1) == 0 ? 0 : 1;
/*      */       }
/* 2850 */       m = 1;
/* 2851 */       n = 100;
/* 2852 */       i1 = 1;
/*      */     }
/*      */     else
/*      */     {
/* 2856 */       if (paramInt >= 0)
/*      */       {
/* 2858 */         i2 = 63 + (paramInt + 1 >> 1) - i6;
/*      */ 
/* 2860 */         i3 = (paramInt & 0x1) == 0 ? 0 : 1;
/*      */       }
/*      */       else
/*      */       {
/* 2864 */         paramInt = -paramInt;
/* 2865 */         i2 = 63 - (paramInt >> 1) - i6;
/*      */ 
/* 2867 */         i3 = (paramInt & 0x1) == 0 ? 0 : 1;
/*      */       }
/* 2869 */       m = 101;
/* 2870 */       n = 2;
/* 2871 */       i1 = -1;
/*      */ 
/* 2874 */       i -= (paramArrayOfByte[(i - 1)] == 102 ? 1 : 0);
/*      */     }
/*      */ 
/* 2878 */     byte[] arrayOfByte = new byte[i];
/* 2879 */     System.arraycopy(paramArrayOfByte, 0, arrayOfByte, 0, i);
/*      */ 
/* 2883 */     if ((i2 > i - 1) || ((i2 == i - 1) && ((i3 == 0) || (LnxqFirstDigit[paramArrayOfByte[i2]] == 1))))
/*      */     {
/* 2887 */       return _setLength(paramArrayOfByte, i);
/*      */     }
/*      */ 
/* 2893 */     if ((i2 >= 0) && ((i2 != 0) || ((i3 == 0) && (bool ? paramArrayOfByte[1] >= 51 : paramArrayOfByte[1] <= 51)))) {
/* 2893 */       if ((i2 != 1) || (i3 == 0) || (bool ? paramArrayOfByte[1] >= 6 : paramArrayOfByte[1] <= 96));
/*      */     }
/*      */     else
/*      */     {
/* 2898 */       return NUMBER._makeZero();
/*      */     }
/*      */ 
/* 2903 */     if (i2 == 0)
/*      */     {
/* 2906 */       if (bool ? paramArrayOfByte[j] == -1 : paramArrayOfByte[j] == 0)
/*      */       {
/* 2908 */         if (bool) {
/* 2909 */           return NUMBER._makePosInf();
/*      */         }
/* 2911 */         return NUMBER._makeNegInf();
/*      */       }
/*      */ 
/* 2916 */       arrayOfByte[0] = ((byte)(paramArrayOfByte[j] + i1));
/* 2917 */       arrayOfByte[1] = ((byte)(m + i1));
/*      */ 
/* 2919 */       return _setLength(arrayOfByte, 2);
/*      */     }
/*      */     int i4;
/* 2924 */     int k = i4 = (byte)i2;
/*      */ 
/* 2926 */     if (i3 != 0)
/*      */     {
/* 2929 */       arrayOfByte[i4] = (bool ? LnxqRound_P[paramArrayOfByte[k]] : LnxqRound_N[paramArrayOfByte[k]]);
/*      */     }
/* 2935 */     else if (bool ? paramArrayOfByte[(k + 1)] > 50 : paramArrayOfByte[(k + 1)] < 52)
/*      */     {
/* 2938 */       arrayOfByte[i4] = ((byte)(paramArrayOfByte[k] + i1));
/*      */     }
/*      */     else
/*      */     {
/* 2943 */       arrayOfByte[i4] = paramArrayOfByte[k];
/*      */     }
/*      */ 
/* 2949 */     k = (byte)(k - 1);
/*      */     int i5;
/* 2953 */     if (arrayOfByte[i4] == n + i1)
/*      */     {
/* 2958 */       while ((k > j) && (paramArrayOfByte[k] == n)) {
/* 2959 */         k = (byte)(k - 1);
/*      */       }
/*      */ 
/* 2962 */       if (k == j)
/*      */       {
/* 2965 */         if (bool ? paramArrayOfByte[j] == -1 : paramArrayOfByte[j] == 0)
/*      */         {
/* 2968 */           if (bool) {
/* 2969 */             return NUMBER._makePosInf();
/*      */           }
/* 2971 */           return NUMBER._makeNegInf();
/*      */         }
/*      */ 
/* 2976 */         arrayOfByte[0] = ((byte)(paramArrayOfByte[j] + i1));
/* 2977 */         arrayOfByte[1] = ((byte)(m + i1));
/*      */ 
/* 2979 */         return _setLength(arrayOfByte, 2);
/*      */       }
/*      */ 
/* 2983 */       arrayOfByte[(k - j)] = ((byte)(paramArrayOfByte[k] + i1));
/*      */ 
/* 2986 */       i5 = k - j + 1;
/*      */ 
/* 2989 */       k = (byte)(k - 1);
/*      */     }
/* 2991 */     else if (arrayOfByte[i4] == m)
/*      */     {
/* 2996 */       while (paramArrayOfByte[k] == m) {
/* 2997 */         k = (byte)(k - 1);
/*      */       }
/*      */ 
/* 3000 */       i5 = k - j + 1;
/*      */     }
/*      */     else
/*      */     {
/* 3007 */       i5 = i2 + 1;
/*      */     }
/*      */ 
/* 3011 */     return _setLength(arrayOfByte, i5);
/*      */   }
/*      */ 
/*      */   public byte[] lnxsca(byte[] paramArrayOfByte, int paramInt1, int paramInt2, boolean[] paramArrayOfBoolean)
/*      */     throws SQLException
/*      */   {
/* 3023 */     int m = paramArrayOfByte.length;
/*      */ 
/* 3025 */     if (m != 1)
/*      */     {
/*      */       int i;
/*      */       int j;
/*      */       int k;
/* 3030 */       if (NUMBER._isPositive(paramArrayOfByte))
/*      */       {
/* 3032 */         i = (byte)((paramArrayOfByte[0] & 0xFFFFFF7F) - 65);
/* 3033 */         j = paramArrayOfByte[1];
/* 3034 */         k = paramArrayOfByte[(m - 1)];
/*      */       }
/*      */       else
/*      */       {
/* 3038 */         m--;
/* 3039 */         i = (byte)(((paramArrayOfByte[0] ^ 0xFFFFFFFF) & 0xFFFFFF7F) - 65);
/* 3040 */         j = LnxqNegate[paramArrayOfByte[1]];
/* 3041 */         k = LnxqNegate[paramArrayOfByte[(m - 1)]];
/*      */       }
/*      */ 
/* 3045 */       if (2 * (m - i) - (k % 10 == 1 ? 1 : 0) > paramInt2)
/*      */       {
/* 3048 */         byte[] arrayOfByte1 = lnxrou(paramArrayOfByte, paramInt2);
/*      */ 
/* 3050 */         if (NUMBER._isPositive(arrayOfByte1))
/*      */         {
/* 3052 */           i = (byte)((arrayOfByte1[0] & 0xFFFFFF7F) - 65);
/* 3053 */           j = arrayOfByte1.length != 1 ? arrayOfByte1[1] : 1;
/*      */         }
/*      */         else
/*      */         {
/* 3057 */           i = (byte)(((arrayOfByte1[0] ^ 0xFFFFFFFF) & 0xFFFFFF7F) - 65);
/* 3058 */           j = LnxqNegate[arrayOfByte1[1]];
/*      */         }
/*      */ 
/* 3062 */         paramArrayOfBoolean[0] = (2 * (i + 1) - (j < 11 ? 1 : 0) > paramInt1 ? 1 : false);
/*      */ 
/* 3064 */         return arrayOfByte1;
/*      */       }
/*      */ 
/* 3069 */       int n = paramArrayOfByte.length;
/*      */ 
/* 3071 */       byte[] arrayOfByte2 = new byte[n];
/* 3072 */       System.arraycopy(paramArrayOfByte, 0, arrayOfByte2, 0, n);
/*      */ 
/* 3075 */       paramArrayOfBoolean[0] = (2 * (i + 1) - (j < 11 ? 1 : 0) > paramInt1 ? 1 : false);
/*      */ 
/* 3077 */       return arrayOfByte2;
/*      */     }
/*      */ 
/* 3085 */     paramArrayOfBoolean[0] = false;
/* 3086 */     return NUMBER._makeZero();
/*      */   }
/*      */ 
/*      */   public byte[] lnxshift(byte[] paramArrayOfByte, int paramInt)
/*      */     throws SQLException
/*      */   {
/* 3096 */     byte[] arrayOfByte1 = paramArrayOfByte;
/* 3097 */     int i = arrayOfByte1.length;
/*      */ 
/* 3102 */     byte[] arrayOfByte3 = new byte[22];
/*      */ 
/* 3104 */     int j = 0;
/*      */ 
/* 3115 */     int i3 = 0;
/*      */ 
/* 3120 */     if (i == 1) i4 = 0; else i4 = 1;
/* 3121 */     if ((((arrayOfByte1[0] & 0xFF) == 128) && (i == 1)) || ((i == 2) && ((arrayOfByte1[0] & 0xFF) == 255) && (arrayOfByte1[i4] == 101)) || ((i == 1) && (arrayOfByte1[0] == 0)))
/*      */     {
/* 3130 */       arrayOfByte2 = new byte[i];
/* 3131 */       for (i4 = 0; i4 < i; i4++) arrayOfByte2[i4] = arrayOfByte1[i4];
/* 3132 */       return arrayOfByte2;
/*      */     }
/*      */ 
/* 3135 */     int k = arrayOfByte1[0] >> 7 == 0 ? 1 : 0;
/*      */ 
/* 3139 */     int n = k != 0 ? 255 - arrayOfByte1[0] & 0xFF : arrayOfByte1[0] & 0xFF;
/* 3140 */     int i1 = i;
/*      */ 
/* 3143 */     if ((paramInt & 0x1) > 0)
/*      */     {
/*      */       byte[][] arrayOfByte4;
/*      */       byte[][] arrayOfByte5;
/*      */       int i2;
/* 3149 */       if (k != 0)
/*      */       {
/* 3151 */         if (arrayOfByte1[(i1 - 1)] == 102) i1--;
/* 3152 */         arrayOfByte4 = LnxqComponents_N;
/* 3153 */         arrayOfByte5 = LnxqDigit_N;
/* 3154 */         i2 = 101;
/*      */       }
/*      */       else
/*      */       {
/* 3158 */         arrayOfByte4 = LnxqComponents_P;
/* 3159 */         arrayOfByte5 = LnxqDigit_P;
/* 3160 */         i2 = 1;
/*      */       }
/*      */ 
/* 3165 */       if (arrayOfByte4[arrayOfByte1[1]][0] != 0)
/*      */       {
/* 3171 */         n = paramInt >= 0 ? n + (paramInt / 2 + 1) : n - -paramInt / 2;
/*      */ 
/* 3174 */         j = i1 - 2;
/* 3175 */         i3 = i1 - 1;
/*      */         int m;
/* 3178 */         if (i1 > 20)
/*      */         {
/* 3180 */           m = arrayOfByte4[arrayOfByte1[(j + 1)]][1] >= 5 ? 1 : 0;
/*      */         }
/*      */         else
/*      */         {
/* 3184 */           arrayOfByte3[(i3 + 1)] = arrayOfByte5[arrayOfByte4[arrayOfByte1[(j + 1)]][1]][0];
/* 3185 */           i1++;
/* 3186 */           m = 0;
/*      */         }
/*      */ 
/* 3190 */         while (j > 0)
/*      */         {
/* 3192 */           arrayOfByte3[i3] = arrayOfByte5[arrayOfByte4[arrayOfByte1[(j + 0)]][1]][arrayOfByte4[arrayOfByte1[(j + 1)]][0]];
/* 3193 */           j--;
/* 3194 */           i3--;
/*      */         }
/*      */ 
/* 3199 */         arrayOfByte3[1] = arrayOfByte5[0][arrayOfByte4[arrayOfByte1[(j + 1)]][0]];
/*      */ 
/* 3202 */         if (m != 0)
/*      */         {
/* 3205 */           int i5 = k != 0 ? 2 : 100;
/* 3206 */           int i6 = k != 0 ? -1 : 1;
/*      */ 
/* 3208 */           i3 = 20;
/* 3209 */           while (arrayOfByte3[i3] == i5)
/*      */           {
/* 3211 */             i3--;
/* 3212 */             i1--;
/*      */           }
/*      */           int tmp459_457 = i3;
/*      */           byte[] tmp459_455 = arrayOfByte3; tmp459_455[tmp459_457] = ((byte)(tmp459_455[tmp459_457] + i6));
/*      */         }
/*      */ 
/*      */       }
/*      */       else
/*      */       {
/* 3226 */         n = paramInt >= 0 ? n + paramInt / 2 : n - (-paramInt / 2 + 1);
/*      */ 
/* 3229 */         j = 1;
/* 3230 */         i3 = 1;
/*      */ 
/* 3233 */         while (i3 < i1 - 1)
/*      */         {
/* 3235 */           arrayOfByte3[i3] = arrayOfByte5[arrayOfByte4[arrayOfByte1[(j + 0)]][1]][arrayOfByte4[arrayOfByte1[(j + 1)]][0]];
/* 3236 */           j++;
/* 3237 */           i3++;
/*      */         }
/*      */ 
/* 3242 */         arrayOfByte3[i3] = arrayOfByte5[arrayOfByte4[arrayOfByte1[(j + 0)]][1]][0];
/*      */       }
/*      */ 
/* 3248 */       while (arrayOfByte3[(i1 - 1)] == i2)
/*      */       {
/* 3250 */         i1--;
/*      */       }
/*      */ 
/* 3255 */       if (k != 0)
/*      */       {
/* 3257 */         i1++;
/* 3258 */         arrayOfByte3[(i1 - 1)] = 102;
/*      */       }
/*      */ 
/*      */     }
/*      */     else
/*      */     {
/* 3268 */       n = paramInt >= 0 ? n + paramInt / 2 : n - -paramInt / 2;
/*      */ 
/* 3271 */       for (i4 = 1; i4 < i1; i4++)
/*      */       {
/* 3273 */         arrayOfByte3[i4] = arrayOfByte1[i4];
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 3279 */     if (n > 255)
/*      */     {
/* 3282 */       if (k != 0)
/*      */       {
/* 3284 */         arrayOfByte2 = new byte[1];
/* 3285 */         arrayOfByte2[0] = 0;
/*      */       } else {
/* 3287 */         arrayOfByte2 = new byte[2];
/* 3288 */         arrayOfByte2[0] = -1; arrayOfByte2[1] = 101;
/*      */       }
/* 3290 */       return arrayOfByte2;
/*      */     }
/* 3292 */     if (n < 128)
/*      */     {
/* 3295 */       arrayOfByte2 = new byte[1];
/* 3296 */       arrayOfByte2[0] = -128;
/* 3297 */       return arrayOfByte2;
/*      */     }
/*      */ 
/* 3303 */     arrayOfByte3[0] = (k != 0 ? (byte)(255 - n) : (byte)n);
/* 3304 */     byte[] arrayOfByte2 = new byte[i1];
/* 3305 */     for (int i4 = 0; i4 < i1; i4++)
/*      */     {
/* 3307 */       arrayOfByte2[i4] = arrayOfByte3[i4];
/*      */     }
/* 3309 */     return arrayOfByte2;
/*      */   }
/*      */ 
/*      */   public byte[] lnxsin(byte[] paramArrayOfByte)
/*      */     throws SQLException
/*      */   {
/* 3321 */     return lnxqtra(paramArrayOfByte, 4);
/*      */   }
/*      */ 
/*      */   public byte[] lnxsnh(byte[] paramArrayOfByte)
/*      */     throws SQLException
/*      */   {
/* 3333 */     return lnxqtra(paramArrayOfByte, 7);
/*      */   }
/*      */ 
/*      */   public byte[] lnxsqr(byte[] paramArrayOfByte)
/*      */     throws SQLException
/*      */   {
/* 3340 */     int i = paramArrayOfByte.length;
/* 3341 */     int[] arrayOfInt1 = new int[29];
/* 3342 */     int[] arrayOfInt2 = new int[29];
/*      */ 
/* 3365 */     if (!NUMBER._isPositive(paramArrayOfByte)) {
/* 3366 */       return NUMBER._makeNegInf();
/*      */     }
/*      */ 
/* 3369 */     if (NUMBER._isPosInf(paramArrayOfByte)) {
/* 3370 */       return NUMBER._makePosInf();
/*      */     }
/*      */ 
/* 3373 */     if (NUMBER._isZero(paramArrayOfByte)) {
/* 3374 */       return NUMBER._makeZero();
/*      */     }
/*      */ 
/* 3377 */     int i8 = (paramArrayOfByte[0] & 0xFF) - 193;
/*      */ 
/* 3384 */     for (int i9 = 1; i9 < i; i9++) {
/* 3385 */       paramArrayOfByte[i9] -= 1;
/*      */     }
/*      */ 
/* 3388 */     int i4 = 1;
/* 3389 */     int i5 = i4 + 20 + 3;
/*      */ 
/* 3394 */     if ((i8 + 128 & 0x1) != 0)
/*      */     {
/* 3396 */       k = ((arrayOfInt1[i4] * 100 + arrayOfInt1[(i4 + 1)]) * 100 + arrayOfInt1[(i4 + 2)]) * 100 + arrayOfInt1[(i4 + 3)];
/*      */ 
/* 3398 */       i4 += 3;
/*      */     }
/*      */     else
/*      */     {
/* 3402 */       k = (arrayOfInt1[i4] * 100 + arrayOfInt1[(i4 + 1)]) * 100 + arrayOfInt1[(i4 + 2)];
/*      */ 
/* 3404 */       i4 += 2;
/*      */     }
/*      */ 
/* 3409 */     int j = (int)(Math.sqrt(k) * 100.0D);
/*      */ 
/* 3412 */     arrayOfInt2[1] = (j / 10000);
/* 3413 */     arrayOfInt2[2] = (j / 100 % 100);
/* 3414 */     arrayOfInt2[3] = (j % 100);
/*      */ 
/* 3418 */     k -= arrayOfInt2[1] * j;
/* 3419 */     int k = k * 100 + arrayOfInt1[(i4 + 1)];
/* 3420 */     k -= arrayOfInt2[2] * j;
/* 3421 */     k = k * 100 + arrayOfInt1[(i4 + 2)];
/* 3422 */     k -= arrayOfInt2[3] * j;
/*      */ 
/* 3424 */     i4 += 3;
/*      */ 
/* 3427 */     j *= 2;
/*      */ 
/* 3430 */     int n = 3;
/* 3431 */     int i1 = n + 1;
/*      */ 
/* 3433 */     while (i4 < i5)
/*      */     {
/* 3436 */       k = k * 100 + arrayOfInt1[i4];
/*      */ 
/* 3439 */       int m = k / j;
/*      */ 
/* 3442 */       k -= m * j;
/*      */ 
/* 3445 */       arrayOfInt2[i1] = m;
/*      */ 
/* 3448 */       i2 = n + (i5 - i4) < i1 ? n + (i5 - i4) : i1;
/*      */       int i6;
/* 3452 */       if (m != 0)
/*      */       {
/* 3455 */         i6 = i4 + 1;
/* 3456 */         int i7 = n + 1;
/* 3457 */         while (i7 < i2)
/*      */         {
/* 3459 */           arrayOfInt1[i6] -= 2 * m * arrayOfInt2[i7];
/* 3460 */           i6++;
/* 3461 */           i7++;
/*      */         }
/* 3463 */         if (i6 < i5)
/* 3464 */           arrayOfInt1[i6] -= m * m;
/*      */       }
/* 3466 */       else if (k == 0)
/*      */       {
/* 3469 */         i6 = i4 + 1;
/* 3470 */         while ((i6 < i5) && (arrayOfInt1[i6] == 0)) {
/* 3471 */           i6++;
/*      */         }
/* 3473 */         if (i6 == i5)
/*      */           break;
/*      */       }
/* 3476 */       i4++;
/* 3477 */       i1++;
/*      */     }
/*      */ 
/* 3481 */     int i2 = i1;
/* 3482 */     i1--;
/*      */ 
/* 3485 */     arrayOfInt2[0] = 0;
/*      */ 
/* 3487 */     while (i1 > 0)
/*      */     {
/* 3489 */       while (arrayOfInt2[i1] > 99)
/*      */       {
/* 3491 */         arrayOfInt2[i1] -= 100;
/* 3492 */         arrayOfInt2[(i1 - 1)] += 1;
/*      */       }
/* 3494 */       while (arrayOfInt2[i1] < 0)
/*      */       {
/* 3496 */         arrayOfInt2[i1] += 100;
/* 3497 */         arrayOfInt2[(i1 - 1)] -= 1;
/*      */       }
/* 3499 */       i1--;
/*      */     }
/*      */ 
/* 3505 */     i8 = (i8 - (i8 + 128 & 0x1)) / 2 + 1;
/*      */ 
/* 3508 */     while (arrayOfInt2[i1] == 0)
/*      */     {
/* 3510 */       i1++;
/* 3511 */       i8--;
/* 3512 */       if (i8 < -65) {
/* 3513 */         return NUMBER._makeZero();
/*      */       }
/*      */     }
/*      */ 
/*      */     do
/*      */     {
/* 3519 */       i2--;
/*      */     }
/* 3521 */     while (arrayOfInt2[i2] == 0);
/*      */ 
/* 3524 */     int i3 = i2 - i1 + 2;
/* 3525 */     if (i3 > 21)
/*      */     {
/* 3534 */       i2 = i1 + 20;
/* 3535 */       if (arrayOfInt2[i2] >= 50)
/*      */       {
/*      */         do
/*      */         {
/* 3540 */           i2--;
/*      */         }
/* 3542 */         while (arrayOfInt2[i2] == 99);
/* 3543 */         arrayOfInt2[i2] += 1;
/*      */       }
/*      */       else
/*      */       {
/*      */         do
/*      */         {
/* 3550 */           i2--;
/*      */         }
/* 3552 */         while (arrayOfInt2[i2] == 0);
/*      */       }
/*      */ 
/* 3556 */       if (i2 < i1)
/*      */       {
/* 3558 */         i1 = i2;
/* 3559 */         i8++;
/* 3560 */         if (i8 > 62) {
/* 3561 */           return NUMBER._makePosInf();
/*      */         }
/*      */       }
/* 3564 */       i3 = i2 - i1 + 2;
/*      */     }
/*      */ 
/* 3568 */     byte[] arrayOfByte = new byte[i3];
/*      */ 
/* 3571 */     arrayOfByte[0] = ((byte)(i8 - 63));
/*      */ 
/* 3575 */     for (i9 = i1; i9 <= i2; i9++) {
/* 3576 */       arrayOfByte[(i9 - (i1 - 1))] = ((byte)(arrayOfInt2[i9] + 1));
/*      */     }
/*      */ 
/* 3579 */     return arrayOfByte;
/*      */   }
/*      */ 
/*      */   public byte[] lnxsub(byte[] paramArrayOfByte1, byte[] paramArrayOfByte2)
/*      */     throws SQLException
/*      */   {
/* 3590 */     return lnxadd(paramArrayOfByte1, lnxneg(paramArrayOfByte2));
/*      */   }
/*      */ 
/*      */   public byte[] lnxtan(byte[] paramArrayOfByte)
/*      */     throws SQLException
/*      */   {
/* 3602 */     return lnxqtra(paramArrayOfByte, 5);
/*      */   }
/*      */ 
/*      */   public byte[] lnxtnh(byte[] paramArrayOfByte)
/*      */     throws SQLException
/*      */   {
/* 3614 */     return lnxqtra(paramArrayOfByte, 8);
/*      */   }
/*      */ 
/*      */   public byte[] lnxtru(byte[] paramArrayOfByte, int paramInt)
/*      */     throws SQLException
/*      */   {
/* 3628 */     int i1 = paramArrayOfByte.length;
/*      */ 
/* 3632 */     if (NUMBER._isZero(paramArrayOfByte))
/*      */     {
/* 3634 */       return NUMBER._makeZero();
/*      */     }
/* 3636 */     if (NUMBER._isNegInf(paramArrayOfByte))
/*      */     {
/* 3638 */       return NUMBER._makeNegInf();
/*      */     }
/* 3640 */     if (NUMBER._isPosInf(paramArrayOfByte))
/*      */     {
/* 3642 */       return NUMBER._makePosInf();
/*      */     }
/*      */ 
/* 3647 */     int i3 = paramArrayOfByte[0] < 0 ? 256 + paramArrayOfByte[0] : paramArrayOfByte[0];
/*      */     boolean bool;
/*      */     int k;
/*      */     int m;
/*      */     int n;
/* 3649 */     if ((bool = NUMBER._isPositive(paramArrayOfByte)))
/*      */     {
/* 3651 */       if (paramInt >= 0)
/*      */       {
/* 3653 */         k = i3 + (paramInt + 1 >> 1) - 192;
/* 3654 */         m = (paramInt & 0x1) == 1 ? 1 : 0;
/*      */       }
/*      */       else
/*      */       {
/* 3658 */         paramInt = -paramInt;
/* 3659 */         k = i3 - (paramInt >> 1) - 192;
/* 3660 */         m = (paramInt & 0x1) == 1 ? 1 : 0;
/*      */       }
/* 3662 */       n = 1;
/*      */     }
/*      */     else
/*      */     {
/* 3666 */       if (paramInt >= 0)
/*      */       {
/* 3668 */         k = 63 + (paramInt + 1 >> 1) - i3;
/* 3669 */         m = (paramInt & 0x1) == 1 ? 1 : 0;
/*      */       }
/*      */       else
/*      */       {
/* 3673 */         paramInt = -paramInt;
/* 3674 */         k = 63 - (paramInt >> 1) - i3;
/* 3675 */         m = (paramInt & 0x1) == 1 ? 1 : 0;
/*      */       }
/*      */ 
/* 3678 */       n = 101;
/*      */ 
/* 3680 */       if (paramArrayOfByte[(i1 - 1)] == 102)
/*      */       {
/* 3682 */         i1--;
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 3688 */     byte[] arrayOfByte = new byte[i1];
/* 3689 */     System.arraycopy(paramArrayOfByte, 0, arrayOfByte, 0, i1);
/*      */ 
/* 3694 */     if ((k > i1 - 1) || ((k == i1 - 1) && ((m != 0) || (LnxqFirstDigit[paramArrayOfByte[k]] == 1))))
/*      */     {
/* 3697 */       return _setLength(paramArrayOfByte, i1);
/*      */     }
/*      */ 
/* 3703 */     if ((k <= 0) || ((k == 1) && (m != 0) && (bool ? paramArrayOfByte[1] < 11 : paramArrayOfByte[1] > 91)))
/*      */     {
/* 3706 */       return NUMBER._makeZero();
/*      */     }
/*      */ 
/* 3710 */     int i = j = (byte)k;
/*      */ 
/* 3713 */     if (m != 0)
/*      */     {
/* 3716 */       if (bool)
/*      */       {
/* 3718 */         arrayOfByte[i] = LnxqTruncate_P[paramArrayOfByte[j]];
/*      */       }
/*      */       else
/*      */       {
/* 3722 */         arrayOfByte[i] = LnxqTruncate_N[paramArrayOfByte[j]];
/*      */       }
/*      */ 
/*      */     }
/*      */     else
/*      */     {
/* 3729 */       arrayOfByte[i] = paramArrayOfByte[j];
/*      */     }
/*      */ 
/* 3733 */     int j = (byte)(j - 1);
/*      */     int i2;
/* 3735 */     if (arrayOfByte[i] == n)
/*      */     {
/* 3739 */       while (paramArrayOfByte[j] == n)
/*      */       {
/* 3741 */         j = (byte)(j - 1);
/*      */       }
/*      */ 
/* 3745 */       i2 = j + 1;
/*      */     }
/*      */     else
/*      */     {
/* 3750 */       i2 = k + 1;
/*      */     }
/*      */ 
/* 3753 */     return _setLength(arrayOfByte, i2);
/*      */   }
/*      */ 
/*      */   public byte[] lnxcpn(String paramString1, boolean paramBoolean1, int paramInt1, boolean paramBoolean2, int paramInt2, String paramString2)
/*      */     throws SQLException
/*      */   {
/* 3769 */     int n = 0;
/*      */ 
/* 3774 */     int i4 = 0;
/* 3775 */     boolean bool = false;
/* 3776 */     int i5 = 0;
/*      */ 
/* 3779 */     int i6 = 0;
/* 3780 */     int i7 = 0;
/* 3781 */     int i8 = 0;
/* 3782 */     int i9 = 0;
/* 3783 */     int i10 = 0;
/* 3784 */     int i11 = 0;
/*      */ 
/* 3789 */     int i15 = 0;
/* 3790 */     int i16 = 0;
/* 3791 */     int i17 = 0;
/* 3792 */     int i18 = 0;
/*      */ 
/* 3802 */     int i27 = 0;
/*      */     Locale localLocale;
/* 3813 */     if (paramString2 != null)
/*      */     {
/* 3816 */       int i28 = paramString2.indexOf("_");
/* 3817 */       if (i28 == -1)
/*      */       {
/* 3819 */         localLocale = LxMetaData.getJavaLocale(paramString2, "");
/*      */       }
/*      */       else
/*      */       {
/* 3824 */         String str1 = paramString2.substring(0, i28);
/* 3825 */         String str2 = paramString2.substring(i28 + 1);
/* 3826 */         localLocale = LxMetaData.getJavaLocale(str1, str2);
/*      */       }
/*      */ 
/* 3829 */       if (localLocale == null)
/*      */       {
/* 3834 */         localLocale = OracleLocale.getDefault();
/*      */       }
/*      */ 
/*      */     }
/*      */     else
/*      */     {
/* 3843 */       localLocale = OracleLocale.getDefault();
/*      */     }
/*      */ 
/* 3847 */     DecimalFormatSymbols localDecimalFormatSymbols = new DecimalFormatSymbols(localLocale);
/* 3848 */     int i22 = localDecimalFormatSymbols.getDecimalSeparator();
/* 3849 */     int i26 = localDecimalFormatSymbols.getMinusSign();
/*      */ 
/* 3852 */     char[] arrayOfChar = paramString1.toCharArray();
/*      */ 
/* 3856 */     int j = 0;
/* 3857 */     int k = arrayOfChar.length - 1;
/*      */ 
/* 3860 */     while ((j <= k) && (Character.isSpaceChar(arrayOfChar[j])))
/*      */     {
/* 3862 */       j++;
/*      */     }
/*      */ 
/* 3866 */     if ((j <= k) && ((arrayOfChar[j] == i26) || (arrayOfChar[j] == '+')))
/*      */     {
/* 3871 */       bool = arrayOfChar[j] == i26;
/* 3872 */       j++;
/*      */     }
/*      */ 
/* 3876 */     int i = j;
/*      */ 
/* 3879 */     while ((j <= k) && (arrayOfChar[j] == '0'))
/*      */     {
/* 3881 */       j++;
/*      */     }
/*      */ 
/* 3885 */     int m = j;
/*      */ 
/* 3888 */     while ((j <= k) && (Character.isDigit(arrayOfChar[j])))
/*      */     {
/* 3890 */       j++;
/*      */     }
/*      */ 
/* 3894 */     i6 = j - i;
/* 3895 */     i7 = j - m;
/*      */ 
/* 3898 */     if ((j <= k) && (arrayOfChar[j] == i22))
/*      */     {
/* 3900 */       j++;
/*      */ 
/* 3903 */       n = j;
/*      */ 
/* 3906 */       while ((j <= k) && (Character.isDigit(arrayOfChar[j])))
/*      */       {
/* 3908 */         j++;
/*      */       }
/*      */ 
/* 3912 */       i8 = j - n;
/*      */ 
/* 3915 */       i = j;
/*      */       do
/*      */       {
/* 3921 */         j--;
/*      */       }
/* 3923 */       while ((j >= n) && (arrayOfChar[j] == '0'));
/*      */ 
/* 3926 */       i9 = j - n + 1;
/*      */ 
/* 3929 */       j = i;
/*      */     }
/*      */ 
/* 3933 */     if (i6 + i8 != 0)
/*      */     {
/* 3936 */       if ((j <= k) && ((arrayOfChar[j] == 'E') || (arrayOfChar[j] == 'e')))
/*      */       {
/* 3942 */         j++;
/*      */ 
/* 3944 */         if ((j <= k) && ((arrayOfChar[j] == i26) || (arrayOfChar[j] == '+')))
/*      */         {
/* 3948 */           i5 = arrayOfChar[j] == i26 ? 1 : 0;
/*      */ 
/* 3950 */           j++;
/*      */         }
/*      */ 
/* 3954 */         i = j;
/*      */ 
/* 3957 */         while ((j <= k) && (arrayOfChar[j] == '0'))
/*      */         {
/* 3959 */           j++;
/*      */         }
/*      */ 
/* 3963 */         int i1 = j;
/*      */ 
/* 3966 */         while ((j <= k) && (Character.isDigit(arrayOfChar[j])))
/*      */         {
/* 3968 */           i4 = i4 * 10 + (arrayOfChar[j] - '0');
/* 3969 */           j++;
/*      */         }
/*      */ 
/* 3973 */         i10 = j - i;
/* 3974 */         i11 = j - i1;
/*      */ 
/* 3976 */         if (i10 != 0)
/*      */         {
/* 3978 */           if (i5 != 0)
/*      */           {
/* 3980 */             i4 = -i4;
/*      */           }
/*      */ 
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/* 3989 */       while ((j <= k) && (Character.isSpaceChar(arrayOfChar[j])))
/*      */       {
/* 3991 */         j++;
/*      */       }
/*      */     }
/*      */     int i19;
/*      */     int i20;
/*      */     int i3;
/* 4002 */     if (i7 != 0)
/*      */     {
/* 4004 */       if (i9 != 0)
/*      */       {
/* 4009 */         i4 += i7 - 1;
/*      */ 
/* 4012 */         i19 = i7;
/* 4013 */         i20 = i9;
/*      */ 
/* 4016 */         i3 = m;
/*      */       }
/*      */       else
/*      */       {
/* 4023 */         i4 += i7 - 1;
/*      */ 
/* 4026 */         j = m + (i7 - 1);
/* 4027 */         while (arrayOfChar[j] == '0')
/*      */         {
/* 4029 */           j--;
/*      */         }
/*      */ 
/* 4033 */         i19 = j - m + 1;
/* 4034 */         i20 = 0;
/*      */ 
/* 4037 */         i3 = m;
/*      */       }
/*      */ 
/*      */     }
/* 4042 */     else if (i9 != 0)
/*      */     {
/* 4048 */       j = n;
/* 4049 */       while (arrayOfChar[j] == '0')
/*      */       {
/* 4051 */         j++;
/*      */       }
/*      */ 
/* 4055 */       i4 -= j - n + 1;
/*      */ 
/* 4058 */       i19 = i9 - (j - n);
/* 4059 */       i20 = 0;
/*      */ 
/* 4062 */       i3 = j;
/*      */     }
/*      */     else
/*      */     {
/* 4067 */       return NUMBER._makeZero();
/*      */     }
/*      */ 
/* 4072 */     int i14 = (i4 & 0x1) == 1 ? 40 : 39;
/*      */ 
/* 4077 */     int i12 = i19 + i20;
/*      */ 
/* 4080 */     if ((paramBoolean1) || (paramBoolean2))
/*      */     {
/* 4083 */       if (!paramBoolean1)
/*      */       {
/* 4085 */         paramInt1 = 2147483647;
/*      */       }
/*      */ 
/* 4088 */       if (!paramBoolean2)
/*      */       {
/* 4090 */         paramInt2 = 0;
/*      */       }
/*      */ 
/* 4093 */       i13 = i4 + 1 + paramInt2;
/*      */     }
/*      */     else
/*      */     {
/* 4098 */       i13 = i12;
/*      */     }
/*      */ 
/* 4103 */     int i13 = Math.min(i13, i14);
/*      */ 
/* 4107 */     if ((i13 < 0) || ((i13 == 0) && (arrayOfChar[i3] < '5')))
/*      */     {
/* 4110 */       return NUMBER._makeZero();
/*      */     }
/*      */ 
/* 4115 */     int i21 = 0;
/*      */ 
/* 4117 */     if (i13 < i12)
/*      */     {
/* 4123 */       j = i3 + i13 + (i13 < i19 ? 0 : 1);
/*      */ 
/* 4126 */       if (arrayOfChar[j] < '5')
/*      */       {
/*      */         do
/*      */         {
/* 4131 */           j--;
/*      */ 
/* 4133 */           if (j < i3) break;  } while ((arrayOfChar[j] == '0') || (arrayOfChar[j] == i22));
/*      */       }
/*      */       else
/*      */       {
/*      */         do
/*      */         {
/* 4141 */           j--;
/*      */         }
/* 4143 */         while ((j >= i3) && ((arrayOfChar[j] == '9') || (arrayOfChar[j] == i22)));
/*      */ 
/* 4145 */         i21 = 1;
/*      */       }
/*      */ 
/* 4149 */       if (j < i3)
/*      */       {
/* 4151 */         arrayOfChar[1] = '1';
/* 4152 */         arrayOfChar[2] = '0';
/* 4153 */         i3 = 1;
/*      */ 
/* 4155 */         i4++;
/*      */ 
/* 4158 */         i15 = 0;
/* 4159 */         i17 = (i4 & 0x1) == 1 ? 0 : 1;
/* 4160 */         i18 = 0;
/* 4161 */         i19 = (i4 & 0x1) == 1 ? 2 : 0;
/* 4162 */         i20 = 0;
/* 4163 */         i21 = 0;
/* 4164 */         i27 = 1;
/*      */       }
/* 4169 */       else if (i20 != 0)
/*      */       {
/* 4172 */         if (j - i3 < i19)
/*      */         {
/* 4175 */           i19 = j - i3 + 1;
/* 4176 */           i20 = 0;
/*      */         }
/*      */         else
/*      */         {
/* 4181 */           i20 = j - i3 - i19;
/*      */         }
/*      */ 
/*      */       }
/*      */       else
/*      */       {
/* 4187 */         i19 = j - i3 + 1;
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 4193 */     if (i27 == 0)
/*      */     {
/* 4195 */       if (i20 != 0)
/*      */       {
/* 4198 */         i15 = 1;
/* 4199 */         i16 = (i4 & 0x1) == (i19 & 0x1) ? 1 : 0;
/* 4200 */         i17 = (i4 & 0x1) == 1 ? 0 : 1;
/* 4201 */         i18 = i16 != ((i20 & 0x1) == 1 ? 1 : 0) ? 1 : 0;
/*      */ 
/* 4203 */         i19 -= (i17 != 0 ? 1 : 0) + (i16 != 0 ? 1 : 0);
/* 4204 */         i20 -= (i16 != 0 ? 1 : 0) + (i18 != 0 ? 1 : 0);
/*      */       }
/*      */       else
/*      */       {
/* 4209 */         i15 = 0;
/* 4210 */         i17 = (i4 & 0x1) == 1 ? 0 : 1;
/* 4211 */         i18 = (i4 & 0x1) == (i19 & 0x1) ? 1 : 0;
/* 4212 */         i19 -= (i17 != 0 ? 1 : 0) + (i18 != 0 ? 1 : 0);
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 4217 */     if ((i5 == 0) && ((i11 > 3) || (i4 > 125)))
/*      */     {
/* 4219 */       if (bool)
/*      */       {
/* 4221 */         return NUMBER._makeNegInf();
/*      */       }
/*      */ 
/* 4225 */       return NUMBER._makePosInf();
/*      */     }
/*      */ 
/* 4230 */     if ((i5 != 0) && ((i11 > 3) || (i4 < -130)))
/*      */     {
/* 4232 */       return NUMBER._makeZero();
/*      */     }
/*      */ 
/* 4235 */     byte[] arrayOfByte = new byte[22];
/* 4236 */     int i25 = 1;
/* 4237 */     j = i3;
/*      */ 
/* 4241 */     if (i17 != 0)
/*      */     {
/* 4244 */       arrayOfByte[i25] = digitPtr(0, lnxqctn(arrayOfChar[j]), bool);
/*      */ 
/* 4247 */       i25++;
/* 4248 */       j++;
/*      */     }
/*      */     int i2;
/* 4253 */     if (i19 != 0)
/*      */     {
/* 4255 */       i2 = j + i19;
/* 4256 */       while (j < i2)
/*      */       {
/* 4259 */         arrayOfByte[i25] = digitPtr(lnxqctn(arrayOfChar[j]), lnxqctn(arrayOfChar[(j + 1)]), bool);
/*      */ 
/* 4262 */         i25++;
/* 4263 */         j += 2;
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 4269 */     if (i15 != 0)
/*      */     {
/* 4271 */       if (i16 != 0)
/*      */       {
/* 4273 */         arrayOfByte[i25] = digitPtr(lnxqctn(arrayOfChar[j]), lnxqctn(arrayOfChar[(j + 2)]), bool);
/*      */ 
/* 4276 */         i25++;
/* 4277 */         j += 3;
/*      */       }
/*      */       else
/*      */       {
/* 4281 */         j++;
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 4287 */     if (i20 != 0)
/*      */     {
/* 4289 */       i2 = j + i20;
/* 4290 */       while (j < i2)
/*      */       {
/* 4294 */         arrayOfByte[i25] = digitPtr(lnxqctn(arrayOfChar[j]), lnxqctn(arrayOfChar[(j + 1)]), bool);
/*      */ 
/* 4297 */         i25++;
/* 4298 */         j += 2;
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 4304 */     if (i18 != 0)
/*      */     {
/* 4306 */       arrayOfByte[i25] = digitPtr(lnxqctn(arrayOfChar[j]), 0, bool);
/*      */ 
/* 4309 */       i25++;
/* 4310 */       j++;
/*      */     }
/*      */ 
/* 4315 */     if (i21 != 0)
/*      */     {
/*      */       int tmp1571_1570 = (i25 - 1);
/*      */       byte[] tmp1571_1565 = arrayOfByte; tmp1571_1565[tmp1571_1570] = ((byte)(tmp1571_1565[tmp1571_1570] + (bool ? -1 : 1) * (i18 != 0 ? 10 : 1)));
/*      */     }
/*      */     int i24;
/* 4322 */     if (i4 < 0)
/*      */     {
/* 4324 */       i24 = (byte)(193 - (1 - i4) / 2);
/*      */     }
/*      */     else
/*      */     {
/* 4329 */       i24 = (byte)(193 + i4 / 2);
/*      */     }
/*      */ 
/* 4333 */     int i23 = i25;
/*      */ 
/* 4336 */     arrayOfByte[0] = ((byte)(bool ? i24 ^ 0xFFFFFFFF : i24));
/*      */ 
/* 4338 */     return _setLength(arrayOfByte, i23);
/*      */   }
/*      */ 
/*      */   private static byte digitPtr(int paramInt1, int paramInt2, boolean paramBoolean)
/*      */   {
/* 4350 */     return paramBoolean ? LnxqDigit_N[paramInt1][paramInt2] : LnxqDigit_P[paramInt1][paramInt2];
/*      */   }
/*      */ 
/*      */   private static int lnxqctn(char paramChar)
/*      */   {
/* 4359 */     return Character.digit(paramChar, 10);
/*      */   }
/*      */ 
/*      */   public byte[] lnxfcn(String paramString1, String paramString2, String paramString3)
/*      */     throws SQLException
/*      */   {
/* 4394 */     if ((paramString3 != null) && (!paramString3.equals("AMERICAN_AMERICAN")))
/*      */     {
/* 4396 */       throw new SQLException(CoreException.getMessage((byte)12));
/*      */     }
/*      */ 
/* 4400 */     LnxLibThinFormat localLnxLibThinFormat = new LnxLibThinFormat();
/* 4401 */     localLnxLibThinFormat.parseFormat(paramString2);
/*      */ 
/* 4403 */     localLnxLibThinFormat.LNXNFRDX = true;
/*      */ 
/* 4405 */     int i = localLnxLibThinFormat.lnxnflhd;
/* 4406 */     int j = localLnxLibThinFormat.lnxnfrhd;
/* 4407 */     int k = localLnxLibThinFormat.lnxnfsiz;
/* 4408 */     int m = localLnxLibThinFormat.lnxnfzld;
/*      */ 
/* 4411 */     if ((localLnxLibThinFormat.LNXNFFDA | localLnxLibThinFormat.LNXNFFED | localLnxLibThinFormat.LNXNFFRN | localLnxLibThinFormat.LNXNFFTM))
/*      */     {
/* 4416 */       throw new SQLException(CoreException.getMessage((byte)5));
/*      */     }
/*      */ 
/* 4421 */     if ((localLnxLibThinFormat.LNXNFFRC | localLnxLibThinFormat.LNXNFFCH | localLnxLibThinFormat.LNXNFFCT))
/*      */     {
/* 4423 */       throw new SQLException(CoreException.getMessage((byte)12));
/*      */     }
/*      */ 
/* 4428 */     char[] arrayOfChar1 = paramString1.toCharArray();
/* 4429 */     int n = 0;
/* 4430 */     int i1 = arrayOfChar1.length - 1;
/*      */ 
/* 4432 */     int i2 = 0;
/*      */ 
/* 4435 */     while ((n <= i1) && (Character.isSpaceChar(arrayOfChar1[n])))
/*      */     {
/* 4437 */       n++;
/* 4438 */       i2++;
/*      */     }
/*      */ 
/* 4441 */     if ((localLnxLibThinFormat.LNXNFFBL) && (i2 == k) && (i2 == arrayOfChar1.length))
/*      */     {
/* 4444 */       return NUMBER._makeZero();
/*      */     }
/*      */ 
/* 4448 */     if (n > i1)
/*      */     {
/* 4450 */       throw new SQLException(CoreException.getMessage((byte)14));
/*      */     }
/*      */ 
/* 4454 */     char[] arrayOfChar2 = new char['ÿ'];
/* 4455 */     int i3 = 0;
/*      */ 
/* 4459 */     if (localLnxLibThinFormat.LNXNFFSH)
/*      */     {
/* 4462 */       if ((arrayOfChar1[n] != '-') && (arrayOfChar1[n] != '+'))
/*      */       {
/* 4464 */         throw new SQLException(CoreException.getMessage((byte)14));
/*      */       }
/*      */ 
/* 4467 */       arrayOfChar2[(i3++)] = arrayOfChar1[(n++)];
/*      */     }
/* 4469 */     else if (localLnxLibThinFormat.LNXNFFPR)
/*      */     {
/* 4472 */       if (arrayOfChar1[n] == '<')
/*      */       {
/* 4474 */         arrayOfChar2[(i3++)] = '-';
/* 4475 */         n++;
/*      */       }
/*      */       else
/*      */       {
/* 4479 */         arrayOfChar2[(i3++)] = '+';
/*      */       }
/*      */     }
/* 4482 */     else if (localLnxLibThinFormat.LNXNFFPT)
/*      */     {
/* 4485 */       if (arrayOfChar1[n] == '(')
/*      */       {
/* 4487 */         arrayOfChar2[(i3++)] = '-';
/* 4488 */         n++;
/*      */       }
/*      */       else
/*      */       {
/* 4492 */         arrayOfChar2[(i3++)] = '+';
/*      */       }
/*      */     }
/* 4495 */     else if ((!localLnxLibThinFormat.LNXNFFMI) && (!localLnxLibThinFormat.LNXNFFST))
/*      */     {
/* 4498 */       if (arrayOfChar1[n] == '-')
/*      */       {
/* 4500 */         arrayOfChar2[(i3++)] = arrayOfChar1[(n++)];
/*      */       }
/*      */ 
/*      */     }
/*      */     else
/*      */     {
/* 4506 */       i3++;
/*      */     }
/*      */ 
/* 4510 */     if (n > i1)
/*      */     {
/* 4512 */       throw new SQLException(CoreException.getMessage((byte)14));
/*      */     }
/*      */ 
/* 4518 */     if (localLnxLibThinFormat.LNXNFFDS)
/*      */     {
/* 4521 */       if (arrayOfChar1[n] != '$')
/*      */       {
/* 4523 */         throw new SQLException(CoreException.getMessage((byte)14));
/*      */       }
/*      */ 
/* 4527 */       n++;
/*      */ 
/* 4529 */       if (n > i1)
/*      */       {
/* 4531 */         throw new SQLException(CoreException.getMessage((byte)14));
/*      */       }
/*      */ 
/*      */     }
/* 4535 */     else if (localLnxLibThinFormat.LNXNFFCH)
/*      */     {
/* 4539 */       throw new SQLException(CoreException.getMessage((byte)12));
/*      */     }
/*      */ 
/* 4545 */     byte[] arrayOfByte = new byte[40];
/* 4546 */     int i4 = 0;
/*      */ 
/* 4548 */     int i5 = 0;
/*      */ 
/* 4550 */     int i6 = 0;
/* 4551 */     int i7 = 0;
/*      */     int i8;
/* 4553 */     while (n <= i1)
/*      */     {
/* 4556 */       if ((Character.isDigit(arrayOfChar1[n])) || ((localLnxLibThinFormat.LNXNFFHX) && (((arrayOfChar1[n] >= 'a') && (arrayOfChar1[n] <= 'f')) || ((arrayOfChar1[n] >= 'A') && (arrayOfChar1[n] <= 'F')))))
/*      */       {
/* 4561 */         arrayOfChar2[(i3++)] = arrayOfChar1[(n++)];
/* 4562 */         i6++;
/*      */       }
/* 4565 */       else if (i7 == 0)
/*      */       {
/* 4567 */         if (localLnxLibThinFormat.LNXNFRDX)
/*      */         {
/* 4570 */           if (arrayOfChar1[n] == ',')
/*      */           {
/* 4576 */             n++;
/* 4577 */             arrayOfByte[(i4++)] = ((byte)i6);
/*      */           }
/* 4580 */           else if (arrayOfChar1[n] == '.')
/*      */           {
/* 4583 */             if ((i6 > i) || (i6 < m))
/*      */             {
/* 4585 */               throw new SQLException(CoreException.getMessage((byte)14));
/*      */             }
/*      */ 
/* 4593 */             i6 = i - i6;
/*      */ 
/* 4597 */             i4 = 0;
/* 4598 */             while (localLnxLibThinFormat.lnxnfgps[i5] != 0)
/*      */             {
/* 4609 */               i8 = (byte)(localLnxLibThinFormat.lnxnfgps[i5] & 0x7F);
/*      */ 
/* 4623 */               if (i8 > i6)
/*      */               {
/* 4625 */                 if (arrayOfByte[i4] != i8 - i6)
/*      */                 {
/* 4627 */                   throw new SQLException(CoreException.getMessage((byte)14));
/*      */                 }
/*      */ 
/* 4631 */                 i4++;
/*      */               }
/*      */ 
/* 4635 */               i5++;
/*      */             }
/*      */ 
/* 4639 */             i6 = 0;
/* 4640 */             i7 = 1;
/* 4641 */             arrayOfChar2[i3] = '.';
/* 4642 */             i3++;
/* 4643 */             n++;
/*      */           }
/*      */ 
/*      */         }
/*      */         else
/*      */         {
/* 4650 */           throw new SQLException(CoreException.getMessage((byte)12));
/*      */         }
/*      */ 
/*      */       }
/* 4655 */       else if (((arrayOfChar1[n] == 'E') || (arrayOfChar1[n] == 'e')) && (localLnxLibThinFormat.LNXNFFSN))
/*      */       {
/* 4658 */         if ((i6 <= 0) && (i7 == 0))
/*      */         {
/* 4660 */           throw new SQLException(CoreException.getMessage((byte)14));
/*      */         }
/*      */ 
/* 4663 */         arrayOfChar2[(i3++)] = arrayOfChar1[(n++)];
/* 4664 */         if (n > i1)
/*      */         {
/* 4666 */           throw new SQLException(CoreException.getMessage((byte)14));
/*      */         }
/*      */ 
/* 4669 */         if ((arrayOfChar1[n] == '+') || (arrayOfChar1[n] == '-'))
/*      */         {
/* 4671 */           arrayOfChar2[(i3++)] = arrayOfChar1[(n++)];
/*      */         }
/* 4673 */         i8 = n;
/* 4674 */         while ((n <= i1) && (Character.isDigit(arrayOfChar1[n])))
/*      */         {
/* 4676 */           arrayOfChar2[(i3++)] = arrayOfChar1[(n++)];
/*      */         }
/*      */ 
/* 4679 */         if (i8 == n)
/*      */         {
/* 4681 */           throw new SQLException(CoreException.getMessage((byte)14));
/*      */         }
/*      */ 
/*      */       }
/* 4685 */       else if (localLnxLibThinFormat.LNXNFFRC)
/*      */       {
/* 4689 */         throw new SQLException(CoreException.getMessage((byte)12));
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 4700 */     if (i7 == 0)
/*      */     {
/* 4702 */       i8 = i - i6;
/* 4703 */       i4 = 0;
/*      */ 
/* 4705 */       while (localLnxLibThinFormat.lnxnfgps[i5] != 0)
/*      */       {
/* 4707 */         int i9 = (byte)(localLnxLibThinFormat.lnxnfgps[i5] & 0x7F);
/* 4708 */         if (i9 > i8)
/*      */         {
/* 4710 */           if (arrayOfByte[i4] != i9 - i8)
/*      */           {
/* 4712 */             throw new SQLException(CoreException.getMessage((byte)14));
/*      */           }
/*      */ 
/* 4715 */           i4++;
/*      */         }
/* 4717 */         i5++;
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 4723 */     if (localLnxLibThinFormat.LNXNFFCT)
/*      */     {
/* 4725 */       throw new SQLException(CoreException.getMessage((byte)12));
/*      */     }
/*      */ 
/* 4731 */     if (localLnxLibThinFormat.LNXNFFST)
/*      */     {
/* 4734 */       if (n > i1)
/*      */       {
/* 4736 */         throw new SQLException(CoreException.getMessage((byte)14));
/*      */       }
/*      */ 
/* 4739 */       if ((arrayOfChar1[n] != '-') && (arrayOfChar1[n] != '+'))
/*      */       {
/* 4741 */         throw new SQLException(CoreException.getMessage((byte)14));
/*      */       }
/*      */ 
/* 4744 */       arrayOfChar2[0] = arrayOfChar1[n];
/* 4745 */       n++;
/*      */     }
/* 4747 */     else if (localLnxLibThinFormat.LNXNFFMI)
/*      */     {
/* 4750 */       if (n > i1)
/*      */       {
/* 4752 */         if ((localLnxLibThinFormat.LNXNFFIL) || (n != arrayOfChar1.length))
/*      */         {
/* 4754 */           throw new SQLException(CoreException.getMessage((byte)14));
/*      */         }
/*      */ 
/* 4758 */         arrayOfChar2[0] = '+';
/*      */       }
/*      */       else
/*      */       {
/* 4762 */         arrayOfChar2[0] = (arrayOfChar1[n] == '-' ? 45 : '+');
/* 4763 */         n++;
/*      */       }
/*      */     }
/* 4766 */     else if (localLnxLibThinFormat.LNXNFFPR)
/*      */     {
/* 4769 */       if ((arrayOfChar1[n] == '>') && (arrayOfChar2[0] == '-'))
/*      */       {
/* 4771 */         n++;
/*      */       }
/*      */     }
/* 4774 */     else if (localLnxLibThinFormat.LNXNFFPT)
/*      */     {
/* 4777 */       if ((n < arrayOfChar1.length) && (arrayOfChar1[n] == ')') && (arrayOfChar2[0] == '-'))
/*      */       {
/* 4781 */         n++;
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 4787 */     if (n <= i1)
/*      */     {
/* 4789 */       throw new SQLException(CoreException.getMessage((byte)14));
/*      */     }
/*      */ 
/* 4795 */     if (i7 != 0)
/*      */     {
/* 4797 */       if (i6 > j)
/*      */       {
/* 4799 */         throw new SQLException(CoreException.getMessage((byte)14));
/*      */       }
/*      */ 
/*      */     }
/*      */     else
/*      */     {
/* 4806 */       if (i6 > i)
/*      */       {
/* 4808 */         throw new SQLException(CoreException.getMessage((byte)14));
/*      */       }
/*      */ 
/* 4812 */       if (i6 < m)
/*      */       {
/* 4814 */         throw new SQLException(CoreException.getMessage((byte)14));
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 4825 */     if ((localLnxLibThinFormat.LNXNFF05) && (((i7 != 0) && (i6 == j)) || (j == 0)))
/*      */     {
/* 4828 */       i3--;
/* 4829 */       if ((arrayOfChar2[i3] != '0') && (arrayOfChar2[i3] != '5'))
/*      */       {
/* 4831 */         throw new SQLException(CoreException.getMessage((byte)14));
/*      */       }
/*      */ 
/* 4834 */       i3++;
/*      */     }
/*      */ 
/* 4839 */     if (localLnxLibThinFormat.LNXNFFHX)
/*      */     {
/* 4841 */       return lnxqh2n(arrayOfChar2);
/*      */     }
/*      */ 
/* 4845 */     return lnxcpn(new String(arrayOfChar2), false, 0, false, 0, paramString3);
/*      */   }
/*      */ 
/*      */   public String lnxnfn(byte[] paramArrayOfByte, String paramString1, String paramString2)
/*      */     throws SQLException
/*      */   {
/* 4857 */     char[] arrayOfChar1 = null;
/* 4858 */     int i = 0;
/* 4859 */     int j = 0;
/* 4860 */     int k = 0;
/* 4861 */     int m = 0;
/* 4862 */     int n = 0;
/* 4863 */     int i1 = 0;
/* 4864 */     int i2 = 0;
/* 4865 */     int i3 = 0;
/* 4866 */     int i4 = 0;
/* 4867 */     int i5 = 0;
/* 4868 */     int i6 = 0;
/* 4869 */     int i7 = 0;
/* 4870 */     int i8 = 0;
/* 4871 */     int i9 = 0;
/* 4872 */     int i10 = 0;
/* 4873 */     int i11 = 0;
/* 4874 */     int i12 = 0;
/* 4875 */     int i13 = 0;
/*      */ 
/* 4877 */     Object localObject = null;
/* 4878 */     boolean[] arrayOfBoolean = new boolean[1];
/* 4879 */     int i14 = 0;
/* 4880 */     int i15 = 1;
/*      */ 
/* 4882 */     int i17 = 1;
/*      */ 
/* 4884 */     String str = null;
/*      */ 
/* 4891 */     LnxLibThinFormat localLnxLibThinFormat = new LnxLibThinFormat();
/* 4892 */     localLnxLibThinFormat.parseFormat(paramString1);
/*      */ 
/* 4894 */     i = localLnxLibThinFormat.lnxnflhd;
/* 4895 */     j = localLnxLibThinFormat.lnxnfrhd;
/* 4896 */     k = localLnxLibThinFormat.lnxnfsiz;
/* 4897 */     m = localLnxLibThinFormat.lnxnfzld;
/* 4898 */     n = localLnxLibThinFormat.lnxnfztr;
/*      */ 
/* 4900 */     if ((localLnxLibThinFormat.LNXNFFRN) || (localLnxLibThinFormat.LNXNFFHX))
/*      */     {
/* 4910 */       if (localLnxLibThinFormat.LNXNFFRN)
/*      */       {
/* 4927 */         throw new SQLException(CoreException.getMessage((byte)1));
/*      */       }
/*      */ 
/* 4932 */       throw new SQLException(CoreException.getMessage((byte)1));
/*      */     }
/*      */     int i19;
/*      */     int i20;
/* 4975 */     if (localLnxLibThinFormat.LNXNFFTM)
/*      */     {
/* 4977 */       i19 = paramArrayOfByte.length;
/*      */       int i21;
/*      */       int i22;
/*      */       int i23;
/* 4985 */       if (!NUMBER._isZero(paramArrayOfByte))
/*      */       {
/* 4987 */         if (NUMBER._isPositive(paramArrayOfByte))
/*      */         {
/* 4989 */           i20 = i19 - 1;
/* 4990 */           i21 = 2 * ((paramArrayOfByte[0] & 0xFF) - 193) + ((paramArrayOfByte[1] & 0xFF) > 10 ? 1 : 0);
/*      */ 
/* 4992 */           i22 = 2 * i20 - ((paramArrayOfByte[1] & 0xFF) < 11 ? 1 : 0) - LnxqFirstDigit[paramArrayOfByte[i20]];
/* 4993 */           i23 = 0;
/*      */         }
/*      */         else
/*      */         {
/* 4997 */           if ((paramArrayOfByte[(i19 - 1)] & 0xFF) == 102) {
/* 4998 */             i19--;
/*      */           }
/* 5000 */           i20 = i19 - 1;
/* 5001 */           i21 = 2 * (62 - paramArrayOfByte[0]) + ((paramArrayOfByte[1] & 0xFF) < 92 ? 1 : 0);
/*      */ 
/* 5003 */           i22 = 2 * i20 - ((paramArrayOfByte[1] & 0xFF) > 91 ? 1 : 0) - LnxqFirstDigit[paramArrayOfByte[i20]];
/* 5004 */           i23 = 1;
/*      */         }
/*      */       }
/*      */       else
/*      */       {
/* 5009 */         i21 = 0;
/* 5010 */         i22 = 1;
/* 5011 */         i23 = 0;
/*      */       }
/*      */ 
/* 5015 */       if (i21 >= 0)
/*      */       {
/* 5017 */         i23 += (i22 > i21 + 1 ? i22 + 1 : i21 + 1);
/*      */       }
/*      */       else
/*      */       {
/* 5021 */         i23 += -(i21 + 1) + i22 + 1;
/*      */       }
/*      */ 
/* 5025 */       if ((!localLnxLibThinFormat.LNXNFFSN) && (i23 > 64))
/*      */       {
/* 5027 */         localLnxLibThinFormat.LNXNFFSN = true;
/*      */       }
/*      */ 
/* 5031 */       if (localLnxLibThinFormat.LNXNFFSN)
/*      */       {
/* 5033 */         i = 1;
/* 5034 */         j = i22 - 1;
/* 5035 */         k = i22 > 1 ? i22 + 7 : 7;
/*      */       }
/*      */       else
/*      */       {
/* 5039 */         i = i21 + 1 > 0 ? i21 + 1 : 0;
/* 5040 */         j = i22 - (i21 + 1) > 0 ? i22 - (i21 + 1) : 0;
/* 5041 */         k = j != 0 ? i + j + 2 : i + 1;
/*      */       }
/*      */ 
/* 5045 */       if (j == 0)
/*      */       {
/* 5047 */         localLnxLibThinFormat.LNXNFNRD = true;
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 5057 */     int i18 = (paramArrayOfByte[0] & 0xFF) >= 128 ? 1 : 0;
/*      */     byte[] arrayOfByte;
/* 5062 */     if (localLnxLibThinFormat.LNXNFFSN)
/*      */     {
/* 5064 */       arrayOfByte = lnxfpr(paramArrayOfByte, j + i);
/*      */     }
/*      */     else
/*      */     {
/* 5068 */       arrayOfByte = lnxsca(paramArrayOfByte, i, j, arrayOfBoolean);
/*      */ 
/* 5070 */       if (arrayOfBoolean[0] != 0)
/*      */       {
/* 5072 */         throw new SQLException(CoreException.getMessage((byte)4));
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 5077 */     arrayOfChar1 = new char[64];
/* 5078 */     i5 = 0;
/*      */ 
/* 5080 */     if (NUMBER._isZero(arrayOfByte))
/*      */     {
/* 5083 */       if (localLnxLibThinFormat.LNXNFFBL)
/*      */       {
/* 5085 */         if (localLnxLibThinFormat.LNXNFFIL)
/*      */         {
/* 5088 */           arrayOfChar1 = new char[k];
/*      */ 
/* 5090 */           for (i19 = 0; i19 < k; i19++) {
/* 5091 */             arrayOfChar1[i19] = ' ';
/*      */           }
/* 5093 */           return new String(arrayOfChar1);
/*      */         }
/*      */ 
/* 5097 */         return null;
/*      */       }
/*      */ 
/* 5103 */       i15 = i18;
/* 5104 */       i14 = 0;
/* 5105 */       i2 = 0;
/* 5106 */       i4 = 0;
/* 5107 */       i1 = i2;
/*      */ 
/* 5119 */       i3 = (i > 0) && (n == 0) ? 1 : 0;
/*      */     }
/*      */     else {
/* 5122 */       if ((NUMBER._isNegInf(arrayOfByte)) || (NUMBER._isPosInf(arrayOfByte)))
/*      */       {
/* 5124 */         throw new SQLException(CoreException.getMessage((byte)4));
/*      */       }
/*      */ 
/* 5133 */       i4 = arrayOfByte.length - 1;
/* 5134 */       i15 = (arrayOfByte[0] & 0x80) != 0 ? 1 : 0;
/*      */ 
/* 5136 */       if (i15 == 0)
/*      */       {
/* 5138 */         localObject = new byte[i4];
/* 5139 */         if (arrayOfByte[i4] == 102) {
/* 5140 */           i4--;
/*      */         }
/* 5142 */         for (i19 = 1; i19 <= i4; i19++) {
/* 5143 */           localObject[i19] = ((byte)(102 - arrayOfByte[i19]));
/*      */         }
/* 5145 */         localObject[0] = ((byte)(arrayOfByte[0] ^ 0xFFFFFFFF));
/*      */       }
/*      */       else
/*      */       {
/* 5149 */         localObject = arrayOfByte;
/*      */       }
/*      */ 
/* 5153 */       int i16 = (localObject[i4] & 0xFF) % 10 == 1 ? 1 : 0;
/* 5154 */       i1 = 2 * ((localObject[0] & 0xFF) - 192);
/*      */ 
/* 5157 */       i6 = 1;
/* 5158 */       if ((i17 = (localObject[i6] & 0xFF) < 11 ? 1 : 0) != 0)
/*      */       {
/* 5160 */         i10 = ((localObject[i6] & 0xFF) - 1) / 10;
/*      */       }
/*      */ 
/* 5163 */       if (localLnxLibThinFormat.LNXNFFSN)
/*      */       {
/* 5165 */         i2 = 2 * i4 - (i17 != 0 ? 1 : 0) - (i16 != 0 ? 1 : 0) - (i3 = 1);
/* 5166 */         i1 -= (i17 != 0 ? 1 : 0) + 1;
/*      */ 
/* 5168 */         if ((i14 = i1 < 0 ? 1 : 0) != 0)
/*      */         {
/* 5170 */           i1 = -i1;
/*      */         }
/* 5172 */         if ((i1 < 100) && (localLnxLibThinFormat.LNXNFFIL))
/*      */         {
/* 5175 */           arrayOfChar1[i5] = ' ';
/* 5176 */           i5++;
/*      */         }
/*      */       }
/*      */       else
/*      */       {
/* 5181 */         i2 = 2 * i4 - i1 - (i16 != 0 ? 1 : 0);
/* 5182 */         i3 = i1 - (i17 != 0 ? 1 : 0);
/*      */ 
/* 5185 */         if ((localLnxLibThinFormat.LNXNFF05) && ((j == 0) || (i2 == j)))
/*      */         {
/* 5196 */           i19 = i6 + i4 - 1;
/*      */ 
/* 5199 */           if (i16 == 0)
/*      */           {
/* 5202 */             i20 = (localObject[i19] & 0xFF) % 10;
/* 5203 */             i20 = i20 != 0 ? i20 - 1 : 9;
/* 5204 */             if (i20 <= 2)
/*      */             {
/* 5206 */               localObject[i19] = ((byte)((localObject[i19] & 0xFF) - i20));
/*      */             }
/* 5208 */             else if (i20 <= 7)
/*      */             {
/* 5210 */               localObject[i19] = ((byte)((localObject[i19] & 0xFF) + (5 - i20)));
/*      */             }
/*      */ 
/*      */           }
/*      */           else
/*      */           {
/* 5216 */             i20 = (localObject[i19] & 0xFF) / 10;
/* 5217 */             if (i20 <= 2)
/*      */             {
/* 5219 */               localObject[i19] = 1;
/*      */             }
/* 5221 */             else if (i20 <= 7)
/*      */             {
/* 5223 */               localObject[i19] = 51;
/*      */             }
/*      */           }
/*      */ 
/* 5227 */           if (i20 > 7)
/*      */           {
/* 5231 */             i6--;
/* 5232 */             localObject = lnxrou((byte[])localObject, i2 - 1);
/*      */ 
/* 5235 */             i4 = localObject.length - 1;
/* 5236 */             i16 = (localObject[i6] & 0xFF) % 10 == 1 ? 1 : 0;
/* 5237 */             i1 = 2 * ((localObject[i6] & 0xFF) - 192);
/*      */ 
/* 5240 */             i6++;
/*      */ 
/* 5242 */             if ((i17 = (localObject[i6] & 0xFF) < 11 ? 1 : 0) != 0)
/*      */             {
/* 5244 */               i10 = ((localObject[i6] & 0xFF) - 1) / 10;
/*      */             }
/*      */ 
/* 5247 */             i2 = 2 * i4 - i1 - (i16 != 0 ? 1 : 0);
/* 5248 */             i3 = i1 - (i17 != 0 ? 1 : 0);
/*      */ 
/* 5250 */             if (i3 > i)
/*      */             {
/* 5252 */               throw new SQLException(CoreException.getMessage((byte)4));
/*      */             }
/*      */ 
/*      */           }
/*      */ 
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 5269 */     i11 = i - (m > i3 ? m : i3);
/*      */ 
/* 5271 */     if ((i11 != 0) && (localLnxLibThinFormat.LNXNFFIL))
/*      */     {
/* 5273 */       i19 = i11 + i5;
/* 5274 */       for (i20 = 0; i20 < i19; i5++) {
/* 5275 */         arrayOfChar1[i20] = ' ';
/*      */ 
/* 5274 */         i20++;
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 5279 */     if ((!localLnxLibThinFormat.LNXNFFMI) && (!localLnxLibThinFormat.LNXNFFST))
/*      */     {
/* 5283 */       if (i15 != 0)
/*      */       {
/* 5286 */         i19 = localLnxLibThinFormat.LNXNFFSH ? 43 : 32;
/*      */       }
/*      */       else
/*      */       {
/* 5291 */         i19 = localLnxLibThinFormat.LNXNFFPT ? 40 : localLnxLibThinFormat.LNXNFFPR ? 60 : 45;
/*      */       }
/*      */ 
/* 5294 */       if ((localLnxLibThinFormat.LNXNFFIL) || (i19 != 32))
/*      */       {
/* 5297 */         arrayOfChar1[i5] = i19;
/* 5298 */         i5++;
/*      */       }
/*      */     }
/*      */ 
/* 5302 */     if (localLnxLibThinFormat.LNXNFFIC)
/*      */     {
/* 5305 */       str = "USD";
/*      */     }
/* 5307 */     else if (localLnxLibThinFormat.LNXNFFUN)
/*      */     {
/* 5310 */       str = "$";
/*      */     }
/*      */     else
/*      */     {
/* 5314 */       str = "$";
/*      */     }
/*      */ 
/* 5317 */     if (localLnxLibThinFormat.LNXNFFDS)
/*      */     {
/* 5321 */       arrayOfChar1[i5] = '$';
/* 5322 */       i5++;
/*      */     }
/* 5324 */     else if (localLnxLibThinFormat.LNXNFFCH)
/*      */     {
/* 5326 */       for (i19 = 0; i19 < str.length(); i5++) {
/* 5327 */         arrayOfChar1[i5] = str.charAt(i19);
/*      */ 
/* 5326 */         i19++;
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 5332 */     i7 = 0;
/* 5333 */     while ((i8 = localLnxLibThinFormat.lnxnfgps[i7] & 0x7F) != 0)
/*      */     {
/* 5335 */       if (i8 > i11)
/*      */       {
/*      */         break;
/*      */       }
/* 5339 */       i7++;
/*      */     }
/*      */ 
/* 5343 */     if ((i9 = m - (i3 > 0 ? i3 : 0)) > 0)
/*      */     {
/* 5345 */       while (i9 > 0)
/*      */       {
/* 5348 */         arrayOfChar1[i5] = '0';
/* 5349 */         i5++;
/* 5350 */         i11++;
/*      */ 
/* 5353 */         while (i11 == i8)
/*      */         {
/* 5358 */           arrayOfChar1[i5] = ',';
/* 5359 */           i5++;
/* 5360 */           i7++;
/*      */ 
/* 5362 */           i8 = localLnxLibThinFormat.lnxnfgps[i7] & 0x7F;
/*      */         }
/* 5364 */         i9--;
/*      */       }
/*      */     }
/*      */ 
/* 5368 */     if (i3 > 0)
/*      */     {
/* 5371 */       while ((i3 > 0) && (i4 != 0))
/*      */       {
/* 5374 */         if (i17 != 0)
/*      */         {
/* 5376 */           i13 = (localObject[i6] & 0xFF) - 1 - i10 * 10;
/* 5377 */           i6++;
/* 5378 */           i4--;
/*      */         }
/*      */         else
/*      */         {
/* 5382 */           i13 = ((localObject[i6] & 0xFF) - 1) / 10;
/* 5383 */           i10 = i13;
/*      */         }
/*      */ 
/* 5387 */         arrayOfChar1[i5] = this.lnx_chars[i13];
/* 5388 */         i5++;
/* 5389 */         i11++;
/*      */ 
/* 5391 */         while (i11 == i8)
/*      */         {
/* 5396 */           arrayOfChar1[i5] = ',';
/* 5397 */           i5++;
/* 5398 */           i7++;
/* 5399 */           i8 = localLnxLibThinFormat.lnxnfgps[i7] & 0x7F;
/*      */         }
/* 5401 */         i3--;
/* 5402 */         i17 = i17 == 0 ? 1 : 0;
/*      */       }
/*      */ 
/* 5406 */       while (i3 > 0)
/*      */       {
/* 5409 */         arrayOfChar1[i5] = '0';
/* 5410 */         i5++;
/* 5411 */         i11++;
/*      */ 
/* 5414 */         while (i11 == i8)
/*      */         {
/* 5419 */           arrayOfChar1[i5] = ',';
/* 5420 */           i5++;
/* 5421 */           i7++;
/* 5422 */           i8 = localLnxLibThinFormat.lnxnfgps[i7] & 0x7F;
/*      */         }
/*      */ 
/* 5425 */         i3--;
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 5431 */     if (!localLnxLibThinFormat.LNXNFNRD)
/*      */     {
/* 5434 */       if (localLnxLibThinFormat.LNXNFRDX)
/*      */       {
/* 5437 */         arrayOfChar1[i5] = '.';
/* 5438 */         i5++;
/*      */       }
/* 5442 */       else if (localLnxLibThinFormat.LNXNFFRC)
/*      */       {
/* 5445 */         for (i19 = 0; i19 < str.length(); i5++) {
/* 5446 */           arrayOfChar1[i5] = str.charAt(i19);
/*      */ 
/* 5445 */           i19++;
/*      */         }
/*      */ 
/*      */       }
/*      */       else
/*      */       {
/* 5451 */         arrayOfChar1[i5] = '.';
/* 5452 */         i5++;
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 5457 */     i11 = 0;
/* 5458 */     if ((i12 = n - (i2 > 0 ? i2 : 0)) < 0)
/*      */     {
/* 5460 */       i12 = 0;
/*      */     }
/*      */ 
/* 5464 */     if (i3 != 0)
/*      */     {
/* 5467 */       i3 = -i3;
/* 5468 */       i2 -= i3;
/* 5469 */       while (i3 != 0)
/*      */       {
/* 5472 */         arrayOfChar1[i5] = '0';
/* 5473 */         i5++;
/* 5474 */         i3--;
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 5479 */     while ((i4 != 0) && (i2 != 0))
/*      */     {
/* 5481 */       if (i17 != 0)
/*      */       {
/* 5483 */         i13 = (localObject[i6] & 0xFF) - 1 - i10 * 10;
/* 5484 */         i6++;
/* 5485 */         i4--;
/*      */       }
/*      */       else
/*      */       {
/* 5489 */         i13 = ((localObject[i6] & 0xFF) - 1) / 10;
/* 5490 */         i10 = i13;
/*      */       }
/*      */ 
/* 5494 */       arrayOfChar1[i5] = this.lnx_chars[i13];
/* 5495 */       i5++;
/* 5496 */       i2--;
/* 5497 */       i17 = i17 == 0 ? 1 : 0;
/*      */     }
/*      */ 
/* 5500 */     while (i12 != 0)
/*      */     {
/* 5503 */       arrayOfChar1[i5] = '0';
/* 5504 */       i5++;
/* 5505 */       i12--;
/*      */     }
/*      */ 
/* 5509 */     if (localLnxLibThinFormat.LNXNFFSN)
/*      */     {
/* 5512 */       arrayOfChar1[i5] = 'E';
/* 5513 */       i5++;
/*      */ 
/* 5518 */       arrayOfChar1[i5] = (i14 != 0 ? 45 : '+');
/* 5519 */       i5++;
/*      */ 
/* 5522 */       if (i1 > 99)
/*      */       {
/* 5525 */         arrayOfChar1[i5] = '1';
/* 5526 */         i5++;
/* 5527 */         i1 -= 100;
/*      */       }
/*      */ 
/* 5531 */       arrayOfChar1[i5] = this.lnx_chars[(i1 / 10)];
/* 5532 */       i5++;
/*      */ 
/* 5535 */       arrayOfChar1[i5] = this.lnx_chars[(i1 % 10)];
/* 5536 */       i5++;
/*      */     }
/*      */ 
/* 5539 */     if (localLnxLibThinFormat.LNXNFFCT)
/*      */     {
/* 5542 */       for (i19 = 0; i19 < str.length(); i5++) {
/* 5543 */         arrayOfChar1[i5] = str.charAt(i19);
/*      */ 
/* 5542 */         i19++;
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 5547 */     if (i15 != 0)
/*      */     {
/* 5549 */       if (localLnxLibThinFormat.LNXNFFST)
/*      */       {
/* 5553 */         arrayOfChar1[i5] = '+';
/* 5554 */         i5++;
/*      */       }
/* 5556 */       else if (((localLnxLibThinFormat.LNXNFFPR) || (localLnxLibThinFormat.LNXNFFMI) || (localLnxLibThinFormat.LNXNFFPT)) && (localLnxLibThinFormat.LNXNFFIL))
/*      */       {
/* 5561 */         arrayOfChar1[i5] = ' ';
/* 5562 */         i5++;
/*      */       }
/*      */ 
/*      */     }
/* 5567 */     else if (localLnxLibThinFormat.LNXNFFPR)
/*      */     {
/* 5570 */       arrayOfChar1[i5] = '>';
/* 5571 */       i5++;
/*      */     }
/* 5574 */     else if (localLnxLibThinFormat.LNXNFFPT)
/*      */     {
/* 5577 */       arrayOfChar1[i5] = ')';
/* 5578 */       i5++;
/*      */     }
/* 5580 */     else if ((localLnxLibThinFormat.LNXNFFMI) || (localLnxLibThinFormat.LNXNFFST))
/*      */     {
/* 5583 */       arrayOfChar1[i5] = '-';
/* 5584 */       i5++;
/*      */     }
/*      */ 
/* 5589 */     i12 = i5;
/*      */ 
/* 5594 */     if ((localLnxLibThinFormat.LNXNFFIL) && (i12 != k))
/*      */     {
/* 5598 */       i9 = k - i12;
/*      */ 
/* 5600 */       char[] arrayOfChar2 = new char[i9];
/* 5601 */       for (i20 = 0; i20 < i9; i20++) {
/* 5602 */         arrayOfChar2[i20] = ' ';
/*      */       }
/* 5604 */       StringBuffer localStringBuffer = new StringBuffer();
/* 5605 */       localStringBuffer.append(arrayOfChar2);
/* 5606 */       localStringBuffer.append(arrayOfChar1, 0, i12);
/*      */ 
/* 5608 */       return localStringBuffer.toString();
/*      */     }
/*      */ 
/* 5611 */     return new String(arrayOfChar1, 0, i12);
/*      */   }
/*      */ 
/*      */   public String lnxnuc(byte[] paramArrayOfByte, int paramInt, String paramString)
/*      */     throws SQLException
/*      */   {
/* 5631 */     byte[] arrayOfByte1 = new byte[22];
/*      */ 
/* 5653 */     int i13 = 0;
/*      */ 
/* 5662 */     if (paramString != null)
/*      */     {
/* 5664 */       throw new SQLException(CoreException.getMessage((byte)12));
/*      */     }
/*      */ 
/* 5670 */     char[] arrayOfChar1 = this.lnx_chars;
/* 5671 */     int i5 = 46;
/*      */ 
/* 5674 */     if (paramInt == 0)
/*      */     {
/* 5676 */       throw new SQLException(CoreException.getMessage((byte)13));
/*      */     }
/*      */     int k;
/* 5682 */     if ((k = paramInt >= 0 ? 1 : 0) == 0)
/*      */     {
/* 5684 */       paramInt = -paramInt;
/*      */     }
/*      */ 
/* 5687 */     char[] arrayOfChar2 = new char[paramInt];
/*      */     int i7;
/*      */     byte[][] arrayOfByte;
/*      */     int i6;
/* 5691 */     if ((i7 = !NUMBER._isPositive(paramArrayOfByte) ? 1 : 0) != 0)
/*      */     {
/* 5693 */       arrayOfByte = LnxqComponents_N;
/* 5694 */       i6 = paramInt - 1;
/*      */     }
/*      */     else
/*      */     {
/* 5698 */       arrayOfByte = LnxqComponents_P;
/* 5699 */       i6 = paramInt;
/*      */     }
/*      */ 
/* 5702 */     int i19 = 1;
/*      */ 
/* 5704 */     while (i19 != 0)
/*      */     {
/* 5708 */       int m = k;
/*      */ 
/* 5712 */       int i20 = paramArrayOfByte.length;
/*      */       int i4;
/*      */       int i18;
/* 5714 */       if (i20 == 1)
/*      */       {
/* 5717 */         if ((paramArrayOfByte[0] & 0xFF) == 128)
/*      */         {
/* 5720 */           if (m != 0)
/*      */           {
/* 5722 */             i4 = paramInt - 1;
/* 5723 */             arrayOfChar2[i4] = arrayOfChar1[0];
/*      */           }
/*      */           else
/*      */           {
/* 5727 */             if (paramInt < 5)
/*      */             {
/* 5729 */               throw new SQLException(CoreException.getMessage((byte)13));
/*      */             }
/*      */ 
/* 5732 */             i4 = paramInt - 5;
/* 5733 */             arrayOfChar2[i4] = arrayOfChar1[0];
/* 5734 */             arrayOfChar2[(i4 + 1)] = arrayOfChar1[41];
/* 5735 */             arrayOfChar2[(i4 + 2)] = arrayOfChar1[10];
/* 5736 */             arrayOfChar2[(i4 + 3)] = arrayOfChar1[0];
/* 5737 */             arrayOfChar2[(i4 + 4)] = arrayOfChar1[0];
/*      */           }
/*      */ 
/* 5740 */           if (i4 != 0) {
/* 5741 */             for (i18 = 0; i18 < i4; i18++) arrayOfChar2[i18] = arrayOfChar1[12];
/*      */           }
/* 5743 */           return new String(arrayOfChar2);
/*      */         }
/*      */ 
/* 5747 */         if (paramInt < 2)
/*      */         {
/* 5749 */           throw new SQLException(CoreException.getMessage((byte)13));
/*      */         }
/*      */ 
/* 5752 */         i4 = paramInt - 2;
/* 5753 */         arrayOfChar2[i4] = arrayOfChar1[11];
/* 5754 */         arrayOfChar2[(i4 + 1)] = arrayOfChar1[21];
/*      */ 
/* 5756 */         if (i4 != 0) {
/* 5757 */           for (i18 = 0; i18 < i4; i18++) arrayOfChar2[i18] = arrayOfChar1[12];
/*      */         }
/* 5759 */         return new String(arrayOfChar2);
/*      */       }
/*      */ 
/* 5765 */       if ((i20 == 2) && ((paramArrayOfByte[0] & 0xFF) == 255) && ((paramArrayOfByte[1] & 0xFF) == 101))
/*      */       {
/* 5769 */         i4 = paramInt - 1;
/* 5770 */         arrayOfChar2[i4] = arrayOfChar1[21];
/*      */ 
/* 5772 */         if (i4 != 0) {
/* 5773 */           for (i18 = 0; i18 < i4; i18++) arrayOfChar2[i18] = arrayOfChar1[12];
/*      */         }
/* 5775 */         return new String(arrayOfChar2);
/*      */       }
/*      */       int i2;
/*      */       int i8;
/*      */       int i3;
/* 5780 */       if (i7 != 0)
/*      */       {
/* 5782 */         if (paramArrayOfByte[(i20 - 1)] == 102) i20--;
/* 5783 */         i2 = i20 - 1;
/* 5784 */         i8 = 2 * (62 - (paramArrayOfByte[0] & 0xFF)) + ((paramArrayOfByte[1] & 0xFF) < 92 ? 1 : 0);
/*      */ 
/* 5786 */         i3 = 2 * i2 - ((paramArrayOfByte[1] & 0xFF) > 91 ? 1 : 0) - LnxqFirstDigit[paramArrayOfByte[i2]];
/*      */       }
/*      */       else
/*      */       {
/* 5790 */         i2 = i20 - 1;
/* 5791 */         i8 = 2 * ((paramArrayOfByte[0] & 0xFF) - 193) + ((paramArrayOfByte[1] & 0xFF) > 10 ? 1 : 0);
/*      */ 
/* 5793 */         i3 = 2 * i2 - ((paramArrayOfByte[1] & 0xFF) < 11 ? 1 : 0) - LnxqFirstDigit[paramArrayOfByte[i2]];
/*      */       }
/*      */ 
/* 5798 */       if (m != 0)
/*      */       {
/* 5801 */         if (i8 >= 0)
/*      */         {
/* 5804 */           m = i8 < i6 ? 1 : 0;
/*      */         }
/*      */         else
/*      */         {
/* 5809 */           m = (i8 >= -5) || (i3 - i8 <= i6) || (i6 <= 6) ? 1 : 0;
/*      */         }
/*      */       }
/*      */       int i9;
/*      */       int i12;
/*      */       int i14;
/*      */       int i15;
/*      */       int i16;
/*      */       int i17;
/*      */       int i1;
/*      */       int i11;
/*      */       int n;
/* 5815 */       if (m != 0)
/*      */       {
/* 5822 */         if (i8 >= 0)
/*      */         {
/* 5824 */           i9 = i6 <= i8 + 1 ? i6 : i6 - 1;
/*      */         }
/*      */         else
/*      */         {
/* 5828 */           i9 = i6 + i8;
/*      */         }
/*      */ 
/* 5833 */         if (i9 < i3)
/*      */         {
/* 5836 */           paramArrayOfByte = lnxfpr(paramArrayOfByte, i9);
/*      */         }
/*      */         else
/*      */         {
/* 5842 */           i19 = 0;
/*      */ 
/* 5847 */           if (i8 >= 0)
/*      */           {
/* 5849 */             if (i3 > i8 + 1)
/*      */             {
/* 5855 */               i4 = i6 - (i3 + 1);
/* 5856 */               i12 = 1;
/* 5857 */               i13 = 0;
/* 5858 */               i14 = (i8 & 0x1) > 0 ? 0 : 1;
/* 5859 */               i15 = (i3 - i8 & 0x1) > 0 ? 0 : 1;
/* 5860 */               int i21 = 2147483647;
/* 5861 */               i16 = i8 + 1 & i21 - 1;
/* 5862 */               i17 = i3 - (i8 + 1) & i21 - 1;
/*      */ 
/* 5865 */               i1 = i4;
/*      */             }
/*      */             else
/*      */             {
/* 5873 */               i4 = i6 - (i8 + 1);
/* 5874 */               i11 = i8 + 1 - i3;
/* 5875 */               i12 = 0;
/* 5876 */               i14 = (i8 & 0x1) > 0 ? 0 : 1;
/* 5877 */               i15 = (i11 & 0x1) > 0 ? 1 : 0;
/* 5878 */               i16 = i3 - (i14 != 0 ? 1 : 0) - (i15 != 0 ? 1 : 0);
/* 5879 */               i17 = 0;
/*      */ 
/* 5882 */               if (i11 != 0)
/*      */               {
/* 5884 */                 n = i4 + (i7 != 0 ? 1 : 0) + i3;
/* 5885 */                 for (i18 = 0; i18 < i11; i18++) {
/* 5886 */                   arrayOfChar2[(n + i18)] = arrayOfChar1[0];
/*      */                 }
/*      */               }
/*      */ 
/* 5890 */               i1 = i4;
/*      */             }
/*      */ 
/*      */           }
/*      */           else
/*      */           {
/* 5899 */             i4 = i6 - (i3 - i8);
/* 5900 */             int i10 = -(i8 + 1);
/* 5901 */             i12 = 0;
/* 5902 */             i14 = (i10 & 0x1) > 0 ? 1 : 0;
/* 5903 */             i15 = (i10 + i3 & 0x1) > 0 ? 1 : 0;
/* 5904 */             i16 = 0;
/* 5905 */             i17 = i3 - (i14 != 0 ? 1 : 0) - (i15 != 0 ? 1 : 0);
/*      */ 
/* 5908 */             n = i4;
/*      */ 
/* 5911 */             if (i7 != 0)
/*      */             {
/* 5913 */               arrayOfChar2[n] = arrayOfChar1[11];
/* 5914 */               n++;
/* 5915 */               i7 = 0;
/*      */             }
/*      */ 
/* 5919 */             arrayOfChar2[n] = i5;
/* 5920 */             n++;
/*      */ 
/* 5923 */             if (i10 != 0)
/*      */             {
/* 5925 */               for (i18 = 0; i18 < i10; i18++)
/* 5926 */                 arrayOfChar2[(n + i18)] = arrayOfChar1[0];
/* 5927 */               n += i10;
/*      */             }
/*      */ 
/* 5931 */             i1 = n;
/*      */           }
/*      */ 
/* 5937 */           if (i4 != 0)
/*      */           {
/* 5939 */             for (i18 = 0; i18 < i4; i18++) arrayOfChar2[i18] = arrayOfChar1[12];
/*      */           }
/*      */ 
/*      */         }
/*      */ 
/*      */       }
/*      */       else
/*      */       {
/* 5947 */         i9 = i6 - ((i8 > 99) || (i8 < -99) ? 6 : 5);
/*      */ 
/* 5951 */         if (i9 < 2)
/*      */         {
/* 5953 */           throw new SQLException(CoreException.getMessage((byte)13));
/*      */         }
/*      */ 
/* 5959 */         if (i9 < i3)
/*      */         {
/* 5962 */           paramArrayOfByte = lnxfpr(paramArrayOfByte, i9);
/*      */         }
/*      */         else
/*      */         {
/* 5968 */           i19 = 0;
/*      */ 
/* 5973 */           if (i3 == 1)
/*      */           {
/* 5976 */             i11 = i9 - 1;
/* 5977 */             i12 = 1;
/* 5978 */             i13 = (i8 & 0x1) > 0 ? 1 : 0;
/* 5979 */             i14 = i13 == 0 ? 1 : 0;
/* 5980 */             i15 = 0;
/* 5981 */             i16 = 0;
/* 5982 */             i17 = 0;
/*      */           }
/*      */           else
/*      */           {
/* 5987 */             i11 = i9 - i3;
/* 5988 */             i12 = 1;
/* 5989 */             i13 = (i8 & 0x1) > 0 ? 1 : 0;
/* 5990 */             i14 = i13 == 0 ? 1 : 0;
/* 5991 */             i15 = i13 == ((i3 & 0x1) > 0 ? 1 : 0) ? 1 : 0;
/* 5992 */             i16 = 0;
/* 5993 */             i17 = i3 - (i14 != 0 ? 1 : 2) - (i15 != 0 ? 1 : 0);
/*      */           }
/*      */ 
/* 5998 */           n = (i7 != 0 ? 1 : 0) + 1 + i3;
/*      */ 
/* 6002 */           if (i11 != 0)
/*      */           {
/* 6004 */             for (i18 = 0; i18 < i11; i18++)
/* 6005 */               arrayOfChar2[(n + i18)] = arrayOfChar1[0];
/* 6006 */             n += i11;
/*      */           }
/*      */ 
/* 6011 */           if (i8 < 0)
/*      */           {
/* 6013 */             i8 = -i8;
/* 6014 */             arrayOfChar2[n] = arrayOfChar1[41];
/* 6015 */             arrayOfChar2[(n + 1)] = arrayOfChar1[11];
/*      */           }
/*      */           else
/*      */           {
/* 6019 */             arrayOfChar2[n] = arrayOfChar1[41];
/* 6020 */             arrayOfChar2[(n + 1)] = arrayOfChar1[10];
/*      */           }
/*      */ 
/* 6023 */           if (i8 > 99)
/*      */           {
/* 6025 */             arrayOfChar2[(n + 2)] = arrayOfChar1[1];
/* 6026 */             arrayOfByte1[0] = ((byte)(i8 - 99));
/* 6027 */             arrayOfChar2[(n + 3)] = arrayOfChar1[LnxqComponents_P[(arrayOfByte1[0] & 0xFF)][0]];
/* 6028 */             arrayOfChar2[(n + 4)] = arrayOfChar1[LnxqComponents_P[(arrayOfByte1[0] & 0xFF)][1]];
/*      */           }
/*      */           else
/*      */           {
/* 6032 */             arrayOfByte1[0] = ((byte)(i8 + 1));
/* 6033 */             arrayOfChar2[(n + 2)] = arrayOfChar1[LnxqComponents_P[(arrayOfByte1[0] & 0xFF)][0]];
/* 6034 */             arrayOfChar2[(n + 3)] = arrayOfChar1[LnxqComponents_P[(arrayOfByte1[0] & 0xFF)][1]];
/*      */           }
/*      */ 
/* 6038 */           i1 = 0;
/*      */ 
/* 6044 */           int i = 1;
/* 6045 */           n = i1;
/*      */ 
/* 6049 */           if (i7 != 0)
/*      */           {
/* 6051 */             arrayOfChar2[n] = arrayOfChar1[11];
/* 6052 */             n++;
/*      */           }
/*      */ 
/* 6057 */           if (i14 != 0)
/*      */           {
/* 6059 */             arrayOfChar2[n] = arrayOfChar1[arrayOfByte[paramArrayOfByte[i]][1]];
/* 6060 */             n++;
/* 6061 */             i++;
/*      */           }
/*      */           int j;
/* 6066 */           if (i16 != 0)
/*      */           {
/* 6068 */             j = n + i16;
/* 6069 */             while (n < j)
/*      */             {
/* 6071 */               arrayOfChar2[n] = arrayOfChar1[arrayOfByte[paramArrayOfByte[i]][0]];
/* 6072 */               n++;
/* 6073 */               arrayOfChar2[n] = arrayOfChar1[arrayOfByte[paramArrayOfByte[i]][1]];
/* 6074 */               n++;
/* 6075 */               i++;
/*      */             }
/*      */ 
/*      */           }
/*      */ 
/* 6081 */           if (i12 != 0)
/*      */           {
/* 6083 */             if (i13 != 0)
/*      */             {
/* 6085 */               arrayOfChar2[n] = arrayOfChar1[arrayOfByte[paramArrayOfByte[i]][0]];
/* 6086 */               n++;
/* 6087 */               arrayOfChar2[n] = i5;
/* 6088 */               n++;
/* 6089 */               arrayOfChar2[n] = arrayOfChar1[arrayOfByte[paramArrayOfByte[i]][1]];
/* 6090 */               n++;
/* 6091 */               i++;
/*      */             }
/*      */             else
/*      */             {
/* 6095 */               arrayOfChar2[n] = i5;
/* 6096 */               n++;
/*      */             }
/*      */ 
/*      */           }
/*      */ 
/* 6102 */           if (i17 != 0)
/*      */           {
/* 6104 */             j = n + i17;
/* 6105 */             while (n < j)
/*      */             {
/* 6107 */               arrayOfChar2[n] = arrayOfChar1[arrayOfByte[paramArrayOfByte[i]][0]];
/* 6108 */               n++;
/* 6109 */               arrayOfChar2[n] = arrayOfChar1[arrayOfByte[paramArrayOfByte[i]][1]];
/* 6110 */               n++;
/* 6111 */               i++;
/*      */             }
/*      */ 
/*      */           }
/*      */ 
/* 6117 */           if (i15 != 0)
/*      */           {
/* 6119 */             arrayOfChar2[n] = arrayOfChar1[arrayOfByte[paramArrayOfByte[i]][0]];
/* 6120 */             n++;
/* 6121 */             i++;
/*      */           }
/*      */         }
/*      */       }
/*      */     }
/* 6126 */     return new String(arrayOfChar2); } 
/*      */   public byte[] lnxren(double paramDouble) throws SQLException { // Byte code:
/*      */     //   0: bipush 20
/*      */     //   2: newarray byte
/*      */     //   4: astore_3
/*      */     //   5: iconst_0
/*      */     //   6: istore 4
/*      */     //   8: dload_1
/*      */     //   9: dconst_0
/*      */     //   10: dcmpg
/*      */     //   11: ifge +7 -> 18
/*      */     //   14: iconst_0
/*      */     //   15: goto +4 -> 19
/*      */     //   18: iconst_1
/*      */     //   19: istore 6
/*      */     //   21: dload_1
/*      */     //   22: invokestatic 146	java/lang/Math:abs	(D)D
/*      */     //   25: dstore_1
/*      */     //   26: dload_1
/*      */     //   27: dconst_1
/*      */     //   28: dcmpg
/*      */     //   29: ifge +75 -> 104
/*      */     //   32: iconst_0
/*      */     //   33: istore 10
/*      */     //   35: iload 10
/*      */     //   37: bipush 8
/*      */     //   39: if_icmpge +47 -> 86
/*      */     //   42: getstatic 147	oracle/sql/LnxLibThin:powerTable	[[D
/*      */     //   45: iload 10
/*      */     //   47: aaload
/*      */     //   48: iconst_2
/*      */     //   49: daload
/*      */     //   50: dload_1
/*      */     //   51: dcmpl
/*      */     //   52: iflt +28 -> 80
/*      */     //   55: iload 4
/*      */     //   57: getstatic 147	oracle/sql/LnxLibThin:powerTable	[[D
/*      */     //   60: iload 10
/*      */     //   62: aaload
/*      */     //   63: iconst_0
/*      */     //   64: daload
/*      */     //   65: d2i
/*      */     //   66: isub
/*      */     //   67: istore 4
/*      */     //   69: dload_1
/*      */     //   70: getstatic 147	oracle/sql/LnxLibThin:powerTable	[[D
/*      */     //   73: iload 10
/*      */     //   75: aaload
/*      */     //   76: iconst_1
/*      */     //   77: daload
/*      */     //   78: dmul
/*      */     //   79: dstore_1
/*      */     //   80: iinc 10 1
/*      */     //   83: goto -48 -> 35
/*      */     //   86: dload_1
/*      */     //   87: dconst_1
/*      */     //   88: dcmpg
/*      */     //   89: ifge +69 -> 158
/*      */     //   92: iinc 4 255
/*      */     //   95: dload_1
/*      */     //   96: ldc2_w 74
/*      */     //   99: dmul
/*      */     //   100: dstore_1
/*      */     //   101: goto +57 -> 158
/*      */     //   104: iconst_0
/*      */     //   105: istore 10
/*      */     //   107: iload 10
/*      */     //   109: bipush 8
/*      */     //   111: if_icmpge +47 -> 158
/*      */     //   114: getstatic 147	oracle/sql/LnxLibThin:powerTable	[[D
/*      */     //   117: iload 10
/*      */     //   119: aaload
/*      */     //   120: iconst_1
/*      */     //   121: daload
/*      */     //   122: dload_1
/*      */     //   123: dcmpg
/*      */     //   124: ifgt +28 -> 152
/*      */     //   127: iload 4
/*      */     //   129: getstatic 147	oracle/sql/LnxLibThin:powerTable	[[D
/*      */     //   132: iload 10
/*      */     //   134: aaload
/*      */     //   135: iconst_0
/*      */     //   136: daload
/*      */     //   137: d2i
/*      */     //   138: iadd
/*      */     //   139: istore 4
/*      */     //   141: dload_1
/*      */     //   142: getstatic 147	oracle/sql/LnxLibThin:powerTable	[[D
/*      */     //   145: iload 10
/*      */     //   147: aaload
/*      */     //   148: iconst_2
/*      */     //   149: daload
/*      */     //   150: dmul
/*      */     //   151: dstore_1
/*      */     //   152: iinc 10 1
/*      */     //   155: goto -48 -> 107
/*      */     //   158: iload 4
/*      */     //   160: bipush 62
/*      */     //   162: if_icmple +15 -> 177
/*      */     //   165: new 20	java/sql/SQLException
/*      */     //   168: dup
/*      */     //   169: iconst_3
/*      */     //   170: invokestatic 21	oracle/core/lmx/CoreException:getMessage	(B)Ljava/lang/String;
/*      */     //   173: invokespecial 22	java/sql/SQLException:<init>	(Ljava/lang/String;)V
/*      */     //   176: athrow
/*      */     //   177: iload 4
/*      */     //   179: bipush 191
/*      */     //   181: if_icmpge +15 -> 196
/*      */     //   184: new 20	java/sql/SQLException
/*      */     //   187: dup
/*      */     //   188: iconst_2
/*      */     //   189: invokestatic 21	oracle/core/lmx/CoreException:getMessage	(B)Ljava/lang/String;
/*      */     //   192: invokespecial 22	java/sql/SQLException:<init>	(Ljava/lang/String;)V
/*      */     //   195: athrow
/*      */     //   196: dload_1
/*      */     //   197: ldc2_w 58
/*      */     //   200: dcmpl
/*      */     //   201: iflt +7 -> 208
/*      */     //   204: iconst_0
/*      */     //   205: goto +4 -> 209
/*      */     //   208: iconst_1
/*      */     //   209: istore 5
/*      */     //   211: bipush 8
/*      */     //   213: istore 7
/*      */     //   215: iconst_0
/*      */     //   216: istore 9
/*      */     //   218: dload_1
/*      */     //   219: d2i
/*      */     //   220: i2b
/*      */     //   221: istore 8
/*      */     //   223: iload 9
/*      */     //   225: iload 7
/*      */     //   227: if_icmpge +30 -> 257
/*      */     //   230: aload_3
/*      */     //   231: iload 9
/*      */     //   233: iload 8
/*      */     //   235: bastore
/*      */     //   236: dload_1
/*      */     //   237: iload 8
/*      */     //   239: i2d
/*      */     //   240: dsub
/*      */     //   241: ldc2_w 74
/*      */     //   244: dmul
/*      */     //   245: dstore_1
/*      */     //   246: dload_1
/*      */     //   247: d2i
/*      */     //   248: i2b
/*      */     //   249: istore 8
/*      */     //   251: iinc 9 1
/*      */     //   254: goto -31 -> 223
/*      */     //   257: bipush 7
/*      */     //   259: istore 9
/*      */     //   261: iload 5
/*      */     //   263: ifeq +22 -> 285
/*      */     //   266: iload 8
/*      */     //   268: bipush 50
/*      */     //   270: if_icmplt +76 -> 346
/*      */     //   273: aload_3
/*      */     //   274: iload 9
/*      */     //   276: dup2
/*      */     //   277: baload
/*      */     //   278: iconst_1
/*      */     //   279: iadd
/*      */     //   280: i2b
/*      */     //   281: bastore
/*      */     //   282: goto +64 -> 346
/*      */     //   285: iload 4
/*      */     //   287: bipush 62
/*      */     //   289: if_icmpne +40 -> 329
/*      */     //   292: aload_3
/*      */     //   293: iload 9
/*      */     //   295: baload
/*      */     //   296: iconst_5
/*      */     //   297: iadd
/*      */     //   298: bipush 10
/*      */     //   300: idiv
/*      */     //   301: bipush 10
/*      */     //   303: imul
/*      */     //   304: bipush 100
/*      */     //   306: if_icmpne +23 -> 329
/*      */     //   309: aload_3
/*      */     //   310: iload 9
/*      */     //   312: aload_3
/*      */     //   313: iload 9
/*      */     //   315: baload
/*      */     //   316: iconst_5
/*      */     //   317: isub
/*      */     //   318: bipush 10
/*      */     //   320: idiv
/*      */     //   321: bipush 10
/*      */     //   323: imul
/*      */     //   324: i2b
/*      */     //   325: bastore
/*      */     //   326: goto +20 -> 346
/*      */     //   329: aload_3
/*      */     //   330: iload 9
/*      */     //   332: aload_3
/*      */     //   333: iload 9
/*      */     //   335: baload
/*      */     //   336: iconst_5
/*      */     //   337: iadd
/*      */     //   338: bipush 10
/*      */     //   340: idiv
/*      */     //   341: bipush 10
/*      */     //   343: imul
/*      */     //   344: i2b
/*      */     //   345: bastore
/*      */     //   346: aload_3
/*      */     //   347: iload 9
/*      */     //   349: baload
/*      */     //   350: bipush 100
/*      */     //   352: if_icmpne +39 -> 391
/*      */     //   355: iload 9
/*      */     //   357: ifne +14 -> 371
/*      */     //   360: iinc 4 1
/*      */     //   363: aload_3
/*      */     //   364: iload 9
/*      */     //   366: iconst_1
/*      */     //   367: bastore
/*      */     //   368: goto +23 -> 391
/*      */     //   371: aload_3
/*      */     //   372: iload 9
/*      */     //   374: iconst_0
/*      */     //   375: bastore
/*      */     //   376: iinc 9 255
/*      */     //   379: aload_3
/*      */     //   380: iload 9
/*      */     //   382: dup2
/*      */     //   383: baload
/*      */     //   384: iconst_1
/*      */     //   385: iadd
/*      */     //   386: i2b
/*      */     //   387: bastore
/*      */     //   388: goto -42 -> 346
/*      */     //   391: bipush 7
/*      */     //   393: istore 9
/*      */     //   395: iload 9
/*      */     //   397: ifeq +23 -> 420
/*      */     //   400: aload_3
/*      */     //   401: iload 9
/*      */     //   403: baload
/*      */     //   404: ifne +16 -> 420
/*      */     //   407: iload 7
/*      */     //   409: iconst_1
/*      */     //   410: isub
/*      */     //   411: i2b
/*      */     //   412: istore 7
/*      */     //   414: iinc 9 255
/*      */     //   417: goto -22 -> 395
/*      */     //   420: iload 7
/*      */     //   422: iconst_1
/*      */     //   423: iadd
/*      */     //   424: newarray byte
/*      */     //   426: astore 11
/*      */     //   428: aload 11
/*      */     //   430: iconst_0
/*      */     //   431: iload 4
/*      */     //   433: i2b
/*      */     //   434: bastore
/*      */     //   435: aload_3
/*      */     //   436: iconst_0
/*      */     //   437: aload 11
/*      */     //   439: iconst_1
/*      */     //   440: iload 7
/*      */     //   442: invokestatic 4	java/lang/System:arraycopy	(Ljava/lang/Object;ILjava/lang/Object;II)V
/*      */     //   445: aload 11
/*      */     //   447: iload 6
/*      */     //   449: invokestatic 148	oracle/sql/NUMBER:_toLnxFmt	([BZ)[B
/*      */     //   452: areturn } 
/* 6272 */   public byte[] lnxmin(long paramLong) { byte[] arrayOfByte1 = new byte[20];
/*      */ 
/* 6275 */     byte[] arrayOfByte2 = new byte[20];
/* 6276 */     int k = 0;
/*      */ 
/* 6278 */     if (paramLong == 0L)
/*      */     {
/* 6280 */       return NUMBER._makeZero();
/*      */     }
/*      */ 
/* 6285 */     boolean bool = paramLong >= 0L;
/*      */ 
/* 6296 */     for (int i = 0; paramLong != 0L; i++)
/*      */     {
/* 6299 */       arrayOfByte1[i] = ((byte)(int)Math.abs(paramLong % 100L));
/* 6300 */       paramLong /= 100L;
/*      */     }
/*      */ 
/* 6305 */     i--; int j = (byte)i;
/*      */ 
/* 6310 */     for (int m = j; k <= j; m--) {
/* 6311 */       arrayOfByte2[k] = arrayOfByte1[m];
/*      */ 
/* 6310 */       k = (byte)(k + 1);
/*      */     }
/*      */ 
/* 6315 */     while (i > 0)
/*      */     {
/* 6317 */       if (arrayOfByte2[(i--)] != 0) {
/*      */         break;
/*      */       }
/* 6320 */       k = (byte)(k - 1);
/*      */     }
/*      */ 
/* 6325 */     byte[] arrayOfByte3 = new byte[k + 1];
/* 6326 */     arrayOfByte3[0] = j;
/* 6327 */     System.arraycopy(arrayOfByte2, 0, arrayOfByte3, 1, k);
/*      */ 
/* 6331 */     return NUMBER._toLnxFmt(arrayOfByte3, bool);
/*      */   }
/*      */ 
/*      */   public double lnxnur(byte[] paramArrayOfByte)
/*      */   {
/* 6336 */     double d1 = 0.0D;
/*      */ 
/* 6338 */     int j = 1;
/*      */ 
/* 6342 */     int i1 = 0;
/*      */ 
/* 6346 */     int i4 = factorTable.length;
/*      */ 
/* 6353 */     byte[] arrayOfByte = NUMBER._fromLnxFmt(paramArrayOfByte);
/*      */ 
/* 6359 */     int i2 = arrayOfByte[1] < 10 ? 1 : 0;
/*      */ 
/* 6361 */     double d3 = factorTable[0][0];
/* 6362 */     double d4 = factorTable[0][0] - (i4 - 20);
/*      */     int i;
/*      */     int i3;
/* 6364 */     if ((arrayOfByte[0] > d3) || (arrayOfByte[0] < d4))
/*      */     {
/* 6366 */       if (arrayOfByte[0] > d3)
/*      */       {
/* 6368 */         i = -1;
/* 6369 */         i3 = (int)(arrayOfByte[0] - d3);
/*      */       }
/*      */       else
/*      */       {
/* 6373 */         i = -1 + (i4 - 20);
/* 6374 */         i3 = (int)(arrayOfByte[0] - d4);
/*      */       }
/*      */     }
/*      */     else
/*      */     {
/* 6379 */       i = -1 + (int)(d3 - arrayOfByte[0]);
/* 6380 */       i3 = 0;
/*      */     }
/*      */ 
/* 6384 */     int n = arrayOfByte.length - 1;
/*      */ 
/* 6386 */     if (i2 != 0 ? n > 8 : n >= 8)
/*      */     {
/* 6388 */       n = 8;
/* 6389 */       i1 = 1;
/*      */     }
/*      */     int m;
/*      */     double d2;
/* 6392 */     switch (n % 4)
/*      */     {
/*      */     case 3:
/* 6395 */       m = (arrayOfByte[1] * 100 + arrayOfByte[2]) * 100 + arrayOfByte[3];
/* 6396 */       i += 3;
/* 6397 */       d2 = factorTable[i][1];
/* 6398 */       if (d2 < 1.0D)
/* 6399 */         d1 = m / factorTable[i][2];
/*      */       else
/* 6401 */         d1 = m * factorTable[i][1];
/* 6402 */       j += 3;
/* 6403 */       n -= 3;
/* 6404 */       break;
/*      */     case 2:
/* 6406 */       m = arrayOfByte[1] * 100 + arrayOfByte[2];
/* 6407 */       i += 2;
/* 6408 */       d2 = factorTable[i][1];
/* 6409 */       if (d2 < 1.0D)
/* 6410 */         d1 = m / factorTable[i][2];
/*      */       else
/* 6412 */         d1 = m * factorTable[i][1];
/* 6413 */       j += 2;
/* 6414 */       n -= 2;
/* 6415 */       break;
/*      */     case 1:
/* 6417 */       m = arrayOfByte[1];
/* 6418 */       i++;
/* 6419 */       d2 = factorTable[i][1];
/* 6420 */       if (d2 < 1.0D)
/* 6421 */         d1 = m / factorTable[i][2];
/*      */       else
/* 6423 */         d1 = m * factorTable[i][1];
/* 6424 */       j++;
/* 6425 */       n--;
/* 6426 */       break;
/*      */     default:
/* 6428 */       d1 = 0.0D;
/*      */     }
/*      */ 
/* 6432 */     while (n > 0)
/*      */     {
/* 6434 */       m = ((arrayOfByte[j] * 100 + arrayOfByte[(j + 1)]) * 100 + arrayOfByte[(j + 2)]) * 100 + arrayOfByte[(j + 3)];
/*      */ 
/* 6438 */       i += 4;
/* 6439 */       d2 = factorTable[i][1];
/* 6440 */       if (d2 < 1.0D)
/* 6441 */         d1 += m / factorTable[i][2];
/*      */       else
/* 6443 */         d1 += m * factorTable[i][1];
/* 6444 */       j += 4;
/* 6445 */       n -= 4;
/*      */     }
/*      */ 
/* 6448 */     if (i1 != 0)
/*      */     {
/* 6450 */       if (i2 != 0)
/*      */       {
/* 6452 */         if (arrayOfByte[j] > 50)
/*      */         {
/* 6454 */           m = 1;
/* 6455 */           d1 += m * factorTable[i][1];
/*      */         }
/*      */       }
/*      */       else
/*      */       {
/* 6460 */         j--;
/* 6461 */         if (arrayOfByte[j] % 10 >= 5)
/*      */         {
/* 6463 */           m = (arrayOfByte[j] / 10 + 1) * 10;
/*      */         }
/*      */         else
/*      */         {
/* 6467 */           m = arrayOfByte[j] / 10 * 10;
/*      */         }
/* 6469 */         m -= arrayOfByte[j];
/* 6470 */         d1 += m * factorTable[i][1];
/*      */       }
/*      */     }
/*      */ 
/* 6474 */     if (i3 != 0)
/*      */     {
/* 6476 */       int k = 0;
/* 6477 */       while (i3 > 0)
/*      */       {
/* 6479 */         if ((int)powerTable[k][0] <= i3)
/*      */         {
/* 6481 */           i3 -= (int)powerTable[k][0];
/* 6482 */           d1 *= powerTable[k][1];
/*      */         }
/* 6484 */         k++;
/*      */       }
/* 6486 */       while (i3 < 0)
/*      */       {
/* 6488 */         if ((int)powerTable[k][0] <= -i3)
/*      */         {
/* 6490 */           i3 += (int)powerTable[k][0];
/* 6491 */           d1 *= powerTable[k][2];
/*      */         }
/* 6493 */         k++;
/*      */       }
/*      */     }
/*      */ 
/* 6497 */     return NUMBER._isPositive(paramArrayOfByte) ? d1 : -d1;
/*      */   }
/*      */ 
/*      */   public long lnxsni(byte[] paramArrayOfByte) throws SQLException
/*      */   {
/* 6502 */     long l = 0L;
/* 6503 */     byte[] arrayOfByte = NUMBER._fromLnxFmt(paramArrayOfByte);
/* 6504 */     int i = arrayOfByte[0];
/* 6505 */     int j = (byte)(arrayOfByte.length - 1);
/*      */ 
/* 6512 */     int k = j > i + 1 ? i + 1 : j;
/*      */ 
/* 6514 */     for (int m = 0; m < k; m++) {
/* 6515 */       l = l * 100L + arrayOfByte[(m + 1)];
/*      */     }
/*      */ 
/* 6520 */     for (m = i - j; m >= 0; m--) {
/* 6521 */       l *= 100L;
/*      */     }
/* 6523 */     return NUMBER._isPositive(paramArrayOfByte) ? l : -l;
/*      */   }
/*      */ 
/*      */   private byte[] lnxqh2n(char[] paramArrayOfChar)
/*      */   {
/* 7940 */     int i = 0;
/* 7941 */     int j = paramArrayOfChar.length;
/*      */ 
/* 7943 */     long[] arrayOfLong = new long[14];
/* 7944 */     int k = 13;
/* 7945 */     int m = 13;
/*      */ 
/* 7948 */     byte[] arrayOfByte1 = new byte[42];
/* 7949 */     int i1 = 1;
/*      */ 
/* 7958 */     while ((j != 0) && (paramArrayOfChar[(j - 1)] == 0))
/*      */     {
/* 7960 */       j--;
/*      */     }
/*      */ 
/* 7965 */     while ((j != 0) && (paramArrayOfChar[i] == '0'))
/*      */     {
/* 7967 */       i++;
/* 7968 */       j--;
/*      */     }
/*      */ 
/* 7973 */     if (j == 0)
/*      */     {
/* 7975 */       return NUMBER._makeZero();
/*      */     }
/*      */ 
/* 7980 */     arrayOfLong[m] = 0L;
/*      */ 
/* 7982 */     switch (j % 3)
/*      */     {
/*      */     case 0:
/* 7985 */       arrayOfLong[m] = LNXQH2N_DIGIT(paramArrayOfChar[i], 8, arrayOfLong[m]);
/* 7986 */       i++;
/* 7987 */       j--;
/*      */     case 2:
/* 7990 */       arrayOfLong[m] = LNXQH2N_DIGIT(paramArrayOfChar[i], 4, arrayOfLong[m]);
/* 7991 */       i++;
/* 7992 */       j--;
/*      */     case 1:
/* 7995 */       arrayOfLong[m] = LNXQH2N_DIGIT(paramArrayOfChar[i], 0, arrayOfLong[m]);
/* 7996 */       i++;
/* 7997 */       j--;
/* 7998 */       break;
/*      */     }
/*      */ 
/* 8006 */     while (j != 0)
/*      */     {
/* 8009 */       long l = 0L;
/* 8010 */       l = LNXQH2N_DIGIT(paramArrayOfChar[i], 8, l);
/* 8011 */       l = LNXQH2N_DIGIT(paramArrayOfChar[(i + 1)], 4, l);
/* 8012 */       l = LNXQH2N_DIGIT(paramArrayOfChar[(i + 2)], 0, l);
/*      */ 
/* 8014 */       for (n = m; n >= k; n--)
/*      */       {
/* 8016 */         l += (arrayOfLong[n] << 12);
/* 8017 */         arrayOfLong[n] = (l % 1000000L);
/* 8018 */         l /= 1000000L;
/*      */       }
/*      */ 
/* 8021 */       if (l != 0L)
/*      */       {
/* 8023 */         k--;
/* 8024 */         arrayOfLong[k] = l;
/*      */       }
/*      */ 
/* 8027 */       i += 3;
/* 8028 */       j -= 3;
/*      */     }
/*      */ 
/* 8033 */     int i4 = 3 * (m - k) + 1;
/* 8034 */     i4 += (arrayOfLong[k] >= 100L ? 1 : 0);
/* 8035 */     i4 += (arrayOfLong[k] >= 10000L ? 1 : 0);
/*      */ 
/* 8039 */     byte[] arrayOfByte3 = new byte[22];
/* 8040 */     int i5 = 0;
/*      */ 
/* 8044 */     arrayOfByte3[i5] = ((byte)(i4 + 192));
/*      */     byte[] arrayOfByte2;
/*      */     int i3;
/* 8048 */     if (i4 > 20)
/*      */     {
/* 8050 */       arrayOfByte2 = arrayOfByte1;
/* 8051 */       i2 = i1;
/* 8052 */       i3 = 21;
/*      */     }
/*      */     else
/*      */     {
/* 8056 */       arrayOfByte2 = arrayOfByte3;
/* 8057 */       i2 = i5 + 1;
/* 8058 */       i3 = i4 + 1;
/*      */     }
/*      */ 
/* 8063 */     switch (i4 % 3)
/*      */     {
/*      */     case 0:
/* 8066 */       arrayOfByte2[i2] = ((byte)(int)(arrayOfLong[k] / 10000L + 1L));
/* 8067 */       i2++;
/*      */     case 2:
/* 8070 */       arrayOfByte2[i2] = ((byte)(int)(arrayOfLong[k] % 10000L / 100L + 1L));
/* 8071 */       i2++;
/*      */     case 1:
/* 8074 */       arrayOfByte2[i2] = ((byte)(int)(arrayOfLong[k] % 100L + 1L));
/* 8075 */       i2++;
/* 8076 */       break;
/*      */     }
/*      */ 
/* 8084 */     for (int n = k + 1; n <= m; n++)
/*      */     {
/* 8087 */       arrayOfByte2[i2] = ((byte)(int)(arrayOfLong[n] / 10000L + 1L));
/* 8088 */       arrayOfByte2[(i2 + 1)] = ((byte)(int)(arrayOfLong[n] % 10000L / 100L + 1L));
/* 8089 */       arrayOfByte2[(i2 + 2)] = ((byte)(int)(arrayOfLong[n] % 100L + 1L));
/*      */ 
/* 8091 */       i2 += 3;
/*      */     }
/*      */ 
/* 8096 */     if (i4 > 20)
/*      */     {
/* 8099 */       i2 = i1 + 20;
/*      */ 
/* 8101 */       if (arrayOfByte1[i2] > 50)
/*      */       {
/* 8104 */         arrayOfByte1[(i1 - 1)] = 1;
/*      */ 
/* 8106 */         i2--;
/* 8107 */         while (arrayOfByte1[i2] == 100)
/*      */         {
/* 8109 */           i2--;
/* 8110 */           i3--;
/*      */         }
/*      */         int tmp672_670 = i2;
/*      */         byte[] tmp672_668 = arrayOfByte1; tmp672_668[tmp672_670] = ((byte)(tmp672_668[tmp672_670] + 1));
/*      */ 
/* 8115 */         if (i2 < i1)
/*      */         {
/* 8117 */           i1--;
/*      */           int tmp692_690 = i5;
/*      */           byte[] tmp692_688 = arrayOfByte3; tmp692_688[tmp692_690] = ((byte)(tmp692_688[tmp692_690] + 1));
/* 8119 */           i3 = 2;
/*      */         }
/*      */       }
/* 8122 */       for (int i6 = 0; i6 < i3; i6++) {
/* 8123 */         arrayOfByte3[(i5 + 1 + i6)] = arrayOfByte1[(i1 + i6)];
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 8128 */     int i2 = i5 + (i3 - 1);
/*      */ 
/* 8130 */     while (arrayOfByte2[i2] == 1)
/*      */     {
/* 8132 */       i2--;
/* 8133 */       i3--;
/*      */     }
/*      */ 
/* 8136 */     byte[] arrayOfByte4 = new byte[i3];
/* 8137 */     System.arraycopy(arrayOfByte3, 0, arrayOfByte4, 0, i3);
/*      */ 
/* 8139 */     return arrayOfByte4;
/*      */   }
/*      */ 
/*      */   private long LNXQH2N_DIGIT(char paramChar, int paramInt, long paramLong)
/*      */   {
/* 8155 */     if ((paramChar >= 'a') && (paramChar <= 'f'))
/*      */     {
/* 8157 */       l = paramLong + (paramChar - 'a' + 10 << paramInt);
/* 8158 */       return l;
/*      */     }
/*      */ 
/* 8161 */     if ((paramChar >= 'A') && (paramChar <= 'F'))
/*      */     {
/* 8163 */       l = paramLong + (paramChar - 'A' + 10 << paramInt);
/* 8164 */       return l;
/*      */     }
/*      */ 
/* 8167 */     long l = paramLong + (paramChar - '0' << paramInt);
/* 8168 */     return l;
/*      */   }
/*      */ 
/*      */   private byte[] lnxqtra(byte[] paramArrayOfByte, int paramInt)
/*      */     throws SQLException
/*      */   {
/* 8200 */     byte[] arrayOfByte1 = null;
/* 8201 */     byte[] arrayOfByte2 = null;
/* 8202 */     byte[] arrayOfByte3 = null;
/*      */ 
/* 8204 */     byte[] arrayOfByte4 = NUMBER.pi().shareBytes();
/* 8205 */     byte[] arrayOfByte5 = lnxmin(-1L);
/*      */ 
/* 8207 */     long l = 0L;
/*      */ 
/* 8211 */     if ((paramInt == 3) || (paramInt == 4) || (paramInt == 5))
/*      */     {
/* 8214 */       arrayOfByte3 = lnxmul(lnxqtwo, arrayOfByte4);
/*      */ 
/* 8217 */       arrayOfByte1 = lnxabs(paramArrayOfByte);
/*      */ 
/* 8224 */       arrayOfByte1 = lnxmod(arrayOfByte1, arrayOfByte3);
/* 8225 */       if (lnxcmp(arrayOfByte1, arrayOfByte4) > 0)
/*      */       {
/* 8227 */         arrayOfByte1 = lnxsub(arrayOfByte1, arrayOfByte3);
/*      */       }
/*      */ 
/* 8235 */       if (lnxsgn(paramArrayOfByte) == -1)
/*      */       {
/* 8237 */         arrayOfByte1 = lnxneg(arrayOfByte1);
/*      */       }
/*      */ 
/* 8241 */       arrayOfByte2 = lnxmul(arrayOfByte1, arrayOfByte1);
/*      */     }
/* 8243 */     else if (paramInt == 9)
/*      */     {
/* 8246 */       arrayOfByte1 = lnxmod(paramArrayOfByte, lnxqone);
/* 8247 */       arrayOfByte3 = lnxsub(paramArrayOfByte, arrayOfByte1);
/*      */ 
/* 8250 */       if ((arrayOfByte3[0] & 0xFF) < 60)
/*      */       {
/* 8252 */         return NUMBER._makeZero();
/*      */       }
/*      */ 
/* 8256 */       if ((arrayOfByte3[0] & 0xFF) > 195)
/*      */       {
/* 8258 */         return NUMBER._makePosInf();
/*      */       }
/*      */ 
/* 8262 */       l = lnxsni(arrayOfByte3);
/*      */ 
/* 8265 */       arrayOfByte2 = lnxmul(arrayOfByte1, arrayOfByte1);
/*      */     }
/*      */     else
/*      */     {
/* 8270 */       arrayOfByte1 = new byte[paramArrayOfByte.length];
/* 8271 */       System.arraycopy(paramArrayOfByte, 0, arrayOfByte1, 0, paramArrayOfByte.length);
/*      */ 
/* 8274 */       arrayOfByte2 = lnxmul(arrayOfByte1, arrayOfByte1);
/*      */     }
/*      */ 
/* 8278 */     byte[] arrayOfByte6 = null;
/* 8279 */     byte[] arrayOfByte7 = null;
/*      */     int i;
/* 8283 */     if ((paramInt != 4) && (paramInt != 7))
/*      */     {
/* 8286 */       arrayOfByte3 = lnxqone;
/* 8287 */       arrayOfByte6 = lnxqone;
/* 8288 */       arrayOfByte7 = NUMBER._makeZero();
/*      */ 
/* 8291 */       int j = 0;
/*      */       while (true)
/*      */       {
/* 8294 */         arrayOfByte3 = lnxmul(arrayOfByte2, arrayOfByte3);
/* 8295 */         i = (j + 1) * (j + 2);
/* 8296 */         j += 2;
/*      */ 
/* 8298 */         arrayOfByte3 = lnxqIDiv(arrayOfByte3, i);
/*      */ 
/* 8300 */         arrayOfByte7 = lnxadd(arrayOfByte7, arrayOfByte3);
/* 8301 */         arrayOfByte3 = lnxmul(arrayOfByte2, arrayOfByte3);
/* 8302 */         i = (j + 1) * (j + 2);
/* 8303 */         j += 2;
/*      */ 
/* 8305 */         arrayOfByte3 = lnxqIDiv(arrayOfByte3, i);
/*      */ 
/* 8307 */         arrayOfByte6 = lnxadd(arrayOfByte6, arrayOfByte3);
/*      */ 
/* 8309 */         if ((arrayOfByte3[0] & 0xFF) + 20 >= (arrayOfByte6[0] & 0xFF)) if ((arrayOfByte7[0] & 0xFF) == 255)
/*      */           {
/* 8312 */             break;
/*      */           }
/*      */       }
/*      */     }
/*      */ 
/* 8317 */     byte[] arrayOfByte8 = null;
/* 8318 */     byte[] arrayOfByte9 = null;
/*      */ 
/* 8321 */     if ((paramInt != 3) && (paramInt != 6))
/*      */     {
/* 8324 */       arrayOfByte3 = new byte[arrayOfByte1.length];
/* 8325 */       System.arraycopy(arrayOfByte1, 0, arrayOfByte3, 0, arrayOfByte1.length);
/*      */ 
/* 8327 */       arrayOfByte8 = new byte[arrayOfByte1.length];
/* 8328 */       System.arraycopy(arrayOfByte1, 0, arrayOfByte8, 0, arrayOfByte1.length);
/*      */ 
/* 8330 */       arrayOfByte9 = NUMBER._makeZero();
/*      */ 
/* 8333 */       int k = 1;
/*      */       while (true)
/*      */       {
/* 8336 */         arrayOfByte3 = lnxmul(arrayOfByte2, arrayOfByte3);
/* 8337 */         i = (k + 1) * (k + 2);
/* 8338 */         k += 2;
/*      */ 
/* 8340 */         arrayOfByte3 = lnxqIDiv(arrayOfByte3, i);
/*      */ 
/* 8342 */         arrayOfByte9 = lnxadd(arrayOfByte9, arrayOfByte3);
/* 8343 */         arrayOfByte3 = lnxmul(arrayOfByte2, arrayOfByte3);
/* 8344 */         i = (k + 1) * (k + 2);
/* 8345 */         k += 2;
/*      */ 
/* 8347 */         arrayOfByte3 = lnxqIDiv(arrayOfByte3, i);
/*      */ 
/* 8349 */         arrayOfByte8 = lnxadd(arrayOfByte8, arrayOfByte3);
/*      */ 
/* 8351 */         if (((arrayOfByte3[0] & 0xFF) != 128) || (arrayOfByte3.length != 1))
/*      */         {
/* 8356 */           if (((arrayOfByte3[0] & 0xFF) < 128) || ((arrayOfByte3[0] & 0xFF) + 20 >= (arrayOfByte8[0] & 0xFF)))
/*      */           {
/* 8362 */             if (((arrayOfByte3[0] & 0xFF) >= 128) || ((arrayOfByte3[0] & 0xFF) <= (arrayOfByte8[0] & 0xFF) + 20))
/*      */             {
/* 8368 */               if ((arrayOfByte9[0] & 0xFF) != 255) if ((arrayOfByte9[0] & 0xFF) == 0)
/*      */                 {
/* 8370 */                   break;
/*      */                 } 
/*      */             }
/*      */           }
/*      */         }
/*      */       }
/*      */     }
/* 8375 */     byte[] arrayOfByte10 = null;
/* 8376 */     byte[] arrayOfByte11 = null;
/*      */ 
/* 8379 */     if ((paramInt == 3) || (paramInt == 4) || (paramInt == 5))
/*      */     {
/* 8382 */       if ((paramInt == 3) || (paramInt == 5))
/*      */       {
/* 8385 */         arrayOfByte10 = lnxsub(arrayOfByte6, arrayOfByte7);
/* 8386 */         if (lnxcmp(arrayOfByte10, lnxqone) > 0)
/*      */         {
/* 8389 */           arrayOfByte10 = lnxqone;
/*      */         }
/* 8391 */         else if (lnxcmp(arrayOfByte10, arrayOfByte5) < 0)
/*      */         {
/* 8394 */           arrayOfByte10 = arrayOfByte5;
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/* 8399 */       if (paramInt == 3)
/*      */       {
/* 8401 */         return arrayOfByte10;
/*      */       }
/*      */ 
/* 8407 */       arrayOfByte11 = lnxsub(arrayOfByte8, arrayOfByte9);
/* 8408 */       if (lnxcmp(arrayOfByte11, lnxqone) > 0)
/*      */       {
/* 8411 */         arrayOfByte11 = lnxqone;
/*      */       }
/* 8413 */       else if (lnxcmp(arrayOfByte11, arrayOfByte5) < 0)
/*      */       {
/* 8416 */         arrayOfByte11 = arrayOfByte5;
/*      */       }
/*      */ 
/* 8420 */       if (paramInt == 4)
/*      */       {
/* 8422 */         return arrayOfByte11;
/*      */       }
/*      */ 
/* 8426 */       return lnxdiv(arrayOfByte11, arrayOfByte10);
/*      */     }
/*      */ 
/* 8431 */     if (paramInt == 6)
/*      */     {
/* 8433 */       return lnxadd(arrayOfByte6, arrayOfByte7);
/*      */     }
/*      */ 
/* 8438 */     if (paramInt == 7)
/*      */     {
/* 8440 */       return lnxadd(arrayOfByte8, arrayOfByte9);
/*      */     }
/*      */ 
/* 8445 */     arrayOfByte11 = lnxadd(arrayOfByte8, arrayOfByte9);
/* 8446 */     arrayOfByte10 = lnxadd(arrayOfByte6, arrayOfByte7);
/*      */ 
/* 8450 */     if (paramInt == 8)
/*      */     {
/* 8452 */       return lnxdiv(arrayOfByte11, arrayOfByte10);
/*      */     }
/*      */ 
/* 8457 */     byte[] arrayOfByte12 = NUMBER.e().shareBytes();
/*      */ 
/* 8459 */     byte[] arrayOfByte13 = lnxadd(arrayOfByte10, arrayOfByte11);
/* 8460 */     arrayOfByte1 = lnxpow(arrayOfByte12, (int)l);
/*      */ 
/* 8462 */     arrayOfByte13 = lnxmul(arrayOfByte13, arrayOfByte1);
/*      */ 
/* 8464 */     return arrayOfByte13;
/*      */   }
/*      */ 
/*      */   private byte[] lnxqtri(byte[] paramArrayOfByte, int paramInt)
/*      */     throws SQLException
/*      */   {
/* 8497 */     Object localObject = null;
/* 8498 */     byte[] arrayOfByte1 = null;
/* 8499 */     byte[] arrayOfByte2 = null;
/*      */ 
/* 8502 */     byte[] arrayOfByte3 = NUMBER.pi().shareBytes();
/* 8503 */     byte[] arrayOfByte4 = lnxdiv(arrayOfByte3, lnxqtwo);
/*      */ 
/* 8506 */     if (paramInt == 2)
/*      */     {
/* 8508 */       if (NUMBER._isPosInf(paramArrayOfByte))
/*      */       {
/* 8511 */         return arrayOfByte4;
/*      */       }
/* 8513 */       if (NUMBER._isNegInf(paramArrayOfByte))
/*      */       {
/* 8516 */         return lnxneg(arrayOfByte4);
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 8524 */     byte[] arrayOfByte5 = lnxabs(paramArrayOfByte);
/*      */ 
/* 8529 */     if ((paramInt == 1) || (paramInt == 0))
/*      */     {
/* 8532 */       if (lnxcmp(arrayOfByte5, lnxqone) > 0)
/*      */       {
/* 8536 */         throw new SQLException(CoreException.getMessage((byte)11));
/*      */       }
/*      */ 
/* 8546 */       if ((arrayOfByte5[0] & 0xFF) <= 183)
/*      */       {
/* 8548 */         if (paramInt == 1)
/*      */         {
/* 8550 */           byte[] arrayOfByte6 = new byte[paramArrayOfByte.length];
/* 8551 */           System.arraycopy(paramArrayOfByte, 0, arrayOfByte6, 0, paramArrayOfByte.length);
/* 8552 */           return arrayOfByte6;
/*      */         }
/*      */ 
/* 8557 */         return lnxsub(arrayOfByte4, paramArrayOfByte);
/*      */       }
/*      */ 
/* 8570 */       localObject = lnxsub(lnxqone, arrayOfByte5);
/* 8571 */       arrayOfByte1 = lnxadd(lnxqone, arrayOfByte5);
/* 8572 */       arrayOfByte5 = lnxdiv((byte[])localObject, arrayOfByte1);
/*      */ 
/* 8574 */       arrayOfByte5 = lnxsqr(arrayOfByte5);
/*      */     }
/*      */     int i;
/* 8586 */     if ((i = lnxcmp(arrayOfByte5, lnxqone)) > 0)
/*      */     {
/* 8588 */       arrayOfByte5 = lnxdiv(lnxqone, arrayOfByte5);
/*      */     }
/*      */ 
/* 8592 */     localObject = new byte[arrayOfByte5.length];
/* 8593 */     System.arraycopy(arrayOfByte5, 0, localObject, 0, arrayOfByte5.length);
/*      */ 
/* 8602 */     int j = 1;
/*      */     while (true)
/*      */     {
/* 8625 */       arrayOfByte1 = lnxtan((byte[])localObject);
/* 8626 */       arrayOfByte2 = lnxsub(arrayOfByte5, arrayOfByte1);
/* 8627 */       arrayOfByte1 = lnxmul(arrayOfByte1, arrayOfByte1);
/* 8628 */       arrayOfByte1 = lnxadd(arrayOfByte1, lnxqone);
/* 8629 */       arrayOfByte1 = lnxdiv(arrayOfByte2, arrayOfByte1);
/*      */ 
/* 8633 */       int k = (arrayOfByte1[0] & 0xFF) >= 128 ? (arrayOfByte1[0] & 0xFF) - 193 : 62 - (arrayOfByte1[0] & 0xFF);
/*      */ 
/* 8636 */       int m = (localObject[0] & 0xFF) >= 128 ? (localObject[0] & 0xFF) - 193 : 62 - (localObject[0] & 0xFF);
/*      */ 
/* 8640 */       if (((arrayOfByte1[0] & 0xFF) == 128) && (arrayOfByte1.length == 1))
/*      */       {
/*      */         break;
/*      */       }
/*      */ 
/* 8645 */       if ((k & 0xFF) + 15 < (m & 0xFF))
/*      */       {
/*      */         break;
/*      */       }
/*      */ 
/* 8650 */       if (j > 15)
/*      */       {
/*      */         break;
/*      */       }
/* 8654 */       localObject = lnxadd((byte[])localObject, arrayOfByte1);
/* 8655 */       j++;
/*      */     }
/*      */ 
/* 8659 */     if (i > 0)
/*      */     {
/* 8662 */       localObject = lnxsub(arrayOfByte4, (byte[])localObject);
/*      */     }
/*      */ 
/* 8666 */     if ((localObject[0] & 0xFF) < 128)
/*      */     {
/* 8668 */       localObject = NUMBER._makeZero();
/*      */     }
/*      */ 
/* 8672 */     if (lnxcmp((byte[])localObject, arrayOfByte4) > 0)
/*      */     {
/* 8674 */       localObject = arrayOfByte4;
/*      */     }
/*      */ 
/* 8682 */     if ((paramInt == 1) || (paramInt == 0))
/*      */     {
/* 8684 */       localObject = lnxmul((byte[])localObject, lnxqtwo);
/*      */     }
/*      */ 
/* 8687 */     switch (paramInt)
/*      */     {
/*      */     case 1:
/* 8694 */       if (NUMBER._isPositive(paramArrayOfByte))
/*      */       {
/* 8696 */         return lnxsub(arrayOfByte4, (byte[])localObject);
/*      */       }
/*      */ 
/* 8700 */       return lnxsub((byte[])localObject, arrayOfByte4);
/*      */     case 0:
/* 8708 */       if (NUMBER._isPositive(paramArrayOfByte))
/*      */       {
/* 8710 */         return localObject;
/*      */       }
/*      */ 
/* 8715 */       return lnxsub(arrayOfByte3, (byte[])localObject);
/*      */     case 2:
/* 8723 */       if (NUMBER._isPositive(paramArrayOfByte))
/*      */       {
/* 8725 */         return localObject;
/*      */       }
/*      */ 
/* 8730 */       return lnxneg((byte[])localObject);
/*      */     }
/*      */ 
/* 8739 */     throw new SQLException(CoreException.getMessage((byte)11));
/*      */   }
/*      */ 
/*      */   private int lnxcmp(byte[] paramArrayOfByte1, byte[] paramArrayOfByte2)
/*      */   {
/* 8754 */     return NUMBER.compareBytes(paramArrayOfByte1, paramArrayOfByte2);
/*      */   }
/*      */ 
/*      */   private int lnxsgn(byte[] paramArrayOfByte)
/*      */   {
/* 8770 */     if (NUMBER._isZero(paramArrayOfByte)) return 0;
/* 8771 */     if (NUMBER._isPositive(paramArrayOfByte)) {
/* 8772 */       return 1;
/*      */     }
/* 8774 */     return -1;
/*      */   }
/*      */ 
/*      */   private byte[] lnxqIDiv(byte[] paramArrayOfByte, int paramInt)
/*      */     throws SQLException
/*      */   {
/* 8786 */     byte[] arrayOfByte = lnxmin(paramInt);
/*      */ 
/* 8789 */     return lnxdiv(paramArrayOfByte, arrayOfByte);
/*      */   }
/*      */ 
/*      */   private static void _negateNumber(byte[] paramArrayOfByte)
/*      */   {
/* 8800 */     for (int i = paramArrayOfByte.length - 1; i > 0; i--)
/*      */     {
/* 8802 */       paramArrayOfByte[i] = LnxqNegate[paramArrayOfByte[i]];
/*      */     }
/* 8804 */     paramArrayOfByte[0] = ((byte)(paramArrayOfByte[0] ^ 0xFFFFFFFF));
/*      */   }
/*      */ 
/*      */   private static byte[] _setLength(byte[] paramArrayOfByte, int paramInt)
/*      */   {
/* 8814 */     boolean bool = NUMBER._isPositive(paramArrayOfByte);
/*      */     byte[] arrayOfByte;
/* 8818 */     if (bool)
/*      */     {
/* 8820 */       arrayOfByte = new byte[paramInt];
/*      */     }
/* 8825 */     else if ((paramInt <= 20) && (paramArrayOfByte[(paramInt - 1)] != 102))
/*      */     {
/* 8828 */       arrayOfByte = new byte[paramInt + 1];
/* 8829 */       arrayOfByte[paramInt] = 102;
/*      */     }
/*      */     else
/*      */     {
/* 8833 */       arrayOfByte = new byte[paramInt];
/*      */     }
/*      */ 
/* 8836 */     System.arraycopy(paramArrayOfByte, 0, arrayOfByte, 0, paramInt);
/* 8837 */     return arrayOfByte;
/*      */   }
/*      */ 
/*      */   private static class lnxqc
/*      */   {
/*      */     static final int LNXQC0 = 0;
/*      */     static final int LNXQC1 = 1;
/*      */     static final int LNXQC2 = 2;
/*      */     static final int LNXQC3 = 3;
/*      */     static final int LNXQC4 = 4;
/*      */     static final int LNXQC5 = 5;
/*      */     static final int LNXQC6 = 6;
/*      */     static final int LNXQC7 = 7;
/*      */     static final int LNXQC8 = 8;
/*      */     static final int LNXQC9 = 9;
/*      */     static final int LNXQCPLUS = 10;
/*      */     static final int LNXQCMINUS = 11;
/*      */     static final int LNXQCSPACE = 12;
/*      */     static final int LNXQCDOT = 13;
/*      */     static final int LNXQCCOMMA = 14;
/*      */     static final int LNXQCDOLLR = 15;
/*      */     static final int LNXQCLT = 16;
/*      */     static final int LNXQCGRT = 17;
/*      */     static final int LNXQCLPT = 18;
/*      */     static final int LNXQCRPT = 19;
/*      */     static final int LNXQCHASH = 20;
/*      */     static final int LNXQCTILDE = 21;
/*      */     static final int LNXQCASML = 22;
/*      */     static final int LNXQCBSML = 23;
/*      */     static final int LNXQCCSML = 24;
/*      */     static final int LNXQCDSML = 25;
/*      */     static final int LNXQCESML = 26;
/*      */     static final int LNXQCFSML = 27;
/*      */     static final int LNXQCGSML = 28;
/*      */     static final int LNXQCISML = 29;
/*      */     static final int LNXQCLSML = 30;
/*      */     static final int LNXQCMSML = 31;
/*      */     static final int LNXQCPSML = 32;
/*      */     static final int LNXQCRSML = 33;
/*      */     static final int LNXQCSSML = 34;
/*      */     static final int LNXQCTSML = 35;
/*      */     static final int LNXQCVSML = 36;
/*      */     static final int LNXQCALRG = 37;
/*      */     static final int LNXQCBLRG = 38;
/*      */     static final int LNXQCCLRG = 39;
/*      */     static final int LNXQCDLRG = 40;
/*      */     static final int LNXQCELRG = 41;
/*      */     static final int LNXQCFLRG = 42;
/*      */     static final int LNXQCILRG = 43;
/*      */     static final int LNXQCLLRG = 44;
/*      */     static final int LNXQCMLRG = 45;
/*      */     static final int LNXQCPLRG = 46;
/*      */     static final int LNXQCRLRG = 47;
/*      */     static final int LNXQCSLRG = 48;
/*      */     static final int LNXQCTLRG = 49;
/*      */   }
/*      */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.sql.LnxLibThin
 * JD-Core Version:    0.6.2
 */