/*      */ package oracle.sql;
/*      */ 
/*      */ import java.sql.SQLException;
/*      */ import java.sql.Timestamp;
/*      */ import java.text.DateFormatSymbols;
/*      */ import java.text.DecimalFormat;
/*      */ import java.text.DecimalFormatSymbols;
/*      */ import java.text.NumberFormat;
/*      */ import java.text.ParsePosition;
/*      */ import java.text.SimpleDateFormat;
/*      */ import java.util.Calendar;
/*      */ import java.util.Date;
/*      */ import java.util.GregorianCalendar;
/*      */ import java.util.Locale;
/*      */ import oracle.core.lmx.CoreException;
/*      */ import oracle.jdbc.driver.OracleLocale;
/*      */ 
/*      */ class LdxLibThin
/*      */   implements LdxLib
/*      */ {
/*      */   private static final int LDXFDLSZ = 50;
/*      */   private static final byte LDX_CC = 1;
/*      */   private static final byte LDX_SCC = 2;
/*      */   private static final byte LDX_I = 3;
/*      */   private static final byte LDX_Y = 4;
/*      */   private static final byte LDX_IY = 5;
/*      */   private static final byte LDX_YY = 6;
/*      */   private static final byte LDX_IYY = 7;
/*      */   private static final byte LDX_YYY = 8;
/*      */   private static final byte LDX_IYYY = 9;
/*      */   private static final byte LDX_YYYY = 10;
/*      */   private static final byte LDX_YCYYY = 11;
/*      */   private static final byte LDX_SYYYY = 12;
/*      */   private static final byte LDX_SYCYYY = 13;
/*      */   private static final byte LDX_YEAR = 14;
/*      */   private static final byte LDX_SYEAR = 15;
/*      */   private static final byte LDX_Q = 16;
/*      */   private static final byte LDX_MM = 17;
/*      */   private static final byte LDX_IW = 18;
/*      */   private static final byte LDX_WW = 19;
/*      */   private static final byte LDX_W = 20;
/*      */   private static final byte LDX_D = 21;
/*      */   private static final byte LDX_DD = 22;
/*      */   private static final byte LDX_DDD = 23;
/*      */   private static final byte LDX_HH24 = 24;
/*      */   private static final byte LDX_HH = 25;
/*      */   private static final byte LDX_MI = 26;
/*      */   private static final byte LDX_SS = 27;
/*      */   private static final byte LDX_SSSSS = 28;
/*      */   private static final byte LDX_J = 29;
/*      */   private static final byte LDX_MONTH = 30;
/*      */   private static final byte LDX_MON = 31;
/*      */   private static final byte LDX_DAY = 32;
/*      */   private static final byte LDX_DY = 33;
/*      */   private static final byte LDX_AMPM = 34;
/*      */   private static final byte LDX_A_M_P_M = 35;
/*      */   private static final byte LDX_BCAD = 36;
/*      */   private static final byte LDX_B_C_A_D = 37;
/*      */   private static final byte LDX_RM = 38;
/*      */   private static final byte LDX_FM = 39;
/*      */   private static final byte LDX_RR = 40;
/*      */   private static final byte LDX_RRRR = 41;
/*      */   private static final byte LDX_FX = 42;
/*      */   private static final byte LDX_E = 43;
/*      */   private static final byte LDX_EE = 44;
/*      */   private static final byte LDX_LIT = 45;
/*      */   private static final byte LDX_JUS = 16;
/*      */   private static final byte LDX_NTH = 1;
/*      */   private static final byte LDX_SPL = 2;
/*      */   private static final byte LDX_CAP = 4;
/*      */   private static final byte LDX_UPR = 8;
/*      */   private static final byte LDX_QUO = 1;
/*      */   private static final byte LDX_SPA = 2;
/*      */   private static final byte LDX_PUN = 4;
/*      */   private static final byte LDX_ALPHA = -128;
/*      */   private static final byte LDXFNJUS = 64;
/*      */   private static final byte LDX_NEG = 32;
/*      */   private static final byte LDX_COMMA = 16;
/*      */   private static final byte LDX_LEN = 15;
/*      */   private static final byte LDXFL_NOT = 0;
/*      */   private static final byte LDXFL_FLEX = 1;
/*      */   private static final byte LDXFL_STD = 2;
/*      */   private static final byte LDXFL_MDONE = 4;
/*      */   private static final byte LDXFL_YDONE = 8;
/*      */   private static final byte LDXFL_PUNC = 16;
/*      */   private static final byte LDXFL_MSEC = 32;
/*      */   private static final int LDXSBUFFERSIZE = 64;
/*      */   private static final int LDXWBUFSIZE = 64;
/*      */   private static final int LDXTCE = 0;
/*      */   private static final int LDXTYE = 1;
/*      */   private static final int LDXTMO = 2;
/*      */   private static final int LDXTDA = 3;
/*      */   private static final int LDXTHO = 4;
/*      */   private static final int LDXTMI = 5;
/*      */   private static final int LDXTSO = 6;
/*      */   private static final int LDXTSIZ = 7;
/*      */   private static final int LDX_SUNDAY = 2445029;
/*      */   private static final int LDXPMXYR = 9999;
/*      */   private static final int LDXPMNYR = -4712;
/* 2038 */   private static final char[][] ldxfda = { { 'A', '.', 'D', '.' }, { 'A', '.', 'M', '.' }, { 'A', 'D' }, { 'A', 'M' }, { 'B', '.', 'C', '.' }, { 'B', 'C' }, { 'C', 'C' }, { 'D' }, { 'D', 'A', 'Y' }, { 'D', 'D' }, { 'D', 'D', 'D' }, { 'D', 'Y' }, { 'E' }, { 'E', 'E' }, { 'F', 'M' }, { 'F', 'X' }, { 'H', 'H' }, { 'H', 'H', '1', '2' }, { 'H', 'H', '2', '4' }, { 'I' }, { 'I', 'W' }, { 'I', 'Y' }, { 'I', 'Y', 'Y' }, { 'I', 'Y', 'Y', 'Y' }, { 'J' }, { 'M', 'I' }, { 'M', 'M' }, { 'M', 'O', 'N' }, { 'M', 'O', 'N', 'T', 'H' }, { 'P', '.', 'M', '.' }, { 'P', 'M' }, { 'Q' }, { 'R', 'M' }, { 'R', 'R' }, { 'R', 'R', 'R', 'R' }, { 'S', 'C', 'C' }, { 'S', 'S' }, { 'S', 'S', 'S', 'S', 'S' }, { 'S', 'Y', ',', 'Y', 'Y', 'Y' }, { 'S', 'Y', 'E', 'A', 'R' }, { 'S', 'Y', 'Y', 'Y', 'Y' }, { 'W' }, { 'W', 'W' }, { 'Y' }, { 'Y', ',', 'Y', 'Y', 'Y' }, { 'Y', 'E', 'A', 'R' }, { 'Y', 'Y' }, { 'Y', 'Y', 'Y' }, { 'Y', 'Y', 'Y', 'Y' }, { '\000' } };
/*      */ 
/* 2094 */   private static final byte[] ldxfdc = { 37, 35, 36, 34, 37, 36, 1, 21, 32, 22, 23, 33, 43, 44, 39, 42, 25, 25, 24, 3, 18, 5, 7, 9, 29, 26, 17, 31, 30, 35, 34, 16, 38, 40, 41, 2, 27, 28, 13, 15, 12, 20, 19, 4, 11, 14, 6, 8, 10, 0 };
/*      */ 
/* 2157 */   private static final byte[] ldxfcdlen = { 0, 2, 35, 1, 1, 2, 2, 3, 3, 4, 4, 21, 37, 54, -60, -27, 1, 2, 2, 2, 1, 1, 2, 3, 2, 2, 2, 2, 5, 7, -128, -128, -128, -128, -62, -60, -62, -60, -124, 0, 2, 4, 0, -113, -98, -128, -128 };
/*      */ 
/* 2212 */   private static int[] ldxfdi = { 0, 4, 6, 7, 12, 14, -2147483648, 16, 19, 24, -2147483648, -2147483648, 25, -2147483648, -2147483648, 29, 31, 32, 35, -2147483648, -2147483648, -2147483648, 41, -2147483648, 43, -2147483648 };
/*      */ 
/* 2242 */   private static final char[][] ldxfdx = { { 'S', 'P' }, { 'S', 'P', 'T', 'H' }, { 'T', 'H' }, { 'T', 'H', 'S', 'P' }, { '\000' } };
/*      */ 
/* 2251 */   private static final byte[] ldxfdxc = { 2, 3, 1, 3, 0 };
/*      */ 
/* 2262 */   private static final byte[] NULLFMT = { 0, 16 };
/*      */ 
/* 2267 */   private static final byte[] DEFAULT_FORMAT = { 22, 24, 46, 4, 47, 31, 24, 46, 4, 47, 10, 24 };
/*      */ 
/* 2274 */   private static final String[] ldxpaa = { "A.D.", "A.M.", "B.C.", "P.M." };
/*      */ 
/* 2283 */   private static final int[] ldxdom = { 0, 0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334, 365 };
/*      */ 
/* 2301 */   private final byte[][] ldxpmxa = { { 23, 29 }, { 4, 6, 8, 10, 12, 11, 13 }, { 25, 24 }, { 34, 35 }, { 36, 37 }, { 30, 31, 17, 38 }, { 32, 33, 21 }, { 34, 35, 24 }, { 12, 13, 36, 37 } };
/*      */ 
/*      */   public byte[] ldxadm(byte[] paramArrayOfByte, int paramInt)
/*      */     throws SQLException
/*      */   {
/*   93 */     int j = ((paramArrayOfByte[0] & 0xFF) - 100) * 100 + ((paramArrayOfByte[1] & 0xFF) - 100);
/*      */ 
/*   95 */     int i = j;
/*      */ 
/*   97 */     int k = paramArrayOfByte[2] & 0xFF;
/*      */ 
/*   99 */     int m = paramArrayOfByte[3] & 0xFF;
/*      */ 
/*  101 */     paramInt += (paramArrayOfByte[2] & 0xFF) + i * 12;
/*      */ 
/*  104 */     if (paramInt > 0)
/*      */     {
/*  106 */       if ((i = paramInt / 12) > 9999) {
/*  107 */         throw new SQLException(CoreException.getMessage((byte)8));
/*      */       }
/*  109 */       if (paramInt %= 12 == 0)
/*      */       {
/*  111 */         i--;
/*  112 */         paramInt = 12;
/*      */       }
/*      */     }
/*      */     else
/*      */     {
/*  117 */       if ((i = paramInt / 12 - 1) < -4712) {
/*  118 */         throw new SQLException(CoreException.getMessage((byte)8));
/*      */       }
/*  120 */       paramInt = paramInt % 12 + 12;
/*      */     }
/*      */ 
/*  124 */     int i1 = (paramInt == 2) && (ldxisl(j)) ? 29 : ldxdom[(k + 1)] - ldxdom[k];
/*      */ 
/*  128 */     paramArrayOfByte[0] = ((byte)(i / 100 + 100));
/*  129 */     paramArrayOfByte[1] = ((byte)(i % 100 + 100));
/*      */ 
/*  131 */     paramArrayOfByte[2] = ((byte)paramInt);
/*  132 */     int n = (paramInt == 2) && (ldxisl(i)) ? 29 : ldxdom[(paramInt + 1)] - ldxdom[paramInt];
/*      */ 
/*  135 */     paramArrayOfByte[3] = ((byte)((m == i1) || (m > n) ? n : m));
/*      */ 
/*  137 */     return paramArrayOfByte;
/*      */   }
/*      */ 
/*      */   public byte[] ldxads(byte[] paramArrayOfByte, int paramInt1, int paramInt2)
/*      */     throws SQLException
/*      */   {
/*  157 */     if (paramInt2 != 0)
/*      */     {
/*  159 */       paramInt2 += ((paramArrayOfByte[4] - 1) * 60 + (paramArrayOfByte[5] - 1)) * 60 + (paramArrayOfByte[6] - 1);
/*  160 */       paramInt1 += paramInt2 / 86400;
/*      */ 
/*  162 */       if (paramInt2 %= 86400 < 0)
/*      */       {
/*  164 */         paramInt2 += 86400;
/*  165 */         paramInt1--;
/*      */       }
/*      */ 
/*  168 */       paramArrayOfByte[4] = ((byte)(paramInt2 / 3600 + 1));
/*  169 */       paramArrayOfByte[5] = ((byte)(paramInt2 % 3600 / 60 + 1));
/*  170 */       paramArrayOfByte[6] = ((byte)(paramInt2 % 3600 % 60 + 1));
/*      */     }
/*      */ 
/*  174 */     int i = ((paramArrayOfByte[0] & 0xFF) - 100) * 100 + ((paramArrayOfByte[1] & 0xFF) - 100);
/*      */ 
/*  177 */     if (paramInt1 != 0)
/*      */     {
/*  179 */       paramInt1 += ldxctj(i, paramArrayOfByte[2], paramArrayOfByte[3]);
/*      */ 
/*  181 */       if (paramInt1 < 1) {
/*  182 */         throw new SQLException(CoreException.getMessage((byte)8));
/*      */       }
/*      */ 
/*  186 */       paramArrayOfByte = ldxjtc(paramInt1, paramArrayOfByte);
/*      */     }
/*      */ 
/*  190 */     i = ((paramArrayOfByte[0] & 0xFF) - 100) * 100 + ((paramArrayOfByte[1] & 0xFF) - 100);
/*      */ 
/*  193 */     if (i > 9999) {
/*  194 */       throw new SQLException(CoreException.getMessage((byte)8));
/*      */     }
/*      */ 
/*  197 */     return paramArrayOfByte;
/*      */   }
/*      */ 
/*      */   public int ldxchk(byte[] paramArrayOfByte)
/*      */     throws SQLException
/*      */   {
/*  229 */     throw new SQLException(CoreException.getMessage((byte)1));
/*      */   }
/*      */ 
/*      */   public byte[] ldxdfd(int paramInt1, int paramInt2)
/*      */     throws SQLException
/*      */   {
/*  245 */     throw new SQLException(CoreException.getMessage((byte)1));
/*      */   }
/*      */ 
/*      */   public void ldxdtd(byte[] paramArrayOfByte, int[] paramArrayOfInt1, int[] paramArrayOfInt2)
/*      */     throws SQLException
/*      */   {
/*  261 */     throw new SQLException(CoreException.getMessage((byte)1));
/*      */   }
/*      */ 
/*      */   public String ldxdts(byte[] paramArrayOfByte, String paramString1, String paramString2)
/*      */     throws SQLException
/*      */   {
/*  285 */     return ldxdts(paramArrayOfByte, ldxsto(paramString1, paramString2), paramString2);
/*      */   }
/*      */ 
/*      */   public String ldxdts(byte[] paramArrayOfByte1, byte[] paramArrayOfByte2, String paramString)
/*      */     throws SQLException
/*      */   {
/*  309 */     int i = 0;
/*      */ 
/*  311 */     int k = 0;
/*  312 */     int m = 0;
/*      */ 
/*  314 */     int i1 = 0;
/*      */ 
/*  316 */     int i3 = 0;
/*  317 */     int i4 = 0;
/*  318 */     String str1 = null;
/*      */ 
/*  321 */     StringBuffer localStringBuffer1 = new StringBuffer(64);
/*      */ 
/*  323 */     StringBuffer localStringBuffer2 = null;
/*      */ 
/*  335 */     if ((paramArrayOfByte2.length == 0) || (paramArrayOfByte2 == null) || ((paramArrayOfByte2[0] == 0) && (paramArrayOfByte2[1] == 16)))
/*      */     {
/*  338 */       paramArrayOfByte2 = DEFAULT_FORMAT;
/*      */     }
/*      */ 
/*  341 */     int n = paramArrayOfByte2.length;
/*      */     Locale localLocale;
/*  345 */     if ((paramString != null) && (paramString.compareTo("") != 0))
/*      */     {
/*  353 */       i4 = paramString.indexOf("_");
/*  354 */       if (i4 == -1)
/*      */       {
/*  356 */         localLocale = LxMetaData.getJavaLocale(paramString, "");
/*      */       }
/*      */       else
/*      */       {
/*  361 */         String str2 = paramString.substring(0, i4);
/*  362 */         String str3 = paramString.substring(i4 + 1);
/*  363 */         localLocale = LxMetaData.getJavaLocale(str2, str3);
/*      */       }
/*  365 */       if (localLocale == null)
/*      */       {
/*  371 */         localLocale = OracleLocale.getDefault();
/*      */       }
/*      */ 
/*      */     }
/*      */     else
/*      */     {
/*  381 */       localLocale = OracleLocale.getDefault();
/*      */     }
/*      */ 
/*  390 */     i3 = ((paramArrayOfByte1[0] & 0xFF) - 100) * 100 + ((paramArrayOfByte1[1] & 0xFF) - 100);
/*      */ 
/*  395 */     while (m < n)
/*      */     {
/*  398 */       i = paramArrayOfByte2[(m++)];
/*  399 */       k = paramArrayOfByte2[(m++)];
/*      */ 
/*  402 */       if (i == 0)
/*      */       {
/*      */         break;
/*      */       }
/*  406 */       if (i >= 45)
/*      */       {
/*  409 */         int i2 = i - 45;
/*      */ 
/*  413 */         localStringBuffer1.append(new String(paramArrayOfByte2, m, i2));
/*      */ 
/*  415 */         m += i2;
/*      */       }
/*      */       else
/*      */       {
/*  421 */         int j = ldxfcdlen[i];
/*      */         StringBuffer localStringBuffer3;
/*  427 */         if ((((j & 0xFFFFFF80) != 0) && ((k & 0xC) != 0)) || (((k & 0x10) != 0) && ((j & 0x40) == 0)) || (((k & 0xC) != 0) && ((k & 0x3) != 0)))
/*      */         {
/*  433 */           localStringBuffer2 = new StringBuffer(64);
/*  434 */           localStringBuffer3 = localStringBuffer2;
/*      */         }
/*      */         else {
/*  437 */           localStringBuffer3 = localStringBuffer1;
/*      */         }
/*      */         int i5;
/*      */         int i6;
/*  439 */         switch (i)
/*      */         {
/*      */         case 37:
/*  442 */           if ((localLocale.getCountry().compareTo("US") == 0) && (localLocale.getLanguage().compareTo("en") == 0))
/*      */           {
/*  445 */             str1 = paramArrayOfByte1[0] < 100 ? ldxpaa[2] : ldxpaa[0];
/*      */           }
/*      */           else
/*  448 */             i--;
/*      */         case 36:
/*  450 */           localStringBuffer3.append(new DateFormatSymbols(localLocale).getEras()[1]);
/*      */ 
/*  455 */           i5 = localStringBuffer3.length();
/*  456 */           break;
/*      */         case 35:
/*  458 */           if ((localLocale.getCountry().compareTo("US") == 0) && (localLocale.getLanguage().compareTo("en") == 0))
/*      */           {
/*  461 */             str1 = paramArrayOfByte1[4] - 1 >= 12 ? ldxpaa[3] : ldxpaa[1];
/*      */           }
/*      */           else
/*  464 */             i--;
/*      */         case 34:
/*  466 */           localStringBuffer3.append(new DateFormatSymbols(localLocale).getAmPmStrings()[0]);
/*      */ 
/*  470 */           i5 = localStringBuffer3.length();
/*  471 */           break;
/*      */         case 29:
/*  473 */           i4 = ldxctj(i3, paramArrayOfByte1[2], paramArrayOfByte1[3]);
/*  474 */           break;
/*      */         case 21:
/*  476 */           i4 = ldxdow(i3, paramArrayOfByte1[2], paramArrayOfByte1[3], localLocale);
/*  477 */           break;
/*      */         case 32:
/*      */         case 33:
/*  481 */           i6 = ldxdow(i3, paramArrayOfByte1[2], paramArrayOfByte1[3], localLocale);
/*      */ 
/*  485 */           Calendar localCalendar = GregorianCalendar.getInstance(localLocale);
/*  486 */           if (localCalendar.getFirstDayOfWeek() > 1)
/*  487 */             i6++;
/*  488 */           if (i6 > 7)
/*  489 */             i6 -= 7;
/*  490 */           if (i6 == 0)
/*  491 */             i6++;
/*      */           String[] arrayOfString1;
/*  494 */           if (i == 32)
/*  495 */             arrayOfString1 = new DateFormatSymbols(localLocale).getWeekdays();
/*      */           else {
/*  497 */             arrayOfString1 = new DateFormatSymbols(localLocale).getShortWeekdays();
/*      */           }
/*  499 */           localStringBuffer3.append(arrayOfString1[i6]);
/*  500 */           i5 = localStringBuffer3.length();
/*  501 */           break;
/*      */         case 1:
/*      */         case 2:
/*  506 */           if ((i4 = i3) > 0)
/*  507 */             i4 = (i4 - 1) / 100 + 1;
/*      */           else
/*  509 */             i4 = -((-1 - i4) / 100) - 1;
/*  510 */           break;
/*      */         case 22:
/*  512 */           i4 = paramArrayOfByte1[3];
/*  513 */           break;
/*      */         case 43:
/*      */         case 44:
/*  516 */           throw new SQLException(CoreException.getMessage((byte)1));
/*      */         case 24:
/*      */         case 25:
/*  521 */           i4 = paramArrayOfByte1[4] - 1;
/*  522 */           if (i == 25)
/*  523 */             i4 = i4 == 0 ? 12 : i4 > 12 ? i4 - 12 : i4; break;
/*      */         case 26:
/*  526 */           i4 = paramArrayOfByte1[5] - 1;
/*  527 */           break;
/*      */         case 16:
/*  529 */           i4 = (paramArrayOfByte1[2] + 2) / 3;
/*  530 */           break;
/*      */         case 17:
/*  532 */           i4 = paramArrayOfByte1[2];
/*  533 */           break;
/*      */         case 30:
/*      */         case 31:
/*  536 */           i4 = paramArrayOfByte1[2];
/*      */           String[] arrayOfString2;
/*  537 */           if (i == 30)
/*  538 */             arrayOfString2 = new DateFormatSymbols(localLocale).getMonths();
/*      */           else {
/*  540 */             arrayOfString2 = new DateFormatSymbols(localLocale).getShortMonths();
/*      */           }
/*      */ 
/*  543 */           localStringBuffer3.append(arrayOfString2[(--i4)]);
/*  544 */           i5 = localStringBuffer3.length();
/*  545 */           break;
/*      */         case 38:
/*  547 */           throw new SQLException(CoreException.getMessage((byte)1));
/*      */         case 27:
/*  551 */           i4 = paramArrayOfByte1[6] - 1;
/*  552 */           break;
/*      */         case 28:
/*  554 */           i4 = ((paramArrayOfByte1[4] - 1) * 60 + (paramArrayOfByte1[5] - 1)) * 60 + (paramArrayOfByte1[6] - 1);
/*      */ 
/*  556 */           break;
/*      */         case 20:
/*  558 */           i4 = (paramArrayOfByte1[3] + 6) / 7;
/*  559 */           break;
/*      */         case 23:
/*  561 */           i4 = ldxcty(i3, paramArrayOfByte1[2], paramArrayOfByte1[3]);
/*  562 */           break;
/*      */         case 18:
/*  564 */           throw new SQLException(CoreException.getMessage((byte)1));
/*      */         case 19:
/*  568 */           i4 = (ldxcty(i3, paramArrayOfByte1[2], paramArrayOfByte1[3]) + 6) / 7;
/*  569 */           break;
/*      */         case 3:
/*  571 */           throw new SQLException(CoreException.getMessage((byte)1));
/*      */         case 4:
/*  575 */           i4 = i3 % 10;
/*  576 */           break;
/*      */         case 5:
/*  578 */           throw new SQLException(CoreException.getMessage((byte)1));
/*      */         case 6:
/*      */         case 40:
/*  583 */           i4 = i3 % 100;
/*  584 */           break;
/*      */         case 7:
/*  586 */           throw new SQLException(CoreException.getMessage((byte)1));
/*      */         case 8:
/*  590 */           i4 = i3 % 1000;
/*  591 */           break;
/*      */         case 10:
/*      */         case 11:
/*      */         case 12:
/*      */         case 13:
/*      */         case 41:
/*  597 */           i4 = i3;
/*  598 */           break;
/*      */         case 9:
/*  600 */           throw new SQLException(CoreException.getMessage((byte)1));
/*      */         case 14:
/*      */         case 15:
/*  605 */           throw new SQLException(CoreException.getMessage((byte)1));
/*      */         case 42:
/*  609 */           break;
/*      */         case 39:
/*      */         default:
/*  611 */           throw new SQLException(CoreException.getMessage((byte)7));
/*      */ 
/*  616 */           if ((j & 0xFFFFFF80) == 0)
/*      */           {
/*  621 */             if ((j & 0x20) == 0)
/*      */             {
/*  623 */               if (i4 < 0) {
/*  624 */                 i4 = -i4;
/*      */               }
/*      */ 
/*      */             }
/*  632 */             else if (i4 >= 0)
/*      */             {
/*  634 */               localStringBuffer3.insert(0, " ");
/*  635 */               j = (byte)(j - 1);
/*      */             }
/*  637 */             if ((k & 0x2) != 0)
/*      */             {
/*  640 */               throw new SQLException(CoreException.getMessage((byte)1));
/*      */             }
/*      */ 
/*  647 */             if ((k & 0x10) != 0)
/*  648 */               i5 = j & 0xF;
/*      */             else {
/*  650 */               i5 = 0;
/*      */             }
/*      */ 
/*  656 */             String str4 = lxi42b(64, i4, i5, (j & 0x10) != 0, localLocale);
/*      */ 
/*  659 */             localStringBuffer3.append(str4);
/*      */ 
/*  661 */             if ((k & 0x1) != 0)
/*      */             {
/*  664 */               throw new SQLException(CoreException.getMessage((byte)1));
/*      */             }
/*      */ 
/*      */           }
/*  676 */           else if (((k & 0x10) != 0) && ((j & 0x40) == 0))
/*      */           {
/*      */             String[] arrayOfString3;
/*  681 */             switch (i)
/*      */             {
/*      */             case 33:
/*  684 */               arrayOfString3 = new DateFormatSymbols(localLocale).getShortWeekdays();
/*  685 */               break;
/*      */             case 32:
/*  687 */               arrayOfString3 = new DateFormatSymbols(localLocale).getWeekdays();
/*  688 */               break;
/*      */             case 31:
/*  690 */               arrayOfString3 = new DateFormatSymbols(localLocale).getShortMonths();
/*  691 */               break;
/*      */             case 30:
/*  693 */               arrayOfString3 = new DateFormatSymbols(localLocale).getMonths();
/*  694 */               break;
/*      */             default:
/*  697 */               throw new SQLException(CoreException.getMessage((byte)7));
/*      */             }
/*      */ 
/*  702 */             i6 = 0;
/*      */ 
/*  705 */             for (int i7 = 0; i7 < arrayOfString3.length; i7++)
/*      */             {
/*  707 */               i4 = arrayOfString3[i7].length();
/*  708 */               if (i4 > i6) {
/*  709 */                 i6 = i4;
/*      */               }
/*      */             }
/*      */ 
/*  713 */             i6 -= localStringBuffer3.length();
/*  714 */             for (i7 = 0; i7 < i6; i7++) {
/*  715 */               localStringBuffer3.append(" ");
/*      */             }
/*      */           }
/*      */ 
/*  719 */           if (str1 != null)
/*      */           {
/*  722 */             i5 = 4;
/*      */ 
/*  724 */             if ((k & 0xC) == 0)
/*  725 */               localStringBuffer3 = localStringBuffer1;
/*  726 */             localStringBuffer3.append(str1.toLowerCase(localLocale));
/*  727 */             str1 = null;
/*      */           }
/*      */ 
/*  732 */           if ((k & 0x4) != 0)
/*      */           {
/*  735 */             if (Character.isLowerCase(localStringBuffer3.charAt(0))) {
/*  736 */               localStringBuffer3.setCharAt(0, Character.toUpperCase(localStringBuffer3.charAt(0)));
/*      */             }
/*  738 */             localStringBuffer1.append(localStringBuffer3.toString());
/*      */           }
/*  741 */           else if ((k & 0x8) != 0)
/*      */           {
/*  743 */             localStringBuffer1.append(localStringBuffer3.toString().toUpperCase());
/*      */           }
/*  745 */           else if (localStringBuffer3 != localStringBuffer1)
/*      */           {
/*  747 */             localStringBuffer1.append(localStringBuffer3.toString());
/*      */           }
/*      */           break;
/*      */         }
/*      */       }
/*      */     }
/*  753 */     return localStringBuffer1.toString();
/*      */   }
/*      */ 
/*      */   private int ldxdow(int paramInt1, int paramInt2, int paramInt3, Locale paramLocale)
/*      */   {
/*  776 */     Calendar localCalendar = GregorianCalendar.getInstance(paramLocale);
/*      */ 
/*  779 */     int i = ldxctj(paramInt1, paramInt2, paramInt3);
/*      */ 
/*  782 */     int j = (i - (2445029 + (localCalendar.getFirstDayOfWeek() - 1))) % 7;
/*  783 */     if (j < 0)
/*  784 */       j += 7;
/*  785 */     return j + 1;
/*      */   }
/*      */ 
/*      */   private int ldxctj(int paramInt1, int paramInt2, int paramInt3)
/*      */   {
/*      */     int i;
/*  801 */     if (paramInt1 == -4712) {
/*  802 */       i = 0;
/*      */     }
/*      */     else {
/*  805 */       i = paramInt1 + 4712;
/*      */ 
/*  811 */       i = 365 * i + (i - 1) / 4;
/*      */     }
/*      */ 
/*  815 */     if (paramInt1 >= 1583) {
/*  816 */       i = i - 10 - (paramInt1 - 1501) / 100 + (paramInt1 - 1201) / 400;
/*      */     }
/*      */ 
/*  820 */     i += ldxcty(paramInt1, paramInt2, paramInt3);
/*      */ 
/*  823 */     if ((paramInt1 == 1582) && (((paramInt2 == 10) && (paramInt3 >= 15)) || (paramInt2 >= 11))) {
/*  824 */       i -= 10;
/*      */     }
/*  826 */     return i;
/*      */   }
/*      */ 
/*      */   private byte[] ldxjtc(int paramInt, byte[] paramArrayOfByte)
/*      */     throws SQLException
/*      */   {
/*  843 */     if (paramInt < 1) {
/*  844 */       throw new SQLException(CoreException.getMessage((byte)10));
/*      */     }
/*  846 */     if (paramInt < 366)
/*      */     {
/*  849 */       paramArrayOfByte[0] = 53;
/*  850 */       paramArrayOfByte[1] = 28;
/*      */ 
/*  853 */       paramArrayOfByte = ldxdyc(-4712, paramInt, paramArrayOfByte);
/*      */     }
/*      */     else
/*      */     {
/*      */       int k;
/*      */       int i;
/*      */       int j;
/*  856 */       if (paramInt < 2299161)
/*      */       {
/*  860 */         paramInt -= 366;
/*      */ 
/*  865 */         k = -4711 + paramInt / 1461 * 4;
/*  866 */         paramInt %= 1461;
/*      */ 
/*  868 */         i = paramInt / 365;
/*  869 */         j = paramInt % 365;
/*      */ 
/*  871 */         if ((j == 0) && (i == 4))
/*      */         {
/*  874 */           j = 366;
/*  875 */           i = 3;
/*      */         }
/*      */         else {
/*  878 */           j++;
/*      */         }
/*  880 */         k += i;
/*      */ 
/*  882 */         paramArrayOfByte = ldxdyc(k, j, paramArrayOfByte);
/*      */ 
/*  884 */         paramArrayOfByte[0] = ((byte)(k / 100 + 100));
/*  885 */         paramArrayOfByte[1] = ((byte)(k % 100 + 100));
/*      */       }
/*      */       else
/*      */       {
/*  891 */         paramInt = 4 * (paramInt - 1721119) - 1;
/*  892 */         k = paramInt / 146097;
/*  893 */         paramInt %= 146097;
/*      */ 
/*  895 */         j = paramInt / 4;
/*      */ 
/*  897 */         paramInt = 4 * j + 3;
/*  898 */         j = paramInt % 1461;
/*  899 */         paramInt /= 1461;
/*      */ 
/*  901 */         j /= 4;
/*  902 */         j++;
/*      */ 
/*  904 */         i = 5 * j - 3;
/*  905 */         j = i % 153;
/*  906 */         i /= 153;
/*      */ 
/*  908 */         j /= 5;
/*  909 */         j++;
/*      */ 
/*  911 */         k *= 100;
/*  912 */         k += paramInt;
/*      */ 
/*  914 */         if (i < 10) {
/*  915 */           i += 3;
/*      */         }
/*      */         else {
/*  918 */           i -= 9;
/*  919 */           k++;
/*      */         }
/*      */ 
/*  922 */         paramArrayOfByte[3] = ((byte)j);
/*  923 */         paramArrayOfByte[2] = ((byte)i);
/*  924 */         paramArrayOfByte[0] = ((byte)(k / 100 + 100));
/*  925 */         paramArrayOfByte[1] = ((byte)(k % 100 + 100));
/*      */       }
/*      */     }
/*      */ 
/*  929 */     return paramArrayOfByte;
/*      */   }
/*      */ 
/*      */   private byte[] ldxdyc(int paramInt1, int paramInt2, byte[] paramArrayOfByte)
/*      */     throws SQLException
/*      */   {
/*  948 */     boolean bool = ldxisl(paramInt1);
/*      */ 
/*  950 */     if ((paramInt2 == 366) && (!bool)) {
/*  951 */       throw new SQLException(CoreException.getMessage((byte)9));
/*      */     }
/*      */ 
/*  954 */     int i = paramInt2;
/*      */ 
/*  956 */     if (paramInt2 > 59 + (bool ? 1 : 0)) {
/*  957 */       i += 2 - (bool ? 1 : 0);
/*      */     }
/*  959 */     i += 91; int j = i * 100;
/*  960 */     paramArrayOfByte[3] = ((byte)(i - (j - j % 3055) / 100));
/*  961 */     paramArrayOfByte[2] = ((byte)(j / 3055 - 2));
/*      */ 
/*  963 */     return paramArrayOfByte;
/*      */   }
/*      */ 
/*      */   private int ldxcty(int paramInt1, int paramInt2, int paramInt3)
/*      */   {
/*  982 */     return ldxdom[paramInt2] + paramInt3 + ((paramInt2 >= 3) && (ldxisl(paramInt1)) ? 1 : 0);
/*      */   }
/*      */ 
/*      */   private boolean ldxisl(int paramInt)
/*      */   {
/*  995 */     return (paramInt % 4 == 0) && (paramInt <= 1582 ? paramInt == -4712 : (paramInt % 100 != 0) || (paramInt % 400 == 0));
/*      */   }
/*      */ 
/*      */   private String lxi42b(int paramInt1, long paramLong, int paramInt2, boolean paramBoolean, Locale paramLocale)
/*      */     throws SQLException
/*      */   {
/* 1023 */     int i = 0;
/* 1024 */     int j = 0;
/* 1025 */     long l = paramLong;
/* 1026 */     NumberFormat localNumberFormat = NumberFormat.getInstance(paramLocale);
/* 1027 */     DecimalFormat localDecimalFormat = (DecimalFormat)localNumberFormat;
/* 1028 */     StringBuffer localStringBuffer = new StringBuffer();
/* 1029 */     int k = localDecimalFormat.getGroupingSize();
/* 1030 */     char c1 = '\000';
/* 1031 */     char c2 = localDecimalFormat.getDecimalFormatSymbols().getZeroDigit();
/*      */ 
/* 1034 */     for (j = 1; l /= 10L != 0L; j++);
/* 1036 */     if (paramLong < 0L) {
/* 1037 */       j++;
/*      */     }
/* 1039 */     if (paramBoolean) {
/* 1040 */       j += (j - 1) / k;
/*      */     }
/*      */ 
/* 1043 */     if (!paramBoolean) {
/* 1044 */       localNumberFormat.setGroupingUsed(false);
/*      */     }
/* 1046 */     localStringBuffer.append(localDecimalFormat.format(paramLong));
/*      */ 
/* 1048 */     if ((j > paramInt1) || (paramInt2 > paramInt1) || ((paramInt2 != 0) && (j > paramInt2)))
/*      */     {
/* 1050 */       throw new SQLException(CoreException.getMessage((byte)3));
/*      */     }
/*      */ 
/* 1053 */     if (paramBoolean) {
/* 1054 */       c1 = localDecimalFormat.getDecimalFormatSymbols().getGroupingSeparator();
/*      */     }
/* 1056 */     if (paramInt2 != 0)
/*      */     {
/* 1058 */       for (paramInt2 -= j; paramInt2-- != 0; )
/*      */       {
/* 1060 */         if ((paramBoolean) && (i++ == k) && (paramInt2 != 0))
/*      */         {
/* 1062 */           localStringBuffer.insert(0, c1);
/* 1063 */           i = 1;
/* 1064 */           paramInt2--;
/*      */         }
/* 1066 */         localStringBuffer.insert(0, c2);
/*      */       }
/*      */     }
/*      */ 
/* 1070 */     return localStringBuffer.toString();
/*      */   }
/*      */ 
/*      */   public byte[] ldxsto(String paramString1, String paramString2)
/*      */     throws SQLException
/*      */   {
/* 1085 */     int i = 0;
/* 1086 */     int j = 0;
/*      */ 
/* 1088 */     int m = 0;
/* 1089 */     byte[] arrayOfByte1 = new byte[512];
/* 1090 */     int n = 16;
/* 1091 */     int i1 = 0;
/* 1092 */     int i2 = 0;
/* 1093 */     char[] arrayOfChar = new char[256];
/* 1094 */     int i3 = 0;
/*      */ 
/* 1097 */     int i4 = 0;
/*      */ 
/* 1100 */     if ((paramString1 == null) || (paramString1.compareTo("") == 0))
/*      */     {
/* 1103 */       return NULLFMT;
/*      */     }
/*      */ 
/* 1106 */     int k = paramString1.length();
/*      */ 
/* 1109 */     while (i < k)
/*      */     {
/* 1112 */       n = 16;
/* 1113 */       i2 = 0;
/*      */       do
/*      */       {
/* 1119 */         if ((i < k) && (paramString1.charAt(i) == '|'))
/*      */         {
/* 1121 */           i++;
/* 1122 */           break;
/*      */         }
/*      */ 
/* 1126 */         for (i3 = 0; (i < k) && (!Character.isLetterOrDigit(paramString1.charAt(i))); )
/*      */         {
/* 1129 */           if (paramString1.charAt(i) == '"')
/*      */           {
/* 1132 */             i1 = 1;
/*      */ 
/* 1134 */             while ((i != k) && (paramString1.charAt(++i) != '"'))
/*      */             {
/* 1136 */               arrayOfChar[(i2++)] = paramString1.charAt(i);
/* 1137 */               i3++;
/*      */             }
/* 1139 */             if (paramString1.charAt(i) == '"')
/* 1140 */               i++;
/*      */           }
/*      */           else
/*      */           {
/* 1144 */             arrayOfChar[(i2++)] = paramString1.charAt(i++);
/* 1145 */             i3++;
/*      */           }
/*      */         }
/*      */         int i5;
/* 1150 */         if (i3 > 0)
/*      */         {
/* 1152 */           if (i3 > 210)
/*      */           {
/* 1155 */             throw new SQLException(CoreException.getMessage((byte)7));
/*      */           }
/*      */ 
/* 1160 */           if (Character.isWhitespace(arrayOfChar[0]))
/*      */           {
/* 1165 */             int i10 = 0;
/*      */ 
/* 1167 */             i5 = i3; int i8 = 0;
/*      */ 
/* 1169 */             for (; (i5 > 0) && (Character.isWhitespace(arrayOfChar[i10])); 
/* 1169 */               i5--) { i10++; i8++; }
/* 1170 */             arrayOfByte1[(j++)] = ((byte)(45 + i8));
/*      */ 
/* 1172 */             arrayOfByte1[(j++)] = 2;
/*      */ 
/* 1178 */             byte[] arrayOfByte4 = new String(arrayOfChar, 0, i8).getBytes();
/* 1179 */             System.arraycopy(arrayOfByte4, 0, arrayOfByte1, j, arrayOfByte4.length);
/*      */ 
/* 1182 */             j += arrayOfByte4.length;
/*      */ 
/* 1184 */             i3 -= i8;
/* 1185 */             if (i3 == 0)
/*      */             {
/*      */               continue;
/*      */             }
/*      */ 
/* 1191 */             i += i8 + 1;
/*      */ 
/* 1193 */             i2 = i10;
/*      */           }
/*      */           else {
/* 1196 */             i2 = 0;
/*      */           }
/* 1198 */           if (i1 != 1) {
/* 1199 */             i1 = 4;
/*      */           }
/* 1201 */           arrayOfByte1[(j++)] = ((byte)(45 + i3));
/* 1202 */           arrayOfByte1[(j++)] = i1;
/*      */ 
/* 1208 */           byte[] arrayOfByte2 = new String(arrayOfChar, 0, i3).getBytes();
/* 1209 */           System.arraycopy(arrayOfByte2, 0, arrayOfByte1, j, arrayOfByte2.length);
/*      */ 
/* 1211 */           j += arrayOfByte2.length;
/*      */         }
/*      */         else
/*      */         {
/* 1218 */           if (!Character.isLetterOrDigit(paramString1.charAt(i)))
/*      */           {
/* 1220 */             throw new SQLException(CoreException.getMessage((byte)7));
/*      */           }
/*      */ 
/* 1224 */           char c = Character.toUpperCase(paramString1.charAt(i));
/* 1225 */           i5 = c - 'A';
/* 1226 */           if ((i5 > 25) || (ldxfdi[i5] == -2147483648))
/*      */           {
/* 1229 */             throw new SQLException(CoreException.getMessage((byte)7));
/*      */           }
/*      */ 
/* 1234 */           i4 = ldxfdi[i5];
/*      */ 
/* 1239 */           i5 = 50;
/*      */           int i9;
/*      */           int i6;
/*      */           int i7;
/* 1240 */           for (; i4 < ldxfda.length; i4++)
/*      */           {
/* 1243 */             i9 = ldxfda[i4].length;
/* 1244 */             i6 = 0; for (i7 = i; 
/* 1245 */               (i6 < i9) && (i7 < k); i7++)
/*      */             {
/* 1247 */               if (Character.toUpperCase(paramString1.charAt(i7)) != ldxfda[i4][i6])
/*      */                 break;
/* 1245 */               i6++;
/*      */             }
/*      */ 
/* 1252 */             if (i6 == i9)
/*      */             {
/* 1254 */               i5 = i4;
/*      */             }
/*      */ 
/* 1257 */             if (ldxfda[(i4 + 1)][0] != c) {
/*      */               break;
/*      */             }
/*      */           }
/* 1261 */           i4 = i5;
/*      */ 
/* 1264 */           if (i4 >= ldxfda.length)
/*      */           {
/* 1266 */             throw new SQLException(CoreException.getMessage((byte)7));
/*      */           }
/*      */ 
/* 1271 */           if (k - i > 1)
/*      */           {
/* 1273 */             if (Character.isUpperCase(paramString1.charAt(i)))
/*      */             {
/* 1275 */               c = Character.isLetterOrDigit(paramString1.charAt(i + 1)) ? paramString1.charAt(i + 1) : paramString1.charAt(i + 2);
/*      */ 
/* 1278 */               if (Character.isLowerCase(c))
/* 1279 */                 n = (byte)(n | 0x4);
/*      */               else {
/* 1281 */                 n = (byte)(n | 0x8);
/*      */               }
/*      */             }
/*      */           }
/* 1285 */           i += ldxfda[i4].length;
/* 1286 */           m = ldxfdc[i4];
/*      */ 
/* 1288 */           if ((ldxfcdlen[m] & 0xFFFFFF80) == 0)
/*      */           {
/* 1290 */             i4 = 0; for (i6 = -1; i4 < ldxfdx.length; i4++)
/*      */             {
/* 1292 */               i9 = ldxfdx[i4].length;
/* 1293 */               i5 = 0; for (i7 = i; 
/* 1294 */                 (i5 < i9) && (i7 < k); i7++)
/*      */               {
/* 1297 */                 if (Character.toUpperCase(paramString1.charAt(i7)) != ldxfdx[i4][i5])
/*      */                   break;
/* 1294 */                 i5++;
/*      */               }
/*      */ 
/* 1303 */               if (i5 == i9)
/*      */               {
/* 1305 */                 i6 = i4;
/*      */               }
/*      */             }
/*      */ 
/* 1309 */             i4 = i6;
/*      */ 
/* 1312 */             if ((i4 >= 0) && (i4 < ldxfdx.length))
/*      */             {
/* 1314 */               n = (byte)(n | ldxfdxc[i4]);
/* 1315 */               i += ldxfdx[i4].length;
/*      */             }
/*      */ 
/*      */           }
/*      */ 
/* 1320 */           if (512 - j < 2)
/*      */           {
/* 1324 */             throw new SQLException(CoreException.getMessage((byte)7));
/*      */           }
/*      */ 
/* 1328 */           arrayOfByte1[(j++)] = ((byte)m);
/* 1329 */           arrayOfByte1[(j++)] = n;
/*      */         }
/*      */ 
/* 1333 */         if (m == 39)
/* 1334 */           n = (n & 0x10) == 1 ? 0 : 16;
/*      */       }
/* 1336 */       while (m == 39);
/*      */     }
/*      */ 
/* 1340 */     byte[] arrayOfByte3 = new byte[j];
/* 1341 */     System.arraycopy(arrayOfByte1, 0, arrayOfByte3, 0, arrayOfByte3.length);
/* 1342 */     return arrayOfByte3;
/*      */   }
/*      */ 
/*      */   public byte[] ldxdyf(byte[] paramArrayOfByte)
/*      */     throws SQLException
/*      */   {
/* 1352 */     throw new SQLException(CoreException.getMessage((byte)1));
/*      */   }
/*      */ 
/*      */   public void ldxftd(byte[] paramArrayOfByte, int[] paramArrayOfInt1, int[] paramArrayOfInt2)
/*      */     throws SQLException
/*      */   {
/* 1364 */     throw new SQLException(CoreException.getMessage((byte)1));
/*      */   }
/*      */ 
/*      */   public byte[] ldxgdt()
/*      */     throws SQLException
/*      */   {
/* 1375 */     throw new SQLException(CoreException.getMessage((byte)1));
/*      */   }
/*      */ 
/*      */   public byte[] ldxldd(byte[] paramArrayOfByte)
/*      */     throws SQLException
/*      */   {
/* 1386 */     throw new SQLException(CoreException.getMessage((byte)1));
/*      */   }
/*      */ 
/*      */   public byte[] ldxnxd(byte[] paramArrayOfByte, int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1400 */     throw new SQLException(CoreException.getMessage((byte)1));
/*      */   }
/*      */ 
/*      */   public byte[] ldxrnd(byte[] paramArrayOfByte, String paramString)
/*      */     throws SQLException
/*      */   {
/* 1414 */     throw new SQLException(CoreException.getMessage((byte)1));
/*      */   }
/*      */ 
/*      */   public byte[] ldxsbm(byte[] paramArrayOfByte1, byte[] paramArrayOfByte2)
/*      */     throws SQLException
/*      */   {
/* 1428 */     throw new SQLException(CoreException.getMessage((byte)1));
/*      */   }
/*      */ 
/*      */   public void ldxsub(byte[] paramArrayOfByte1, byte[] paramArrayOfByte2, int[] paramArrayOfInt1, int[] paramArrayOfInt2)
/*      */     throws SQLException
/*      */   {
/* 1442 */     throw new SQLException(CoreException.getMessage((byte)1));
/*      */   }
/*      */ 
/*      */   public byte[] ldxstd(String paramString1, String paramString2, String paramString3)
/*      */     throws SQLException
/*      */   {
/* 1524 */     Object localObject = null;
/* 1525 */     byte[] arrayOfByte = null;
/* 1526 */     int i = 0;
/* 1527 */     int j = 0;
/* 1528 */     char[] arrayOfChar = new char[512];
/* 1529 */     int k = 0;
/* 1530 */     int m = 0;
/* 1531 */     int n = 0;
/* 1532 */     int i1 = 0;
/* 1533 */     ParsePosition localParsePosition = new ParsePosition(0);
/* 1534 */     SimpleDateFormat localSimpleDateFormat = new SimpleDateFormat();
/*      */ 
/* 1537 */     arrayOfByte = ldxsto(paramString2, paramString3);
/*      */ 
/* 1540 */     ldxsti(arrayOfByte);
/*      */ 
/* 1542 */     m = arrayOfByte.length;
/*      */ 
/* 1546 */     while (k < m)
/*      */     {
/* 1548 */       i = arrayOfByte[(k++)];
/* 1549 */       j = arrayOfByte[(k++)];
/*      */       int i2;
/* 1551 */       switch (i)
/*      */       {
/*      */       case 43:
/*      */       case 44:
/* 1555 */         throw new SQLException(CoreException.getMessage((byte)1));
/*      */       case 41:
/* 1559 */         throw new SQLException(CoreException.getMessage((byte)1));
/*      */       case 40:
/* 1563 */         throw new SQLException(CoreException.getMessage((byte)1));
/*      */       case 4:
/* 1567 */         arrayOfChar[(n++)] = 'y';
/* 1568 */         break;
/*      */       case 6:
/* 1571 */         for (i2 = 0; i2 < 2; i2++)
/* 1572 */           arrayOfChar[(n++)] = 'y';
/* 1573 */         break;
/*      */       case 8:
/* 1576 */         for (i2 = 0; i2 < 3; i2++)
/* 1577 */           arrayOfChar[(n++)] = 'y';
/* 1578 */         break;
/*      */       case 10:
/* 1581 */         for (i2 = 0; i2 < 4; i2++)
/* 1582 */           arrayOfChar[(n++)] = 'y';
/* 1583 */         break;
/*      */       case 11:
/*      */       case 12:
/*      */       case 13:
/* 1588 */         throw new SQLException(CoreException.getMessage((byte)1));
/*      */       case 38:
/* 1592 */         throw new SQLException(CoreException.getMessage((byte)1));
/*      */       case 17:
/* 1596 */         arrayOfChar[(n++)] = 'M';
/* 1597 */         arrayOfChar[(n++)] = 'M';
/* 1598 */         break;
/*      */       case 31:
/* 1601 */         for (i2 = 0; i2 < 3; i2++)
/* 1602 */           arrayOfChar[(n++)] = 'M';
/* 1603 */         break;
/*      */       case 30:
/* 1606 */         for (i2 = 0; i2 < 4; i2++)
/* 1607 */           arrayOfChar[(n++)] = 'M';
/* 1608 */         break;
/*      */       case 21:
/*      */       case 33:
/* 1612 */         arrayOfChar[(n++)] = 'E';
/* 1613 */         break;
/*      */       case 32:
/* 1616 */         for (i2 = 0; i2 < 4; i2++)
/* 1617 */           arrayOfChar[(n++)] = 'E';
/* 1618 */         break;
/*      */       case 22:
/* 1621 */         arrayOfChar[(n++)] = 'd';
/* 1622 */         break;
/*      */       case 23:
/* 1625 */         arrayOfChar[(n++)] = 'D';
/* 1626 */         break;
/*      */       case 29:
/* 1629 */         throw new SQLException(CoreException.getMessage((byte)1));
/*      */       case 25:
/* 1633 */         arrayOfChar[(n++)] = 'h';
/* 1634 */         break;
/*      */       case 24:
/* 1637 */         arrayOfChar[(n++)] = 'H';
/* 1638 */         break;
/*      */       case 26:
/* 1641 */         arrayOfChar[(n++)] = 'm';
/* 1642 */         break;
/*      */       case 27:
/* 1645 */         arrayOfChar[(n++)] = 's';
/* 1646 */         break;
/*      */       case 28:
/* 1649 */         throw new SQLException(CoreException.getMessage((byte)1));
/*      */       case 34:
/*      */       case 35:
/* 1654 */         arrayOfChar[(n++)] = 'a';
/* 1655 */         break;
/*      */       case 36:
/*      */       case 37:
/* 1659 */         arrayOfChar[(n++)] = 'G';
/* 1660 */         break;
/*      */       case 39:
/*      */       case 42:
/* 1663 */         throw new SQLException(CoreException.getMessage((byte)1));
/*      */       case 5:
/*      */       case 7:
/*      */       case 9:
/*      */       case 14:
/*      */       case 15:
/*      */       case 16:
/*      */       case 18:
/*      */       case 19:
/*      */       case 20:
/*      */       default:
/* 1666 */         i1 = i - 45;
/* 1667 */         str = new String(arrayOfByte, k, i1);
/*      */ 
/* 1669 */         if (j == 1)
/*      */         {
/* 1671 */           arrayOfChar[(n++)] = '\'';
/* 1672 */           System.arraycopy(str.toCharArray(), 0, arrayOfChar, n, i1);
/*      */ 
/* 1674 */           n += i1;
/* 1675 */           k += i1;
/* 1676 */           arrayOfChar[(n++)] = '\'';
/*      */         }
/*      */         else
/*      */         {
/* 1680 */           System.arraycopy(str.toCharArray(), 0, arrayOfChar, n, i1);
/*      */ 
/* 1682 */           n += i1;
/* 1683 */           k += i1;
/*      */         }
/*      */ 
/*      */         break;
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 1692 */     String str = new String(arrayOfChar, 0, n);
/* 1693 */     localSimpleDateFormat.applyPattern(str);
/* 1694 */     localSimpleDateFormat.setLenient(false);
/* 1695 */     Date localDate = localSimpleDateFormat.parse(paramString1, localParsePosition);
/* 1696 */     if (localDate != null)
/*      */     {
/* 1698 */       return DATE.toBytes(new Timestamp(localDate.getTime()));
/*      */     }
/*      */ 
/* 1701 */     throw new SQLException(CoreException.getMessage((byte)6));
/*      */   }
/*      */ 
/*      */   public byte[] ldxtrn(byte[] paramArrayOfByte, String paramString)
/*      */     throws SQLException
/*      */   {
/* 1716 */     throw new SQLException(CoreException.getMessage((byte)1));
/*      */   }
/*      */ 
/*      */   private void ldxsti(byte[] paramArrayOfByte)
/*      */     throws SQLException
/*      */   {
/* 1723 */     int[] arrayOfInt = new int[46];
/*      */     int j;
/* 1726 */     for (int i = 0; i < paramArrayOfByte.length; i += 2)
/*      */     {
/* 1729 */       if (paramArrayOfByte[i] < 45)
/*      */       {
/* 1731 */         j = paramArrayOfByte[i];
/*      */ 
/* 1736 */         if ((paramArrayOfByte[i] != 42) && (paramArrayOfByte[i] != 39) && (arrayOfInt[paramArrayOfByte[i]] != 0))
/*      */         {
/* 1738 */           throw new SQLException(CoreException.getMessage((byte)7));
/*      */         }
/*      */ 
/* 1743 */         arrayOfInt[paramArrayOfByte[i]] += 1;
/*      */ 
/* 1746 */         switch (paramArrayOfByte[i])
/*      */         {
/*      */         case 1:
/*      */         case 2:
/*      */         case 3:
/*      */         case 5:
/*      */         case 7:
/*      */         case 9:
/*      */         case 14:
/*      */         case 15:
/*      */         case 16:
/*      */         case 18:
/*      */         case 19:
/*      */         case 20:
/* 1760 */           throw new SQLException(CoreException.getMessage((byte)7));
/*      */         case 4:
/*      */         case 6:
/*      */         case 8:
/*      */         case 10:
/*      */         case 11:
/*      */         case 12:
/*      */         case 13:
/* 1767 */         case 17: }  } else { i += paramArrayOfByte[i] - 45; }
/*      */ 
/*      */ 
/*      */     }
/*      */ 
/* 1780 */     for (i = 0; i < this.ldxpmxa.length; i++)
/*      */     {
/* 1782 */       j = 0;
/*      */ 
/* 1784 */       for (int k = 0; k < this.ldxpmxa[i].length; k++) {
/* 1785 */         j += arrayOfInt[this.ldxpmxa[i][k]];
/*      */       }
/* 1787 */       if (j > 1)
/*      */       {
/* 1789 */         throw new SQLException(CoreException.getMessage((byte)7));
/*      */       }
/*      */     }
/*      */   }
/*      */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.sql.LdxLibThin
 * JD-Core Version:    0.6.2
 */