/*     */ package oracle.sql;
/*     */ 
/*     */ import java.sql.SQLException;
/*     */ import oracle.jdbc.driver.DatabaseError;
/*     */ import oracle.jdbc.internal.OracleConnection;
/*     */ import oracle.jdbc.oracore.PickleContext;
/*     */ 
/*     */ class Kotad
/*     */ {
/*     */   static final int KOTADSIG = -1365573631;
/*     */   static final int KOTPDSIG = -1365442559;
/*     */   static final int KOTRDSIG = -1365377023;
/*     */   static final int KOTCDSIG = -1365311487;
/*     */   static final int KOTODSIG = -1365307391;
/*     */   static final int KOTADXSIG = -1365303295;
/*     */   static final int KOTADPRV = 1;
/*     */   static final int KOTADPUB = 2;
/*     */   static final int KOTADCNT = 4;
/*     */   static final int KOTADCFM = 248;
/*     */   static final int KOTADSUB = 256;
/*     */   static final int KOTADPTR = 16384;
/*     */   static final int KOTADREF = 32768;
/*     */   static final int KOTADCNN = 65536;
/*     */   static final int KOTADCFN = 131072;
/*     */   static final int KOTADCVN = 262144;
/*     */   static final int KOTADTRN = 512;
/*     */   static final int KOTADCPT = 4096;
/*     */   static final int KOTADIN = 256;
/*     */   static final int KOTADOUT = 512;
/*     */   static final int KOTADCBR = 1024;
/*     */   static final int KOTADREQ = 2048;
/*     */   static final int KOTADNCP = 1048576;
/*     */   private int kotadkvn;
/*     */   private byte[] kotadnam;
/*     */   private byte[] kotadtrf;
/*     */   private short kotadtvn;
/*     */   private short kotadid;
/*     */   private byte[] kotadprf;
/*     */   private short kotadpvn;
/*     */   private int kotadflg;
/*     */   private long kotadpre;
/*     */   private int kotadcid;
/*     */   private byte kotadscl;
/*     */   private int kotadcne;
/*     */   private byte[] kotaddft;
/*     */   private long kotadtyp;
/*     */   private byte[] kotadadd;
/* 276 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   private Kotad()
/*     */     throws SQLException
/*     */   {
/*     */   }
/*     */ 
/*     */   private static Kotad unpickleKotad(PickleContext paramPickleContext)
/*     */     throws SQLException
/*     */   {
/* 137 */     Kotad localKotad = new Kotad();
/* 138 */     paramPickleContext.skipBytes(2);
/* 139 */     long l = paramPickleContext.readLength(true) - 2;
/* 140 */     paramPickleContext.skipBytes(1);
/* 141 */     localKotad.kotadkvn = ((int)paramPickleContext.readUB4());
/* 142 */     localKotad.kotadnam = paramPickleContext.readDataValue();
/* 143 */     localKotad.kotadtrf = paramPickleContext.readDataValue();
/* 144 */     paramPickleContext.skipBytes(1);
/* 145 */     localKotad.kotadtvn = ((short)paramPickleContext.readUB2());
/* 146 */     paramPickleContext.skipBytes(1);
/* 147 */     localKotad.kotadid = ((short)paramPickleContext.readUB2());
/* 148 */     localKotad.kotadprf = paramPickleContext.readDataValue();
/* 149 */     paramPickleContext.skipBytes(1);
/* 150 */     localKotad.kotadpvn = ((short)paramPickleContext.readUB2());
/* 151 */     paramPickleContext.skipBytes(1);
/* 152 */     localKotad.kotadflg = ((int)paramPickleContext.readUB4());
/* 153 */     paramPickleContext.skipBytes(1);
/* 154 */     localKotad.kotadpre = paramPickleContext.readUB4();
/* 155 */     paramPickleContext.skipBytes(1);
/* 156 */     localKotad.kotadcid = paramPickleContext.readUB2();
/* 157 */     paramPickleContext.skipBytes(1);
/* 158 */     localKotad.kotadscl = paramPickleContext.readByte();
/* 159 */     paramPickleContext.skipBytes(1);
/* 160 */     localKotad.kotadcne = ((int)paramPickleContext.readUB4());
/* 161 */     localKotad.kotaddft = paramPickleContext.readDataValue();
/* 162 */     paramPickleContext.skipBytes(1);
/* 163 */     localKotad.kotadtyp = paramPickleContext.readUB4();
/* 164 */     localKotad.kotadadd = paramPickleContext.readDataValue();
/* 165 */     return localKotad;
/*     */   }
/*     */ 
/*     */   static final TypeDescriptor unpickleTypeDescriptorImage(PickleContext paramPickleContext)
/*     */     throws SQLException
/*     */   {
/* 175 */     Kotad localKotad = unpickleKotad(paramPickleContext);
/* 176 */     if (localKotad.kotadkvn != -1365311487)
/*     */     {
/* 180 */       localObject = DatabaseError.createSqlException(null, 179);
/* 181 */       ((SQLException)localObject).fillInStackTrace();
/* 182 */       throw ((Throwable)localObject);
/*     */     }
/*     */ 
/* 186 */     Object localObject = constructPredefinedTypeDescriptor(localKotad);
/* 187 */     return localObject;
/*     */   }
/*     */ 
/*     */   static final AttributeDescriptor unpickleAttributeImage(boolean paramBoolean, PickleContext paramPickleContext)
/*     */     throws SQLException
/*     */   {
/* 198 */     Kotad localKotad = unpickleKotad(paramPickleContext);
/* 199 */     if (localKotad.kotadkvn != -1365573631)
/*     */     {
/* 203 */       localObject = DatabaseError.createSqlException(null, 179);
/* 204 */       ((SQLException)localObject).fillInStackTrace();
/* 205 */       throw ((Throwable)localObject);
/*     */     }
/*     */ 
/* 209 */     Object localObject = null;
/*     */ 
/* 211 */     if (paramBoolean) {
/* 212 */       localObject = constructPredefinedTypeDescriptor(localKotad);
/*     */     }
/* 214 */     AttributeDescriptor localAttributeDescriptor = new AttributeDescriptor(new String(localKotad.kotadnam), localKotad.kotadid, localKotad.kotadflg, (TypeDescriptor)localObject);
/*     */ 
/* 219 */     return localAttributeDescriptor;
/*     */   }
/*     */ 
/*     */   private static final TypeDescriptor constructPredefinedTypeDescriptor(Kotad paramKotad)
/*     */     throws SQLException
/*     */   {
/* 227 */     if (paramKotad.kotadtrf.length != 36)
/*     */     {
/* 231 */       SQLException localSQLException = DatabaseError.createSqlException(null, 180);
/* 232 */       localSQLException.fillInStackTrace();
/* 233 */       throw localSQLException;
/*     */     }
/*     */ 
/* 240 */     for (short s = 4; s < 18; s++)
/*     */     {
/* 242 */       if (paramKotad.kotadtrf[s] != 0)
/*     */       {
/* 246 */         localObject = DatabaseError.createSqlException(null, 180);
/* 247 */         ((SQLException)localObject).fillInStackTrace();
/* 248 */         throw ((Throwable)localObject);
/*     */       }
/*     */     }
/*     */ 
/* 252 */     s = TypeDescriptor.OID_TO_TYPECODE[paramKotad.kotadtrf[19]];
/* 253 */     Object localObject = new TypeDescriptor(s);
/* 254 */     ((TypeDescriptor)localObject).setPrecision(paramKotad.kotadpre);
/* 255 */     ((TypeDescriptor)localObject).setScale(paramKotad.kotadscl);
/* 256 */     return localObject;
/*     */   }
/*     */ 
/*     */   protected OracleConnection getConnectionDuringExceptionHandling()
/*     */   {
/* 271 */     return null;
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.sql.Kotad
 * JD-Core Version:    0.6.2
 */