/*     */ package oracle.sql;
/*     */ 
/*     */ public class INTERVALYM extends Datum
/*     */ {
/* 349 */   private static int MASKVAL = 255;
/* 350 */   private static int INTYMYEAROFFSET = -2147483648;
/* 351 */   private static int INTYMMONTHOFFSET = 60;
/* 352 */   private static int INTERVALYMMAXLENGTH = 5;
/* 353 */   private static int MAXYEARPREC = 9;
/* 354 */   private static int MAXMONTH = 12;
/*     */   static final long serialVersionUID = 8393284561907159296L;
/* 358 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   public INTERVALYM()
/*     */   {
/*  73 */     super(_initIntervalYM());
/*     */   }
/*     */ 
/*     */   public INTERVALYM(byte[] paramArrayOfByte)
/*     */   {
/*  87 */     super(paramArrayOfByte);
/*     */   }
/*     */ 
/*     */   public INTERVALYM(String paramString)
/*     */   {
/* 101 */     super(toBytes(paramString));
/*     */   }
/*     */ 
/*     */   public byte[] toBytes()
/*     */   {
/* 112 */     return getBytes();
/*     */   }
/*     */ 
/*     */   public static byte[] toBytes(String paramString)
/*     */   {
/* 126 */     if (paramString == null) {
/* 127 */       return null;
/*     */     }
/*     */ 
/* 130 */     byte[] arrayOfByte = new byte[INTERVALYMMAXLENGTH];
/*     */ 
/* 134 */     String str1 = paramString.trim();
/*     */ 
/* 137 */     int j = str1.charAt(0);
/*     */     int i;
/* 139 */     if ((j != 45) && (j != 43)) {
/* 140 */       i = 0;
/*     */     }
/*     */     else {
/* 143 */       i = 1;
/*     */     }
/*     */ 
/* 147 */     str1 = str1.substring(i);
/*     */ 
/* 149 */     int k = str1.indexOf(45);
/*     */ 
/* 151 */     String str2 = str1.substring(0, k);
/*     */ 
/* 153 */     if (str2.length() > MAXYEARPREC) {
/* 154 */       throw new NumberFormatException();
/*     */     }
/*     */ 
/* 157 */     int m = Integer.valueOf(str2).intValue();
/*     */ 
/* 160 */     String str3 = str1.substring(k + 1);
/*     */ 
/* 162 */     int n = Integer.valueOf(str3).intValue();
/*     */ 
/* 164 */     if (n >= MAXMONTH) {
/* 165 */       throw new NumberFormatException();
/*     */     }
/*     */ 
/* 169 */     if (j == 45) {
/* 170 */       m = -1 * m;
/* 171 */       n = -1 * n;
/*     */     }
/*     */ 
/* 176 */     m += INTYMYEAROFFSET;
/*     */ 
/* 180 */     arrayOfByte[0] = utilpack.RIGHTSHIFTFIRSTNIBBLE(m);
/* 181 */     arrayOfByte[1] = utilpack.RIGHTSHIFTSECONDNIBBLE(m);
/* 182 */     arrayOfByte[2] = utilpack.RIGHTSHIFTTHIRDNIBBLE(m);
/* 183 */     arrayOfByte[3] = utilpack.RIGHTSHIFTFOURTHNIBBLE(m);
/*     */ 
/* 186 */     arrayOfByte[4] = ((byte)(n + INTYMMONTHOFFSET));
/*     */ 
/* 188 */     return arrayOfByte;
/*     */   }
/*     */ 
/*     */   public static String toString(byte[] paramArrayOfByte)
/*     */   {
/* 203 */     if ((paramArrayOfByte == null) || (paramArrayOfByte.length == 0)) {
/* 204 */       return new String();
/*     */     }
/*     */ 
/* 208 */     int i = 1;
/*     */ 
/* 214 */     int j = utilpack.LEFTSHIFTFIRSTNIBBLE(paramArrayOfByte[0]);
/* 215 */     j |= utilpack.LEFTSHIFTSECONDNIBBLE(paramArrayOfByte[1]);
/* 216 */     j |= utilpack.LEFTSHIFTTHIRDNIBBLE(paramArrayOfByte[2]);
/* 217 */     j |= paramArrayOfByte[3] & 0xFF;
/*     */ 
/* 220 */     j -= INTYMYEAROFFSET;
/*     */ 
/* 223 */     int k = paramArrayOfByte[4] - INTYMMONTHOFFSET;
/*     */ 
/* 226 */     if (j < 0) {
/* 227 */       i = 0;
/* 228 */       j = -j;
/*     */     }
/*     */ 
/* 231 */     if (k < 0) {
/* 232 */       i = 0;
/* 233 */       k = -k;
/*     */     }
/*     */ 
/* 237 */     String str = j + "-" + k;
/*     */ 
/* 239 */     if (i == 0) {
/* 240 */       str = "-" + str;
/*     */     }
/*     */ 
/* 243 */     return str;
/*     */   }
/*     */ 
/*     */   public Object toJdbc()
/*     */   {
/* 256 */     return this;
/*     */   }
/*     */ 
/*     */   public String stringValue()
/*     */   {
/* 266 */     return toString(getBytes());
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 277 */     return toString(getBytes());
/*     */   }
/*     */ 
/*     */   public Object makeJdbcArray(int paramInt)
/*     */   {
/* 289 */     INTERVALYM[] arrayOfINTERVALYM = new INTERVALYM[paramInt];
/*     */ 
/* 291 */     return arrayOfINTERVALYM;
/*     */   }
/*     */ 
/*     */   public boolean isConvertibleTo(Class paramClass)
/*     */   {
/* 303 */     if (paramClass.getName().compareTo("java.lang.String") == 0) {
/* 304 */       return true;
/*     */     }
/* 306 */     return false;
/*     */   }
/*     */ 
/*     */   private static byte[] _initIntervalYM()
/*     */   {
/* 319 */     byte[] arrayOfByte = new byte[INTERVALYMMAXLENGTH];
/*     */ 
/* 323 */     int i = 0;
/* 324 */     int j = 0;
/*     */ 
/* 328 */     i += INTYMYEAROFFSET;
/*     */ 
/* 333 */     arrayOfByte[0] = utilpack.RIGHTSHIFTFIRSTNIBBLE(i);
/* 334 */     arrayOfByte[1] = utilpack.RIGHTSHIFTSECONDNIBBLE(i);
/* 335 */     arrayOfByte[2] = utilpack.RIGHTSHIFTTHIRDNIBBLE(i);
/* 336 */     arrayOfByte[3] = utilpack.RIGHTSHIFTFOURTHNIBBLE(i);
/*     */ 
/* 341 */     arrayOfByte[4] = ((byte)(j + INTYMMONTHOFFSET));
/*     */ 
/* 345 */     return arrayOfByte;
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.sql.INTERVALYM
 * JD-Core Version:    0.6.2
 */