/*     */ package oracle.sql;
/*     */ 
/*     */ import java.util.StringTokenizer;
/*     */ 
/*     */ public class INTERVALDS extends Datum
/*     */ {
/* 498 */   private static int MAXLEADPREC = 9;
/* 499 */   private static int MAXHOUR = 23;
/* 500 */   private static int MAXMINUTE = 59;
/* 501 */   private static int MAXSECOND = 59;
/* 502 */   private static int INTERVALDSMAXLENGTH = 11;
/* 503 */   private static int INTERVALDSOFFSET = 60;
/* 504 */   private static int INTERVALDAYOFFSET = -2147483648;
/*     */   static final long serialVersionUID = 7164731704878764759L;
/* 508 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   public INTERVALDS()
/*     */   {
/*  98 */     super(_initIntervalDS());
/*     */   }
/*     */ 
/*     */   public INTERVALDS(byte[] paramArrayOfByte)
/*     */   {
/* 114 */     super(paramArrayOfByte);
/*     */   }
/*     */ 
/*     */   public INTERVALDS(String paramString)
/*     */   {
/* 128 */     super(toBytes(paramString));
/*     */   }
/*     */ 
/*     */   public byte[] toBytes()
/*     */   {
/* 139 */     return getBytes();
/*     */   }
/*     */ 
/*     */   public static byte[] toBytes(String paramString)
/*     */   {
/* 153 */     if (paramString == null) {
/* 154 */       return null;
/*     */     }
/*     */ 
/* 157 */     int j = 0; int k = 0; int m = 0; int n = 0; int i1 = 0;
/* 158 */     byte[] arrayOfByte = new byte[INTERVALDSMAXLENGTH];
/*     */ 
/* 160 */     String str5 = null;
/*     */ 
/* 163 */     String str6 = paramString.trim();
/*     */ 
/* 166 */     int i2 = str6.charAt(0);
/*     */     int i;
/* 168 */     if ((i2 != 45) && (i2 != 43)) {
/* 169 */       i = 0;
/*     */     }
/*     */     else {
/* 172 */       i = 1;
/*     */     }
/*     */ 
/* 176 */     str6 = str6.substring(i);
/*     */ 
/* 179 */     int i3 = str6.indexOf(32);
/*     */ 
/* 181 */     String str1 = str6.substring(0, i3);
/*     */ 
/* 183 */     if (str1.length() > MAXLEADPREC) {
/* 184 */       throw new NumberFormatException();
/*     */     }
/*     */ 
/* 188 */     String str7 = str6.substring(i3 + 1);
/*     */ 
/* 191 */     StringTokenizer localStringTokenizer = new StringTokenizer(str7, ":.");
/*     */ 
/* 193 */     if (localStringTokenizer.hasMoreTokens()) { String str2;
/*     */       String str3;
/*     */       String str4;
/*     */       try { str2 = localStringTokenizer.nextToken();
/* 196 */         str3 = localStringTokenizer.nextToken();
/* 197 */         str4 = localStringTokenizer.nextToken();
/* 198 */         str5 = localStringTokenizer.nextToken();
/*     */       } catch (Exception localException)
/*     */       {
/* 201 */         throw new NumberFormatException();
/*     */       }
/*     */ 
/* 205 */       j = Integer.valueOf(str1).intValue();
/* 206 */       k = Integer.valueOf(str2).intValue();
/* 207 */       m = Integer.valueOf(str3).intValue();
/* 208 */       n = Integer.valueOf(str4).intValue();
/*     */ 
/* 211 */       if (k > MAXHOUR) {
/* 212 */         throw new NumberFormatException();
/*     */       }
/*     */ 
/* 215 */       if (m > MAXMINUTE) {
/* 216 */         throw new NumberFormatException();
/*     */       }
/*     */ 
/* 219 */       if (n > MAXSECOND) {
/* 220 */         throw new NumberFormatException();
/*     */       }
/*     */ 
/* 223 */       if (str5.length() <= MAXLEADPREC) {
/* 224 */         if (str5.length() < MAXLEADPREC)
/*     */         {
/* 226 */           char[] arrayOfChar = new char[MAXLEADPREC];
/*     */ 
/* 228 */           for (int i4 = 0; i4 < str5.length(); i4++) {
/* 229 */             arrayOfChar[i4] = str5.charAt(i4);
/*     */           }
/*     */ 
/* 232 */           for (int i5 = i4; i5 < MAXLEADPREC; i5++) {
/* 233 */             arrayOfChar[i5] = '0';
/*     */           }
/*     */ 
/* 236 */           String str8 = new String(arrayOfChar);
/* 237 */           i1 = Integer.valueOf(str8).intValue();
/*     */         }
/*     */         else {
/* 240 */           i1 = Integer.valueOf(str5).intValue();
/*     */         }
/*     */       }
/*     */       else
/* 244 */         throw new NumberFormatException();
/*     */     }
/*     */     else
/*     */     {
/* 248 */       throw new NumberFormatException();
/*     */     }
/*     */ 
/* 251 */     if (i2 == 45) {
/* 252 */       j = -j;
/* 253 */       k = -k;
/* 254 */       m = -m;
/* 255 */       n = -n;
/* 256 */       i1 = -i1;
/*     */     }
/*     */ 
/* 260 */     j += INTERVALDAYOFFSET;
/*     */ 
/* 263 */     arrayOfByte[0] = utilpack.RIGHTSHIFTFIRSTNIBBLE(j);
/* 264 */     arrayOfByte[1] = utilpack.RIGHTSHIFTSECONDNIBBLE(j);
/* 265 */     arrayOfByte[2] = utilpack.RIGHTSHIFTTHIRDNIBBLE(j);
/* 266 */     arrayOfByte[3] = utilpack.RIGHTSHIFTFOURTHNIBBLE(j);
/*     */ 
/* 269 */     arrayOfByte[4] = ((byte)(k + INTERVALDSOFFSET));
/*     */ 
/* 272 */     arrayOfByte[5] = ((byte)(m + INTERVALDSOFFSET));
/*     */ 
/* 275 */     arrayOfByte[6] = ((byte)(n + INTERVALDSOFFSET));
/*     */ 
/* 280 */     i1 += INTERVALDAYOFFSET;
/*     */ 
/* 282 */     arrayOfByte[7] = utilpack.RIGHTSHIFTFIRSTNIBBLE(i1);
/* 283 */     arrayOfByte[8] = utilpack.RIGHTSHIFTSECONDNIBBLE(i1);
/* 284 */     arrayOfByte[9] = utilpack.RIGHTSHIFTTHIRDNIBBLE(i1);
/* 285 */     arrayOfByte[10] = utilpack.RIGHTSHIFTFOURTHNIBBLE(i1);
/*     */ 
/* 287 */     return arrayOfByte;
/*     */   }
/*     */ 
/*     */   public static String toString(byte[] paramArrayOfByte)
/*     */   {
/* 302 */     if ((paramArrayOfByte == null) || (paramArrayOfByte.length == 0)) {
/* 303 */       return new String();
/*     */     }
/*     */ 
/* 307 */     int i = 1;
/*     */ 
/* 309 */     int i1 = 0;
/*     */ 
/* 312 */     int j = utilpack.LEFTSHIFTFIRSTNIBBLE(paramArrayOfByte[0]);
/* 313 */     j |= utilpack.LEFTSHIFTSECONDNIBBLE(paramArrayOfByte[1]);
/* 314 */     j |= utilpack.LEFTSHIFTTHIRDNIBBLE(paramArrayOfByte[2]);
/* 315 */     j |= paramArrayOfByte[3] & 0xFF;
/*     */ 
/* 318 */     j -= INTERVALDAYOFFSET;
/* 319 */     int k = paramArrayOfByte[4] - INTERVALDSOFFSET;
/* 320 */     int m = paramArrayOfByte[5] - INTERVALDSOFFSET;
/* 321 */     int n = paramArrayOfByte[6] - INTERVALDSOFFSET;
/*     */ 
/* 323 */     i1 = utilpack.LEFTSHIFTFIRSTNIBBLE(paramArrayOfByte[7]);
/* 324 */     i1 |= utilpack.LEFTSHIFTSECONDNIBBLE(paramArrayOfByte[8]);
/* 325 */     i1 |= utilpack.LEFTSHIFTTHIRDNIBBLE(paramArrayOfByte[9]);
/* 326 */     i1 |= paramArrayOfByte[10] & 0xFF;
/*     */ 
/* 329 */     i1 -= INTERVALDAYOFFSET;
/*     */ 
/* 331 */     if (j < 0) {
/* 332 */       i = 0;
/* 333 */       j = -j;
/* 334 */       k = -k;
/* 335 */       m = -m;
/* 336 */       n = -n;
/* 337 */       i1 = -i1;
/*     */     }
/* 339 */     else if (k < 0) {
/* 340 */       i = 0;
/* 341 */       k = -k;
/* 342 */       m = -m;
/* 343 */       n = -n;
/* 344 */       i1 = -i1;
/*     */     }
/* 346 */     else if (m < 0) {
/* 347 */       i = 0;
/* 348 */       m = -m;
/* 349 */       n = -n;
/* 350 */       i1 = -i1;
/*     */     }
/* 352 */     else if (n < 0) {
/* 353 */       i = 0;
/* 354 */       n = -n;
/* 355 */       i1 = -i1;
/*     */     }
/* 357 */     else if (i1 < 0) {
/* 358 */       i = 0;
/* 359 */       i1 = -i1;
/*     */     }
/*     */ 
/* 362 */     String str2 = String.format("%09d", new Object[] { Integer.valueOf(i1) });
/*     */ 
/* 364 */     char[] arrayOfChar = str2.toCharArray();
/* 365 */     int i2 = arrayOfChar.length;
/*     */ 
/* 367 */     while ((i2 > 1) && (arrayOfChar[(i2 - 1)] == '0')) {
/* 368 */       i2--;
/*     */     }
/*     */ 
/* 371 */     str2 = str2.substring(0, i2);
/*     */ 
/* 373 */     String str1 = j + " " + k + ":" + m + ":" + n + "." + str2;
/*     */ 
/* 376 */     if (i == 0) {
/* 377 */       str1 = "-" + str1;
/*     */     }
/*     */ 
/* 380 */     return str1;
/*     */   }
/*     */ 
/*     */   public Object toJdbc()
/*     */   {
/* 392 */     return this;
/*     */   }
/*     */ 
/*     */   public String stringValue()
/*     */   {
/* 403 */     return toString(getBytes());
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 416 */     return toString(getBytes());
/*     */   }
/*     */ 
/*     */   public boolean isConvertibleTo(Class paramClass)
/*     */   {
/* 429 */     if (paramClass.getName().compareTo("java.lang.String") == 0) {
/* 430 */       return true;
/*     */     }
/* 432 */     return false;
/*     */   }
/*     */ 
/*     */   public Object makeJdbcArray(int paramInt)
/*     */   {
/* 444 */     INTERVALDS[] arrayOfINTERVALDS = new INTERVALDS[paramInt];
/*     */ 
/* 446 */     return arrayOfINTERVALDS;
/*     */   }
/*     */ 
/*     */   private static byte[] _initIntervalDS()
/*     */   {
/* 457 */     byte[] arrayOfByte = new byte[INTERVALDSMAXLENGTH];
/*     */ 
/* 461 */     int i = 0;
/* 462 */     int j = 0;
/* 463 */     int k = 0;
/* 464 */     int m = 0;
/* 465 */     int n = 0;
/*     */ 
/* 469 */     i += INTERVALDAYOFFSET;
/*     */ 
/* 474 */     arrayOfByte[0] = utilpack.RIGHTSHIFTFIRSTNIBBLE(i);
/* 475 */     arrayOfByte[1] = utilpack.RIGHTSHIFTSECONDNIBBLE(i);
/* 476 */     arrayOfByte[2] = utilpack.RIGHTSHIFTTHIRDNIBBLE(i);
/* 477 */     arrayOfByte[3] = utilpack.RIGHTSHIFTFOURTHNIBBLE(i);
/*     */ 
/* 482 */     arrayOfByte[4] = ((byte)(j + INTERVALDSOFFSET));
/* 483 */     arrayOfByte[5] = ((byte)(k + INTERVALDSOFFSET));
/* 484 */     arrayOfByte[6] = ((byte)(m + INTERVALDSOFFSET));
/*     */ 
/* 486 */     n += INTERVALDAYOFFSET;
/*     */ 
/* 488 */     arrayOfByte[7] = utilpack.RIGHTSHIFTFIRSTNIBBLE(n);
/* 489 */     arrayOfByte[8] = utilpack.RIGHTSHIFTSECONDNIBBLE(n);
/* 490 */     arrayOfByte[9] = utilpack.RIGHTSHIFTTHIRDNIBBLE(n);
/* 491 */     arrayOfByte[10] = utilpack.RIGHTSHIFTFOURTHNIBBLE(n);
/*     */ 
/* 495 */     return arrayOfByte;
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.sql.INTERVALDS
 * JD-Core Version:    0.6.2
 */