/*     */ package oracle.sql;
/*     */ 
/*     */ import java.sql.Connection;
/*     */ import java.sql.SQLException;
/*     */ import oracle.jdbc.driver.DatabaseError;
/*     */ import oracle.jdbc.driver.OracleDriver;
/*     */ import oracle.jdbc.internal.OracleDatumWithConnection;
/*     */ 
/*     */ public abstract class DatumWithConnection extends Datum
/*     */   implements OracleDatumWithConnection
/*     */ {
/*  29 */   private oracle.jdbc.internal.OracleConnection physicalConnection = null;
/*     */ 
/* 254 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   oracle.jdbc.internal.OracleConnection getPhysicalConnection()
/*     */   {
/*  39 */     if (this.physicalConnection == null)
/*     */     {
/*     */       try
/*     */       {
/*  54 */         this.physicalConnection = ((oracle.jdbc.internal.OracleConnection)new OracleDriver().defaultConnection());
/*     */       }
/*     */       catch (SQLException localSQLException)
/*     */       {
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/*  67 */     return this.physicalConnection;
/*     */   }
/*     */ 
/*     */   public DatumWithConnection(byte[] paramArrayOfByte)
/*     */     throws SQLException
/*     */   {
/*  73 */     super(paramArrayOfByte);
/*     */   }
/*     */ 
/*     */   public DatumWithConnection()
/*     */   {
/*     */   }
/*     */ 
/*     */   public static void assertNotNull(Connection paramConnection)
/*     */     throws SQLException
/*     */   {
/*  88 */     if (paramConnection == null)
/*     */     {
/*  90 */       SQLException localSQLException = DatabaseError.createSqlException(null, 68, "Connection is null");
/*  91 */       localSQLException.fillInStackTrace();
/*  92 */       throw localSQLException;
/*     */     }
/*     */   }
/*     */ 
/*     */   public static void assertNotNull(TypeDescriptor paramTypeDescriptor)
/*     */     throws SQLException
/*     */   {
/* 100 */     if (paramTypeDescriptor == null)
/*     */     {
/* 102 */       SQLException localSQLException = DatabaseError.createSqlException(null, 61);
/* 103 */       localSQLException.fillInStackTrace();
/* 104 */       throw localSQLException;
/*     */     }
/*     */   }
/*     */ 
/*     */   public void setPhysicalConnectionOf(Connection paramConnection)
/*     */   {
/* 119 */     this.physicalConnection = ((oracle.jdbc.OracleConnection)paramConnection).physicalConnectionWithin();
/*     */   }
/*     */ 
/*     */   public Connection getJavaSqlConnection()
/*     */     throws SQLException
/*     */   {
/* 144 */     return getPhysicalConnection().getWrapper();
/*     */   }
/*     */ 
/*     */   public oracle.jdbc.OracleConnection getOracleConnection()
/*     */     throws SQLException
/*     */   {
/* 167 */     return getPhysicalConnection().getWrapper();
/*     */   }
/*     */ 
/*     */   public oracle.jdbc.internal.OracleConnection getInternalConnection()
/*     */     throws SQLException
/*     */   {
/* 193 */     return getPhysicalConnection();
/*     */   }
/*     */ 
/*     */   /** @deprecated */
/*     */   public oracle.jdbc.driver.OracleConnection getConnection()
/*     */     throws SQLException
/*     */   {
/* 220 */     oracle.jdbc.driver.OracleConnection localOracleConnection = null;
/*     */     try
/*     */     {
/* 224 */       localOracleConnection = (oracle.jdbc.driver.OracleConnection)((oracle.jdbc.driver.OracleConnection)this.physicalConnection).getWrapper();
/*     */     }
/*     */     catch (ClassCastException localClassCastException)
/*     */     {
/* 229 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 103);
/* 230 */       localSQLException.fillInStackTrace();
/* 231 */       throw localSQLException;
/*     */     }
/*     */ 
/* 234 */     return localOracleConnection;
/*     */   }
/*     */ 
/*     */   protected oracle.jdbc.internal.OracleConnection getConnectionDuringExceptionHandling()
/*     */   {
/* 249 */     return this.physicalConnection;
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.sql.DatumWithConnection
 * JD-Core Version:    0.6.2
 */