/*     */ package oracle.sql;
/*     */ 
/*     */ import java.io.ByteArrayInputStream;
/*     */ import java.io.InputStream;
/*     */ import java.io.Reader;
/*     */ import java.io.Serializable;
/*     */ import java.math.BigDecimal;
/*     */ import java.sql.Connection;
/*     */ import java.sql.Date;
/*     */ import java.sql.SQLException;
/*     */ import java.sql.Time;
/*     */ import java.sql.Timestamp;
/*     */ import java.util.Calendar;
/*     */ import oracle.jdbc.driver.DatabaseError;
/*     */ import oracle.jdbc.internal.OracleConnection;
/*     */ 
/*     */ public abstract class Datum
/*     */   implements Serializable
/*     */ {
/*     */   private byte[] data;
/*     */   static final long serialVersionUID = 4645732484621936751L;
/* 520 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   public Datum()
/*     */   {
/*     */   }
/*     */ 
/*     */   public Datum(byte[] paramArrayOfByte)
/*     */   {
/*  51 */     this.data = paramArrayOfByte;
/*     */   }
/*     */ 
/*     */   public boolean equals(Object paramObject)
/*     */   {
/*  65 */     if (this == paramObject)
/*  66 */       return true;
/*  67 */     if ((paramObject == null) || (!(paramObject instanceof Datum)))
/*  68 */       return false;
/*  69 */     if (getClass() == paramObject.getClass())
/*     */     {
/*  71 */       Datum localDatum = (Datum)paramObject;
/*     */ 
/*  75 */       if ((this.data == null) && (localDatum.data == null))
/*  76 */         return true;
/*  77 */       if (((this.data == null) && (localDatum.data != null)) || ((this.data != null) && (localDatum.data == null)))
/*     */       {
/*  79 */         return false;
/*     */       }
/*  81 */       if (this.data.length != localDatum.data.length) {
/*  82 */         return false;
/*     */       }
/*  84 */       for (int i = 0; i < this.data.length; i++)
/*     */       {
/*  86 */         if (this.data[i] != localDatum.data[i]) {
/*  87 */           return false;
/*     */         }
/*     */       }
/*  90 */       return true;
/*     */     }
/*     */ 
/*  93 */     return false;
/*     */   }
/*     */ 
/*     */   public byte[] shareBytes()
/*     */   {
/* 106 */     return this.data;
/*     */   }
/*     */ 
/*     */   public long getLength()
/*     */   {
/* 116 */     if (null == this.data) {
/* 117 */       return 0L;
/*     */     }
/* 119 */     return this.data.length;
/*     */   }
/*     */ 
/*     */   public void setBytes(byte[] paramArrayOfByte)
/*     */   {
/* 129 */     int i = paramArrayOfByte.length;
/* 130 */     this.data = new byte[i];
/* 131 */     System.arraycopy(paramArrayOfByte, 0, this.data, 0, i);
/*     */   }
/*     */ 
/*     */   public void setShareBytes(byte[] paramArrayOfByte)
/*     */   {
/* 141 */     this.data = paramArrayOfByte;
/*     */   }
/*     */ 
/*     */   public byte[] getBytes()
/*     */   {
/* 164 */     if (this.data == null) {
/* 165 */       return new byte[0];
/*     */     }
/* 167 */     byte[] arrayOfByte = new byte[this.data.length];
/* 168 */     System.arraycopy(this.data, 0, arrayOfByte, 0, this.data.length);
/* 169 */     return arrayOfByte;
/*     */   }
/*     */ 
/*     */   public boolean isNull()
/*     */   {
/* 186 */     return (this.data == null) || (this.data.length == 0);
/*     */   }
/*     */ 
/*     */   public InputStream getStream()
/*     */   {
/* 199 */     return new ByteArrayInputStream(this.data);
/*     */   }
/*     */ 
/*     */   public String stringValue()
/*     */     throws SQLException
/*     */   {
/* 210 */     throw new SQLException("Conversion to String failed");
/*     */   }
/*     */ 
/*     */   public String stringValue(Connection paramConnection)
/*     */     throws SQLException
/*     */   {
/* 221 */     return stringValue();
/*     */   }
/*     */ 
/*     */   public boolean booleanValue()
/*     */     throws SQLException
/*     */   {
/* 232 */     throw new SQLException("Conversion to boolean failed");
/*     */   }
/*     */ 
/*     */   public int intValue()
/*     */     throws SQLException
/*     */   {
/* 243 */     throw new SQLException("Conversion to integer failed");
/*     */   }
/*     */ 
/*     */   public long longValue()
/*     */     throws SQLException
/*     */   {
/* 254 */     throw new SQLException("Conversion to long failed");
/*     */   }
/*     */ 
/*     */   public float floatValue()
/*     */     throws SQLException
/*     */   {
/* 265 */     throw new SQLException("Conversion to float failed");
/*     */   }
/*     */ 
/*     */   public double doubleValue()
/*     */     throws SQLException
/*     */   {
/* 276 */     throw new SQLException("Conversion to double failed");
/*     */   }
/*     */ 
/*     */   public byte byteValue()
/*     */     throws SQLException
/*     */   {
/* 287 */     throw new SQLException("Conversion to byte failed");
/*     */   }
/*     */ 
/*     */   public BigDecimal bigDecimalValue()
/*     */     throws SQLException
/*     */   {
/* 298 */     throw new SQLException("Conversion to BigDecimal failed");
/*     */   }
/*     */ 
/*     */   public Date dateValue()
/*     */     throws SQLException
/*     */   {
/* 309 */     throw new SQLException("Conversion to Date failed");
/*     */   }
/*     */ 
/*     */   public Time timeValue()
/*     */     throws SQLException
/*     */   {
/* 320 */     throw new SQLException("Conversion to Time failed");
/*     */   }
/*     */ 
/*     */   public Time timeValue(Calendar paramCalendar) throws SQLException {
/* 324 */     throw new SQLException("Conversion to Time failed");
/*     */   }
/*     */ 
/*     */   public Timestamp timestampValue()
/*     */     throws SQLException
/*     */   {
/* 334 */     throw new SQLException("Conversion to Timestamp failed");
/*     */   }
/*     */ 
/*     */   public Timestamp timestampValue(Calendar paramCalendar) throws SQLException {
/* 338 */     throw new SQLException("Conversion to Timestamp failed");
/*     */   }
/*     */ 
/*     */   public Reader characterStreamValue()
/*     */     throws SQLException
/*     */   {
/* 349 */     throw new SQLException("Conversion to character stream failed");
/*     */   }
/*     */ 
/*     */   public InputStream asciiStreamValue()
/*     */     throws SQLException
/*     */   {
/* 360 */     throw new SQLException("Conversion to ascii stream failed");
/*     */   }
/*     */ 
/*     */   public InputStream binaryStreamValue()
/*     */     throws SQLException
/*     */   {
/* 371 */     throw new SQLException("Conversion to binary stream failed");
/*     */   }
/*     */ 
/*     */   public abstract boolean isConvertibleTo(Class paramClass);
/*     */ 
/*     */   public <T> T toClass(Class<T> paramClass)
/*     */     throws SQLException
/*     */   {
/* 397 */     Object localObject = null;
/* 398 */     if (paramClass == getClass()) { localObject = this;
/* 399 */     } else if (paramClass == String.class) { localObject = stringValue();
/* 400 */     } else if (paramClass == Boolean.class) { localObject = Boolean.valueOf(booleanValue());
/* 401 */     } else if (paramClass == Byte.class) { localObject = Byte.valueOf(byteValue());
/* 402 */     } else if (paramClass == Integer.class) { localObject = Integer.valueOf(intValue());
/* 403 */     } else if (paramClass == Long.class) { localObject = Long.valueOf(longValue());
/* 404 */     } else if (paramClass == Float.class) { localObject = Float.valueOf(floatValue());
/* 405 */     } else if (paramClass == Double.class) { localObject = Double.valueOf(doubleValue());
/* 406 */     } else if (paramClass == BigDecimal.class) { localObject = bigDecimalValue();
/* 407 */     } else if (paramClass == Date.class) { localObject = dateValue();
/* 408 */     } else if (paramClass == Time.class) { localObject = timeValue();
/* 409 */     } else if (paramClass == Timestamp.class) { localObject = timestampValue();
/* 410 */     } else if (paramClass == Reader.class) { localObject = characterStreamValue();
/* 411 */     } else if (paramClass == InputStream.class) { localObject = binaryStreamValue();
/*     */     } else {
/* 413 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 59, paramClass.getName());
/* 414 */       localSQLException.fillInStackTrace();
/* 415 */       throw localSQLException;
/*     */     }
/* 417 */     return localObject;
/*     */   }
/*     */ 
/*     */   public abstract Object toJdbc()
/*     */     throws SQLException;
/*     */ 
/*     */   public abstract Object makeJdbcArray(int paramInt);
/*     */ 
/*     */   protected static int compareBytes(byte[] paramArrayOfByte1, byte[] paramArrayOfByte2)
/*     */   {
/* 447 */     int i = paramArrayOfByte1.length;
/* 448 */     int j = paramArrayOfByte2.length;
/* 449 */     int k = 0;
/* 450 */     int m = Math.min(i, j);
/* 451 */     int n = 0;
/* 452 */     int i1 = 0;
/*     */ 
/* 454 */     while (k < m)
/*     */     {
/* 457 */       n = paramArrayOfByte1[k] & 0xFF;
/* 458 */       i1 = paramArrayOfByte2[k] & 0xFF;
/*     */ 
/* 460 */       if (n != i1)
/*     */       {
/* 462 */         if (n < i1) {
/* 463 */           return -1;
/*     */         }
/* 465 */         return 1;
/*     */       }
/*     */ 
/* 468 */       k++;
/*     */     }
/*     */ 
/* 473 */     if (i == j)
/* 474 */       return 0;
/* 475 */     if (i > j) {
/* 476 */       return 1;
/*     */     }
/* 478 */     return -1;
/*     */   }
/*     */ 
/*     */   protected boolean bytesEqual(Datum paramDatum)
/*     */   {
/* 483 */     boolean bool = this == paramDatum;
/* 484 */     if (!bool) {
/* 485 */       byte[] arrayOfByte = paramDatum.shareBytes();
/* 486 */       int i = this.data == null ? 1 : 0;
/* 487 */       if (i == (arrayOfByte == null ? 1 : 0)) if ((i != 0) || (this.data.length == arrayOfByte.length))
/*     */         {
/* 489 */           bool = true;
/* 490 */           if (i == 0)
/* 491 */             for (int j = 0; j < this.data.length; j++)
/* 492 */               if (this.data[j] != arrayOfByte[j]) {
/* 493 */                 bool = false;
/* 494 */                 break;
/*     */               }
/*     */         }
/*     */     }
/* 498 */     return bool;
/*     */   }
/*     */ 
/*     */   protected OracleConnection getConnectionDuringExceptionHandling()
/*     */   {
/* 516 */     return null;
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.sql.Datum
 * JD-Core Version:    0.6.2
 */