/*      */ package oracle.sql;
/*      */ 
/*      */ import java.io.PrintStream;
/*      */ import java.sql.SQLException;
/*      */ import java.sql.Time;
/*      */ import java.sql.Timestamp;
/*      */ import java.text.ParseException;
/*      */ import java.text.SimpleDateFormat;
/*      */ import java.util.Calendar;
/*      */ 
/*      */ public class DATE extends Datum
/*      */ {
/*      */   static final long serialVersionUID = 5229717576495161269L;
/*      */   public static final int BDA = 1;
/*      */   public static final int BDAL = 2;
/*      */   public static final int BMO = 4;
/*      */   public static final int BMOL = 8;
/*      */   public static final int BYR = 16;
/*      */   public static final int BYRL = 32;
/*      */   public static final int BHR = 64;
/*      */   public static final int BHRL = 128;
/*      */   public static final int BMN = 256;
/*      */   public static final int BMNL = 512;
/*      */   public static final int BSC = 1024;
/*      */   public static final int BSCL = 2048;
/*      */   public static final int MSD = 4096;
/*      */   public static final int YR0 = 8192;
/*      */   public static final int BDT = 32768;
/*      */   public static final int HRZER0 = 65536;
/*      */   public static final int MIZERO = 131072;
/*      */   public static final int SEZERO = 262144;
/*      */   private static final byte LDXTCE = 0;
/*      */   private static final byte LDXTYE = 1;
/*      */   private static final byte LDXTMO = 2;
/*      */   private static final byte LDXTDA = 3;
/*      */   private static final byte LDXTHO = 4;
/*      */   private static final byte LDXTMI = 5;
/*      */   private static final byte LDXTSE = 6;
/*      */   private static LdxLib _sldxlib;
/* 1372 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*      */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*      */   public static final boolean TRACE = false;
/*      */ 
/*      */   public DATE()
/*      */   {
/*   69 */     super(_initDate());
/*      */   }
/*      */ 
/*      */   public DATE(byte[] paramArrayOfByte)
/*      */   {
/*   80 */     super(paramArrayOfByte);
/*      */   }
/*      */ 
/*      */   public DATE(java.sql.Date paramDate)
/*      */   {
/*   92 */     super(toBytes(paramDate));
/*      */   }
/*      */ 
/*      */   public DATE(Time paramTime)
/*      */   {
/*  104 */     super(toBytes(paramTime));
/*      */   }
/*      */ 
/*      */   public DATE(Timestamp paramTimestamp)
/*      */   {
/*  116 */     super(toBytes(paramTimestamp));
/*      */   }
/*      */ 
/*      */   public DATE(java.sql.Date paramDate, Calendar paramCalendar)
/*      */   {
/*  130 */     super(toBytes(paramDate, paramCalendar));
/*      */   }
/*      */ 
/*      */   public DATE(Time paramTime, Calendar paramCalendar)
/*      */   {
/*  144 */     super(toBytes(paramTime, paramCalendar));
/*      */   }
/*      */ 
/*      */   public DATE(Timestamp paramTimestamp, Calendar paramCalendar)
/*      */   {
/*  158 */     super(toBytes(paramTimestamp, paramCalendar));
/*      */   }
/*      */ 
/*      */   public DATE(String paramString)
/*      */   {
/*  170 */     super(toBytes(paramString));
/*      */   }
/*      */ 
/*      */   public DATE(String paramString, boolean paramBoolean)
/*      */     throws ParseException
/*      */   {
/*  186 */     super(toBytes(paramString));
/*  187 */     if (!paramBoolean)
/*      */     {
/*  190 */       SimpleDateFormat localSimpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
/*      */ 
/*  193 */       localSimpleDateFormat.setLenient(false);
/*      */ 
/*  195 */       java.util.Date localDate = localSimpleDateFormat.parse(paramString);
/*      */     }
/*      */   }
/*      */ 
/*      */   public DATE(String paramString, Calendar paramCalendar)
/*      */   {
/*  210 */     super(toBytes(paramString, paramCalendar));
/*      */   }
/*      */ 
/*      */   public DATE(Object paramObject)
/*      */     throws SQLException
/*      */   {
/*  223 */     if ((paramObject instanceof java.sql.Date)) {
/*  224 */       setShareBytes(toBytes((java.sql.Date)paramObject));
/*      */     }
/*  226 */     else if ((paramObject instanceof Time)) {
/*  227 */       setShareBytes(toBytes((Time)paramObject));
/*      */     }
/*  229 */     else if ((paramObject instanceof Timestamp)) {
/*  230 */       setShareBytes(toBytes((Timestamp)paramObject));
/*      */     }
/*  232 */     else if ((paramObject instanceof String)) {
/*  233 */       setShareBytes(toBytes((String)paramObject));
/*      */     }
/*      */     else
/*  236 */       throw new SQLException("Initialization failed");
/*      */   }
/*      */ 
/*      */   public DATE(Object paramObject, Calendar paramCalendar)
/*      */     throws SQLException
/*      */   {
/*  253 */     if ((paramObject instanceof java.sql.Date)) {
/*  254 */       setShareBytes(toBytes((java.sql.Date)paramObject, paramCalendar));
/*      */     }
/*  256 */     else if ((paramObject instanceof Time)) {
/*  257 */       setShareBytes(toBytes((Time)paramObject, paramCalendar));
/*      */     }
/*  259 */     else if ((paramObject instanceof Timestamp)) {
/*  260 */       setShareBytes(toBytes((Timestamp)paramObject, paramCalendar));
/*      */     }
/*  262 */     else if ((paramObject instanceof String)) {
/*  263 */       setShareBytes(toBytes((String)paramObject, paramCalendar));
/*      */     }
/*      */     else
/*  266 */       throw new SQLException("Initialization failed");
/*      */   }
/*      */ 
/*      */   public static java.sql.Date toDate(byte[] paramArrayOfByte)
/*      */   {
/*  288 */     return toDate(paramArrayOfByte, null);
/*      */   }
/*      */ 
/*      */   public static Time toTime(byte[] paramArrayOfByte)
/*      */   {
/*  300 */     return toTime(paramArrayOfByte, null);
/*      */   }
/*      */ 
/*      */   public static Timestamp toTimestamp(byte[] paramArrayOfByte)
/*      */   {
/*  312 */     return toTimestamp(paramArrayOfByte, null);
/*      */   }
/*      */ 
/*      */   public static java.sql.Date toDate(byte[] paramArrayOfByte, Calendar paramCalendar)
/*      */   {
/*  327 */     int[] arrayOfInt = new int[7];
/*      */ 
/*  329 */     for (int i = 0; i < 7; i++) {
/*  330 */       paramArrayOfByte[i] &= 255;
/*      */     }
/*      */ 
/*  334 */     i = TIMESTAMP.getJavaYear(arrayOfInt[0], arrayOfInt[1]);
/*      */     Calendar localCalendar;
/*  337 */     if (paramCalendar == null) {
/*  338 */       localCalendar = Calendar.getInstance();
/*      */     }
/*      */     else {
/*  341 */       localCalendar = Calendar.getInstance(paramCalendar.getTimeZone());
/*      */     }
/*      */ 
/*  344 */     localCalendar.clear();
/*  345 */     localCalendar.set(1, i);
/*  346 */     localCalendar.set(2, arrayOfInt[2] - 1);
/*  347 */     localCalendar.set(5, arrayOfInt[3]);
/*  348 */     localCalendar.set(11, arrayOfInt[4] - 1);
/*  349 */     localCalendar.set(12, arrayOfInt[5] - 1);
/*  350 */     localCalendar.set(13, arrayOfInt[6] - 1);
/*  351 */     localCalendar.set(14, 0);
/*      */ 
/*  353 */     java.sql.Date localDate = new java.sql.Date(localCalendar.getTime().getTime());
/*      */ 
/*  355 */     return localDate;
/*      */   }
/*      */ 
/*      */   public static Time toTime(byte[] paramArrayOfByte, Calendar paramCalendar)
/*      */   {
/*  369 */     int[] arrayOfInt = new int[7];
/*      */ 
/*  371 */     for (int i = 0; i < 7; i++)
/*  372 */       paramArrayOfByte[i] &= 255;
/*      */     Calendar localCalendar;
/*  376 */     if (paramCalendar == null) {
/*  377 */       localCalendar = Calendar.getInstance();
/*      */     }
/*      */     else {
/*  380 */       localCalendar = Calendar.getInstance(paramCalendar.getTimeZone());
/*      */     }
/*      */ 
/*  383 */     localCalendar.clear();
/*  384 */     localCalendar.set(1, 1970);
/*  385 */     localCalendar.set(2, 0);
/*  386 */     localCalendar.set(5, 1);
/*  387 */     localCalendar.set(11, arrayOfInt[4] - 1);
/*  388 */     localCalendar.set(12, arrayOfInt[5] - 1);
/*  389 */     localCalendar.set(13, arrayOfInt[6] - 1);
/*  390 */     localCalendar.set(14, 0);
/*      */ 
/*  392 */     Time localTime = new Time(localCalendar.getTime().getTime());
/*      */ 
/*  394 */     return localTime;
/*      */   }
/*      */ 
/*      */   public static Timestamp toTimestamp(byte[] paramArrayOfByte, Calendar paramCalendar)
/*      */   {
/*  408 */     int[] arrayOfInt = new int[7];
/*      */ 
/*  410 */     for (int i = 0; i < 7; i++) {
/*  411 */       paramArrayOfByte[i] &= 255;
/*      */     }
/*      */ 
/*  415 */     i = TIMESTAMP.getJavaYear(arrayOfInt[0], arrayOfInt[1]);
/*      */     Calendar localCalendar;
/*  418 */     if (paramCalendar == null) {
/*  419 */       localCalendar = Calendar.getInstance();
/*      */     }
/*      */     else {
/*  422 */       localCalendar = Calendar.getInstance(paramCalendar.getTimeZone());
/*      */     }
/*      */ 
/*  425 */     localCalendar.clear();
/*  426 */     localCalendar.set(1, i);
/*  427 */     localCalendar.set(2, arrayOfInt[2] - 1);
/*  428 */     localCalendar.set(5, arrayOfInt[3]);
/*  429 */     localCalendar.set(11, arrayOfInt[4] - 1);
/*  430 */     localCalendar.set(12, arrayOfInt[5] - 1);
/*  431 */     localCalendar.set(13, arrayOfInt[6] - 1);
/*  432 */     localCalendar.set(14, 0);
/*      */ 
/*  434 */     Timestamp localTimestamp = new Timestamp(localCalendar.getTime().getTime());
/*      */ 
/*  437 */     return localTimestamp;
/*      */   }
/*      */ 
/*      */   public static String toString(byte[] paramArrayOfByte)
/*      */   {
/*  451 */     if ((paramArrayOfByte == null) || (paramArrayOfByte.length == 0)) {
/*  452 */       return new String();
/*      */     }
/*      */ 
/*  455 */     int[] arrayOfInt = new int[7];
/*      */ 
/*  457 */     for (int i = 0; i < 7; i++) {
/*  458 */       if (paramArrayOfByte[i] < 0) {
/*  459 */         paramArrayOfByte[i] += 256;
/*      */       }
/*      */       else {
/*  462 */         arrayOfInt[i] = paramArrayOfByte[i];
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*  467 */     i = TIMESTAMP.getJavaYear(arrayOfInt[0], arrayOfInt[1]);
/*  468 */     int j = arrayOfInt[2];
/*  469 */     int k = arrayOfInt[3];
/*  470 */     int m = arrayOfInt[4] - 1;
/*  471 */     int n = arrayOfInt[5] - 1;
/*  472 */     int i1 = arrayOfInt[6] - 1;
/*  473 */     int i2 = -1;
/*      */ 
/*  475 */     String str = TIMESTAMPTZ.toString(i, j, k, m, n, i1, -1, null);
/*      */ 
/*  477 */     return str;
/*      */   }
/*      */ 
/*      */   public byte[] toBytes()
/*      */   {
/*  488 */     return getBytes();
/*      */   }
/*      */ 
/*      */   public static byte[] toBytes(java.sql.Date paramDate)
/*      */   {
/*  499 */     return toBytes(paramDate, null);
/*      */   }
/*      */ 
/*      */   public static byte[] toBytes(Time paramTime)
/*      */   {
/*  510 */     return toBytes(paramTime, null);
/*      */   }
/*      */ 
/*      */   public static byte[] toBytes(Timestamp paramTimestamp)
/*      */   {
/*  521 */     return toBytes(paramTimestamp, null);
/*      */   }
/*      */ 
/*      */   public static byte[] toBytes(java.sql.Date paramDate, Calendar paramCalendar)
/*      */   {
/*  535 */     if (paramDate == null)
/*  536 */       return null;
/*      */     Calendar localCalendar;
/*  540 */     if (paramCalendar == null) {
/*  541 */       localCalendar = Calendar.getInstance();
/*      */     }
/*      */     else {
/*  544 */       localCalendar = Calendar.getInstance(paramCalendar.getTimeZone());
/*      */     }
/*      */ 
/*  547 */     localCalendar.clear();
/*  548 */     localCalendar.setTime(paramDate);
/*      */ 
/*  550 */     byte[] arrayOfByte = new byte[7];
/*      */ 
/*  552 */     int i = TIMESTAMP.getOracleYear(localCalendar);
/*      */ 
/*  554 */     arrayOfByte[0] = ((byte)(i / 100 + 100));
/*  555 */     arrayOfByte[1] = ((byte)(i % 100 + 100));
/*  556 */     arrayOfByte[2] = ((byte)(localCalendar.get(2) + 1));
/*  557 */     arrayOfByte[3] = ((byte)localCalendar.get(5));
/*  558 */     arrayOfByte[4] = ((byte)(localCalendar.get(11) + 1));
/*  559 */     arrayOfByte[5] = ((byte)(localCalendar.get(12) + 1));
/*  560 */     arrayOfByte[6] = ((byte)(localCalendar.get(13) + 1));
/*      */ 
/*  562 */     return arrayOfByte;
/*      */   }
/*      */ 
/*      */   public static byte[] toBytes(Time paramTime, Calendar paramCalendar)
/*      */   {
/*  577 */     if (paramTime == null)
/*  578 */       return null;
/*      */     Calendar localCalendar;
/*  582 */     if (paramCalendar == null) {
/*  583 */       localCalendar = Calendar.getInstance();
/*      */     }
/*      */     else {
/*  586 */       localCalendar = Calendar.getInstance(paramCalendar.getTimeZone());
/*      */     }
/*      */ 
/*  589 */     localCalendar.clear();
/*  590 */     localCalendar.setTime(paramTime);
/*      */ 
/*  592 */     byte[] arrayOfByte = new byte[7];
/*      */ 
/*  594 */     arrayOfByte[0] = 119;
/*  595 */     arrayOfByte[1] = -86;
/*  596 */     arrayOfByte[2] = 1;
/*  597 */     arrayOfByte[3] = 1;
/*  598 */     arrayOfByte[4] = ((byte)(localCalendar.get(11) + 1));
/*  599 */     arrayOfByte[5] = ((byte)(localCalendar.get(12) + 1));
/*  600 */     arrayOfByte[6] = ((byte)(localCalendar.get(13) + 1));
/*      */ 
/*  602 */     return arrayOfByte;
/*      */   }
/*      */ 
/*      */   public static byte[] toBytes(Timestamp paramTimestamp, Calendar paramCalendar)
/*      */   {
/*  617 */     if (paramTimestamp == null)
/*  618 */       return null;
/*      */     Calendar localCalendar;
/*  622 */     if (paramCalendar == null) {
/*  623 */       localCalendar = Calendar.getInstance();
/*      */     }
/*      */     else {
/*  626 */       localCalendar = Calendar.getInstance(paramCalendar.getTimeZone());
/*      */     }
/*      */ 
/*  629 */     localCalendar.clear();
/*  630 */     localCalendar.setTime(paramTimestamp);
/*      */ 
/*  632 */     byte[] arrayOfByte = new byte[7];
/*      */ 
/*  634 */     int i = TIMESTAMP.getOracleYear(localCalendar);
/*      */ 
/*  636 */     arrayOfByte[0] = ((byte)(i / 100 + 100));
/*  637 */     arrayOfByte[1] = ((byte)(i % 100 + 100));
/*  638 */     arrayOfByte[2] = ((byte)(localCalendar.get(2) + 1));
/*  639 */     arrayOfByte[3] = ((byte)localCalendar.get(5));
/*  640 */     arrayOfByte[4] = ((byte)(localCalendar.get(11) + 1));
/*  641 */     arrayOfByte[5] = ((byte)(localCalendar.get(12) + 1));
/*  642 */     arrayOfByte[6] = ((byte)(localCalendar.get(13) + 1));
/*      */ 
/*  644 */     return arrayOfByte;
/*      */   }
/*      */ 
/*      */   public static byte[] toBytes(String paramString)
/*      */   {
/*  656 */     if (paramString == null) {
/*  657 */       return null;
/*      */     }
/*      */ 
/*  660 */     byte[] arrayOfByte = toBytes(Timestamp.valueOf(paramString));
/*  661 */     return arrayOfByte;
/*      */   }
/*      */ 
/*      */   public static byte[] toBytes(String paramString, Calendar paramCalendar)
/*      */   {
/*  674 */     return toBytes(Timestamp.valueOf(paramString), paramCalendar);
/*      */   }
/*      */ 
/*      */   public java.sql.Date dateValue()
/*      */   {
/*  689 */     return toDate(getBytes());
/*      */   }
/*      */ 
/*      */   public Time timeValue()
/*      */   {
/*  699 */     return toTime(getBytes());
/*      */   }
/*      */ 
/*      */   public Timestamp timestampValue()
/*      */   {
/*  709 */     return toTimestamp(getBytes());
/*      */   }
/*      */ 
/*      */   public java.sql.Date dateValue(Calendar paramCalendar)
/*      */   {
/*  720 */     return toDate(getBytes(), paramCalendar);
/*      */   }
/*      */ 
/*      */   public Time timeValue(Calendar paramCalendar)
/*      */   {
/*  731 */     return toTime(getBytes(), paramCalendar);
/*      */   }
/*      */ 
/*      */   public Timestamp timestampValue(Calendar paramCalendar)
/*      */   {
/*  743 */     return toTimestamp(getBytes(), paramCalendar);
/*      */   }
/*      */ 
/*      */   public String stringValue()
/*      */   {
/*  753 */     return toString(getBytes());
/*      */   }
/*      */ 
/*      */   public String toString()
/*      */   {
/*  758 */     return stringValue();
/*      */   }
/*      */ 
/*      */   public Object toJdbc()
/*      */   {
/*  768 */     return timestampValue();
/*      */   }
/*      */ 
/*      */   public Object makeJdbcArray(int paramInt)
/*      */   {
/*  779 */     Timestamp[] arrayOfTimestamp = new Timestamp[paramInt];
/*      */ 
/*  781 */     return arrayOfTimestamp;
/*      */   }
/*      */ 
/*      */   public boolean isConvertibleTo(Class paramClass)
/*      */   {
/*  793 */     if ((paramClass.getName().compareTo("java.sql.Date") == 0) || (paramClass.getName().compareTo("java.sql.Time") == 0) || (paramClass.getName().compareTo("java.sql.Timestamp") == 0) || (paramClass.getName().compareTo("java.lang.String") == 0))
/*      */     {
/*  797 */       return true;
/*      */     }
/*      */ 
/*  800 */     return false;
/*      */   }
/*      */ 
/*      */   public DATE addJulianDays(int paramInt1, int paramInt2)
/*      */     throws SQLException
/*      */   {
/*  820 */     return new DATE(_getLdxLib().ldxads(shareBytes(), paramInt1, paramInt2));
/*      */   }
/*      */ 
/*      */   public DATE addMonths(int paramInt)
/*      */     throws SQLException
/*      */   {
/*  836 */     return new DATE(_getLdxLib().ldxadm(shareBytes(), paramInt));
/*      */   }
/*      */ 
/*      */   public void diffInJulianDays(DATE paramDATE, int[] paramArrayOfInt1, int[] paramArrayOfInt2)
/*      */     throws SQLException
/*      */   {
/*  851 */     _getLdxLib().ldxsub(shareBytes(), paramDATE.shareBytes(), paramArrayOfInt1, paramArrayOfInt2);
/*      */   }
/*      */ 
/*      */   public NUMBER diffInMonths(DATE paramDATE)
/*      */     throws SQLException
/*      */   {
/*  865 */     return new NUMBER(_getLdxLib().ldxsbm(shareBytes(), paramDATE.shareBytes()));
/*      */   }
/*      */ 
/*      */   public static DATE getCurrentDate()
/*      */     throws SQLException
/*      */   {
/*  878 */     return new DATE(_getLdxLib().ldxgdt());
/*      */   }
/*      */ 
/*      */   public static int checkValidity(byte[] paramArrayOfByte)
/*      */     throws SQLException
/*      */   {
/*  912 */     return _getLdxLib().ldxchk(paramArrayOfByte);
/*      */   }
/*      */ 
/*      */   public static DATE fromJulianDays(int paramInt1, int paramInt2)
/*      */     throws SQLException
/*      */   {
/*  928 */     return new DATE(_getLdxLib().ldxdfd(paramInt1, paramInt2));
/*      */   }
/*      */ 
/*      */   public static DATE fromText(String paramString1, String paramString2, String paramString3)
/*      */     throws SQLException
/*      */   {
/* 1012 */     return new DATE(_getLdxLib().ldxstd(paramString1, paramString2, paramString3));
/*      */   }
/*      */ 
/*      */   public DATE lastDayOfMonth()
/*      */     throws SQLException
/*      */   {
/* 1024 */     return new DATE(_getLdxLib().ldxldd(shareBytes()));
/*      */   }
/*      */ 
/*      */   public static void numberToJulianDays(NUMBER paramNUMBER, int[] paramArrayOfInt1, int[] paramArrayOfInt2)
/*      */     throws SQLException
/*      */   {
/* 1039 */     _getLdxLib().ldxftd(paramNUMBER.toBytes(), paramArrayOfInt1, paramArrayOfInt2);
/*      */   }
/*      */ 
/*      */   public DATE round(String paramString)
/*      */     throws SQLException
/*      */   {
/* 1052 */     return new DATE(_getLdxLib().ldxrnd(shareBytes(), paramString));
/*      */   }
/*      */ 
/*      */   public DATE setDayOfWeek(int paramInt)
/*      */     throws SQLException
/*      */   {
/* 1066 */     return new DATE(_getLdxLib().ldxnxd(shareBytes(), paramInt));
/*      */   }
/*      */ 
/*      */   public void toJulianDays(int[] paramArrayOfInt1, int[] paramArrayOfInt2)
/*      */     throws SQLException
/*      */   {
/* 1081 */     _getLdxLib().ldxdtd(shareBytes(), paramArrayOfInt1, paramArrayOfInt2);
/*      */   }
/*      */ 
/*      */   public NUMBER toNumber()
/*      */     throws SQLException
/*      */   {
/* 1093 */     return new NUMBER(_getLdxLib().ldxdyf(shareBytes()));
/*      */   }
/*      */ 
/*      */   public String toText(String paramString1, String paramString2)
/*      */     throws SQLException
/*      */   {
/* 1108 */     return _getLdxLib().ldxdts(shareBytes(), paramString1, paramString2);
/*      */   }
/*      */ 
/*      */   public String toText(byte[] paramArrayOfByte, String paramString)
/*      */     throws SQLException
/*      */   {
/* 1123 */     return _getLdxLib().ldxdts(shareBytes(), paramArrayOfByte, paramString);
/*      */   }
/*      */ 
/*      */   public static byte[] parseFormat(String paramString1, String paramString2)
/*      */     throws SQLException
/*      */   {
/* 1139 */     return (byte[])_getLdxLib().ldxsto(paramString1, paramString2);
/*      */   }
/*      */ 
/*      */   public DATE truncate(String paramString)
/*      */     throws SQLException
/*      */   {
/* 1153 */     return new DATE(_getLdxLib().ldxtrn(shareBytes(), paramString));
/*      */   }
/*      */ 
/*      */   public int compareTo(DATE paramDATE)
/*      */   {
/* 1167 */     return compareBytes(shareBytes(), paramDATE.shareBytes());
/*      */   }
/*      */ 
/*      */   private static byte[] _initDate()
/*      */   {
/* 1322 */     byte[] arrayOfByte = new byte[7];
/*      */ 
/* 1324 */     arrayOfByte[0] = 119;
/* 1325 */     arrayOfByte[1] = -86;
/* 1326 */     arrayOfByte[2] = 1;
/* 1327 */     arrayOfByte[3] = 1;
/* 1328 */     arrayOfByte[4] = 1;
/* 1329 */     arrayOfByte[5] = 1;
/* 1330 */     arrayOfByte[6] = 1;
/*      */ 
/* 1332 */     return arrayOfByte;
/*      */   }
/*      */ 
/*      */   private static LdxLib _getLdxLib()
/*      */   {
/* 1342 */     if (_sldxlib == null) {
/*      */       try
/*      */       {
/* 1345 */         if (System.getProperty("oracle.jserver.version") != null) {
/* 1346 */           _sldxlib = new LdxLibServer();
/*      */         }
/*      */         else
/* 1349 */           _sldxlib = new LdxLibThin();
/*      */       }
/*      */       catch (SecurityException localSecurityException)
/*      */       {
/* 1353 */         _sldxlib = new LdxLibThin();
/*      */       }
/*      */     }
/*      */ 
/* 1357 */     return _sldxlib;
/*      */   }
/*      */ 
/*      */   private static void _printBytes(byte[] paramArrayOfByte)
/*      */   {
/* 1369 */     System.out.println(toString(paramArrayOfByte));
/*      */   }
/*      */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.sql.DATE
 * JD-Core Version:    0.6.2
 */