/*     */ package oracle.sql;
/*     */ 
/*     */ import java.io.File;
/*     */ import java.io.FileInputStream;
/*     */ import java.io.FileNotFoundException;
/*     */ import java.io.FileOutputStream;
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.io.ObjectInputStream;
/*     */ import java.io.ObjectOutputStream;
/*     */ import java.io.PrintStream;
/*     */ import java.io.StreamCorruptedException;
/*     */ import java.net.URL;
/*     */ import java.util.zip.ZipEntry;
/*     */ import java.util.zip.ZipFile;
/*     */ import java.util.zip.ZipInputStream;
/*     */ import java.util.zip.ZipOutputStream;
/*     */ 
/*     */ public class ConverterArchive
/*     */ {
/*     */   private String m_izipName;
/*  90 */   private FileOutputStream m_ifStream = null;
/*  91 */   private ZipOutputStream m_izStream = null;
/*  92 */   private InputStream m_riStream = null;
/*  93 */   private ZipFile m_rzipFile = null;
/*     */   private static final String TEMPFILE = "gsstemp.zip";
/* 496 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   public void openArchiveforInsert(String paramString)
/*     */   {
/* 109 */     this.m_izipName = paramString;
/*     */     try
/*     */     {
/* 113 */       this.m_ifStream = new FileOutputStream(this.m_izipName);
/* 114 */       this.m_izStream = new ZipOutputStream(this.m_ifStream);
/*     */     }
/*     */     catch (FileNotFoundException localFileNotFoundException)
/*     */     {
/*     */     }
/*     */   }
/*     */ 
/*     */   public void closeArchiveforInsert()
/*     */   {
/*     */     try
/*     */     {
/* 126 */       this.m_izStream.close();
/* 127 */       this.m_ifStream.close();
/*     */     }
/*     */     catch (IOException localIOException)
/*     */     {
/*     */     }
/*     */   }
/*     */ 
/*     */   public void insertObj(Object paramObject, String paramString)
/*     */   {
/* 139 */     ZipEntry localZipEntry = null;
/* 140 */     ObjectOutputStream localObjectOutputStream = null;
/*     */ 
/* 142 */     localZipEntry = new ZipEntry(paramString);
/*     */     try
/*     */     {
/* 146 */       this.m_izStream.putNextEntry(localZipEntry);
/*     */ 
/* 148 */       localObjectOutputStream = new ObjectOutputStream(this.m_izStream);
/*     */ 
/* 150 */       localObjectOutputStream.writeObject(paramObject);
/* 151 */       localObjectOutputStream.close();
/* 152 */       this.m_izStream.closeEntry();
/*     */     }
/*     */     catch (IOException localIOException)
/*     */     {
/*     */     }
/*     */   }
/*     */ 
/*     */   public void insertSingleObj(String paramString1, Object paramObject, String paramString2)
/*     */     throws IOException
/*     */   {
/* 166 */     FileInputStream localFileInputStream = null;
/* 167 */     ZipInputStream localZipInputStream = null;
/* 168 */     FileOutputStream localFileOutputStream = null;
/* 169 */     ZipOutputStream localZipOutputStream = null;
/* 170 */     ZipEntry localZipEntry = null;
/*     */ 
/* 172 */     ObjectInputStream localObjectInputStream = null;
/* 173 */     ObjectOutputStream localObjectOutputStream = null;
/*     */ 
/* 176 */     File localFile1 = new File(paramString1);
/*     */ 
/* 179 */     if (localFile1.isFile())
/*     */     {
/*     */       try
/*     */       {
/* 187 */         localFileInputStream = new FileInputStream(paramString1);
/* 188 */         localZipInputStream = new ZipInputStream(localFileInputStream);
/*     */ 
/* 191 */         localFileOutputStream = new FileOutputStream("gsstemp.zip");
/* 192 */         localZipOutputStream = new ZipOutputStream(localFileOutputStream);
/*     */ 
/* 199 */         while ((localZipEntry = localZipInputStream.getNextEntry()) != null)
/*     */         {
/* 201 */           if (!localZipEntry.getName().equals(paramString2))
/*     */           {
/* 204 */             localZipOutputStream.putNextEntry(localZipEntry);
/*     */ 
/* 206 */             localObjectInputStream = new ObjectInputStream(localZipInputStream);
/* 207 */             localObjectOutputStream = new ObjectOutputStream(localZipOutputStream);
/* 208 */             Object localObject = localObjectInputStream.readObject();
/*     */ 
/* 210 */             localObjectOutputStream.writeObject(localObject);
/*     */           }
/*     */ 
/*     */         }
/*     */ 
/* 215 */         localZipEntry = new ZipEntry(paramString2);
/*     */ 
/* 217 */         localZipOutputStream.putNextEntry(localZipEntry);
/*     */ 
/* 219 */         localObjectOutputStream = new ObjectOutputStream(localZipOutputStream);
/*     */ 
/* 221 */         localObjectOutputStream.writeObject(paramObject);
/* 222 */         localObjectOutputStream.close();
/* 223 */         localZipInputStream.close();
/*     */       }
/*     */       catch (FileNotFoundException localFileNotFoundException1)
/*     */       {
/* 229 */         throw new IOException(localFileNotFoundException1.getMessage());
/*     */       }
/*     */       catch (StreamCorruptedException localStreamCorruptedException1)
/*     */       {
/* 233 */         throw new IOException(localStreamCorruptedException1.getMessage());
/*     */       }
/*     */       catch (IOException localIOException1)
/*     */       {
/* 237 */         throw localIOException1;
/*     */       }
/*     */       catch (ClassNotFoundException localClassNotFoundException)
/*     */       {
/* 241 */         throw new IOException(localClassNotFoundException.getMessage());
/*     */       }
/*     */ 
/* 244 */       File localFile2 = new File("gsstemp.zip");
/*     */ 
/* 246 */       localFile1.delete();
/*     */       try
/*     */       {
/* 250 */         if (!localFile2.renameTo(localFile1))
/* 251 */           throw new IOException("can't write to target file " + paramString1);
/*     */       }
/*     */       catch (SecurityException localSecurityException)
/*     */       {
/* 255 */         throw new IOException(localSecurityException.getMessage());
/*     */       }
/*     */       catch (NullPointerException localNullPointerException)
/*     */       {
/* 261 */         throw new IOException(localNullPointerException.getMessage());
/*     */       }
/*     */ 
/*     */     }
/*     */     else
/*     */     {
/*     */       try
/*     */       {
/* 274 */         localFileOutputStream = new FileOutputStream(paramString1);
/* 275 */         localZipOutputStream = new ZipOutputStream(localFileOutputStream);
/* 276 */         localZipEntry = new ZipEntry(paramString2);
/*     */ 
/* 278 */         localZipOutputStream.putNextEntry(localZipEntry);
/*     */ 
/* 280 */         localObjectOutputStream = new ObjectOutputStream(localZipOutputStream);
/*     */ 
/* 282 */         localObjectOutputStream.writeObject(paramObject);
/* 283 */         localObjectOutputStream.close();
/*     */       }
/*     */       catch (FileNotFoundException localFileNotFoundException2)
/*     */       {
/* 287 */         throw new IOException(localFileNotFoundException2.getMessage());
/*     */       }
/*     */       catch (StreamCorruptedException localStreamCorruptedException2)
/*     */       {
/* 291 */         throw new IOException(localStreamCorruptedException2.getMessage());
/*     */       }
/*     */       catch (IOException localIOException2)
/*     */       {
/* 295 */         throw localIOException2;
/*     */       }
/*     */     }
/*     */ 
/* 299 */     System.out.print(paramString2 + " has been successfully stored in ");
/* 300 */     System.out.println(paramString1);
/*     */   }
/*     */ 
/*     */   public void insertObjtoFile(String paramString1, String paramString2, Object paramObject)
/*     */     throws IOException
/*     */   {
/* 312 */     File localFile1 = new File(paramString1);
/* 313 */     File localFile2 = new File(paramString1 + paramString2);
/*     */ 
/* 318 */     if (!localFile1.isDirectory())
/*     */     {
/* 322 */       throw new IOException("directory " + paramString1 + " doesn't exist");
/*     */     }
/*     */ 
/* 325 */     if (localFile2.exists())
/*     */     {
/*     */       try
/*     */       {
/* 331 */         localFile2.delete();
/*     */       }
/*     */       catch (SecurityException localSecurityException)
/*     */       {
/* 335 */         throw new IOException("file exist,can't overwrite file.");
/*     */       }
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 341 */       FileOutputStream localFileOutputStream = new FileOutputStream(localFile2);
/* 342 */       ObjectOutputStream localObjectOutputStream = new ObjectOutputStream(localFileOutputStream);
/*     */ 
/* 344 */       localObjectOutputStream.writeObject(paramObject);
/* 345 */       localObjectOutputStream.close();
/*     */     }
/*     */     catch (FileNotFoundException localFileNotFoundException)
/*     */     {
/* 349 */       throw new IOException("file can't be created.");
/*     */     }
/*     */ 
/* 352 */     System.out.print(paramString2 + " has been successfully stored in ");
/* 353 */     System.out.println(paramString1);
/*     */   }
/*     */ 
/*     */   public void openArchiveforRead()
/*     */   {
/*     */     try
/*     */     {
/* 365 */       this.m_rzipFile = new ZipFile(this.m_izipName);
/*     */     }
/*     */     catch (IOException localIOException)
/*     */     {
/* 369 */       localIOException.printStackTrace();
/* 370 */       System.exit(0);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void closeArchiveforRead()
/*     */   {
/*     */     try
/*     */     {
/* 380 */       this.m_rzipFile.close();
/*     */     }
/*     */     catch (IOException localIOException)
/*     */     {
/* 384 */       localIOException.printStackTrace();
/* 385 */       System.exit(0);
/*     */     }
/*     */   }
/*     */ 
/*     */   public Object readObj(String paramString)
/*     */   {
/* 393 */     URL localURL = getClass().getResource(paramString);
/* 394 */     Object localObject1 = null;
/* 395 */     ObjectInputStream localObjectInputStream = null;
/* 396 */     InputStream localInputStream = null;
/*     */ 
/* 398 */     if (localURL == null) {
/* 399 */       return null;
/*     */     }
/*     */     try
/*     */     {
/* 403 */       localInputStream = localURL.openStream();
/*     */ 
/* 405 */       localObjectInputStream = new ObjectInputStream(localInputStream);
/* 406 */       localObject1 = localObjectInputStream.readObject();
/*     */ 
/* 408 */       return localObject1;
/*     */     }
/*     */     catch (IOException localIOException1)
/*     */     {
/*     */     }
/*     */     catch (ClassNotFoundException localClassNotFoundException)
/*     */     {
/*     */     }
/*     */     finally
/*     */     {
/*     */       try
/*     */       {
/* 423 */         if (localObjectInputStream != null)
/* 424 */           localObjectInputStream.close();
/* 425 */         if (localInputStream != null) {
/* 426 */           localInputStream.close();
/*     */         }
/*     */       }
/*     */       catch (IOException localIOException5)
/*     */       {
/*     */       }
/*     */     }
/* 433 */     return null;
/*     */   }
/*     */ 
/*     */   public Object readObj(String paramString1, String paramString2)
/*     */   {
/*     */     try
/*     */     {
/* 448 */       FileInputStream localFileInputStream = new FileInputStream(paramString1);
/* 449 */       ZipInputStream localZipInputStream = new ZipInputStream(localFileInputStream);
/* 450 */       ZipEntry localZipEntry = null;
/* 451 */       ObjectInputStream localObjectInputStream = null;
/* 452 */       Object localObject = null;
/*     */ 
/* 454 */       while (localZipInputStream.available() != 0)
/*     */       {
/* 456 */         localZipEntry = localZipInputStream.getNextEntry();
/*     */ 
/* 458 */         if ((localZipEntry != null) && (localZipEntry.getName().equals(paramString2)))
/*     */         {
/* 462 */           localObjectInputStream = new ObjectInputStream(localZipInputStream);
/* 463 */           localObject = localObjectInputStream.readObject();
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/* 469 */       localZipInputStream.close();
/*     */ 
/* 471 */       return localObject;
/*     */     } catch (IOException localIOException) {
/*     */     }
/*     */     catch (ClassNotFoundException localClassNotFoundException) {
/*     */     }
/* 476 */     return null;
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.sql.ConverterArchive
 * JD-Core Version:    0.6.2
 */