/*     */ package oracle.sql;
/*     */ 
/*     */ import java.sql.SQLException;
/*     */ import oracle.jdbc.driver.DatabaseError;
/*     */ import oracle.sql.converter.JdbcCharacterConverters;
/*     */ 
/*     */ class CharacterSetZHTEUC extends CharacterSetWithConverter
/*     */ {
/*     */   static final String CHAR_CONV_SUPERCLASS_NAME = "oracle.sql.converter.CharacterConverterZHTEUC";
/*     */   static final int MAX_7BIT = 127;
/*     */   static final int CHARLENGTH = 4;
/*     */   static Class m_charConvSuperclass;
/*     */   char[] m_leadingCodes;
/* 211 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   CharacterSetZHTEUC(int paramInt, JdbcCharacterConverters paramJdbcCharacterConverters)
/*     */   {
/*  85 */     super(paramInt, paramJdbcCharacterConverters);
/*     */ 
/*  88 */     this.m_leadingCodes = paramJdbcCharacterConverters.getLeadingCodes();
/*     */   }
/*     */ 
/*     */   static CharacterSetZHTEUC getInstance(int paramInt, JdbcCharacterConverters paramJdbcCharacterConverters)
/*     */   {
/*  99 */     if (paramJdbcCharacterConverters.getGroupId() == 5)
/*     */     {
/* 101 */       return new CharacterSetZHTEUC(paramInt, paramJdbcCharacterConverters);
/*     */     }
/*     */ 
/* 105 */     return null;
/*     */   }
/*     */ 
/*     */   int decode(CharacterWalker paramCharacterWalker)
/*     */     throws SQLException
/*     */   {
/* 114 */     if (paramCharacterWalker.next + 1 < paramCharacterWalker.bytes.length)
/*     */     {
/* 118 */       i = paramCharacterWalker.bytes[paramCharacterWalker.next] << 8 | paramCharacterWalker.bytes[(paramCharacterWalker.next + 1)];
/*     */ 
/* 121 */       for (int j = 0; j < this.m_leadingCodes.length; j++)
/*     */       {
/* 123 */         if (i == this.m_leadingCodes[j])
/*     */         {
/* 127 */           if (paramCharacterWalker.bytes.length - paramCharacterWalker.next < 4)
/*     */           {
/* 130 */             SQLException localSQLException2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 182, "destination too small");
/* 131 */             localSQLException2.fillInStackTrace();
/* 132 */             throw localSQLException2;
/*     */           }
/*     */ 
/* 136 */           int k = 0;
/*     */ 
/* 138 */           for (int m = 0; m < 4; m++)
/*     */           {
/* 140 */             k = k << 8 | paramCharacterWalker.bytes[(paramCharacterWalker.next++)];
/*     */           }
/*     */ 
/* 143 */           return k;
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 150 */     int i = paramCharacterWalker.bytes[paramCharacterWalker.next] & 0xFF;
/*     */ 
/* 152 */     paramCharacterWalker.next += 1;
/*     */ 
/* 154 */     if (i > 127)
/*     */     {
/* 158 */       if (paramCharacterWalker.bytes.length > paramCharacterWalker.next)
/*     */       {
/* 160 */         i = i << 8 | paramCharacterWalker.bytes[paramCharacterWalker.next];
/* 161 */         paramCharacterWalker.next += 1;
/*     */       }
/*     */       else
/*     */       {
/* 166 */         SQLException localSQLException1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 182);
/* 167 */         localSQLException1.fillInStackTrace();
/* 168 */         throw localSQLException1;
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 173 */     return i;
/*     */   }
/*     */ 
/*     */   void encode(CharacterBuffer paramCharacterBuffer, int paramInt)
/*     */     throws SQLException
/*     */   {
/* 182 */     int i = paramInt >> 16;
/*     */ 
/* 184 */     for (int j = 0; j < this.m_leadingCodes.length; j++)
/*     */     {
/* 186 */       if (i == this.m_leadingCodes[j])
/*     */       {
/* 190 */         need(paramCharacterBuffer, 4);
/*     */ 
/* 192 */         for (int k = 0; k < 4; k++)
/*     */         {
/* 194 */           paramCharacterBuffer.bytes[(paramCharacterBuffer.next++)] = ((byte)paramInt);
/* 195 */           paramInt >>= 8;
/*     */         }
/*     */ 
/* 198 */         return;
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 204 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 181, "Failed to find valid leading code");
/* 205 */     localSQLException.fillInStackTrace();
/* 206 */     throw localSQLException;
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.sql.CharacterSetZHTEUC
 * JD-Core Version:    0.6.2
 */