/*     */ package oracle.sql;
/*     */ 
/*     */ import java.sql.SQLException;
/*     */ import oracle.sql.converter.CharacterConverterFactory;
/*     */ import oracle.sql.converter.CharacterConverterFactoryJDBC;
/*     */ import oracle.sql.converter.JdbcCharacterConverters;
/*     */ 
/*     */ public abstract class CharacterSetWithConverter extends CharacterSet
/*     */ {
/*  68 */   public static CharacterConverterFactory ccFactory = new CharacterConverterFactoryJDBC();
/*     */   JdbcCharacterConverters m_converter;
/* 219 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   CharacterSetWithConverter(int paramInt, JdbcCharacterConverters paramJdbcCharacterConverters)
/*     */   {
/*  81 */     super(paramInt);
/*     */ 
/*  83 */     this.m_converter = paramJdbcCharacterConverters;
/*     */   }
/*     */ 
/*     */   static CharacterSet getInstance(int paramInt)
/*     */   {
/*  95 */     JdbcCharacterConverters localJdbcCharacterConverters = ccFactory.make(paramInt);
/*     */ 
/*  97 */     if (localJdbcCharacterConverters == null)
/*     */     {
/*  99 */       return null;
/*     */     }
/*     */ 
/* 104 */     Object localObject = null;
/*     */ 
/* 106 */     if ((localObject = CharacterSet1Byte.getInstance(paramInt, localJdbcCharacterConverters)) != null)
/*     */     {
/* 109 */       return localObject;
/*     */     }
/*     */ 
/* 114 */     if ((localObject = CharacterSetSJIS.getInstance(paramInt, localJdbcCharacterConverters)) != null)
/*     */     {
/* 117 */       return localObject;
/*     */     }
/*     */ 
/* 120 */     if ((localObject = CharacterSetShift.getInstance(paramInt, localJdbcCharacterConverters)) != null)
/*     */     {
/* 123 */       return localObject;
/*     */     }
/*     */ 
/* 126 */     if ((localObject = CharacterSet2ByteFixed.getInstance(paramInt, localJdbcCharacterConverters)) != null)
/*     */     {
/* 129 */       return localObject;
/*     */     }
/*     */ 
/* 132 */     if ((localObject = CharacterSetGB18030.getInstance(paramInt, localJdbcCharacterConverters)) != null)
/*     */     {
/* 135 */       return localObject;
/*     */     }
/*     */ 
/* 138 */     if ((localObject = CharacterSet12Byte.getInstance(paramInt, localJdbcCharacterConverters)) != null)
/*     */     {
/* 141 */       return localObject;
/*     */     }
/*     */ 
/* 144 */     if ((localObject = CharacterSetJAEUC.getInstance(paramInt, localJdbcCharacterConverters)) != null)
/*     */     {
/* 147 */       return localObject;
/*     */     }
/*     */ 
/* 150 */     if ((localObject = CharacterSetZHTEUC.getInstance(paramInt, localJdbcCharacterConverters)) != null)
/*     */     {
/* 153 */       return localObject;
/*     */     }
/*     */ 
/* 157 */     return CharacterSetLCFixed.getInstance(paramInt, localJdbcCharacterConverters);
/*     */   }
/*     */ 
/*     */   public boolean isLossyFrom(CharacterSet paramCharacterSet)
/*     */   {
/* 164 */     return paramCharacterSet.getOracleId() != getOracleId();
/*     */   }
/*     */ 
/*     */   public boolean isConvertibleFrom(CharacterSet paramCharacterSet)
/*     */   {
/* 171 */     return paramCharacterSet.getOracleId() == getOracleId();
/*     */   }
/*     */ 
/*     */   public String toStringWithReplacement(byte[] paramArrayOfByte, int paramInt1, int paramInt2)
/*     */   {
/* 178 */     return this.m_converter.toUnicodeStringWithReplacement(paramArrayOfByte, paramInt1, paramInt2);
/*     */   }
/*     */ 
/*     */   public String toString(byte[] paramArrayOfByte, int paramInt1, int paramInt2)
/*     */     throws SQLException
/*     */   {
/* 186 */     return this.m_converter.toUnicodeString(paramArrayOfByte, paramInt1, paramInt2);
/*     */   }
/*     */ 
/*     */   public byte[] convert(String paramString)
/*     */     throws SQLException
/*     */   {
/* 193 */     return this.m_converter.toOracleString(paramString);
/*     */   }
/*     */ 
/*     */   public byte[] convertWithReplacement(String paramString)
/*     */   {
/* 200 */     return this.m_converter.toOracleStringWithReplacement(paramString);
/*     */   }
/*     */ 
/*     */   public byte[] convert(CharacterSet paramCharacterSet, byte[] paramArrayOfByte, int paramInt1, int paramInt2)
/*     */     throws SQLException
/*     */   {
/* 208 */     if (paramCharacterSet.getOracleId() == getOracleId())
/*     */     {
/* 210 */       return useOrCopy(paramArrayOfByte, paramInt1, paramInt2);
/*     */     }
/*     */ 
/* 214 */     return convert(paramCharacterSet.toString(paramArrayOfByte, paramInt1, paramInt2));
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.sql.CharacterSetWithConverter
 * JD-Core Version:    0.6.2
 */