/*     */ package oracle.sql;
/*     */ 
/*     */ import java.sql.SQLException;
/*     */ 
/*     */ class CharacterSetUTFE extends CharacterSet
/*     */   implements CharacterRepConstants
/*     */ {
/*     */   static final int MAXBYTEPERCHAR = 4;
/*  48 */   static byte[][] utf8m2utfe = { { 0, 1, 2, 3, 55, 45, 46, 47, 22, 5, 21, 11, 12, 13, 14, 15 }, { 16, 17, 18, 19, 60, 61, 50, 38, 24, 25, 63, 39, 28, 29, 30, 31 }, { 64, 90, 127, 123, 91, 108, 80, 125, 77, 93, 92, 78, 107, 96, 75, 97 }, { -16, -15, -14, -13, -12, -11, -10, -9, -8, -7, 122, 94, 76, 126, 110, 111 }, { 124, -63, -62, -61, -60, -59, -58, -57, -56, -55, -47, -46, -45, -44, -43, -42 }, { -41, -40, -39, -30, -29, -28, -27, -26, -25, -24, -23, -83, -32, -67, 95, 109 }, { 121, -127, -126, -125, -124, -123, -122, -121, -120, -119, -111, -110, -109, -108, -107, -106 }, { -105, -104, -103, -94, -93, -92, -91, -90, -89, -88, -87, -64, 79, -48, -95, 7 }, { 32, 33, 34, 35, 36, 37, 6, 23, 40, 41, 42, 43, 44, 9, 10, 27 }, { 48, 49, 26, 51, 52, 53, 54, 8, 56, 57, 58, 59, 4, 20, 62, -1 }, { 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 81, 82, 83, 84, 85, 86 }, { 87, 88, 89, 98, 99, 100, 101, 102, 103, 104, 105, 106, 112, 113, 114, 115 }, { 116, 117, 118, 119, 120, -128, -118, -117, -116, -115, -114, -113, -112, -102, -101, -100 }, { -99, -98, -97, -96, -86, -85, -84, -82, -81, -80, -79, -78, -77, -76, -75, -74 }, { -73, -72, -71, -70, -69, -68, -66, -65, -54, -53, -52, -51, -50, -49, -38, -37 }, { -36, -35, -34, -33, -31, -22, -21, -20, -19, -18, -17, -6, -5, -4, -3, -2 } };
/*     */ 
/* 146 */   static byte[][] utfe2utf8m = { { 0, 1, 2, 3, -100, 9, -122, 127, -105, -115, -114, 11, 12, 13, 14, 15 }, { 16, 17, 18, 19, -99, 10, 8, -121, 24, 25, -110, -113, 28, 29, 30, 31 }, { -128, -127, -126, -125, -124, -123, 23, 27, -120, -119, -118, -117, -116, 5, 6, 7 }, { -112, -111, 22, -109, -108, -107, -106, 4, -104, -103, -102, -101, 20, 21, -98, 26 }, { 32, -96, -95, -94, -93, -92, -91, -90, -89, -88, -87, 46, 60, 40, 43, 124 }, { 38, -86, -85, -84, -83, -82, -81, -80, -79, -78, 33, 36, 42, 41, 59, 94 }, { 45, 47, -77, -76, -75, -74, -73, -72, -71, -70, -69, 44, 37, 95, 62, 63 }, { -68, -67, -66, -65, -64, -63, -62, -61, -60, 96, 58, 35, 64, 39, 61, 34 }, { -59, 97, 98, 99, 100, 101, 102, 103, 104, 105, -58, -57, -56, -55, -54, -53 }, { -52, 106, 107, 108, 109, 110, 111, 112, 113, 114, -51, -50, -49, -48, -47, -46 }, { -45, 126, 115, 116, 117, 118, 119, 120, 121, 122, -44, -43, -42, 88, -41, -40 }, { -39, -38, -37, -36, -35, -34, -33, -32, -31, -30, -29, -28, -27, 93, -26, -25 }, { 123, 65, 66, 67, 68, 69, 70, 71, 72, 73, -24, -23, -22, -21, -20, -19 }, { 13, 74, 75, 76, 77, 78, 79, 80, 81, 82, -18, -17, -16, -15, -14, -13 }, { 92, -12, 83, 84, 85, 86, 87, 88, 89, 90, -11, -10, -9, -8, -7, -6 }, { 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, -5, -4, -3, -2, -1, -97 } };
/*     */ 
/* 245 */   private static int[] m_byteLen = { 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 2, 2, 3, 4 };
/*     */ 
/* 780 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   CharacterSetUTFE(int paramInt)
/*     */   {
/* 252 */     super(paramInt);
/*     */ 
/* 255 */     this.rep = 3;
/*     */   }
/*     */ 
/*     */   public boolean isLossyFrom(CharacterSet paramCharacterSet)
/*     */   {
/* 264 */     return !paramCharacterSet.isUnicode();
/*     */   }
/*     */ 
/*     */   public boolean isConvertibleFrom(CharacterSet paramCharacterSet)
/*     */   {
/* 273 */     boolean bool = paramCharacterSet.rep <= 1024;
/*     */ 
/* 275 */     return bool;
/*     */   }
/*     */ 
/*     */   public boolean isUnicode()
/*     */   {
/* 283 */     return true;
/*     */   }
/*     */ 
/*     */   public String toString(byte[] paramArrayOfByte, int paramInt1, int paramInt2)
/*     */     throws SQLException
/*     */   {
/* 291 */     char[] arrayOfChar = new char[paramArrayOfByte.length];
/* 292 */     int i = UTFEToJavaChar(paramArrayOfByte, paramInt1, paramInt2, arrayOfChar, CharacterSet.CharacterConverterBehavior.REPORT_ERROR);
/*     */ 
/* 295 */     return new String(arrayOfChar, 0, i);
/*     */   }
/*     */ 
/*     */   public String toStringWithReplacement(byte[] paramArrayOfByte, int paramInt1, int paramInt2)
/*     */   {
/*     */     try
/*     */     {
/* 306 */       char[] arrayOfChar = new char[paramArrayOfByte.length];
/* 307 */       int i = UTFEToJavaChar(paramArrayOfByte, paramInt1, paramInt2, arrayOfChar, CharacterSet.CharacterConverterBehavior.REPLACEMENT);
/*     */ 
/* 310 */       return new String(arrayOfChar, 0, i);
/*     */     }
/*     */     catch (SQLException localSQLException)
/*     */     {
/* 316 */       throw new IllegalStateException(localSQLException.getMessage());
/*     */     }
/*     */   }
/*     */ 
/*     */   int UTFEToJavaChar(byte[] paramArrayOfByte, int paramInt1, int paramInt2, char[] paramArrayOfChar, CharacterSet.CharacterConverterBehavior paramCharacterConverterBehavior)
/*     */     throws SQLException
/*     */   {
/* 326 */     int i = paramInt1;
/* 327 */     int j = paramInt1 + paramInt2;
/* 328 */     int k = 0;
/*     */ 
/* 334 */     while (i < j)
/*     */     {
/* 336 */       int m = utfe2utf8m[high(paramArrayOfByte[i])][low(paramArrayOfByte[(i++)])];
/*     */       byte b1;
/*     */       byte b2;
/* 338 */       switch (m >>> 4 & 0xF)
/*     */       {
/*     */       case 0:
/*     */       case 1:
/*     */       case 2:
/*     */       case 3:
/*     */       case 4:
/*     */       case 5:
/*     */       case 6:
/*     */       case 7:
/* 357 */         paramArrayOfChar[(k++)] = ((char)(m & 0x7F));
/*     */ 
/* 359 */         break;
/*     */       case 8:
/*     */       case 9:
/* 365 */         paramArrayOfChar[(k++)] = ((char)(m & 0x1F));
/*     */ 
/* 367 */         break;
/*     */       case 12:
/*     */       case 13:
/* 374 */         if (i >= j)
/*     */         {
/* 376 */           paramCharacterConverterBehavior.onFailConversion();
/*     */ 
/* 378 */           i = j;
/*     */         }
/*     */         else
/*     */         {
/* 383 */           m = (byte)(m & 0x1F);
/* 384 */           b1 = utfe2utf8m[high(paramArrayOfByte[i])][low(paramArrayOfByte[(i++)])];
/*     */ 
/* 387 */           if (!is101xxxxx(b1))
/*     */           {
/* 389 */             paramCharacterConverterBehavior.onFailConversion();
/*     */ 
/* 391 */             paramArrayOfChar[(k++)] = 65533;
/*     */           }
/*     */           else
/*     */           {
/* 397 */             paramArrayOfChar[(k++)] = ((char)(m << 5 | b1 & 0x1F));
/*     */           }
/*     */         }
/* 399 */         break;
/*     */       case 14:
/* 404 */         if (i + 1 >= j)
/*     */         {
/* 406 */           paramCharacterConverterBehavior.onFailConversion();
/*     */ 
/* 408 */           i = j;
/*     */         }
/*     */         else
/*     */         {
/* 413 */           m = (byte)(m & 0xF);
/* 414 */           b1 = utfe2utf8m[high(paramArrayOfByte[i])][low(paramArrayOfByte[(i++)])];
/* 415 */           b2 = utfe2utf8m[high(paramArrayOfByte[i])][low(paramArrayOfByte[(i++)])];
/*     */ 
/* 418 */           if ((!is101xxxxx(b1)) || (!is101xxxxx(b2)))
/*     */           {
/* 420 */             paramCharacterConverterBehavior.onFailConversion();
/*     */ 
/* 422 */             paramArrayOfChar[(k++)] = 65533;
/*     */           }
/*     */           else
/*     */           {
/* 428 */             paramArrayOfChar[(k++)] = ((char)(m << 10 | (b1 & 0x1F) << 5 | b2 & 0x1F));
/*     */           }
/*     */         }
/* 431 */         break;
/*     */       case 15:
/* 436 */         if (i + 2 >= j)
/*     */         {
/* 438 */           paramCharacterConverterBehavior.onFailConversion();
/*     */ 
/* 440 */           i = j;
/*     */         }
/*     */         else
/*     */         {
/* 445 */           m = (byte)(m & 0x1);
/* 446 */           b1 = utfe2utf8m[high(paramArrayOfByte[i])][low(paramArrayOfByte[(i++)])];
/* 447 */           b2 = utfe2utf8m[high(paramArrayOfByte[i])][low(paramArrayOfByte[(i++)])];
/* 448 */           byte b3 = utfe2utf8m[high(paramArrayOfByte[i])][low(paramArrayOfByte[(i++)])];
/*     */ 
/* 451 */           if ((!is101xxxxx(b1)) || (!is101xxxxx(b2)) || (!is101xxxxx(b3)))
/*     */           {
/* 453 */             paramCharacterConverterBehavior.onFailConversion();
/*     */ 
/* 455 */             paramArrayOfChar[(k++)] = 65533;
/*     */           }
/*     */           else
/*     */           {
/* 461 */             paramArrayOfChar[(k++)] = ((char)(m << 15 | (b1 & 0x1F) << 10 | (b2 & 0x1F) << 5 | b3 & 0x1F));
/*     */           }
/*     */         }
/* 464 */         break;
/*     */       case 10:
/*     */       case 11:
/*     */       default:
/* 469 */         paramCharacterConverterBehavior.onFailConversion();
/*     */ 
/* 471 */         paramArrayOfChar[(k++)] = 65533;
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 478 */     return k;
/*     */   }
/*     */ 
/*     */   public byte[] convertWithReplacement(String paramString)
/*     */   {
/* 493 */     char[] arrayOfChar = paramString.toCharArray();
/* 494 */     byte[] arrayOfByte1 = new byte[arrayOfChar.length * 4];
/*     */ 
/* 496 */     int i = javaCharsToUTFE(arrayOfChar, 0, arrayOfChar.length, arrayOfByte1, 0);
/* 497 */     byte[] arrayOfByte2 = new byte[i];
/*     */ 
/* 499 */     System.arraycopy(arrayOfByte1, 0, arrayOfByte2, 0, i);
/*     */ 
/* 501 */     return arrayOfByte2;
/*     */   }
/*     */ 
/*     */   public byte[] convert(String paramString)
/*     */     throws SQLException
/*     */   {
/* 518 */     return convertWithReplacement(paramString);
/*     */   }
/*     */ 
/*     */   public byte[] convert(CharacterSet paramCharacterSet, byte[] paramArrayOfByte, int paramInt1, int paramInt2)
/*     */     throws SQLException
/*     */   {
/*     */     byte[] arrayOfByte;
/* 529 */     if (paramCharacterSet.rep == 3)
/*     */     {
/* 531 */       arrayOfByte = useOrCopy(paramArrayOfByte, paramInt1, paramInt2);
/*     */     }
/*     */     else
/*     */     {
/* 536 */       String str = paramCharacterSet.toString(paramArrayOfByte, paramInt1, paramInt2);
/*     */ 
/* 538 */       arrayOfByte = convert(str);
/*     */     }
/*     */ 
/* 541 */     return arrayOfByte;
/*     */   }
/*     */ 
/*     */   int javaCharsToUTFE(char[] paramArrayOfChar, int paramInt1, int paramInt2, byte[] paramArrayOfByte, int paramInt3)
/*     */   {
/* 550 */     int i = paramInt1 + paramInt2;
/*     */ 
/* 552 */     int k = 0;
/*     */ 
/* 554 */     for (int m = paramInt1; m < i; m++)
/*     */     {
/* 557 */       int n = paramArrayOfChar[m];
/*     */       int j;
/* 559 */       if (n <= 31)
/*     */       {
/* 563 */         j = n | 0x80;
/* 564 */         paramArrayOfByte[(k++)] = utf8m2utfe[high(j)][low(j)];
/*     */       }
/* 566 */       else if (n <= 127)
/*     */       {
/* 570 */         paramArrayOfByte[(k++)] = utf8m2utfe[high(n)][low(n)];
/*     */       }
/* 572 */       else if (n <= 1023)
/*     */       {
/* 576 */         j = (n & 0x3E0) >> 5 | 0xC0;
/* 577 */         paramArrayOfByte[(k++)] = utf8m2utfe[high(j)][low(j)];
/* 578 */         j = n & 0x1F | 0xA0;
/* 579 */         paramArrayOfByte[(k++)] = utf8m2utfe[high(j)][low(j)];
/*     */       }
/* 581 */       else if (n <= 16383)
/*     */       {
/* 585 */         j = (n & 0x3C00) >> 10 | 0xE0;
/* 586 */         paramArrayOfByte[(k++)] = utf8m2utfe[high(j)][low(j)];
/* 587 */         j = (n & 0x3E0) >> 5 | 0xA0;
/* 588 */         paramArrayOfByte[(k++)] = utf8m2utfe[high(j)][low(j)];
/* 589 */         j = n & 0x1F | 0xA0;
/* 590 */         paramArrayOfByte[(k++)] = utf8m2utfe[high(j)][low(j)];
/*     */       }
/*     */       else
/*     */       {
/* 596 */         j = (n & 0x8000) >> 15 | 0xF0;
/* 597 */         paramArrayOfByte[(k++)] = utf8m2utfe[high(j)][low(j)];
/* 598 */         j = (n & 0x7C00) >> 10 | 0xA0;
/* 599 */         paramArrayOfByte[(k++)] = utf8m2utfe[high(j)][low(j)];
/* 600 */         j = (n & 0x3E0) >> 5 | 0xA0;
/* 601 */         paramArrayOfByte[(k++)] = utf8m2utfe[high(j)][low(j)];
/* 602 */         j = n & 0x1F | 0xA0;
/* 603 */         paramArrayOfByte[(k++)] = utf8m2utfe[high(j)][low(j)];
/*     */       }
/*     */     }
/*     */ 
/* 607 */     return k;
/*     */   }
/*     */ 
/*     */   int decode(CharacterWalker paramCharacterWalker)
/*     */     throws SQLException
/*     */   {
/* 615 */     byte[] arrayOfByte = paramCharacterWalker.bytes;
/* 616 */     int i = paramCharacterWalker.next;
/* 617 */     int j = paramCharacterWalker.end;
/* 618 */     int k = 0;
/*     */ 
/* 620 */     if (i >= j)
/*     */     {
/* 622 */       failUTFConversion();
/*     */     }
/*     */ 
/* 625 */     int m = arrayOfByte[i];
/* 626 */     int n = getUTFByteLength((byte)m);
/*     */ 
/* 628 */     if ((n == 0) || (i + (n - 1) >= j))
/*     */     {
/* 630 */       failUTFConversion();
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 636 */       char[] arrayOfChar = new char[2];
/* 637 */       int i1 = UTFEToJavaChar(arrayOfByte, i, n, arrayOfChar, CharacterSet.CharacterConverterBehavior.REPORT_ERROR);
/*     */ 
/* 640 */       paramCharacterWalker.next += n;
/*     */ 
/* 642 */       if (i1 == 1)
/*     */       {
/* 645 */         return arrayOfChar[0];
/*     */       }
/*     */ 
/* 650 */       return arrayOfChar[0] << '\020' | arrayOfChar[1];
/*     */     }
/*     */     catch (SQLException localSQLException)
/*     */     {
/* 655 */       failUTFConversion();
/*     */ 
/* 658 */       paramCharacterWalker.next = i;
/*     */     }
/* 660 */     return k;
/*     */   }
/*     */ 
/*     */   void encode(CharacterBuffer paramCharacterBuffer, int paramInt)
/*     */     throws SQLException
/*     */   {
/* 670 */     if ((paramInt & 0xFFFF0000) != 0)
/*     */     {
/* 672 */       failUTFConversion();
/*     */     }
/*     */     else
/*     */     {
/*     */       int i;
/* 676 */       if (paramInt <= 31)
/*     */       {
/* 680 */         need(paramCharacterBuffer, 1);
/*     */ 
/* 682 */         i = paramInt | 0x80;
/* 683 */         paramCharacterBuffer.bytes[(paramCharacterBuffer.next++)] = utf8m2utfe[high(i)][low(i)];
/*     */       }
/* 685 */       else if (paramInt <= 127)
/*     */       {
/* 689 */         need(paramCharacterBuffer, 1);
/*     */ 
/* 691 */         paramCharacterBuffer.bytes[(paramCharacterBuffer.next++)] = utf8m2utfe[high(paramInt)][low(paramInt)];
/*     */       }
/* 693 */       else if (paramInt <= 1023)
/*     */       {
/* 697 */         need(paramCharacterBuffer, 2);
/*     */ 
/* 699 */         i = (paramInt & 0x3E0) >> 5 | 0xC0;
/* 700 */         paramCharacterBuffer.bytes[(paramCharacterBuffer.next++)] = utf8m2utfe[high(i)][low(i)];
/* 701 */         i = paramInt & 0x1F | 0xA0;
/* 702 */         paramCharacterBuffer.bytes[(paramCharacterBuffer.next++)] = utf8m2utfe[high(i)][low(i)];
/*     */       }
/* 704 */       else if (paramInt <= 16383)
/*     */       {
/* 708 */         need(paramCharacterBuffer, 3);
/*     */ 
/* 710 */         i = (paramInt & 0x3C00) >> 10 | 0xE0;
/* 711 */         paramCharacterBuffer.bytes[(paramCharacterBuffer.next++)] = utf8m2utfe[high(i)][low(i)];
/* 712 */         i = (paramInt & 0x3E0) >> 5 | 0xA0;
/* 713 */         paramCharacterBuffer.bytes[(paramCharacterBuffer.next++)] = utf8m2utfe[high(i)][low(i)];
/* 714 */         i = paramInt & 0x1F | 0xA0;
/* 715 */         paramCharacterBuffer.bytes[(paramCharacterBuffer.next++)] = utf8m2utfe[high(i)][low(i)];
/*     */       }
/*     */       else
/*     */       {
/* 721 */         need(paramCharacterBuffer, 4);
/*     */ 
/* 723 */         i = (paramInt & 0x8000) >> 15 | 0xF0;
/* 724 */         paramCharacterBuffer.bytes[(paramCharacterBuffer.next++)] = utf8m2utfe[high(i)][low(i)];
/* 725 */         i = (paramInt & 0x7C00) >> 10 | 0xA0;
/* 726 */         paramCharacterBuffer.bytes[(paramCharacterBuffer.next++)] = utf8m2utfe[high(i)][low(i)];
/* 727 */         i = (paramInt & 0x3E0) >> 5 | 0xA0;
/* 728 */         paramCharacterBuffer.bytes[(paramCharacterBuffer.next++)] = utf8m2utfe[high(i)][low(i)];
/* 729 */         i = paramInt & 0x1F | 0xA0;
/* 730 */         paramCharacterBuffer.bytes[(paramCharacterBuffer.next++)] = utf8m2utfe[high(i)][low(i)];
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private static int high(int paramInt)
/*     */   {
/* 740 */     return paramInt >> 4 & 0xF;
/*     */   }
/*     */ 
/*     */   private static int low(int paramInt)
/*     */   {
/* 748 */     return paramInt & 0xF;
/*     */   }
/*     */ 
/*     */   private static boolean is101xxxxx(byte paramByte)
/*     */   {
/* 756 */     return (paramByte & 0xFFFFFFE0) == -96;
/*     */   }
/*     */ 
/*     */   private static int getUTFByteLength(byte paramByte)
/*     */   {
/* 776 */     return m_byteLen[(utfe2utf8m[high(paramByte)][low(paramByte)] >>> 4 & 0xF)];
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.sql.CharacterSetUTFE
 * JD-Core Version:    0.6.2
 */