/*     */ package oracle.sql;
/*     */ 
/*     */ import java.sql.SQLException;
/*     */ 
/*     */ class CharacterSetUTF extends CharacterSet
/*     */   implements CharacterRepConstants
/*     */ {
/*  50 */   private static int[] m_byteLen = { 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 2, 2, 3, 0 };
/*     */ 
/* 459 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   CharacterSetUTF(int paramInt)
/*     */   {
/*  62 */     super(paramInt);
/*     */ 
/*  65 */     this.rep = 2;
/*     */   }
/*     */ 
/*     */   public boolean isLossyFrom(CharacterSet paramCharacterSet)
/*     */   {
/*  74 */     return !paramCharacterSet.isUnicode();
/*     */   }
/*     */ 
/*     */   public boolean isConvertibleFrom(CharacterSet paramCharacterSet)
/*     */   {
/*  83 */     boolean bool = paramCharacterSet.rep <= 1024;
/*     */ 
/*  85 */     return bool;
/*     */   }
/*     */ 
/*     */   public boolean isUnicode()
/*     */   {
/*  94 */     return true;
/*     */   }
/*     */ 
/*     */   public String toStringWithReplacement(byte[] paramArrayOfByte, int paramInt1, int paramInt2)
/*     */   {
/*     */     try
/*     */     {
/* 124 */       char[] arrayOfChar = new char[paramArrayOfByte.length];
/* 125 */       int[] arrayOfInt = new int[1];
/*     */ 
/* 127 */       arrayOfInt[0] = paramInt2;
/*     */ 
/* 129 */       int i = CharacterSet.convertUTFBytesToJavaChars(paramArrayOfByte, paramInt1, arrayOfChar, 0, arrayOfInt, true);
/*     */ 
/* 132 */       return new String(arrayOfChar, 0, i);
/*     */     }
/*     */     catch (SQLException localSQLException)
/*     */     {
/*     */     }
/*     */ 
/* 138 */     return "";
/*     */   }
/*     */ 
/*     */   public String toString(byte[] paramArrayOfByte, int paramInt1, int paramInt2)
/*     */     throws SQLException
/*     */   {
/*     */     try
/*     */     {
/* 171 */       char[] arrayOfChar = new char[paramArrayOfByte.length];
/* 172 */       int[] arrayOfInt = new int[1];
/*     */ 
/* 174 */       arrayOfInt[0] = paramInt2;
/*     */ 
/* 176 */       int i = CharacterSet.convertUTFBytesToJavaChars(paramArrayOfByte, paramInt1, arrayOfChar, 0, arrayOfInt, false);
/*     */ 
/* 179 */       return new String(arrayOfChar, 0, i);
/*     */     }
/*     */     catch (SQLException localSQLException)
/*     */     {
/* 183 */       failUTFConversion();
/*     */     }
/* 185 */     return "";
/*     */   }
/*     */ 
/*     */   public byte[] convertWithReplacement(String paramString)
/*     */   {
/* 211 */     return stringToUTF(paramString);
/*     */   }
/*     */ 
/*     */   public byte[] convert(String paramString)
/*     */     throws SQLException
/*     */   {
/* 235 */     return stringToUTF(paramString);
/*     */   }
/*     */ 
/*     */   public byte[] convert(CharacterSet paramCharacterSet, byte[] paramArrayOfByte, int paramInt1, int paramInt2)
/*     */     throws SQLException
/*     */   {
/*     */     byte[] arrayOfByte;
/* 259 */     if (paramCharacterSet.rep == 2)
/*     */     {
/* 261 */       arrayOfByte = useOrCopy(paramArrayOfByte, paramInt1, paramInt2);
/*     */     }
/*     */     else
/*     */     {
/* 266 */       String str = paramCharacterSet.toString(paramArrayOfByte, paramInt1, paramInt2);
/*     */ 
/* 268 */       arrayOfByte = stringToUTF(str);
/*     */     }
/*     */ 
/* 271 */     return arrayOfByte;
/*     */   }
/*     */ 
/*     */   int decode(CharacterWalker paramCharacterWalker)
/*     */     throws SQLException
/*     */   {
/* 297 */     byte[] arrayOfByte = paramCharacterWalker.bytes;
/* 298 */     int i = paramCharacterWalker.next;
/* 299 */     int j = paramCharacterWalker.end;
/*     */ 
/* 301 */     if (i >= j)
/*     */     {
/* 303 */       failUTFConversion();
/*     */     }
/*     */ 
/* 306 */     int k = arrayOfByte[i];
/* 307 */     int m = getUTFByteLength((byte)k);
/*     */ 
/* 309 */     if ((m == 0) || (i + (m - 1) >= j))
/*     */     {
/* 311 */       failUTFConversion();
/*     */     }
/*     */ 
/* 315 */     if ((m == 3) && (isHiSurrogate((byte)k, arrayOfByte[(i + 1)])) && (i + 5 < j))
/*     */     {
/* 318 */       m = 6;
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 324 */       char[] arrayOfChar = new char[2];
/* 325 */       int[] arrayOfInt = new int[1];
/*     */ 
/* 327 */       arrayOfInt[0] = m;
/*     */ 
/* 329 */       int n = CharacterSet.convertUTFBytesToJavaChars(arrayOfByte, i, arrayOfChar, 0, arrayOfInt, false);
/*     */ 
/* 332 */       paramCharacterWalker.next += m;
/*     */ 
/* 334 */       if (n == 1)
/*     */       {
/* 337 */         return arrayOfChar[0];
/*     */       }
/*     */ 
/* 342 */       return arrayOfChar[0] << '\020' | arrayOfChar[1];
/*     */     }
/*     */     catch (SQLException localSQLException)
/*     */     {
/* 347 */       failUTFConversion();
/*     */     }
/*     */ 
/* 350 */     return 0;
/*     */   }
/*     */ 
/*     */   void encode(CharacterBuffer paramCharacterBuffer, int paramInt)
/*     */     throws SQLException
/*     */   {
/*     */     char[] arrayOfChar;
/*     */     int i;
/* 375 */     if ((paramInt & 0xFFFF0000) != 0)
/*     */     {
/* 377 */       need(paramCharacterBuffer, 6);
/*     */ 
/* 379 */       arrayOfChar = new char[] { (char)(paramInt >>> 16), (char)paramInt };
/*     */ 
/* 383 */       i = CharacterSet.convertJavaCharsToUTFBytes(arrayOfChar, 0, paramCharacterBuffer.bytes, paramCharacterBuffer.next, 2);
/*     */     }
/*     */     else
/*     */     {
/* 388 */       need(paramCharacterBuffer, 3);
/*     */ 
/* 390 */       arrayOfChar = new char[] { (char)paramInt };
/*     */ 
/* 394 */       i = CharacterSet.convertJavaCharsToUTFBytes(arrayOfChar, 0, paramCharacterBuffer.bytes, paramCharacterBuffer.next, 1);
/*     */     }
/*     */ 
/* 398 */     paramCharacterBuffer.next += i;
/*     */   }
/*     */ 
/*     */   private static int getUTFByteLength(byte paramByte)
/*     */   {
/* 418 */     return m_byteLen[(paramByte >>> 4 & 0xF)];
/*     */   }
/*     */ 
/*     */   private static boolean isHiSurrogate(byte paramByte1, byte paramByte2)
/*     */   {
/* 425 */     return (paramByte1 == -19) && (paramByte2 >= -96);
/*     */   }
/*     */ 
/*     */   public int encodedByteLength(String paramString)
/*     */   {
/* 440 */     return CharacterSet.stringUTFLength(paramString);
/*     */   }
/*     */ 
/*     */   public int encodedByteLength(char[] paramArrayOfChar)
/*     */   {
/* 455 */     return CharacterSet.charArrayUTF8Length(paramArrayOfChar);
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.sql.CharacterSetUTF
 * JD-Core Version:    0.6.2
 */