/*     */ package oracle.sql;
/*     */ 
/*     */ import java.sql.SQLException;
/*     */ import oracle.jdbc.driver.DatabaseError;
/*     */ import oracle.sql.converter.JdbcCharacterConverters;
/*     */ 
/*     */ class CharacterSetShift extends CharacterSetWithConverter
/*     */ {
/*     */   static final String CHAR_CONV_SUPERCLASS_NAME = "oracle.sql.converter.CharacterConverterShift";
/*     */   static final short MAX_7BIT = 127;
/*     */   static final short MIN_8BIT_SB = 161;
/*     */   static final short MAX_8BIT_SB = 223;
/*     */   static final byte SHIFT_OUT = 14;
/*     */   static final byte SHIFT_IN = 15;
/*     */   static Class m_charConvSuperclass;
/* 210 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   CharacterSetShift(int paramInt, JdbcCharacterConverters paramJdbcCharacterConverters)
/*     */   {
/*  81 */     super(paramInt, paramJdbcCharacterConverters);
/*     */   }
/*     */ 
/*     */   static CharacterSetShift getInstance(int paramInt, JdbcCharacterConverters paramJdbcCharacterConverters)
/*     */   {
/*  93 */     if (paramJdbcCharacterConverters.getGroupId() == 7)
/*     */     {
/*  95 */       return new CharacterSetShift(paramInt, paramJdbcCharacterConverters);
/*     */     }
/*     */ 
/*  99 */     return null;
/*     */   }
/*     */ 
/*     */   int decode(CharacterWalker paramCharacterWalker)
/*     */     throws SQLException
/*     */   {
/* 107 */     int i = paramCharacterWalker.bytes[paramCharacterWalker.next] & 0xFF;
/*     */ 
/* 109 */     paramCharacterWalker.next += 1;
/*     */ 
/* 111 */     if ((i > 223) || ((i > 127) && (i < 161)))
/*     */     {
/* 115 */       if (paramCharacterWalker.bytes.length > paramCharacterWalker.next)
/*     */       {
/* 117 */         i = i << 8 | paramCharacterWalker.bytes[paramCharacterWalker.next];
/* 118 */         paramCharacterWalker.next += 1;
/*     */       }
/*     */       else
/*     */       {
/* 123 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 182, "destination too small");
/* 124 */         localSQLException.fillInStackTrace();
/* 125 */         throw localSQLException;
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 130 */     return i;
/*     */   }
/*     */ 
/*     */   void encode(CharacterBuffer paramCharacterBuffer, int paramInt)
/*     */     throws SQLException
/*     */   {
/* 137 */     int i = paramCharacterBuffer.next;
/* 138 */     int j = 1;
/*     */ 
/* 140 */     while (i <= 0)
/*     */     {
/* 142 */       if (paramCharacterBuffer.bytes[i] == 15)
/*     */       {
/* 144 */         j = 1;
/*     */       }
/* 149 */       else if (paramCharacterBuffer.bytes[i] == 14)
/*     */       {
/* 151 */         j = 0;
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 157 */     int k = 0;
/* 158 */     int m = 1;
/*     */ 
/* 160 */     while (paramInt >> k != 0)
/*     */     {
/* 162 */       k = (short)(k + 8);
/* 163 */       m = (short)(m + 1);
/*     */     }
/*     */ 
/* 166 */     if (m > 2)
/*     */     {
/* 169 */       SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 182, "Character invalid,too many bytes");
/* 170 */       localSQLException.fillInStackTrace();
/* 171 */       throw localSQLException;
/*     */     }
/*     */ 
/* 175 */     int n = 0;
/* 176 */     int i1 = 0;
/*     */ 
/* 178 */     if ((m == 1) && (j == 0))
/*     */     {
/* 180 */       n = 1;
/* 181 */       m = (short)(m + 1);
/*     */     }
/*     */ 
/* 184 */     if ((m == 2) && (j != 0))
/*     */     {
/* 186 */       i1 = 1;
/* 187 */       m = (short)(m + 1);
/*     */     }
/*     */ 
/* 190 */     need(paramCharacterBuffer, m);
/*     */ 
/* 192 */     if (n != 0)
/*     */     {
/* 194 */       paramCharacterBuffer.bytes[(paramCharacterBuffer.next++)] = 15;
/*     */     }
/*     */ 
/* 197 */     if (i1 != 0)
/*     */     {
/* 199 */       paramCharacterBuffer.bytes[(paramCharacterBuffer.next++)] = 14;
/*     */     }
/*     */ 
/* 202 */     while (k >= 0)
/*     */     {
/* 204 */       paramCharacterBuffer.bytes[(paramCharacterBuffer.next++)] = ((byte)(paramInt >> k & 0xFF));
/* 205 */       k = (short)(k - 8);
/*     */     }
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.sql.CharacterSetShift
 * JD-Core Version:    0.6.2
 */