/*     */ package oracle.sql;
/*     */ 
/*     */ import java.sql.SQLException;
/*     */ import oracle.jdbc.driver.DatabaseError;
/*     */ import oracle.sql.converter.JdbcCharacterConverters;
/*     */ 
/*     */ class CharacterSetSJIS extends CharacterSetWithConverter
/*     */ {
/*     */   static final String CHAR_CONV_SUPERCLASS_NAME = "oracle.sql.converter.CharacterConverterSJIS";
/*     */   static final short MAX_7BIT = 127;
/*     */   static final short MIN_8BIT_SB = 161;
/*     */   static final short MAX_8BIT_SB = 223;
/*     */   static Class m_charConvSuperclass;
/* 160 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   CharacterSetSJIS(int paramInt, JdbcCharacterConverters paramJdbcCharacterConverters)
/*     */   {
/*  82 */     super(paramInt, paramJdbcCharacterConverters);
/*     */   }
/*     */ 
/*     */   static CharacterSetSJIS getInstance(int paramInt, JdbcCharacterConverters paramJdbcCharacterConverters)
/*     */   {
/*  94 */     if (paramJdbcCharacterConverters.getGroupId() == 4)
/*     */     {
/*  96 */       return new CharacterSetSJIS(paramInt, paramJdbcCharacterConverters);
/*     */     }
/*     */ 
/* 100 */     return null;
/*     */   }
/*     */ 
/*     */   int decode(CharacterWalker paramCharacterWalker)
/*     */     throws SQLException
/*     */   {
/* 108 */     int i = paramCharacterWalker.bytes[paramCharacterWalker.next] & 0xFF;
/*     */ 
/* 110 */     paramCharacterWalker.next += 1;
/*     */ 
/* 112 */     if ((i > 223) || ((i > 127) && (i < 161)))
/*     */     {
/* 116 */       if (paramCharacterWalker.bytes.length > paramCharacterWalker.next)
/*     */       {
/* 118 */         i = i << 8 | paramCharacterWalker.bytes[paramCharacterWalker.next];
/* 119 */         paramCharacterWalker.next += 1;
/*     */       }
/*     */       else
/*     */       {
/* 124 */         SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 182, "destination too small");
/* 125 */         localSQLException.fillInStackTrace();
/* 126 */         throw localSQLException;
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 131 */     return i;
/*     */   }
/*     */ 
/*     */   void encode(CharacterBuffer paramCharacterBuffer, int paramInt)
/*     */     throws SQLException
/*     */   {
/* 138 */     int i = 0;
/* 139 */     int j = 1;
/*     */ 
/* 141 */     while (paramInt >> i != 0)
/*     */     {
/* 143 */       i = (short)(i + 8);
/* 144 */       j = (short)(j + 1);
/*     */     }
/*     */ 
/* 150 */     need(paramCharacterBuffer, j);
/*     */ 
/* 152 */     while (i >= 0)
/*     */     {
/* 154 */       paramCharacterBuffer.bytes[(paramCharacterBuffer.next++)] = ((byte)(paramInt >> i & 0xFF));
/* 155 */       i = (short)(i - 8);
/*     */     }
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.sql.CharacterSetSJIS
 * JD-Core Version:    0.6.2
 */