/*     */ package oracle.sql;
/*     */ 
/*     */ import java.sql.SQLException;
/*     */ import oracle.jdbc.driver.DatabaseError;
/*     */ import oracle.sql.converter.JdbcCharacterConverters;
/*     */ 
/*     */ class CharacterSetLCFixed extends CharacterSetWithConverter
/*     */ {
/*     */   static final String CHAR_CONV_SUPERCLASS_NAME = "oracle.sql.converter.CharacterConverterLCFixed";
/*     */   static final int CHARLENGTH = 4;
/*     */   static Class m_charConvSuperclass;
/*     */   char[] m_leadingCodes;
/* 185 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   CharacterSetLCFixed(int paramInt, JdbcCharacterConverters paramJdbcCharacterConverters)
/*     */   {
/*  85 */     super(paramInt, paramJdbcCharacterConverters);
/*     */ 
/*  88 */     this.m_leadingCodes = paramJdbcCharacterConverters.getLeadingCodes();
/*     */   }
/*     */ 
/*     */   static CharacterSetLCFixed getInstance(int paramInt, JdbcCharacterConverters paramJdbcCharacterConverters)
/*     */   {
/*  99 */     if (paramJdbcCharacterConverters.getGroupId() == 3)
/*     */     {
/* 101 */       return new CharacterSetLCFixed(paramInt, paramJdbcCharacterConverters);
/*     */     }
/*     */ 
/* 105 */     return null;
/*     */   }
/*     */ 
/*     */   int decode(CharacterWalker paramCharacterWalker)
/*     */     throws SQLException
/*     */   {
/* 113 */     if (paramCharacterWalker.bytes.length - paramCharacterWalker.next < 4)
/*     */     {
/* 116 */       SQLException localSQLException1 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 182, "destination too small");
/* 117 */       localSQLException1.fillInStackTrace();
/* 118 */       throw localSQLException1;
/*     */     }
/*     */ 
/* 123 */     int i = paramCharacterWalker.bytes[paramCharacterWalker.next] << 8 | paramCharacterWalker.bytes[(paramCharacterWalker.next + 1)];
/*     */ 
/* 126 */     for (int j = 0; j < this.m_leadingCodes.length; j++)
/*     */     {
/* 128 */       if (i == this.m_leadingCodes[j])
/*     */       {
/* 132 */         int k = 0;
/*     */ 
/* 134 */         for (int m = 0; m < 4; m++)
/*     */         {
/* 136 */           k = k << 8 | paramCharacterWalker.bytes[(paramCharacterWalker.next++)];
/*     */         }
/*     */ 
/* 139 */         return k;
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 145 */     SQLException localSQLException2 = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 181, "Leading code invalid");
/* 146 */     localSQLException2.fillInStackTrace();
/* 147 */     throw localSQLException2;
/*     */   }
/*     */ 
/*     */   void encode(CharacterBuffer paramCharacterBuffer, int paramInt)
/*     */     throws SQLException
/*     */   {
/* 157 */     int i = paramInt >> 16;
/*     */ 
/* 159 */     for (int j = 0; j < this.m_leadingCodes.length; j++)
/*     */     {
/* 161 */       if (i == this.m_leadingCodes[j])
/*     */       {
/* 165 */         need(paramCharacterBuffer, 4);
/*     */ 
/* 167 */         for (int k = 3; k >= 0; k--)
/*     */         {
/* 169 */           paramCharacterBuffer.bytes[(paramCharacterBuffer.next++)] = ((byte)(paramInt >> 8 * k & 0xFF));
/*     */         }
/*     */ 
/* 172 */         return;
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 178 */     SQLException localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 181, "Leading code invalid");
/* 179 */     localSQLException.fillInStackTrace();
/* 180 */     throw localSQLException;
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.sql.CharacterSetLCFixed
 * JD-Core Version:    0.6.2
 */