/*     */ package oracle.sql;
/*     */ 
/*     */ import java.sql.SQLException;
/*     */ import oracle.sql.converter.JdbcCharacterConverters;
/*     */ 
/*     */ class CharacterSetJAEUC extends CharacterSetWithConverter
/*     */ {
/*     */   static final String CHAR_CONV_SUPERCLASS_NAME = "oracle.sql.converter.CharacterConverterJAEUC";
/*     */   static final transient short MAX_7BIT = 127;
/*     */   static final transient short LEADINGCODE = 143;
/*     */   static Class m_charConvSuperclass;
/* 166 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   CharacterSetJAEUC(int paramInt, JdbcCharacterConverters paramJdbcCharacterConverters)
/*     */   {
/*  80 */     super(paramInt, paramJdbcCharacterConverters);
/*     */   }
/*     */ 
/*     */   static CharacterSetJAEUC getInstance(int paramInt, JdbcCharacterConverters paramJdbcCharacterConverters)
/*     */   {
/*  92 */     if (paramJdbcCharacterConverters.getGroupId() == 2)
/*     */     {
/*  94 */       return new CharacterSetJAEUC(paramInt, paramJdbcCharacterConverters);
/*     */     }
/*     */ 
/*  98 */     return null;
/*     */   }
/*     */ 
/*     */   int decode(CharacterWalker paramCharacterWalker)
/*     */     throws SQLException
/*     */   {
/* 106 */     int i = paramCharacterWalker.bytes[paramCharacterWalker.next] & 0xFF;
/*     */ 
/* 108 */     paramCharacterWalker.next += 1;
/*     */ 
/* 110 */     if (i > 127)
/*     */     {
/* 112 */       if (i != 143)
/*     */       {
/* 116 */         if (paramCharacterWalker.bytes.length > paramCharacterWalker.next)
/*     */         {
/* 118 */           i = i << 8 | paramCharacterWalker.bytes[paramCharacterWalker.next];
/* 119 */           paramCharacterWalker.next += 1;
/*     */         }
/*     */ 
/*     */       }
/*     */       else
/*     */       {
/* 126 */         for (int j = 0; j < 2; j++)
/*     */         {
/* 128 */           if (paramCharacterWalker.bytes.length > paramCharacterWalker.next)
/*     */           {
/* 130 */             i = i << 8 | paramCharacterWalker.bytes[paramCharacterWalker.next];
/* 131 */             paramCharacterWalker.next += 1;
/*     */           }
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/* 137 */     return i;
/*     */   }
/*     */ 
/*     */   void encode(CharacterBuffer paramCharacterBuffer, int paramInt)
/*     */     throws SQLException
/*     */   {
/* 144 */     int i = 0;
/* 145 */     int j = 1;
/*     */ 
/* 147 */     while (paramInt >> i != 0)
/*     */     {
/* 149 */       i = (short)(i + 8);
/* 150 */       j = (short)(j + 1);
/*     */     }
/*     */ 
/* 156 */     need(paramCharacterBuffer, j);
/*     */ 
/* 158 */     while (i >= 0)
/*     */     {
/* 160 */       paramCharacterBuffer.bytes[(paramCharacterBuffer.next++)] = ((byte)(paramInt >> i & 0xFF));
/* 161 */       i = (short)(i - 8);
/*     */     }
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.sql.CharacterSetJAEUC
 * JD-Core Version:    0.6.2
 */