/*     */ package oracle.sql;
/*     */ 
/*     */ import java.sql.SQLException;
/*     */ import oracle.jdbc.driver.DatabaseError;
/*     */ import oracle.sql.converter.JdbcCharacterConverters;
/*     */ 
/*     */ class CharacterSetGB18030 extends CharacterSetWithConverter
/*     */ {
/*     */   static final int MAX_7BIT = 127;
/*     */   static Class m_charConvSuperclass;
/* 210 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   CharacterSetGB18030(int paramInt, JdbcCharacterConverters paramJdbcCharacterConverters)
/*     */   {
/*  78 */     super(paramInt, paramJdbcCharacterConverters);
/*     */   }
/*     */ 
/*     */   static CharacterSetGB18030 getInstance(int paramInt, JdbcCharacterConverters paramJdbcCharacterConverters)
/*     */   {
/*  90 */     if (paramJdbcCharacterConverters.getGroupId() == 9)
/*     */     {
/*  92 */       return new CharacterSetGB18030(paramInt, paramJdbcCharacterConverters);
/*     */     }
/*     */ 
/*  96 */     return null;
/*     */   }
/*     */ 
/*     */   int decode(CharacterWalker paramCharacterWalker)
/*     */     throws SQLException
/*     */   {
/* 104 */     int i = paramCharacterWalker.bytes[paramCharacterWalker.next] & 0xFF;
/*     */ 
/* 106 */     if (i > 127)
/*     */     {
/*     */       SQLException localSQLException;
/* 110 */       if (paramCharacterWalker.bytes.length > paramCharacterWalker.next + 1)
/*     */       {
/* 112 */         if (((paramCharacterWalker.bytes[paramCharacterWalker.next] & 0xFF) >= 129) && ((paramCharacterWalker.bytes[paramCharacterWalker.next] & 0xFF) <= 254) && ((paramCharacterWalker.bytes[(paramCharacterWalker.next + 1)] & 0xFF) >= 48) && ((paramCharacterWalker.bytes[(paramCharacterWalker.next + 1)] & 0xFF) <= 57))
/*     */         {
/* 119 */           if (paramCharacterWalker.bytes.length > paramCharacterWalker.next + 3)
/*     */           {
/* 121 */             if (((paramCharacterWalker.bytes[(paramCharacterWalker.next + 2)] & 0xFF) >= 129) && ((paramCharacterWalker.bytes[(paramCharacterWalker.next + 2)] & 0xFF) <= 254) && ((paramCharacterWalker.bytes[(paramCharacterWalker.next + 3)] & 0xFF) >= 48) && ((paramCharacterWalker.bytes[(paramCharacterWalker.next + 3)] & 0xFF) <= 57))
/*     */             {
/* 126 */               i = (paramCharacterWalker.bytes[paramCharacterWalker.next] & 0xFF) << 24 | (paramCharacterWalker.bytes[(paramCharacterWalker.next + 1)] & 0xFF) << 16 | (paramCharacterWalker.bytes[(paramCharacterWalker.next + 2)] & 0xFF) << 8 | paramCharacterWalker.bytes[(paramCharacterWalker.next + 3)] & 0xFF;
/*     */ 
/* 130 */               paramCharacterWalker.next += 4;
/*     */             }
/*     */             else
/*     */             {
/* 136 */               i = paramCharacterWalker.bytes[paramCharacterWalker.next] & 0xFF;
/* 137 */               paramCharacterWalker.next += 1;
/*     */             }
/*     */ 
/*     */           }
/*     */           else
/*     */           {
/* 143 */             localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 182, "destination too small");
/* 144 */             localSQLException.fillInStackTrace();
/* 145 */             throw localSQLException;
/*     */           }
/*     */ 
/*     */         }
/*     */         else
/*     */         {
/* 153 */           i = (paramCharacterWalker.bytes[paramCharacterWalker.next] & 0xFF) << 8 | paramCharacterWalker.bytes[(paramCharacterWalker.next + 1)] & 0xFF;
/*     */ 
/* 155 */           paramCharacterWalker.next += 2;
/*     */         }
/*     */ 
/*     */       }
/*     */       else
/*     */       {
/* 161 */         localSQLException = DatabaseError.createSqlException(getConnectionDuringExceptionHandling(), 182, "destination too small");
/* 162 */         localSQLException.fillInStackTrace();
/* 163 */         throw localSQLException;
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 168 */     return i;
/*     */   }
/*     */ 
/*     */   void encode(CharacterBuffer paramCharacterBuffer, int paramInt)
/*     */     throws SQLException
/*     */   {
/* 175 */     int i = 0;
/* 176 */     int j = 0;
/*     */ 
/* 178 */     while (paramInt >> i != 0)
/*     */     {
/* 180 */       i = (short)(i + 8);
/* 181 */       j = (short)(j + 1);
/*     */     }
/*     */ 
/* 184 */     if (paramInt >> 16 != 0)
/*     */     {
/* 186 */       i = 3;
/* 187 */       j = 4;
/*     */     }
/* 189 */     else if (paramInt >> 8 != 0)
/*     */     {
/* 191 */       i = 1;
/* 192 */       j = 2;
/*     */     }
/*     */     else
/*     */     {
/* 196 */       i = 0;
/* 197 */       j = 1;
/*     */     }
/*     */ 
/* 200 */     need(paramCharacterBuffer, j);
/*     */ 
/* 202 */     while (i >= 0)
/*     */     {
/* 204 */       paramCharacterBuffer.bytes[(paramCharacterBuffer.next++)] = ((byte)(paramInt >> i & 0xFF));
/* 205 */       i = (short)(i - 8);
/*     */     }
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.sql.CharacterSetGB18030
 * JD-Core Version:    0.6.2
 */