/*     */ package oracle.sql;
/*     */ 
/*     */ import java.io.PrintStream;
/*     */ import java.sql.SQLException;
/*     */ 
/*     */ abstract class CharacterSetFactory
/*     */ {
/*     */   public static final short DEFAULT_CHARSET = -1;
/*     */   public static final short ASCII_CHARSET = 1;
/*     */   public static final short ISO_LATIN_1_CHARSET = 31;
/*     */   public static final short UNICODE_1_CHARSET = 870;
/*     */   public static final short UNICODE_2_CHARSET = 871;
/* 185 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   public abstract CharacterSet make(int paramInt);
/*     */ 
/*     */   public static void main(String[] paramArrayOfString)
/*     */   {
/*  78 */     CharacterSet localCharacterSet1 = CharacterSet.make(871);
/*  79 */     int[] arrayOfInt = { 1, 31, 870, 871 };
/*     */ 
/*  84 */     for (int i = 0; i < arrayOfInt.length; i++)
/*     */     {
/*  86 */       CharacterSet localCharacterSet2 = CharacterSet.make(arrayOfInt[i]);
/*     */ 
/*  89 */       String str1 = "longlonglonglong";
/*  90 */       str1 = new StringBuilder().append(str1).append(str1).append(str1).append(str1).toString();
/*  91 */       str1 = new StringBuilder().append(str1).append(str1).append(str1).append(str1).toString();
/*  92 */       str1 = new StringBuilder().append(str1).append(str1).append(str1).append(str1).toString();
/*  93 */       str1 = new StringBuilder().append(str1).append(str1).append(str1).append(str1).toString();
/*     */ 
/*  95 */       String[] arrayOfString = { "abc", "ab?c", "XYZ", str1 };
/*     */ 
/* 100 */       for (int j = 0; j < arrayOfString.length; j++)
/*     */       {
/* 102 */         String str2 = arrayOfString[j];
/* 103 */         String str3 = str2;
/*     */ 
/* 105 */         if (str2.length() > 16)
/*     */         {
/* 107 */           str3 = new StringBuilder().append(str3.substring(0, 16)).append("...").toString();
/*     */         }
/*     */ 
/* 110 */         System.out.println(new StringBuilder().append("testing ").append(localCharacterSet2).append(" against <").append(str3).append(">").toString());
/*     */ 
/* 112 */         int k = 1;
/*     */         try
/*     */         {
/* 116 */           byte[] arrayOfByte1 = localCharacterSet2.convertWithReplacement(str2);
/* 117 */           String str4 = localCharacterSet2.toStringWithReplacement(arrayOfByte1, 0, arrayOfByte1.length);
/*     */ 
/* 120 */           arrayOfByte1 = localCharacterSet2.convert(str4);
/*     */ 
/* 122 */           String str5 = localCharacterSet2.toString(arrayOfByte1, 0, arrayOfByte1.length);
/*     */ 
/* 124 */           if (!str4.equals(str5))
/*     */           {
/* 126 */             System.out.println(new StringBuilder().append("    FAILED roundTrip ").append(str5).toString());
/*     */ 
/* 128 */             k = 0;
/*     */           }
/*     */           Object localObject;
/* 131 */           if (localCharacterSet2.isLossyFrom(localCharacterSet1))
/*     */           {
/*     */             try
/*     */             {
/* 135 */               byte[] arrayOfByte2 = localCharacterSet2.convert(str2);
/* 136 */               localObject = localCharacterSet2.toString(arrayOfByte2, 0, arrayOfByte2.length);
/*     */ 
/* 138 */               if (!((String)localObject).equals(str5))
/*     */               {
/* 140 */                 System.out.println("    FAILED roundtrip, no throw");
/*     */               }
/*     */             }
/*     */             catch (SQLException localSQLException) {
/*     */             }
/*     */           }
/*     */           else {
/* 147 */             if (!str5.equals(str2))
/*     */             {
/* 149 */               System.out.println(new StringBuilder().append("    FAILED roundTrip ").append(str5).toString());
/*     */ 
/* 151 */               k = 0;
/*     */             }
/*     */ 
/* 154 */             byte[] arrayOfByte3 = localCharacterSet1.convert(str2);
/* 155 */             localObject = localCharacterSet2.convert(localCharacterSet1, arrayOfByte3, 0, arrayOfByte3.length);
/*     */ 
/* 157 */             String str6 = localCharacterSet2.toString((byte[])localObject, 0, localObject.length);
/*     */ 
/* 161 */             if (!str6.equals(str2))
/*     */             {
/* 163 */               System.out.println(new StringBuilder().append("    FAILED withoutReplacement ").append(str6).toString());
/*     */ 
/* 166 */               k = 0;
/*     */             }
/*     */           }
/*     */         }
/*     */         catch (Exception localException)
/*     */         {
/* 172 */           System.out.println(new StringBuilder().append("    FAILED with Exception ").append(localException).toString());
/*     */         }
/*     */ 
/* 175 */         if (k != 0)
/*     */         {
/* 177 */           System.out.println(new StringBuilder().append("    PASSED ").append(localCharacterSet2.isLossyFrom(localCharacterSet1) ? "LOSSY" : "").toString());
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.sql.CharacterSetFactory
 * JD-Core Version:    0.6.2
 */