/*     */ package oracle.sql;
/*     */ 
/*     */ import java.sql.SQLException;
/*     */ 
/*     */ class CharacterSetAL32UTF8 extends CharacterSet
/*     */   implements CharacterRepConstants
/*     */ {
/*  53 */   private static int[] m_byteLen = { 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 2, 2, 3, 4 };
/*     */ 
/* 445 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   CharacterSetAL32UTF8(int paramInt)
/*     */   {
/*  60 */     super(paramInt);
/*     */ 
/*  62 */     this.rep = 6;
/*     */   }
/*     */ 
/*     */   public boolean isLossyFrom(CharacterSet paramCharacterSet)
/*     */   {
/*  71 */     return !paramCharacterSet.isUnicode();
/*     */   }
/*     */ 
/*     */   public boolean isConvertibleFrom(CharacterSet paramCharacterSet)
/*     */   {
/*  80 */     boolean bool = paramCharacterSet.rep <= 1024;
/*     */ 
/*  82 */     return bool;
/*     */   }
/*     */ 
/*     */   public boolean isUnicode()
/*     */   {
/*  90 */     return true;
/*     */   }
/*     */ 
/*     */   public String toStringWithReplacement(byte[] paramArrayOfByte, int paramInt1, int paramInt2)
/*     */   {
/*     */     try
/*     */     {
/* 120 */       char[] arrayOfChar = new char[paramArrayOfByte.length];
/*     */ 
/* 126 */       int[] arrayOfInt = new int[1];
/*     */ 
/* 128 */       arrayOfInt[0] = paramInt2;
/*     */ 
/* 130 */       int i = CharacterSet.convertAL32UTF8BytesToJavaChars(paramArrayOfByte, paramInt1, arrayOfChar, 0, arrayOfInt, true);
/*     */ 
/* 133 */       return new String(arrayOfChar, 0, i);
/*     */     }
/*     */     catch (SQLException localSQLException)
/*     */     {
/*     */     }
/*     */ 
/* 139 */     return "";
/*     */   }
/*     */ 
/*     */   public String toString(byte[] paramArrayOfByte, int paramInt1, int paramInt2)
/*     */     throws SQLException
/*     */   {
/*     */     try
/*     */     {
/* 172 */       char[] arrayOfChar = new char[paramArrayOfByte.length];
/* 173 */       int[] arrayOfInt = new int[1];
/*     */ 
/* 175 */       arrayOfInt[0] = paramInt2;
/*     */ 
/* 177 */       int i = CharacterSet.convertAL32UTF8BytesToJavaChars(paramArrayOfByte, paramInt1, arrayOfChar, 0, arrayOfInt, false);
/*     */ 
/* 180 */       return new String(arrayOfChar, 0, i);
/*     */     }
/*     */     catch (SQLException localSQLException)
/*     */     {
/* 184 */       failUTFConversion();
/*     */     }
/* 186 */     return "";
/*     */   }
/*     */ 
/*     */   public byte[] convertWithReplacement(String paramString)
/*     */   {
/* 212 */     return stringToAL32UTF8(paramString);
/*     */   }
/*     */ 
/*     */   public byte[] convert(String paramString)
/*     */     throws SQLException
/*     */   {
/* 236 */     return stringToAL32UTF8(paramString);
/*     */   }
/*     */ 
/*     */   public byte[] convert(CharacterSet paramCharacterSet, byte[] paramArrayOfByte, int paramInt1, int paramInt2)
/*     */     throws SQLException
/*     */   {
/*     */     byte[] arrayOfByte;
/* 260 */     if (paramCharacterSet.rep == 6)
/*     */     {
/* 262 */       arrayOfByte = useOrCopy(paramArrayOfByte, paramInt1, paramInt2);
/*     */     }
/*     */     else
/*     */     {
/* 267 */       String str = paramCharacterSet.toString(paramArrayOfByte, paramInt1, paramInt2);
/*     */ 
/* 269 */       arrayOfByte = stringToAL32UTF8(str);
/*     */     }
/*     */ 
/* 272 */     return arrayOfByte;
/*     */   }
/*     */ 
/*     */   int decode(CharacterWalker paramCharacterWalker)
/*     */     throws SQLException
/*     */   {
/* 298 */     byte[] arrayOfByte = paramCharacterWalker.bytes;
/* 299 */     int i = paramCharacterWalker.next;
/* 300 */     int j = paramCharacterWalker.end;
/*     */ 
/* 302 */     if (i >= j)
/*     */     {
/* 304 */       failUTFConversion();
/*     */     }
/*     */ 
/* 307 */     int k = arrayOfByte[i];
/* 308 */     int m = getUTFByteLength((byte)k);
/*     */ 
/* 310 */     if ((m == 0) || (i + (m - 1) >= j))
/*     */     {
/* 312 */       failUTFConversion();
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 318 */       char[] arrayOfChar = new char[2];
/* 319 */       int[] arrayOfInt = new int[1];
/*     */ 
/* 321 */       arrayOfInt[0] = m;
/*     */ 
/* 323 */       int n = CharacterSet.convertAL32UTF8BytesToJavaChars(arrayOfByte, i, arrayOfChar, 0, arrayOfInt, false);
/*     */ 
/* 326 */       paramCharacterWalker.next += m;
/*     */ 
/* 328 */       if (n == 1)
/*     */       {
/* 331 */         return arrayOfChar[0];
/*     */       }
/*     */ 
/* 336 */       return arrayOfChar[0] << '\020' | arrayOfChar[1];
/*     */     }
/*     */     catch (SQLException localSQLException)
/*     */     {
/* 341 */       failUTFConversion();
/*     */     }
/*     */ 
/* 344 */     return 0;
/*     */   }
/*     */ 
/*     */   void encode(CharacterBuffer paramCharacterBuffer, int paramInt)
/*     */     throws SQLException
/*     */   {
/*     */     char[] arrayOfChar;
/*     */     int i;
/* 369 */     if ((paramInt & 0xFFFF0000) != 0)
/*     */     {
/* 371 */       need(paramCharacterBuffer, 4);
/*     */ 
/* 373 */       arrayOfChar = new char[] { (char)(paramInt >>> 16), (char)paramInt };
/*     */ 
/* 377 */       i = CharacterSet.convertJavaCharsToAL32UTF8Bytes(arrayOfChar, 0, paramCharacterBuffer.bytes, paramCharacterBuffer.next, 2);
/*     */     }
/*     */     else
/*     */     {
/* 382 */       need(paramCharacterBuffer, 3);
/*     */ 
/* 384 */       arrayOfChar = new char[] { (char)paramInt };
/*     */ 
/* 388 */       i = CharacterSet.convertJavaCharsToAL32UTF8Bytes(arrayOfChar, 0, paramCharacterBuffer.bytes, paramCharacterBuffer.next, 1);
/*     */     }
/*     */ 
/* 392 */     paramCharacterBuffer.next += i;
/*     */   }
/*     */ 
/*     */   private static int getUTFByteLength(byte paramByte)
/*     */   {
/* 412 */     return m_byteLen[(paramByte >>> 4 & 0xF)];
/*     */   }
/*     */ 
/*     */   public int encodedByteLength(String paramString)
/*     */   {
/* 427 */     return CharacterSet.string32UTF8Length(paramString);
/*     */   }
/*     */ 
/*     */   public int encodedByteLength(char[] paramArrayOfChar)
/*     */   {
/* 441 */     return CharacterSet.charArray32UTF8Length(paramArrayOfChar);
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.sql.CharacterSetAL32UTF8
 * JD-Core Version:    0.6.2
 */