/*     */ package oracle.sql;
/*     */ 
/*     */ import java.sql.SQLException;
/*     */ 
/*     */ class CharacterSetAL16UTF16LE extends CharacterSet
/*     */   implements CharacterRepConstants
/*     */ {
/* 212 */   private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
/*     */   public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
/*     */   public static final boolean TRACE = false;
/*     */ 
/*     */   CharacterSetAL16UTF16LE(int paramInt)
/*     */   {
/*  48 */     super(paramInt);
/*     */ 
/*  51 */     this.rep = 5;
/*     */   }
/*     */ 
/*     */   public boolean isLossyFrom(CharacterSet paramCharacterSet)
/*     */   {
/*  60 */     return !paramCharacterSet.isUnicode();
/*     */   }
/*     */ 
/*     */   public boolean isConvertibleFrom(CharacterSet paramCharacterSet)
/*     */   {
/*  69 */     boolean bool = paramCharacterSet.rep <= 1024;
/*     */ 
/*  71 */     return bool;
/*     */   }
/*     */ 
/*     */   public boolean isUnicode()
/*     */   {
/*  78 */     return true;
/*     */   }
/*     */ 
/*     */   public String toStringWithReplacement(byte[] paramArrayOfByte, int paramInt1, int paramInt2)
/*     */   {
/*     */     try
/*     */     {
/*  88 */       char[] arrayOfChar = new char[Math.min(paramArrayOfByte.length - paramInt1 >>> 1, paramInt2 >>> 1)];
/*     */ 
/*  90 */       int i = CharacterSet.convertAL16UTF16LEBytesToJavaChars(paramArrayOfByte, paramInt1, arrayOfChar, 0, paramInt2, true);
/*     */ 
/*  93 */       return new String(arrayOfChar, 0, i);
/*     */     }
/*     */     catch (SQLException localSQLException)
/*     */     {
/*     */     }
/*     */ 
/*  99 */     return "";
/*     */   }
/*     */ 
/*     */   public String toString(byte[] paramArrayOfByte, int paramInt1, int paramInt2)
/*     */     throws SQLException
/*     */   {
/*     */     try
/*     */     {
/* 114 */       char[] arrayOfChar = new char[Math.min(paramArrayOfByte.length - paramInt1 >>> 1, paramInt2 >>> 1)];
/*     */ 
/* 116 */       int i = CharacterSet.convertAL16UTF16LEBytesToJavaChars(paramArrayOfByte, paramInt1, arrayOfChar, 0, paramInt2, false);
/*     */ 
/* 119 */       return new String(arrayOfChar, 0, i);
/*     */     }
/*     */     catch (SQLException localSQLException)
/*     */     {
/* 123 */       failUTFConversion();
/*     */     }
/* 125 */     return "";
/*     */   }
/*     */ 
/*     */   public byte[] convert(String paramString)
/*     */     throws SQLException
/*     */   {
/* 133 */     return stringToAL16UTF16LEBytes(paramString);
/*     */   }
/*     */ 
/*     */   public byte[] convertWithReplacement(String paramString)
/*     */   {
/* 140 */     return stringToAL16UTF16LEBytes(paramString);
/*     */   }
/*     */ 
/*     */   public byte[] convert(CharacterSet paramCharacterSet, byte[] paramArrayOfByte, int paramInt1, int paramInt2)
/*     */     throws SQLException
/*     */   {
/*     */     byte[] arrayOfByte;
/* 150 */     if (paramCharacterSet.rep == 5)
/*     */     {
/* 152 */       arrayOfByte = useOrCopy(paramArrayOfByte, paramInt1, paramInt2);
/*     */     }
/*     */     else
/*     */     {
/* 156 */       String str = paramCharacterSet.toString(paramArrayOfByte, paramInt1, paramInt2);
/*     */ 
/* 158 */       arrayOfByte = stringToAL16UTF16LEBytes(str);
/*     */     }
/*     */ 
/* 161 */     return arrayOfByte;
/*     */   }
/*     */ 
/*     */   int decode(CharacterWalker paramCharacterWalker)
/*     */     throws SQLException
/*     */   {
/* 175 */     byte[] arrayOfByte = paramCharacterWalker.bytes;
/* 176 */     int k = paramCharacterWalker.next;
/* 177 */     int m = paramCharacterWalker.end;
/*     */ 
/* 180 */     if (k + 2 >= m)
/*     */     {
/* 182 */       failUTFConversion();
/*     */     }
/*     */ 
/* 185 */     int i = arrayOfByte[(k++)];
/* 186 */     int j = arrayOfByte[(k++)];
/* 187 */     int n = i << 8 & 0xFF00 | j;
/* 188 */     paramCharacterWalker.next = k;
/*     */ 
/* 190 */     return n;
/*     */   }
/*     */ 
/*     */   void encode(CharacterBuffer paramCharacterBuffer, int paramInt)
/*     */     throws SQLException
/*     */   {
/* 197 */     if (paramInt > 65535)
/*     */     {
/* 199 */       failUTFConversion();
/*     */     }
/*     */     else
/*     */     {
/* 203 */       need(paramCharacterBuffer, 2);
/*     */ 
/* 205 */       paramCharacterBuffer.bytes[(paramCharacterBuffer.next++)] = ((byte)(paramInt >> 8 & 0xFF));
/* 206 */       paramCharacterBuffer.bytes[(paramCharacterBuffer.next++)] = ((byte)(paramInt & 0xFF));
/*     */     }
/*     */   }
/*     */ }

/* Location:           E:\HYN\Java\trunk\ref\lib-dep\oracle-jdbc\oracle-driver-ojdbc6-12.1.0.1.jar
 * Qualified Name:     oracle.sql.CharacterSetAL16UTF16LE
 * JD-Core Version:    0.6.2
 */